/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import java.awt.Font;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.CSS;
import javax.swing.text.html.StyleSheet;

public class ScaledStyleSheet
extends StyleSheet {
    private static final long serialVersionUID = 1L;
    public static float FONT_SCALE_FACTOR;

    @Override
    public Font getFont(AttributeSet a) {
        Font font = super.getFont(a);
        float fontScaleFactor = this.getFontScaleFactor(a);
        return super.getFont(font.getFamily(), font.getStyle(), Math.round(font.getSize2D() * fontScaleFactor));
    }

    private float getFontScaleFactor(AttributeSet a) {
        Object attribute = a.getAttribute(CSS.Attribute.FONT_SIZE);
        if (attribute == null) {
            return FONT_SCALE_FACTOR;
        }
        String fontSize = attribute.toString();
        int fsLength = fontSize.length();
        if (fsLength <= 1 || Character.isDigit(fontSize.charAt(fsLength - 1)) || fontSize.endsWith("pt")) {
            return FONT_SCALE_FACTOR;
        }
        if (fontSize.endsWith("px")) {
            return 0.7692308f;
        }
        if (fontSize.endsWith("%") || fontSize.endsWith("em") || fontSize.endsWith("ex") || fontSize.endsWith("er")) {
            return this.getFontScaleFactor(a.getResolveParent());
        }
        return FONT_SCALE_FACTOR;
    }

    static {
        float factor = 1.0f;
        try {
            factor = (float)Toolkit.getDefaultToolkit().getScreenResolution() / 72.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        FONT_SCALE_FACTOR = factor;
    }
}

