/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.TimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;

public class HistogramAggregationHelper {
    protected static final Logger logger = LogManager.getLogger(HistogramAggregationHelper.class);
    protected static final String AGGREGATION = "agg";
    private Config config;
    private final TimeValue requestTimeout;

    public HistogramAggregationHelper(Config config, TimeValue requestTimeout) {
        this.config = config;
        this.requestTimeout = requestTimeout;
    }

    public Histogram checkBucketResultErrors(SearchResponse response) {
        Aggregations aggs = response.getAggregations();
        if (aggs == null) {
            logger.warn("Unexpected null aggregation.");
            throw new ValidationException(CommonMessages.MODEL_VALIDATION_FAILED_UNEXPECTEDLY, ValidationIssueType.AGGREGATION, ValidationAspect.MODEL);
        }
        Histogram aggregate = (Histogram)aggs.get(AGGREGATION);
        if (aggregate == null) {
            throw new IllegalArgumentException("Failed to find valid aggregation result");
        }
        return aggregate;
    }

    public AggregationBuilder getBucketAggregation(int intervalInMinutes, LongBounds timeStampBound) {
        return ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)AGGREGATION).field(this.config.getTimeField())).minDocCount(1L).hardBounds(timeStampBound).fixedInterval(DateHistogramInterval.minutes((int)intervalInMinutes));
    }

    public Long timeConfigToMilliSec(TimeConfiguration timeConfig) {
        return Optional.ofNullable((IntervalTimeConfiguration)timeConfig).map(t -> t.toDuration().toMillis()).orElse(0L);
    }

    public LongBounds getTimeRangeBounds(long endMillis, long intervalInMillis) {
        Long startMillis = endMillis - (long)this.getNumberOfSamples(intervalInMillis) * intervalInMillis;
        return new LongBounds(startMillis, Long.valueOf(endMillis));
    }

    public int getNumberOfSamples(long intervalInMillis) {
        return Math.max((int)(Duration.ofHours(24L).toMillis() / intervalInMillis), 512);
    }

    public double processBucketAggregationResults(Histogram histogram, long intervalInMillis, Config config) {
        List bucketsInResponse = histogram.getBuckets();
        if (bucketsInResponse.size() >= config.getShingleSize() + 32) {
            long minTimestampMillis = HistogramAggregationHelper.convertKeyToEpochMillis(((Histogram.Bucket)bucketsInResponse.get(0)).getKey());
            long maxTimestampMillis = HistogramAggregationHelper.convertKeyToEpochMillis(((Histogram.Bucket)bucketsInResponse.get(bucketsInResponse.size() - 1)).getKey());
            double totalBuckets = (maxTimestampMillis - minTimestampMillis) / intervalInMillis;
            return (double)histogram.getBuckets().size() / totalBuckets;
        }
        return 0.0;
    }

    public SearchSourceBuilder getSearchSourceBuilder(QueryBuilder query, AggregationBuilder aggregation) {
        return new SearchSourceBuilder().query(query).aggregation(aggregation).size(0).timeout(this.requestTimeout);
    }

    public static long convertKeyToEpochMillis(Object key) {
        return key instanceof ZonedDateTime ? ((ZonedDateTime)key).toInstant().toEpochMilli() : (key instanceof Double ? ((Double)key).longValue() : (key instanceof Long ? (Long)key : -1L));
    }
}

