/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.logging;

import com.azure.core.implementation.util.EnvironmentConfiguration;
import com.azure.core.util.logging.LogLevel;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public final class DefaultLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -144261058636441630L;
    private static final String WHITESPACE = " ";
    private static final String HYPHEN = " - ";
    private static final String OPEN_BRACKET = " [";
    private static final String CLOSE_BRACKET = "]";
    public static final String WARN = "WARN";
    public static final String DEBUG = "DEBUG";
    public static final String INFO = "INFO";
    public static final String ERROR = "ERROR";
    public static final String TRACE = "TRACE";
    private final String classPath;
    private final boolean isTraceEnabled;
    private final boolean isDebugEnabled;
    private final boolean isInfoEnabled;
    private final boolean isWarnEnabled;
    private final boolean isErrorEnabled;
    private final PrintStream logLocation;

    public DefaultLogger(Class<?> clazz) {
        this(clazz.getCanonicalName(), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String className) {
        this(DefaultLogger.getClassPathFromClassName(className), System.out, DefaultLogger.fromEnvironment());
    }

    public DefaultLogger(String className, PrintStream logLocation, LogLevel logLevel) {
        this.classPath = DefaultLogger.getClassPathFromClassName(className);
        int configuredLogLevel = logLevel.getLogLevel();
        this.isTraceEnabled = LogLevel.VERBOSE.getLogLevel() > configuredLogLevel;
        this.isDebugEnabled = LogLevel.VERBOSE.getLogLevel() >= configuredLogLevel;
        this.isInfoEnabled = LogLevel.INFORMATIONAL.getLogLevel() >= configuredLogLevel;
        this.isWarnEnabled = LogLevel.WARNING.getLogLevel() >= configuredLogLevel;
        this.isErrorEnabled = LogLevel.ERROR.getLogLevel() >= configuredLogLevel;
        this.logLocation = logLocation;
    }

    private static String getClassPathFromClassName(String className) {
        try {
            return Class.forName(className).getCanonicalName();
        }
        catch (ClassNotFoundException | InvalidPathException e) {
            return className;
        }
    }

    private static LogLevel fromEnvironment() {
        String level = EnvironmentConfiguration.getGlobalConfiguration().get("AZURE_LOG_LEVEL");
        return LogLevel.fromString(level);
    }

    public String getName() {
        return this.classPath;
    }

    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public void trace(String msg) {
        this.logMessageWithFormat(TRACE, msg, new Object[0]);
    }

    public void trace(String format, Object arg1) {
        this.logMessageWithFormat(TRACE, format, arg1);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(TRACE, format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.logMessageWithFormat(TRACE, format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.log(TRACE, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void debug(String msg) {
        this.logMessageWithFormat(DEBUG, msg, new Object[0]);
    }

    public void debug(String format, Object arg) {
        this.logMessageWithFormat(DEBUG, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(DEBUG, format, arg1, arg2);
    }

    public void debug(String format, Object ... args) {
        this.logMessageWithFormat(DEBUG, format, args);
    }

    public void debug(String msg, Throwable t) {
        this.log(DEBUG, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    public void info(String msg) {
        this.logMessageWithFormat(INFO, msg, new Object[0]);
    }

    public void info(String format, Object arg) {
        this.logMessageWithFormat(INFO, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... args) {
        this.logMessageWithFormat(INFO, format, args);
    }

    public void info(String msg, Throwable t) {
        this.log(INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    public void warn(String msg) {
        this.logMessageWithFormat(WARN, msg, new Object[0]);
    }

    public void warn(String format, Object arg) {
        this.logMessageWithFormat(WARN, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(WARN, format, arg1, arg2);
    }

    public void warn(String format, Object ... args) {
        this.logMessageWithFormat(WARN, format, args);
    }

    public void warn(String msg, Throwable t) {
        this.log(WARN, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    public void error(String format, Object arg) {
        this.logMessageWithFormat(ERROR, format, arg);
    }

    public void error(String msg) {
        this.logMessageWithFormat(ERROR, msg, new Object[0]);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logMessageWithFormat(ERROR, format, arg1, arg2);
    }

    public void error(String format, Object ... args) {
        this.logMessageWithFormat(ERROR, format, args);
    }

    public void error(String msg, Throwable t) {
        this.log(ERROR, msg, t);
    }

    private void logMessageWithFormat(String levelName, String format, Object ... arguments) {
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.log(levelName, tp.getMessage(), tp.getThrowable());
    }

    private void log(String levelName, String message, Throwable t) {
        String dateTime = DefaultLogger.getFormattedDate();
        String threadName = Thread.currentThread().getName();
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(dateTime).append(OPEN_BRACKET).append(threadName).append(CLOSE_BRACKET).append(OPEN_BRACKET).append(levelName).append(CLOSE_BRACKET).append(WHITESPACE).append(this.classPath).append(HYPHEN).append(message).append(System.lineSeparator());
        this.writeWithThrowable(stringBuilder, t);
    }

    private static String getFormattedDate() {
        LocalDateTime now = LocalDateTime.now();
        byte[] bytes = new byte[23];
        int year = now.getYear();
        int round = year / 1000;
        bytes[0] = (byte)(48 + round);
        year -= 1000 * round;
        round = year / 100;
        bytes[1] = (byte)(48 + round);
        year -= 100 * round;
        round = year / 10;
        bytes[2] = (byte)(48 + round);
        bytes[3] = (byte)(48 + (year - 10 * round));
        bytes[4] = 45;
        DefaultLogger.zeroPad(now.getMonthValue(), bytes, 5);
        bytes[7] = 45;
        DefaultLogger.zeroPad(now.getDayOfMonth(), bytes, 8);
        bytes[10] = 32;
        DefaultLogger.zeroPad(now.getHour(), bytes, 11);
        bytes[13] = 58;
        DefaultLogger.zeroPad(now.getMinute(), bytes, 14);
        bytes[16] = 58;
        DefaultLogger.zeroPad(now.getSecond(), bytes, 17);
        bytes[19] = 46;
        int millis = now.get(ChronoField.MILLI_OF_SECOND);
        round = millis / 100;
        bytes[20] = (byte)(48 + round);
        millis -= 100 * round;
        round = millis / 10;
        bytes[21] = (byte)(48 + round);
        bytes[22] = (byte)(48 + (millis - 10 * round));
        return new String(bytes, StandardCharsets.UTF_8);
    }

    void writeWithThrowable(StringBuilder stringBuilder, Throwable t) {
        if (t != null) {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                stringBuilder.append(sw);
            }
        }
        this.logLocation.print(stringBuilder.toString());
    }

    private static void zeroPad(int value, byte[] bytes, int index) {
        if (value < 10) {
            bytes[index++] = 48;
            bytes[index] = (byte)(48 + value);
        } else {
            int high = value / 10;
            bytes[index++] = (byte)(48 + high);
            bytes[index] = (byte)(48 + (value - 10 * high));
        }
    }
}

