/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.windows;

import com.sun.jna.Pointer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.network.proxy.NetworkProxyResolver;
import org.netbeans.core.network.proxy.NetworkProxySettings;
import org.netbeans.core.network.proxy.windows.WindowsNetworkProxyLibrary;

public class WindowsNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(WindowsNetworkProxy.class.getName());
    private static final String HTTP_PROPERTY_NAME = "http=";
    private static final String HTTPS_PROPERTY_NAME = "https=";
    private static final String SOCKS_PROPERTY_NAME = "socks=";
    private static final String SPACE = " ";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "Windows system proxy resolver started.");
        WindowsNetworkProxyLibrary.ProxyConfig.ByReference byReference = new WindowsNetworkProxyLibrary.ProxyConfig.ByReference();
        boolean bl = WindowsNetworkProxyLibrary.LIBRARY.WinHttpGetIEProxyConfigForCurrentUser(byReference);
        if (bl) {
            Pointer pointer;
            LOGGER.log(Level.FINE, "Windows system proxy resolver successfully retrieved proxy settings.");
            if (byReference.autoDetect) {
                LOGGER.log(Level.INFO, "Windows system proxy resolver: auto detect");
            }
            if ((pointer = byReference.pacFile) != null || byReference.autoDetect) {
                String string = pointer != null ? pointer.getWideString(0L) : "http://wpad/wpad.dat";
                LOGGER.log(Level.INFO, "Windows system proxy resolver: auto - PAC ({0})", string);
                return new NetworkProxySettings(string);
            }
            Pointer pointer2 = byReference.proxy;
            Pointer pointer3 = byReference.proxyBypass;
            if (pointer2 != null) {
                String[] stringArray;
                Object object;
                String string = pointer2.getWideString(0L);
                LOGGER.log(Level.INFO, "Windows system proxy resolver: manual ({0})", string);
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (string != null) {
                    string = string.toLowerCase();
                }
                if (string.contains(SEMI_COLON)) {
                    object = string.split(SEMI_COLON);
                    for (String string5 : object) {
                        if (string5.startsWith(HTTP_PROPERTY_NAME)) {
                            string2 = string5.substring(HTTP_PROPERTY_NAME.length());
                            continue;
                        }
                        if (string5.startsWith(HTTPS_PROPERTY_NAME)) {
                            string3 = string5.substring(HTTPS_PROPERTY_NAME.length());
                            continue;
                        }
                        if (!string5.startsWith(SOCKS_PROPERTY_NAME)) continue;
                        string4 = string5.substring(SOCKS_PROPERTY_NAME.length());
                    }
                } else if (string.startsWith(HTTP_PROPERTY_NAME)) {
                    string = string.substring(HTTP_PROPERTY_NAME.length());
                    string2 = string.replace(SPACE, COLON);
                } else if (string.startsWith(HTTPS_PROPERTY_NAME)) {
                    string = string.substring(HTTPS_PROPERTY_NAME.length());
                    string3 = string.replace(SPACE, COLON);
                } else if (string.startsWith(SOCKS_PROPERTY_NAME)) {
                    string = string.substring(SOCKS_PROPERTY_NAME.length());
                    string4 = string.replace(SPACE, COLON);
                } else {
                    string2 = string;
                    string3 = string;
                }
                if (pointer3 != null) {
                    object = pointer3.getWideString(0L);
                    LOGGER.log(Level.INFO, "Windows system proxy resolver: manual - no proxy hosts ({0})", object);
                    stringArray = ((String)object).split(SEMI_COLON);
                } else {
                    stringArray = new String[]{};
                }
                return new NetworkProxySettings(string2, string3, string4, stringArray);
            }
            LOGGER.log(Level.FINE, "Windows system proxy resolver: no proxy");
            return new NetworkProxySettings();
        }
        LOGGER.log(Level.SEVERE, "Windows system proxy resolver cannot retrieve proxy settings from Windows API!");
        return new NetworkProxySettings(false);
    }
}

