/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.CryptoPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import sun.security.ssl.SSLAlgorithmConstraints;

public enum ProtocolVersion {
    TLS13(772, "TLSv1.3"),
    TLS12(771, "TLSv1.2"),
    TLS11(770, "TLSv1.1"),
    TLS10(769, "TLSv1"),
    SSL30(768, "SSLv3"),
    SSL20Hello(2, "SSLv2Hello"),
    NONE(-1, "NONE");

    final int id;
    final String name;
    final byte major;
    final byte minor;
    final boolean isAvailable;
    static final int LIMIT_MAX_VALUE = 65535;
    static final int LIMIT_MIN_VALUE = 0;
    static final ProtocolVersion[] PROTOCOLS_TO_10;
    static final ProtocolVersion[] PROTOCOLS_TO_11;
    static final ProtocolVersion[] PROTOCOLS_TO_12;
    static final ProtocolVersion[] PROTOCOLS_TO_13;
    static final ProtocolVersion[] PROTOCOLS_OF_NONE;
    static final ProtocolVersion[] PROTOCOLS_OF_30;
    static final ProtocolVersion[] PROTOCOLS_OF_11;
    static final ProtocolVersion[] PROTOCOLS_OF_12;
    static final ProtocolVersion[] PROTOCOLS_OF_13;
    static final ProtocolVersion[] PROTOCOLS_10_11;
    static final ProtocolVersion[] PROTOCOLS_11_12;
    static final ProtocolVersion[] PROTOCOLS_12_13;
    static final ProtocolVersion[] PROTOCOLS_10_12;
    static final ProtocolVersion[] PROTOCOLS_TO_TLS12;
    static final ProtocolVersion[] PROTOCOLS_TO_TLS11;
    static final ProtocolVersion[] PROTOCOLS_TO_TLS10;
    static final ProtocolVersion[] PROTOCOLS_EMPTY;

    private ProtocolVersion(int n2, String string2) {
        this.id = n2;
        this.name = string2;
        this.major = (byte)(n2 >>> 8 & 0xFF);
        this.minor = (byte)(n2 & 0xFF);
        this.isAvailable = SSLAlgorithmConstraints.DEFAULT_SSL_ONLY.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), string2, null);
    }

    static ProtocolVersion valueOf(byte by, byte by2) {
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            if (protocolVersion.major != by || protocolVersion.minor != by2) continue;
            return protocolVersion;
        }
        return null;
    }

    static ProtocolVersion valueOf(int n) {
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            if (protocolVersion.id != n) continue;
            return protocolVersion;
        }
        return null;
    }

    static String nameOf(byte by, byte by2) {
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            if (protocolVersion.major != by || protocolVersion.minor != by2) continue;
            return protocolVersion.name;
        }
        return "TLS-" + by + "." + by2;
    }

    static String nameOf(int n) {
        return ProtocolVersion.nameOf((byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF));
    }

    static ProtocolVersion nameOf(String string) {
        for (ProtocolVersion protocolVersion : ProtocolVersion.values()) {
            if (!protocolVersion.name.equals(string)) continue;
            return protocolVersion;
        }
        return null;
    }

    static boolean isNegotiable(byte by, byte by2, boolean bl) {
        int n = (by & 0xFF) << 8 | by2 & 0xFF;
        return n >= ProtocolVersion.SSL30.id || bl && n == ProtocolVersion.SSL20Hello.id;
    }

    static String[] toStringArray(List<ProtocolVersion> list) {
        if (list != null && !list.isEmpty()) {
            String[] stringArray = new String[list.size()];
            int n = 0;
            for (ProtocolVersion protocolVersion : list) {
                stringArray[n++] = protocolVersion.name;
            }
            return stringArray;
        }
        return new String[0];
    }

    static String[] toStringArray(int[] nArray) {
        if (nArray != null && nArray.length != 0) {
            String[] stringArray = new String[nArray.length];
            int n = 0;
            for (int n2 : nArray) {
                stringArray[n++] = ProtocolVersion.nameOf(n2);
            }
            return stringArray;
        }
        return new String[0];
    }

    static List<ProtocolVersion> namesOf(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>(stringArray.length);
        for (String string : stringArray) {
            ProtocolVersion protocolVersion = ProtocolVersion.nameOf(string);
            if (protocolVersion == null) {
                throw new IllegalArgumentException("Unsupported protocol" + string);
            }
            arrayList.add(protocolVersion);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static boolean useTLS12PlusSpec(String string) {
        ProtocolVersion protocolVersion = ProtocolVersion.nameOf(string);
        if (protocolVersion != null && protocolVersion != NONE) {
            return protocolVersion.id >= ProtocolVersion.TLS12.id;
        }
        return false;
    }

    int compare(ProtocolVersion protocolVersion) {
        if (this == protocolVersion) {
            return 0;
        }
        if (this == NONE) {
            return -1;
        }
        if (protocolVersion == NONE) {
            return 1;
        }
        return this.id - protocolVersion.id;
    }

    boolean useTLS13PlusSpec() {
        return this.id >= ProtocolVersion.TLS13.id;
    }

    boolean useTLS12PlusSpec() {
        return this.id >= ProtocolVersion.TLS12.id;
    }

    boolean useTLS11PlusSpec() {
        return this.id >= ProtocolVersion.TLS11.id;
    }

    boolean useTLS10PlusSpec() {
        return this.id >= ProtocolVersion.TLS10.id;
    }

    static boolean useTLS10PlusSpec(int n) {
        return n >= ProtocolVersion.TLS10.id;
    }

    static boolean useTLS13PlusSpec(int n) {
        return n >= ProtocolVersion.TLS13.id;
    }

    static ProtocolVersion selectedFrom(List<ProtocolVersion> list, int n) {
        ProtocolVersion protocolVersion = NONE;
        for (ProtocolVersion protocolVersion2 : list) {
            if (protocolVersion2.id == n) {
                return protocolVersion2;
            }
            if (protocolVersion2.id >= n || protocolVersion2.id <= protocolVersion.id) continue;
            protocolVersion = protocolVersion2;
        }
        return protocolVersion;
    }

    static {
        PROTOCOLS_TO_10 = new ProtocolVersion[]{TLS10, SSL30};
        PROTOCOLS_TO_11 = new ProtocolVersion[]{TLS11, TLS10, SSL30};
        PROTOCOLS_TO_12 = new ProtocolVersion[]{TLS12, TLS11, TLS10, SSL30};
        PROTOCOLS_TO_13 = new ProtocolVersion[]{TLS13, TLS12, TLS11, TLS10, SSL30};
        PROTOCOLS_OF_NONE = new ProtocolVersion[]{NONE};
        PROTOCOLS_OF_30 = new ProtocolVersion[]{SSL30};
        PROTOCOLS_OF_11 = new ProtocolVersion[]{TLS11};
        PROTOCOLS_OF_12 = new ProtocolVersion[]{TLS12};
        PROTOCOLS_OF_13 = new ProtocolVersion[]{TLS13};
        PROTOCOLS_10_11 = new ProtocolVersion[]{TLS11, TLS10};
        PROTOCOLS_11_12 = new ProtocolVersion[]{TLS12, TLS11};
        PROTOCOLS_12_13 = new ProtocolVersion[]{TLS13, TLS12};
        PROTOCOLS_10_12 = new ProtocolVersion[]{TLS12, TLS11, TLS10};
        PROTOCOLS_TO_TLS12 = new ProtocolVersion[]{TLS12, TLS11, TLS10, SSL30};
        PROTOCOLS_TO_TLS11 = new ProtocolVersion[]{TLS11, TLS10, SSL30};
        PROTOCOLS_TO_TLS10 = new ProtocolVersion[]{TLS10, SSL30};
        PROTOCOLS_EMPTY = new ProtocolVersion[0];
    }
}

