/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProtectedConstructorNotInSuperCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "shouldAllowSuchCallNonetheless", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirProtectedConstructorNotInSuperCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirProtectedConstructorNotInSuperCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProtectedConstructorNotInSuperCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 5 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 6 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,50:1\n18#2:51\n2632#3,3:52\n104#4:55\n98#4:56\n86#4:57\n92#4:59\n39#5:58\n87#6:60\n*S KotlinDebug\n*F\n+ 1 FirProtectedConstructorNotInSuperCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirProtectedConstructorNotInSuperCallChecker\n*L\n34#1:51\n37#1:52,3\n46#1:55\n46#1:56\n46#1:57\n46#1:59\n46#1:58\n47#1:60\n*E\n"})
public final class FirProtectedConstructorNotInSuperCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirProtectedConstructorNotInSuperCallChecker INSTANCE = new FirProtectedConstructorNotInSuperCallChecker();

    private FirProtectedConstructorNotInSuperCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirResolvedNamedReference firResolvedNamedReference = FirReferenceUtilsKt.getResolved(expression2.getCalleeReference());
        if (firResolvedNamedReference == null) {
            return;
        }
        FirResolvedNamedReference reference2 = firResolvedNamedReference;
        FirConstructorSymbol firConstructorSymbol = FirReferenceUtilsKt.toResolvedConstructorSymbol$default(reference2, false, 1, null);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol symbol = firConstructorSymbol;
        FirRegularClassSymbol constructedClass = DeclarationUtilsKt.getConstructedClass(symbol, context2.getSession());
        if (!this.shouldAllowSuchCallNonetheless(symbol, context2)) {
            FirCallableSymbol $this$visibility$iv = symbol;
            boolean $i$f$getVisibility = false;
            if (Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility().normalize(), Visibilities.Protected.INSTANCE) && !FirReferenceUtilsKt.isError(reference2)) {
                boolean bl;
                block8: {
                    Iterable $this$none$iv = context2.getContainingDeclarations();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            FirDeclaration it = (FirDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getSymbol(), constructedClass)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getCalleeReference().getSource(), FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL(), (Object)symbol, (DiagnosticContext)context2, null, 16, null);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean shouldAllowSuchCallNonetheless(FirConstructorSymbol symbol, CheckerContext context) {
        v0 = context.getContainingFile();
        if (v0 == null) {
            return false;
        }
        containingFile = v0;
        $this$originalIfFakeOverride$iv = symbol;
        $i$f$originalIfFakeOverride = false;
        $this$originalIfFakeOverride$iv$iv = (FirCallableDeclaration)$this$originalIfFakeOverride$iv.getFir();
        $i$f$originalIfFakeOverride = false;
        $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
        $i$f$getOriginalForSubstitutionOverride = false;
        if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv)) ** GOTO lbl-1000
        $this$isSynthetic$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv;
        $i$f$isSynthetic = false;
        if ($this$isSynthetic$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
        // 2 sources

        {
            v1 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv);
        } else {
            v1 = v2 = null;
        }
        if (v1 == null) {
            $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            $i$f$getBaseForIntersectionOverride = false;
            v2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
        }
        if ((v3 = (FirConstructorSymbol)((FirCallableSymbol)((FirConstructorSymbol)(v2 != null ? v2.getSymbol() : null)))) == null) {
            v3 = symbol;
        }
        original = v3;
        $this$isJavaOrEnhancement$iv = original.getOrigin();
        $i$f$isJavaOrEnhancement = false;
        return ($this$isJavaOrEnhancement$iv instanceof FirDeclarationOrigin.Java != false || Intrinsics.areEqual($this$isJavaOrEnhancement$iv, FirDeclarationOrigin.Enhancement.INSTANCE) != false) != false && Intrinsics.areEqual(original.getCallableId().getPackageName(), UtilsKt.getPackageFqName(containingFile)) != false;
    }
}

