/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher.model;

import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.sql.spark.dispatcher.model.FlintIndexOptions;
import org.opensearch.sql.spark.dispatcher.model.FullyQualifiedTableName;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryActionType;
import org.opensearch.sql.spark.flint.FlintIndexType;

public class IndexQueryDetails {
    public static final String STRIP_CHARS = "`";
    private static final Set<Character> INVALID_INDEX_NAME_CHARS = Set.of(Character.valueOf(' '), Character.valueOf(','), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf('+'), Character.valueOf('/'), Character.valueOf('\\'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('>'), Character.valueOf('<'));
    private String indexName;
    private FullyQualifiedTableName fullyQualifiedTableName;
    private IndexQueryActionType indexQueryActionType;
    private FlintIndexOptions flintIndexOptions;
    private String mvName;
    private FlintIndexType indexType;

    private IndexQueryDetails() {
    }

    public static IndexQueryDetailsBuilder builder() {
        return new IndexQueryDetailsBuilder();
    }

    public String openSearchIndexName() {
        FullyQualifiedTableName fullyQualifiedTableName = this.getFullyQualifiedTableName();
        Object indexName = "";
        switch (this.getIndexType()) {
            case COVERING: {
                indexName = "flint_" + fullyQualifiedTableName.toFlintName() + "_" + StringUtils.strip((String)this.getIndexName(), (String)STRIP_CHARS) + "_" + this.getIndexType().getSuffix();
                break;
            }
            case SKIPPING: {
                indexName = "flint_" + fullyQualifiedTableName.toFlintName() + "_" + this.getIndexType().getSuffix();
                break;
            }
            case MATERIALIZED_VIEW: {
                indexName = "flint_" + new FullyQualifiedTableName(this.mvName).toFlintName();
            }
        }
        return this.percentEncode((String)indexName).toLowerCase();
    }

    private String percentEncode(String indexName) {
        StringBuilder builder = new StringBuilder(indexName.length());
        for (char ch : indexName.toCharArray()) {
            if (INVALID_INDEX_NAME_CHARS.contains(Character.valueOf(ch))) {
                builder.append(String.format("%%%02X", ch));
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    @Generated
    public FullyQualifiedTableName getFullyQualifiedTableName() {
        return this.fullyQualifiedTableName;
    }

    @Generated
    public IndexQueryActionType getIndexQueryActionType() {
        return this.indexQueryActionType;
    }

    @Generated
    public FlintIndexOptions getFlintIndexOptions() {
        return this.flintIndexOptions;
    }

    @Generated
    public String getMvName() {
        return this.mvName;
    }

    @Generated
    public FlintIndexType getIndexType() {
        return this.indexType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexQueryDetails)) {
            return false;
        }
        IndexQueryDetails other = (IndexQueryDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        FullyQualifiedTableName this$fullyQualifiedTableName = this.getFullyQualifiedTableName();
        FullyQualifiedTableName other$fullyQualifiedTableName = other.getFullyQualifiedTableName();
        if (this$fullyQualifiedTableName == null ? other$fullyQualifiedTableName != null : !((Object)this$fullyQualifiedTableName).equals(other$fullyQualifiedTableName)) {
            return false;
        }
        IndexQueryActionType this$indexQueryActionType = this.getIndexQueryActionType();
        IndexQueryActionType other$indexQueryActionType = other.getIndexQueryActionType();
        if (this$indexQueryActionType == null ? other$indexQueryActionType != null : !((Object)((Object)this$indexQueryActionType)).equals((Object)other$indexQueryActionType)) {
            return false;
        }
        FlintIndexOptions this$flintIndexOptions = this.getFlintIndexOptions();
        FlintIndexOptions other$flintIndexOptions = other.getFlintIndexOptions();
        if (this$flintIndexOptions == null ? other$flintIndexOptions != null : !this$flintIndexOptions.equals(other$flintIndexOptions)) {
            return false;
        }
        String this$mvName = this.getMvName();
        String other$mvName = other.getMvName();
        if (this$mvName == null ? other$mvName != null : !this$mvName.equals(other$mvName)) {
            return false;
        }
        FlintIndexType this$indexType = this.getIndexType();
        FlintIndexType other$indexType = other.getIndexType();
        return !(this$indexType == null ? other$indexType != null : !((Object)((Object)this$indexType)).equals((Object)other$indexType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexQueryDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        FullyQualifiedTableName $fullyQualifiedTableName = this.getFullyQualifiedTableName();
        result = result * 59 + ($fullyQualifiedTableName == null ? 43 : ((Object)$fullyQualifiedTableName).hashCode());
        IndexQueryActionType $indexQueryActionType = this.getIndexQueryActionType();
        result = result * 59 + ($indexQueryActionType == null ? 43 : ((Object)((Object)$indexQueryActionType)).hashCode());
        FlintIndexOptions $flintIndexOptions = this.getFlintIndexOptions();
        result = result * 59 + ($flintIndexOptions == null ? 43 : $flintIndexOptions.hashCode());
        String $mvName = this.getMvName();
        result = result * 59 + ($mvName == null ? 43 : $mvName.hashCode());
        FlintIndexType $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : ((Object)((Object)$indexType)).hashCode());
        return result;
    }

    public static class IndexQueryDetailsBuilder {
        private final IndexQueryDetails indexQueryDetails = new IndexQueryDetails();

        public IndexQueryDetailsBuilder indexName(String indexName) {
            this.indexQueryDetails.indexName = indexName;
            return this;
        }

        public IndexQueryDetailsBuilder fullyQualifiedTableName(FullyQualifiedTableName tableName) {
            this.indexQueryDetails.fullyQualifiedTableName = tableName;
            return this;
        }

        public IndexQueryDetailsBuilder indexQueryActionType(IndexQueryActionType indexQueryActionType) {
            this.indexQueryDetails.indexQueryActionType = indexQueryActionType;
            return this;
        }

        public IndexQueryDetailsBuilder indexOptions(FlintIndexOptions flintIndexOptions) {
            this.indexQueryDetails.flintIndexOptions = flintIndexOptions;
            return this;
        }

        public IndexQueryDetailsBuilder mvName(String mvName) {
            this.indexQueryDetails.mvName = mvName;
            return this;
        }

        public IndexQueryDetailsBuilder indexType(FlintIndexType indexType) {
            this.indexQueryDetails.indexType = indexType;
            return this;
        }

        public IndexQueryDetails build() {
            if (this.indexQueryDetails.flintIndexOptions == null) {
                this.indexQueryDetails.flintIndexOptions = new FlintIndexOptions();
            }
            return this.indexQueryDetails;
        }
    }
}

