/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.WithNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileIfHexagon;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.style.ISkinParam;

public class InstructionSwitch
extends WithNote
implements Instruction,
InstructionCollection {
    private final List<Branch> switches = new ArrayList<Branch>();
    private final ISkinParam skinParam;
    private final Instruction parent;
    private Branch current;
    private final LinkRendering topInlinkRendering;
    private LinkRendering afterEndwhile = LinkRendering.none();
    private final Display labelTest;
    private final Swimlane swimlane;

    @Override
    public boolean containsBreak() {
        for (Branch branch : this.switches) {
            if (!branch.containsBreak()) continue;
            return true;
        }
        return false;
    }

    public InstructionSwitch(Swimlane swimlane, Instruction parent, Display labelTest, LinkRendering inlinkRendering, HColor color, ISkinParam skinParam) {
        this.topInlinkRendering = Objects.requireNonNull(inlinkRendering);
        this.parent = parent;
        this.skinParam = skinParam;
        this.labelTest = labelTest;
        this.swimlane = swimlane;
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        if (this.current == null) {
            return CommandExecutionResult.error("No 'case' in this switch");
        }
        return this.current.add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        for (Branch branch : this.switches) {
            branch.updateGtile(skinParam, stringBounder);
        }
        ArrayList<Gtile> gtiles = new ArrayList<Gtile>();
        ArrayList<Branch> branches = new ArrayList<Branch>();
        for (Branch branch : this.switches) {
            gtiles.add(branch.getGtile());
            branches.add(branch);
        }
        return GtileIfHexagon.build(this.swimlane, gtiles, this.switches);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        for (Branch branch : this.switches) {
            branch.updateFtile(factory);
        }
        Ftile result = factory.createSwitch(this.swimlane, this.switches, this.afterEndwhile, this.topInlinkRendering, this.labelTest);
        result = this.eventuallyAddNote(factory, result, this.getSwimlaneIn(), VerticalAlignment.TOP);
        return result;
    }

    @Override
    public final boolean kill() {
        return this.current.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.topInlinkRendering;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<? extends Swimlane> result = new HashSet<Swimlane>();
        if (this.swimlane != null) {
            result.add(this.swimlane);
        }
        for (Branch branch : this.switches) {
            result.addAll(branch.getSwimlanes());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public Instruction getLast() {
        return this.switches.get(this.switches.size() - 1).getLast();
    }

    public boolean switchCase(Display labelCase, LinkRendering nextLinkRenderer) {
        if (this.current != null) {
            this.current.setSpecial(nextLinkRenderer);
        }
        this.current = new Branch(this.skinParam.getCurrentStyleBuilder(), this.swimlane, LinkRendering.none().withDisplay(labelCase), labelCase, null, LinkRendering.none().withDisplay(labelCase), null);
        this.switches.add(this.current);
        return true;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void endSwitch(LinkRendering nextLinkRenderer) {
        if (this.current != null) {
            this.current.setSpecial(nextLinkRenderer);
        }
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (this.current == null || this.current.isEmpty()) {
            return super.addNote(note, position, type, colors, swimlaneNote);
        }
        return this.current.addNote(note, position, type, colors, swimlaneNote);
    }
}

