/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.alerting.model.ActionRunResult;
import org.opensearch.alerting.model.MonitorRunResultKt;
import org.opensearch.alerting.model.TriggerRunResult;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.script.ScriptException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult;", "Lorg/opensearch/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "triggerName", "", "triggered", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "actionResults", "", "Lorg/opensearch/alerting/model/ActionRunResult;", "(Ljava/lang/String;ZLjava/lang/Exception;Ljava/util/Map;)V", "getActionResults", "()Ljava/util/Map;", "setActionResults", "(Ljava/util/Map;)V", "getError", "()Ljava/lang/Exception;", "setError", "(Ljava/lang/Exception;)V", "getTriggerName", "()Ljava/lang/String;", "setTriggerName", "(Ljava/lang/String;)V", "getTriggered", "()Z", "setTriggered", "(Z)V", "alertError", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "internalXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "opensearch-alerting"})
public class QueryLevelTriggerRunResult
extends TriggerRunResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String triggerName;
    private boolean triggered;
    @Nullable
    private Exception error;
    @NotNull
    private Map<String, ActionRunResult> actionResults;

    public QueryLevelTriggerRunResult(@NotNull String triggerName, boolean triggered, @Nullable Exception error, @NotNull Map<String, ActionRunResult> actionResults) {
        Intrinsics.checkNotNullParameter((Object)triggerName, (String)"triggerName");
        Intrinsics.checkNotNullParameter(actionResults, (String)"actionResults");
        super(triggerName, error);
        this.triggerName = triggerName;
        this.triggered = triggered;
        this.error = error;
        this.actionResults = actionResults;
    }

    public /* synthetic */ QueryLevelTriggerRunResult(String string, boolean bl, Exception exception, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map = new LinkedHashMap();
        }
        this(string, bl, exception, map);
    }

    @Override
    @NotNull
    public String getTriggerName() {
        return this.triggerName;
    }

    @Override
    public void setTriggerName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.triggerName = string;
    }

    public boolean getTriggered() {
        return this.triggered;
    }

    public void setTriggered(boolean bl) {
        this.triggered = bl;
    }

    @Override
    @Nullable
    public Exception getError() {
        return this.error;
    }

    @Override
    public void setError(@Nullable Exception exception) {
        this.error = exception;
    }

    @NotNull
    public Map<String, ActionRunResult> getActionResults() {
        return this.actionResults;
    }

    public void setActionResults(@NotNull Map<String, ActionRunResult> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.actionResults = map;
    }

    public QueryLevelTriggerRunResult(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Exception exception = sin.readException();
        boolean bl = sin.readBoolean();
        Map map = sin.readMap();
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, org.opensearch.alerting.model.ActionRunResult>");
        Map map2 = TypeIntrinsics.asMutableMap((Object)map);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString()");
        this(string, bl, exception, map2);
    }

    @Override
    @Nullable
    public AlertError alertError() {
        if (this.getError() != null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception);
            return new AlertError(instant, "Failed evaluating trigger:\n" + MonitorRunResultKt.userErrorMessage(exception));
        }
        for (ActionRunResult actionResult : this.getActionResults().values()) {
            if (actionResult.getError() == null) continue;
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            return new AlertError(instant, "Failed running action:\n" + MonitorRunResultKt.userErrorMessage(actionResult.getError()));
        }
        return null;
    }

    @Override
    @NotNull
    public XContentBuilder internalXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.getError() instanceof ScriptException) {
            Exception exception = this.getError();
            Intrinsics.checkNotNull((Object)exception, (String)"null cannot be cast to non-null type org.opensearch.script.ScriptException");
            this.setError(new Exception(((ScriptException)exception).toJsonString(), this.getError()));
        }
        XContentBuilder xContentBuilder = builder.field("triggered", this.getTriggered());
        Map<String, ActionRunResult> map = this.getActionResults();
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.alerting.model.ActionRunResult>");
        XContentBuilder xContentBuilder2 = xContentBuilder.field("action_results", map);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder\n            .fie\u2026String, ActionRunResult>)");
        return xContentBuilder2;
    }

    @Override
    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        out.writeBoolean(this.getTriggered());
        Map<String, ActionRunResult> map = this.getActionResults();
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, org.opensearch.alerting.model.ActionRunResult>");
        out.writeMap(map);
    }

    @JvmStatic
    @NotNull
    public static final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/alerting/model/QueryLevelTriggerRunResult$Companion;", "", "()V", "readFrom", "Lorg/opensearch/alerting/model/TriggerRunResult;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "opensearch-alerting"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TriggerRunResult readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new QueryLevelTriggerRunResult(sin);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

