/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum MemberState {
    UNSUBSCRIBED,
    JOINING,
    RECONCILING,
    ACKNOWLEDGING,
    STABLE,
    FENCED,
    PREPARE_LEAVING,
    LEAVING,
    FATAL,
    STALE;

    private List<MemberState> previousValidStates = new ArrayList<MemberState>();

    public List<MemberState> getPreviousValidStates() {
        return this.previousValidStates;
    }

    public boolean canHandleNewAssignment() {
        return RECONCILING.getPreviousValidStates().contains((Object)this);
    }

    static {
        MemberState.STABLE.previousValidStates = Arrays.asList(JOINING, ACKNOWLEDGING, RECONCILING);
        MemberState.RECONCILING.previousValidStates = Arrays.asList(STABLE, JOINING, ACKNOWLEDGING, RECONCILING);
        MemberState.ACKNOWLEDGING.previousValidStates = Arrays.asList(RECONCILING);
        MemberState.FATAL.previousValidStates = Arrays.asList(JOINING, STABLE, RECONCILING, ACKNOWLEDGING, PREPARE_LEAVING, LEAVING, UNSUBSCRIBED);
        MemberState.FENCED.previousValidStates = Arrays.asList(JOINING, STABLE, RECONCILING, ACKNOWLEDGING, PREPARE_LEAVING, LEAVING);
        MemberState.JOINING.previousValidStates = Arrays.asList(FENCED, UNSUBSCRIBED, STALE);
        MemberState.PREPARE_LEAVING.previousValidStates = Arrays.asList(JOINING, STABLE, RECONCILING, ACKNOWLEDGING, UNSUBSCRIBED, FENCED);
        MemberState.LEAVING.previousValidStates = Arrays.asList(PREPARE_LEAVING);
        MemberState.UNSUBSCRIBED.previousValidStates = Arrays.asList(PREPARE_LEAVING, LEAVING);
        MemberState.STALE.previousValidStates = Arrays.asList(JOINING, RECONCILING, ACKNOWLEDGING, STABLE);
    }
}

