/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors.telemetry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.opensearch.action.admin.indices.stats.IndexShardStats;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.collectors.ValueCalculator;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.TelemetryCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.RTFMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.performanceanalyzer.util.Utils;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public class RTFNodeStatsAllShardsMetricsCollector
extends PerformanceAnalyzerMetricsCollector
implements TelemetryCollector {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(RTFNodeStatsAllShardsMetricsCollector.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(RTFNodeStatsAllShardsMetricsCollector.class);
    private Map<ShardId, IndexShard> currentShards = new HashMap<ShardId, IndexShard>();
    private Map<ShardId, ShardStats> currentPerShardStats;
    private Map<ShardId, ShardStats> prevPerShardStats = new HashMap<ShardId, ShardStats>();
    private MetricsRegistry metricsRegistry;
    private Counter cacheQueryHitMetrics;
    private Counter cacheQueryMissMetrics;
    private Counter cacheQuerySizeMetrics;
    private Counter cacheFieldDataEvictionMetrics;
    private Counter cacheFieldDataSizeMetrics;
    private Counter cacheRequestHitMetrics;
    private Counter cacheRequestMissMetrics;
    private Counter cacheRequestEvictionMetrics;
    private Counter cacheRequestSizeMetrics;
    private boolean metricsInitialised = false;
    private PerformanceAnalyzerController performanceAnalyzerController;
    private ConfigOverridesWrapper configOverridesWrapper;
    private static final ImmutableMap<String, ValueCalculator> valueCalculators = ImmutableMap.of((Object)RTFMetrics.ShardStatsValue.INDEXING_THROTTLE_TIME.toString(), shardStats -> shardStats.getStats().getIndexing().getTotal().getThrottleTime().millis(), (Object)RTFMetrics.ShardStatsValue.CACHE_QUERY_HIT.toString(), shardStats -> shardStats.getStats().getQueryCache().getHitCount(), (Object)RTFMetrics.ShardStatsValue.CACHE_QUERY_MISS.toString(), shardStats -> shardStats.getStats().getQueryCache().getMissCount(), (Object)RTFMetrics.ShardStatsValue.CACHE_QUERY_SIZE.toString(), shardStats -> shardStats.getStats().getQueryCache().getMemorySizeInBytes(), (Object)RTFMetrics.ShardStatsValue.CACHE_FIELDDATA_EVICTION.toString(), shardStats -> shardStats.getStats().getFieldData().getEvictions(), (Object)RTFMetrics.ShardStatsValue.CACHE_FIELDDATA_SIZE.toString(), shardStats -> shardStats.getStats().getFieldData().getMemorySizeInBytes(), (Object)RTFMetrics.ShardStatsValue.CACHE_REQUEST_HIT.toString(), shardStats -> shardStats.getStats().getRequestCache().getHitCount(), (Object)RTFMetrics.ShardStatsValue.CACHE_REQUEST_MISS.toString(), shardStats -> shardStats.getStats().getRequestCache().getMissCount(), (Object)RTFMetrics.ShardStatsValue.CACHE_REQUEST_EVICTION.toString(), shardStats -> shardStats.getStats().getRequestCache().getEvictions(), (Object)RTFMetrics.ShardStatsValue.CACHE_REQUEST_SIZE.toString(), shardStats -> shardStats.getStats().getRequestCache().getMemorySizeInBytes());

    public RTFNodeStatsAllShardsMetricsCollector(PerformanceAnalyzerController performanceAnalyzerController, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "RTFNodeStatsMetricsCollector", (MeasurementSet)StatMetrics.RTF_NODE_STATS_ALL_SHARDS_METRICS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.RTF_NODESTATS_COLLECTION_ERROR);
        this.currentPerShardStats = new HashMap<ShardId, ShardStats>();
        this.performanceAnalyzerController = performanceAnalyzerController;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    private void populateCurrentShards() {
        if (!this.currentShards.isEmpty()) {
            this.prevPerShardStats.putAll(this.currentPerShardStats);
            this.currentPerShardStats.clear();
        }
        this.currentShards.clear();
        this.currentShards = Utils.getShards();
    }

    public void collectMetrics(long startTime) {
        if (this.performanceAnalyzerController.isCollectorDisabled(this.configOverridesWrapper, this.getCollectorName())) {
            LOG.info("RTFDisksCollector is disabled. Skipping collection.");
            return;
        }
        IndicesService indicesService = OpenSearchResources.INSTANCE.getIndicesService();
        if (indicesService == null) {
            return;
        }
        this.metricsRegistry = OpenSearchResources.INSTANCE.getMetricsRegistry();
        if (this.metricsRegistry == null) {
            LOG.error("could not get the instance of MetricsRegistry class");
            return;
        }
        LOG.debug("Executing collect metrics for RTFNodeStatsAllShardsMetricsCollector");
        this.initialiseMetricsIfNeeded();
        this.populateCurrentShards();
        this.populatePerShardStats(indicesService);
        for (Map.Entry<ShardId, ShardStats> currentShard : this.currentPerShardStats.entrySet()) {
            ShardId shardId = currentShard.getKey();
            ShardStats currentShardStats = currentShard.getValue();
            if (this.prevPerShardStats.size() == 0) {
                this.recordMetrics(new NodeStatsMetricsAllShardsPerCollectionStatus(currentShardStats), shardId.getIndexName(), String.valueOf(shardId.id()));
                continue;
            }
            ShardStats prevShardStats = this.prevPerShardStats.get(shardId);
            if (prevShardStats == null) {
                this.recordMetrics(new NodeStatsMetricsAllShardsPerCollectionStatus(currentShardStats), shardId.getIndexName(), String.valueOf(shardId.id()));
                continue;
            }
            NodeStatsMetricsAllShardsPerCollectionStatus prevValue = new NodeStatsMetricsAllShardsPerCollectionStatus(prevShardStats);
            NodeStatsMetricsAllShardsPerCollectionStatus currValue = new NodeStatsMetricsAllShardsPerCollectionStatus(currentShardStats);
            this.populateDiffMetricValue(prevValue, currValue, shardId.getIndexName(), shardId.id());
        }
    }

    private void initialiseMetricsIfNeeded() {
        if (!this.metricsInitialised) {
            this.cacheQueryHitMetrics = this.metricsRegistry.createCounter("cache_query_hit", "CacheQueryHit Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.cacheQueryMissMetrics = this.metricsRegistry.createCounter("cache_query_miss", "CacheQueryMiss Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.cacheQuerySizeMetrics = this.metricsRegistry.createCounter("cache_query_size", "CacheQuerySize Metrics", RTFMetrics.MetricUnits.BYTE.toString());
            this.cacheFieldDataEvictionMetrics = this.metricsRegistry.createCounter("cache_field_data_eviction", "CacheFieldDataEviction Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.cacheFieldDataSizeMetrics = this.metricsRegistry.createCounter("cache_field_data_size", "CacheFieldDataSize Metrics", RTFMetrics.MetricUnits.BYTE.toString());
            this.cacheRequestHitMetrics = this.metricsRegistry.createCounter("cache_request_hit", "CacheRequestHit Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.cacheRequestMissMetrics = this.metricsRegistry.createCounter("cache_request_miss", "CacheRequestMiss Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.cacheRequestEvictionMetrics = this.metricsRegistry.createCounter("cache_request_eviction", "CacheRequestEviction Metrics", RTFMetrics.MetricUnits.COUNT.toString());
            this.cacheRequestSizeMetrics = this.metricsRegistry.createCounter("cache_request_size", "CacheRequestSize Metrics", RTFMetrics.MetricUnits.BYTE.toString());
            this.metricsInitialised = true;
        }
    }

    public void populatePerShardStats(IndicesService indicesService) {
        for (Map.Entry<ShardId, IndexShard> currentShard : this.currentShards.entrySet()) {
            IndexShard currentIndexShard = currentShard.getValue();
            IndexShardStats currentIndexShardStats = Utils.indexShardStats(indicesService, currentIndexShard, new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.RequestCache}));
            for (ShardStats shardStats : currentIndexShardStats.getShards()) {
                this.currentPerShardStats.put(currentIndexShardStats.getShardId(), shardStats);
            }
        }
    }

    private void recordMetrics(NodeStatsMetricsAllShardsPerCollectionStatus metrics, String indexName, String shardId) {
        Tags nodeStatsMetricsTag = Tags.create().addTag(RTFMetrics.CommonDimension.INDEX_NAME.toString(), indexName).addTag(RTFMetrics.CommonDimension.SHARD_ID.toString(), shardId);
        this.cacheQueryMissMetrics.add((double)metrics.getQueryCacheMissCount(), nodeStatsMetricsTag);
        this.cacheQuerySizeMetrics.add((double)metrics.getQueryCacheInBytes(), nodeStatsMetricsTag);
        this.cacheQueryHitMetrics.add((double)metrics.getQueryCacheHitCount(), nodeStatsMetricsTag);
        this.cacheFieldDataEvictionMetrics.add((double)metrics.getFieldDataEvictions(), nodeStatsMetricsTag);
        this.cacheFieldDataSizeMetrics.add((double)metrics.getFieldDataInBytes(), nodeStatsMetricsTag);
        this.cacheRequestEvictionMetrics.add((double)metrics.getRequestCacheEvictions(), nodeStatsMetricsTag);
        this.cacheRequestHitMetrics.add((double)metrics.getRequestCacheHitCount(), nodeStatsMetricsTag);
        this.cacheRequestMissMetrics.add((double)metrics.getRequestCacheMissCount(), nodeStatsMetricsTag);
        this.cacheRequestSizeMetrics.add((double)metrics.getRequestCacheInBytes(), nodeStatsMetricsTag);
    }

    public void populateDiffMetricValue(NodeStatsMetricsAllShardsPerCollectionStatus prevValue, NodeStatsMetricsAllShardsPerCollectionStatus currValue, String indexName, int shardId) {
        NodeStatsMetricsAllShardsPerCollectionStatus metrics = new NodeStatsMetricsAllShardsPerCollectionStatus(Math.max(currValue.queryCacheHitCount - prevValue.queryCacheHitCount, 0L), Math.max(currValue.queryCacheMissCount - prevValue.queryCacheMissCount, 0L), currValue.queryCacheInBytes, Math.max(currValue.fieldDataEvictions - prevValue.fieldDataEvictions, 0L), currValue.fieldDataInBytes, Math.max(currValue.requestCacheHitCount - prevValue.requestCacheHitCount, 0L), Math.max(currValue.requestCacheMissCount - prevValue.requestCacheMissCount, 0L), Math.max(currValue.requestCacheEvictions - prevValue.requestCacheEvictions, 0L), currValue.requestCacheInBytes);
        this.recordMetrics(metrics, indexName, String.valueOf(shardId));
    }

    public static class NodeStatsMetricsAllShardsPerCollectionStatus
    extends MetricStatus {
        @JsonIgnore
        private ShardStats shardStats;
        private final long queryCacheHitCount;
        private final long queryCacheMissCount;
        private final long queryCacheInBytes;
        private final long fieldDataEvictions;
        private final long fieldDataInBytes;
        private final long requestCacheHitCount;
        private final long requestCacheMissCount;
        private final long requestCacheEvictions;
        private final long requestCacheInBytes;

        public NodeStatsMetricsAllShardsPerCollectionStatus(ShardStats shardStats) {
            this.shardStats = shardStats;
            this.queryCacheHitCount = this.calculate(RTFMetrics.ShardStatsValue.CACHE_QUERY_HIT);
            this.queryCacheMissCount = this.calculate(RTFMetrics.ShardStatsValue.CACHE_QUERY_MISS);
            this.queryCacheInBytes = this.calculate(RTFMetrics.ShardStatsValue.CACHE_QUERY_SIZE);
            this.fieldDataEvictions = this.calculate(RTFMetrics.ShardStatsValue.CACHE_FIELDDATA_EVICTION);
            this.fieldDataInBytes = this.calculate(RTFMetrics.ShardStatsValue.CACHE_FIELDDATA_SIZE);
            this.requestCacheHitCount = this.calculate(RTFMetrics.ShardStatsValue.CACHE_REQUEST_HIT);
            this.requestCacheMissCount = this.calculate(RTFMetrics.ShardStatsValue.CACHE_REQUEST_MISS);
            this.requestCacheEvictions = this.calculate(RTFMetrics.ShardStatsValue.CACHE_REQUEST_EVICTION);
            this.requestCacheInBytes = this.calculate(RTFMetrics.ShardStatsValue.CACHE_REQUEST_SIZE);
        }

        public NodeStatsMetricsAllShardsPerCollectionStatus(long queryCacheHitCount, long queryCacheMissCount, long queryCacheInBytes, long fieldDataEvictions, long fieldDataInBytes, long requestCacheHitCount, long requestCacheMissCount, long requestCacheEvictions, long requestCacheInBytes) {
            this.shardStats = null;
            this.queryCacheHitCount = queryCacheHitCount;
            this.queryCacheMissCount = queryCacheMissCount;
            this.queryCacheInBytes = queryCacheInBytes;
            this.fieldDataEvictions = fieldDataEvictions;
            this.fieldDataInBytes = fieldDataInBytes;
            this.requestCacheHitCount = requestCacheHitCount;
            this.requestCacheMissCount = requestCacheMissCount;
            this.requestCacheEvictions = requestCacheEvictions;
            this.requestCacheInBytes = requestCacheInBytes;
        }

        private long calculate(RTFMetrics.ShardStatsValue nodeMetric) {
            return ((ValueCalculator)valueCalculators.get((Object)nodeMetric.toString())).calculateValue(this.shardStats);
        }

        @JsonIgnore
        public ShardStats getShardStats() {
            return this.shardStats;
        }

        @JsonProperty(value="cache_query_hit")
        public long getQueryCacheHitCount() {
            return this.queryCacheHitCount;
        }

        @JsonProperty(value="cache_query_miss")
        public long getQueryCacheMissCount() {
            return this.queryCacheMissCount;
        }

        @JsonProperty(value="cache_query_size")
        public long getQueryCacheInBytes() {
            return this.queryCacheInBytes;
        }

        @JsonProperty(value="cache_field_data_eviction")
        public long getFieldDataEvictions() {
            return this.fieldDataEvictions;
        }

        @JsonProperty(value="cache_field_data_size")
        public long getFieldDataInBytes() {
            return this.fieldDataInBytes;
        }

        @JsonProperty(value="cache_request_hit")
        public long getRequestCacheHitCount() {
            return this.requestCacheHitCount;
        }

        @JsonProperty(value="cache_request_miss")
        public long getRequestCacheMissCount() {
            return this.requestCacheMissCount;
        }

        @JsonProperty(value="cache_request_eviction")
        public long getRequestCacheEvictions() {
            return this.requestCacheEvictions;
        }

        @JsonProperty(value="cache_request_size")
        public long getRequestCacheInBytes() {
            return this.requestCacheInBytes;
        }
    }
}

