/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.timeseries.util.ExceptionUtil;

public class BulkUtil {
    private static final Logger logger = LogManager.getLogger(BulkUtil.class);

    public static List<IndexRequest> getFailedIndexRequest(BulkRequest bulkRequest, BulkResponse bulkResponse) {
        ArrayList<IndexRequest> res = new ArrayList<IndexRequest>();
        if (bulkResponse == null || bulkRequest == null) {
            return res;
        }
        HashSet<String> failedId = new HashSet<String>();
        for (BulkItemResponse response : bulkResponse.getItems()) {
            if (!response.isFailed() || !ExceptionUtil.isRetryAble(response.getFailure().getStatus())) continue;
            failedId.add(response.getId());
        }
        for (DocWriteRequest request : bulkRequest.requests()) {
            try {
                if (!failedId.contains(request.id())) continue;
                res.add((IndexRequest)request);
            }
            catch (ClassCastException e) {
                logger.error("We only support IndexRequest");
                throw e;
            }
        }
        return res;
    }

    public static IndexRequest cloneIndexRequest(IndexRequest indexRequest) {
        IndexRequest newRequest = new IndexRequest(indexRequest.index());
        newRequest.source(indexRequest.source(), indexRequest.getContentType());
        return newRequest;
    }
}

