/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.geoip2;

import com.maxmind.db.DatabaseRecord;
import com.maxmind.db.Metadata;
import com.maxmind.db.Network;
import com.maxmind.db.NoCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseProvider;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.AnonymousIpResponse;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.model.ConnectionTypeResponse;
import com.maxmind.geoip2.model.CountryResponse;
import com.maxmind.geoip2.model.DomainResponse;
import com.maxmind.geoip2.model.EnterpriseResponse;
import com.maxmind.geoip2.model.IpRiskResponse;
import com.maxmind.geoip2.model.IspResponse;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DatabaseReader
implements DatabaseProvider,
Closeable {
    private final Reader reader;
    private final List<String> locales;
    private final int databaseType;

    private DatabaseReader(Builder builder) throws IOException {
        if (builder.stream != null) {
            this.reader = new Reader(builder.stream, builder.cache);
        } else if (builder.database != null) {
            this.reader = new Reader(builder.database, builder.mode, builder.cache);
        } else {
            throw new IllegalArgumentException("Unsupported Builder configuration: expected either File or URL");
        }
        this.locales = builder.locales;
        this.databaseType = this.getDatabaseType();
    }

    private int getDatabaseType() {
        String databaseType = this.getMetadata().getDatabaseType();
        int type = 0;
        if (databaseType.contains("GeoIP2-Anonymous-IP")) {
            type |= DatabaseType.ANONYMOUS_IP.type;
        }
        if (databaseType.contains("GeoIP2-IP-Risk")) {
            type |= DatabaseType.IP_RISK.type;
        }
        if (databaseType.contains("GeoLite2-ASN")) {
            type |= DatabaseType.ASN.type;
        }
        if (databaseType.contains("City")) {
            type |= DatabaseType.CITY.type | DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-Connection-Type")) {
            type |= DatabaseType.CONNECTION_TYPE.type;
        }
        if (databaseType.contains("Country")) {
            type |= DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-Domain")) {
            type |= DatabaseType.DOMAIN.type;
        }
        if (databaseType.contains("Enterprise")) {
            type |= DatabaseType.ENTERPRISE.type | DatabaseType.CITY.type | DatabaseType.COUNTRY.type;
        }
        if (databaseType.contains("GeoIP2-ISP")) {
            type |= DatabaseType.ISP.type;
        }
        if (type == 0) {
            throw new UnsupportedOperationException("Invalid attempt to open an unknown database type: " + databaseType);
        }
        return type;
    }

    private <T> LookupResult<T> get(InetAddress ipAddress, Class<T> cls, DatabaseType expectedType) throws IOException {
        if ((this.databaseType & expectedType.type) == 0) {
            String caller = Thread.currentThread().getStackTrace()[3].getMethodName();
            throw new UnsupportedOperationException("Invalid attempt to open a " + this.getMetadata().getDatabaseType() + " database using the " + caller + " method");
        }
        DatabaseRecord record = this.reader.getRecord(ipAddress, cls);
        Object o = record.getData();
        return new LookupResult<Object>(o, ipAddress.getHostAddress(), record.getNetwork());
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public CountryResponse country(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<CountryResponse> r = this.getCountry(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<CountryResponse> tryCountry(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getCountry(ipAddress);
    }

    private Optional<CountryResponse> getCountry(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<CountryResponse> result = this.get(ipAddress, CountryResponse.class, DatabaseType.COUNTRY);
        CountryResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new CountryResponse(response, result.getIpAddress(), result.getNetwork(), this.locales));
    }

    @Override
    public CityResponse city(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<CityResponse> r = this.getCity(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<CityResponse> tryCity(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getCity(ipAddress);
    }

    private Optional<CityResponse> getCity(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<CityResponse> result = this.get(ipAddress, CityResponse.class, DatabaseType.CITY);
        CityResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new CityResponse(response, result.getIpAddress(), result.getNetwork(), this.locales));
    }

    @Override
    public AnonymousIpResponse anonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<AnonymousIpResponse> r = this.getAnonymousIp(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<AnonymousIpResponse> tryAnonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getAnonymousIp(ipAddress);
    }

    private Optional<AnonymousIpResponse> getAnonymousIp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<AnonymousIpResponse> result = this.get(ipAddress, AnonymousIpResponse.class, DatabaseType.ANONYMOUS_IP);
        AnonymousIpResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new AnonymousIpResponse(response, result.getIpAddress(), result.getNetwork()));
    }

    @Override
    @Deprecated
    public IpRiskResponse ipRisk(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<IpRiskResponse> r = this.getIpRisk(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    @Deprecated
    public Optional<IpRiskResponse> tryIpRisk(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getIpRisk(ipAddress);
    }

    @Deprecated
    private Optional<IpRiskResponse> getIpRisk(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<IpRiskResponse> result = this.get(ipAddress, IpRiskResponse.class, DatabaseType.IP_RISK);
        IpRiskResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new IpRiskResponse(response, result.getIpAddress(), result.getNetwork()));
    }

    @Override
    public AsnResponse asn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<AsnResponse> r = this.getAsn(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<AsnResponse> tryAsn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getAsn(ipAddress);
    }

    private Optional<AsnResponse> getAsn(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<AsnResponse> result = this.get(ipAddress, AsnResponse.class, DatabaseType.ASN);
        AsnResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new AsnResponse(response, result.getIpAddress(), result.getNetwork()));
    }

    @Override
    public ConnectionTypeResponse connectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<ConnectionTypeResponse> r = this.getConnectionType(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<ConnectionTypeResponse> tryConnectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getConnectionType(ipAddress);
    }

    private Optional<ConnectionTypeResponse> getConnectionType(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<ConnectionTypeResponse> result = this.get(ipAddress, ConnectionTypeResponse.class, DatabaseType.CONNECTION_TYPE);
        ConnectionTypeResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new ConnectionTypeResponse(response, result.getIpAddress(), result.getNetwork()));
    }

    @Override
    public DomainResponse domain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<DomainResponse> r = this.getDomain(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<DomainResponse> tryDomain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getDomain(ipAddress);
    }

    private Optional<DomainResponse> getDomain(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<DomainResponse> result = this.get(ipAddress, DomainResponse.class, DatabaseType.DOMAIN);
        DomainResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new DomainResponse(response, result.getIpAddress(), result.getNetwork()));
    }

    @Override
    public EnterpriseResponse enterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<EnterpriseResponse> r = this.getEnterprise(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<EnterpriseResponse> tryEnterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getEnterprise(ipAddress);
    }

    private Optional<EnterpriseResponse> getEnterprise(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<EnterpriseResponse> result = this.get(ipAddress, EnterpriseResponse.class, DatabaseType.ENTERPRISE);
        EnterpriseResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new EnterpriseResponse(response, result.getIpAddress(), result.getNetwork(), this.locales));
    }

    @Override
    public IspResponse isp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        Optional<IspResponse> r = this.getIsp(ipAddress);
        if (r.isEmpty()) {
            throw new AddressNotFoundException("The address " + ipAddress.getHostAddress() + " is not in the database.");
        }
        return r.get();
    }

    @Override
    public Optional<IspResponse> tryIsp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        return this.getIsp(ipAddress);
    }

    private Optional<IspResponse> getIsp(InetAddress ipAddress) throws IOException, GeoIp2Exception {
        LookupResult<IspResponse> result = this.get(ipAddress, IspResponse.class, DatabaseType.ISP);
        IspResponse response = result.getModel();
        if (response == null) {
            return Optional.empty();
        }
        return Optional.of(new IspResponse(response, result.getIpAddress(), result.getNetwork()));
    }

    public Metadata getMetadata() {
        return this.reader.getMetadata();
    }

    public static final class Builder {
        final File database;
        final InputStream stream;
        List<String> locales = Collections.singletonList("en");
        Reader.FileMode mode = Reader.FileMode.MEMORY_MAPPED;
        NodeCache cache = NoCache.getInstance();

        public Builder(InputStream stream) {
            this.stream = stream;
            this.database = null;
        }

        public Builder(File database) {
            this.database = database;
            this.stream = null;
        }

        public Builder locales(List<String> val) {
            this.locales = val;
            return this;
        }

        public Builder withCache(NodeCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder fileMode(Reader.FileMode val) {
            if (this.stream != null && Reader.FileMode.MEMORY != val) {
                throw new IllegalArgumentException("Only FileMode.MEMORY is supported when using an InputStream.");
            }
            this.mode = val;
            return this;
        }

        public DatabaseReader build() throws IOException {
            return new DatabaseReader(this);
        }
    }

    private static enum DatabaseType {
        ANONYMOUS_IP,
        ASN,
        CITY,
        CONNECTION_TYPE,
        COUNTRY,
        DOMAIN,
        ENTERPRISE,
        IP_RISK,
        ISP;

        final int type = 1 << this.ordinal();
    }

    static final class LookupResult<T> {
        final T model;
        final String ipAddress;
        final Network network;

        LookupResult(T model, String ipAddress, Network network) {
            this.model = model;
            this.ipAddress = ipAddress;
            this.network = network;
        }

        T getModel() {
            return this.model;
        }

        String getIpAddress() {
            return this.ipAddress;
        }

        Network getNetwork() {
            return this.network;
        }
    }
}

