/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.cluster.metadata.DataStream;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.DataStreamFieldMapper;

@PublicApi(since="1.0.0")
public class ComposableIndexTemplate
extends AbstractDiffable<ComposableIndexTemplate>
implements ToXContentObject {
    private static final ParseField INDEX_PATTERNS = new ParseField("index_patterns", new String[0]);
    private static final ParseField TEMPLATE = new ParseField("template", new String[0]);
    private static final ParseField PRIORITY = new ParseField("priority", new String[0]);
    private static final ParseField COMPOSED_OF = new ParseField("composed_of", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField METADATA = new ParseField("_meta", new String[0]);
    private static final ParseField DATA_STREAM = new ParseField("data_stream", new String[0]);
    public static final ConstructingObjectParser<ComposableIndexTemplate, Void> PARSER = new ConstructingObjectParser("index_template", false, a -> new ComposableIndexTemplate((List)a[0], (Template)a[1], (List)a[2], (Long)a[3], (Long)a[4], (Map)a[5], (DataStreamTemplate)a[6]));
    private final List<String> indexPatterns;
    @Nullable
    private final Template template;
    @Nullable
    private final List<String> componentTemplates;
    @Nullable
    private final Long priority;
    @Nullable
    private final Long version;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final DataStreamTemplate dataStreamTemplate;

    static Diff<ComposableIndexTemplate> readITV2DiffFrom(StreamInput in) throws IOException {
        return AbstractDiffable.readDiffFrom(ComposableIndexTemplate::new, in);
    }

    public static ComposableIndexTemplate parse(XContentParser parser) throws IOException {
        return (ComposableIndexTemplate)PARSER.parse(parser, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata) {
        this(indexPatterns, template, componentTemplates, priority, version, metadata, null);
    }

    public ComposableIndexTemplate(List<String> indexPatterns, @Nullable Template template, @Nullable List<String> componentTemplates, @Nullable Long priority, @Nullable Long version, @Nullable Map<String, Object> metadata, @Nullable DataStreamTemplate dataStreamTemplate) {
        this.indexPatterns = indexPatterns;
        this.template = template;
        this.componentTemplates = componentTemplates;
        this.priority = priority;
        this.version = version;
        this.metadata = metadata;
        this.dataStreamTemplate = dataStreamTemplate;
    }

    public ComposableIndexTemplate(StreamInput in) throws IOException {
        this.indexPatterns = in.readStringList();
        this.template = in.readBoolean() ? new Template(in) : null;
        this.componentTemplates = in.readOptionalStringList();
        this.priority = in.readOptionalVLong();
        this.version = in.readOptionalVLong();
        this.metadata = in.readMap();
        this.dataStreamTemplate = in.getVersion().onOrAfter((Version)LegacyESVersion.V_7_9_0) ? (DataStreamTemplate)in.readOptionalWriteable(DataStreamTemplate::new) : null;
    }

    public List<String> indexPatterns() {
        return this.indexPatterns;
    }

    @Nullable
    public Template template() {
        return this.template;
    }

    public List<String> composedOf() {
        if (this.componentTemplates == null) {
            return Collections.emptyList();
        }
        return this.componentTemplates;
    }

    public Long priority() {
        return this.priority;
    }

    public long priorityOrZero() {
        if (this.priority == null) {
            return 0L;
        }
        return this.priority;
    }

    public Long version() {
        return this.version;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public DataStreamTemplate getDataStreamTemplate() {
        return this.dataStreamTemplate;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.indexPatterns);
        if (this.template == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.template.writeTo(out);
        }
        out.writeOptionalStringCollection(this.componentTemplates);
        out.writeOptionalVLong(this.priority);
        out.writeOptionalVLong(this.version);
        out.writeMap(this.metadata);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_7_9_0)) {
            out.writeOptionalWriteable((Writeable)this.dataStreamTemplate);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_PATTERNS.getPreferredName(), this.indexPatterns);
        if (this.template != null) {
            builder.field(TEMPLATE.getPreferredName(), (ToXContent)this.template);
        }
        if (this.componentTemplates != null) {
            builder.field(COMPOSED_OF.getPreferredName(), this.componentTemplates);
        }
        if (this.priority != null) {
            builder.field(PRIORITY.getPreferredName(), this.priority);
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        if (this.metadata != null) {
            builder.field(METADATA.getPreferredName(), this.metadata);
        }
        if (this.dataStreamTemplate != null) {
            builder.field(DATA_STREAM.getPreferredName(), (ToXContent)this.dataStreamTemplate);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.indexPatterns, this.template, this.componentTemplates, this.priority, this.version, this.metadata, this.dataStreamTemplate);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComposableIndexTemplate other = (ComposableIndexTemplate)obj;
        return Objects.equals(this.indexPatterns, other.indexPatterns) && Objects.equals(this.template, other.template) && Objects.equals(this.componentTemplates, other.componentTemplates) && Objects.equals(this.priority, other.priority) && Objects.equals(this.version, other.version) && Objects.equals(this.metadata, other.metadata) && Objects.equals(this.dataStreamTemplate, other.dataStreamTemplate);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), INDEX_PATTERNS);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), Template.PARSER, TEMPLATE);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), COMPOSED_OF);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), PRIORITY);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), METADATA);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataStreamTemplate.PARSER, DATA_STREAM);
    }

    @PublicApi(since="1.0.0")
    public static class DataStreamTemplate
    implements Writeable,
    ToXContentObject {
        private static final ParseField TIMESTAMP_FIELD_FIELD = new ParseField("timestamp_field", new String[0]);
        private static final ConstructingObjectParser<DataStreamTemplate, Void> PARSER = new ConstructingObjectParser("data_stream_template", true, args -> new DataStreamTemplate((DataStream.TimestampField)args[0]));
        private final DataStream.TimestampField timestampField;

        public DataStreamTemplate() {
            this(DataStreamFieldMapper.Defaults.TIMESTAMP_FIELD);
        }

        public DataStreamTemplate(DataStream.TimestampField timestampField) {
            this.timestampField = timestampField;
        }

        public DataStreamTemplate(StreamInput in) throws IOException {
            this.timestampField = in.getVersion().onOrAfter(Version.V_1_0_0) ? (DataStream.TimestampField)in.readOptionalWriteable(DataStream.TimestampField::new) : DataStreamFieldMapper.Defaults.TIMESTAMP_FIELD;
        }

        public DataStream.TimestampField getTimestampField() {
            return this.timestampField == null ? DataStreamFieldMapper.Defaults.TIMESTAMP_FIELD : this.timestampField;
        }

        public Map<String, Object> getDataStreamMappingSnippet() {
            return Collections.singletonMap("_doc", Collections.singletonMap("_data_stream_timestamp", Collections.unmodifiableMap(Map.of("enabled", true, "timestamp_field", this.getTimestampField().toMap()))));
        }

        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_1_0_0)) {
                out.writeOptionalWriteable((Writeable)this.timestampField);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(TIMESTAMP_FIELD_FIELD.getPreferredName(), (ToXContent)this.getTimestampField()).endObject();
        }

        public static DataStreamTemplate fromXContent(XContentParser parser) {
            return (DataStreamTemplate)PARSER.apply(parser, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataStreamTemplate that = (DataStreamTemplate)o;
            return Objects.equals(this.timestampField, that.timestampField);
        }

        public int hashCode() {
            return Objects.hash(this.timestampField);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), DataStream.TimestampField.PARSER, TIMESTAMP_FIELD_FIELD);
        }
    }
}

