/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.discovery;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.extensions.DiscoveryExtensionNode;
import org.opensearch.transport.TransportRequest;

public class InitializeExtensionRequest
extends TransportRequest {
    private final DiscoveryNode sourceNode;
    private final DiscoveryExtensionNode extension;
    private final String serviceAccountHeader;

    public InitializeExtensionRequest(DiscoveryNode sourceNode, DiscoveryExtensionNode extension, String serviceAccountHeader) {
        this.sourceNode = sourceNode;
        this.extension = extension;
        this.serviceAccountHeader = serviceAccountHeader;
    }

    public InitializeExtensionRequest(StreamInput in) throws IOException {
        super(in);
        this.sourceNode = new DiscoveryNode(in);
        this.extension = new DiscoveryExtensionNode(in);
        this.serviceAccountHeader = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.sourceNode.writeTo(out);
        this.extension.writeTo(out);
        out.writeString(this.serviceAccountHeader);
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public DiscoveryExtensionNode getExtension() {
        return this.extension;
    }

    public String getServiceAccountHeader() {
        return this.serviceAccountHeader;
    }

    public String toString() {
        return "InitializeExtensionsRequest{sourceNode=" + this.sourceNode + ", extension=" + this.extension + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InitializeExtensionRequest that = (InitializeExtensionRequest)o;
        return Objects.equals(this.sourceNode, that.sourceNode) && Objects.equals(this.extension, that.extension) && Objects.equals(this.serviceAccountHeader, that.getServiceAccountHeader());
    }

    public int hashCode() {
        return Objects.hash(this.sourceNode, this.extension);
    }
}

