/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.RoutingNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.gateway.PrimaryShardAllocator;
import org.opensearch.gateway.TransportNodesGatewayStartedShardHelper;
import org.opensearch.gateway.TransportNodesListGatewayStartedShards;
import org.opensearch.gateway.TransportNodesListGatewayStartedShardsBatch;

public abstract class PrimaryShardBatchAllocator
extends PrimaryShardAllocator {
    protected abstract AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> fetchData(List<ShardRouting> var1, List<ShardRouting> var2, RoutingAllocation var3);

    @Override
    protected AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting shard, RoutingAllocation allocation) {
        this.logger.error("fetchData for single shard called via batch allocator, shard id {}", (Object)shard.shardId());
        throw new IllegalStateException("PrimaryShardBatchAllocator should only be used for a batch of shards");
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        AllocateUnassignedDecision decision = this.getInEligibleShardDecision(unassignedShard, allocation);
        if (decision != null) {
            return decision;
        }
        AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> shardsState = this.fetchData(List.of(unassignedShard), Collections.emptyList(), allocation);
        List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeGatewayStartedShards = PrimaryShardBatchAllocator.adaptToNodeShardStates(unassignedShard, shardsState);
        return this.getAllocationDecision(unassignedShard, allocation, nodeGatewayStartedShards, logger);
    }

    public void allocateUnassignedBatch(List<ShardRouting> shardRoutings, RoutingAllocation allocation) {
        HashMap<ShardId, AllocateUnassignedDecision> ineligibleShardAllocationDecisions = new HashMap<ShardId, AllocateUnassignedDecision>();
        ArrayList<ShardRouting> eligibleShards = new ArrayList<ShardRouting>();
        ArrayList<ShardRouting> inEligibleShards = new ArrayList<ShardRouting>();
        for (ShardRouting shard : shardRoutings) {
            AllocateUnassignedDecision decision = this.getInEligibleShardDecision(shard, allocation);
            if (decision != null) {
                ineligibleShardAllocationDecisions.put(shard.shardId(), decision);
                inEligibleShards.add(shard);
                continue;
            }
            eligibleShards.add(shard);
        }
        AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> shardsState = this.fetchData(eligibleShards, inEligibleShards, allocation);
        RoutingNodes.UnassignedShards.UnassignedIterator iterator = allocation.routingNodes().unassigned().iterator();
        while (iterator.hasNext()) {
            AllocateUnassignedDecision allocationDecision;
            ShardRouting unassignedShard = iterator.next();
            if (!shardRoutings.contains(unassignedShard)) continue;
            assert (unassignedShard.primary());
            if (ineligibleShardAllocationDecisions.containsKey(unassignedShard.shardId())) {
                allocationDecision = (AllocateUnassignedDecision)ineligibleShardAllocationDecisions.get(unassignedShard.shardId());
            } else {
                List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = PrimaryShardBatchAllocator.adaptToNodeShardStates(unassignedShard, shardsState);
                allocationDecision = this.getAllocationDecision(unassignedShard, allocation, nodeShardStates, this.logger);
            }
            this.executeDecision(unassignedShard, allocationDecision, allocation, iterator);
        }
    }

    private static List<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> adaptToNodeShardStates(ShardRouting unassignedShard, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> shardsState) {
        if (!shardsState.hasData()) {
            return null;
        }
        ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard> nodeShardStates = new ArrayList<TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard>();
        Map<DiscoveryNode, TransportNodesListGatewayStartedShardsBatch.NodeGatewayStartedShardsBatch> nodeResponses = shardsState.getData();
        nodeResponses.forEach((node, nodeGatewayStartedShardsBatch) -> {
            TransportNodesGatewayStartedShardHelper.GatewayStartedShard shardData = nodeGatewayStartedShardsBatch.getNodeGatewayStartedShardsBatch().get(unassignedShard.shardId());
            nodeShardStates.add(new TransportNodesGatewayStartedShardHelper.NodeGatewayStartedShard(shardData.allocationId(), shardData.primary(), shardData.replicationCheckpoint(), shardData.storeException(), (DiscoveryNode)node));
        });
        return nodeShardStates;
    }
}

