/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.remote.AbstractRemoteWritableBlobEntity;
import org.opensearch.common.remote.RemoteWritableEntityStore;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteStateTransferException;
import org.opensearch.gateway.remote.model.RemoteClusterStateBlobStore;
import org.opensearch.gateway.remote.model.RemoteReadResult;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteClusterStateAttributesManager {
    public static final String CLUSTER_STATE_ATTRIBUTE = "cluster_state_attribute";
    public static final String DISCOVERY_NODES = "nodes";
    public static final String CLUSTER_BLOCKS = "blocks";
    public static final int CLUSTER_STATE_ATTRIBUTES_CURRENT_CODEC_VERSION = 1;
    private final Map<String, RemoteWritableEntityStore> remoteWritableEntityStores;
    private final NamedWriteableRegistry namedWriteableRegistry;

    RemoteClusterStateAttributesManager(String clusterName, BlobStoreRepository blobStoreRepository, BlobStoreTransferService blobStoreTransferService, NamedWriteableRegistry namedWriteableRegistry, ThreadPool threadpool) {
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.remoteWritableEntityStores = new HashMap<String, RemoteWritableEntityStore>();
        this.remoteWritableEntityStores.put(DISCOVERY_NODES, new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put(CLUSTER_BLOCKS, new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("cluster-state-custom", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
    }

    CheckedRunnable<IOException> getAsyncMetadataWriteAction(String component, AbstractRemoteWritableBlobEntity blobEntity, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        return () -> this.getStore(blobEntity).writeAsync(blobEntity, this.getActionListener(component, blobEntity, latchedActionListener));
    }

    private ActionListener<Void> getActionListener(String component, AbstractRemoteWritableBlobEntity remoteObject, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        return ActionListener.wrap(resp -> latchedActionListener.onResponse(remoteObject.getUploadedMetadata()), ex -> latchedActionListener.onFailure(new RemoteStateTransferException(component, remoteObject, (Throwable)ex)));
    }

    private RemoteWritableEntityStore getStore(AbstractRemoteWritableBlobEntity entity) {
        RemoteWritableEntityStore remoteStore = this.remoteWritableEntityStores.get(entity.getType());
        if (remoteStore == null) {
            throw new IllegalArgumentException("Unknown entity type [" + entity.getType() + "]");
        }
        return remoteStore;
    }

    public CheckedRunnable<IOException> getAsyncMetadataReadAction(String component, AbstractRemoteWritableBlobEntity blobEntity, LatchedActionListener<RemoteReadResult> listener) {
        ActionListener actionListener = ActionListener.wrap(response -> listener.onResponse(new RemoteReadResult(response, CLUSTER_STATE_ATTRIBUTE, component)), listener::onFailure);
        return () -> this.getStore(blobEntity).readAsync(blobEntity, actionListener);
    }

    public DiffableUtils.MapDiff<String, ClusterState.Custom, Map<String, ClusterState.Custom>> getUpdatedCustoms(ClusterState clusterState, ClusterState previousClusterState, boolean isRemotePublicationEnabled, boolean isFirstUpload) {
        if (!isRemotePublicationEnabled) {
            return DiffableUtils.diff(Collections.emptyMap(), Collections.emptyMap(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        }
        if (isFirstUpload) {
            return DiffableUtils.diff(Collections.emptyMap(), clusterState.customs(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        }
        return DiffableUtils.diff(previousClusterState.customs(), clusterState.customs(), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
    }
}

