/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.action.LatchedActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.DiffableUtils;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.TemplatesMetadata;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.remote.AbstractRemoteWritableBlobEntity;
import org.opensearch.common.remote.RemoteWritableEntityStore;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.compress.Compressor;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteStateTransferException;
import org.opensearch.gateway.remote.model.RemoteClusterStateBlobStore;
import org.opensearch.gateway.remote.model.RemoteCoordinationMetadata;
import org.opensearch.gateway.remote.model.RemoteCustomMetadata;
import org.opensearch.gateway.remote.model.RemoteGlobalMetadata;
import org.opensearch.gateway.remote.model.RemotePersistentSettingsMetadata;
import org.opensearch.gateway.remote.model.RemoteReadResult;
import org.opensearch.gateway.remote.model.RemoteTemplatesMetadata;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.threadpool.ThreadPool;

public class RemoteGlobalMetadataManager {
    public static final TimeValue GLOBAL_METADATA_UPLOAD_TIMEOUT_DEFAULT = TimeValue.timeValueMillis((long)20000L);
    public static final Setting<TimeValue> GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.state.global_metadata.upload_timeout", GLOBAL_METADATA_UPLOAD_TIMEOUT_DEFAULT, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final int GLOBAL_METADATA_CURRENT_CODEC_VERSION = 1;
    private volatile TimeValue globalMetadataUploadTimeout;
    private Map<String, RemoteWritableEntityStore> remoteWritableEntityStores;
    private final Compressor compressor;
    private final NamedXContentRegistry namedXContentRegistry;
    private final NamedWriteableRegistry namedWriteableRegistry;

    RemoteGlobalMetadataManager(ClusterSettings clusterSettings, String clusterName, BlobStoreRepository blobStoreRepository, BlobStoreTransferService blobStoreTransferService, NamedWriteableRegistry namedWriteableRegistry, ThreadPool threadpool) {
        this.globalMetadataUploadTimeout = clusterSettings.get(GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING);
        this.compressor = blobStoreRepository.getCompressor();
        this.namedXContentRegistry = blobStoreRepository.getNamedXContentRegistry();
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.remoteWritableEntityStores = new HashMap<String, RemoteWritableEntityStore>();
        this.remoteWritableEntityStores.put("global_metadata", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("coordination", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("settings", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("transient-settings", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("hashes-of-consistent-settings", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("templates", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        this.remoteWritableEntityStores.put("custom", new RemoteClusterStateBlobStore(blobStoreTransferService, blobStoreRepository, clusterName, threadpool, "remote_state_read"));
        clusterSettings.addSettingsUpdateConsumer(GLOBAL_METADATA_UPLOAD_TIMEOUT_SETTING, this::setGlobalMetadataUploadTimeout);
    }

    CheckedRunnable<IOException> getAsyncMetadataWriteAction(AbstractRemoteWritableBlobEntity writeEntity, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        return () -> this.getStore(writeEntity).writeAsync(writeEntity, this.getActionListener(writeEntity, latchedActionListener));
    }

    private RemoteWritableEntityStore getStore(AbstractRemoteWritableBlobEntity entity) {
        RemoteWritableEntityStore remoteStore = this.remoteWritableEntityStores.get(entity.getType());
        if (remoteStore == null) {
            throw new IllegalArgumentException("Unknown entity type [" + entity.getType() + "]");
        }
        return remoteStore;
    }

    private ActionListener<Void> getActionListener(AbstractRemoteWritableBlobEntity remoteBlobStoreObject, LatchedActionListener<ClusterMetadataManifest.UploadedMetadata> latchedActionListener) {
        return ActionListener.wrap(resp -> latchedActionListener.onResponse(remoteBlobStoreObject.getUploadedMetadata()), ex -> latchedActionListener.onFailure(new RemoteStateTransferException("Upload failed for " + remoteBlobStoreObject.getType(), (Throwable)ex)));
    }

    CheckedRunnable<IOException> getAsyncMetadataReadAction(AbstractRemoteWritableBlobEntity readEntity, String componentName, LatchedActionListener<RemoteReadResult> listener) {
        ActionListener actionListener = ActionListener.wrap(response -> listener.onResponse(new RemoteReadResult(response, readEntity.getType(), componentName)), listener::onFailure);
        return () -> this.getStore(readEntity).readAsync(readEntity, actionListener);
    }

    Metadata getGlobalMetadata(String clusterUUID, ClusterMetadataManifest clusterMetadataManifest) {
        String globalMetadataFileName = clusterMetadataManifest.getGlobalMetadataFileName();
        try {
            if (globalMetadataFileName != null) {
                RemoteGlobalMetadata remoteGlobalMetadata = new RemoteGlobalMetadata(String.format(Locale.ROOT, "%s.dat", globalMetadataFileName), clusterUUID, this.compressor, this.namedXContentRegistry);
                return (Metadata)this.getStore(remoteGlobalMetadata).read(remoteGlobalMetadata);
            }
            if (clusterMetadataManifest.hasMetadataAttributesFiles()) {
                Metadata.Builder builder = new Metadata.Builder();
                if (clusterMetadataManifest.getCoordinationMetadata().getUploadedFilename() != null) {
                    RemoteCoordinationMetadata remoteCoordinationMetadata = new RemoteCoordinationMetadata(clusterMetadataManifest.getCoordinationMetadata().getUploadedFilename(), clusterUUID, this.compressor, this.namedXContentRegistry);
                    builder.coordinationMetadata((CoordinationMetadata)this.getStore(remoteCoordinationMetadata).read(remoteCoordinationMetadata));
                }
                if (clusterMetadataManifest.getTemplatesMetadata().getUploadedFilename() != null) {
                    RemoteTemplatesMetadata remoteTemplatesMetadata = new RemoteTemplatesMetadata(clusterMetadataManifest.getTemplatesMetadata().getUploadedFilename(), clusterUUID, this.compressor, this.namedXContentRegistry);
                    builder.templates((TemplatesMetadata)this.getStore(remoteTemplatesMetadata).read(remoteTemplatesMetadata));
                }
                if (clusterMetadataManifest.getSettingsMetadata().getUploadedFilename() != null) {
                    RemotePersistentSettingsMetadata remotePersistentSettingsMetadata = new RemotePersistentSettingsMetadata(clusterMetadataManifest.getSettingsMetadata().getUploadedFilename(), clusterUUID, this.compressor, this.namedXContentRegistry);
                    builder.persistentSettings((Settings)this.getStore(remotePersistentSettingsMetadata).read(remotePersistentSettingsMetadata));
                }
                builder.clusterUUID(clusterMetadataManifest.getClusterUUID());
                builder.clusterUUIDCommitted(clusterMetadataManifest.isClusterUUIDCommitted());
                clusterMetadataManifest.getCustomMetadataMap().forEach((key, value) -> {
                    try {
                        RemoteCustomMetadata remoteCustomMetadata = new RemoteCustomMetadata(value.getUploadedFilename(), (String)key, clusterUUID, this.compressor, this.namedWriteableRegistry);
                        builder.putCustom((String)key, (Metadata.Custom)this.getStore(remoteCustomMetadata).read(remoteCustomMetadata));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading Custom Metadata - %s", value.getUploadedFilename()), e);
                    }
                });
                return builder.build();
            }
            return Metadata.EMPTY_METADATA;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Error while downloading Global Metadata - %s", globalMetadataFileName), e);
        }
    }

    DiffableUtils.MapDiff<String, Metadata.Custom, Map<String, Metadata.Custom>> getCustomsDiff(ClusterState currentState, ClusterState previousState, boolean firstUploadForSplitGlobalMetadata, boolean isRemotePublicationEnabled) {
        if (firstUploadForSplitGlobalMetadata) {
            return DiffableUtils.diff(Collections.emptyMap(), RemoteGlobalMetadataManager.filterCustoms(currentState.metadata().customs(), isRemotePublicationEnabled), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
        }
        return DiffableUtils.diff(RemoteGlobalMetadataManager.filterCustoms(previousState.metadata().customs(), isRemotePublicationEnabled), RemoteGlobalMetadataManager.filterCustoms(currentState.metadata().customs(), isRemotePublicationEnabled), DiffableUtils.getStringKeySerializer(), DiffableUtils.NonDiffableValueSerializer.getAbstractInstance());
    }

    public static Map<String, Metadata.Custom> filterCustoms(Map<String, Metadata.Custom> customs, boolean isRemotePublicationEnabled) {
        if (isRemotePublicationEnabled) {
            return customs;
        }
        return customs.entrySet().stream().filter(e -> ((Metadata.Custom)e.getValue()).context().contains((Object)Metadata.XContentContext.GATEWAY)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    boolean isGlobalMetadataEqual(ClusterMetadataManifest first, ClusterMetadataManifest second, String clusterName) {
        Metadata secondGlobalMetadata = this.getGlobalMetadata(second.getClusterUUID(), second);
        Metadata firstGlobalMetadata = this.getGlobalMetadata(first.getClusterUUID(), first);
        return Metadata.isGlobalResourcesMetadataEquals(firstGlobalMetadata, secondGlobalMetadata);
    }

    private void setGlobalMetadataUploadTimeout(TimeValue newGlobalMetadataUploadTimeout) {
        this.globalMetadataUploadTimeout = newGlobalMetadataUploadTimeout;
    }

    public TimeValue getGlobalMetadataUploadTimeout() {
        return this.globalMetadataUploadTimeout;
    }
}

