/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote.routingtable;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

public class IndexRoutingTableHeader
implements Writeable {
    public static final String INDEX_ROUTING_HEADER_CODEC = "index_routing_header_codec";
    public static final int INITIAL_VERSION = 1;
    public static final int CURRENT_VERSION = 1;
    private final String indexName;

    public IndexRoutingTableHeader(String indexName) {
        this.indexName = indexName;
    }

    public IndexRoutingTableHeader(StreamInput in) throws IOException {
        try {
            this.readHeaderVersion(in);
            this.indexName = in.readString();
        }
        catch (EOFException e) {
            throw new IOException("index routing header truncated", e);
        }
    }

    private void readHeaderVersion(StreamInput in) throws IOException {
        try {
            CodecUtil.checkHeader((DataInput)new InputStreamDataInput((InputStream)in), (String)INDEX_ROUTING_HEADER_CODEC, (int)1, (int)1);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
            throw new IOException("index routing table header corrupted", e);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        try {
            CodecUtil.writeHeader((DataOutput)new OutputStreamDataOutput((OutputStream)out), (String)INDEX_ROUTING_HEADER_CODEC, (int)1);
            out.writeString(this.indexName);
            out.flush();
        }
        catch (IOException e) {
            throw new IOException("Failed to write IndexRoutingTable header", e);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }
}

