/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class HttpStats
implements Writeable,
ToXContentFragment {
    private final long serverOpen;
    private final long totalOpen;

    public HttpStats(long serverOpen, long totalOpened) {
        this.serverOpen = serverOpen;
        this.totalOpen = totalOpened;
    }

    public HttpStats(StreamInput in) throws IOException {
        this.serverOpen = in.readVLong();
        this.totalOpen = in.readVLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.serverOpen);
        out.writeVLong(this.totalOpen);
    }

    public long getServerOpen() {
        return this.serverOpen;
    }

    public long getTotalOpen() {
        return this.totalOpen;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.field("current_open", this.serverOpen);
        builder.field("total_opened", this.totalOpen);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String CURRENT_OPEN = "current_open";
        static final String TOTAL_OPENED = "total_opened";

        Fields() {
        }
    }
}

