/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugins;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import joptsimple.OptionSet;
import org.opensearch.Version;
import org.opensearch.cli.EnvironmentAwareCommand;
import org.opensearch.cli.Terminal;
import org.opensearch.env.Environment;
import org.opensearch.plugins.PluginInfo;
import org.opensearch.plugins.PluginsService;

class ListPluginsCommand
extends EnvironmentAwareCommand {
    ListPluginsCommand() {
        super("Lists installed opensearch plugins");
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!Files.exists(env.pluginsFile(), new LinkOption[0])) {
            throw new IOException("Plugins directory missing: " + env.pluginsFile());
        }
        terminal.println(Terminal.Verbosity.VERBOSE, "Plugins directory: " + env.pluginsFile());
        ArrayList<Path> plugins = new ArrayList<Path>();
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(env.pluginsFile());){
            for (Path plugin : paths) {
                plugins.add(plugin);
            }
        }
        Collections.sort(plugins);
        for (Path plugin : plugins) {
            this.printPlugin(env, terminal, plugin, "");
        }
    }

    private void printPlugin(Environment env, Terminal terminal, Path plugin, String prefix) throws IOException {
        PluginInfo info = PluginInfo.readFromProperties((Path)env.pluginsFile().resolve(plugin));
        terminal.println(Terminal.Verbosity.SILENT, prefix + info.getName());
        terminal.println(Terminal.Verbosity.VERBOSE, info.toString(prefix));
        if (!PluginsService.isPluginVersionCompatible((PluginInfo)info, (Version)Version.CURRENT)) {
            terminal.errorPrintln("WARNING: plugin [" + info.getName() + "] was built for OpenSearch version " + info.getOpenSearchVersionRangesString() + " and is not compatible with " + Version.CURRENT);
        }
    }
}

