import * as Models from '../../../models';
import { BroadcastAddress } from '../../../zspec/enums';
import * as Zcl from '../../../zspec/zcl';
import Adapter from '../../adapter';
import * as Events from '../../events';
import { NetworkOptions, SerialPortOptions, Coordinator, CoordinatorVersion, NodeDescriptor, ActiveEndpoints, SimpleDescriptor, LQI, RoutingTable, NetworkParameters, StartResult, AdapterOptions } from '../../tstype';
declare class EZSPAdapter extends Adapter {
    private driver;
    private waitress;
    private interpanLock;
    private queue;
    private closing;
    private deprecatedTimer;
    constructor(networkOptions: NetworkOptions, serialPortOptions: SerialPortOptions, backupPath: string, adapterOptions: AdapterOptions);
    private processMessage;
    private handleDeviceJoin;
    private handleDeviceLeft;
    /**
     * Adapter methods
     */
    start(): Promise<StartResult>;
    stop(): Promise<void>;
    onDriverClose(): Promise<void>;
    static isValidPath(path: string): Promise<boolean>;
    static autoDetectPath(): Promise<string>;
    getCoordinator(): Promise<Coordinator>;
    permitJoin(seconds: number, networkAddress: number): Promise<void>;
    getCoordinatorVersion(): Promise<CoordinatorVersion>;
    addInstallCode(ieeeAddress: string, key: Buffer): Promise<void>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    lqi(networkAddress: number): Promise<LQI>;
    routingTable(networkAddress: number): Promise<RoutingTable>;
    nodeDescriptor(networkAddress: number): Promise<NodeDescriptor>;
    private nodeDescriptorInternal;
    activeEndpoints(networkAddress: number): Promise<ActiveEndpoints>;
    simpleDescriptor(networkAddress: number, endpointID: number): Promise<SimpleDescriptor>;
    sendZclFrameToEndpoint(ieeeAddr: string, networkAddress: number, endpoint: number, zclFrame: Zcl.Frame, timeout: number, disableResponse: boolean, disableRecovery: boolean, sourceEndpoint?: number): Promise<Events.ZclPayload>;
    private sendZclFrameToEndpointInternal;
    sendZclFrameToGroup(groupID: number, zclFrame: Zcl.Frame): Promise<void>;
    sendZclFrameToAll(endpoint: number, zclFrame: Zcl.Frame, sourceEndpoint: number, destination: BroadcastAddress): Promise<void>;
    bind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint?: number): Promise<void>;
    unbind(destinationNetworkAddress: number, sourceIeeeAddress: string, sourceEndpoint: number, clusterID: number, destinationAddressOrGroup: string | number, type: 'endpoint' | 'group', destinationEndpoint: number): Promise<void>;
    removeDevice(networkAddress: number, ieeeAddr: string): Promise<void>;
    getNetworkParameters(): Promise<NetworkParameters>;
    supportsBackup(): Promise<boolean>;
    backup(): Promise<Models.Backup>;
    restoreChannelInterPAN(): Promise<void>;
    private checkInterpanLock;
    sendZclFrameInterPANToIeeeAddr(zclFrame: Zcl.Frame, ieeeAddr: string): Promise<void>;
    sendZclFrameInterPANBroadcast(zclFrame: Zcl.Frame, timeout: number): Promise<Events.ZclPayload>;
    changeChannel(newChannel: number): Promise<void>;
    setTransmitPower(value: number): Promise<void>;
    setChannelInterPAN(channel: number): Promise<void>;
    private waitForInternal;
    waitFor(networkAddress: number, endpoint: number, frameType: Zcl.FrameType, direction: Zcl.Direction, transactionSequenceNumber: number, clusterID: number, commandIdentifier: number, timeout: number): {
        promise: Promise<Events.ZclPayload>;
        cancel: () => void;
    };
    private waitressTimeoutFormatter;
    private waitressValidator;
}
export default EZSPAdapter;
//# sourceMappingURL=ezspAdapter.d.ts.map