/*
 * Decompiled with CFR 0.152.
 */
package zext.plantuml.com.ctreber.acearth.plugins.markers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.List;
import zext.plantuml.com.ctreber.acearth.gui.PixelCanvas;
import zext.plantuml.com.ctreber.acearth.projection.Projection;
import zext.plantuml.com.ctreber.acearth.projection.ProjectionOrtho;
import zext.plantuml.com.ctreber.acearth.util.Coordinate;
import zext.plantuml.com.ctreber.acearth.util.Point2D;
import zext.plantuml.com.ctreber.acearth.util.Point3D;
import zext.plantuml.com.ctreber.acearth.util.StringParser;

public class Marker {
    private static final int MARKER_SIZE = 4;
    private static final int MarkerAlignDefault = 0;
    private static final int MarkerAlignLeft = 1;
    private static final int MarkerAlignRight = 2;
    private static final int MarkerAlignAbove = 3;
    private static final int MarkerAlignBelow = 4;
    private Coordinate fCoordinate;
    private String fLabel;
    private int fAlign;

    private Marker(Coordinate pCoordinate, String pLabel, int pAlign) {
        this.fCoordinate = pCoordinate;
        this.fLabel = pLabel;
        this.fAlign = pAlign;
    }

    private static Marker createFromLine(String pLine) {
        Coordinate lPos;
        List lWords = StringParser.parse(pLine);
        double lLat = Double.parseDouble((String)lWords.get(0));
        double lLong = Double.parseDouble((String)lWords.get(1));
        String lLabel = (String)lWords.get(2);
        int lAlign = 0;
        if (lWords.size() >= 4) {
            String lAlignString = (String)lWords.get(3);
            if (lAlignString.equalsIgnoreCase("left")) {
                lAlign = 1;
            }
            if (lAlignString.equalsIgnoreCase("right")) {
                lAlign = 2;
            }
            if (lAlignString.equalsIgnoreCase("above")) {
                lAlign = 3;
            }
            if (lAlignString.equalsIgnoreCase("below")) {
                lAlign = 4;
            }
        }
        if (!(lPos = new Coordinate(lLat, lLong)).check()) {
            return null;
        }
        return new Marker(lPos, lLabel, lAlign);
    }

    public String toString() {
        return this.fLabel + " (" + this.fCoordinate + "), align: " + this.fAlign;
    }

    public void render(PixelCanvas pCanvas, Projection pProjection) {
        Point3D lPos = pProjection.rotate(this.fCoordinate.getPoint3D());
        if (pProjection instanceof ProjectionOrtho && lPos.getZ() <= 0.0) {
            return;
        }
        Point2D lPoint = pProjection.finalize(pProjection.project2D(lPos));
        int lX = (int)lPoint.getX();
        int lY = (int)lPoint.getY();
        Graphics2D g2d = pCanvas.getGraphics2D();
        g2d.setColor(Color.red);
        g2d.drawOval(lX, lY, 4, 4);
        if (this.fLabel != null) {
            switch (this.fAlign) {
                case 1: {
                    break;
                }
                case 0: 
                case 2: {
                    g2d.setFont(new Font("", 0, 9));
                    g2d.drawString(this.fLabel, lX + 4 + 1, lY + 2);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    public static Marker loadMarkerFile(String line) {
        return Marker.createFromLine(line);
    }
}

