'''OpenGL extension OES.shader_multisample_interpolation

This module customises the behaviour of the 
OpenGL.raw.GLES2.OES.shader_multisample_interpolation to provide a more 
Python-friendly API

Overview (from the spec)
	
	In standard multisample rendering, an implementation is allowed to
	assign the same sets of fragment shader input values to each sample.
	This can cause aliasing where the fragment shader input values are
	used to generate a result that doesn't antialias itself, for example
	with alpha-tested transparency.
	
	This extension adds the "sample" qualifier that can be used on vertex
	outputs and fragment inputs. When the "sample" qualifier is used, the
	fragment shader is invoked separately for each covered sample and
	all such qualified interpolants must be evaluated at the corresponding
	sample point.
	
	This extension provides built-in fragment shader functions to provide
	fine-grained control over interpolation, including interpolating a
	fragment shader input at a programmable offset relative to the pixel
	center, a specific sample number, or at the centroid.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/OES/shader_multisample_interpolation.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.OES.shader_multisample_interpolation import *
from OpenGL.raw.GLES2.OES.shader_multisample_interpolation import _EXTENSION_NAME

def glInitShaderMultisampleInterpolationOES():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION