
#ifndef KWAYLANDCLIENT_EXPORT_H
#define KWAYLANDCLIENT_EXPORT_H

#ifdef KWAYLANDCLIENT_STATIC_DEFINE
#  define KWAYLANDCLIENT_EXPORT
#  define KWAYLANDCLIENT_NO_EXPORT
#else
#  ifndef KWAYLANDCLIENT_EXPORT
#    ifdef KWaylandClient_EXPORTS
        /* We are building this library */
#      define KWAYLANDCLIENT_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KWAYLANDCLIENT_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KWAYLANDCLIENT_NO_EXPORT
#    define KWAYLANDCLIENT_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KWAYLANDCLIENT_DECL_DEPRECATED
#  define KWAYLANDCLIENT_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KWAYLANDCLIENT_DECL_DEPRECATED_EXPORT
#  define KWAYLANDCLIENT_DECL_DEPRECATED_EXPORT KWAYLANDCLIENT_EXPORT KWAYLANDCLIENT_DECL_DEPRECATED
#endif

#ifndef KWAYLANDCLIENT_DECL_DEPRECATED_NO_EXPORT
#  define KWAYLANDCLIENT_DECL_DEPRECATED_NO_EXPORT KWAYLANDCLIENT_NO_EXPORT KWAYLANDCLIENT_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KWAYLANDCLIENT_NO_DEPRECATED
#    define KWAYLANDCLIENT_NO_DEPRECATED
#  endif
#endif
#include <kwayland_version.h>

#define KWAYLANDCLIENT_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KWAYLANDCLIENT_NO_DEPRECATED)
#  undef KWAYLANDCLIENT_DEPRECATED
#  define KWAYLANDCLIENT_DEPRECATED_EXPORT KWAYLANDCLIENT_EXPORT
#  define KWAYLANDCLIENT_DEPRECATED_NO_EXPORT KWAYLANDCLIENT_NO_EXPORT
#elif defined(KWAYLANDCLIENT_NO_DEPRECATED_WARNINGS)
#  define KWAYLANDCLIENT_DEPRECATED
#  define KWAYLANDCLIENT_DEPRECATED_EXPORT KWAYLANDCLIENT_EXPORT
#  define KWAYLANDCLIENT_DEPRECATED_NO_EXPORT KWAYLANDCLIENT_NO_EXPORT
#else
#  define KWAYLANDCLIENT_DEPRECATED KWAYLANDCLIENT_DECL_DEPRECATED
#  define KWAYLANDCLIENT_DEPRECATED_EXPORT KWAYLANDCLIENT_DECL_DEPRECATED_EXPORT
#  define KWAYLANDCLIENT_DEPRECATED_NO_EXPORT KWAYLANDCLIENT_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KWAYLANDCLIENT_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KWAYLANDCLIENT_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KWAYLANDCLIENT_NO_DEPRECATED
#  define KWAYLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT KWAYLAND_VERSION
#endif
#ifdef KWAYLANDCLIENT_NO_DEPRECATED_WARNINGS
#  define KWAYLANDCLIENT_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KWAYLANDCLIENT_DEPRECATED_WARNINGS_SINCE
#  ifdef KWAYLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KWAYLANDCLIENT_DEPRECATED_WARNINGS_SINCE KWAYLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KWAYLANDCLIENT_DEPRECATED_WARNINGS_SINCE KWAYLAND_VERSION
#  endif
#endif

#ifndef KWAYLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KWAYLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KWAYLANDCLIENT_DEPRECATED
#  define KWAYLANDCLIENT_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KWAYLANDCLIENT_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KWAYLANDCLIENT_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KWAYLANDCLIENT_EXPORT_H */
