/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.TextDetail;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class MatchingObject
implements Comparable<MatchingObject>,
Selectable {
    public static final String PROP_INVALIDITY_STATUS = "invalidityStatus";
    public static final String PROP_MATCHES_SELECTED = "matchesSelected";
    public static final String PROP_SELECTED = "selected";
    public static final String PROP_REMOVED = "removed";
    public static final String PROP_CHILD_REMOVED = "child_removed";
    private static final Logger LOG = Logger.getLogger(MatchingObject.class.getName());
    private static final int FILE_READ_BUFFER_SIZE = 4096;
    private final ResultModel resultModel;
    private FileObject fileObject;
    private DataObject dataObject;
    private long timestamp;
    private int matchesCount = 0;
    private Node nodeDelegate = null;
    List<TextDetail> textDetails;
    private Charset charset;
    private boolean selected = true;
    private boolean expanded = false;
    private int selectedMatchesCount = 0;
    private boolean valid = true;
    private boolean refreshed = false;
    private InvalidityStatus invalidityStatus = null;
    private StringBuilder text;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private FileListener fileListener;
    private final MatchSelectionListener matchSelectionListener = new MatchSelectionListener();
    private static final boolean REALLY_WRITE = true;

    MatchingObject(ResultModel resultModel, FileObject fileObject, Charset charset, List<TextDetail> list) {
        if (resultModel == null) {
            throw new IllegalArgumentException("resultModel = null");
        }
        if (fileObject == null) {
            throw new IllegalArgumentException("object = null");
        }
        this.textDetails = list;
        this.resultModel = resultModel;
        this.charset = charset;
        this.fileObject = fileObject;
        this.dataObject = this.dataObject();
        this.timestamp = fileObject.lastModified().getTime();
        boolean bl = this.valid = this.timestamp != 0L;
        if (this.dataObject != null) {
            this.matchesCount = this.computeMatchesCount();
            this.nodeDelegate = this.dataObject.getNodeDelegate();
        }
        this.setUpDataObjValidityChecking();
        if (list != null && !list.isEmpty()) {
            this.adjustTextDetails();
        }
    }

    private void adjustTextDetails() {
        TextDetail textDetail = this.textDetails.get(this.textDetails.size() - 1);
        int n = textDetail.getLine();
        int n2 = this.countDigits(n);
        for (TextDetail textDetail2 : this.textDetails) {
            ++this.selectedMatchesCount;
            int n3 = this.countDigits(textDetail2.getLine());
            if (n3 < n2) {
                textDetail2.setLineNumberIndent(this.indent(n2 - n3));
            }
            textDetail2.addChangeListener(this.matchSelectionListener);
        }
    }

    private int countDigits(int n) {
        int n2 = 0;
        while (n > 0) {
            n /= 10;
            ++n2;
        }
        return n2;
    }

    private String indent(int n) {
        switch (n) {
            case 1: {
                return "&nbsp;&nbsp;";
            }
            case 2: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            case 3: {
                return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("&nbsp;&nbsp;");
        }
        return stringBuilder.toString();
    }

    private void setUpDataObjValidityChecking() {
        if (this.fileObject != null && this.fileObject.isValid()) {
            this.fileListener = new FileListener();
            this.fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
        }
    }

    void cleanup() {
        if (this.fileObject != null && this.fileListener != null) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
            this.fileListener = null;
        }
        this.dataObject = null;
        this.nodeDelegate = null;
        this.changeSupport.firePropertyChange(PROP_REMOVED, null, null);
    }

    private void setInvalid(InvalidityStatus invalidityStatus) {
        if (this.invalidityStatus == invalidityStatus) {
            return;
        }
        InvalidityStatus invalidityStatus2 = this.invalidityStatus;
        this.valid = false;
        this.invalidityStatus = invalidityStatus;
        if (this.fileObject != null && this.fileListener != null && invalidityStatus == InvalidityStatus.DELETED) {
            this.fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
        }
        this.changeSupport.firePropertyChange(PROP_INVALIDITY_STATUS, (Object)invalidityStatus2, (Object)invalidityStatus);
    }

    public boolean isObjectValid() {
        return this.valid && this.dataObject != null ? this.dataObject.isValid() : false;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public void setSelected(boolean bl) {
        if (bl == this.selected) {
            return;
        }
        this.selected = bl;
        this.changeSupport.firePropertyChange(PROP_SELECTED, !bl, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectedRecursively(boolean bl) {
        if (this.selected == bl) {
            return;
        }
        this.matchSelectionListener.setEnabled(false);
        int n = this.selectedMatchesCount;
        try {
            if (this.textDetails != null) {
                for (TextDetail textDetail : this.getTextDetails()) {
                    textDetail.setSelectedRecursively(bl);
                }
            }
            this.setSelected(bl);
            this.selectedMatchesCount = bl ? this.getTextDetails().size() : 0;
            this.changeSupport.firePropertyChange(PROP_MATCHES_SELECTED, n, this.selectedMatchesCount);
        }
        finally {
            this.matchSelectionListener.setEnabled(true);
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    void markExpanded(boolean bl) {
        this.expanded = bl;
    }

    boolean isExpanded() {
        return this.expanded;
    }

    String getName() {
        return this.getFileObject().getNameExt();
    }

    String getHtmlDisplayName() {
        return this.getFileObject().getNameExt();
    }

    long getTimestamp() {
        return this.timestamp;
    }

    String getDescription() {
        return this.getFileObject().getParent().getPath();
    }

    String getText() throws IOException {
        StringBuilder stringBuilder = this.text(false);
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public List<TextDetail> getTextDetails() {
        return this.textDetails;
    }

    public int getDetailsCount() {
        if (this.textDetails == null) {
            return 0;
        }
        return this.textDetails.size();
    }

    public Node[] getDetails() {
        if (this.textDetails == null) {
            return null;
        }
        ArrayList<TextDetail.DetailNode> arrayList = new ArrayList<TextDetail.DetailNode>(this.textDetails.size());
        for (TextDetail textDetail : this.textDetails) {
            arrayList.add(new TextDetail.DetailNode(textDetail, false, this));
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public Children getDetailsChildren(boolean bl) {
        return new DetailsChildren(bl, this.resultModel);
    }

    FileLock lock() throws IOException {
        return this.getFileObject().lock();
    }

    StringBuilder text(boolean bl) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (bl || this.text == null) {
            if (this.charset == null) {
                this.text = new StringBuilder(this.getFileObject().asText());
            } else {
                this.text = new StringBuilder();
                CharsetDecoder charsetDecoder = this.charset.newDecoder();
                try (InputStream inputStream = this.getFileObject().getInputStream();
                     InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charsetDecoder);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 4096);){
                    int n;
                    char[] cArray = new char[4096];
                    while ((n = bufferedReader.read(cArray)) != -1) {
                        this.text.append(cArray, 0, n);
                    }
                }
            }
        }
        return this.text;
    }

    @Override
    public int compareTo(MatchingObject matchingObject) {
        if (matchingObject == null) {
            return Integer.MAX_VALUE;
        }
        return this.getName().compareToIgnoreCase(matchingObject.getName());
    }

    private DataObject dataObject() {
        try {
            return DataObject.find((FileObject)this.fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            this.valid = false;
            return null;
        }
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    InvalidityStatus checkValidity() {
        InvalidityStatus invalidityStatus = this.invalidityStatus;
        InvalidityStatus invalidityStatus2 = this.getFreshInvalidityStatus();
        if (invalidityStatus2 != null) {
            this.valid = false;
            this.invalidityStatus = invalidityStatus2;
        }
        if (invalidityStatus != this.invalidityStatus) {
            this.changeSupport.firePropertyChange(PROP_INVALIDITY_STATUS, (Object)invalidityStatus, (Object)this.invalidityStatus);
        }
        return invalidityStatus2;
    }

    public InvalidityStatus getInvalidityStatus() {
        return this.invalidityStatus;
    }

    String getInvalidityDescription() {
        InvalidityStatus invalidityStatus = this.getFreshInvalidityStatus();
        String string = invalidityStatus != null ? invalidityStatus.getDescription(this.getFileObject().getPath()) : null;
        return string;
    }

    private InvalidityStatus getFreshInvalidityStatus() {
        this.log(Level.FINER, "getInvalidityStatus()");
        FileObject fileObject = this.getFileObject();
        if (!fileObject.isValid()) {
            this.log(Level.FINEST, " - DELETED");
            return InvalidityStatus.DELETED;
        }
        if (fileObject.isFolder()) {
            this.log(Level.FINEST, " - BECAME_DIR");
            return InvalidityStatus.BECAME_DIR;
        }
        long l = fileObject.lastModified().getTime();
        if (!this.refreshed && l > this.resultModel.getStartTime() || this.refreshed && l > this.timestamp) {
            this.log(Level.SEVERE, "file's timestamp changed since start of the search");
            if (LOG.isLoggable(Level.FINEST)) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                this.log(Level.FINEST, " - file stamp:           " + l + " (" + calendar.getTime() + ')');
                calendar.setTimeInMillis(this.resultModel.getStartTime());
                this.log(Level.FINEST, " - result model created: " + this.resultModel.getStartTime() + " (" + calendar.getTime() + ')');
            }
            return InvalidityStatus.CHANGED;
        }
        if (fileObject.getSize() > Integer.MAX_VALUE) {
            return InvalidityStatus.TOO_BIG;
        }
        if (!fileObject.canRead()) {
            return InvalidityStatus.CANT_READ;
        }
        return null;
    }

    boolean isValid() {
        return this.valid;
    }

    public void updateDataObject(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.dataObject == null || this.dataObject.getPrimaryFile().equals(fileObject)) {
            if (fileObject.isValid()) {
                this.invalidityStatus = null;
                if (this.fileListener == null) {
                    this.fileListener = new FileListener();
                    fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
                } else if (fileObject != this.dataObject.getPrimaryFile()) {
                    this.dataObject.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.fileListener);
                    fileObject.addFileChangeListener((FileChangeListener)this.fileListener);
                }
                this.dataObject = dataObject;
                this.nodeDelegate = dataObject.getNodeDelegate();
                this.valid = true;
                for (TextDetail textDetail : this.textDetails) {
                    textDetail.updateDataObject(dataObject);
                }
            }
        } else {
            throw new IllegalArgumentException("Expected data object for the same file");
        }
    }

    public InvalidityStatus replace() throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (this.isSelected());
        StringBuilder stringBuilder = this.text(true);
        List<TextDetail> list = this.getTextDetails();
        int n = 0;
        for (TextDetail textDetail : list) {
            n += textDetail.isSelected() ? 1 : 0;
        }
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            TextDetail textDetail = list.get(i);
            if (!textDetail.isSelected()) continue;
            String string = stringBuilder.substring(textDetail.getStartOffset() + n2, textDetail.getEndOffset() + n2);
            if (!string.equals(textDetail.getMatchedText())) {
                this.log(Level.SEVERE, "file match part differs from the expected match");
                if (LOG.isLoggable(Level.FINEST)) {
                    this.log(Level.SEVERE, " - expected line: \"" + textDetail.getMatchedText() + '\"');
                    this.log(Level.SEVERE, " - file line:     \"" + string + '\"');
                }
                return InvalidityStatus.CHANGED;
            }
            String string2 = this.resultModel.basicCriteria.getReplaceExpr();
            if (this.resultModel.basicCriteria.getSearchPattern().isRegExp()) {
                Matcher matcher = this.resultModel.basicCriteria.getTextPattern().matcher(string);
                string2 = matcher.replaceFirst(this.resultModel.basicCriteria.getReplaceString());
            } else if (this.resultModel.basicCriteria.isPreserveCase()) {
                string2 = MatchingObject.adaptCase(string2, string);
            }
            stringBuilder.replace(textDetail.getStartOffset() + n2, textDetail.getEndOffset() + n2, string2);
            n2 += string2.length() - string.length();
        }
        return null;
    }

    public static String adaptCase(String string, String string2) {
        if (string2.equals(string2.toUpperCase())) {
            return string.toUpperCase();
        }
        if (string2.equals(string2.toLowerCase())) {
            return string.toLowerCase();
        }
        if (Character.isUpperCase(string2.charAt(0))) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        if (Character.isLowerCase(string2.charAt(0))) {
            if (string2.substring(1).equals(string2.substring(1).toUpperCase())) {
                return Character.toLowerCase(string.charAt(0)) + string.substring(1).toUpperCase();
            }
            return Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    void write(FileLock fileLock) throws IOException {
        if (this.text == null) {
            throw new IllegalStateException("Buffer is gone");
        }
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.fileObject.getOutputStream(fileLock), this.charset);){
            outputStreamWriter.write(this.makeStringToWrite());
        }
    }

    private String makeStringToWrite() {
        return MatchingObject.makeStringToWrite(this.text);
    }

    static String makeStringToWrite(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }

    private void log(Level level, String string) {
        String string2;
        String string3 = string2 = this.dataObject != null ? this.dataObject.getName() : this.fileObject.toString();
        if (LOG.isLoggable(level)) {
            LOG.log(level, "{0}: {1}", new Object[]{string2, string});
        }
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MatchingObject matchingObject = (MatchingObject)object;
        if (this.resultModel == matchingObject.resultModel || this.resultModel != null && this.resultModel.equals(matchingObject.resultModel)) {
            return this.fileObject == matchingObject.fileObject || this.fileObject != null && this.fileObject.equals(matchingObject.fileObject);
        }
        return false;
    }

    public int hashCode() {
        int n = 3;
        n = 73 * n + (this.fileObject != null ? this.fileObject.hashCode() : 0);
        n = 73 * n + (this.resultModel != null ? this.resultModel.hashCode() : 0);
        return n;
    }

    private int computeMatchesCount() {
        return this.resultModel.getDetailsCount(this);
    }

    String getFileDisplayName() {
        return FileUtil.getFileDisplayName((FileObject)this.fileObject);
    }

    int getMatchesCount() {
        return this.matchesCount;
    }

    Node getNodeDelegate() {
        return this.nodeDelegate;
    }

    public void removeDetail(TextDetail textDetail) {
        boolean bl = this.textDetails.remove(textDetail);
        if (bl) {
            this.matchesCount = this.getDetailsCount();
            this.resultModel.removeDetailMatch(this, textDetail);
            this.changeSupport.firePropertyChange(PROP_CHILD_REMOVED, null, null);
        }
    }

    public void remove() {
        this.resultModel.remove(this);
    }

    public void refresh(Def def) {
        this.refreshed = true;
        this.charset = def.getCharset();
        FileObject fileObject = this.fileObject;
        this.fileObject = def.getFileObject();
        this.textDetails = def.getTextDetails();
        this.dataObject = this.dataObject();
        this.timestamp = this.fileObject.lastModified().getTime();
        boolean bl = this.valid = this.timestamp != 0L;
        if (this.dataObject == null) {
            return;
        }
        if (this.fileObject != fileObject) {
            if (this.fileListener != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this.fileListener);
            }
            this.setUpDataObjValidityChecking();
        }
        this.nodeDelegate = this.dataObject.getNodeDelegate();
        Mutex.EVENT.writeAccess(() -> {
            int n = this.selectedMatchesCount;
            this.selectedMatchesCount = 0;
            if (this.textDetails != null && !this.textDetails.isEmpty()) {
                this.adjustTextDetails();
            }
            this.changeSupport.firePropertyChange(PROP_MATCHES_SELECTED, n, this.selectedMatchesCount);
            if (this.matchesCount > 0) {
                this.setSelected(true);
            }
            InvalidityStatus invalidityStatus = this.invalidityStatus;
            this.invalidityStatus = null;
            this.changeSupport.firePropertyChange(PROP_INVALIDITY_STATUS, (Object)invalidityStatus, (Object)this.invalidityStatus);
        });
    }

    public BasicComposition getBasicComposition() {
        return this.resultModel.basicComposition;
    }

    private class MatchSelectionListener
    implements ChangeListener {
        private boolean enabled = true;

        private MatchSelectionListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (this.enabled) {
                TextDetail textDetail = (TextDetail)changeEvent.getSource();
                int n = MatchingObject.this.selectedMatchesCount;
                MatchingObject.this.selectedMatchesCount = MatchingObject.this.selectedMatchesCount + (textDetail.isSelected() ? 1 : -1);
                MatchingObject.this.changeSupport.firePropertyChange(MatchingObject.PROP_MATCHES_SELECTED, n, MatchingObject.this.selectedMatchesCount);
                if (MatchingObject.this.selected && MatchingObject.this.selectedMatchesCount == 0) {
                    MatchingObject.this.setSelected(false);
                } else if (!MatchingObject.this.selected && MatchingObject.this.selectedMatchesCount > 0) {
                    MatchingObject.this.setSelected(true);
                }
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    private class FileListener
    extends FileChangeAdapter {
        private FileListener() {
        }

        public void fileDeleted(FileEvent fileEvent) {
            MatchingObject.this.setInvalid(InvalidityStatus.DELETED);
        }

        public void fileChanged(FileEvent fileEvent) {
            if (((MatchingObject)MatchingObject.this).resultModel.basicCriteria.isSearchAndReplace()) {
                MatchingObject.this.setInvalid(InvalidityStatus.CHANGED);
            }
        }
    }

    private class DetailsChildren
    extends Children.Keys<TextDetail> {
        private final boolean replacing;

        public DetailsChildren(boolean bl, ResultModel resultModel) {
            this.replacing = bl;
            this.setKeys(MatchingObject.this.getTextDetails());
            MatchingObject.this.addPropertyChangeListener(MatchingObject.PROP_CHILD_REMOVED, propertyChangeEvent -> this.update());
        }

        protected Node[] createNodes(TextDetail textDetail) {
            return new Node[]{new TextDetail.DetailNode(textDetail, this.replacing, MatchingObject.this)};
        }

        public void update() {
            this.setKeys(MatchingObject.this.getTextDetails());
        }
    }

    public static class Def {
        private FileObject fileObject;
        private Charset charset;
        private List<TextDetail> textDetails;

        public Def(FileObject fileObject, Charset charset, List<TextDetail> list) {
            this.fileObject = fileObject;
            this.charset = charset;
            this.textDetails = list;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public void setFileObject(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public List<TextDetail> getTextDetails() {
            return this.textDetails;
        }

        public void setTextDetails(List<TextDetail> list) {
            this.textDetails = list;
        }
    }

    public static enum InvalidityStatus {
        DELETED(true, "Inv_status_Err_deleted"),
        BECAME_DIR(true, "Inv_status_Err_became_dir"),
        CHANGED(false, "Inv_status_Err_changed"),
        TOO_BIG(false, "Inv_status_Err_too_big"),
        CANT_READ(false, "Inv_status_Err_cannot_read");

        private final boolean fatal;
        private final String descrBundleKey;

        private InvalidityStatus(boolean bl, String string2) {
            this.fatal = bl;
            this.descrBundleKey = string2;
        }

        boolean isFatal() {
            return this.fatal;
        }

        String getDescription(String string) {
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)this.descrBundleKey, (Object)string);
        }
    }
}

