/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.ArgReceiver;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandResultBaseInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceiveKeywordsInstr
extends NoOperandResultBaseInstr
implements ArgReceiver {
    final boolean hasRestArg;
    final boolean acceptsKeywords;

    public ReceiveKeywordsInstr(Variable result2, boolean hasRestArg, boolean acceptsKeywords) {
        super(Operation.RECV_KW, result2);
        this.hasRestArg = hasRestArg;
        this.acceptsKeywords = acceptsKeywords;
    }

    public boolean hasRestArg() {
        return this.hasRestArg;
    }

    public boolean acceptsKeywords() {
        return this.acceptsKeywords;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.hasRestArg);
        e.encode(this.acceptsKeywords);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ReceiveKeywordsInstr(ii.getRenamedVariable(this.result), this.hasRestArg, this.acceptsKeywords);
    }

    public static ReceiveKeywordsInstr decode(IRReaderDecoder d) {
        return new ReceiveKeywordsInstr(d.decodeVariable(), d.decodeBoolean(), d.decodeBoolean());
    }

    @Override
    public IRubyObject receiveArg(ThreadContext context, IRubyObject self2, DynamicScope currDynScope, StaticScope currScope, Object[] temp, IRubyObject[] args2, boolean ruby2keywords) {
        return IRRuntimeHelpers.receiveKeywords(context, args2, this.hasRestArg, this.acceptsKeywords, ruby2keywords);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceiveKeywordsInstr(this);
    }
}

