/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="entrySet().toArray()")
@ApiStatus.NonExtendable
public class MultiMap<K, V>
implements Serializable {
    private static final MultiMap<?, ?> EMPTY = new EmptyMap();
    private static final long serialVersionUID = -2632269270151455493L;
    protected final Map<K, Collection<V>> myMap;
    private Collection<V> values;

    public MultiMap() {
        this.myMap = new HashMap<K, Collection<V>>();
    }

    public MultiMap(@NotNull Map<K, Collection<V>> map) {
        if (map == null) {
            MultiMap.$$$reportNull$$$0(0);
        }
        this.myMap = map;
    }

    @NotNull
    protected Collection<V> createCollection() {
        return new ArrayList();
    }

    @NotNull
    protected Collection<V> createEmptyCollection() {
        List list = Collections.emptyList();
        if (list == null) {
            MultiMap.$$$reportNull$$$0(2);
        }
        return list;
    }

    public final void putValues(K key, @NotNull Collection<? extends V> values2) {
        if (values2 == null) {
            MultiMap.$$$reportNull$$$0(6);
        }
        this.getModifiable(key).addAll(values2);
    }

    public final void putValue(@Nullable K key, V value2) {
        this.getModifiable(key).add(value2);
    }

    @NotNull
    public final Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myMap.entrySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(7);
        }
        return set;
    }

    @NotNull
    public final Collection<V> get(K key) {
        Collection<V> collection = this.myMap.get(key);
        Collection<V> collection2 = collection == null ? this.createEmptyCollection() : collection;
        if (collection2 == null) {
            MultiMap.$$$reportNull$$$0(10);
        }
        return collection2;
    }

    @NotNull
    public final Collection<V> getModifiable(K key) {
        Collection collection = this.myMap.computeIfAbsent(key, __ -> this.createCollection());
        if (collection == null) {
            MultiMap.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public final Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            MultiMap.$$$reportNull$$$0(13);
        }
        return set;
    }

    public boolean remove(K key, V value2) {
        Collection<V> values2 = this.myMap.get(key);
        if (values2 == null) {
            return false;
        }
        boolean removed = values2.remove(value2);
        if (values2.isEmpty()) {
            this.myMap.remove(key);
        }
        return removed;
    }

    public final void clear() {
        this.myMap.clear();
    }

    @Nullable
    public final Collection<V> remove(K key) {
        return this.myMap.remove(key);
    }

    @NotNull
    public static <K, V> MultiMap<K, V> create() {
        return new MultiMap<K, V>();
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinked() {
        return new MultiMap(new LinkedHashMap());
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createLinkedSet() {
        return new MultiMap<K, V>((Map)new LinkedHashMap()){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new LinkedHashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$2", "createEmptyCollection"));
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createConcurrent() {
        return new MultiMap<K, V>((Map)new ConcurrentHashMap()){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                List list = ContainerUtil.createLockFreeCopyOnWriteList();
                if (list == null) {
                    4.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$4", "createCollection"));
            }
        };
    }

    @NotNull
    public static <K, V> MultiMap<K, V> createSet() {
        return new MultiMap<K, V>(){

            @Override
            @NotNull
            protected Collection<V> createCollection() {
                return new HashSet();
            }

            @Override
            @NotNull
            protected Collection<V> createEmptyCollection() {
                Set set = Collections.emptySet();
                if (set == null) {
                    6.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/MultiMap$6", "createEmptyCollection"));
            }
        };
    }

    public final boolean equals(Object o) {
        return this == o || o instanceof MultiMap && this.myMap.equals(((MultiMap)o).myMap);
    }

    public final int hashCode() {
        return this.myMap.hashCode();
    }

    public final String toString() {
        return this.myMap.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCopy";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/MultiMap";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/MultiMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCollection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toHashMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "freezeValues";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrPut";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putAllValues";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putValues";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class EmptyMap
    extends MultiMap<Object, Object> {
        private EmptyMap() {
            super(Collections.emptyMap());
        }
    }
}

