/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantExplicitTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isSame", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "other", "Lorg/jetbrains/kotlin/name/ClassId;", "hasSameNameWithoutModifiers", "name", "Lorg/jetbrains/kotlin/name/Name;", "checkers"})
@SourceDebugExtension(value={"SMAP\nRedundantExplicitTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantExplicitTypeChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantExplicitTypeChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class RedundantExplicitTypeChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final RedundantExplicitTypeChecker INSTANCE = new RedundantExplicitTypeChecker();

    private RedundantExplicitTypeChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (!declaration.isLocal()) {
            return;
        }
        if (declaration.getReturnTypeRef().getSource() == null) {
            return;
        }
        FirExpression firExpression = declaration.getInitializer();
        if (firExpression == null) {
            return;
        }
        FirExpression initializer = firExpression;
        FirTypeRef it = firTypeRef = declaration.getReturnTypeRef();
        boolean bl = false;
        if (it instanceof FirErrorTypeRef) return;
        FirTypeRef firTypeRef2 = firTypeRef;
        if (firTypeRef2 == null) {
            return;
        }
        FirTypeRef typeReference = firTypeRef2;
        KtSourceElement ktSourceElement = typeReference.getSource();
        if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
            return;
        }
        ConeKotlinType type2 = FirTypeUtilsKt.getConeType(typeReference);
        if (TypeUtilsKt.toSymbol(type2, context.getSession()) instanceof FirTypeAliasSymbol) {
            return;
        }
        if (!((Collection)typeReference.getAnnotations()).isEmpty()) {
            return;
        }
        boolean bl2 = false;
        if (bl2) {
            return;
        }
        FirExpression firExpression2 = initializer;
        if (firExpression2 instanceof FirLiteralExpression) {
            IElementType iElementType;
            KtSourceElement ktSourceElement2 = ((FirLiteralExpression)initializer).getSource();
            IElementType iElementType2 = iElementType = ktSourceElement2 != null ? ktSourceElement2.getElementType() : null;
            if (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getBoolean())) {
                    return;
                }
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
                if (Intrinsics.areEqual(((FirLiteralExpression)initializer).getKind(), ConstantValueKind.Long.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getLong()) : !this.isSame(type2, StandardClassIds.INSTANCE.getInt())) {
                    return;
                }
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
                if (Intrinsics.areEqual(((FirLiteralExpression)initializer).getKind(), ConstantValueKind.Float.INSTANCE) ? !this.isSame(type2, StandardClassIds.INSTANCE.getFloat()) : !this.isSame(type2, StandardClassIds.INSTANCE.getDouble())) {
                    return;
                }
            } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CHARACTER_CONSTANT)) {
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getChar())) {
                    return;
                }
            } else {
                if (!Intrinsics.areEqual(iElementType, KtNodeTypes.STRING_TEMPLATE)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        } else if (firExpression2 instanceof FirFunctionCall) {
            if (!this.hasSameNameWithoutModifiers(type2, ((FirFunctionCall)initializer).getCalleeReference().getName())) {
                return;
            }
        } else {
            if (firExpression2 instanceof FirGetClassCall) {
                return;
            }
            if (firExpression2 instanceof FirResolvedQualifier) {
                if (!this.isSame(type2, ((FirResolvedQualifier)initializer).getClassId())) {
                    return;
                }
            } else {
                if (!(firExpression2 instanceof FirStringConcatenationCall)) return;
                if (!this.isSame(type2, StandardClassIds.INSTANCE.getString())) {
                    return;
                }
            }
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getREDUNDANT_EXPLICIT_TYPE(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean isSame(ConeKotlinType $this$isSame, ClassId other) {
        if ($this$isSame.getNullability().isNullable()) {
            return false;
        }
        return Intrinsics.areEqual(ConeTypeUtilsKt.getClassId($this$isSame.getType()), other);
    }

    private final boolean hasSameNameWithoutModifiers(ConeKotlinType $this$hasSameNameWithoutModifiers, Name name2) {
        return $this$hasSameNameWithoutModifiers instanceof ConeClassLikeType && Intrinsics.areEqual(((ConeClassLikeType)$this$hasSameNameWithoutModifiers).getLookupTag().getName(), name2) && $this$hasSameNameWithoutModifiers.getTypeArguments().length == 0 && !ConeTypeUtilsKt.isMarkedNullable($this$hasSameNameWithoutModifiers);
    }
}

