/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000eJ\b\u0010\u0014\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/StringBuilderWithLocations;", "", "<init>", "()V", "builder", "Ljava/lang/StringBuilder;", "value", "", "lineNumber", "getLineNumber", "()I", "columnNumber", "getColumnNumber", "append", "", "char", "", "text", "", "appendLine", "toString", "wasm.ir"})
public final class StringBuilderWithLocations {
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    private int lineNumber;
    private int columnNumber = -1;

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getColumnNumber() {
        return this.columnNumber;
    }

    public final void append(char c) {
        if (c == '\n') {
            this.appendLine();
        } else {
            this.builder.append(c);
        }
    }

    public final void append(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.builder.append(text);
        Object object = new char[]{'\n'};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)text, object, false, 0, 6, null);
        boolean bl = false;
        if (it.size() > 1) {
            this.columnNumber = -1;
        }
        char[] lines = object;
        this.lineNumber += lines.size() - 1;
        this.columnNumber += ((String)CollectionsKt.last(lines)).length();
    }

    public final void appendLine() {
        Intrinsics.checkNotNullExpressionValue(this.builder.append('\n'), "append(...)");
        ++this.lineNumber;
        this.columnNumber = -1;
    }

    @NotNull
    public String toString() {
        String string2 = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }
}

