/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.Device;
import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TextEmbeddingTranslator
implements Translator<String, float[]> {
    private static final int[] AXIS = new int[]{0};
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private boolean normalize;
    private String pooling;
    private boolean includeTokenTypes;
    private String dense;
    private String denseActivation;
    private String layerNorm;
    private NDList denseModel;
    private NDList layerNormModel;

    TextEmbeddingTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier, String pooling, boolean normalize, boolean includeTokenTypes, String dense, String denseActivation, String layerNorm) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
        this.pooling = pooling;
        this.normalize = normalize;
        this.includeTokenTypes = includeTokenTypes;
        this.dense = dense;
        this.denseActivation = denseActivation;
        this.layerNorm = layerNorm;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public void prepare(TranslatorContext ctx) throws Exception {
        InputStream is;
        Path file;
        NDManager manager = ctx.getPredictorManager().newSubManager(Device.cpu());
        if (this.dense != null) {
            file = Paths.get(this.dense, new String[0]);
            if (!file.isAbsolute()) {
                file = ctx.getModel().getModelPath().resolve(file);
            }
            if (Files.exists(file, new LinkOption[0])) {
                is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    this.denseModel = NDList.decode((NDManager)manager, (InputStream)is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
        if (this.layerNorm != null) {
            file = Paths.get(this.layerNorm, new String[0]);
            if (!file.isAbsolute()) {
                file = ctx.getModel().getModelPath().resolve(file);
            }
            if (Files.exists(file, new LinkOption[0])) {
                is = Files.newInputStream(file, new OpenOption[0]);
                try {
                    this.layerNormModel = NDList.decode((NDManager)manager, (InputStream)is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
        }
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        Encoding encoding = this.tokenizer.encode(input);
        ctx.setAttachment("encoding", (Object)encoding);
        return encoding.toNDList(ctx.getNDManager(), this.includeTokenTypes);
    }

    public NDList batchProcessInput(TranslatorContext ctx, List<String> inputs) {
        NDManager manager = ctx.getNDManager();
        Encoding[] encodings = this.tokenizer.batchEncode(inputs);
        ctx.setAttachment("encodings", (Object)encodings);
        NDList[] batch = new NDList[encodings.length];
        for (int i = 0; i < encodings.length; ++i) {
            batch[i] = encodings[i].toNDList(manager, this.includeTokenTypes);
        }
        return this.batchifier.batchify(batch);
    }

    public float[] processOutput(TranslatorContext ctx, NDList list) {
        Encoding encoding = (Encoding)ctx.getAttachment("encoding");
        NDManager manager = ctx.getNDManager();
        NDArray embeddings = this.processEmbedding(manager, list, encoding);
        return embeddings.toFloatArray();
    }

    public List<float[]> batchProcessOutput(TranslatorContext ctx, NDList list) {
        NDList[] batch = this.batchifier.unbatchify(list);
        Encoding[] encodings = (Encoding[])ctx.getAttachment("encodings");
        NDManager manager = ctx.getNDManager();
        ArrayList<float[]> ret = new ArrayList<float[]>(batch.length);
        for (int i = 0; i < batch.length; ++i) {
            NDArray array = this.processEmbedding(manager, batch[i], encodings[i]);
            ret.add(array.toFloatArray());
        }
        return ret;
    }

    private NDArray processEmbedding(NDManager manager, NDList list, Encoding encoding) {
        NDArray weight;
        NDArray embedding = list.get("last_hidden_state");
        if (embedding == null) {
            embedding = list.head();
        }
        long[] attentionMask = encoding.getAttentionMask();
        NDArray inputAttentionMask = manager.create(attentionMask).toType(DataType.FLOAT32, true);
        switch (this.pooling) {
            case "mean": {
                embedding = TextEmbeddingTranslator.meanPool(embedding, inputAttentionMask, false);
                break;
            }
            case "mean_sqrt_len": {
                embedding = TextEmbeddingTranslator.meanPool(embedding, inputAttentionMask, true);
                break;
            }
            case "max": {
                embedding = TextEmbeddingTranslator.maxPool(embedding, inputAttentionMask);
                break;
            }
            case "weightedmean": {
                embedding = TextEmbeddingTranslator.weightedMeanPool(embedding, inputAttentionMask);
                break;
            }
            case "cls": {
                embedding = embedding.get(new long[]{0L});
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected pooling mode: " + this.pooling));
            }
        }
        if (this.denseModel != null) {
            weight = this.denseModel.get("linear.weight");
            NDArray bias = this.denseModel.get("linear.bias");
            embedding = (NDArray)embedding.getNDArrayInternal().linear(embedding, weight, bias).get(0);
            if ("Tanh".equalsIgnoreCase(this.denseActivation)) {
                embedding = embedding.tanh();
            }
        }
        if (this.layerNormModel != null) {
            weight = this.layerNormModel.get("norm.weight");
            NDArray bias = this.layerNormModel.get("norm.bias");
            Shape shape = weight.getShape();
            embedding = (NDArray)embedding.getNDArrayInternal().layerNorm(embedding, shape, weight, bias, 1.0E-5f).get(0);
        }
        if (this.normalize) {
            embedding = embedding.normalize(2.0, 0L);
        }
        return embedding;
    }

    private static NDArray meanPool(NDArray embeddings, NDArray attentionMask, boolean sqrt) {
        long[] shape = embeddings.getShape().getShape();
        attentionMask = attentionMask.expandDims(-1).broadcast(shape);
        NDArray inputAttentionMaskSum = attentionMask.sum(AXIS);
        NDArray clamp = inputAttentionMaskSum.clip((Number)Float.valueOf(1.0E-9f), (Number)Float.valueOf(1.0E12f));
        NDArray prod = embeddings.mul(attentionMask);
        NDArray sum = prod.sum(AXIS);
        if (sqrt) {
            return sum.div(clamp.sqrt());
        }
        return sum.div(clamp);
    }

    private static NDArray maxPool(NDArray embeddings, NDArray inputAttentionMask) {
        long[] shape = embeddings.getShape().getShape();
        inputAttentionMask = inputAttentionMask.expandDims(-1).broadcast(shape);
        inputAttentionMask = inputAttentionMask.eq((Number)0);
        embeddings = embeddings.duplicate();
        embeddings.set(inputAttentionMask, (Number)-1.0E9);
        return embeddings.max(AXIS, true);
    }

    private static NDArray weightedMeanPool(NDArray embeddings, NDArray attentionMask) {
        long[] shape = embeddings.getShape().getShape();
        NDArray weight = embeddings.getManager().arange(1.0f, (float)(shape[0] + 1L));
        weight = weight.expandDims(-1).broadcast(shape);
        attentionMask = attentionMask.expandDims(-1).broadcast(shape).mul(weight);
        NDArray maskSum = attentionMask.sum(AXIS);
        NDArray embeddingSum = embeddings.mul(attentionMask).sum(AXIS);
        return embeddingSum.div(maskSum);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = TextEmbeddingTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private Batchifier batchifier = Batchifier.STACK;
        private boolean normalize = true;
        private String pooling = "mean";
        private boolean includeTokenTypes;
        private String dense;
        private String denseActivation;
        private String layerNorm;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public Builder optNormalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder optPoolingMode(String poolingMode) {
            if (!("mean".equals(poolingMode) || "max".equals(poolingMode) || "cls".equals(poolingMode) || "mean_sqrt_len".equals(poolingMode) || "weightedmean".equals(poolingMode))) {
                throw new IllegalArgumentException("Invalid pooling model, must be one of [mean, max, cls, mean_sqrt_len, weightedmean].");
            }
            this.pooling = poolingMode;
            return this;
        }

        public Builder optIncludeTokenTypes(boolean includeTokenTypes) {
            this.includeTokenTypes = includeTokenTypes;
            return this;
        }

        public Builder optDense(String dense) {
            this.dense = dense;
            return this;
        }

        public Builder optDenseActivation(String denseActivation) {
            this.denseActivation = denseActivation;
            return this;
        }

        public Builder optLayerNorm(String layerNorm) {
            this.layerNorm = layerNorm;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
            this.optNormalize(ArgumentsUtil.booleanValue(arguments, (String)"normalize", (boolean)true));
            this.optPoolingMode(ArgumentsUtil.stringValue(arguments, (String)"pooling", (String)"mean"));
            this.optIncludeTokenTypes(ArgumentsUtil.booleanValue(arguments, (String)"includeTokenTypes"));
            this.optDense(ArgumentsUtil.stringValue(arguments, (String)"dense"));
            this.optDenseActivation(ArgumentsUtil.stringValue(arguments, (String)"denseActivation"));
            this.optLayerNorm(ArgumentsUtil.stringValue(arguments, (String)"layerNorm"));
        }

        public TextEmbeddingTranslator build() throws IOException {
            return new TextEmbeddingTranslator(this.tokenizer, this.batchifier, this.pooling, this.normalize, this.includeTokenTypes, this.dense, this.denseActivation, this.layerNorm);
        }
    }
}

