/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.PrintWriter;
import java.text.Normalizer;

public final class StringUtil {
    private StringUtil() {
    }

    public static String pad(int padding) {
        if (padding > 0) {
            StringBuilder sb = new StringBuilder(padding);
            for (int i = 0; i < padding; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }
        return "";
    }

    public static String pad(String string, int minLength) {
        String result = string;
        int pad = minLength - string.length();
        if (pad > 0) {
            result = string + StringUtil.pad(minLength - string.length());
        } else if (pad < 0) {
            result = string.substring(0, minLength);
        }
        return result;
    }

    public static String pad(int val, int minLength) {
        return StringUtil.pad("" + val, minLength);
    }

    public static String pad(double val, int minLength) {
        return StringUtil.pad("" + val, minLength);
    }

    public static void dump(PrintWriter pw, int padding, String string) {
        pw.print(StringUtil.pad(padding));
        pw.println(string);
    }

    public static String normalize(String text) {
        text = Normalizer.normalize(text, Normalizer.Form.NFD);
        text = text.replaceAll("\\p{M}", "");
        return text;
    }
}

