/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.clustering;

import com.oracle.labs.mlrg.olcut.util.MutableLong;
import com.oracle.labs.mlrg.olcut.util.MutableNumber;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.MutableOutputInfo;
import org.tribuo.OutputInfo;
import org.tribuo.clustering.ClusterID;
import org.tribuo.clustering.ImmutableClusteringInfo;
import org.tribuo.clustering.MutableClusteringInfo;

public abstract class ClusteringInfo
implements OutputInfo<ClusterID> {
    private static final long serialVersionUID = 1L;
    protected final Map<Integer, MutableLong> clusterCounts;
    protected int unknownCount = 0;

    ClusteringInfo() {
        this.clusterCounts = new HashMap<Integer, MutableLong>();
    }

    ClusteringInfo(ClusteringInfo other) {
        this.clusterCounts = MutableNumber.copyMap(other.clusterCounts);
    }

    public int getUnknownCount() {
        return this.unknownCount;
    }

    public Set<ClusterID> getDomain() {
        HashSet<ClusterID> outputs = new HashSet<ClusterID>();
        for (Map.Entry<Integer, MutableLong> e : this.clusterCounts.entrySet()) {
            outputs.add(new ClusterID(e.getKey()));
        }
        return outputs;
    }

    public int size() {
        return this.clusterCounts.size();
    }

    public ImmutableOutputInfo<ClusterID> generateImmutableOutputInfo() {
        return new ImmutableClusteringInfo(this);
    }

    public MutableOutputInfo<ClusterID> generateMutableOutputInfo() {
        return new MutableClusteringInfo(this);
    }

    public abstract ClusteringInfo copy();

    public Iterable<Pair<String, Long>> outputCountsIterable() {
        return () -> new Iterator<Pair<String, Long>>(){
            Iterator itr;
            {
                this.itr = ClusteringInfo.this.clusterCounts.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Pair<String, Long> next() {
                Map.Entry e = (Map.Entry)this.itr.next();
                return new Pair((Object)("" + e.getKey()), (Object)((MutableLong)e.getValue()).longValue());
            }
        };
    }

    public String toReadableString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Integer, MutableLong> e : this.clusterCounts.entrySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append('(');
            builder.append(e.getKey());
            builder.append(',');
            builder.append(e.getValue().longValue());
            builder.append(')');
        }
        return builder.toString();
    }

    public String toString() {
        return this.toReadableString();
    }
}

