/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.undeploy;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.ml.cluster.DiscoveryNodeHelper;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.transport.deploy.MLDeployModelRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelNodesRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsRequest;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsResponse;
import org.opensearch.ml.engine.ModelHelper;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.task.MLTaskDispatcher;
import org.opensearch.ml.task.MLTaskManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportUndeployModelsAction
extends HandledTransportAction<ActionRequest, MLUndeployModelsResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUndeployModelsAction.class);
    TransportService transportService;
    ModelHelper modelHelper;
    MLTaskManager mlTaskManager;
    ClusterService clusterService;
    ThreadPool threadPool;
    Client client;
    Settings settings;
    NamedXContentRegistry xContentRegistry;
    DiscoveryNodeHelper nodeFilter;
    MLTaskDispatcher mlTaskDispatcher;
    MLModelManager mlModelManager;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public TransportUndeployModelsAction(TransportService transportService, ActionFilters actionFilters, ModelHelper modelHelper, MLTaskManager mlTaskManager, ClusterService clusterService, ThreadPool threadPool, Client client, Settings settings, NamedXContentRegistry xContentRegistry, DiscoveryNodeHelper nodeFilter, MLTaskDispatcher mlTaskDispatcher, MLModelManager mlModelManager, ModelAccessControlHelper modelAccessControlHelper) {
        super("cluster:admin/opensearch/ml/undeploy_models", transportService, actionFilters, MLDeployModelRequest::new);
        this.transportService = transportService;
        this.modelHelper = modelHelper;
        this.mlTaskManager = mlTaskManager;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.nodeFilter = nodeFilter;
        this.mlTaskDispatcher = mlTaskDispatcher;
        this.mlModelManager = mlModelManager;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.settings = settings;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelsRequest undeployModelsRequest = MLUndeployModelsRequest.fromActionRequest((ActionRequest)request);
        String[] modelIds = undeployModelsRequest.getModelIds();
        String[] targetNodeIds = undeployModelsRequest.getNodeIds();
        if (modelIds == null) {
            listener.onFailure((Exception)new IllegalArgumentException("Must set specific model ids to undeploy"));
            return;
        }
        if (modelIds.length == 1) {
            String modelId = modelIds[0];
            this.validateAccess(modelId, (ActionListener<Boolean>)ActionListener.wrap(hasPermissionToUndeploy -> {
                if (hasPermissionToUndeploy.booleanValue()) {
                    this.undeployModels(targetNodeIds, modelIds, listener);
                } else {
                    listener.onFailure((Exception)new IllegalArgumentException("No permission to undeploy model " + modelId));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            if (this.modelAccessControlHelper.isModelAccessControlEnabled()) {
                throw new IllegalArgumentException("only support undeploy one model");
            }
            this.searchHiddenModels(modelIds, (ActionListener<SearchResponse>)ActionListener.wrap(hiddenModels -> {
                if (hiddenModels != null && hiddenModels.getHits().getTotalHits() != null && hiddenModels.getHits().getTotalHits().value != 0L && !this.isSuperAdminUserWrapper(this.clusterService, this.client)) {
                    List hiddenModelIds = Arrays.stream(hiddenModels.getHits().getHits()).map(SearchHit::getId).collect(Collectors.toList());
                    String[] modelsIDsToUndeploy = (String[])Arrays.stream(modelIds).filter(modelId -> !hiddenModelIds.contains(modelId)).toArray(String[]::new);
                    this.undeployModels(targetNodeIds, modelsIDsToUndeploy, listener);
                } else {
                    this.undeployModels(targetNodeIds, modelIds, listener);
                }
            }, e -> {
                log.error("Failed to search model index", (Throwable)e);
                listener.onFailure(e);
            }));
        }
    }

    private void undeployModels(String[] targetNodeIds, String[] modelIds, ActionListener<MLUndeployModelsResponse> listener) {
        MLUndeployModelNodesRequest mlUndeployModelNodesRequest = new MLUndeployModelNodesRequest(targetNodeIds, modelIds);
        this.client.execute((ActionType)MLUndeployModelAction.INSTANCE, (ActionRequest)mlUndeployModelNodesRequest, ActionListener.wrap(r -> listener.onResponse((Object)new MLUndeployModelsResponse(r)), arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateAccess(String modelId, ActionListener<Boolean> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        String[] excludes = new String[]{"model_content", "content"};
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.mlModelManager.getModel(modelId, null, excludes, (ActionListener<MLModel>)ActionListener.runBefore((ActionListener)ActionListener.wrap(mlModel -> {
                Boolean isHidden = mlModel.getIsHidden();
                if (isHidden != null && isHidden.booleanValue()) {
                    if (isSuperAdmin) {
                        listener.onResponse((Object)true);
                    } else {
                        listener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this model", RestStatus.FORBIDDEN, new Object[0]));
                    }
                } else {
                    this.modelAccessControlHelper.validateModelGroupAccess(user, mlModel.getModelGroupId(), this.client, listener);
                }
            }, e -> {
                log.error("Failed to find Model", (Throwable)e);
                listener.onFailure(e);
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to undeploy ML model");
            listener.onFailure(e2);
        }
    }

    public void searchHiddenModels(String[] modelIds, ActionListener<SearchResponse> listener) throws IllegalArgumentException {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            TermsQueryBuilder termsQuery = QueryBuilders.termsQuery((String)"_id", (String[])modelIds);
            TermQueryBuilder isHiddenQuery = QueryBuilders.termQuery((String)"is_hidden", (boolean)true);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)termsQuery).must((QueryBuilder)isHiddenQuery).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"chunk_number")));
            SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"}).source(searchSourceBuilder);
            this.client.search(searchRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(models -> listener.onResponse(models), e -> {
                if (e instanceof IndexNotFoundException) {
                    listener.onResponse(null);
                } else {
                    log.error("Failed to search model index", (Throwable)e);
                    listener.onFailure(e);
                }
            }), () -> context.restore()));
        }
        catch (Exception e2) {
            log.error("Failed to search model index", (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

