/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.breaker;

import java.util.Optional;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.monitor.os.OsService;

public class NativeMemoryCircuitBreaker
extends ThresholdCircuitBreaker<Short> {
    private static final String ML_MEMORY_CB = "Native Memory Circuit Breaker";
    public static final short DEFAULT_NATIVE_MEM_USAGE_THRESHOLD = 90;
    private final OsService osService;

    public NativeMemoryCircuitBreaker(OsService osService, Settings settings, ClusterService clusterService) {
        super(Optional.ofNullable((Integer)MLCommonsSettings.ML_COMMONS_NATIVE_MEM_THRESHOLD.get(settings)).map(Integer::shortValue).orElse((short)90));
        this.osService = osService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_NATIVE_MEM_THRESHOLD, it -> super.setThreshold(it.shortValue()));
    }

    public NativeMemoryCircuitBreaker(Integer threshold, OsService osService) {
        super(threshold.shortValue());
        this.osService = osService;
    }

    @Override
    public String getName() {
        return ML_MEMORY_CB;
    }

    @Override
    public boolean isOpen() {
        return this.osService.stats().getMem().getUsedPercent() > (Short)this.getThreshold();
    }
}

