/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher;

import com.amazonaws.services.emrserverless.model.JobRunState;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryJobMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.dispatcher.AsyncQueryHandler;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryContext;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryRequest;
import org.opensearch.sql.spark.dispatcher.model.DispatchQueryResponse;
import org.opensearch.sql.spark.dispatcher.model.IndexDMLResult;
import org.opensearch.sql.spark.dispatcher.model.IndexQueryDetails;
import org.opensearch.sql.spark.dispatcher.model.JobType;
import org.opensearch.sql.spark.execution.statement.StatementState;
import org.opensearch.sql.spark.execution.statestore.StateModel;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.flint.IndexDMLResultStorageService;
import org.opensearch.sql.spark.flint.operation.FlintIndexOp;
import org.opensearch.sql.spark.flint.operation.FlintIndexOpFactory;
import org.opensearch.sql.spark.response.JobExecutionResponseReader;

public class IndexDMLHandler
extends AsyncQueryHandler {
    private static final Logger LOG = LogManager.getLogger();
    public static final String DROP_INDEX_JOB_ID = "dropIndexJobId";
    public static final String DML_QUERY_JOB_ID = "DMLQueryJobId";
    private final JobExecutionResponseReader jobExecutionResponseReader;
    private final FlintIndexMetadataService flintIndexMetadataService;
    private final IndexDMLResultStorageService indexDMLResultStorageService;
    private final FlintIndexOpFactory flintIndexOpFactory;

    public static boolean isIndexDMLQuery(String jobId) {
        return DROP_INDEX_JOB_ID.equalsIgnoreCase(jobId) || DML_QUERY_JOB_ID.equalsIgnoreCase(jobId);
    }

    @Override
    public DispatchQueryResponse submit(DispatchQueryRequest dispatchQueryRequest, DispatchQueryContext context) {
        DataSourceMetadata dataSourceMetadata = context.getDataSourceMetadata();
        long startTime = System.currentTimeMillis();
        try {
            IndexQueryDetails indexDetails = context.getIndexQueryDetails();
            FlintIndexMetadata indexMetadata = this.getFlintIndexMetadata(indexDetails);
            this.getIndexOp(dispatchQueryRequest, indexDetails).apply(indexMetadata);
            String asyncQueryId = this.storeIndexDMLResult(context.getQueryId(), dispatchQueryRequest, dataSourceMetadata, JobRunState.SUCCESS.toString(), "", this.getElapsedTimeSince(startTime), context.getAsyncQueryRequestContext());
            return DispatchQueryResponse.builder().queryId(asyncQueryId).jobId(DML_QUERY_JOB_ID).resultIndex(dataSourceMetadata.getResultIndex()).datasourceName(dataSourceMetadata.getName()).jobType(JobType.INTERACTIVE).build();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            String asyncQueryId = this.storeIndexDMLResult(context.getQueryId(), dispatchQueryRequest, dataSourceMetadata, JobRunState.FAILED.toString(), e.getMessage(), this.getElapsedTimeSince(startTime), context.getAsyncQueryRequestContext());
            return DispatchQueryResponse.builder().queryId(asyncQueryId).jobId(DML_QUERY_JOB_ID).resultIndex(dataSourceMetadata.getResultIndex()).datasourceName(dataSourceMetadata.getName()).jobType(JobType.INTERACTIVE).build();
        }
    }

    private String storeIndexDMLResult(String queryId, DispatchQueryRequest dispatchQueryRequest, DataSourceMetadata dataSourceMetadata, String status, String error, long queryRunTime, AsyncQueryRequestContext asyncQueryRequestContext) {
        StateModel indexDMLResult = ((IndexDMLResult.IndexDMLResultBuilder)((IndexDMLResult.IndexDMLResultBuilder)((IndexDMLResult.IndexDMLResultBuilder)((IndexDMLResult.IndexDMLResultBuilder)((IndexDMLResult.IndexDMLResultBuilder)((IndexDMLResult.IndexDMLResultBuilder)IndexDMLResult.builder().queryId(queryId)).status(status)).error(error)).datasourceName(dispatchQueryRequest.getDatasource())).queryRunTime(queryRunTime)).updateTime(System.currentTimeMillis())).build();
        this.indexDMLResultStorageService.createIndexDMLResult((IndexDMLResult)indexDMLResult, asyncQueryRequestContext);
        return queryId;
    }

    private long getElapsedTimeSince(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    private FlintIndexOp getIndexOp(DispatchQueryRequest dispatchQueryRequest, IndexQueryDetails indexQueryDetails) {
        switch (indexQueryDetails.getIndexQueryActionType()) {
            case DROP: {
                return this.flintIndexOpFactory.getDrop(dispatchQueryRequest.getDatasource());
            }
            case ALTER: {
                return this.flintIndexOpFactory.getAlter(indexQueryDetails.getFlintIndexOptions(), dispatchQueryRequest.getDatasource());
            }
            case VACUUM: {
                return this.flintIndexOpFactory.getVacuum(dispatchQueryRequest.getDatasource());
            }
        }
        throw new IllegalStateException(String.format("IndexQueryActionType: %s is not supported in IndexDMLHandler.", new Object[]{indexQueryDetails.getIndexQueryActionType()}));
    }

    private FlintIndexMetadata getFlintIndexMetadata(IndexQueryDetails indexDetails) {
        Map<String, FlintIndexMetadata> indexMetadataMap = this.flintIndexMetadataService.getFlintIndexMetadata(indexDetails.openSearchIndexName());
        if (!indexMetadataMap.containsKey(indexDetails.openSearchIndexName())) {
            throw new IllegalStateException(String.format("Couldn't fetch flint index: %s details", indexDetails.openSearchIndexName()));
        }
        return indexMetadataMap.get(indexDetails.openSearchIndexName());
    }

    @Override
    protected JSONObject getResponseFromResultIndex(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        String queryId = asyncQueryJobMetadata.getQueryId();
        return this.jobExecutionResponseReader.getResultWithQueryId(queryId, asyncQueryJobMetadata.getResultIndex());
    }

    @Override
    protected JSONObject getResponseFromExecutor(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        JSONObject result = new JSONObject();
        result.put("status", (Object)StatementState.RUNNING.getState());
        result.put("error", (Object)"");
        return result;
    }

    @Override
    public String cancelJob(AsyncQueryJobMetadata asyncQueryJobMetadata) {
        throw new IllegalArgumentException("can't cancel index DML query");
    }

    @Generated
    public IndexDMLHandler(JobExecutionResponseReader jobExecutionResponseReader, FlintIndexMetadataService flintIndexMetadataService, IndexDMLResultStorageService indexDMLResultStorageService, FlintIndexOpFactory flintIndexOpFactory) {
        this.jobExecutionResponseReader = jobExecutionResponseReader;
        this.flintIndexMetadataService = flintIndexMetadataService;
        this.indexDMLResultStorageService = indexDMLResultStorageService;
        this.flintIndexOpFactory = flintIndexOpFactory;
    }
}

