from typing import List

from .. import Provider as AddressProvider


def getcities(fulldict):
    return list({c[0] for _cap, cities in fulldict.items() for c in cities})


class Provider(AddressProvider):
    # Converted from: https://download.geonames.org/export/zip/IT.zip
    cap_city_province = {
        "67010": [["Barete", "AQ"]],
        "67012": [["San Giovanni", "AQ"], ["Cagnano Amiterno", "AQ"]],
        "67013": [["Mascioni", "AQ"], ["Campotosto", "AQ"], ["Ortolano", "AQ"], ["Poggio Cancelli", "AQ"]],
        "67014": [["Capitignano", "AQ"]],
        "67015": [
            ["Marana Di Montereale", "AQ"],
            ["Marana", "AQ"],
            ["Cesaproba", "AQ"],
            ["Aringo", "AQ"],
            ["Ville Di Fano", "AQ"],
            ["Montereale", "AQ"],
            ["San Giovanni Paganica", "AQ"],
        ],
        "67017": [["Pizzoli", "AQ"], ["Marruci", "AQ"], ["San Lorenzo Di Pizzoli", "AQ"]],
        "67019": [["Sella Di Corno", "AQ"], ["Vigliano", "AQ"], ["Scoppito", "AQ"]],
        "67020": [
            ["Castelnuovo Di San Pio Delle Camere", "AQ"],
            ["Villa Santa Lucia Degli Abruzzi", "AQ"],
            ["Santo Stefano Di Sessanio", "AQ"],
            ["Castelnuovo", "AQ"],
            ["Castelvecchio Calvisio", "AQ"],
            ["Beffi", "AQ"],
            ["Castel Di Ieri", "AQ"],
            ["Fagnano Alto", "AQ"],
            ["Calascio", "AQ"],
            ["Acciano", "AQ"],
            ["Tussio", "AQ"],
            ["San Benedetto In Perillis", "AQ"],
            ["Navelli", "AQ"],
            ["Collepietro", "AQ"],
            ["Molina Aterno", "AQ"],
            ["Civitaretenga", "AQ"],
            ["San Pio Delle Camere", "AQ"],
            ["Gagliano Aterno", "AQ"],
            ["Fossa", "AQ"],
            ["Goriano Valli", "AQ"],
            ["Fontecchio", "AQ"],
            ["Prata D'Ansidonia", "AQ"],
            ["Roccapreturo", "AQ"],
            ["Tione Degli Abruzzi", "AQ"],
            ["Carapelle Calvisio", "AQ"],
            ["Carrufo", "AQ"],
            ["Sant'Eusanio Forconese", "AQ"],
            ["Caporciano", "AQ"],
            ["Villa Sant'Angelo", "AQ"],
        ],
        "67021": [["Barisciano", "AQ"], ["Picenze", "AQ"]],
        "67022": [["Capestrano", "AQ"]],
        "67023": [["Castel Del Monte", "AQ"]],
        "67024": [["Castelvecchio Subequo", "AQ"]],
        "67025": [["Ofena", "AQ"]],
        "67026": [["Poggio Picenze", "AQ"]],
        "67027": [["Raiano", "AQ"]],
        "67028": [["San Demetrio Ne' Vestini", "AQ"]],
        "67029": [["Secinaro", "AQ"]],
        "67030": [
            ["Barrea", "AQ"],
            ["Villalago", "AQ"],
            ["Alfedena", "AQ"],
            ["Anversa Degli Abruzzi", "AQ"],
            ["Villetta Barrea", "AQ"],
            ["Torre Dei Nolfi", "AQ"],
            ["Corfinio", "AQ"],
            ["Civitella Alfedena", "AQ"],
            ["Cansano", "AQ"],
            ["Rocca Pia", "AQ"],
            ["Castrovalva", "AQ"],
            ["Bugnara", "AQ"],
            ["Introdacqua", "AQ"],
            ["Ateleta", "AQ"],
            ["Scontrone", "AQ"],
            ["Pacentro", "AQ"],
            ["Vittorito", "AQ"],
            ["Prezza", "AQ"],
            ["Campo Di Fano", "AQ"],
            ["Cocullo", "AQ"],
            ["Campo Di Giove", "AQ"],
            ["Villa Scontrone", "AQ"],
            ["Roccacasale", "AQ"],
            ["Opi", "AQ"],
            ["Goriano Sicoli", "AQ"],
        ],
        "67031": [["Castel Di Sangro", "AQ"], ["Roccacinquemiglia", "AQ"]],
        "67032": [["Pescasseroli", "AQ"]],
        "67033": [["Pescocostanzo", "AQ"]],
        "67034": [["Pettorano Sul Gizio", "AQ"]],
        "67035": [["Bagnaturo", "AQ"], ["Pratola Peligna", "AQ"]],
        "67036": [["Rivisondoli", "AQ"]],
        "67037": [["Roccaraso", "AQ"], ["Pietransieri", "AQ"], ["Aremogna", "AQ"]],
        "67038": [["Scanno", "AQ"], ["Frattura Di Scanno", "AQ"], ["Frattura", "AQ"]],
        "67039": [
            ["Torrone Di Sulmona", "AQ"],
            ["Cavate", "AQ"],
            ["Albanese", "AQ"],
            ["Sulmona", "AQ"],
            ["Torrone", "AQ"],
            ["Marane", "AQ"],
            ["Arabona", "AQ"],
            ["Abazia Di Sulmona", "AQ"],
        ],
        "67040": [["Collarmele", "AQ"], ["Ocre", "AQ"], ["San Martino D'Ocre", "AQ"]],
        "67041": [["Aielli Stazione", "AQ"], ["Aielli", "AQ"]],
        "67043": [["Celano", "AQ"]],
        "67044": [["Cerchio", "AQ"]],
        "67045": [["Lucoli", "AQ"], ["Casamaina Di Lucoli", "AQ"], ["Casamaina", "AQ"], ["Ville Di Lucoli", "AQ"]],
        "67046": [["San Potito", "AQ"], ["Santo Iona", "AQ"], ["Ovindoli", "AQ"]],
        "67047": [["Rocca Di Cambio", "AQ"]],
        "67048": [["Rocca Di Mezzo", "AQ"], ["Rovere", "AQ"], ["Rovere Di Rocca Di Mezzo", "AQ"]],
        "67049": [
            ["Rocca Santo Stefano", "AQ"],
            ["San Nicola Di Tornimparte", "AQ"],
            ["Villagrande", "AQ"],
            ["Rocca Santo Stefano Di Tornimparte", "AQ"],
            ["Tornimparte", "AQ"],
            ["San Nicola", "AQ"],
        ],
        "67050": [
            ["Ortucchio", "AQ"],
            ["Roccavivi", "AQ"],
            ["Castellafiume", "AQ"],
            ["Lecce Nei Marsi", "AQ"],
            ["Forme", "AQ"],
            ["Villavallelonga", "AQ"],
            ["Canistro Inferiore", "AQ"],
            ["Collelongo", "AQ"],
            ["Pagliara", "AQ"],
            ["San Vincenzo Valle Roveto", "AQ"],
            ["Civita D'Antino", "AQ"],
            ["Corona", "AQ"],
            ["Bisegna", "AQ"],
            ["Canistro", "AQ"],
            ["Ortona Dei Marsi", "AQ"],
            ["San Vincenzo Valle Roveto Superiore", "AQ"],
            ["Albe", "AQ"],
            ["Castronovo", "AQ"],
            ["Pagliara Dei Marsi", "AQ"],
            ["Canistro Superiore", "AQ"],
            ["San Sebastiano", "AQ"],
            ["Morino", "AQ"],
            ["Pero Dei Santi", "AQ"],
            ["Rendinara", "AQ"],
            ["Grancia", "AQ"],
            ["Carrito", "AQ"],
            ["San Vincenzo Vecchio", "AQ"],
            ["Massa D'Albe", "AQ"],
        ],
        "67051": [
            ["San Pelino", "AQ"],
            ["Cese", "AQ"],
            ["Antrosano", "AQ"],
            ["Santuario Di Pietracquaria", "AQ"],
            ["Avezzano", "AQ"],
            ["Paterno", "AQ"],
        ],
        "67052": [["Balsorano Nuovo", "AQ"], ["Ridotti", "AQ"], ["Ridotti Di Balsorano", "AQ"], ["Balsorano", "AQ"]],
        "67053": [
            ["Capistrello", "AQ"],
            ["Corcumello", "AQ"],
            ["Pescocanale", "AQ"],
            ["Pescocanale Di Capistrello", "AQ"],
        ],
        "67054": [["Meta", "AQ"], ["Civitella Roveto", "AQ"]],
        "67055": [["Gioia Dei Marsi", "AQ"], ["Casali D'Aschi", "AQ"]],
        "67056": [["Luco Dei Marsi", "AQ"]],
        "67057": [["Venere", "AQ"], ["Pescina", "AQ"]],
        "67058": [["San Benedetto Dei Marsi", "AQ"]],
        "67059": [["Trasacco", "AQ"]],
        "67060": [["Cappadocia", "AQ"], ["Petrella Liri", "AQ"], ["Verrecchie", "AQ"]],
        "67061": [
            ["Villa Romana", "AQ"],
            ["Pietrasecca", "AQ"],
            ["Montesabinese", "AQ"],
            ["Tufo Di Carsoli", "AQ"],
            ["Carsoli", "AQ"],
            ["Colli Di Montebove", "AQ"],
            ["Poggio Cinolfo", "AQ"],
        ],
        "67062": [
            ["Magliano De' Marsi", "AQ"],
            ["Marano Dei Marsi", "AQ"],
            ["Rosciolo", "AQ"],
            ["Rosciolo Dei Marsi", "AQ"],
        ],
        "67063": [["Oricola", "AQ"], ["Civita", "AQ"]],
        "67064": [["Pereto", "AQ"]],
        "67066": [["Rocca Di Botte", "AQ"]],
        "67067": [
            ["Scanzano", "AQ"],
            ["Santo Stefano", "AQ"],
            ["Santo Stefano Di Sante Marie", "AQ"],
            ["Sante Marie", "AQ"],
        ],
        "67068": [["Scurcola Marsicana", "AQ"], ["Cappelle", "AQ"], ["Cappelle Dei Marsi", "AQ"]],
        "67069": [
            ["San Donato Di Tagliacozzo", "AQ"],
            ["Villa San Sebastiano", "AQ"],
            ["Sorbo Di Tagliacozzo", "AQ"],
            ["Gallo", "AQ"],
            ["Tremonti", "AQ"],
            ["San Donato", "AQ"],
            ["Tagliacozzo", "AQ"],
            ["Sorbo", "AQ"],
            ["Poggetello Di Tagliacozzo", "AQ"],
            ["Gallo Di Tagliacozzo", "AQ"],
            ["Poggetello", "AQ"],
            ["Poggio Filippo", "AQ"],
            ["Roccacerro", "AQ"],
        ],
        "67100": [
            ["Pagliare", "AQ"],
            ["Arischia", "AQ"],
            ["Monticchio", "AQ"],
            ["San Gregorio", "AQ"],
            ["San Vittorino", "AQ"],
            ["Tempera", "AQ"],
            ["Bagno", "AQ"],
            ["Preturo", "AQ"],
            ["Pile", "AQ"],
            ["Aragno", "AQ"],
            ["Colle Brincioni", "AQ"],
            ["Pianola", "AQ"],
            ["Colle Di Roio", "AQ"],
            ["Poggio Di Roio", "AQ"],
            ["Coppito", "AQ"],
            ["Assergi", "AQ"],
            ["Forcella", "AQ"],
            ["Onna", "AQ"],
            ["Santi", "AQ"],
            ["L'Aquila", "AQ"],
            ["Paganica", "AQ"],
            ["Roio Piano", "AQ"],
            ["San Benedetto", "AQ"],
            ["Collebrincioni", "AQ"],
            ["Campo Imperatore", "AQ"],
            ["Bazzano", "AQ"],
            ["San Vittorino Amiterno", "AQ"],
            ["Camarda", "AQ"],
            ["Sassa", "AQ"],
        ],
        "66010": [
            ["Gessopalena", "CH"],
            ["Pennapiedimonte", "CH"],
            ["Ari", "CH"],
            ["Ripa Teatina", "CH"],
            ["Canosa Sannita", "CH"],
            ["Tollo", "CH"],
            ["Roccamontepiano", "CH"],
            ["San Rocco", "CH"],
            ["Pretoro", "CH"],
            ["Lama Dei Peligni", "CH"],
            ["Montenerodomo", "CH"],
            ["Semivicoli", "CH"],
            ["San Martino Sulla Marrucina", "CH"],
            ["Lettopalena", "CH"],
            ["San Pietro", "CH"],
            ["Vacri", "CH"],
            ["Civitella Messer Raimondo", "CH"],
            ["Terranova", "CH"],
            ["Giuliano Teatino", "CH"],
            ["Rapino", "CH"],
            ["Fara Filiorum Petri", "CH"],
            ["Torrevecchia Teatina", "CH"],
            ["Miglianico", "CH"],
            ["Casacanditella", "CH"],
            ["Castelferrato", "CH"],
            ["Palombaro", "CH"],
            ["Colledimacine", "CH"],
            ["Villamagna", "CH"],
        ],
        "66011": [["Colle Sant'Antonio", "CH"], ["Bucchianico", "CH"]],
        "66012": [["Casalincontrada", "CH"]],
        "66014": [["Villa Tucci", "CH"], ["Crecchio", "CH"]],
        "66015": [["Fara San Martino", "CH"]],
        "66016": [
            ["Villa San Vincenzo", "CH"],
            ["Comino", "CH"],
            ["Piano Delle Fonti", "CH"],
            ["Caporosso", "CH"],
            ["Guardiagrele", "CH"],
        ],
        "66017": [["Palena", "CH"]],
        "66018": [["Taranta Peligna", "CH"]],
        "66019": [["Fallascoso", "CH"], ["Torricella Peligna", "CH"]],
        "66020": [
            ["Torino Di Sangro Stazione", "CH"],
            ["Pollutri", "CH"],
            ["Villalfonsina", "CH"],
            ["San Giacomo Di Scerni", "CH"],
            ["Sambuceto", "CH"],
            ["San Giovanni Teatino", "CH"],
            ["Torino Di Sangro", "CH"],
            ["Paglieta", "CH"],
            ["Rocca San Giovanni", "CH"],
            ["Sant'Egidio", "CH"],
            ["Scerni", "CH"],
        ],
        "66021": [["Miracoli", "CH"], ["Casalbordino Stazione", "CH"], ["Casalbordino", "CH"]],
        "66022": [["Villascorciosa", "CH"], ["Scorciosa", "CH"], ["Fossacesia Marina", "CH"], ["Fossacesia", "CH"]],
        "66023": [["Francavilla Al Mare", "CH"], ["Francavilla Al Mare Rione Foro", "CH"]],
        "66026": [
            ["Ortona", "CH"],
            ["Ortona Foro", "CH"],
            ["San Nicola", "CH"],
            ["Villa San Leonardo", "CH"],
            ["Ortona Porto", "CH"],
            ["Villa Grande", "CH"],
            ["San Leonardo", "CH"],
            ["Villa Caldari", "CH"],
            ["Villa San Nicola", "CH"],
        ],
        "66030": [
            ["Montazzoli", "CH"],
            ["Filetto", "CH"],
            ["Villa Romagnoli", "CH"],
            ["Santa Maria Imbaro", "CH"],
            ["Arielli", "CH"],
            ["Guastameroli", "CH"],
            ["Poggiofiorito", "CH"],
            ["Treglio", "CH"],
            ["Frisa", "CH"],
            ["Carpineto Sinello", "CH"],
            ["Mozzagrogna", "CH"],
        ],
        "66031": [["Casalanguida", "CH"]],
        "66032": [["Castel Frentano", "CH"]],
        "66033": [["Castiglione Messer Marino", "CH"]],
        "66034": [
            ["Rizzacorno", "CH"],
            ["Madonna Del Carmine", "CH"],
            ["Lanciano", "CH"],
            ["Nasuti", "CH"],
            ["Sant'Amato", "CH"],
            ["Villa Elce", "CH"],
        ],
        "66036": [["Orsogna", "CH"]],
        "66037": [["Sant'Eusanio Del Sangro", "CH"]],
        "66038": [["Marina Di San Vito", "CH"], ["Sant'Apollinare Chietino", "CH"], ["San Vito Chietino", "CH"]],
        "66040": [
            ["Pennadomo", "CH"],
            ["Roccascalegna", "CH"],
            ["Pietraferrazzana", "CH"],
            ["Quadri", "CH"],
            ["Civitaluparella", "CH"],
            ["Rosello", "CH"],
            ["Giuliopoli", "CH"],
            ["Selva", "CH"],
            ["Pizzoferrato", "CH"],
            ["Selva Di Altino", "CH"],
            ["Altino", "CH"],
            ["Monteferrante", "CH"],
            ["Perano", "CH"],
            ["Montelapiano", "CH"],
            ["Buonanotte", "CH"],
            ["Colledimezzo", "CH"],
            ["Fallo", "CH"],
            ["Roio Del Sangro", "CH"],
            ["Montebello Sul Sangro", "CH"],
            ["Gamberale", "CH"],
            ["Borrello", "CH"],
            ["Castelguidone", "CH"],
        ],
        "66041": [
            ["Piana La Fara", "CH"],
            ["Atessa", "CH"],
            ["Monte Marcone", "CH"],
            ["Piazzano Di Atessa", "CH"],
            ["Piazzano", "CH"],
        ],
        "66042": [["Bomba", "CH"]],
        "66043": [["Casoli", "CH"], ["Selva Piana", "CH"]],
        "66044": [["Piane D'Archi", "CH"], ["Archi", "CH"]],
        "66045": [["Schiavi Di Abruzzo", "CH"], ["Taverna Di Schiavi Di Abruzzo", "CH"]],
        "66046": [["San Giovanni", "CH"], ["Tornareccio", "CH"]],
        "66047": [["Villa Santa Maria", "CH"]],
        "66050": [
            ["Lentella", "CH"],
            ["Guardiabruna", "CH"],
            ["Tufillo", "CH"],
            ["Torrebruna", "CH"],
            ["San Buono", "CH"],
            ["San Giovanni Lipioni", "CH"],
            ["Roccaspinalveti", "CH"],
            ["Furci", "CH"],
            ["Guilmi", "CH"],
            ["Dogliola", "CH"],
            ["Olmi", "CH"],
            ["Celenza Sul Trigno", "CH"],
            ["Fraine", "CH"],
            ["Liscia", "CH"],
            ["Monteodorisio", "CH"],
            ["San Salvo", "CH"],
            ["Carunchio", "CH"],
            ["Fresagrandinaria", "CH"],
            ["San Salvo Marina", "CH"],
            ["Palmoli", "CH"],
        ],
        "66051": [["Cupello", "CH"]],
        "66052": [["Gissi", "CH"]],
        "66054": [
            ["San Lorenzo Di Vasto", "CH"],
            ["Incoronata Di Vasto", "CH"],
            ["Vasto", "CH"],
            ["Marina Di Vasto", "CH"],
            ["Vasto Marina", "CH"],
        ],
        "66100": [
            ["Brecciarola", "CH"],
            ["Tricalle", "CH"],
            ["Chieti", "CH"],
            ["Chieti Scalo", "CH"],
            ["Chieti Stazione", "CH"],
        ],
        "65010": [
            ["Santa Lucia Di Collecorvino", "PE"],
            ["Moscufo", "PE"],
            ["Montebello Di Bertona", "PE"],
            ["Carpineto Della Nora", "PE"],
            ["Elice", "PE"],
            ["Piccianello", "PE"],
            ["Vicoli", "PE"],
            ["Civitella Casanova", "PE"],
            ["Collecorvino", "PE"],
            ["Villa Celiera", "PE"],
            ["Caprara D'Abruzzo", "PE"],
            ["Spoltore", "PE"],
            ["Barberi", "PE"],
            ["Farindola", "PE"],
            ["Vestea", "PE"],
            ["Santa Lucia", "PE"],
            ["Congiunti", "PE"],
            ["Brittoli", "PE"],
            ["Cappelle Sul Tavo", "PE"],
            ["Civitaquana", "PE"],
            ["Villa Raspa", "PE"],
            ["Nocciano", "PE"],
            ["Picciano", "PE"],
            ["Santa Teresa", "PE"],
        ],
        "65011": [["Catignano", "PE"]],
        "65012": [
            ["Villareia", "PE"],
            ["Vallemare Di Cepagatti", "PE"],
            ["Vallemare", "PE"],
            ["Villanova", "PE"],
            ["Cepagatti", "PE"],
        ],
        "65013": [
            ["Marina", "PE"],
            ["San Martino Bassa", "PE"],
            ["Citta' Sant'Angelo", "PE"],
            ["Villa Cipresso", "PE"],
        ],
        "65014": [["Loreto Aprutino", "PE"]],
        "65015": [
            ["Montesilvano Colle", "PE"],
            ["Villa Carmine", "PE"],
            ["Montesilvano", "PE"],
            ["Montesilvano Spiaggia", "PE"],
            ["Montesilvano Marina", "PE"],
        ],
        "65017": [["Penne", "PE"], ["Roccafinadamo", "PE"]],
        "65019": [["Pianella", "PE"], ["Cerratina", "PE"], ["Castellana", "PE"]],
        "65020": [
            ["Bolognano", "PE"],
            ["Cugnoli", "PE"],
            ["Sant'Eufemia A Maiella", "PE"],
            ["Alanno", "PE"],
            ["Corvara", "PE"],
            ["Salle", "PE"],
            ["Villa San Giovanni", "PE"],
            ["Castiglione A Casauria", "PE"],
            ["Pietranico", "PE"],
            ["Ticchione", "PE"],
            ["Lettomanoppello", "PE"],
            ["Musellaro", "PE"],
            ["Roccamorice", "PE"],
            ["Villa Badessa", "PE"],
            ["Rosciano", "PE"],
            ["Villa Oliveti", "PE"],
            ["Abbateggio", "PE"],
            ["San Valentino In Abruzzo Citeriore", "PE"],
            ["Pescosansonesco", "PE"],
            ["Turrivalignani", "PE"],
            ["Pesconuovo", "PE"],
            ["Piano D'Orta", "PE"],
            ["Alanno Scalo", "PE"],
            ["Alanno Stazione", "PE"],
        ],
        "65022": [["Bussi Officine", "PE"], ["Bussi Sul Tirino", "PE"]],
        "65023": [["Caramanico Terme", "PE"], ["San Tommaso", "PE"]],
        "65024": [
            ["Ripacorbaria", "PE"],
            ["Manoppello", "PE"],
            ["Manoppello Stazione", "PE"],
            ["Manoppello Scalo", "PE"],
        ],
        "65025": [["Serramonacesca", "PE"]],
        "65026": [["Popoli", "PE"]],
        "65027": [["Scafa", "PE"], ["Decontra", "PE"]],
        "65028": [["Tocco Da Casauria", "PE"]],
        "65029": [["Torre De' Passeri", "PE"]],
        "65100": [["Pescara", "PE"]],
        "65121": [["Pescara", "PE"]],
        "65122": [["Pescara", "PE"]],
        "65123": [["Pescara", "PE"]],
        "65124": [["Pescara", "PE"]],
        "65125": [["Pescara", "PE"], ["Pescara Colli", "PE"]],
        "65126": [["Pescara", "PE"]],
        "65127": [["Pescara", "PE"]],
        "65128": [["Pescara", "PE"]],
        "65129": [["Pescara", "PE"], ["Pineta Di Pescara", "PE"]],
        "65131": [["Fontanelle", "PE"]],
        "65132": [["San Silvestro", "PE"], ["Pescara", "PE"]],
        "64010": [
            ["Rocche Di Civitella", "TE"],
            ["Civitella Del Tronto", "TE"],
            ["Cesano", "TE"],
            ["Colonnella", "TE"],
            ["San Vito", "TE"],
            ["Ancarano", "TE"],
            ["Valle Castellana", "TE"],
            ["Torano Nuovo", "TE"],
            ["Villa Lempa", "TE"],
            ["Pietralta", "TE"],
            ["Ioanella", "TE"],
            ["Villa Favale", "TE"],
            ["Rocca Santa Maria", "TE"],
            ["Villa Passo", "TE"],
            ["Santo Stefano Di Torricella Sicura", "TE"],
            ["Controguerra", "TE"],
            ["Ripe Civitella Del Tronto", "TE"],
            ["Pascellata", "TE"],
            ["Ponzano", "TE"],
            ["Santo Stefano", "TE"],
            ["Cerqueto Del Tronto", "TE"],
            ["Leofara", "TE"],
            ["Torricella Sicura", "TE"],
        ],
        "64011": [["Alba Adriatica", "TE"]],
        "64012": [
            ["Paterno", "TE"],
            ["Villa Paterno", "TE"],
            ["Sant'Onofrio", "TE"],
            ["Piancarani", "TE"],
            ["Campli", "TE"],
            ["Campovalano", "TE"],
            ["Garrufo Di Campli", "TE"],
        ],
        "64013": [["Corropoli", "TE"]],
        "64014": [["Martinsicuro", "TE"], ["Villa Rosa", "TE"], ["Villa Rosa Di Martinsicuro", "TE"]],
        "64015": [["Nereto", "TE"]],
        "64016": [
            ["Sant'Egidio Alla Vibrata", "TE"],
            ["Paolantonio", "TE"],
            ["Faraone", "TE"],
            ["Villa Mattoni", "TE"],
            ["Faraone Nuovo", "TE"],
        ],
        "64018": [["Tortoreto", "TE"], ["Salino", "TE"], ["Tortoreto Lido", "TE"]],
        "64020": [
            ["Bellante Stazione", "TE"],
            ["Zaccheo", "TE"],
            ["Canzano", "TE"],
            ["Pagliare", "TE"],
            ["Petriccione", "TE"],
            ["Castelnuovo Vomano", "TE"],
            ["Casemolino", "TE"],
            ["Morro D'Oro", "TE"],
            ["Castelbasso", "TE"],
            ["Castellalto", "TE"],
            ["Valle Canzano", "TE"],
            ["Ripattoni", "TE"],
            ["Villa Zaccheo", "TE"],
            ["Bellante", "TE"],
        ],
        "64021": [["Giulianova Spiaggia", "TE"], ["Colleranesco", "TE"], ["Giulianova", "TE"]],
        "64023": [["Mosciano Sant'Angelo", "TE"], ["Montone", "TE"], ["Notaresco Stazione", "TE"]],
        "64024": [["Guardia Vomano", "TE"], ["Pianura Vomano", "TE"], ["Notaresco", "TE"]],
        "64025": [
            ["Borgo Santa Maria Immacolata", "TE"],
            ["Mutignano", "TE"],
            ["Scerne", "TE"],
            ["Scerne Di Pineto", "TE"],
            ["Pineto", "TE"],
        ],
        "64026": [
            ["Cologna", "TE"],
            ["Montepagano", "TE"],
            ["Cologna Spiaggia", "TE"],
            ["San Giovanni", "TE"],
            ["Santa Lucia Di Roseto Degli Abruzzi", "TE"],
            ["Santa Lucia", "TE"],
            ["Roseto Degli Abruzzi", "TE"],
            ["Cologna Paese", "TE"],
        ],
        "64027": [["Garrufo", "TE"], ["Poggio Morello", "TE"], ["Sant'Omero", "TE"]],
        "64028": [["Pianacce", "TE"], ["Silvi Marina", "TE"], ["San Silvestro", "TE"], ["Silvi", "TE"]],
        "64030": [["Basciano", "TE"], ["Castel Castagna", "TE"], ["Montefino", "TE"], ["Villa Bozza", "TE"]],
        "64031": [["Arsita", "TE"]],
        "64032": [
            ["Atri", "TE"],
            ["Casoli", "TE"],
            ["Santa Margherita Di Atri", "TE"],
            ["Santa Margherita", "TE"],
            ["Fontanelle", "TE"],
            ["San Giacomo D'Atri", "TE"],
            ["San Giacomo", "TE"],
            ["Treciminiere", "TE"],
            ["Casoli Di Atri", "TE"],
        ],
        "64033": [["Bisenti", "TE"]],
        "64034": [["Appignano", "TE"], ["Castiglione Messer Raimondo", "TE"]],
        "64035": [["Castilenti", "TE"], ["Villa San Romualdo", "TE"]],
        "64036": [["Scorrano", "TE"], ["Cellino Attanasio", "TE"]],
        "64037": [["Montegualtieri", "TE"], ["Poggio Delle Rose", "TE"], ["Cermignano", "TE"]],
        "64039": [["Val Vomano", "TE"], ["Penna Sant'Andrea", "TE"]],
        "64040": [["Cortino", "TE"], ["Padula", "TE"], ["Pagliaroli", "TE"]],
        "64041": [["Castelli", "TE"], ["Colledoro", "TE"]],
        "64042": [["Colledara", "TE"], ["Villa Petto", "TE"], ["Ornano Grande", "TE"]],
        "64043": [
            ["Cesacastina", "TE"],
            ["Crognaleto", "TE"],
            ["Tottea", "TE"],
            ["San Giorgio", "TE"],
            ["Cervaro", "TE"],
            ["San Giorgio Di Crognaleto", "TE"],
            ["Macchia Vomano", "TE"],
            ["Nerito", "TE"],
            ["Poggio Umbricchio", "TE"],
        ],
        "64044": [["Cerqueto", "TE"], ["Fano Adriano", "TE"]],
        "64045": [
            ["Isola Del Gran Sasso D'Italia", "TE"],
            ["Fano A Corno", "TE"],
            ["Cerchiara", "TE"],
            ["Forca Di Valle", "TE"],
            ["San Gabriele Dell'Addolorata", "TE"],
        ],
        "64046": [
            ["Cusciano", "TE"],
            ["Collevecchio Di Montorio", "TE"],
            ["Leognano", "TE"],
            ["Montorio Al Vomano", "TE"],
        ],
        "64047": [["Intermesoli", "TE"], ["Pietracamela", "TE"]],
        "64049": [["Chiarino", "TE"], ["Azzinano", "TE"], ["Tossicia", "TE"]],
        "64100": [
            ["Piano D'Accio", "TE"],
            ["Valle San Giovanni", "TE"],
            ["San Nicolo' A Tordino", "TE"],
            ["Poggio San Vittorino", "TE"],
            ["Tordinia", "TE"],
            ["Varano", "TE"],
            ["Castagneto", "TE"],
            ["Forcella", "TE"],
            ["Nepezzano", "TE"],
            ["Miano", "TE"],
            ["Cartecchio", "TE"],
            ["Colleatterrato Alto", "TE"],
            ["Frondarola", "TE"],
            ["Sant'Atto", "TE"],
            ["Villa Ripa", "TE"],
            ["Colleminuccio", "TE"],
            ["Colle Santa Maria", "TE"],
            ["Teramo", "TE"],
            ["Villa Vomano", "TE"],
            ["Spiano", "TE"],
        ],
        "75010": [
            ["Miglionico", "MT"],
            ["Craco", "MT"],
            ["Garaguso", "MT"],
            ["Peschiera", "MT"],
            ["Grottole", "MT"],
            ["Oliveto Lucano", "MT"],
            ["Calciano", "MT"],
            ["Gorgoglione", "MT"],
            ["Cirigliano", "MT"],
            ["Aliano", "MT"],
            ["San Mauro Forte", "MT"],
        ],
        "75011": [["Accettura", "MT"]],
        "75012": [["Metaponto Lido", "MT"], ["Metaponto", "MT"], ["Bernalda", "MT"], ["Serra Marina", "MT"]],
        "75013": [["Macchia", "MT"], ["Borgo Macchia", "MT"], ["Ferrandina", "MT"]],
        "75014": [["Grassano", "MT"]],
        "75015": [["Pisticci", "MT"], ["Marconia", "MT"], ["Pisticci Scalo", "MT"]],
        "75016": [["Pomarico", "MT"]],
        "75017": [["Salandra", "MT"]],
        "75018": [["Stigliano", "MT"]],
        "75019": [["Tricarico", "MT"], ["Calle", "MT"]],
        "75020": [
            ["Nova Siri", "MT"],
            ["Nova Siri Scalo", "MT"],
            ["Scanzano Jonico", "MT"],
            ["Recoleta", "MT"],
            ["Nova Siri Stazione", "MT"],
        ],
        "75021": [["Colobraro", "MT"]],
        "75022": [["Irsina", "MT"], ["Taccone", "MT"]],
        "75023": [["Montalbano Jonico", "MT"]],
        "75024": [["Montescaglioso", "MT"]],
        "75025": [["Policoro", "MT"]],
        "75026": [["Rotondella", "MT"]],
        "75027": [["San Giorgio Lucano", "MT"]],
        "75028": [["Gannano", "MT"], ["Caprarico", "MT"], ["Tursi", "MT"]],
        "75029": [["Valsinni", "MT"]],
        "75100": [["La Martella", "MT"], ["Matera", "MT"], ["Venusio", "MT"]],
        "85010": [
            ["Gallicchio", "PZ"],
            ["Banzi", "PZ"],
            ["Albano Di Lucania", "PZ"],
            ["Abriola", "PZ"],
            ["San Chirico Nuovo", "PZ"],
            ["Armento", "PZ"],
            ["Calvello", "PZ"],
            ["Madonna Del Pantano", "PZ"],
            ["Pignola", "PZ"],
            ["Brindisi Montagna", "PZ"],
            ["Rifreddo", "PZ"],
            ["Pantano", "PZ"],
            ["Castelmezzano", "PZ"],
            ["Guardia Perticara", "PZ"],
            ["Campomaggiore", "PZ"],
            ["Cancellara", "PZ"],
            ["Pietrapertosa", "PZ"],
            ["Vaglio Basilicata", "PZ"],
            ["Missanello", "PZ"],
            ["Anzi", "PZ"],
        ],
        "85011": [["Acerenza", "PZ"]],
        "85012": [["Corleto Perticara", "PZ"]],
        "85013": [["Genzano Di Lucania", "PZ"]],
        "85014": [["Laurenzana", "PZ"]],
        "85015": [["Oppido Lucano", "PZ"]],
        "85016": [["Pietragalla", "PZ"], ["San Giorgio", "PZ"]],
        "85017": [["Tolve", "PZ"]],
        "85018": [["Trivigno", "PZ"]],
        "85020": [
            ["Ruvo Del Monte", "PZ"],
            ["Piano San Nicola", "PZ"],
            ["Ginestra", "PZ"],
            ["Sterpito", "PZ"],
            ["San Giorgio Di Pietragalla", "PZ"],
            ["Sant'Angelo Di Avigliano", "PZ"],
            ["Dragonetti", "PZ"],
            ["Filiano", "PZ"],
            ["Avigliano Scalo", "PZ"],
            ["Sant'Andrea", "PZ"],
            ["Rapone", "PZ"],
            ["Maschito", "PZ"],
            ["San Fele", "PZ"],
            ["Atella", "PZ"],
            ["San Nicola", "PZ"],
            ["Montemilone", "PZ"],
            ["Sant'Ilario", "PZ"],
            ["Lagopesole", "PZ"],
            ["Pescopagano", "PZ"],
            ["Scalera", "PZ"],
            ["Ripacandida", "PZ"],
            ["Sterpito Di Sotto", "PZ"],
            ["Sterpito Di Sopra", "PZ"],
        ],
        "85021": [
            ["Avigliano", "PZ"],
            ["Castel Lagopesole", "PZ"],
            ["San Cataldo", "PZ"],
            ["Sant'Angelo", "PZ"],
            ["San Cataldo Di Bella", "PZ"],
            ["Possidente", "PZ"],
            ["Piano Del Conte", "PZ"],
        ],
        "85022": [["Barile", "PZ"]],
        "85023": [["Forenza", "PZ"]],
        "85024": [["Gaudiano", "PZ"], ["Lavello", "PZ"]],
        "85025": [["Foggiano", "PZ"], ["Melfi", "PZ"], ["Leonessa Di Melfi", "PZ"]],
        "85026": [["Palazzo San Gervasio", "PZ"]],
        "85027": [["Rapolla", "PZ"]],
        "85028": [["Monticchio", "PZ"], ["Rionero In Vulture", "PZ"], ["Monticchio Bagni", "PZ"]],
        "85029": [["Venosa", "PZ"]],
        "85030": [
            ["Mezzana", "PZ"],
            ["Calvera", "PZ"],
            ["Casa Del Conte", "PZ"],
            ["San Costantino Albanese", "PZ"],
            ["Castronuovo Di Sant'Andrea", "PZ"],
            ["Carbone", "PZ"],
            ["Cersosimo", "PZ"],
            ["Terranova Di Pollino", "PZ"],
            ["San Severino Lucano", "PZ"],
            ["San Martino D'Agri", "PZ"],
            ["Villaneto", "PZ"],
            ["San Chirico Raparo", "PZ"],
            ["Mezzana Salice", "PZ"],
            ["San Paolo Albanese", "PZ"],
        ],
        "85031": [["Castelsaraceno", "PZ"], ["Frusci", "PZ"], ["Miraldo", "PZ"]],
        "85032": [["Teana", "PZ"], ["Chiaromonte", "PZ"]],
        "85033": [["Episcopia", "PZ"]],
        "85034": [["Fardella", "PZ"], ["Francavilla In Sinni", "PZ"]],
        "85035": [["Noepoli", "PZ"]],
        "85036": [["Roccanova", "PZ"]],
        "85037": [["San Brancato", "PZ"], ["Sant'Arcangelo", "PZ"]],
        "85038": [["Senise", "PZ"]],
        "85039": [["Spinoso", "PZ"]],
        "85040": [
            ["San Costantino", "PZ"],
            ["Rivello", "PZ"],
            ["Castelluccio Inferiore", "PZ"],
            ["San Costantino Di Rivello", "PZ"],
            ["Viggianello", "PZ"],
            ["Castelluccio Superiore", "PZ"],
            ["Pedali Di Viggianello", "PZ"],
            ["Nemoli", "PZ"],
        ],
        "85042": [["Lagonegro", "PZ"]],
        "85043": [["Latronico", "PZ"], ["Mileo", "PZ"], ["Cerri", "PZ"], ["Agromonte", "PZ"], ["Magnano", "PZ"]],
        "85044": [
            ["Lauria", "PZ"],
            ["Seluci", "PZ"],
            ["Lauria Superiore", "PZ"],
            ["Cogliandrino", "PZ"],
            ["Lauria Inferiore", "PZ"],
            ["Galdo", "PZ"],
            ["Galdo Di Lauria", "PZ"],
            ["Pecorone", "PZ"],
        ],
        "85046": [
            ["Massa", "PZ"],
            ["Fiumicello Santa Venere", "PZ"],
            ["Acquafredda", "PZ"],
            ["Maratea Porto", "PZ"],
            ["Maratea", "PZ"],
        ],
        "85047": [["Moliterno", "PZ"]],
        "85048": [["Rotonda", "PZ"]],
        "85049": [["Trecchina", "PZ"], ["Piano Dei Peri", "PZ"]],
        "85050": [
            ["Baragiano Scalo", "PZ"],
            ["Tito Scalo", "PZ"],
            ["Scalo Di Baragiano", "PZ"],
            ["Castelgrande", "PZ"],
            ["Balvano", "PZ"],
            ["Sarconi", "PZ"],
            ["Sasso Di Castalda", "PZ"],
            ["Satriano Di Lucania", "PZ"],
            ["Sant'Angelo Le Fratte", "PZ"],
            ["Tito", "PZ"],
            ["Villa D'Agri", "PZ"],
            ["Brienza", "PZ"],
            ["Savoia Di Lucania", "PZ"],
            ["Marsicovetere", "PZ"],
            ["Paterno", "PZ"],
            ["Baragiano", "PZ"],
            ["Grumento Nova", "PZ"],
        ],
        "85051": [["Bella", "PZ"], ["Sant'Antonio Casalini", "PZ"]],
        "85052": [["Galaino", "PZ"], ["Pergola", "PZ"], ["Marsico Nuovo", "PZ"]],
        "85053": [["Montemurro", "PZ"]],
        "85054": [["Muro Lucano", "PZ"], ["Capo Di Giano", "PZ"]],
        "85055": [["Picerno", "PZ"]],
        "85056": [["Ruoti", "PZ"]],
        "85057": [["Tramutola", "PZ"]],
        "85058": [["Mosileo", "PZ"], ["Vietri Di Potenza", "PZ"]],
        "85059": [["Viggiano", "PZ"]],
        "85100": [["Giuliano", "PZ"], ["Montocchio", "PZ"], ["Potenza", "PZ"]],
        "87010": [
            ["Lattarico", "CS"],
            ["Saracena", "CS"],
            ["Acquaformosa", "CS"],
            ["Mottafollone", "CS"],
            ["Regina", "CS"],
            ["Santa Maria Le Grotte", "CS"],
            ["San Martino Di Finita", "CS"],
            ["Cervicati", "CS"],
            ["Torano Castello", "CS"],
            ["Terranova Da Sibari", "CS"],
            ["Santa Caterina Albanese", "CS"],
            ["Civita", "CS"],
            ["Frascineto", "CS"],
            ["Malvito", "CS"],
            ["Firmo", "CS"],
            ["Sant'Agata Di Esaro", "CS"],
            ["Lungro", "CS"],
            ["Sartano", "CS"],
            ["San Basile", "CS"],
            ["Torano Castello Scalo", "CS"],
            ["Policastrello", "CS"],
            ["Eianina", "CS"],
            ["Rota Greca", "CS"],
            ["Ioggi", "CS"],
            ["San Donato Di Ninea", "CS"],
            ["San Sosti", "CS"],
        ],
        "87011": [
            ["Sibari Stazione", "CS"],
            ["Lattughelle", "CS"],
            ["Lauropoli", "CS"],
            ["Pianoscafo", "CS"],
            ["Sibari", "CS"],
            ["Doria", "CS"],
            ["Cassano Allo Ionio", "CS"],
        ],
        "87012": [["Vigne Di Castrovillari", "CS"], ["Castrovillari", "CS"]],
        "87013": [["Fagnano Castello", "CS"]],
        "87014": [["Laino Borgo", "CS"]],
        "87015": [["Laino Castello", "CS"]],
        "87016": [["Morano Calabro", "CS"]],
        "87017": [["Roggiano Gravina", "CS"]],
        "87018": [
            ["San Marco Argentano Stazione", "CS"],
            ["San Marco Roggiano Stazione", "CS"],
            ["San Marco Argentano", "CS"],
        ],
        "87019": [["Spezzano Albanese Stazione", "CS"], ["Spezzano Albanese Terme", "CS"], ["Spezzano Albanese", "CS"]],
        "87020": [
            ["San Nicola Arcella", "CS"],
            ["Sangineto", "CS"],
            ["Marcellina", "CS"],
            ["Acquappesa", "CS"],
            ["Maiera'", "CS"],
            ["Santa Domenica Talao", "CS"],
            ["Bonifati", "CS"],
            ["Guardia Piemontese Marina", "CS"],
            ["Grisolia", "CS"],
            ["Aieta", "CS"],
            ["Buonvicino", "CS"],
            ["Torrevecchia", "CS"],
            ["Orsomarso", "CS"],
            ["Guardia Piemontese Terme", "CS"],
            ["Le Crete", "CS"],
            ["Granata", "CS"],
            ["Cittadella Del Capo", "CS"],
            ["Tortora Marina", "CS"],
            ["Intavolata", "CS"],
            ["Guardia Piemontese", "CS"],
            ["Acquappesa Marina", "CS"],
            ["Marina Di Tortora", "CS"],
            ["Verbicaro", "CS"],
            ["Papasidero", "CS"],
            ["Santa Maria Del Cedro", "CS"],
            ["Sangineto Lido", "CS"],
            ["Tortora", "CS"],
        ],
        "87021": [["Laise", "CS"], ["Marina Di Belvedere Marittimo", "CS"], ["Belvedere Marittimo", "CS"]],
        "87022": [
            ["Cetraro Marina", "CS"],
            ["Cetraro", "CS"],
            ["Sant'Angelo Di Cetraro", "CS"],
            ["Battendieri", "CS"],
            ["San Filippo", "CS"],
            ["Sant'Angelo", "CS"],
        ],
        "87023": [["Cirella", "CS"], ["Diamante", "CS"]],
        "87024": [["Cariglio", "CS"], ["Marina Di Fuscaldo", "CS"], ["Scarcelli", "CS"], ["Fuscaldo", "CS"]],
        "87026": [["Mormanno", "CS"]],
        "87027": [
            ["Paola Marina", "CS"],
            ["Paola Santuario", "CS"],
            ["Paola", "CS"],
            ["San Miceli", "CS"],
            ["Fosse", "CS"],
            ["Santuario San Francesco", "CS"],
        ],
        "87028": [["Praia A Mare", "CS"]],
        "87029": [["Scalea", "CS"]],
        "87030": [
            ["San Vincenzo La Costa", "CS"],
            ["Longobardi Marina", "CS"],
            ["Carolei", "CS"],
            ["Belsito", "CS"],
            ["Domanico", "CS"],
            ["San Pietro In Amantea", "CS"],
            ["Falconara Albanese", "CS"],
            ["Savuto Di Cleto", "CS"],
            ["Malito", "CS"],
            ["Fiumefreddo Bruzio", "CS"],
            ["Cleto", "CS"],
            ["Serra D'Aiello", "CS"],
            ["Vadue", "CS"],
            ["Torremezzo Di Falconara", "CS"],
            ["Longobardi", "CS"],
            ["Savuto", "CS"],
            ["Scornavacca", "CS"],
            ["Gesuiti", "CS"],
            ["Torremezzo", "CS"],
            ["Marina Di Fiumefreddo Bruzio", "CS"],
            ["Stazione Di Fiumefreddo Bruzio", "CS"],
            ["San Biase", "CS"],
            ["Reggio", "CS"],
        ],
        "87031": [["Aiello Calabro", "CS"]],
        "87032": [["Amantea Marina", "CS"], ["Amantea", "CS"], ["Campora San Giovanni", "CS"], ["Corica", "CS"]],
        "87033": [["Belmonte Calabro Marina", "CS"], ["Belmonte Calabro", "CS"], ["Vadi", "CS"]],
        "87034": [["Grimaldi", "CS"]],
        "87035": [["Terrati", "CS"], ["Greci", "CS"], ["Aria Di Lupi", "CS"], ["Lago", "CS"]],
        "87036": [
            ["Roges", "CS"],
            ["Santo Stefano", "CS"],
            ["Arcavacata", "CS"],
            ["Commenda", "CS"],
            ["Rende", "CS"],
            ["Castiglione Cosentino Stazione", "CS"],
            ["Surdo", "CS"],
            ["Quattromiglia", "CS"],
        ],
        "87037": [["San Fili", "CS"], ["Bucita", "CS"]],
        "87038": [["San Lucido", "CS"], ["Pollella", "CS"]],
        "87040": [
            ["Mongrassano Stazione", "CS"],
            ["San Lorenzo Del Vallo", "CS"],
            ["San Giacomo Di Cerzeto", "CS"],
            ["Marano Principato", "CS"],
            ["Casal Di Basso", "CS"],
            ["Mongrassano", "CS"],
            ["Rosario", "CS"],
            ["Deposito Di Luzzi", "CS"],
            ["Rose", "CS"],
            ["Stazione Di Mongrassano", "CS"],
            ["San Bartolo", "CS"],
            ["Montalto Uffugo Scalo", "CS"],
            ["Cavallerizzo", "CS"],
            ["Timparello Di Luzzi", "CS"],
            ["San Giacomo", "CS"],
            ["Andreotta", "CS"],
            ["Taverna Di Montalto Uffugo", "CS"],
            ["Zumpano", "CS"],
            ["Malavicina", "CS"],
            ["Andreotta Di Castrolibero", "CS"],
            ["Castiglione Cosentino", "CS"],
            ["Mendicino", "CS"],
            ["Tarsia", "CS"],
            ["Luzzi", "CS"],
            ["Tivolille", "CS"],
            ["Marano Marchesato", "CS"],
            ["Paterno Calabro", "CS"],
            ["Ortomatera", "CS"],
            ["San Benedetto Ullano", "CS"],
            ["Timparello", "CS"],
            ["Maione", "CS"],
            ["Cerzeto", "CS"],
            ["Altilia", "CS"],
            ["Castrolibero", "CS"],
            ["Parenti", "CS"],
        ],
        "87041": [
            ["Acri", "CS"],
            ["Montagnola", "CS"],
            ["Serricella", "CS"],
            ["San Giacomo D'Acri", "CS"],
            ["Duglia", "CS"],
        ],
        "87042": [["Altomonte", "CS"]],
        "87043": [["Bisignano", "CS"]],
        "87044": [["Cerisano", "CS"]],
        "87045": [["Laurignano", "CS"], ["Tessano", "CS"], ["Dipignano", "CS"]],
        "87046": [
            ["Parantoro", "CS"],
            ["Caldopiano", "CS"],
            ["Vaccarizzo Di Montalto", "CS"],
            ["Vaccarizzo", "CS"],
            ["Montalto Uffugo", "CS"],
        ],
        "87047": [["Redipiano", "CS"], ["San Benedetto In Guarano", "CS"], ["San Pietro In Guarano", "CS"]],
        "87048": [["Santa Sofia D'Epiro", "CS"]],
        "87050": [
            ["Pian Del Lago", "CS"],
            ["Trenta", "CS"],
            ["Carpanzano", "CS"],
            ["Magli", "CS"],
            ["Serra Pedace", "CS"],
            ["Morelli", "CS"],
            ["Perito", "CS"],
            ["Casole Bruzio", "CS"],
            ["Rovito", "CS"],
            ["Bianchi", "CS"],
            ["Pedace", "CS"],
            ["Marzi", "CS"],
            ["Borboruso", "CS"],
            ["Panettieri", "CS"],
            ["Pedivigliano", "CS"],
            ["Colosimi", "CS"],
            ["Piane Crati", "CS"],
            ["Figline Vegliaturo", "CS"],
            ["Cellara", "CS"],
            ["Spezzano Piccolo", "CS"],
            ["Pietrafitta", "CS"],
            ["Mangone", "CS"],
            ["Silvana Mansio", "CS"],
            ["Lappano", "CS"],
        ],
        "87051": [["Vico", "CS"], ["Camarda Di Aprigliano", "CS"], ["Aprigliano", "CS"]],
        "87052": [
            ["Moccone", "CS"],
            ["Croce Di Magara", "CS"],
            ["Camigliatello Silano", "CS"],
            ["Camigliatello", "CS"],
            ["Fago Del Soldato", "CS"],
        ],
        "87053": [["Celico", "CS"]],
        "87054": [["Rogliano", "CS"], ["Saliano", "CS"]],
        "87055": [["Lorica", "CS"], ["Monte Oliveto", "CS"], ["San Giovanni In Fiore", "CS"]],
        "87056": [["Santo Stefano Di Rogliano", "CS"]],
        "87057": [["Scigliano", "CS"], ["Diano", "CS"], ["Calvisi", "CS"]],
        "87058": [["Spezzano Della Sila", "CS"]],
        "87060": [
            ["Marinella", "CS"],
            ["Vaccarizzo Albanese", "CS"],
            ["San Morello", "CS"],
            ["San Cosmo Albanese", "CS"],
            ["Terravecchia", "CS"],
            ["Pietrapaola Stazione", "CS"],
            ["Caloveto", "CS"],
            ["Paludi", "CS"],
            ["San Giorgio Albanese", "CS"],
            ["Calopezzati", "CS"],
            ["Crosia", "CS"],
            ["Camigliano", "CS"],
            ["Mirto", "CS"],
            ["Cropalati", "CS"],
            ["Vecchiarello", "CS"],
            ["Bocchigliero", "CS"],
            ["Pietrapaola", "CS"],
            ["Scala Coeli", "CS"],
            ["Mandatoriccio", "CS"],
        ],
        "87061": [["Campana", "CS"]],
        "87062": [["Cariati", "CS"], ["Cariati Marina", "CS"]],
        "87064": [
            ["Marina Di Schiavonea", "CS"],
            ["Fabrizio", "CS"],
            ["Villaggio Frasso", "CS"],
            ["Schiavonea", "CS"],
            ["Corigliano Calabro Stazione", "CS"],
            ["Corigliano Calabro", "CS"],
            ["Corigliano Scalo", "CS"],
            ["Cantinella", "CS"],
        ],
        "87066": [["Longobucco", "CS"], ["Destro", "CS"]],
        "87067": [["Rossano", "CS"], ["Piragineti", "CS"], ["Amica", "CS"], ["Rossano Stazione", "CS"]],
        "87069": [["Macchia Albanese", "CS"], ["San Demetrio Corone", "CS"]],
        "87070": [
            ["Castroregio", "CS"],
            ["Canna", "CS"],
            ["Plataci", "CS"],
            ["Farneta", "CS"],
            ["Albidona", "CS"],
            ["Cerchiara Di Calabria", "CS"],
            ["Alessandria Del Carretto", "CS"],
            ["Borgata Marina", "CS"],
            ["Nocara", "CS"],
            ["Montegiordano", "CS"],
            ["Roseto Capo Spulico Stazione", "CS"],
            ["Piana Di Cerchiara", "CS"],
            ["San Lorenzo Bellizzi", "CS"],
            ["Roseto Capo Spulico", "CS"],
            ["Montegiordano Marina", "CS"],
        ],
        "87071": [["Amendolara Marina", "CS"], ["Amendolara", "CS"]],
        "87072": [["Francavilla Marittima", "CS"]],
        "87073": [["Oriolo", "CS"]],
        "87074": [["Rocca Imperiale", "CS"], ["Rocca Imperiale Marina", "CS"]],
        "87075": [["Trebisacce", "CS"]],
        "87076": [
            ["Villapiana Lido", "CS"],
            ["Torre Cerchiar", "CS"],
            ["Villapiana", "CS"],
            ["Villapiana Scalo", "CS"],
        ],
        "87100": [
            ["Cosenza", "CS"],
            ["Donnici Superiore", "CS"],
            ["Donnici Inferiore", "CS"],
            ["Sant'Ippolito Di Cosenza", "CS"],
            ["Borgo Partenope", "CS"],
            ["Casali", "CS"],
            ["Sanvito", "CS"],
        ],
        "88020": [["Jacurso", "CZ"], ["Cortale", "CZ"]],
        "88021": [["Roccelletta", "CZ"], ["Borgia", "CZ"], ["San Floro", "CZ"]],
        "88022": [["Curinga", "CZ"], ["Acconia", "CZ"]],
        "88024": [["Girifalco", "CZ"]],
        "88025": [["San Pietro A Maida", "CZ"], ["Maida", "CZ"]],
        "88040": [
            ["Martelletto", "CZ"],
            ["Martirano", "CZ"],
            ["San Mango D'Aquino", "CZ"],
            ["San Pietro Apostolo", "CZ"],
            ["Cicala", "CZ"],
            ["Gizzeria Lido", "CZ"],
            ["Conflenti", "CZ"],
            ["Accaria Rosaria", "CZ"],
            ["Motta Santa Lucia", "CZ"],
            ["Amato", "CZ"],
            ["Settingiano", "CZ"],
            ["Castagna", "CZ"],
            ["Serrastretta", "CZ"],
            ["Platania", "CZ"],
            ["Martirano Lombardo", "CZ"],
            ["Pianopoli", "CZ"],
            ["Pratora Sarrottino", "CZ"],
            ["Carlopoli", "CZ"],
            ["San Michele", "CZ"],
            ["Cancello", "CZ"],
            ["Ievoli", "CZ"],
            ["Angoli", "CZ"],
            ["San Mazzeo", "CZ"],
            ["Feroleto Antico", "CZ"],
            ["Gizzeria", "CZ"],
            ["Miglierina", "CZ"],
            ["Accaria", "CZ"],
            ["Conflenti Inferiore", "CZ"],
            ["Migliuso", "CZ"],
        ],
        "88041": [["Decollatura", "CZ"], ["San Bernardo", "CZ"], ["Adami", "CZ"], ["Cerrisi", "CZ"]],
        "88042": [["Falerna Scalo", "CZ"], ["Falerna", "CZ"], ["Castiglione Marittimo", "CZ"]],
        "88044": [["Marcellinara", "CZ"]],
        "88045": [
            ["Gimigliano Inferiore", "CZ"],
            ["Gimigliano", "CZ"],
            ["Cavora' Di Gimigliano", "CZ"],
            ["Cavora'", "CZ"],
        ],
        "88046": [
            ["Santa Eufemia Lamezia", "CZ"],
            ["Bella Di Lamezia Terme", "CZ"],
            ["Fronti", "CZ"],
            ["Zangarona", "CZ"],
            ["Nicastro", "CZ"],
            ["Caronte", "CZ"],
            ["Sant'Eufemia Di Lamezia Terme", "CZ"],
            ["Sambiase Di Lamezia Terme", "CZ"],
            ["Gabella", "CZ"],
            ["San Pietro Lametino", "CZ"],
            ["Sambiase", "CZ"],
            ["Acquafredda", "CZ"],
            ["Lamezia Terme", "CZ"],
            ["Zangarona Di Lamezia Terme", "CZ"],
        ],
        "88047": [["Marina Di Nocera Terinese", "CZ"], ["Nocera Terinese", "CZ"]],
        "88049": [["San Tommaso", "CZ"], ["Colla", "CZ"], ["Soveria Mannelli", "CZ"]],
        "88050": [
            ["Simeri", "CZ"],
            ["Belcastro", "CZ"],
            ["Sellia", "CZ"],
            ["Amaroni", "CZ"],
            ["Petrona'", "CZ"],
            ["Crichi", "CZ"],
            ["Vallefiorita", "CZ"],
            ["Sorbo San Basile", "CZ"],
            ["Sellia Marina", "CZ"],
            ["La Petrizia", "CZ"],
            ["Palermiti", "CZ"],
            ["Fossato Serralta", "CZ"],
            ["Soveria Simeri", "CZ"],
            ["San Pietro", "CZ"],
            ["Uria", "CZ"],
            ["Magisano", "CZ"],
            ["Scoppolise", "CZ"],
            ["Simeri Crichi", "CZ"],
            ["Andali", "CZ"],
            ["Pentone", "CZ"],
            ["Marcedusa", "CZ"],
            ["Caraffa Di Catanzaro", "CZ"],
            ["Petrizia", "CZ"],
            ["Cerva", "CZ"],
            ["San Pietro Magisano", "CZ"],
            ["Calabricata", "CZ"],
            ["Zagarise", "CZ"],
        ],
        "88051": [["Cuturella", "CZ"], ["Cropani", "CZ"], ["Cropani Marina", "CZ"]],
        "88054": [["Sersale", "CZ"]],
        "88055": [
            ["San Giovanni", "CZ"],
            ["Albi", "CZ"],
            ["Buturo", "CZ"],
            ["Villaggio Racise", "CZ"],
            ["Taverna", "CZ"],
            ["San Giovanni D'Albi", "CZ"],
            ["Villaggio Mancuso", "CZ"],
        ],
        "88056": [["Pratora", "CZ"], ["Tiriolo", "CZ"]],
        "88060": [
            ["Davoli", "CZ"],
            ["Sant'Andrea Apostolo Dello Ionio", "CZ"],
            ["Montepaone", "CZ"],
            ["Torre Di Ruggiero", "CZ"],
            ["Marina Di Davoli", "CZ"],
            ["Argusto", "CZ"],
            ["San Sostene", "CZ"],
            ["Isca Marina", "CZ"],
            ["Montauro", "CZ"],
            ["Sant'Andrea Ionio Marina", "CZ"],
            ["San Sostene Marina", "CZ"],
            ["Badolato Marina", "CZ"],
            ["Badolato", "CZ"],
            ["Gagliato", "CZ"],
            ["Montepaone Lido", "CZ"],
            ["Marina Di Sant'Andrea Jonio", "CZ"],
            ["Isca Sullo Ionio", "CZ"],
            ["Petrizzi", "CZ"],
            ["Montauro Stazione", "CZ"],
            ["Satriano", "CZ"],
            ["Marina Di Guardavalle", "CZ"],
            ["Santa Caterina Dello Ionio Marina", "CZ"],
            ["Gasperina", "CZ"],
            ["Santa Caterina Dello Ionio", "CZ"],
        ],
        "88062": [["Cardinale", "CZ"], ["Novalba", "CZ"]],
        "88064": [["Chiaravalle Centrale", "CZ"]],
        "88065": [["Guardavalle", "CZ"], ["Guardavalle Marina", "CZ"]],
        "88067": [["Cenadi", "CZ"], ["Centrache", "CZ"], ["San Vito Sullo Ionio", "CZ"], ["Olivadi", "CZ"]],
        "88068": [["Soverato Superiore", "CZ"], ["Soverato Marina", "CZ"], ["Soverato", "CZ"]],
        "88069": [
            ["Squillace Lido", "CZ"],
            ["Staletti", "CZ"],
            ["Lido Di Squillace", "CZ"],
            ["Copanello", "CZ"],
            ["Squillace", "CZ"],
        ],
        "88070": [["Botricello", "CZ"]],
        "88100": [
            ["Pontegrande", "CZ"],
            ["Sant'Elia", "CZ"],
            ["Siano", "CZ"],
            ["Catanzaro Lido", "CZ"],
            ["Santa Maria Di Catanzaro", "CZ"],
            ["Catanzaro Sala", "CZ"],
            ["Catanzaro", "CZ"],
            ["Cava Di Catanzaro", "CZ"],
        ],
        "88811": [["Ciro' Marina", "KR"]],
        "88812": [["Crucoli", "KR"], ["Torretta", "KR"], ["Crucoli Torretta", "KR"]],
        "88813": [["Ciro'", "KR"]],
        "88814": [["Melissa", "KR"], ["Torre Melissa", "KR"]],
        "88815": [["Marina Di Strongoli", "KR"]],
        "88816": [["Strongoli", "KR"]],
        "88817": [["San Nicola Dell'Alto", "KR"], ["Carfizzi", "KR"]],
        "88818": [["Pallagorio", "KR"]],
        "88819": [["Verzino", "KR"]],
        "88821": [["Rocca Di Neto", "KR"], ["Corazzo", "KR"]],
        "88822": [["Zinga", "KR"], ["Casabona", "KR"]],
        "88823": [["Umbriatico", "KR"], ["Perticaro", "KR"]],
        "88824": [["Belvedere Di Spinello", "KR"]],
        "88825": [["Savelli", "KR"]],
        "88831": [["San Mauro Marchesato", "KR"], ["Scandale", "KR"]],
        "88832": [["Altilia", "KR"], ["Santa Severina", "KR"]],
        "88833": [["Caccuri", "KR"], ["Cerenzia", "KR"]],
        "88834": [["Castelsilano", "KR"]],
        "88835": [["Roccabernarda", "KR"]],
        "88836": [["Cotronei", "KR"]],
        "88837": [["Camellino", "KR"], ["Pagliarelle", "KR"], ["Foresta", "KR"], ["Petilia Policastro", "KR"]],
        "88838": [["Filippa", "KR"], ["Mesoraca", "KR"]],
        "88841": [
            ["Punta Le Castella", "KR"],
            ["Sant'Anna", "KR"],
            ["Le Castella", "KR"],
            ["Isola Di Capo Rizzuto", "KR"],
        ],
        "88842": [["San Leonardo Di Cutro", "KR"], ["Cutro", "KR"], ["Steccato Di Cutro", "KR"]],
        "88900": [["Villaggio Bucchi", "KR"], ["Crotone", "KR"], ["Papanice", "KR"]],
        "89010": [["Scido", "RC"], ["Terranova Sappo Minulio", "RC"], ["Varapodio", "RC"], ["Molochio", "RC"]],
        "89011": [
            ["Marinella", "RC"],
            ["Ceramida", "RC"],
            ["Pellegrina", "RC"],
            ["Porelli Di Bagnara", "RC"],
            ["Bagnara Calabra", "RC"],
            ["Solano Inferiore", "RC"],
        ],
        "89012": [["Delianuova", "RC"]],
        "89013": [["Marina Di Gioia Tauro", "RC"], ["Gioia Tauro", "RC"]],
        "89014": [
            ["Tresilico", "RC"],
            ["Zurgonadio", "RC"],
            ["Piminoro", "RC"],
            ["Castellace", "RC"],
            ["Messignadi", "RC"],
            ["Oppido Mamertina", "RC"],
        ],
        "89015": [["Palmi", "RC"], ["Taureana", "RC"], ["Trodio", "RC"]],
        "89016": [["Rizziconi", "RC"], ["Spina", "RC"], ["Drosi", "RC"], ["Cirello", "RC"]],
        "89017": [["San Giorgio Morgeto", "RC"]],
        "89018": [
            ["Acciarello", "RC"],
            ["Pezzo Di Villa San Giovanni", "RC"],
            ["Ferrito", "RC"],
            ["Cannitello", "RC"],
            ["Villa San Giovanni", "RC"],
        ],
        "89020": [
            ["Serrata", "RC"],
            ["San Procopio", "RC"],
            ["Anoia Superiore", "RC"],
            ["Tritanti", "RC"],
            ["Maropati", "RC"],
            ["Giffone", "RC"],
            ["Melicucca'", "RC"],
            ["Melicucco", "RC"],
            ["Sinopoli Inferiore", "RC"],
            ["Anoia", "RC"],
            ["San Pier Fedele", "RC"],
            ["Anoia Inferiore", "RC"],
            ["San Pietro Di Carida'", "RC"],
            ["Candidoni", "RC"],
            ["Sinopoli", "RC"],
        ],
        "89021": [["Cinquefrondi", "RC"]],
        "89022": [["Cittanova", "RC"]],
        "89023": [["Stelletanone", "RC"], ["Bellantone", "RC"], ["Laureana Di Borrello", "RC"]],
        "89024": [["Polistena", "RC"]],
        "89025": [["Bosco", "RC"], ["Rosarno", "RC"]],
        "89026": [["San Ferdinando", "RC"]],
        "89027": [["Sant'Eufemia D'Aspromonte", "RC"]],
        "89028": [["Seminara", "RC"], ["Barritteri", "RC"], ["Sant'Anna", "RC"], ["Sant'Anna Di Seminara", "RC"]],
        "89029": [
            ["San Martino", "RC"],
            ["Taurianova", "RC"],
            ["Amato Di Taurianova", "RC"],
            ["San Martino Di Taurianova", "RC"],
        ],
        "89030": [
            ["Condofuri", "RC"],
            ["Benestare", "RC"],
            ["Natile Vecchio", "RC"],
            ["Staiti", "RC"],
            ["Motticella", "RC"],
            ["Ferruzzano", "RC"],
            ["Careri", "RC"],
            ["Casignana", "RC"],
            ["Belloro", "RC"],
            ["Santuario Di Polsi", "RC"],
            ["San Luca", "RC"],
            ["Caraffa Del Bianco", "RC"],
            ["Natile Nuovo", "RC"],
            ["Sant'Agata Del Bianco", "RC"],
            ["Bruzzano Zeffirio", "RC"],
            ["Samo", "RC"],
            ["Africo", "RC"],
            ["Natile", "RC"],
            ["Canalello", "RC"],
            ["Condofuri Marina", "RC"],
            ["San Carlo", "RC"],
        ],
        "89031": [["Bombile", "RC"], ["San Nicola", "RC"], ["Ardore", "RC"]],
        "89032": [["Pardesca", "RC"], ["Bianco", "RC"]],
        "89033": [["Bova", "RC"]],
        "89034": [
            ["Bosco Sant'Ippolito", "RC"],
            ["Bovalino Marina", "RC"],
            ["Bovalino", "RC"],
            ["Bovalino Superiore", "RC"],
        ],
        "89035": [["Bova Marina", "RC"]],
        "89036": [["Brancaleone Marina", "RC"], ["Capo Spartivento", "RC"], ["Galati", "RC"], ["Brancaleone", "RC"]],
        "89037": [["Ardore Marina", "RC"], ["Marina D'Ardore", "RC"]],
        "89038": [["Marina Di Palizzi", "RC"], ["Palizzi", "RC"], ["Palizzi Marina", "RC"], ["Pietrapennata", "RC"]],
        "89039": [["Plati'", "RC"]],
        "89040": [
            ["Monasterace", "RC"],
            ["Martone", "RC"],
            ["Stignano", "RC"],
            ["Marina Di Caulonia", "RC"],
            ["Monasterace Marina", "RC"],
            ["Riace Marina", "RC"],
            ["Riace", "RC"],
            ["Canolo", "RC"],
            ["Marina Di Sant'Ilario Dello Ionio", "RC"],
            ["Gerace", "RC"],
            ["Canolo Nuova", "RC"],
            ["Cimina'", "RC"],
            ["Bivongi", "RC"],
            ["San Giovanni Di Gerace", "RC"],
            ["Condojanni", "RC"],
            ["Pazzano", "RC"],
            ["Agnana Calabra", "RC"],
            ["Antonimina", "RC"],
            ["Cirella", "RC"],
            ["Placanica", "RC"],
            ["Sant'Ilario Dello Ionio", "RC"],
            ["Camini", "RC"],
            ["Portigliola", "RC"],
        ],
        "89041": [
            ["San Nicola Di Caulonia", "RC"],
            ["Ursini", "RC"],
            ["Campoli Di Caulonia", "RC"],
            ["Caulonia Marina", "RC"],
            ["Caulonia", "RC"],
        ],
        "89042": [["Gioiosa Ionica", "RC"]],
        "89043": [["Grotteria", "RC"], ["Croce Ferrata", "RC"]],
        "89044": [["Merici", "RC"], ["Moschetta Di Locri", "RC"], ["Moschetta", "RC"], ["Locri", "RC"]],
        "89045": [["Mammola", "RC"]],
        "89046": [["Marina Di Gioiosa Ionica", "RC"]],
        "89047": [["Roccella Ionica", "RC"]],
        "89048": [["Siderno Superiore", "RC"], ["Donisi", "RC"], ["Siderno", "RC"], ["Siderno Marina", "RC"]],
        "89049": [["Stilo", "RC"]],
        "89050": [
            ["Villa Mesa", "RC"],
            ["Cosoleto", "RC"],
            ["Fiumara", "RC"],
            ["San Roberto", "RC"],
            ["Sant'Alessio In Aspromonte", "RC"],
            ["Feroleto Della Chiesa", "RC"],
            ["Colelli", "RC"],
            ["Sitizano", "RC"],
            ["Laganadi", "RC"],
            ["Acquacalda", "RC"],
            ["Plaesano", "RC"],
            ["Calanna", "RC"],
        ],
        "89052": [["Campo Calabro", "RC"]],
        "89054": [["Galatro", "RC"]],
        "89056": [["Lubrichi", "RC"], ["Santa Cristina D'Aspromonte", "RC"]],
        "89057": [["Santo Stefano In Aspromonte", "RC"], ["Gambarie", "RC"]],
        "89058": [["Scilla", "RC"], ["Favazzina", "RC"], ["Milea", "RC"], ["Melia", "RC"]],
        "89060": [
            ["Saline Joniche", "RC"],
            ["Ghorio", "RC"],
            ["Bagaladi", "RC"],
            ["Cardeto", "RC"],
            ["Roghudi Nuovo", "RC"],
            ["Roghudi", "RC"],
            ["Roccaforte Del Greco", "RC"],
        ],
        "89062": [["Lazzaro", "RC"]],
        "89063": [
            ["Melito Di Porto Salvo", "RC"],
            ["Anna'", "RC"],
            ["Pentedattilo", "RC"],
            ["Caredia", "RC"],
            ["Lacco", "RC"],
            ["Prunella", "RC"],
        ],
        "89064": [["Masella", "RC"], ["Fossato Ionico", "RC"], ["Montebello Ionico", "RC"], ["Saline Ioniche", "RC"]],
        "89065": [["Motta San Giovanni", "RC"]],
        "89069": [
            ["Marina Di San Lorenzo", "RC"],
            ["San Fantino", "RC"],
            ["Chorio", "RC"],
            ["San Lorenzo", "RC"],
            ["San Pantaleone", "RC"],
        ],
        "89100": [["Reggio Calabria", "RC"]],
        "89121": [["Reggio Calabria", "RC"], ["Archi", "RC"], ["Santa Caterina", "RC"]],
        "89122": [["Vito", "RC"], ["Reggio Calabria", "RC"]],
        "89123": [["Reggio Calabria", "RC"]],
        "89124": [["Reggio Calabria", "RC"], ["Eremo", "RC"]],
        "89125": [["Reggio Calabria", "RC"]],
        "89126": [
            ["Orti'", "RC"],
            ["Reggio Calabria", "RC"],
            ["Cerasi", "RC"],
            ["Arasi'", "RC"],
            ["Trizzino", "RC"],
            ["Schindilifa'", "RC"],
            ["Terreti", "RC"],
            ["Sant'Elia Di Condera", "RC"],
            ["Podargoni", "RC"],
            ["In Via Dalmazia", "RC"],
            ["Trabocchetto", "RC"],
            ["Orti' Superiore", "RC"],
            ["Orti' Inferiore", "RC"],
        ],
        "89127": [["Reggio Calabria", "RC"]],
        "89128": [["Reggio Calabria", "RC"], ["Spirito Santo", "RC"]],
        "89129": [["Reggio Calabria", "RC"]],
        "89131": [["Reggio Calabria", "RC"], ["Armo", "RC"], ["Ravagnese", "RC"], ["Gallina", "RC"], ["Puzzi", "RC"]],
        "89132": [["Reggio Calabria", "RC"]],
        "89133": [
            ["Reggio Calabria", "RC"],
            ["Cataforio", "RC"],
            ["Mosorrofa", "RC"],
            ["Sbarre", "RC"],
            ["San Sperato", "RC"],
            ["San Salvatore", "RC"],
            ["Pavigliana", "RC"],
            ["Cannavo'", "RC"],
            ["Vinco", "RC"],
            ["San Giorgio Extra", "RC"],
        ],
        "89134": [
            ["Rosario Valanidi", "RC"],
            ["San Gregorio", "RC"],
            ["Bocale", "RC"],
            ["Pellaro", "RC"],
            ["Croce Valanidi", "RC"],
        ],
        "89135": [
            ["Reggio Calabria", "RC"],
            ["Diminniti", "RC"],
            ["Sambatello", "RC"],
            ["Rosali'", "RC"],
            ["Gallico", "RC"],
            ["Villa San Giuseppe", "RC"],
            ["Salice Calabro", "RC"],
            ["Catona", "RC"],
        ],
        "89812": [["Pizzo", "VV"], ["Pizzo Marina", "VV"]],
        "89813": [["Polia", "VV"], ["Menniti", "VV"], ["Trecroci", "VV"]],
        "89814": [["Montesoro", "VV"], ["Scarro", "VV"], ["Filadelfia", "VV"]],
        "89815": [["Francavilla Angitola", "VV"]],
        "89816": [["Cessaniti", "VV"], ["San Cono", "VV"], ["Favelloni", "VV"], ["Pannaconi", "VV"]],
        "89817": [
            ["Sciconi", "VV"],
            ["Paradisoni", "VV"],
            ["Potenzoni", "VV"],
            ["San Costantino", "VV"],
            ["San Costantino Di Briatico", "VV"],
            ["Briatico", "VV"],
        ],
        "89818": [["Capistrano", "VV"]],
        "89819": [["Monterosso Calabro", "VV"]],
        "89821": [["Vallelonga", "VV"], ["San Nicola Da Crissa", "VV"]],
        "89822": [["Brognaturo", "VV"], ["Serra San Bruno", "VV"], ["Simbario", "VV"], ["Spadola", "VV"]],
        "89823": [["Mongiana", "VV"], ["Fabrizia", "VV"]],
        "89824": [["Nardodipace", "VV"]],
        "89831": [
            ["Sant'Angelo", "VV"],
            ["Sorianello", "VV"],
            ["Sant'Angelo Gerocarne", "VV"],
            ["Soriano Calabro", "VV"],
            ["Gerocarne", "VV"],
            ["Ciano", "VV"],
        ],
        "89832": [["Limpidi", "VV"], ["Acquaro", "VV"], ["Arena", "VV"], ["Dasa'", "VV"]],
        "89833": [["Melicucca' Di Dinami", "VV"], ["Monsoreto", "VV"], ["Dinami", "VV"]],
        "89834": [["Vazzano", "VV"], ["Pizzoni", "VV"]],
        "89841": [
            ["Rombiolo", "VV"],
            ["Presinaci", "VV"],
            ["Moladi", "VV"],
            ["Pernocari", "VV"],
            ["Arzona", "VV"],
            ["Filandari", "VV"],
            ["Pizzinni", "VV"],
        ],
        "89842": [["San Calogero", "VV"], ["Calimera Calabra", "VV"]],
        "89843": [["Stefanaconi", "VV"], ["Sant'Onofrio", "VV"], ["Filogaso", "VV"], ["Maierato", "VV"]],
        "89844": [
            ["Badia", "VV"],
            ["Limbadi", "VV"],
            ["Mandaradoni", "VV"],
            ["Marina Di Nicotera", "VV"],
            ["Nicotera", "VV"],
            ["Preitoni", "VV"],
            ["Motta Filocastro", "VV"],
            ["Comerconi", "VV"],
            ["Caroni", "VV"],
        ],
        "89851": [["Jonadi", "VV"], ["San Costantino Calabro", "VV"], ["Nao", "VV"], ["Francica", "VV"]],
        "89852": [["Mileto", "VV"], ["Paravati", "VV"], ["San Giovanni", "VV"], ["Comparni", "VV"]],
        "89853": [["San Gregorio D'Ippona", "VV"]],
        "89861": [["Tropea", "VV"], ["Parghelia", "VV"], ["Fitili", "VV"]],
        "89862": [["Drapia", "VV"], ["Gasponi", "VV"], ["Caria", "VV"], ["Brattiro'", "VV"]],
        "89863": [["Coccorino", "VV"], ["Joppolo", "VV"], ["Caroniti", "VV"]],
        "89864": [["Panaia", "VV"], ["Spilinga", "VV"]],
        "89866": [
            ["Barbalaconi", "VV"],
            ["San Nicolo' Di Ricadi", "VV"],
            ["Santa Domenica Ricadi", "VV"],
            ["San Nicolo'", "VV"],
            ["Santa Domenica", "VV"],
            ["Lampazzone", "VV"],
            ["Ricadi", "VV"],
        ],
        "89867": [["Zaccanopoli", "VV"], ["Zungri", "VV"]],
        "89868": [["Zambrone", "VV"], ["Daffina'", "VV"], ["San Giovanni Di Zambrone", "VV"]],
        "89900": [
            ["Longobardi", "VV"],
            ["Vibo Marina", "VV"],
            ["Vena Superiore", "VV"],
            ["Porto Salvo", "VV"],
            ["Vena", "VV"],
            ["Vibo Valentia Marina", "VV"],
            ["Piscopio", "VV"],
            ["Vibo Valentia", "VV"],
            ["Triparni", "VV"],
        ],
        "83010": [
            ["Grottolella", "AV"],
            ["Capriglia Irpina", "AV"],
            ["Torrioni", "AV"],
            ["Summonte", "AV"],
            ["Tufo", "AV"],
            ["Starze", "AV"],
            ["Sant'Angelo A Scala", "AV"],
            ["San Felice", "AV"],
            ["Chianche", "AV"],
            ["Starze Di Summonte", "AV"],
            ["Petruro Irpino", "AV"],
        ],
        "83011": [["Altavilla Irpina", "AV"]],
        "83012": [["Cervinara", "AV"], ["Trescine", "AV"], ["Ioffredo", "AV"]],
        "83013": [
            ["Santuario Di Montevergine", "AV"],
            ["Mercogliano", "AV"],
            ["Torelli", "AV"],
            ["Torelli Di Mercogliano", "AV"],
            ["Torrette", "AV"],
        ],
        "83014": [["Ospedaletto D'Alpinolo", "AV"]],
        "83015": [["Pietrastornina", "AV"], ["Ciardelli Inferiore", "AV"]],
        "83016": [["Tufara Valle", "AV"], ["Roccabascerana", "AV"], ["Squillani", "AV"], ["Cassano Caudino", "AV"]],
        "83017": [["Ferrari Di Cervinara", "AV"], ["Rotondi", "AV"]],
        "83018": [["San Martino Valle Caudina", "AV"]],
        "83020": [
            ["Tavernola San Felice", "AV"],
            ["Santa Lucia Di Serino", "AV"],
            ["Domicella", "AV"],
            ["Petruro", "AV"],
            ["Quadrelle", "AV"],
            ["Celzi", "AV"],
            ["Pago Del Vallo Di Lauro", "AV"],
            ["Forino", "AV"],
            ["Cesinali", "AV"],
            ["Aiello Del Sabato", "AV"],
            ["San Michele Di Serino", "AV"],
            ["Taurano", "AV"],
            ["Contrada", "AV"],
            ["Moschiano", "AV"],
            ["Sperone", "AV"],
            ["Casola", "AV"],
            ["Marzano Di Nola", "AV"],
            ["Quindici", "AV"],
            ["Sirignano", "AV"],
        ],
        "83021": [["Avella", "AV"]],
        "83022": [["Baiano", "AV"]],
        "83023": [["Lauro", "AV"], ["Fontenovella", "AV"], ["Migliano", "AV"]],
        "83024": [["Monteforte Irpino", "AV"], ["Molinelle", "AV"]],
        "83025": [
            ["Borgo Di Montoro Inferiore", "AV"],
            ["Montoro", "AV"],
            ["Preturo", "AV"],
            ["Aterrana", "AV"],
            ["Caliano", "AV"],
            ["Torchiati", "AV"],
            ["Piazza Di Pandola", "AV"],
            ["Figlioli", "AV"],
            ["Borgo", "AV"],
            ["Piano", "AV"],
            ["San Pietro", "AV"],
            ["Banzano", "AV"],
            ["Misciano", "AV"],
            ["Montoro Superiore", "AV"],
            ["Montoro Inferiore", "AV"],
        ],
        "83026": [["San Pietro Di Montoro Superiore", "AV"], ["Banzano Di Montoro Superiore", "AV"]],
        "83027": [["Mugnano Del Cardinale", "AV"]],
        "83028": [
            ["Serino", "AV"],
            ["Sala", "AV"],
            ["San Sossio Di Serino", "AV"],
            ["Canale", "AV"],
            ["San Biagio", "AV"],
            ["Ferrari Stazione Serino", "AV"],
        ],
        "83029": [["Sant'Andrea Apostolo", "AV"], ["Sant'Agata Irpina", "AV"], ["Solofra", "AV"]],
        "83030": [
            ["Savignano Irpino", "AV"],
            ["San Barbato", "AV"],
            ["Venticano", "AV"],
            ["Campanarello", "AV"],
            ["Montefredane", "AV"],
            ["Lapio", "AV"],
            ["Zungoli", "AV"],
            ["Prata Di Principato Ultra", "AV"],
            ["Melito Irpino", "AV"],
            ["Montefusco", "AV"],
            ["Dentecane", "AV"],
            ["Santa Paolina", "AV"],
            ["Manocalzati", "AV"],
            ["Arcella", "AV"],
            ["Serra", "AV"],
            ["Pietradefusi", "AV"],
            ["Sant'Angelo A Cancelli", "AV"],
            ["Torre Le Nocelle", "AV"],
            ["Montaguto", "AV"],
            ["Greci", "AV"],
            ["Montefalcione", "AV"],
            ["Sant'Elena Irpina", "AV"],
            ["Savignano Stazione", "AV"],
            ["Castello Del Lago", "AV"],
            ["Taurasi", "AV"],
            ["Villanova Del Battista", "AV"],
        ],
        "83031": [
            ["Ariano Irpino Stazione", "AV"],
            ["Palazzisi", "AV"],
            ["Ariano Irpino", "AV"],
            ["La Manna", "AV"],
            ["Ariano Scalo", "AV"],
            ["Orneta", "AV"],
        ],
        "83032": [["Morroni", "AV"], ["Bonito", "AV"]],
        "83034": [["Casalbore", "AV"]],
        "83035": [["Grottaminarda", "AV"], ["Carpignano", "AV"]],
        "83036": [["Calore", "AV"], ["Pianopantano", "AV"], ["Mirabella Eclano", "AV"], ["Passo Di Mirabella", "AV"]],
        "83037": [["Montecalvo Irpino", "AV"]],
        "83038": [["Montemiletto", "AV"], ["Montaperto", "AV"]],
        "83039": [
            ["Serra", "AV"],
            ["Pratola Serra", "AV"],
            ["San Michele Di Pratola Serra", "AV"],
            ["Serra Di Pratola Serra", "AV"],
            ["San Michele Di Pratola", "AV"],
        ],
        "83040": [
            ["Cassano Irpino", "AV"],
            ["Castelvetere Sul Calore", "AV"],
            ["Fontanarosa", "AV"],
            ["Carife", "AV"],
            ["Alvano", "AV"],
            ["Materdomini", "AV"],
            ["Chiusano Di San Domenico", "AV"],
            ["Andretta", "AV"],
            ["Castelfranci", "AV"],
            ["Castel Baronia", "AV"],
            ["Mattinella", "AV"],
            ["Cairano", "AV"],
            ["Gesualdo", "AV"],
            ["Conza Della Campania", "AV"],
            ["Guardia Lombardi", "AV"],
            ["Luogosano", "AV"],
            ["Pila Ai Piani", "AV"],
            ["Quaglietta", "AV"],
            ["Frigento", "AV"],
            ["Flumeri", "AV"],
            ["Calabritto", "AV"],
            ["Montemarano", "AV"],
            ["Caposele", "AV"],
            ["Morra De Sanctis", "AV"],
            ["Candida", "AV"],
            ["Pagliara", "AV"],
        ],
        "83041": [["Aquilonia", "AV"]],
        "83042": [["Atripalda", "AV"]],
        "83043": [["Laceno", "AV"], ["Villaggio Laceno", "AV"], ["Bagnoli Irpino", "AV"]],
        "83044": [["Piano Regolatore", "AV"], ["Bisaccia Nuova", "AV"], ["Bisaccia", "AV"]],
        "83045": [["Calitri", "AV"]],
        "83046": [["Lacedonia", "AV"]],
        "83047": [["Lioni", "AV"]],
        "83048": [["Sorbo Di Montella", "AV"], ["Fontana Di Montella", "AV"], ["Montella", "AV"]],
        "83049": [["Monteverde", "AV"]],
        "83050": [
            ["Rocca San Felice", "AV"],
            ["Volturara Irpina", "AV"],
            ["Sant'Angelo All'Esca", "AV"],
            ["San Mango Sul Calore", "AV"],
            ["Parolise", "AV"],
            ["San Potito Ultra", "AV"],
            ["Sorbo Serpico", "AV"],
            ["Santo Stefano Del Sole", "AV"],
            ["Scampitella", "AV"],
            ["San Sossio Baronia", "AV"],
            ["Salza Irpina", "AV"],
            ["Villamaina", "AV"],
            ["San Nicola Baronia", "AV"],
            ["Vallesaccarda", "AV"],
            ["Senerchia", "AV"],
        ],
        "83051": [["Ponteromito", "AV"], ["Nusco", "AV"]],
        "83052": [["Paternopoli", "AV"]],
        "83053": [["Sant'Andrea Di Conza", "AV"]],
        "83054": [["Sant'Angelo Dei Lombardi", "AV"], ["San Vito", "AV"], ["San Vito Dei Lombardi", "AV"]],
        "83055": [["Sturno", "AV"]],
        "83056": [["Teora", "AV"]],
        "83057": [["Torella Dei Lombardi", "AV"]],
        "83058": [["Trevico", "AV"], ["Molini", "AV"]],
        "83059": [["Vallata", "AV"]],
        "83100": [["Avellino", "AV"], ["Valle Ponticelli", "AV"], ["Bellizzi Irpino", "AV"], ["Picarelli", "AV"]],
        "82010": [
            ["Moiano", "BN"],
            ["San Giovanni Di Ceppaloni", "BN"],
            ["Ripabianca", "BN"],
            ["Beltiglio", "BN"],
            ["San Nicola Manfredi", "BN"],
            ["Perrillo", "BN"],
            ["Iannassi", "BN"],
            ["Bosco Perrotta", "BN"],
            ["Motta", "BN"],
            ["Bucciano", "BN"],
            ["San Martino Sannita", "BN"],
            ["Maccoli", "BN"],
            ["Beltiglio Di Ceppaloni", "BN"],
            ["Luzzano", "BN"],
            ["Bagnara", "BN"],
            ["Arpaise", "BN"],
            ["Pastene", "BN"],
            ["Sant'Angelo A Cupolo", "BN"],
            ["Montorsi", "BN"],
            ["Monterocchetta", "BN"],
            ["Terranova", "BN"],
            ["Terranova D'Arpaise", "BN"],
            ["Pagliara", "BN"],
            ["Ripabianca Tressanti", "BN"],
            ["Ceppaloni", "BN"],
            ["Cavuoti", "BN"],
            ["San Leucio Del Sannio", "BN"],
        ],
        "82011": [["Forchia", "BN"], ["Arpaia", "BN"], ["Paolisi", "BN"], ["Airola", "BN"]],
        "82013": [["Bonea", "BN"]],
        "82015": [["Durazzano", "BN"]],
        "82016": [["Cirignano", "BN"], ["Varoni", "BN"], ["Montesarchio", "BN"]],
        "82017": [["Pannarano", "BN"]],
        "82018": [
            ["San Giovanni Di San Giorgio Del Sannio", "BN"],
            ["Calvi", "BN"],
            ["Cubante", "BN"],
            ["San Giorgio Del Sannio", "BN"],
            ["San Nazzaro", "BN"],
        ],
        "82019": [["Bagnoli", "BN"], ["Faggiano", "BN"], ["Sant'Agata De' Goti", "BN"], ["Laiano", "BN"]],
        "82020": [
            ["San Giorgio La Molara", "BN"],
            ["Ginestra Degli Schiavoni", "BN"],
            ["Pesco Sannita", "BN"],
            ["Circello", "BN"],
            ["Santa Croce Del Sannio", "BN"],
            ["Paduli", "BN"],
            ["Campolattaro", "BN"],
            ["Fragneto L'Abate", "BN"],
            ["Pago Veiano", "BN"],
            ["Fragneto Monforte", "BN"],
            ["Reino", "BN"],
            ["Pietrelcina", "BN"],
            ["Baselice", "BN"],
            ["Foiano Di Val Fortore", "BN"],
            ["Molinara", "BN"],
            ["Buonalbergo", "BN"],
        ],
        "82021": [["Apice Nuovo", "BN"], ["Apice", "BN"], ["Sant'Arcangelo Trimonte", "BN"]],
        "82022": [["Castelfranco In Miscano", "BN"]],
        "82023": [["Castelvetere In Val Fortore", "BN"]],
        "82024": [["Colle Sannita", "BN"], ["Castelpagano", "BN"], ["Decorata", "BN"]],
        "82025": [["Montefalcone Di Val Fortore", "BN"]],
        "82026": [["Sassinoro", "BN"], ["Morcone", "BN"], ["Cuffiano", "BN"]],
        "82027": [["Giallonardo", "BN"], ["Casalduni", "BN"], ["Pontelandolfo", "BN"]],
        "82028": [["San Bartolomeo In Galdo", "BN"]],
        "82029": [["San Marco Dei Cavoti", "BN"]],
        "82030": [
            ["Torrecuso", "BN"],
            ["Pietraroja", "BN"],
            ["Limatola", "BN"],
            ["Ponte", "BN"],
            ["Melizzano", "BN"],
            ["Dugenta", "BN"],
            ["Ave Gratia Plena", "BN"],
            ["Foglianise", "BN"],
            ["Castelpoto", "BN"],
            ["Paupisi", "BN"],
            ["Campoli Del Monte Taburno", "BN"],
            ["Biancano", "BN"],
            ["Massa", "BN"],
            ["Apollosa", "BN"],
            ["Giardoni", "BN"],
            ["San Lorenzello", "BN"],
            ["Frasso Telesino", "BN"],
            ["San Salvatore Telesino", "BN"],
            ["Tocco Caudio", "BN"],
            ["Cautano", "BN"],
            ["Faicchio", "BN"],
            ["Cacciano", "BN"],
            ["Torello", "BN"],
            ["Puglianello", "BN"],
            ["Torello Di Melizzano", "BN"],
        ],
        "82031": [["Amorosi", "BN"]],
        "82032": [["Cerreto Sannita", "BN"]],
        "82033": [["Civitella Licinio", "BN"], ["Cusano Mutri", "BN"]],
        "82034": [["San Lupo", "BN"], ["Guardia Sanframondi", "BN"], ["San Lorenzo Maggiore", "BN"]],
        "82036": [["Solopaca", "BN"]],
        "82037": [["Telese Terme", "BN"], ["Castelvenere", "BN"]],
        "82038": [["Vitulano", "BN"]],
        "82100": [["Benevento", "BN"], ["Perrillo", "BN"], ["Pastene", "BN"]],
        "81010": [
            ["Letino", "CE"],
            ["Torcino", "CE"],
            ["Squille", "CE"],
            ["Latina Di Baia", "CE"],
            ["Gioia Sannitica", "CE"],
            ["Dragoni", "CE"],
            ["Carattano", "CE"],
            ["Gallo Matese", "CE"],
            ["Calvisi", "CE"],
            ["Baia E Latina", "CE"],
            ["San Giorgio", "CE"],
            ["Ailano", "CE"],
            ["Vallelunga", "CE"],
            ["Ciorlano", "CE"],
            ["Valle Agricola", "CE"],
            ["Pratella", "CE"],
            ["Alvignanello", "CE"],
            ["Castel Campagnano", "CE"],
            ["Prata Sannita", "CE"],
            ["San Gregorio Matese", "CE"],
            ["Ruviano", "CE"],
        ],
        "81011": [["Totari", "CE"], ["Alife", "CE"]],
        "81012": [["Alvignano", "CE"], ["Marciano Freddo", "CE"]],
        "81013": [
            ["Villa Santa Croce", "CE"],
            ["Piana Di Monte Verna", "CE"],
            ["San Giovanni E Paolo", "CE"],
            ["Caiazzo", "CE"],
        ],
        "81014": [["Fontegreca", "CE"], ["Capriati A Volturno", "CE"]],
        "81016": [
            ["Piedimonte D'Alife", "CE"],
            ["San Potito Sannitico", "CE"],
            ["Castello Del Matese", "CE"],
            ["Piedimonte Matese", "CE"],
            ["Sepicciano", "CE"],
        ],
        "81017": [["Quattroventi", "CE"], ["Sant'Angelo D'Alife", "CE"], ["Raviscanina", "CE"]],
        "81020": [
            ["Castel Morrone", "CE"],
            ["Capodrise", "CE"],
            ["Casapulla", "CE"],
            ["San Nicola La Strada", "CE"],
            ["Valle Di Maddaloni", "CE"],
            ["San Marco Evangelista", "CE"],
            ["Annunziata", "CE"],
            ["Recale", "CE"],
        ],
        "81021": [["Arienzo", "CE"]],
        "81022": [["Casagiove", "CE"]],
        "81023": [["Messercola", "CE"], ["Cervino", "CE"], ["Forchia Di Cervino", "CE"]],
        "81024": [["Grotticella", "CE"], ["Montedecoro", "CE"], ["Maddaloni", "CE"]],
        "81025": [["Cantone", "CE"], ["Marcianise", "CE"]],
        "81027": [
            ["San Felice A Cancello", "CE"],
            ["Cancello Di Ferrovia", "CE"],
            ["Cave", "CE"],
            ["San Marco Trotti", "CE"],
            ["Cave Di San Felice", "CE"],
            ["Polvica", "CE"],
        ],
        "81028": [["Santa Maria A Vico", "CE"]],
        "81030": [
            ["Arnone", "CE"],
            ["Orta Di Atella", "CE"],
            ["Teverola", "CE"],
            ["Villa Di Briano", "CE"],
            ["Cancello Ed Arnone", "CE"],
            ["Baia Domizia", "CE"],
            ["Carinola", "CE"],
            ["Frignano", "CE"],
            ["Castel Volturno", "CE"],
            ["Cesa", "CE"],
            ["Casale Di Carinola", "CE"],
            ["Sant'Arpino", "CE"],
            ["Succivo", "CE"],
            ["Villaggio Coppola Pinetamare", "CE"],
            ["Casale", "CE"],
            ["Cellole", "CE"],
            ["Lusciano", "CE"],
            ["Casaluce", "CE"],
            ["Nocelleto", "CE"],
            ["Cancello", "CE"],
            ["Gricignano Di Aversa", "CE"],
            ["Parete", "CE"],
            ["Casanova", "CE"],
            ["Falciano Del Massico", "CE"],
            ["San Marcellino", "CE"],
            ["Casapesenna", "CE"],
        ],
        "81031": [["Aversa", "CE"]],
        "81032": [["Carinaro", "CE"]],
        "81033": [["Casal Di Principe", "CE"]],
        "81034": [["Mondragone", "CE"]],
        "81035": [
            ["Gallo", "CE"],
            ["Ameglio", "CE"],
            ["Roccamonfina", "CE"],
            ["Marzano Appio", "CE"],
            ["Fontanafredda", "CE"],
            ["Campagnola", "CE"],
            ["Filorsi", "CE"],
            ["Garofali", "CE"],
            ["Grottola", "CE"],
        ],
        "81036": [["San Cipriano D'Aversa", "CE"]],
        "81037": [
            ["Cupa E Fasani", "CE"],
            ["Corigliano", "CE"],
            ["Piedimonte Di Sessa Aurunca", "CE"],
            ["Santa Maria Valongo", "CE"],
            ["San Castrese", "CE"],
            ["Sant'Agata", "CE"],
            ["Carano", "CE"],
            ["Fasani", "CE"],
            ["San Martino", "CE"],
            ["San Carlo", "CE"],
            ["Lauro Di Sessa Aurunca", "CE"],
            ["San Carlo Di Sessa Aurunca", "CE"],
            ["Fontanaradina", "CE"],
            ["San Martino Di Sessa Aurunca", "CE"],
            ["Avezzano Sorbello", "CE"],
            ["Sessa Aurunca", "CE"],
            ["Carano Di Sessa Aurunca", "CE"],
            ["Piedimonte", "CE"],
            ["Cupa", "CE"],
            ["Valogno", "CE"],
            ["Cascano", "CE"],
        ],
        "81038": [["Trentola Ducenta", "CE"]],
        "81039": [["Bonifica Villa Literno", "CE"], ["Villa Literno", "CE"]],
        "81040": [
            ["Rocca D'Evandro", "CE"],
            ["Cisterna", "CE"],
            ["Maiorano Di Monte", "CE"],
            ["Castel Di Sasso", "CE"],
            ["Treglia", "CE"],
            ["Formicola", "CE"],
            ["Curti", "CE"],
            ["Bivio Mortola", "CE"],
            ["Pontelatone", "CE"],
            ["Pietravairano", "CE"],
            ["Cocuruzzo", "CE"],
            ["Camino", "CE"],
            ["Liberi", "CE"],
            ["San Felice A Pietravairano", "CE"],
            ["San Felice", "CE"],
            ["Cisterna Di Castel Di Sasso", "CE"],
            ["Borgo Sant'Antonio Abate", "CE"],
        ],
        "81041": [["Vitulazio", "CE"], ["Bellona", "CE"]],
        "81042": [
            ["Calvi Risorta", "CE"],
            ["Petrulo", "CE"],
            ["Pozzillo", "CE"],
            ["Val D'Assano", "CE"],
            ["Rocchetta E Croce", "CE"],
            ["Giano Vetusto", "CE"],
            ["Petrullo", "CE"],
            ["Visciano", "CE"],
        ],
        "81043": [["Capua", "CE"], ["Sant'Angelo In Formis", "CE"]],
        "81044": [
            ["San Clemente", "CE"],
            ["Tora", "CE"],
            ["Piccilli", "CE"],
            ["Orchi", "CE"],
            ["Conca Della Campania", "CE"],
            ["Sipicciano", "CE"],
            ["Galluccio", "CE"],
            ["Tora E Piccilli", "CE"],
            ["Cave", "CE"],
            ["Vaglie", "CE"],
        ],
        "81046": [["Grazzanise", "CE"], ["Brezza", "CE"], ["Borgo Rurale Appio", "CE"], ["Borgo Appio", "CE"]],
        "81047": [["Macerata Campania", "CE"], ["Caturano", "CE"]],
        "81049": [["Mignano Monte Lungo", "CE"], ["San Pietro Infine", "CE"], ["Caspoli", "CE"]],
        "81050": [
            ["Portico Di Caserta", "CE"],
            ["San Felice", "CE"],
            ["Musicile", "CE"],
            ["Santa Maria La Fossa", "CE"],
            ["Montanaro", "CE"],
            ["Pastorano", "CE"],
            ["Francolise", "CE"],
            ["Ciamprisco", "CE"],
            ["Sant'Andrea Del Pizzone", "CE"],
            ["Pantuliano", "CE"],
            ["Camigliano", "CE"],
            ["San Tammaro", "CE"],
            ["Presenzano", "CE"],
        ],
        "81051": [["Roccaromana", "CE"], ["Statigliano", "CE"], ["Pietramelara", "CE"]],
        "81052": [["Pignataro Maggiore", "CE"]],
        "81053": [["Riardo", "CE"]],
        "81054": [["San Prisco", "CE"]],
        "81055": [["Santa Maria Capua Vetere", "CE"]],
        "81056": [["Sparanise", "CE"]],
        "81057": [
            ["San Marco", "CE"],
            ["Casale Di Teano", "CE"],
            ["Furnolo", "CE"],
            ["Pugliano", "CE"],
            ["Casamostra", "CE"],
            ["Teano", "CE"],
            ["Casafredda", "CE"],
            ["Versano", "CE"],
            ["Fontanelle", "CE"],
            ["Casi", "CE"],
            ["Casale", "CE"],
            ["San Giuliano", "CE"],
        ],
        "81058": [
            ["Vairano", "CE"],
            ["Vairano Scalo", "CE"],
            ["Patenora", "CE"],
            ["Marzanello", "CE"],
            ["Vairano Patenora", "CE"],
        ],
        "81059": [["Santa Lucia", "CE"], ["Caianello", "CE"], ["Vairano Stazione", "CE"], ["Montano", "CE"]],
        "81100": [
            ["Casolla", "CE"],
            ["Tredici", "CE"],
            ["Staturano", "CE"],
            ["Briano", "CE"],
            ["Tuoro", "CE"],
            ["Ercole", "CE"],
            ["Mezzano", "CE"],
            ["Caserta", "CE"],
            ["Falciano", "CE"],
            ["Santa Barbara", "CE"],
            ["Puccianiello", "CE"],
            ["Vaccheria", "CE"],
            ["Centurano", "CE"],
            ["San Clemente Di Caserta", "CE"],
            ["Casola", "CE"],
            ["San Leucio", "CE"],
            ["Sala Di Caserta", "CE"],
            ["San Clemente", "CE"],
            ["Casertavecchia", "CE"],
            ["Casola Di Caserta", "CE"],
        ],
        "80010": [["Scalzapecora", "NA"], ["Quarto", "NA"], ["Torretta", "NA"], ["Villaricca", "NA"]],
        "80011": [["Pezzalunga", "NA"], ["Acerra", "NA"]],
        "80012": [["Calvizzano", "NA"]],
        "80013": [
            ["Casalnuovo Di Napoli", "NA"],
            ["Tavernanova", "NA"],
            ["Licignano Di Napoli", "NA"],
            ["Casarea", "NA"],
        ],
        "80014": [["Giugliano In Campania", "NA"], ["Varcaturo", "NA"], ["Lago Patria", "NA"]],
        "80016": [["Torre Piscitelli", "NA"], ["San Rocco", "NA"], ["Marano Di Napoli", "NA"]],
        "80017": [["Melito Di Napoli", "NA"]],
        "80018": [["Mugnano Di Napoli", "NA"]],
        "80019": [["Qualiano", "NA"]],
        "80020": [["Crispano", "NA"], ["Parco Delle Acacie", "NA"], ["Casavatore", "NA"], ["Frattaminore", "NA"]],
        "80021": [["Afragola", "NA"]],
        "80022": [["Arzano", "NA"]],
        "80023": [["Pascarola", "NA"], ["Caivano", "NA"]],
        "80024": [["Carditello", "NA"], ["Cardito", "NA"]],
        "80025": [["Casandrino", "NA"]],
        "80026": [["Arpino", "NA"], ["Casoria", "NA"]],
        "80027": [["Frattamaggiore", "NA"]],
        "80028": [["Grumo Nevano", "NA"]],
        "80029": [["Sant'Antimo", "NA"]],
        "80030": [
            ["San Vitaliano", "NA"],
            ["Camposano", "NA"],
            ["Cimitile", "NA"],
            ["Castello Di Cisterna", "NA"],
            ["Visciano", "NA"],
            ["Spartimento", "NA"],
            ["Gallo", "NA"],
            ["Carbonara Di Nola", "NA"],
            ["Comiziano", "NA"],
            ["Gargani", "NA"],
            ["Mariglianella", "NA"],
            ["Schiava", "NA"],
            ["Scisciano", "NA"],
            ["Liveri", "NA"],
            ["Tufino", "NA"],
            ["San Paolo Bel Sito", "NA"],
            ["Roccarainola", "NA"],
        ],
        "80031": [["Brusciano", "NA"]],
        "80032": [["Casamarciano", "NA"]],
        "80033": [["Cicciano", "NA"]],
        "80034": [["Marigliano", "NA"], ["Faibano", "NA"], ["Lausdomini", "NA"], ["Selva", "NA"], ["Casaferro", "NA"]],
        "80035": [["Nola", "NA"], ["Polvica", "NA"], ["Piazzolla", "NA"], ["Cinquevie", "NA"], ["Pollastri", "NA"]],
        "80036": [["Palma Campania", "NA"], ["Vico Di Palma", "NA"], ["Vico", "NA"], ["Castello", "NA"]],
        "80038": [["Pomigliano D'Arco", "NA"]],
        "80039": [["Saviano", "NA"], ["Piazzolla Di Saviano", "NA"]],
        "80040": [
            ["Volla", "NA"],
            ["Boccia Al Mauro", "NA"],
            ["San Gennaro Vesuviano", "NA"],
            ["Flocco", "NA"],
            ["Caravita", "NA"],
            ["Terzigno", "NA"],
            ["Massa Di Somma", "NA"],
            ["Musci", "NA"],
            ["Trecase", "NA"],
            ["Poggiomarino", "NA"],
            ["Cercola", "NA"],
            ["San Sebastiano Al Vesuvio", "NA"],
            ["Striano", "NA"],
            ["Pollena Trocchia", "NA"],
        ],
        "80041": [["Boscoreale", "NA"], ["Marchesa", "NA"]],
        "80042": [["Boscotrecase", "NA"]],
        "80044": [["Ottaviano", "NA"], ["San Gennarello", "NA"]],
        "80045": [["Mariconda", "NA"], ["Messigno", "NA"], ["Pompei", "NA"], ["Pompei Scavi", "NA"]],
        "80046": [["San Giorgio A Cremano", "NA"]],
        "80047": [["Santa Maria La Scala", "NA"], ["San Giuseppe Vesuviano", "NA"], ["Casilli", "NA"]],
        "80048": [
            ["Madonna Dell'Arco", "NA"],
            ["Starza Vecchia", "NA"],
            ["Ponte Di Ferro", "NA"],
            ["Sant'Anastasia", "NA"],
        ],
        "80049": [["Somma Vesuviana", "NA"]],
        "80050": [
            ["Santa Maria La Carita'", "NA"],
            ["Pimonte", "NA"],
            ["Piazza Roma", "NA"],
            ["Tralia", "NA"],
            ["Franche", "NA"],
            ["Piazza", "NA"],
            ["Casola Di Napoli", "NA"],
            ["San Nicola", "NA"],
            ["Lettere", "NA"],
        ],
        "80051": [["Agerola", "NA"], ["Pianillo", "NA"], ["San Lazzaro Di Agerola", "NA"], ["Bomerano", "NA"]],
        "80053": [
            ["Castellammare Di Stabia", "NA"],
            ["Scanzano", "NA"],
            ["Ponte Della Persica", "NA"],
            ["Quisisana", "NA"],
        ],
        "80054": [["Caprile", "NA"], ["Gragnano", "NA"]],
        "80055": [["Portici", "NA"], ["Bellavista", "NA"]],
        "80056": [["Ercolano", "NA"], ["Resina", "NA"]],
        "80057": [["Sant'Antonio Abate", "NA"]],
        "80058": [["Torre Annunziata", "NA"]],
        "80059": [["Torre Del Greco", "NA"], ["Leopardi", "NA"], ["Santa Maria La Bruna", "NA"]],
        "80060": [["Massaquano", "NA"], ["Monte Faito", "NA"]],
        "80061": [
            ["Massa Lubrense", "NA"],
            ["Nerano", "NA"],
            ["Sant'Agata Sui Due Golfi", "NA"],
            ["Termini", "NA"],
            ["Monticchio Di Massa Lubrense", "NA"],
        ],
        "80062": [["Meta", "NA"]],
        "80063": [["Piano Di Sorrento", "NA"]],
        "80065": [["Sant'Agnello", "NA"], ["Colli Di Fontanelle", "NA"]],
        "80066": [["Seiano", "NA"], ["Fornacelle", "NA"], ["Montechiaro", "NA"], ["Fornacella", "NA"]],
        "80067": [["Priora", "NA"], ["Capo Di Sorrento", "NA"], ["Sorrento", "NA"]],
        "80069": [["Moiano", "NA"], ["Vico Equense", "NA"], ["Villaggio Monte Faito", "NA"]],
        "80070": [
            ["Buonopane", "NA"],
            ["Succhivo", "NA"],
            ["Fontana", "NA"],
            ["Miliscola", "NA"],
            ["Testaccio D'Ischia", "NA"],
            ["Barano D'Ischia", "NA"],
            ["Serrara", "NA"],
            ["Fusaro", "NA"],
            ["Torregaveta", "NA"],
            ["Bacoli", "NA"],
            ["Capo Miseno", "NA"],
            ["Miseno", "NA"],
            ["Sant'Angelo", "NA"],
            ["Serrara Fontana", "NA"],
            ["Monte Di Procida", "NA"],
            ["Cappella", "NA"],
            ["Cuma", "NA"],
            ["Baia", "NA"],
        ],
        "80071": [["Anacapri", "NA"]],
        "80073": [["Marina Grande Di Capri", "NA"], ["Capri", "NA"]],
        "80074": [["Casamicciola Terme", "NA"]],
        "80075": [["Forio", "NA"], ["Panza", "NA"], ["Monterone", "NA"]],
        "80076": [["Lacco Ameno", "NA"]],
        "80077": [
            ["Ischia San Michele", "NA"],
            ["Piedimonte D'Ischia", "NA"],
            ["Sant'Antuono D'Ischia", "NA"],
            ["Ischia", "NA"],
            ["Ischia Ponte", "NA"],
            ["Ischia Porto", "NA"],
        ],
        "80078": [
            ["Pozzuoli", "NA"],
            ["Lucrino", "NA"],
            ["Lago Averno", "NA"],
            ["Monterusciello", "NA"],
            ["Arco Felice", "NA"],
            ["Cappuccini", "NA"],
            ["Lido Di Licola", "NA"],
            ["Licola", "NA"],
        ],
        "80079": [["Procida", "NA"]],
        "80100": [["Napoli", "NA"]],
        "80121": [["Napoli", "NA"]],
        "80122": [["Napoli", "NA"], ["Chiaia", "NA"]],
        "80123": [["Napoli", "NA"]],
        "80124": [["Napoli", "NA"], ["Bagnoli", "NA"]],
        "80125": [["Napoli", "NA"], ["Agnano", "NA"]],
        "80126": [["Pianura", "NA"], ["Napoli", "NA"], ["Soccavo", "NA"]],
        "80127": [["Vomero", "NA"], ["Napoli", "NA"]],
        "80128": [["Napoli", "NA"]],
        "80129": [["Napoli", "NA"]],
        "80131": [["Napoli", "NA"], ["Miano", "NA"], ["Arenella", "NA"], ["Cappella Cangiani", "NA"]],
        "80132": [["Napoli", "NA"]],
        "80133": [["Napoli", "NA"]],
        "80134": [["Napoli", "NA"]],
        "80135": [["Napoli", "NA"]],
        "80136": [["Napoli", "NA"]],
        "80137": [["Napoli", "NA"]],
        "80138": [["Napoli", "NA"]],
        "80139": [["Napoli", "NA"]],
        "80141": [["Napoli", "NA"]],
        "80142": [["Napoli", "NA"]],
        "80143": [["Napoli", "NA"]],
        "80144": [["Napoli", "NA"], ["San Pietro A Patierno", "NA"], ["Secondigliano", "NA"]],
        "80145": [
            ["Marianella", "NA"],
            ["Chiaiano Ed Uniti", "NA"],
            ["Scampia", "NA"],
            ["Miano", "NA"],
            ["Piscinola", "NA"],
            ["Napoli", "NA"],
        ],
        "80146": [["Napoli", "NA"], ["San Giovanni A Teduccio", "NA"]],
        "80147": [["Barra", "NA"], ["Ponticelli", "NA"], ["Napoli", "NA"]],
        "84010": [
            ["Atrani", "SA"],
            ["Ravello", "SA"],
            ["Cetara", "SA"],
            ["San Lorenzo Di Sant'Egidio", "SA"],
            ["Minori", "SA"],
            ["Corbara", "SA"],
            ["Tramonti", "SA"],
            ["San Valentino Torio", "SA"],
            ["Praiano", "SA"],
            ["Furore", "SA"],
            ["Campinola", "SA"],
            ["Conca Dei Marini", "SA"],
            ["San Marzano Sul Sarno", "SA"],
            ["Pontone", "SA"],
            ["San Michele", "SA"],
            ["Scala", "SA"],
            ["Erchie", "SA"],
            ["Maiori", "SA"],
            ["Sant'Egidio Del Monte Albino", "SA"],
        ],
        "84011": [
            ["Pastena", "SA"],
            ["Vettica Pastena", "SA"],
            ["Pogerola", "SA"],
            ["Pogerola Di Amalfi", "SA"],
            ["Lone", "SA"],
            ["Amalfi", "SA"],
        ],
        "84012": [["Angri", "SA"]],
        "84013": [
            ["Corpo Di Cava", "SA"],
            ["Passiano", "SA"],
            ["San Pietro Di Cava", "SA"],
            ["Cava De' Tirreni", "SA"],
            ["Badia Di Cava De' Tirreni", "SA"],
            ["Pregiato", "SA"],
            ["Arcara", "SA"],
            ["Santa Lucia Di Cava", "SA"],
            ["Dupino", "SA"],
            ["Alessia", "SA"],
            ["Marini", "SA"],
        ],
        "84014": [["Nocera Inferiore", "SA"]],
        "84015": [["Nocera Superiore", "SA"], ["Materdomini Di Nocera", "SA"]],
        "84016": [["Pagani", "SA"]],
        "84017": [["Positano", "SA"], ["Montepertuso", "SA"]],
        "84018": [["San Pietro Di Scafati", "SA"], ["Scafati", "SA"]],
        "84019": [
            ["Benincasa", "SA"],
            ["Raito", "SA"],
            ["Vietri Sul Mare", "SA"],
            ["Dragonea", "SA"],
            ["Marina Di Vietri", "SA"],
            ["Molina Di Vietri Sul Mare", "SA"],
            ["Molina", "SA"],
        ],
        "84020": [
            ["Romagnano Al Monte", "SA"],
            ["Controne", "SA"],
            ["Santomenna", "SA"],
            ["Ottati", "SA"],
            ["Valva", "SA"],
            ["Colliano", "SA"],
            ["Bivio Palomonte", "SA"],
            ["Aquara", "SA"],
            ["Perrazze", "SA"],
            ["Bellosguardo", "SA"],
            ["Ricigliano", "SA"],
            ["Quadrivio Di Campagna", "SA"],
            ["Palomonte", "SA"],
            ["Serra Di Castelcivita", "SA"],
            ["Salvitelle", "SA"],
            ["San Gregorio Magno", "SA"],
            ["Laviano", "SA"],
            ["Roscigno", "SA"],
            ["Castelcivita", "SA"],
            ["Corleto Monforte", "SA"],
            ["Oliveto Citra", "SA"],
            ["Castelnuovo Di Conza", "SA"],
            ["Petina", "SA"],
            ["Centro Urbano", "SA"],
        ],
        "84021": [["Tufariello", "SA"], ["Buccino", "SA"], ["Buccino Stazione", "SA"]],
        "84022": [["Serradarce", "SA"], ["Puglietta", "SA"], ["Quadrivio", "SA"], ["Campagna", "SA"]],
        "84023": [["Persano", "SA"]],
        "84024": [["Bagni Di Contursi", "SA"], ["Contursi Terme", "SA"]],
        "84025": [
            ["Bivio Santa Cecilia", "SA"],
            ["Santa Cecilia Di Eboli", "SA"],
            ["Corno D'Oro", "SA"],
            ["Eboli", "SA"],
        ],
        "84026": [["Postiglione", "SA"]],
        "84027": [["Sant'Angelo A Fasanella", "SA"]],
        "84028": [["Borgo San Lazzaro", "SA"], ["Serre", "SA"]],
        "84029": [
            ["Sicignano Degli Alburni", "SA"],
            ["Galdo Degli Alburni", "SA"],
            ["Sicignano Degli Alburni Stazione", "SA"],
            ["Castelluccio Cosentino", "SA"],
            ["Zuppino", "SA"],
            ["Scorzo", "SA"],
        ],
        "84030": [
            ["Torraca", "SA"],
            ["Sanza", "SA"],
            ["Casaletto Spartano", "SA"],
            ["Atena Lucana", "SA"],
            ["Caselle In Pittari", "SA"],
            ["Monte San Giacomo", "SA"],
            ["Sicili'", "SA"],
            ["Pertosa", "SA"],
            ["Caggiano", "SA"],
            ["Taverne", "SA"],
            ["Tortorella", "SA"],
            ["Morigerati", "SA"],
            ["San Rufo", "SA"],
            ["San Pietro Al Tanagro", "SA"],
            ["Battaglia", "SA"],
            ["Casalbuono", "SA"],
            ["Atena Lucana Scalo", "SA"],
        ],
        "84031": [["Auletta", "SA"]],
        "84032": [["Buonabitacolo", "SA"]],
        "84033": [
            ["Prato Comune", "SA"],
            ["Montesano Sulla Marcellana", "SA"],
            ["Tardiano", "SA"],
            ["Montesano Scalo", "SA"],
            ["Arenabianca", "SA"],
        ],
        "84034": [["Padula Scalo", "SA"], ["Padula", "SA"]],
        "84035": [["Polla", "SA"]],
        "84036": [["Sala Consilina", "SA"], ["Trinita'", "SA"]],
        "84037": [["Sant'Arsenio", "SA"]],
        "84038": [["Sassano", "SA"], ["Caiazzano", "SA"], ["Silla", "SA"]],
        "84039": [
            ["Pantano Di Teggiano", "SA"],
            ["Prato Perillo", "SA"],
            ["Teggiano", "SA"],
            ["San Marco Di Teggiano", "SA"],
        ],
        "84040": [
            ["Poderia", "SA"],
            ["Velina", "SA"],
            ["Cannalonga", "SA"],
            ["Castelnuovo Vallo Stazione", "SA"],
            ["Celle Di Bulgheria", "SA"],
            ["Casal Velino", "SA"],
            ["Castelnuovo Cilento", "SA"],
            ["Marina Di Casal Velino", "SA"],
            ["Alfano", "SA"],
            ["Ponte", "SA"],
            ["Campora", "SA"],
            ["Acquavella", "SA"],
            ["Casal Velino Marina", "SA"],
        ],
        "84042": [["Acerno", "SA"]],
        "84043": [["Agropoli Stazione", "SA"], ["Agropoli", "SA"]],
        "84044": [["Matinella", "SA"], ["Albanella", "SA"]],
        "84045": [["Borgo Carillia", "SA"], ["Carillia", "SA"], ["Altavilla Silentina", "SA"], ["Cerrelli", "SA"]],
        "84046": [
            ["Marina Di Ascea", "SA"],
            ["Terradura Di Ascea", "SA"],
            ["Terradura", "SA"],
            ["Catona", "SA"],
            ["Catona Di Ascea", "SA"],
            ["Ascea", "SA"],
            ["Mandia Di Ascea", "SA"],
            ["Mandia", "SA"],
        ],
        "84047": [
            ["Paestum", "SA"],
            ["Capaccio Scalo", "SA"],
            ["Vuccolo Di Maiorano", "SA"],
            ["Ponte Barizzo", "SA"],
            ["Capaccio", "SA"],
            ["Gromola", "SA"],
            ["Laura", "SA"],
            ["Cafasso", "SA"],
            ["Vannullo", "SA"],
            ["Borgo Nuovo", "SA"],
            ["Torre Di Paestum", "SA"],
            ["Licinella", "SA"],
            ["Santa Venere", "SA"],
            ["Rettifilo", "SA"],
        ],
        "84048": [
            ["San Marco", "SA"],
            ["Castellabate", "SA"],
            ["Santa Maria", "SA"],
            ["Santa Maria Di Castellabate", "SA"],
            ["Ogliastro Marina", "SA"],
        ],
        "84049": [["Castel San Lorenzo", "SA"]],
        "84050": [
            ["Laurito", "SA"],
            ["Capitello", "SA"],
            ["Magliano Vetere", "SA"],
            ["Giungano", "SA"],
            ["Laureana Cilento", "SA"],
            ["Lustra", "SA"],
            ["Matonti", "SA"],
            ["Ispani", "SA"],
            ["Cuccaro Vetere", "SA"],
            ["Capizzo", "SA"],
            ["Magliano Nuovo", "SA"],
            ["Futani", "SA"],
            ["Sorvaro", "SA"],
        ],
        "84051": [
            ["San Severino", "SA"],
            ["San Severino Di Centola", "SA"],
            ["Foria", "SA"],
            ["Centola", "SA"],
            ["San Nicola", "SA"],
            ["San Nicola Di Centola", "SA"],
            ["Palinuro", "SA"],
        ],
        "84052": [
            ["San Biase", "SA"],
            ["Ceraso", "SA"],
            ["Santa Barbara", "SA"],
            ["San Sumino", "SA"],
            ["Massascusa", "SA"],
        ],
        "84053": [["Monte Cicerale", "SA"], ["Cicerale", "SA"]],
        "84055": [["Felitto", "SA"]],
        "84056": [["Cardile", "SA"], ["Gioi", "SA"]],
        "84057": [["Villa Littorio", "SA"], ["Laurino", "SA"]],
        "84059": [["Lentiscosa", "SA"], ["Camerota", "SA"], ["Licusati", "SA"], ["Marina Di Camerota", "SA"]],
        "84060": [
            ["Vatolla", "SA"],
            ["Montecorice", "SA"],
            ["Prignano Cilento", "SA"],
            ["Abatemarco", "SA"],
            ["Massicelle", "SA"],
            ["Omignano Scalo", "SA"],
            ["Mercato Cilento", "SA"],
            ["Novi Velia", "SA"],
            ["Omignano", "SA"],
            ["Acquavena", "SA"],
            ["Montano Antilia", "SA"],
            ["Orria", "SA"],
            ["Ostigliano", "SA"],
            ["Piano Vetrale", "SA"],
            ["Agnone Cilento", "SA"],
            ["Pellare", "SA"],
            ["Case Del Conte", "SA"],
            ["Omignano Stazione", "SA"],
            ["Perdifumo", "SA"],
            ["Roccagloriosa", "SA"],
            ["Ortodonico", "SA"],
            ["Fornelli", "SA"],
            ["Moio Della Civitella", "SA"],
            ["Perito", "SA"],
            ["Monteforte Cilento", "SA"],
        ],
        "84061": [["Eredita", "SA"], ["Ogliastro Cilento", "SA"], ["Finocchito", "SA"]],
        "84062": [
            ["Olevano Sul Tusciano", "SA"],
            ["Salitto", "SA"],
            ["Monticelli", "SA"],
            ["Ariano", "SA"],
            ["Valle", "SA"],
        ],
        "84065": [["Piaggine", "SA"]],
        "84066": [["Pisciotta", "SA"], ["Marina Di Pisciotta", "SA"], ["Rodio", "SA"], ["Caprioli", "SA"]],
        "84067": [["Santa Marina", "SA"], ["Policastro Bussentino", "SA"]],
        "84068": [
            ["Galdo Cilento", "SA"],
            ["Celso", "SA"],
            ["Pollica", "SA"],
            ["Pioppi", "SA"],
            ["Acciaroli", "SA"],
            ["Galdo", "SA"],
            ["Cannicchio", "SA"],
        ],
        "84069": [["Acquaviva", "SA"], ["Carratiello", "SA"], ["Fonte", "SA"], ["Roccadaspide", "SA"], ["Serra", "SA"]],
        "84070": [
            ["San Mauro La Bruca", "SA"],
            ["Scario", "SA"],
            ["Rofrano", "SA"],
            ["Bosco", "SA"],
            ["Stella Cilento", "SA"],
            ["San Mauro Cilento", "SA"],
            ["Trentinara", "SA"],
            ["Salento", "SA"],
            ["Rutino", "SA"],
            ["Valle Dell'Angelo", "SA"],
            ["Sacco", "SA"],
            ["San Giovanni A Piro", "SA"],
            ["Casalsottano", "SA"],
            ["Serramezzana", "SA"],
        ],
        "84073": [["Sapri", "SA"]],
        "84074": [
            ["San Mango Cilento", "SA"],
            ["San Mango", "SA"],
            ["Santa Lucia Cilento", "SA"],
            ["Sessa Cilento", "SA"],
        ],
        "84075": [["Gorga", "SA"], ["Stio", "SA"]],
        "84076": [["Copersito", "SA"], ["Copersito Cilento", "SA"], ["Torchiara", "SA"]],
        "84077": [["Torre Orsaia", "SA"], ["Castel Ruggero", "SA"]],
        "84078": [["Pattano", "SA"], ["Angellara", "SA"], ["Massa Della Lucania", "SA"], ["Vallo Della Lucania", "SA"]],
        "84079": [["Vibonati", "SA"], ["Villammare", "SA"]],
        "84080": [
            ["Capezzano Inferiore", "SA"],
            ["Capezzano", "SA"],
            ["Capezzano Superiore", "SA"],
            ["Calvanico", "SA"],
            ["Capriglia", "SA"],
            ["Pellezzano", "SA"],
            ["Cologna", "SA"],
            ["Coperchia", "SA"],
        ],
        "84081": [
            ["Baronissi", "SA"],
            ["Antessano", "SA"],
            ["Fusara", "SA"],
            ["Acquamela", "SA"],
            ["Saragnano", "SA"],
            ["Caprecano", "SA"],
            ["Sava", "SA"],
        ],
        "84082": [["Manzi", "SA"], ["Bracigliano", "SA"], ["San Nazario", "SA"]],
        "84083": [["Castelluccio", "SA"], ["Fimiani", "SA"], ["Castel San Giorgio", "SA"], ["Lanzara", "SA"]],
        "84084": [
            ["Villa", "SA"],
            ["Pizzolano", "SA"],
            ["Fisciano", "SA"],
            ["Settefichi", "SA"],
            ["Lancusi", "SA"],
            ["Bolano", "SA"],
            ["Penta", "SA"],
            ["Gaiano", "SA"],
        ],
        "84085": [
            ["Spiano", "SA"],
            ["Carifi", "SA"],
            ["Curteri", "SA"],
            ["Sant'Angelo", "SA"],
            ["Pandola", "SA"],
            ["Ciorani", "SA"],
            ["Torello", "SA"],
            ["Piazza Del Galdo", "SA"],
            ["Sant'Angelo Di Mercato San Severino", "SA"],
            ["Sant'Eustachio", "SA"],
            ["Monticelli", "SA"],
            ["Acquarola", "SA"],
            ["Mercato San Severino", "SA"],
        ],
        "84086": [["Casali Di Roccapiemonte", "SA"], ["Casali San Potito", "SA"], ["Roccapiemonte", "SA"]],
        "84087": [["Lavorate", "SA"], ["Episcopio", "SA"], ["Sarno", "SA"]],
        "84088": [["Siano", "SA"]],
        "84090": [
            ["Capitignano", "SA"],
            ["Prepezzano", "SA"],
            ["San Mango Piemonte", "SA"],
            ["Montecorvino Pugliano", "SA"],
            ["Sieti", "SA"],
            ["Castelpagano", "SA"],
            ["Pugliano", "SA"],
            ["Castiglione Del Genovesi", "SA"],
            ["Giffoni Sei Casali", "SA"],
            ["Santa Tecla", "SA"],
        ],
        "84091": [
            ["Battipaglia", "SA"],
            ["Santa Lucia Di Battipaglia", "SA"],
            ["Sant'Anna", "SA"],
            ["Belvedere Di Battipaglia", "SA"],
        ],
        "84092": [["Bivio", "SA"], ["Bellizzi", "SA"]],
        "84095": [
            ["Giffoni Valle Piana", "SA"],
            ["Mercato", "SA"],
            ["Curti", "SA"],
            ["Santa Caterina", "SA"],
            ["Ornito", "SA"],
            ["San Giovanni", "SA"],
        ],
        "84096": [
            ["Montecorvino Rovella", "SA"],
            ["Gauro", "SA"],
            ["Macchia", "SA"],
            ["San Martino Montecorvino Rovella", "SA"],
            ["Lenzi", "SA"],
        ],
        "84098": [
            ["Pontecagnano Faiano", "SA"],
            ["Pontecagnano", "SA"],
            ["Magazzeno", "SA"],
            ["Sant'Antonio", "SA"],
            ["Corvinia", "SA"],
            ["Sant'Antonio Di Pontecagnano", "SA"],
            ["Faiano", "SA"],
        ],
        "84099": [
            ["San Cipriano Picentino", "SA"],
            ["Pezzano", "SA"],
            ["Campigliano", "SA"],
            ["Vignale", "SA"],
            ["Filetta", "SA"],
        ],
        "84100": [["Salerno", "SA"]],
        "84121": [["Salerno", "SA"]],
        "84122": [["Salerno", "SA"]],
        "84123": [["Salerno", "SA"]],
        "84124": [["Salerno", "SA"]],
        "84125": [["Salerno", "SA"]],
        "84126": [["Salerno", "SA"]],
        "84127": [["Salerno", "SA"], ["Torrione Di Salerno", "SA"]],
        "84128": [["Pastena Di Salerno", "SA"], ["Salerno", "SA"]],
        "84129": [["Salerno", "SA"]],
        "84131": [["Salerno", "SA"], ["San Leonardo", "SA"], ["Fuorni", "SA"], ["Mercatello Di Salerno", "SA"]],
        "84132": [["Salerno", "SA"]],
        "84133": [["Salerno", "SA"]],
        "84134": [["Giovi", "SA"], ["Salerno", "SA"]],
        "84135": [["Fratte", "SA"], ["Salerno", "SA"], ["Ogliara", "SA"], ["Matierno", "SA"]],
        "40010": [
            ["Bentivoglio", "BO"],
            ["Osteria Nuova", "BO"],
            ["San Marino", "BO"],
            ["Padulle", "BO"],
            ["Interporto Bentivoglio", "BO"],
            ["Santa Maria In Duno", "BO"],
            ["Sala Bolognese", "BO"],
        ],
        "40011": [
            ["San Giacomo Del Martignone", "BO"],
            ["Lavino Di Mezzo", "BO"],
            ["Anzola Dell'Emilia", "BO"],
            ["Santa Maria In Strada", "BO"],
        ],
        "40012": [
            ["Bargellino", "BO"],
            ["Tavernelle D'Emilia", "BO"],
            ["Tavernelle Emilia", "BO"],
            ["Longara", "BO"],
            ["Lippo", "BO"],
            ["Calderara Di Reno", "BO"],
        ],
        "40013": [
            ["Trebbo Di Reno", "BO"],
            ["Castel Maggiore", "BO"],
            ["Progresso", "BO"],
            ["Trebbo", "BO"],
            ["Villa Salina", "BO"],
        ],
        "40014": [["Caselle", "BO"], ["Palata Pepoli", "BO"], ["Crevalcore", "BO"]],
        "40015": [
            ["Bosco Di Galliera", "BO"],
            ["Bosco", "BO"],
            ["Galliera Frazione", "BO"],
            ["Galliera", "BO"],
            ["San Vincenzo", "BO"],
            ["San Venanzio", "BO"],
        ],
        "40016": [["San Giorgio Di Piano", "BO"]],
        "40017": [
            ["Decima", "BO"],
            ["San Giovanni In Persiceto", "BO"],
            ["San Matteo Della Decima", "BO"],
            ["Amola Di Piano", "BO"],
            ["Budrie", "BO"],
        ],
        "40018": [["Maccaretolo", "BO"], ["San Pietro In Casale", "BO"]],
        "40019": [["Sant'Agata Bolognese", "BO"]],
        "40020": [["Casalfiumanese", "BO"]],
        "40021": [["Tossignano", "BO"], ["Borgo Tossignano", "BO"]],
        "40022": [
            ["Castel Del Rio", "BO"],
            ["Moraduccio", "BO"],
            ["Sassoleone", "BO"],
            ["Moraduccio Di Valsalva", "BO"],
            ["Giugnola", "BO"],
        ],
        "40023": [["Castel Guelfo Di Bologna", "BO"]],
        "40024": [
            ["Castel San Pietro Terme", "BO"],
            ["Osteria Grande", "BO"],
            ["San Martino In Pedriolo", "BO"],
            ["Gallo", "BO"],
            ["Gaiana", "BO"],
        ],
        "40025": [["Fontanelice", "BO"], ["Carseggio", "BO"]],
        "40026": [
            ["Sesto Imolese", "BO"],
            ["Spazzate Sassatelli", "BO"],
            ["Imola", "BO"],
            ["Ponticelli", "BO"],
            ["Piratello", "BO"],
            ["San Prospero", "BO"],
            ["Sasso Morelli", "BO"],
        ],
        "40027": [["Bubano", "BO"], ["Mordano", "BO"]],
        "40030": [
            ["Grizzana Morandi", "BO"],
            ["Berzantina", "BO"],
            ["Badi", "BO"],
            ["Piano Di Setta", "BO"],
            ["Pioppe Di Salvaro", "BO"],
            ["Piandisetta", "BO"],
            ["Castel Di Casio", "BO"],
            ["Pian Di Casale", "BO"],
            ["Suviana", "BO"],
        ],
        "40032": [["Ponte Di Verzuno", "BO"], ["Bargi", "BO"], ["Camugnano", "BO"]],
        "40033": [["Casalecchio Di Reno", "BO"], ["Ceretolo", "BO"], ["Cantagallo", "BO"]],
        "40034": [
            ["Santa Maria Di Labante", "BO"],
            ["Castel D'Aiano", "BO"],
            ["Villa D'Aiano", "BO"],
            ["Rocca Di Roffeno", "BO"],
        ],
        "40035": [["Castiglione Dei Pepoli", "BO"], ["Baragazza", "BO"], ["Lagaro", "BO"], ["Creda", "BO"]],
        "40036": [["Rioveggio", "BO"], ["Monzuno", "BO"], ["Vado", "BO"]],
        "40037": [["Sasso Marconi", "BO"], ["Pontecchio Marconi", "BO"], ["Fontana", "BO"], ["Borgonuovo", "BO"]],
        "40038": [["Susano", "BO"], ["Tole'", "BO"], ["Vergato", "BO"], ["Cereglio", "BO"], ["Riola", "BO"]],
        "40041": [
            ["Marano", "BO"],
            ["Santa Maria Villiana", "BO"],
            ["Silla", "BO"],
            ["Bombiana", "BO"],
            ["Gaggio Montano", "BO"],
        ],
        "40042": [
            ["Querciola", "BO"],
            ["Vidiciatico", "BO"],
            ["Farneto Di Lizzano", "BO"],
            ["Monteacuto Delle Alpi", "BO"],
            ["Pianaccio", "BO"],
            ["Rocca Corneta", "BO"],
            ["Lizzano In Belvedere", "BO"],
        ],
        "40043": [["Lama Di Reno", "BO"], ["Lama Di Setta", "BO"], ["Marzabotto", "BO"], ["Pian Di Venola", "BO"]],
        "40046": [
            ["Capugnano", "BO"],
            ["Porretta Terme", "BO"],
            ["Molino Del Pallone", "BO"],
            ["Casa Calistri", "BO"],
            ["Casa Forlai", "BO"],
            ["Castelluccio", "BO"],
            ["Granaglione", "BO"],
            ["Vizzero", "BO"],
            ["Ponte Della Venturina", "BO"],
            ["Borgo Capanne", "BO"],
        ],
        "40048": [
            ["Madonna Dei Fornelli", "BO"],
            ["San Benedetto Val Di Sambro", "BO"],
            ["Castel Dell'Alpi", "BO"],
            ["Piano Del Voglio", "BO"],
        ],
        "40050": [
            ["Monte San Giovanni", "BO"],
            ["Castelletto", "BO"],
            ["Funo", "BO"],
            ["San Martino", "BO"],
            ["Castello Di Serravalle", "BO"],
            ["Rignano Bolognese", "BO"],
            ["San Benedetto Del Querceto", "BO"],
            ["Centergross", "BO"],
            ["Monteveglio", "BO"],
            ["Castello D'Argile", "BO"],
            ["Loiano", "BO"],
            ["Gavignano", "BO"],
            ["Bisano", "BO"],
            ["Monterenzio", "BO"],
            ["Argelato", "BO"],
            ["Monte San Pietro", "BO"],
            ["Pizzano", "BO"],
            ["Calderino", "BO"],
            ["Casadio", "BO"],
            ["Savazza", "BO"],
            ["Venezzano", "BO"],
        ],
        "40051": [["Altedo", "BO"], ["Casoni", "BO"], ["Malalbergo", "BO"], ["Pegola", "BO"]],
        "40052": [["Boschi", "BO"], ["Baricella", "BO"], ["Mondonuovo", "BO"], ["San Gabriele", "BO"]],
        "40053": [["Valsamoggia", "BO"], ["Bazzano", "BO"]],
        "40054": [["Vedrana", "BO"], ["Bagnarola", "BO"], ["Riccardina", "BO"], ["Budrio", "BO"], ["Mezzolara", "BO"]],
        "40055": [["Fiesso", "BO"], ["Villanova", "BO"], ["Castenaso", "BO"]],
        "40056": [["Muffa", "BO"], ["Pragatto", "BO"], ["Crespellano", "BO"], ["Calcara", "BO"]],
        "40057": [
            ["Granarolo Dell'Emilia", "BO"],
            ["Fabbreria Di Cadriana", "BO"],
            ["Lovoleto", "BO"],
            ["Quarto Inferiore", "BO"],
        ],
        "40059": [
            ["Portonovo", "BO"],
            ["Buda", "BO"],
            ["Medicina", "BO"],
            ["Ganzanigo", "BO"],
            ["Sant'Antonio", "BO"],
            ["Villa Fontana", "BO"],
        ],
        "40060": [
            ["Gallo Bolognese", "BO"],
            ["Dozza", "BO"],
            ["Savigno", "BO"],
            ["Toscanella", "BO"],
            ["Vedegheto", "BO"],
        ],
        "40061": [["Minerbio", "BO"], ["Ca' De' Fabbri", "BO"]],
        "40062": [
            ["Marmorta", "BO"],
            ["Selva Malvezzi", "BO"],
            ["Molinella", "BO"],
            ["Selva", "BO"],
            ["San Pietro Capofiume", "BO"],
            ["San Martino In Argine", "BO"],
        ],
        "40063": [["Monghidoro", "BO"]],
        "40064": [["Mercatale", "BO"], ["Ozzano Dell'Emilia", "BO"]],
        "40065": [["Pianoro", "BO"], ["Livergnano", "BO"], ["Pianoro Vecchio", "BO"]],
        "40066": [["Pieve Di Cento", "BO"]],
        "40067": [["Rastignano", "BO"]],
        "40068": [
            ["San Lazzaro Di Savena", "BO"],
            ["Ponticella", "BO"],
            ["San Lazzaro", "BO"],
            ["Castel Dei Britti", "BO"],
            ["Farneto", "BO"],
            ["Martiri Di Pizzocalvo", "BO"],
            ["Pulce", "BO"],
        ],
        "40069": [["Ponte Ronca", "BO"], ["Riale", "BO"], ["Zola Predosa", "BO"], ["Zola", "BO"]],
        "40100": [["Bologna", "BO"]],
        "40121": [["Bologna", "BO"]],
        "40122": [["Bologna", "BO"]],
        "40123": [["Bologna", "BO"]],
        "40124": [["Bologna", "BO"]],
        "40125": [["Bologna", "BO"]],
        "40126": [["Bologna", "BO"]],
        "40127": [["Bologna", "BO"], ["San Donnino", "BO"]],
        "40128": [["Bologna", "BO"], ["Corticella", "BO"]],
        "40129": [["Bologna", "BO"]],
        "40131": [["Bologna", "BO"], ["Bertalia", "BO"]],
        "40132": [["Borgo Panigale", "BO"], ["Bologna", "BO"]],
        "40133": [["Bologna", "BO"]],
        "40134": [["Bologna", "BO"]],
        "40135": [["Bologna", "BO"], ["Casaglia", "BO"]],
        "40136": [["Roncrio", "BO"], ["Gaibola", "BO"], ["Bologna", "BO"], ["Paderno", "BO"]],
        "40137": [["Bologna", "BO"]],
        "40138": [["Bologna", "BO"], ["Roveri", "BO"]],
        "40139": [["Bologna", "BO"]],
        "40141": [["Bologna", "BO"], ["San Ruffillo", "BO"], ["Monte Donato", "BO"]],
        "47010": [
            ["Portico Di Romagna", "FC"],
            ["Bocconi", "FC"],
            ["Strada San Zeno", "FC"],
            ["Portico E San Benedetto", "FC"],
            ["San Benedetto In Alpe", "FC"],
            ["Galeata", "FC"],
            ["Premilcuore", "FC"],
        ],
        "47011": [["Terra Del Sole", "FC"], ["Castrocaro Terme E Terra Del Sole", "FC"], ["Pieve Salutare", "FC"]],
        "47012": [["Cusercoli", "FC"], ["Voltre", "FC"], ["Nespoli", "FC"], ["Civitella Di Romagna", "FC"]],
        "47013": [["San Ruffillo", "FC"], ["Dovadola", "FC"]],
        "47014": [
            ["Teodorano", "FC"],
            ["Rico'", "FC"],
            ["San Colombano", "FC"],
            ["Meldola", "FC"],
            ["San Colombano Di Meldola", "FC"],
            ["Vitignano", "FC"],
            ["Para", "FC"],
        ],
        "47015": [["Santa Reparata", "FC"], ["Modigliana", "FC"]],
        "47016": [
            ["Tontola", "FC"],
            ["Rocca Delle Caminate", "FC"],
            ["Predappio", "FC"],
            ["Predappio Alta", "FC"],
            ["Fiumana", "FC"],
        ],
        "47017": [["Rocca San Casciano", "FC"], ["Calbola", "FC"]],
        "47018": [["Biserno", "FC"], ["Corniolo", "FC"], ["Santa Sofia", "FC"]],
        "47019": [["Tredozio", "FC"]],
        "47020": [["Budrio", "FC"], ["Longiano", "FC"], ["Roncofreddo", "FC"], ["Montiano", "FC"], ["Oriola", "FC"]],
        "47021": [
            ["Monte Guidi", "FC"],
            ["Vessa", "FC"],
            ["Selvapiana", "FC"],
            ["San Piero In Bagno", "FC"],
            ["Bagno Di Romagna", "FC"],
        ],
        "47023": [
            ["Bulgaria", "FC"],
            ["Cesuola", "FC"],
            ["Diegaro", "FC"],
            ["Saiano", "FC"],
            ["San Vittore", "FC"],
            ["Sant'Egidio", "FC"],
            ["San Giorgio Di Cesena", "FC"],
            ["Torre Del Moro", "FC"],
            ["Case Scuola Vecchia", "FC"],
            ["San Mauro In Valle", "FC"],
            ["Pievesestina", "FC"],
            ["Madonna Dell Ulivo", "FC"],
            ["Lizzano", "FC"],
            ["Macerone", "FC"],
            ["Celletta", "FC"],
            ["Gattolino", "FC"],
            ["San Carlo Di Cesena", "FC"],
            ["Roversano", "FC"],
            ["Aie", "FC"],
            ["Cesena", "FC"],
            ["Calisese", "FC"],
            ["Tessello", "FC"],
            ["Martorano", "FC"],
            ["Ronta", "FC"],
            ["Borello", "FC"],
            ["Settecrociari", "FC"],
            ["Rio Marano", "FC"],
        ],
        "47025": [
            ["Tornano", "FC"],
            ["Bacciolino", "FC"],
            ["Monte Castello", "FC"],
            ["Ciola", "FC"],
            ["Cella", "FC"],
            ["Mercato Saraceno", "FC"],
            ["Piavola", "FC"],
            ["Linaro", "FC"],
            ["Bora Bassa", "FC"],
        ],
        "47027": [
            ["Sorbano", "FC"],
            ["Quarto Di Sarsina", "FC"],
            ["Ranchio", "FC"],
            ["Pieve Di Rivoschio", "FC"],
            ["Sarsina", "FC"],
            ["Quarto", "FC"],
        ],
        "47028": [["Alfero", "FC"], ["Balze", "FC"], ["Verghereto", "FC"]],
        "47030": [
            ["San Mauro A Mare", "FC"],
            ["San Mauro Pascoli", "FC"],
            ["Borghi", "FC"],
            ["Sogliano Al Rubicone", "FC"],
            ["San Giovanni In Galilea", "FC"],
            ["Savignano Di Rigo", "FC"],
            ["San Martino In Converseto", "FC"],
            ["Montegelli", "FC"],
            ["Rontagnano", "FC"],
            ["Montepetra", "FC"],
            ["Lo Stradone", "FC"],
        ],
        "47032": [
            ["Collinello Polenta", "FC"],
            ["Polenta", "FC"],
            ["Capocolle", "FC"],
            ["Collinello", "FC"],
            ["Panighina", "FC"],
            ["Fratta Terme", "FC"],
            ["Bertinoro", "FC"],
            ["Santa Maria Nuova", "FC"],
        ],
        "47034": [["Forlimpopoli", "FC"], ["Selbagnone", "FC"]],
        "47035": [["Gambettola", "FC"]],
        "47039": [["Savignano Sul Rubicone", "FC"], ["Fiumicino Di Savignano", "FC"]],
        "47042": [["Bagnarola", "FC"], ["Cesenatico", "FC"], ["Villalta", "FC"], ["Sala", "FC"]],
        "47043": [["Gatteo", "FC"], ["Sant'Angelo In Salute", "FC"], ["Gatteo A Mare", "FC"]],
        "47100": [
            ["Villanova", "FC"],
            ["Pianta", "FC"],
            ["San Martino In Strada", "FC"],
            ["Rovere", "FC"],
            ["Barisano", "FC"],
            ["Ronco", "FC"],
            ["Villafranca", "FC"],
            ["Roncadello", "FC"],
            ["Carpinello", "FC"],
            ["San Lorenzo In Noceto", "FC"],
            ["San Varano", "FC"],
            ["Villa Rovere", "FC"],
            ["Carpena", "FC"],
            ["Cava", "FC"],
            ["Vecchiazzano", "FC"],
        ],
        "47121": [["Forlì", "FC"]],
        "47122": [["Forlì", "FC"]],
        "44011": [
            ["Argenta", "FE"],
            ["Ospital Monacale", "FE"],
            ["Anita", "FE"],
            ["Campotto", "FE"],
            ["Filo", "FE"],
            ["Traghetto", "FE"],
            ["La Fiorana", "FE"],
            ["San Nicolo'", "FE"],
            ["Boccaleone", "FE"],
            ["Longastrino", "FE"],
            ["Bando", "FE"],
            ["San Biagio", "FE"],
            ["Santa Maria Codifiume", "FE"],
            ["Consandolo", "FE"],
        ],
        "44012": [
            ["Ospitale", "FE"],
            ["Pilastri", "FE"],
            ["Stellata", "FE"],
            ["Scortichino", "FE"],
            ["Burana", "FE"],
            ["Gavello", "FE"],
            ["Bondeno", "FE"],
        ],
        "44014": [["Madonna Boschi", "FE"]],
        "44015": [
            ["Portomaggiore", "FE"],
            ["Maiero", "FE"],
            ["Gambulaga", "FE"],
            ["Ripapersico", "FE"],
            ["Portoverrara", "FE"],
            ["Runco", "FE"],
        ],
        "44019": [["Voghenza", "FE"], ["Montesanto", "FE"], ["Voghiera", "FE"]],
        "44020": [
            ["Gorino Di Goro", "FE"],
            ["Rovereto Ferrarese", "FE"],
            ["Masi San Giacomo", "FE"],
            ["Gorino", "FE"],
            ["Masi Torello", "FE"],
            ["Goro", "FE"],
            ["Medelana", "FE"],
            ["San Giuseppe Di Comacchio", "FE"],
            ["San Giovanni Di Ostellato", "FE"],
            ["San Giovanni", "FE"],
            ["Ostellato", "FE"],
            ["Dogato", "FE"],
        ],
        "44021": [
            ["Pomposa", "FE"],
            ["Codigoro", "FE"],
            ["Pontemaodino", "FE"],
            ["Mezzogoro", "FE"],
            ["Pontelangorino", "FE"],
        ],
        "44022": [["San Giuseppe", "FE"], ["Volania", "FE"], ["Comacchio", "FE"], ["Vaccolino", "FE"]],
        "44023": [["Marozzo", "FE"], ["Lagosanto", "FE"]],
        "44026": [
            ["Bosco", "FE"],
            ["Mesola", "FE"],
            ["Bosco Mesola", "FE"],
            ["Massenzatica", "FE"],
            ["Monticelli", "FE"],
            ["Ariano Ferrarese", "FE"],
            ["Ariano", "FE"],
        ],
        "44027": [["Migliaro", "FE"], ["Massa Fiscaglia", "FE"], ["Migliarino", "FE"], ["Fiscaglia", "FE"]],
        "44028": [["Poggio Renatico", "FE"], ["Coronella", "FE"], ["Gallo", "FE"], ["Chiesa Nuova", "FE"]],
        "44029": [["Lido Di Spina", "FE"], ["Lido Degli Estensi", "FE"], ["Porto Garibaldi", "FE"]],
        "44030": [
            ["Alberone Di Ro", "FE"],
            ["Guarda", "FE"],
            ["Ruina", "FE"],
            ["Guarda Ferrarese", "FE"],
            ["Alberone Di Guarda", "FE"],
        ],
        "44033": [["Ro", "FE"], ["Cologna", "FE"], ["Serravalle", "FE"], ["Berra", "FE"]],
        "44034": [
            ["Tamara", "FE"],
            ["Fossalta", "FE"],
            ["Copparo", "FE"],
            ["Ambrogio", "FE"],
            ["Cesta", "FE"],
            ["Sabbioncello San Vittore", "FE"],
            ["Saletta", "FE"],
            ["Zenzalino", "FE"],
            ["Coccanile", "FE"],
            ["Sabbioncello San Pietro", "FE"],
            ["Gradizza", "FE"],
        ],
        "44035": [["Brazzolo", "FE"]],
        "44037": [["Jolanda Di Savoia", "FE"]],
        "44039": [["Formignana", "FE"], ["Tresigallo", "FE"], ["Rero", "FE"], ["Final Di Rero", "FE"]],
        "44041": [["Casumaro", "FE"], ["Reno Centese", "FE"], ["Buonacompra", "FE"]],
        "44042": [
            ["Penzale", "FE"],
            ["Corpo Reno", "FE"],
            ["Alberone", "FE"],
            ["Cento", "FE"],
            ["Alberone Di Cento", "FE"],
            ["Corpo Di Reno", "FE"],
        ],
        "44043": [["Mirabello", "FE"]],
        "44045": [["Dodici Morelli", "FE"], ["Renazzo", "FE"]],
        "44047": [["Dosso", "FE"], ["San Carlo", "FE"], ["Sant'Agostino", "FE"]],
        "44049": [["Vigarano Mainarda", "FE"], ["Vigarano Pieve", "FE"]],
        "44121": [["Ferrara", "FE"]],
        "44122": [["Ferrara", "FE"]],
        "44123": [["Ferrara", "FE"]],
        "44124": [["Ferrara", "FE"]],
        "41011": [["Panzano", "MO"], ["Saliceto Buzzalino", "MO"], ["Campogalliano", "MO"]],
        "41012": [
            ["Gargallo", "MO"],
            ["Budrione", "MO"],
            ["Fossoli", "MO"],
            ["Cortile", "MO"],
            ["Carpi", "MO"],
            ["San Marino", "MO"],
            ["Migliarina", "MO"],
            ["San Martino Secchia", "MO"],
            ["Santa Croce", "MO"],
        ],
        "41013": [
            ["Gaggio Di Piano", "MO"],
            ["Castelfranco Emilia", "MO"],
            ["Riolo", "MO"],
            ["Cavazzona", "MO"],
            ["Rastellino", "MO"],
            ["Recovato", "MO"],
            ["Manzolino", "MO"],
            ["Piumazzo", "MO"],
        ],
        "41014": [
            ["Solignano Nuovo", "MO"],
            ["Levizzano Rangone", "MO"],
            ["Castelvetro Di Modena", "MO"],
            ["Ca' Di Sola", "MO"],
        ],
        "41015": [
            ["Bagazzano", "MO"],
            ["Nonantola", "MO"],
            ["Via Larga", "MO"],
            ["La Grande", "MO"],
            ["Campazzo", "MO"],
            ["Redu'", "MO"],
        ],
        "41016": [["Rovereto Sulla Secchia", "MO"], ["Sant'Antonio In Mercadello", "MO"], ["Novi Di Modena", "MO"]],
        "41017": [["Ravarino", "MO"], ["Stuffione", "MO"]],
        "41018": [["San Cesario Sul Panaro", "MO"]],
        "41019": [["Soliera", "MO"], ["Sozzigalli", "MO"], ["Appalto", "MO"], ["Limidi", "MO"]],
        "41020": [
            ["Castellino Brocco", "MO"],
            ["Serpiano", "MO"],
            ["Castello", "MO"],
            ["Groppo", "MO"],
            ["Riolunato", "MO"],
            ["Castellino", "MO"],
        ],
        "41021": [
            ["Canevare", "MO"],
            ["Trignano Nel Frignano", "MO"],
            ["Ospitale", "MO"],
            ["Fellicarolo", "MO"],
            ["Serrazzone", "MO"],
            ["Lotta", "MO"],
            ["Fanano", "MO"],
            ["Trignano", "MO"],
            ["Ospitale Nel Frignano", "MO"],
            ["Trentino Nel Frignano", "MO"],
        ],
        "41022": [["Fiumalbo", "MO"], ["Dogana Nuova", "MO"], ["Faidello", "MO"]],
        "41023": [
            ["Sassostorno", "MO"],
            ["Vaglio", "MO"],
            ["Montecenere", "MO"],
            ["La Santona", "MO"],
            ["Lama", "MO"],
            ["Barigazzo", "MO"],
            ["Mocogno", "MO"],
            ["Cadignano", "MO"],
            ["Lama Mocogno", "MO"],
            ["Pianorso", "MO"],
        ],
        "41025": [["Montecreto", "MO"], ["Acquaria", "MO"]],
        "41026": [
            ["Gaianello", "MO"],
            ["Castagneto", "MO"],
            ["Niviano", "MO"],
            ["Frassineti", "MO"],
            ["Monzone", "MO"],
            ["Sant'Antonio", "MO"],
            ["Pavullo Nel Frignano", "MO"],
            ["Gaiato", "MO"],
            ["Olina", "MO"],
            ["Montebonello", "MO"],
            ["Miceno", "MO"],
            ["Benedello", "MO"],
            ["Camatta", "MO"],
            ["Renno", "MO"],
            ["Iddiano", "MO"],
            ["Montorso", "MO"],
            ["Sasso Guidano", "MO"],
            ["Crocette", "MO"],
            ["Coscogno", "MO"],
            ["Verica", "MO"],
            ["Montecuccolo", "MO"],
        ],
        "41027": [
            ["Pievepelago", "MO"],
            ["Tagliole", "MO"],
            ["Sant'Anna Pelago", "MO"],
            ["Roccapelago", "MO"],
            ["Sant'Andrea Pelago", "MO"],
        ],
        "41028": [
            ["Faeto", "MO"],
            ["Ricco' Nel Frignano", "MO"],
            ["Rocca Santa Maria", "MO"],
            ["San Dalmazio Nel Frignano", "MO"],
            ["Varana", "MO"],
            ["Selva Nel Frignano", "MO"],
            ["Ligorzano", "MO"],
            ["Valle", "MO"],
            ["Pazzano", "MO"],
            ["Montagnana", "MO"],
            ["San Dalmazio", "MO"],
            ["Pompeano", "MO"],
            ["Ricco'", "MO"],
            ["Monfestino", "MO"],
            ["Serramazzoni", "MO"],
            ["Selva", "MO"],
        ],
        "41029": [
            ["Vesale", "MO"],
            ["Sestola", "MO"],
            ["Rocchetta Sandri", "MO"],
            ["Casine", "MO"],
            ["Castellaro", "MO"],
            ["Roncoscaglia", "MO"],
            ["Castellaro Nel Frignano", "MO"],
        ],
        "41030": [
            ["San Martino Di San Prospero", "MO"],
            ["San Pietro", "MO"],
            ["Sorbara", "MO"],
            ["San Pietro In Elda", "MO"],
            ["Staggia Modenese", "MO"],
            ["San Lorenzo Della Pioppa", "MO"],
            ["Solara", "MO"],
            ["Gorghetto", "MO"],
            ["San Martino", "MO"],
            ["San Lorenzo Pioppa", "MO"],
            ["Bomporto", "MO"],
            ["San Prospero", "MO"],
            ["Bastiglia", "MO"],
            ["Staggia", "MO"],
        ],
        "41031": [["Camposanto", "MO"]],
        "41032": [["Cavezzo", "MO"], ["Motta Sulla Secchia", "MO"], ["Motta", "MO"], ["Villa Motta", "MO"]],
        "41033": [
            ["Concordia Sulla Secchia", "MO"],
            ["Santa Caterina", "MO"],
            ["Fossa Di Concordia", "MO"],
            ["Vallalta", "MO"],
            ["San Giovanni", "MO"],
            ["Fossa", "MO"],
        ],
        "41034": [["Finale Emilia", "MO"], ["Reno Finalese", "MO"]],
        "41035": [["Massa Finalese", "MO"]],
        "41036": [["Villafranca", "MO"], ["Medolla", "MO"], ["Villafranca Di Medolla", "MO"], ["Camurana", "MO"]],
        "41037": [
            ["Gavello", "MO"],
            ["Cividale", "MO"],
            ["San Martino Carano", "MO"],
            ["Quarantoli", "MO"],
            ["Mortizzuolo", "MO"],
            ["San Martino Spino", "MO"],
            ["Tramuschio", "MO"],
            ["Ponte San Pellegrino", "MO"],
            ["Mirandola", "MO"],
            ["San Giacomo Roncole", "MO"],
        ],
        "41038": [
            ["Rivara", "MO"],
            ["San Felice Sul Panaro", "MO"],
            ["San Biagio In Padule", "MO"],
            ["San Biagio", "MO"],
            ["Dogaro", "MO"],
            ["Pavignane", "MO"],
            ["Confine", "MO"],
        ],
        "41039": [["San Possidonio", "MO"]],
        "41040": [
            ["Gombola", "MO"],
            ["San Martino Vallata", "MO"],
            ["Ponte Gombola", "MO"],
            ["Polinago", "MO"],
            ["Cassano", "MO"],
        ],
        "41042": [["Ubersetto", "MO"], ["Fiorano Modenese", "MO"], ["Spezzano", "MO"]],
        "41043": [
            ["Casinalbo", "MO"],
            ["Corlo Di Formigine", "MO"],
            ["Magreta", "MO"],
            ["Colombaro", "MO"],
            ["Colombaro Di Formigine", "MO"],
            ["Formigine", "MO"],
        ],
        "41044": [
            ["Madonna Di Pietravolta", "MO"],
            ["Romanoro", "MO"],
            ["Piandelagotti", "MO"],
            ["Riccovolto", "MO"],
            ["Rovolo", "MO"],
            ["Sassatella", "MO"],
            ["Frassinoro", "MO"],
            ["Fontanaluccia", "MO"],
            ["Cargedolo", "MO"],
        ],
        "41045": [
            ["Lago", "MO"],
            ["Montefiorino", "MO"],
            ["Vitriola", "MO"],
            ["Macognano", "MO"],
            ["Farneta", "MO"],
            ["Gusciola", "MO"],
            ["Casola", "MO"],
            ["Rubbiano", "MO"],
        ],
        "41046": [
            ["Monchio Nel Frignano", "MO"],
            ["Susano", "MO"],
            ["Savoniero", "MO"],
            ["Palagano", "MO"],
            ["Boccassuolo", "MO"],
            ["Monchio", "MO"],
            ["Costrignano", "MO"],
        ],
        "41048": [
            ["Morano", "MO"],
            ["Saltino Sulla Secchia", "MO"],
            ["Castelvecchio", "MO"],
            ["Castelvecchio Sulla Secchia", "MO"],
            ["Pigneto", "MO"],
            ["Sasso Morello", "MO"],
            ["Prignano Sulla Secchia", "MO"],
            ["Moncerrato", "MO"],
            ["Saltino", "MO"],
            ["Montebaranzone", "MO"],
        ],
        "41049": [["Sassuolo", "MO"], ["San Michele Dei Mucchietti", "MO"], ["Montegibbio", "MO"]],
        "41051": [["Montale", "MO"], ["Montale Rangone", "MO"], ["Castelnuovo Rangone", "MO"]],
        "41052": [
            ["Guiglia", "MO"],
            ["Samone", "MO"],
            ["Gainazzo", "MO"],
            ["Rocca Malatina", "MO"],
            ["Rocchetta", "MO"],
            ["Monteorsello", "MO"],
            ["Castellino Delle Formiche", "MO"],
            ["Pieve Di Trebbio", "MO"],
            ["Pieve Trebbio", "MO"],
        ],
        "41053": [["Torre Maina", "MO"], ["Gorzano", "MO"], ["Maranello", "MO"], ["Pozza", "MO"]],
        "41054": [["Marano Sul Panaro", "MO"], ["Ospitaletto", "MO"], ["Villa Bianca", "MO"], ["Festa'", "MO"]],
        "41055": [
            ["Iola", "MO"],
            ["Iola Di Montese", "MO"],
            ["Montalto", "MO"],
            ["Bertocchi", "MO"],
            ["Salto", "MO"],
            ["San Martino", "MO"],
            ["Montese", "MO"],
            ["San Giacomo Maggiore", "MO"],
            ["Montespecchio", "MO"],
            ["Castelluccio", "MO"],
            ["Castelluccio Di Moscheda", "MO"],
            ["Maserno", "MO"],
            ["Semelano", "MO"],
        ],
        "41056": [
            ["Formica", "MO"],
            ["Garofano", "MO"],
            ["Magazzino", "MO"],
            ["Savignano Sul Panaro", "MO"],
            ["Mulino", "MO"],
        ],
        "41057": [["Spilamberto", "MO"], ["San Vito", "MO"]],
        "41058": [["Vignola", "MO"]],
        "41059": [
            ["Monteombraro", "MO"],
            ["Montealbano", "MO"],
            ["Montetortore", "MO"],
            ["Ciano Nel Frignano", "MO"],
            ["Montecorone", "MO"],
            ["Missano", "MO"],
            ["Zocca", "MO"],
            ["Rosola", "MO"],
            ["Ciano", "MO"],
        ],
        "41100": [
            ["Villanova San Pancrazio", "MO"],
            ["Vaciglio", "MO"],
            ["Marzaglia", "MO"],
            ["Modena", "MO"],
            ["Baggiovara", "MO"],
            ["Saliceto San Giuliano", "MO"],
            ["Freto", "MO"],
            ["Saliceto Panaro", "MO"],
            ["Lesignana", "MO"],
            ["Chiesa Nuova Di Marzaglia", "MO"],
            ["Cognento", "MO"],
            ["Villanova", "MO"],
            ["Albareto", "MO"],
            ["San Donnino", "MO"],
            ["Ganaceto", "MO"],
            ["Portile", "MO"],
            ["San Damaso", "MO"],
        ],
        "29010": [
            ["Besenzone", "PC"],
            ["Agazzano", "PC"],
            ["Rottofreno", "PC"],
            ["Fogarole", "PC"],
            ["Stra'", "PC"],
            ["Vicobarone", "PC"],
            ["San Nicolo'", "PC"],
            ["Campremoldo Sopra", "PC"],
            ["Gazzola", "PC"],
            ["Sarmato", "PC"],
            ["Monticelli D'Ongina", "PC"],
            ["Tassara", "PC"],
            ["Lusurasco", "PC"],
            ["Ziano Piacentino", "PC"],
            ["Vigoleno", "PC"],
            ["Chiaravalle", "PC"],
            ["Valconasso", "PC"],
            ["Cadeo", "PC"],
            ["Calendasco", "PC"],
            ["San Pietro In Cerro", "PC"],
            ["San Nazzaro D'Ongina", "PC"],
            ["Caminata", "PC"],
            ["Castelnuovo Fogliani", "PC"],
            ["Olza", "PC"],
            ["Roveleto", "PC"],
            ["San Giuliano", "PC"],
            ["Mezzano Chitantolo", "PC"],
            ["Fontana Fredda", "PC"],
            ["San Giuliano Piacentino", "PC"],
            ["Casaliggio", "PC"],
            ["Piozzano", "PC"],
            ["Campremoldo Sopra E Sotto", "PC"],
            ["Bacedasco Sotto", "PC"],
            ["Villanova Sull'Arda", "PC"],
            ["San Nicolo' A Trebbia", "PC"],
            ["Sant'Imento", "PC"],
            ["Villanova", "PC"],
            ["Nibbiano", "PC"],
            ["Vernasca", "PC"],
            ["Pontenure", "PC"],
            ["Pianello Val Tidone", "PC"],
            ["Gragnano Trebbiense", "PC"],
            ["Campremoldo Sotto", "PC"],
            ["Trevozzo", "PC"],
            ["Castelvetro Piacentino", "PC"],
            ["Pecorara", "PC"],
            ["Rezzanello", "PC"],
            ["Alseno", "PC"],
        ],
        "29011": [["Borgonovo Val Tidone", "PC"], ["Castelnovo Val Tidone", "PC"], ["Castelnuovo", "PC"]],
        "29012": [["Caorso", "PC"]],
        "29013": [["Rezzano", "PC"], ["Carpaneto Piacentino", "PC"]],
        "29014": [["Castell'Arquato", "PC"], ["Vigolo Marchese", "PC"]],
        "29015": [["Fontana Pradosa", "PC"], ["Castel San Giovanni", "PC"], ["Creta", "PC"], ["Ganaghello", "PC"]],
        "29016": [["Cortemaggiore", "PC"]],
        "29017": [["San Protaso", "PC"], ["Baselicaduce", "PC"], ["Fiorenzuola D'Arda", "PC"]],
        "29018": [["Chiavenna Rocchetta", "PC"], ["Rustigazzo", "PC"], ["Lugagnano Val D'Arda", "PC"]],
        "29019": [["San Damiano", "PC"], ["San Giorgio Piacentino", "PC"], ["Godi", "PC"]],
        "29020": [
            ["Quadrelli", "PC"],
            ["Perino", "PC"],
            ["Coli", "PC"],
            ["Zerba", "PC"],
            ["Pej", "PC"],
            ["Corte Brugnatella", "PC"],
            ["Morfasso", "PC"],
            ["Quadrelli Di Fellino", "PC"],
            ["Villo'", "PC"],
            ["Cerignale", "PC"],
            ["Carmiano", "PC"],
            ["Marsaglia", "PC"],
            ["Ponte Organasco", "PC"],
            ["Gossolengo", "PC"],
            ["Settima", "PC"],
            ["Vigolzone", "PC"],
            ["Grazzano Visconti", "PC"],
            ["Quarto", "PC"],
            ["Travo", "PC"],
        ],
        "29021": [
            ["San Bernardino", "PC"],
            ["San Giovanni", "PC"],
            ["Bramaiano", "PC"],
            ["Groppoducale", "PC"],
            ["Bettola", "PC"],
        ],
        "29022": [
            ["Santa Maria Di Bobbio", "PC"],
            ["Santa Maria", "PC"],
            ["Cassolo", "PC"],
            ["Vaccarezza", "PC"],
            ["Bobbio", "PC"],
            ["Passo Penice", "PC"],
            ["Mezzano Scotti", "PC"],
            ["Ceci", "PC"],
        ],
        "29023": [["Mareto", "PC"], ["Groppallo", "PC"], ["Le Moline", "PC"], ["Farini", "PC"]],
        "29024": [
            ["Centenaro Castello", "PC"],
            ["Centenaro", "PC"],
            ["Torrio Casetta", "PC"],
            ["Brugneto", "PC"],
            ["Torrio Sopra", "PC"],
            ["Salsominore", "PC"],
            ["Ferriere", "PC"],
            ["Torrio Sopra E Sotto E Casetta", "PC"],
        ],
        "29025": [["Gropparello", "PC"], ["Sariano", "PC"], ["Groppovisdomo", "PC"]],
        "29026": [["Ottone", "PC"], ["Orezzoli", "PC"]],
        "29027": [["Podenzano", "PC"], ["San Polo", "PC"]],
        "29028": [["Torrano", "PC"], ["Ponte Dell'Olio", "PC"], ["Biana", "PC"]],
        "29029": [
            ["Roveleto Landi", "PC"],
            ["Rivergaro", "PC"],
            ["Niviano", "PC"],
            ["Niviano Castello", "PC"],
            ["Ancarano Di Sopra", "PC"],
        ],
        "29100": [
            ["San Bonico", "PC"],
            ["Mucinasso", "PC"],
            ["Pittolo", "PC"],
            ["Roncaglia", "PC"],
            ["Borgo Trebbia", "PC"],
            ["Baia Del Re", "PC"],
            ["Raffaelina", "PC"],
            ["Verza", "PC"],
            ["Gerbido Di Mortizza", "PC"],
            ["Sant'Antonio", "PC"],
            ["San Lazzaro Alberoni", "PC"],
            ["Piacenza", "PC"],
            ["Gerbido", "PC"],
            ["Raffaellina", "PC"],
            ["Mortizza", "PC"],
        ],
        "29121": [["Piacenza", "PC"]],
        "29122": [["Piacenza", "PC"]],
        "43010": [
            ["Bianconese", "PR"],
            ["Monchio Delle Corti", "PR"],
            ["Rigoso", "PR"],
            ["Fontanelle", "PR"],
            ["Riana Di Monchio", "PR"],
            ["Riana", "PR"],
            ["Roccabianca", "PR"],
            ["Castelguelfo", "PR"],
            ["Valditacca", "PR"],
            ["Ragazzola", "PR"],
            ["Ponte Taro", "PR"],
            ["Fontevivo", "PR"],
        ],
        "43011": [["Busseto", "PR"], ["Roncole Verdi", "PR"]],
        "43012": [["Parola", "PR"], ["Fontanellato", "PR"]],
        "43013": [
            ["Riano", "PR"],
            ["Pilastro", "PR"],
            ["Cozzano", "PR"],
            ["Pastorello", "PR"],
            ["Langhirano", "PR"],
            ["Torrechiara", "PR"],
        ],
        "43014": [["Ramiola", "PR"], ["Felegara", "PR"], ["Medesano", "PR"]],
        "43015": [["Cella Di Costamezzana", "PR"], ["Costamezzana", "PR"], ["Noceto", "PR"]],
        "43016": [["Polesine Parmense", "PR"], ["Pieveottoville", "PR"], ["Zibello", "PR"]],
        "43017": [["San Secondo Parmense", "PR"]],
        "43018": [
            ["Coltaro", "PR"],
            ["Ronco Campo Canneto", "PR"],
            ["Gramignazzo", "PR"],
            ["Trecasali", "PR"],
            ["Sissa", "PR"],
            ["San Quirico Trecasali", "PR"],
            ["Sissa Trecasali", "PR"],
            ["Viarolo", "PR"],
        ],
        "43019": [["Soragna", "PR"]],
        "43021": [
            ["Bosco", "PR"],
            ["Beduzzo", "PR"],
            ["Vestola Ghiare", "PR"],
            ["Ghiare Di Corniglio", "PR"],
            ["Corniglio", "PR"],
            ["Bosco Di Corniglio", "PR"],
        ],
        "43022": [
            ["Montechiarugolo", "PR"],
            ["Basilicanova", "PR"],
            ["Monticelli Terme", "PR"],
            ["Monticelli Terme Di Montechiarugolo", "PR"],
            ["Basilicagoiano", "PR"],
        ],
        "43024": [
            ["Scurano", "PR"],
            ["Mediano", "PR"],
            ["Neviano Degli Arduini", "PR"],
            ["Mozzano", "PR"],
            ["Vezzano", "PR"],
            ["Lupazzano", "PR"],
            ["Provazzano", "PR"],
            ["Sasso Di Neviano", "PR"],
            ["Bazzano Parmense", "PR"],
        ],
        "43025": [
            ["Isola", "PR"],
            ["Palanzano", "PR"],
            ["Vairo", "PR"],
            ["Ruzzano", "PR"],
            ["Isola Di Palanzano", "PR"],
            ["Vairo Superiore", "PR"],
            ["Selvanizza", "PR"],
            ["Ranzano", "PR"],
        ],
        "43028": [
            ["Tizzano Val Parma", "PR"],
            ["Carpaneto", "PR"],
            ["Reno", "PR"],
            ["Capoponte", "PR"],
            ["Lagrimone", "PR"],
            ["Capriglio", "PR"],
            ["Musiara Inferiore", "PR"],
        ],
        "43029": [["Traversetolo", "PR"], ["Vignale", "PR"], ["Mamiano", "PR"], ["Castione De' Baratti", "PR"]],
        "43030": [["Marzolara", "PR"], ["Bore", "PR"], ["Calestano", "PR"], ["Ravarano", "PR"]],
        "43032": [
            ["Bardi", "PR"],
            ["Santa Giustina", "PR"],
            ["Pione", "PR"],
            ["Santa Giustina Val Di Lecca", "PR"],
            ["Gravago", "PR"],
        ],
        "43035": [["Sant'Ilario Di Baganza", "PR"], ["San Michele Di Tiorre", "PR"], ["Felino", "PR"]],
        "43036": [
            ["Fidenza", "PR"],
            ["Chiusa Ferranda", "PR"],
            ["Cogolonchio", "PR"],
            ["Castione Marchesi", "PR"],
            ["Castione Dei Marchesi", "PR"],
            ["Pieve Di Cusignano", "PR"],
        ],
        "43037": [
            ["Mulazzano Ponte", "PR"],
            ["San Michele Cavana", "PR"],
            ["Mulazzano", "PR"],
            ["Lesignano De' Bagni", "PR"],
            ["Santa Maria Del Piano", "PR"],
        ],
        "43038": [["San Vitale", "PR"], ["Sala Baganza", "PR"], ["San Vitale Di Baganza", "PR"], ["Talignano", "PR"]],
        "43039": [
            ["Tabiano", "PR"],
            ["Congelasio", "PR"],
            ["Salsomaggiore Terme", "PR"],
            ["Campore", "PR"],
            ["Bagni Di Tabiano", "PR"],
            ["Pie' Di Via", "PR"],
            ["Bargone", "PR"],
            ["Cangelasio", "PR"],
            ["Scipione", "PR"],
        ],
        "43040": [
            ["Corniana", "PR"],
            ["Terenzo", "PR"],
            ["Vianino", "PR"],
            ["Casola", "PR"],
            ["Specchio", "PR"],
            ["Solignano", "PR"],
            ["Selva Del Bocchetto", "PR"],
            ["Viazzano", "PR"],
            ["Cassio", "PR"],
            ["Boschi Di Bardone", "PR"],
            ["Varano De' Melegari", "PR"],
            ["Lesignano Palmia", "PR"],
            ["Prelerna", "PR"],
        ],
        "43041": [
            ["Pontestrambo", "PR"],
            ["Ponteceno", "PR"],
            ["Bedonia", "PR"],
            ["Masanti", "PR"],
            ["Molino Dell'Anzola", "PR"],
            ["Drusco", "PR"],
            ["Masanti Di Sotto", "PR"],
        ],
        "43042": [
            ["Berceto", "PR"],
            ["Ghiare Di Berceto", "PR"],
            ["Ghiare", "PR"],
            ["Bergotto", "PR"],
            ["Castellonchio", "PR"],
            ["Fugazzolo", "PR"],
            ["Casaselvatica", "PR"],
        ],
        "43043": [
            ["Porcigatone", "PR"],
            ["Ostia Parmense", "PR"],
            ["Tiedoli", "PR"],
            ["Ostia Di Borgo Val Di Taro", "PR"],
            ["Pontolo", "PR"],
            ["Borgo Val Di Taro", "PR"],
        ],
        "43044": [
            ["Collecchio", "PR"],
            ["Gaiano", "PR"],
            ["Madregolo", "PR"],
            ["Ozzano Taro", "PR"],
            ["San Martino Sinzano", "PR"],
        ],
        "43045": [
            ["Ricco'", "PR"],
            ["Neviano De' Rossi", "PR"],
            ["Sivizzano", "PR"],
            ["Piantonia", "PR"],
            ["Fornovo Di Taro", "PR"],
        ],
        "43047": [["Pellegrino Parmense", "PR"], ["Grotta", "PR"], ["Mariano", "PR"], ["Iggio", "PR"]],
        "43048": [["Sant'Andrea Bagni", "PR"], ["Varano Marchesi", "PR"], ["Varano Dei Marchesi", "PR"]],
        "43049": [["Pessola", "PR"], ["Carpadasco", "PR"], ["Varsi", "PR"]],
        "43050": [
            ["Valmozzola Stazione", "PR"],
            ["Stazione Valmozzola", "PR"],
            ["Valmozzola", "PR"],
            ["Mormorola", "PR"],
            ["San Martino Di Valmozzola", "PR"],
        ],
        "43051": [["Albareto", "PR"], ["San Quirico", "PR"], ["San Quirico D'Albareto", "PR"], ["Bertorella", "PR"]],
        "43052": [["Colorno", "PR"]],
        "43053": [["Compiano", "PR"], ["Strela", "PR"], ["Cereseto", "PR"]],
        "43055": [
            ["Mezzano Superiore", "PR"],
            ["Casale", "PR"],
            ["Mezzano Rondani", "PR"],
            ["Mezzano Inferiore", "PR"],
        ],
        "43056": [["Torrile", "PR"], ["San Polo", "PR"]],
        "43058": [["Sorbolo", "PR"], ["Chiozzola", "PR"], ["Mezzani", "PR"]],
        "43059": [["Casale Di Tornolo", "PR"], ["Tornolo", "PR"], ["Santa Maria Del Taro", "PR"], ["Tarsogno", "PR"]],
        "43100": [
            ["Vicomero", "PR"],
            ["Botteghino", "PR"],
            ["Alberi", "PR"],
            ["Carignano", "PR"],
            ["Panocchia", "PR"],
            ["Parma", "PR"],
            ["Baganzola", "PR"],
            ["Cortile San Martino", "PR"],
            ["Moletolo", "PR"],
            ["San Leonardo", "PR"],
            ["Vicofertile", "PR"],
            ["Paradigna", "PR"],
            ["Fontanini", "PR"],
            ["Gaione", "PR"],
            ["Fraore", "PR"],
            ["San Lazzaro Parmense", "PR"],
            ["San Prospero Parmense", "PR"],
            ["Fontana", "PR"],
            ["Porporano", "PR"],
            ["Corcagnano", "PR"],
            ["Marano", "PR"],
            ["Vigatto", "PR"],
            ["San Pancrazio Parmense", "PR"],
        ],
        "43122": [["Parma", "PR"]],
        "43126": [["Parma", "PR"]],
        "48010": [["Casal Borsetti", "RA"]],
        "48011": [["Alfonsine", "RA"]],
        "48012": [
            ["Bagnacavallo", "RA"],
            ["Villanova Di Bagnacavallo", "RA"],
            ["Glorie", "RA"],
            ["Abbatesse", "RA"],
            ["Villanova", "RA"],
            ["Boncellino", "RA"],
            ["Masiera", "RA"],
            ["Traversara", "RA"],
        ],
        "48013": [
            ["San Cassiano", "RA"],
            ["Fognano", "RA"],
            ["San Martino In Gattara", "RA"],
            ["Zattaglia", "RA"],
            ["Monteromano", "RA"],
            ["Brisighella", "RA"],
            ["Marzeno", "RA"],
        ],
        "48014": [["Castel Bolognese", "RA"]],
        "48015": [
            ["Pisignano", "RA"],
            ["Villa Inferno", "RA"],
            ["Pinarella", "RA"],
            ["Madonna Degli Angeli", "RA"],
            ["Castiglione", "RA"],
            ["Savio", "RA"],
            ["Cervia", "RA"],
            ["Cannuzzo", "RA"],
            ["Cervia Milano Marittima", "RA"],
        ],
        "48017": [["Conselice", "RA"], ["Lavezzola", "RA"], ["San Patrizio", "RA"]],
        "48018": [
            ["San Martino", "RA"],
            ["Errano", "RA"],
            ["Case San Martino", "RA"],
            ["Castel Raniero", "RA"],
            ["Cosina", "RA"],
            ["Santa Lucia Delle Spianate", "RA"],
            ["Celle", "RA"],
            ["Sarna", "RA"],
            ["San Silvestro", "RA"],
            ["Prada", "RA"],
            ["Faenza", "RA"],
            ["Fossolo", "RA"],
            ["Mezzeno", "RA"],
            ["Reda", "RA"],
            ["Granarolo", "RA"],
        ],
        "48020": [["Savarna", "RA"], ["Sant'Alberto", "RA"], ["Sant'Agata Sul Santerno", "RA"]],
        "48022": [
            ["Santa Maria In Fabriago", "RA"],
            ["San Bernardino", "RA"],
            ["Passogatto", "RA"],
            ["Giovecca", "RA"],
            ["Lugo", "RA"],
            ["San Lorenzo Di Lugo", "RA"],
            ["Ascensione", "RA"],
            ["Voltana", "RA"],
            ["San Potito", "RA"],
            ["Belricetto", "RA"],
            ["Villa San Martino", "RA"],
        ],
        "48024": [["Villa Serraglio", "RA"], ["Massa Lombarda", "RA"]],
        "48025": [["Riolo Terme", "RA"], ["Borgo Rivola", "RA"]],
        "48026": [["San Pancrazio", "RA"], ["Russi", "RA"], ["Godo", "RA"]],
        "48027": [["Gaiano", "RA"], ["Solarolo", "RA"]],
        "48031": [["Bagnara Di Romagna", "RA"]],
        "48032": [["Casola Valsenio", "RA"]],
        "48033": [["Barbiano", "RA"], ["San Severo", "RA"], ["Cotignola", "RA"]],
        "48034": [["Fusignano", "RA"]],
        "48100": [
            ["Santerno", "RA"],
            ["San Bartolo", "RA"],
            ["Lido Di Savio", "RA"],
            ["Piangipane", "RA"],
            ["Madonna Dell'Albero", "RA"],
            ["San Romualdo", "RA"],
            ["Lido Di Classe", "RA"],
            ["Porto Corsini", "RA"],
            ["Camerlona", "RA"],
            ["Mezzano", "RA"],
            ["Romea Vecchia", "RA"],
            ["San Zaccaria", "RA"],
            ["Roncalceci", "RA"],
            ["Ducenta", "RA"],
            ["Classe", "RA"],
            ["Carraie", "RA"],
            ["Durazzano", "RA"],
            ["Filetto", "RA"],
            ["Punta Marina", "RA"],
            ["Gambellara", "RA"],
            ["Marina Romea", "RA"],
            ["Ravenna", "RA"],
            ["Fornace Zarattini", "RA"],
            ["San Pietro In Trento", "RA"],
            ["Ghibullo", "RA"],
            ["Marina Di Ravenna", "RA"],
            ["San Pietro In Vincoli", "RA"],
            ["Campiano", "RA"],
            ["Fosso Ghiaia", "RA"],
            ["Santo Stefano", "RA"],
            ["Lido Adriano", "RA"],
            ["Coccolia", "RA"],
            ["Castiglione Di Ravenna", "RA"],
            ["Porto Fuori", "RA"],
            ["Ammonite", "RA"],
            ["San Pietro In Campiano", "RA"],
        ],
        "42010": [
            ["Quara", "RE"],
            ["Rio Saliceto", "RE"],
            ["Cerredolo", "RE"],
            ["Cavola", "RE"],
            ["Toano", "RE"],
            ["San Cassiano", "RE"],
        ],
        "42011": [["Bagnolo In Piano", "RE"]],
        "42012": [["Campagnola Emilia", "RE"]],
        "42013": [["Villalunga", "RE"], ["Veggia", "RE"], ["Casalgrande", "RE"], ["Salvaterra", "RE"]],
        "42014": [["Cadiroggio", "RE"], ["Castellarano", "RE"], ["Roteglia", "RE"]],
        "42015": [["Prato", "RE"], ["San Martino", "RE"], ["Fosdondo", "RE"], ["Correggio", "RE"], ["Budrio", "RE"]],
        "42016": [["San Girolamo", "RE"], ["Pieve", "RE"], ["Guastalla", "RE"]],
        "42017": [
            ["Novellara", "RE"],
            ["San Bernardino", "RE"],
            ["Santa Maria", "RE"],
            ["Vezzola", "RE"],
            ["San Giovanni", "RE"],
        ],
        "42018": [["San Martino In Rio", "RE"]],
        "42019": [
            ["Arceto", "RE"],
            ["Pratissolo", "RE"],
            ["Ca' De Caroli", "RE"],
            ["Ventoso", "RE"],
            ["Scandiano", "RE"],
            ["Chiozza", "RE"],
            ["Fellegara", "RE"],
            ["Iano", "RE"],
            ["Bosco", "RE"],
            ["Rondinara", "RE"],
        ],
        "42020": [
            ["Vetto", "RE"],
            ["Cola", "RE"],
            ["Puianello", "RE"],
            ["Rosano", "RE"],
            ["Quattro Castella", "RE"],
            ["Borzano", "RE"],
            ["Albinea", "RE"],
            ["San Polo D'Enza", "RE"],
            ["Montecavolo", "RE"],
            ["Roncolo", "RE"],
        ],
        "42021": [["Bibbiano", "RE"], ["Barco", "RE"]],
        "42022": [["Boretto", "RE"]],
        "42023": [["Cadelbosco Di Sopra", "RE"], ["Argine", "RE"], ["Cadelbosco Di Sotto", "RE"]],
        "42024": [["Meletole", "RE"], ["Castelnovo Di Sotto", "RE"]],
        "42025": [["Cavriago", "RE"]],
        "42026": [["Canossa", "RE"], ["Ciano D'Enza", "RE"], ["Compiano D'Enza", "RE"]],
        "42027": [["Montecchio Emilia", "RE"]],
        "42028": [["Poviglio", "RE"]],
        "42030": [
            ["Gazzano", "RE"],
            ["Succiso", "RE"],
            ["Viano", "RE"],
            ["Montalto", "RE"],
            ["Asta Nell'Emilia", "RE"],
            ["Villa Minozzo", "RE"],
            ["San Giovanni Di Querciola", "RE"],
            ["Pecorile", "RE"],
            ["La Vecchia", "RE"],
            ["Regnano", "RE"],
            ["Civago", "RE"],
            ["Minozzo", "RE"],
            ["Sologno", "RE"],
            ["Vezzano Sul Crostolo", "RE"],
        ],
        "42031": [["Baiso", "RE"], ["Casino Levizzano", "RE"], ["Levizzano", "RE"]],
        "42032": [
            ["Succiso Nuovo", "RE"],
            ["Ramiseto", "RE"],
            ["Castagneto", "RE"],
            ["Pieve San Vincenzo", "RE"],
            ["Cervarezza", "RE"],
            ["Cinquecerri", "RE"],
            ["Ligonchio", "RE"],
            ["Busana", "RE"],
            ["Collagna", "RE"],
            ["Cerreto Alpi", "RE"],
        ],
        "42033": [["Carpineti", "RE"], ["Pantano", "RE"], ["Savognatica", "RE"], ["Valestra", "RE"], ["Marola", "RE"]],
        "42034": [["Casina", "RE"], ["Paullo Di Casina", "RE"], ["Trinita'", "RE"]],
        "42035": [
            ["Casale", "RE"],
            ["Felina", "RE"],
            ["Villaberza", "RE"],
            ["Vologno Di Sotto", "RE"],
            ["Vologno", "RE"],
            ["Monteduro", "RE"],
            ["Castelnuovo Ne' Monti", "RE"],
            ["Croce", "RE"],
            ["Croce Ne' Monti", "RE"],
            ["Gatta", "RE"],
            ["Castelnovo Ne' Monti", "RE"],
        ],
        "42040": [["Campegine", "RE"], ["Caprara", "RE"]],
        "42041": [["Brescello", "RE"], ["Lentigione", "RE"]],
        "42042": [["Fabbrico", "RE"]],
        "42043": [["Taneto", "RE"], ["Gattatico", "RE"], ["Praticello", "RE"]],
        "42044": [
            ["Gualtieri", "RE"],
            ["Santa Vittoria Di Gualtieri", "RE"],
            ["Santa Vittoria", "RE"],
            ["Pieve Saliceto", "RE"],
        ],
        "42045": [["Villarotta", "RE"], ["Casoni", "RE"], ["Luzzara", "RE"], ["Codisotto", "RE"]],
        "42046": [["Reggiolo", "RE"], ["Brugneto", "RE"]],
        "42047": [["Rolo", "RE"]],
        "42048": [["Rubiera", "RE"]],
        "42049": [["Sant'Ilario D'Enza", "RE"], ["Calerno", "RE"]],
        "42100": [
            ["Marmirolo", "RE"],
            ["Reggio Emilia", "RE"],
            ["Bagno", "RE"],
            ["San Pellegrino", "RE"],
            ["Mancasale", "RE"],
            ["Gavassa", "RE"],
            ["Cella", "RE"],
            ["Cade'", "RE"],
            ["Ospizio", "RE"],
            ["Fogliano", "RE"],
            ["Quaresimo", "RE"],
            ["Codemondo", "RE"],
            ["Cavazzoli", "RE"],
            ["Coviolo", "RE"],
            ["Roncocesi", "RE"],
            ["Massenzatico", "RE"],
            ["Canali", "RE"],
            ["Castellazzo", "RE"],
            ["Rivalta", "RE"],
            ["Gaida", "RE"],
            ["Pieve Modolena", "RE"],
            ["Masone", "RE"],
            ["Sesso", "RE"],
            ["San Maurizio", "RE"],
            ["Corticella", "RE"],
            ["Gavasseto", "RE"],
        ],
        "47814": [["Igea Marina", "RN"], ["Bellaria Igea Marina", "RN"], ["Bellaria", "RN"]],
        "47822": [
            ["Santarcangelo Di Romagna", "RN"],
            ["Santa Giustina Di Santarcangelo", "RN"],
            ["San Michele", "RN"],
            ["Sant'Ermete", "RN"],
            ["Ciola Corniale", "RN"],
            ["Montalbano Di Santarcangelo Di Romagna", "RN"],
            ["San Martino Dei Mulini", "RN"],
            ["San Vito", "RN"],
        ],
        "47824": [
            ["Poggio Torriana", "RN"],
            ["Torriana", "RN"],
            ["Trebbio", "RN"],
            ["Santo Marino", "RN"],
            ["Poggio Berni", "RN"],
        ],
        "47826": [["Verucchio", "RN"], ["Villa Verucchio", "RN"]],
        "47832": [["San Clemente", "RN"], ["Sant'Andrea In Casale", "RN"]],
        "47833": [["Morciano Di Romagna", "RN"]],
        "47834": [["Montefiore Conca", "RN"], ["Serbadone", "RN"]],
        "47835": [["Saludecio", "RN"], ["Santa Maria Del Monte", "RN"]],
        "47836": [["Mondaino", "RN"]],
        "47837": [["Montegridolfo", "RN"]],
        "47838": [["Riccione", "RN"]],
        "47841": [["Cattolica", "RN"]],
        "47842": [["Pianventena", "RN"], ["Montalbano", "RN"], ["San Giovanni In Marignano", "RN"]],
        "47843": [
            ["Misano Monte", "RN"],
            ["Misano Adriatico", "RN"],
            ["Belvedere", "RN"],
            ["Santa Monica", "RN"],
            ["Villaggio Argentina", "RN"],
            ["Scacciano", "RN"],
            ["Cella", "RN"],
        ],
        "47853": [
            ["Ospedaletto", "RN"],
            ["Ospedaletto Di Rimini", "RN"],
            ["Sant'Andrea In Besanigo", "RN"],
            ["Cerasolo", "RN"],
            ["Coriano", "RN"],
        ],
        "47854": [
            ["Trarivi", "RN"],
            ["San Savino", "RN"],
            ["San Savino Di Monte Colombo", "RN"],
            ["Monte Colombo", "RN"],
            ["Croce", "RN"],
            ["Taverna Di Monte Colombo", "RN"],
            ["Montescudo", "RN"],
            ["Santa Maria Del Piano", "RN"],
        ],
        "47855": [["Onferno", "RN"], ["Gemmano", "RN"]],
        "47861": [["Casteldelci", "RN"]],
        "47862": [["Maiolo", "RN"]],
        "47863": [
            ["Secchiano Marecchia", "RN"],
            ["Ponte Molino Baffoni", "RN"],
            ["Novafeltria", "RN"],
            ["Perticara", "RN"],
        ],
        "47864": [
            ["Molino Di Bascio", "RN"],
            ["Soanne", "RN"],
            ["Ponte Messa", "RN"],
            ["Pennabilli", "RN"],
            ["Maciano", "RN"],
        ],
        "47865": [["San Leo", "RN"], ["Pietracuta", "RN"], ["Montemaggio", "RN"]],
        "47866": [["San Donato", "RN"], ["Sant'Agata Feltria", "RN"]],
        "47867": [["Talamello", "RN"]],
        "47900": [
            ["San Fortunato", "RN"],
            ["Rimini", "RN"],
            ["Rivazzurra", "RN"],
            ["Torre Pedrera", "RN"],
            ["Bellariva", "RN"],
            ["Vergiano", "RN"],
            ["Santa Giustina", "RN"],
            ["San Lorenzo In Correggiano", "RN"],
            ["Miramare Di Rimini", "RN"],
            ["Corpolo'", "RN"],
            ["Viserbella", "RN"],
            ["San Giuliano A Mare", "RN"],
            ["Gaiofana", "RN"],
            ["Viserba", "RN"],
            ["Santa Aquilina", "RN"],
            ["Rivabella", "RN"],
        ],
        "47921": [["Rimini", "RN"]],
        "47922": [["Rimini", "RN"]],
        "47923": [["Rimini", "RN"]],
        "47924": [["Rimini", "RN"]],
        "34070": [
            ["Jamiano", "GO"],
            ["Scrio'", "GO"],
            ["Marcottini", "GO"],
            ["Villesse", "GO"],
            ["Capriva Del Friuli", "GO"],
            ["San Lorenzo Isontino", "GO"],
            ["Mariano Del Friuli", "GO"],
            ["San Floriano Del Collio", "GO"],
            ["Dolegna Del Collio", "GO"],
            ["Corona", "GO"],
            ["Doberdo' Del Lago", "GO"],
            ["Polazzo", "GO"],
            ["Savogna D'Isonzo", "GO"],
            ["Redipuglia", "GO"],
            ["Lonzano", "GO"],
            ["Venco'", "GO"],
            ["Cassegliano", "GO"],
            ["Redipuglia Sacrario", "GO"],
            ["San Pier D'Isonzo", "GO"],
            ["Mernicco", "GO"],
            ["Rupa", "GO"],
            ["San Michele Del Carso", "GO"],
            ["Fogliano Redipuglia", "GO"],
            ["Moraro", "GO"],
            ["Mossa", "GO"],
            ["Giasbana", "GO"],
            ["Turriaco", "GO"],
            ["Gabria", "GO"],
        ],
        "34071": [["Cormons", "GO"], ["Brazzano", "GO"], ["Borgnano", "GO"]],
        "34072": [["Farra D'Isonzo", "GO"], ["Gradisca D'Isonzo", "GO"]],
        "34073": [
            ["Rotta Primero", "GO"],
            ["Grado Citta' Giardino", "GO"],
            ["Fossalon", "GO"],
            ["Grado", "GO"],
            ["Grado Pineta", "GO"],
        ],
        "34074": [["Monfalcone", "GO"], ["Marina Julia", "GO"]],
        "34075": [["Isola Morosini", "GO"], ["Pieris", "GO"], ["San Canzian D'Isonzo", "GO"], ["Begliano", "GO"]],
        "34076": [["Medea", "GO"], ["Versa", "GO"], ["Romans D'Isonzo", "GO"], ["Fratta", "GO"]],
        "34077": [["Ronchi Dei Legionari", "GO"], ["Vermegliano", "GO"]],
        "34078": [["Poggio Terzarmata", "GO"], ["San Martino Del Carso", "GO"], ["Sagrado", "GO"]],
        "34079": [["Bistrigna", "GO"], ["Staranzano", "GO"]],
        "34170": [
            ["Oslavia", "GO"],
            ["Piedimonte Del Calvario", "GO"],
            ["Gorizia", "GO"],
            ["Lucinico", "GO"],
            ["Piuma", "GO"],
        ],
        "33070": [
            ["Polcenigo", "PN"],
            ["Sarone", "PN"],
            ["Caneva", "PN"],
            ["Dardago", "PN"],
            ["Santa Lucia Di Budoia", "PN"],
            ["Brugnera", "PN"],
            ["San Giovanni Di Polcenigo", "PN"],
            ["Stevena'", "PN"],
            ["Maron", "PN"],
            ["Tamai", "PN"],
            ["Budoia", "PN"],
        ],
        "33072": [["San Giovanni Di Casarsa", "PN"], ["Casarsa Della Delizia", "PN"]],
        "33074": [["Vigonovo", "PN"], ["Fontanafredda", "PN"], ["Nave", "PN"], ["Ceolini", "PN"]],
        "33075": [["Morsano Al Tagliamento", "PN"], ["Mussons", "PN"], ["Cordovado", "PN"]],
        "33076": [["Pravisdomini", "PN"], ["Barco", "PN"]],
        "33077": [["Cavolano", "PN"], ["Schiavoi", "PN"], ["Sacile", "PN"], ["San Giovanni Di Livenza", "PN"]],
        "33078": [["San Vito Al Tagliamento", "PN"], ["Gleris", "PN"], ["Savorgnano", "PN"]],
        "33079": [["Ramuscello", "PN"], ["Bagnarola", "PN"], ["Sesto Al Reghena", "PN"], ["Casette", "PN"]],
        "33080": [
            ["Fiume Veneto", "PN"],
            ["Palse", "PN"],
            ["Claut", "PN"],
            ["Bannia", "PN"],
            ["Ghirano", "PN"],
            ["Barcis", "PN"],
            ["Porcia", "PN"],
            ["Vajont", "PN"],
            ["Roraipiccolo", "PN"],
            ["Zoppola", "PN"],
            ["Cimolais", "PN"],
            ["Puia", "PN"],
            ["Poffabro", "PN"],
            ["San Quirino", "PN"],
            ["Cimpello", "PN"],
            ["Sedrano", "PN"],
            ["Castions", "PN"],
            ["San Foca", "PN"],
            ["Prata Di Pordenone", "PN"],
            ["Villanova", "PN"],
            ["Roveredo In Piano", "PN"],
            ["Frisanco", "PN"],
            ["Erto E Casso", "PN"],
            ["Orcenico Inferiore", "PN"],
            ["Andreis", "PN"],
        ],
        "33081": [
            ["Aviano", "PN"],
            ["Castello", "PN"],
            ["Cortina", "PN"],
            ["Giais", "PN"],
            ["Selva", "PN"],
            ["Glera", "PN"],
            ["Marsure", "PN"],
            ["San Martino Di Campagna", "PN"],
        ],
        "33082": [["Corva", "PN"], ["Fagnigola", "PN"], ["Tiezzo", "PN"], ["Azzano Decimo", "PN"]],
        "33083": [["Chions", "PN"], ["Villotta", "PN"], ["Taiedo", "PN"]],
        "33084": [["Musil", "PN"], ["Cordenons", "PN"], ["Villa D'Arco", "PN"]],
        "33085": [["Campagna", "PN"], ["Maniago", "PN"]],
        "33086": [
            ["San Leonardo Valcellina", "PN"],
            ["Montereale Valcellina", "PN"],
            ["San Leonardo", "PN"],
            ["Malnisio", "PN"],
        ],
        "33087": [
            ["Rivarotta", "PN"],
            ["Visinale", "PN"],
            ["Cecchini", "PN"],
            ["Pasiano", "PN"],
            ["Pasiano Di Pordenone", "PN"],
            ["Pozzo", "PN"],
        ],
        "33090": [
            ["Castelnovo Del Friuli", "PN"],
            ["Casiacco", "PN"],
            ["Chievolis", "PN"],
            ["Sequals", "PN"],
            ["Tramonti Di Sopra", "PN"],
            ["Vito D'Asio", "PN"],
            ["Solimbergo", "PN"],
            ["Travesio", "PN"],
            ["Colle", "PN"],
            ["Toppo", "PN"],
            ["Pielungo", "PN"],
            ["Arba", "PN"],
            ["Lestans", "PN"],
            ["Anduins", "PN"],
            ["Campone", "PN"],
            ["Clauzetto", "PN"],
            ["Usago", "PN"],
            ["Tramonti Di Sotto", "PN"],
        ],
        "33092": [["Fanna", "PN"], ["Meduno", "PN"], ["Cavasso Nuovo", "PN"]],
        "33094": [["Valeriano", "PN"], ["Pinzano Al Tagliamento", "PN"]],
        "33095": [["Domanins", "PN"], ["Rauscedo", "PN"], ["Provesano", "PN"], ["San Giorgio Della Richinvelda", "PN"]],
        "33097": [["Tauriano", "PN"], ["Barbeano", "PN"], ["Spilimbergo", "PN"], ["Istrago", "PN"], ["Vacile", "PN"]],
        "33098": [
            ["San Lorenzo", "PN"],
            ["Valvasone Arzene", "PN"],
            ["Arzene", "PN"],
            ["San Martino Al Tagliamento", "PN"],
            ["Valvasone", "PN"],
        ],
        "33099": [["Vivaro", "PN"]],
        "33170": [
            ["Vallenoncello", "PN"],
            ["La Comina", "PN"],
            ["Comina (La)", "PN"],
            ["Borgo Meduna", "PN"],
            ["Pordenone", "PN"],
        ],
        "34010": [["Sgonico", "TS"]],
        "34011": [
            ["Sistiana", "TS"],
            ["Aurisina", "TS"],
            ["Villaggio Del Pescatore", "TS"],
            ["Duino", "TS"],
            ["San Pelagio", "TS"],
            ["Duino Aurisina", "TS"],
            ["Visogliano", "TS"],
        ],
        "34012": [["Basovizza", "TS"]],
        "34014": [["Grignano", "TS"], ["Santa Croce", "TS"], ["Santa Croce Di Trieste", "TS"]],
        "34015": [["Muggia", "TS"], ["San Rocco", "TS"], ["Stramare", "TS"], ["Aquilinia", "TS"]],
        "34016": [["Monrupino", "TS"]],
        "34017": [["Prosecco", "TS"]],
        "34018": [
            ["San Giuseppe Della Chiusa", "TS"],
            ["Domio", "TS"],
            ["Bagnoli Della Rosandra", "TS"],
            ["San Dorligo Della Valle", "TS"],
            ["Sant'Antonio In Bosco", "TS"],
        ],
        "34100": [["Trieste", "TS"]],
        "34121": [["Trieste", "TS"]],
        "34122": [["Trieste", "TS"]],
        "34123": [["Trieste", "TS"]],
        "34124": [["Trieste", "TS"]],
        "34125": [["Trieste", "TS"]],
        "34126": [["Trieste", "TS"]],
        "34127": [["Trieste", "TS"]],
        "34128": [["Trieste", "TS"]],
        "34129": [["Trieste", "TS"]],
        "34131": [["Trieste", "TS"]],
        "34132": [["Trieste", "TS"]],
        "34133": [["Trieste", "TS"]],
        "34134": [["Trieste", "TS"]],
        "34135": [["Trieste", "TS"]],
        "34136": [["Trieste", "TS"], ["Cedas", "TS"]],
        "34137": [["Trieste", "TS"]],
        "34138": [["Trieste", "TS"]],
        "34139": [["Trieste", "TS"]],
        "34141": [["Trieste", "TS"]],
        "34142": [["Trieste", "TS"]],
        "34143": [["Trieste", "TS"]],
        "34144": [["Trieste", "TS"]],
        "34145": [["Trieste", "TS"]],
        "34146": [["Trieste", "TS"]],
        "34147": [["Trieste", "TS"], ["Aquilinia", "TS"]],
        "34148": [["Trieste", "TS"]],
        "34149": [["Trieste", "TS"], ["Cattinara", "TS"]],
        "34151": [["Trieste", "TS"]],
        "33010": [
            ["Carvacco", "UD"],
            ["Treppo Grande", "UD"],
            ["Montenars", "UD"],
            ["Colugna", "UD"],
            ["Borgo Zurini", "UD"],
            ["Magnano In Riviera", "UD"],
            ["Valbruna", "UD"],
            ["Colloredo Di Monte Albano", "UD"],
            ["Mels", "UD"],
            ["Tavagnacco", "UD"],
            ["Peonis", "UD"],
            ["Vendoglio", "UD"],
            ["La Carnia", "UD"],
            ["Reana Del Roiale", "UD"],
            ["Cassacco", "UD"],
            ["Lauzzana", "UD"],
            ["Resia", "UD"],
            ["Venzone", "UD"],
            ["Trasaghis", "UD"],
            ["Malborghetto", "UD"],
            ["Chiusaforte", "UD"],
            ["Ugovizza", "UD"],
            ["Cavalicco", "UD"],
            ["Vergnacco", "UD"],
            ["Qualso", "UD"],
            ["Osoppo", "UD"],
            ["Dogna", "UD"],
            ["Caporiacco", "UD"],
            ["Stolvizza", "UD"],
            ["Lusevera", "UD"],
            ["Avasinis", "UD"],
            ["Resiutta", "UD"],
            ["Feletto Umberto", "UD"],
            ["Vedronza", "UD"],
            ["Alesso", "UD"],
            ["Adegliacco", "UD"],
            ["Carnia", "UD"],
            ["Braulins", "UD"],
            ["Bordano", "UD"],
            ["Pagnacco", "UD"],
            ["Malborghetto Valbruna", "UD"],
        ],
        "33011": [["Artegna", "UD"]],
        "33013": [["Gemona Piovega", "UD"], ["Ospedaletto Di Gemona", "UD"], ["Gemona Del Friuli", "UD"]],
        "33015": [["Moggio Di Sotto", "UD"], ["Moggio Di Sopra", "UD"], ["Moggio Udinese", "UD"]],
        "33016": [["Pontebba", "UD"]],
        "33017": [["Collalto", "UD"], ["Tarcento", "UD"], ["Bulfons", "UD"]],
        "33018": [
            ["Camporosso In Valcanale", "UD"],
            ["Cave Del Predil", "UD"],
            ["Fusine In Valromana", "UD"],
            ["Tarvisio", "UD"],
        ],
        "33019": [["Leonacco", "UD"], ["Tricesimo", "UD"]],
        "33020": [
            ["Forni Avoltri", "UD"],
            ["Prato Carnico", "UD"],
            ["Treppo Carnico", "UD"],
            ["Sutrio", "UD"],
            ["Ligosullo", "UD"],
            ["Ravascletto", "UD"],
            ["Sauris", "UD"],
            ["Forni Di Sotto", "UD"],
            ["Pesariis", "UD"],
            ["Mediis", "UD"],
            ["Cavazzo Carnico", "UD"],
            ["Socchieve", "UD"],
            ["Verzegnis", "UD"],
            ["Cercivento", "UD"],
            ["Pieria", "UD"],
            ["Quinis", "UD"],
            ["Zuglio", "UD"],
            ["Rigolato", "UD"],
            ["Amaro", "UD"],
            ["Preone", "UD"],
            ["Enemonzo", "UD"],
        ],
        "33021": [["Ampezzo", "UD"]],
        "33022": [["Arta Terme", "UD"], ["Piano D'Arta", "UD"]],
        "33023": [["Comeglians", "UD"]],
        "33024": [["Forni Di Sopra", "UD"]],
        "33025": [["Ovaro", "UD"]],
        "33026": [["Paluzza", "UD"], ["Cleulis", "UD"], ["Timau", "UD"]],
        "33027": [["Salino", "UD"], ["Paularo", "UD"], ["Dierico", "UD"]],
        "33028": [
            ["Caneva", "UD"],
            ["Terzo Di Tolmezzo", "UD"],
            ["Caneva Di Tolmezzo", "UD"],
            ["Tolmezzo", "UD"],
            ["Cadunea", "UD"],
            ["Illegio", "UD"],
            ["Imponzo", "UD"],
        ],
        "33029": [
            ["Villa Santina", "UD"],
            ["Invillino", "UD"],
            ["Lauco", "UD"],
            ["Chiassis", "UD"],
            ["Trava", "UD"],
            ["Raveo", "UD"],
        ],
        "33030": [
            ["Dignano", "UD"],
            ["Carpacco", "UD"],
            ["Canussio", "UD"],
            ["San Vito Di Fagagna", "UD"],
            ["Avilla", "UD"],
            ["Talmassons", "UD"],
            ["Coseano", "UD"],
            ["Varmo", "UD"],
            ["San Pietro", "UD"],
            ["Madonna Di Buja", "UD"],
            ["San Giacomo", "UD"],
            ["Flambro", "UD"],
            ["Brazzacco", "UD"],
            ["Basaldella", "UD"],
            ["Rodeano", "UD"],
            ["Vidulis", "UD"],
            ["Silvella", "UD"],
            ["Camino Al Tagliamento", "UD"],
            ["San Tomaso", "UD"],
            ["Majano", "UD"],
            ["Rodeano Basso", "UD"],
            ["Muris Di Ragogna", "UD"],
            ["Campoformido", "UD"],
            ["Flaibano", "UD"],
            ["Roveredo", "UD"],
            ["Santo Stefano Di Buja", "UD"],
            ["Cornino", "UD"],
            ["Flumignano", "UD"],
            ["Ragogna", "UD"],
            ["Buja", "UD"],
            ["Muris", "UD"],
            ["Forgaria Nel Friuli", "UD"],
            ["Urbignacco", "UD"],
            ["Romans Di Varmo", "UD"],
            ["Flagogna", "UD"],
            ["Santa Margherita", "UD"],
            ["Bressa", "UD"],
            ["Rive D'Arcano", "UD"],
            ["Cisterna Del Friuli", "UD"],
            ["Cisterna", "UD"],
            ["Romans", "UD"],
            ["Moruzzo", "UD"],
        ],
        "33031": [
            ["Villaorba", "UD"],
            ["Blessano", "UD"],
            ["Basagliapenta", "UD"],
            ["Variano", "UD"],
            ["Vissandone", "UD"],
            ["Orgnano", "UD"],
            ["Basiliano", "UD"],
        ],
        "33032": [["Bertiolo", "UD"], ["Pozzecco", "UD"]],
        "33033": [
            ["Beano", "UD"],
            ["Rivolto", "UD"],
            ["Codroipo", "UD"],
            ["Biauzzo", "UD"],
            ["Goricizza E Pozzo", "UD"],
            ["Lonca", "UD"],
        ],
        "33034": [["Fagagna", "UD"], ["Madrisio", "UD"], ["Ciconicco", "UD"]],
        "33035": [["Torreano Di Martignacco", "UD"], ["Nogaredo Di Prato", "UD"], ["Martignacco", "UD"]],
        "33036": [
            ["Mereto Di Tomba", "UD"],
            ["Tomba", "UD"],
            ["Plasencis", "UD"],
            ["San Marco", "UD"],
            ["Pantianicco", "UD"],
        ],
        "33037": [["Pasian Di Prato", "UD"], ["Colloredo Di Prato", "UD"], ["Passons", "UD"]],
        "33038": [["Villanova", "UD"], ["Villanova Di San Daniele", "UD"], ["San Daniele Del Friuli", "UD"]],
        "33039": [
            ["Sedegliano", "UD"],
            ["Coderno", "UD"],
            ["Turrida", "UD"],
            ["San Lorenzo", "UD"],
            ["Gradisca Di Sedegliano", "UD"],
        ],
        "33040": [
            ["Savorgnano Del Torre", "UD"],
            ["Savogna", "UD"],
            ["Racchiuso", "UD"],
            ["Campolongo Al Torre", "UD"],
            ["Tapogliano", "UD"],
            ["Grions", "UD"],
            ["Povoletto", "UD"],
            ["Corno Di Rosazzo", "UD"],
            ["Paciug", "UD"],
            ["Podresca", "UD"],
            ["Grimacco", "UD"],
            ["Attimis", "UD"],
            ["Campeglio", "UD"],
            ["Ipplis", "UD"],
            ["Faedis", "UD"],
            ["Stregna", "UD"],
            ["Ravosa", "UD"],
            ["Taipana", "UD"],
            ["Moimacco", "UD"],
            ["Drenchia", "UD"],
            ["Orsaria", "UD"],
            ["San Leonardo", "UD"],
            ["Cavenzano", "UD"],
            ["Visco", "UD"],
            ["Castelmonte", "UD"],
            ["Pradamano", "UD"],
            ["Magredis", "UD"],
            ["Prepotto", "UD"],
            ["Primulacco", "UD"],
            ["Torreano", "UD"],
            ["Premariacco", "UD"],
            ["Clodig", "UD"],
        ],
        "33041": [["Aiello Del Friuli", "UD"], ["Joannis", "UD"]],
        "33042": [["Buttrio", "UD"]],
        "33043": [["Purgessimo", "UD"], ["Sanguarzo", "UD"], ["Cividale Del Friuli", "UD"]],
        "33044": [["Manzano", "UD"]],
        "33045": [["Nimis", "UD"]],
        "33046": [["Pulfero", "UD"]],
        "33047": [["Orzano", "UD"], ["Cerneglons", "UD"], ["Ziracco", "UD"], ["Remanzacco", "UD"]],
        "33048": [
            ["San Giovanni Al Natisone", "UD"],
            ["Chiopris", "UD"],
            ["Medeuzza", "UD"],
            ["Dolegnano", "UD"],
            ["Villanova Dello Iudrio", "UD"],
            ["Chiopris Viscone", "UD"],
        ],
        "33049": [["San Pietro Al Natisone", "UD"]],
        "33050": [
            ["Porpetto", "UD"],
            ["Clauiano", "UD"],
            ["Mortegliano", "UD"],
            ["Chiasellis", "UD"],
            ["Sammardenchia", "UD"],
            ["Pozzuolo Del Friuli", "UD"],
            ["Papariano", "UD"],
            ["Pocenia", "UD"],
            ["Ruda", "UD"],
            ["Castello", "UD"],
            ["Lestizza", "UD"],
            ["Sevegliano", "UD"],
            ["Terenzano", "UD"],
            ["Zugliano", "UD"],
            ["Carpeneto", "UD"],
            ["San Vito Al Torre", "UD"],
            ["Felettis", "UD"],
            ["Ontagnano", "UD"],
            ["Torviscosa", "UD"],
            ["Malisana", "UD"],
            ["Carlino", "UD"],
            ["Fiumicello", "UD"],
            ["Gonars", "UD"],
            ["Precenicco", "UD"],
            ["Castions Di Strada", "UD"],
            ["Galleriano", "UD"],
            ["Lumignacco", "UD"],
            ["Santa Maria", "UD"],
            ["Lavariano", "UD"],
            ["Perteole", "UD"],
            ["Sclaunicco", "UD"],
            ["Terzo D'Aquileia", "UD"],
            ["Cargnacco", "UD"],
            ["Pavia Di Udine", "UD"],
            ["San Valentino", "UD"],
            ["Percoto", "UD"],
            ["Marano Lagunare", "UD"],
            ["Bagnaria Arsa", "UD"],
            ["Risano", "UD"],
            ["Mereto Di Capitolo", "UD"],
            ["Casale Della Madonna", "UD"],
            ["Nespoledo", "UD"],
            ["Trivignano Udinese", "UD"],
            ["Lauzacco", "UD"],
            ["Tissano", "UD"],
            ["Torsa", "UD"],
            ["Torsa Di Pocenia", "UD"],
            ["Bicinicco", "UD"],
            ["Castions Delle Mura", "UD"],
            ["Ronchis", "UD"],
            ["Santa Maria La Longa", "UD"],
        ],
        "33051": [["Belvedere Di Aquileia", "UD"], ["Belvedere", "UD"], ["Aquileia", "UD"]],
        "33052": [["Cervignano Del Friuli", "UD"], ["Strassoldo", "UD"]],
        "33053": [["Pertegada", "UD"], ["Latisana", "UD"], ["Gorgo", "UD"]],
        "33054": [["Lignano Sabbiadoro", "UD"], ["Lignano Pineta", "UD"]],
        "33055": [["Muzzana Del Turgnano", "UD"]],
        "33056": [["Palazzolo Dello Stella", "UD"]],
        "33057": [["Sottoselva", "UD"], ["Ialmicco", "UD"], ["Jalmicco", "UD"], ["Palmanova", "UD"]],
        "33058": [["San Giorgio Di Nogaro", "UD"]],
        "33059": [["Villa Vicentina", "UD"]],
        "33061": [["Teor", "UD"], ["Rivignano Teor", "UD"], ["Rivarotta", "UD"], ["Rivignano", "UD"]],
        "33100": [
            ["Cussignacco", "UD"],
            ["Laipacco", "UD"],
            ["Udine", "UD"],
            ["Baldasseria", "UD"],
            ["Godia", "UD"],
            ["Gervasutta", "UD"],
        ],
        "03010": [
            ["Filettino", "FR"],
            ["Fumone", "FR"],
            ["Torre Cajetani", "FR"],
            ["Sgurgola", "FR"],
            ["Certosa Di Trisulti", "FR"],
            ["Trivigliano", "FR"],
            ["Patrica", "FR"],
            ["Serrone", "FR"],
            ["Pitocco", "FR"],
            ["Collepardo", "FR"],
            ["Vico Nel Lazio", "FR"],
            ["Patoni", "FR"],
            ["La Forma", "FR"],
            ["Madonna Delle Grazie", "FR"],
            ["Trevi Nel Lazio", "FR"],
            ["Quattro Strade", "FR"],
            ["Piglio", "FR"],
            ["San Giovanni", "FR"],
            ["Acuto", "FR"],
        ],
        "03011": [["Monte San Marino", "FR"], ["Tecchiena", "FR"], ["Collelavena", "FR"], ["Alatri", "FR"]],
        "03012": [["Osteria Della Fontana", "FR"], ["Anagni", "FR"]],
        "03013": [["Tofe", "FR"], ["Porciano", "FR"], ["Ferentino", "FR"], ["Ferentino Stazione", "FR"]],
        "03014": [["Fiuggi", "FR"], ["Fiuggi Fonte", "FR"]],
        "03016": [["Guarcino", "FR"], ["Campocatino", "FR"]],
        "03017": [["Morolo", "FR"], ["Cerquotti Madonna Del Piano", "FR"]],
        "03018": [["Paliano", "FR"]],
        "03019": [["Supino", "FR"]],
        "03020": [
            ["Arnara", "FR"],
            ["Pastena", "FR"],
            ["Castro Dei Volsci", "FR"],
            ["Pico", "FR"],
            ["Strangolagalli", "FR"],
            ["Torrice", "FR"],
            ["Vallecorsa", "FR"],
            ["Madonna Del Piano", "FR"],
            ["Falvaterra", "FR"],
            ["San Sosio", "FR"],
            ["Giuliano Di Roma", "FR"],
            ["Villa Santo Stefano", "FR"],
        ],
        "03021": [["Amaseno", "FR"]],
        "03022": [
            ["Scrima", "FR"],
            ["Rotabile", "FR"],
            ["Colle Campano", "FR"],
            ["Casavitola", "FR"],
            ["Mozzano Torretta", "FR"],
            ["Antica Colle Piscioso", "FR"],
            ["Brecciaro", "FR"],
            ["Boville Ernica", "FR"],
        ],
        "03023": [["Ceccano", "FR"]],
        "03024": [["Ceprano", "FR"]],
        "03025": [
            ["Anitrella", "FR"],
            ["Colli", "FR"],
            ["Monte San Giovanni Campano", "FR"],
            ["Porrino", "FR"],
            ["Chiaiamari", "FR"],
        ],
        "03026": [["Pofi", "FR"]],
        "03027": [["Ripi", "FR"]],
        "03028": [["San Giovanni Incarico", "FR"]],
        "03029": [
            ["Scifelli", "FR"],
            ["Colleberardi", "FR"],
            ["Giglio", "FR"],
            ["Castelmassimo", "FR"],
            ["Veroli", "FR"],
            ["Cotropagno", "FR"],
            ["Case Campoli", "FR"],
            ["Santa Francesca", "FR"],
            ["Panetta", "FR"],
            ["Sant'Angelo In Villa", "FR"],
            ["Casamari", "FR"],
        ],
        "03030": [
            ["Santopadre", "FR"],
            ["Villa Santa Lucia", "FR"],
            ["Broccostella", "FR"],
            ["Madonna Della Stella", "FR"],
            ["Campoli Appennino", "FR"],
            ["Colle San Magno", "FR"],
            ["Casalattico", "FR"],
            ["Posta Fibreno", "FR"],
            ["Castrocielo", "FR"],
            ["Piedimonte San Germano", "FR"],
            ["Piedimonte San Germano Alta", "FR"],
            ["Villa Felice", "FR"],
            ["Vicalvi", "FR"],
            ["Rocca D'Arce", "FR"],
            ["Fontechiari", "FR"],
            ["Castelliri", "FR"],
            ["Colfelice", "FR"],
            ["Coldragone", "FR"],
            ["Pescosolido", "FR"],
            ["Piumarola", "FR"],
        ],
        "03031": [["Aquino", "FR"]],
        "03032": [["Isoletta", "FR"], ["Arce", "FR"]],
        "03033": [["Scaffa", "FR"], ["Arpino", "FR"], ["Scaffa San Sossio", "FR"]],
        "03034": [["Casalvieri", "FR"], ["Purgatorio", "FR"], ["Roselli", "FR"]],
        "03035": [
            ["Fontana Liri", "FR"],
            ["Fontana Liri Superiore", "FR"],
            ["Collefontana", "FR"],
            ["San Paolo", "FR"],
        ],
        "03036": [["Isola Del Liri", "FR"]],
        "03037": [
            ["Pontecorvo", "FR"],
            ["Sant'Oliva Di Pontecorvo", "FR"],
            ["Sant'Oliva", "FR"],
            ["Pastine Di Pontecorvo", "FR"],
        ],
        "03038": [["Roccasecca", "FR"], ["Roccasecca Stazione", "FR"], ["Caprile", "FR"]],
        "03039": [["Sora", "FR"], ["Carnello", "FR"], ["Selva Di Sora", "FR"]],
        "03040": [
            ["Selvacava", "FR"],
            ["Cardito Di Vallerotonda", "FR"],
            ["Pignataro Interamna", "FR"],
            ["Valvori", "FR"],
            ["Sant'Ambrogio Sul Garigliano", "FR"],
            ["Gallinaro", "FR"],
            ["Acquafondata", "FR"],
            ["Villa Latina", "FR"],
            ["Picinisco", "FR"],
            ["San Biagio Saracinisco", "FR"],
            ["Cerreto Di Vallerotonda", "FR"],
            ["Casalcassinese", "FR"],
            ["Sant'Andrea Del Garigliano", "FR"],
            ["Pietrafitta", "FR"],
            ["Belmonte Castello", "FR"],
            ["Viticuso", "FR"],
            ["San Vittore Del Lazio", "FR"],
            ["Terelle", "FR"],
            ["Coreno Ausonio", "FR"],
            ["Ausonia", "FR"],
            ["Vallemaio", "FR"],
            ["Castelnuovo Parano", "FR"],
            ["Settefrati", "FR"],
            ["Vallerotonda", "FR"],
        ],
        "03041": [["Castello D'Alvito", "FR"], ["Sant'Onofrio", "FR"], ["Alvito", "FR"]],
        "03042": [["Atina", "FR"], ["Casino Pica", "FR"], ["Atina Inferiore", "FR"]],
        "03043": [
            ["Sant'Angelo In Theodice", "FR"],
            ["San Bartolomeo", "FR"],
            ["Montecassino", "FR"],
            ["Caira", "FR"],
            ["Cassino", "FR"],
            ["Cappella Morrone", "FR"],
        ],
        "03044": [
            ["Pacitti", "FR"],
            ["Sprumaro", "FR"],
            ["Pastenelle", "FR"],
            ["Cervaro", "FR"],
            ["Santa Lucia", "FR"],
        ],
        "03045": [["Monticelli", "FR"], ["Esperia", "FR"], ["Esperia Inferiore", "FR"]],
        "03046": [["San Donato Val Di Comino", "FR"]],
        "03047": [["San Giorgio A Liri", "FR"]],
        "03048": [["Sant'Apollinare", "FR"]],
        "03049": [["Olivella", "FR"], ["Valleluce", "FR"], ["Sant'Elia Fiumerapido", "FR"], ["Portella", "FR"]],
        "03100": [
            ["Frosinone", "FR"],
            ["De Matteis", "FR"],
            ["Madonna Della Neve", "FR"],
            ["Frosinone Stazione", "FR"],
        ],
        "04010": [
            ["Sezze Stazione", "LT"],
            ["Roccasecca Dei Volsci", "LT"],
            ["Prossedi", "LT"],
            ["Sezze Scalo", "LT"],
            ["Giulianello", "LT"],
            ["Roccagorga", "LT"],
            ["Rocca Massima", "LT"],
            ["Pisterzo", "LT"],
            ["Sonnino Scalo", "LT"],
            ["Cori", "LT"],
            ["Bassiano", "LT"],
            ["Maenza", "LT"],
            ["Sonnino", "LT"],
            ["Norma", "LT"],
        ],
        "04011": [
            ["Fossignano", "LT"],
            ["Camilleri", "LT"],
            ["Campoleone", "LT"],
            ["Torre Del Padiglione", "LT"],
            ["Carano", "LT"],
            ["Campoverde", "LT"],
            ["Aprilia", "LT"],
            ["Casalazara", "LT"],
            ["Vallelata", "LT"],
            ["Pantanelle", "LT"],
            ["Campo Di Carne", "LT"],
            ["Cogna", "LT"],
        ],
        "04012": [["Le Castella", "LT"], ["Borgo Flora", "LT"], ["Cisterna Di Latina", "LT"]],
        "04013": [
            ["Sermoneta", "LT"],
            ["Monticchio", "LT"],
            ["Carrara", "LT"],
            ["Doganella Di Ninfa", "LT"],
            ["Doganella", "LT"],
            ["Latina Aeroporto", "LT"],
            ["Sermoneta Scalo", "LT"],
        ],
        "04014": [["Pontinia", "LT"], ["Borgo Pasubio", "LT"]],
        "04015": [["Abbazia Di Fossanova", "LT"], ["Fossanova", "LT"], ["Priverno", "LT"]],
        "04016": [["Borgo Vodice", "LT"], ["Sabaudia", "LT"], ["Borgo San Donato", "LT"], ["Baia D'Argento", "LT"]],
        "04017": [["San Felice Circeo", "LT"], ["Borgo Montenero", "LT"]],
        "04018": [["Colli Di Suso", "LT"], ["Sezze", "LT"]],
        "04019": [["Badino", "LT"], ["Borgo Hermada", "LT"], ["Terracina", "LT"], ["La Fiora", "LT"]],
        "04020": [
            ["Ventotene", "LT"],
            ["Santi Cosma E Damiano", "LT"],
            ["Itri", "LT"],
            ["Santo Stefano", "LT"],
            ["Campodimele", "LT"],
            ["Grunuovo", "LT"],
            ["Monte San Biagio", "LT"],
            ["Campomaggiore San Luca", "LT"],
            ["San Lorenzo Di Santi Cosma E Damiano", "LT"],
            ["Spigno Saturnia", "LT"],
            ["Spigno Saturnia Inferiore", "LT"],
            ["Grunuovo Di Santi Cosma E Damiano", "LT"],
        ],
        "04021": [["Suio Terme", "LT"], ["San Cataldo", "LT"], ["Castelforte", "LT"], ["Forme Di Suio", "LT"]],
        "04022": [["Salto Di Fondi", "LT"], ["San Magno", "LT"], ["Fondi", "LT"]],
        "04023": [
            ["Acquatraversa Di Formia", "LT"],
            ["Penitro", "LT"],
            ["Castellonorato", "LT"],
            ["Trivio Di Formia", "LT"],
            ["Vindicio Di Formia", "LT"],
            ["Maranola", "LT"],
            ["Formia", "LT"],
        ],
        "04024": [["Gaeta", "LT"]],
        "04025": [["Valle Bernardo", "LT"], ["Lenola", "LT"]],
        "04026": [
            ["Scauri", "LT"],
            ["Tufo Di Minturno", "LT"],
            ["Tremensuoli", "LT"],
            ["Minturno", "LT"],
            ["Santa Maria Infante", "LT"],
            ["Marina Di Minturno", "LT"],
        ],
        "04027": [["Ponza", "LT"], ["Le Forna", "LT"]],
        "04029": [["Sperlonga", "LT"]],
        "04100": [
            ["Borgo Grappa", "LT"],
            ["Borgo Podgora", "LT"],
            ["Borgo Carso", "LT"],
            ["Latina Scalo", "LT"],
            ["Borgo San Michele", "LT"],
            ["Borgo Montello", "LT"],
            ["Borgo Piave", "LT"],
            ["Foce Verde", "LT"],
            ["Latina", "LT"],
            ["Borgo Bainsizza", "LT"],
            ["Borgo Faiti", "LT"],
            ["Fogliano", "LT"],
            ["Foro Appio", "LT"],
            ["Tor Tre Ponti", "LT"],
            ["Borgo Isonzo", "LT"],
            ["Borgo Sabotino", "LT"],
            ["Le Ferriere", "LT"],
        ],
        "02010": [
            ["Rivodutri", "RI"],
            ["Borgo Velino", "RI"],
            ["Micigliano", "RI"],
            ["Borbona", "RI"],
            ["Morro Reatino", "RI"],
            ["Labro", "RI"],
            ["Vallemare", "RI"],
            ["Canetra Di Castel Sant'Angelo", "RI"],
            ["Santa Croce Di Cittareale", "RI"],
            ["Colli Sul Velino", "RI"],
            ["Piedicolle", "RI"],
            ["Castel Sant'Angelo", "RI"],
            ["Santa Croce", "RI"],
            ["Cittareale", "RI"],
        ],
        "02011": [["Accumoli", "RI"], ["Grisciano", "RI"]],
        "02012": [
            ["Torrita", "RI"],
            ["Santi Lorenzo E Flaviano", "RI"],
            ["Preta", "RI"],
            ["Collemoresco", "RI"],
            ["Amatrice", "RI"],
            ["Scai", "RI"],
            ["Sommati", "RI"],
            ["Santa Giusta", "RI"],
        ],
        "02013": [["Antrodoco", "RI"]],
        "02014": [["Fantauzzi", "RI"], ["Cantalice", "RI"], ["San Liberato", "RI"]],
        "02015": [["Cittaducale", "RI"], ["Grotti", "RI"], ["Santa Rufina", "RI"], ["Grotti Di Cittaducale", "RI"]],
        "02016": [
            ["San Clemente Di Leonessa", "RI"],
            ["Leonessa", "RI"],
            ["Villa Bigioni", "RI"],
            ["Piedelpoggio", "RI"],
            ["Albaneto", "RI"],
            ["Vindoli", "RI"],
            ["Terzone", "RI"],
        ],
        "02018": [["Poggio Bustone", "RI"]],
        "02019": [["Picciame", "RI"], ["Sigillo Di Posta", "RI"], ["Posta", "RI"], ["Favischio", "RI"]],
        "02020": [
            ["Longone Sabino", "RI"],
            ["Colle Di Tora", "RI"],
            ["Turania", "RI"],
            ["Belmonte In Sabina", "RI"],
            ["Stipes", "RI"],
            ["Collegiove", "RI"],
            ["Varco Sabino", "RI"],
            ["Concerviano", "RI"],
            ["Nespolo", "RI"],
            ["Ascrea", "RI"],
            ["Marcetelli", "RI"],
            ["Campolano", "RI"],
            ["Paganico Sabino", "RI"],
            ["Roccaranieri", "RI"],
            ["Castel Di Tora", "RI"],
            ["Vaccareccia", "RI"],
        ],
        "02021": [
            ["Corvaro", "RI"],
            ["Poggiovalle Di Borgorose", "RI"],
            ["Collemaggiore", "RI"],
            ["Sant'Anatolia", "RI"],
            ["Villerose", "RI"],
            ["Grotti Di Borgorose", "RI"],
            ["Torano", "RI"],
            ["Poggiovalle", "RI"],
            ["Borgorose", "RI"],
        ],
        "02022": [["Collalto Sabino", "RI"]],
        "02023": [
            ["Fiamignano", "RI"],
            ["Santa Lucia Di Fiamignano", "RI"],
            ["Sant'Ippolito", "RI"],
            ["Sant'Agapito", "RI"],
            ["Santa Lucia", "RI"],
            ["Peschieta", "RI"],
        ],
        "02024": [
            ["Pescorocchiano", "RI"],
            ["Leofreni", "RI"],
            ["Pace", "RI"],
            ["Sant'Elpidio Di Pescorocchiano", "RI"],
            ["Sant'Elpidio", "RI"],
        ],
        "02025": [
            ["Fiumata", "RI"],
            ["Castelmareri", "RI"],
            ["Capradosso", "RI"],
            ["Borgo San Pietro", "RI"],
            ["Petrella Salto", "RI"],
        ],
        "02026": [["Rocca Sinibalda", "RI"], ["Posticciola", "RI"]],
        "02030": [
            ["Pozzaglia Sabina", "RI"],
            ["Poggio San Lorenzo", "RI"],
            ["Casaprota", "RI"],
            ["Collelungo", "RI"],
            ["Torricella In Sabina", "RI"],
            ["Poggio Nativo", "RI"],
            ["Collelungo Sabino", "RI"],
            ["Monte Santa Maria", "RI"],
            ["Frasso Sabino", "RI"],
            ["Villetta Sant'Antonio", "RI"],
        ],
        "02031": [["Castelnuovo Di Farfa", "RI"]],
        "02032": [
            ["Canneto Sabino", "RI"],
            ["Prime Case", "RI"],
            ["Borgo Salario", "RI"],
            ["Talocci", "RI"],
            ["Coltodino", "RI"],
            ["Farfa", "RI"],
            ["Passo Corese", "RI"],
            ["Canneto", "RI"],
            ["Borgo Quinzio", "RI"],
            ["Fara In Sabina", "RI"],
            ["Farfa Sabina", "RI"],
            ["Corese Terra", "RI"],
        ],
        "02033": [["Ginestra Sabina", "RI"], ["Monteleone Sabino", "RI"]],
        "02034": [["Bocchignano", "RI"], ["Montopoli Di Sabina", "RI"]],
        "02035": [["Orvinio", "RI"]],
        "02037": [["Fiacchini", "RI"], ["Osteria Nuova", "RI"], ["Cerdomare", "RI"], ["Poggio Moiano", "RI"]],
        "02038": [["Scandriglia", "RI"], ["Ponticelli", "RI"]],
        "02039": [["Toffia", "RI"]],
        "02040": [
            ["Roccantica", "RI"],
            ["Vacone", "RI"],
            ["Cottanello", "RI"],
            ["San Polo Sabino", "RI"],
            ["San Polo", "RI"],
            ["Mompeo", "RI"],
            ["Configni", "RI"],
            ["Fianello", "RI"],
            ["Cantalupo In Sabina", "RI"],
            ["Poggio Catino", "RI"],
            ["Monte San Giovanni In Sabina", "RI"],
            ["Montenero Sabino", "RI"],
            ["Montebuono", "RI"],
            ["Salisano", "RI"],
            ["Tarano", "RI"],
            ["Selci", "RI"],
            ["Montasola", "RI"],
        ],
        "02041": [["Casperia", "RI"]],
        "02042": [["Collevecchio", "RI"]],
        "02043": [
            ["Montisola", "RI"],
            ["Contigliano", "RI"],
            ["San Filippo Di Contigliano", "RI"],
            ["San Filippo", "RI"],
        ],
        "02044": [["Forano", "RI"], ["Gavignano Sabino", "RI"]],
        "02045": [["Greccio", "RI"], ["Limiti Di Greccio", "RI"]],
        "02046": [["Foglia", "RI"], ["Magliano Sabina", "RI"]],
        "02047": [
            ["Castel San Pietro", "RI"],
            ["Poggio Mirteto Scalo", "RI"],
            ["Poggio Mirteto", "RI"],
            ["Poggio Mirteto Stazione", "RI"],
        ],
        "02048": [["Stimigliano Stazione", "RI"], ["Stimigliano", "RI"], ["Stimigliano Scalo", "RI"]],
        "02049": [["Torri In Sabina", "RI"]],
        "02100": [
            ["Poggio Fidoni", "RI"],
            ["Rieti", "RI"],
            ["Casette", "RI"],
            ["Poggio Perugino", "RI"],
            ["San Giovanni Reatino", "RI"],
            ["Vazia", "RI"],
            ["Pie' Di Moggio", "RI"],
            ["Monte Terminillo", "RI"],
        ],
        "00010": [
            ["Poli", "RM"],
            ["Borgo Santa Maria", "RM"],
            ["Montorio Romano", "RM"],
            ["Setteville Di Guidonia", "RM"],
            ["San Polo Dei Cavalieri", "RM"],
            ["Casape", "RM"],
            ["Sant'Angelo Romano", "RM"],
            ["San Gregorio Da Sassola", "RM"],
            ["Gallicano Nel Lazio", "RM"],
            ["Setteville", "RM"],
            ["Marcellina", "RM"],
            ["Monteflavio", "RM"],
            ["Moricone", "RM"],
            ["Montelibretti", "RM"],
        ],
        "00011": [["Bagni Di Tivol", "RM"]],
        "00012": [
            ["Villalba", "RM"],
            ["Colle Verde", "RM"],
            ["Guidonia Montecelio", "RM"],
            ["Villanova", "RM"],
            ["Albuccione", "RM"],
            ["Montecelio", "RM"],
            ["La Botte", "RM"],
            ["Villanova Di Guidonia", "RM"],
            ["Guidonia", "RM"],
        ],
        "00013": [
            ["Castelchiodato", "RM"],
            ["Tor Lupara", "RM"],
            ["Fonte Nuova", "RM"],
            ["Torlupara Di Mentana", "RM"],
            ["Santa Lucia", "RM"],
            ["Mentana", "RM"],
        ],
        "00015": [["Monterotondo", "RM"], ["Monterotondo Stazione", "RM"]],
        "00017": [["Nerola", "RM"], ["Acquaviva", "RM"]],
        "00018": [["Palombara Sabina", "RM"], ["Cretone", "RM"]],
        "00019": [
            ["Tivoli Terme", "RM"],
            ["Pontelucano", "RM"],
            ["Tivoli", "RM"],
            ["Arci", "RM"],
            ["Empolitana", "RM"],
            ["Villa Adriana", "RM"],
            ["Bivio San Polo", "RM"],
        ],
        "00020": [
            ["Jenne", "RM"],
            ["Agosta", "RM"],
            ["Pisoniano", "RM"],
            ["Canterano", "RM"],
            ["Altipiani Di Arcinazzo", "RM"],
            ["Marano Equo", "RM"],
            ["Ciciliano", "RM"],
            ["Arcinazzo Romano", "RM"],
            ["Percile", "RM"],
            ["Vivaro Romano", "RM"],
            ["Madonna Della Pace", "RM"],
            ["Cervara Di Roma", "RM"],
            ["Camerata Nuova", "RM"],
            ["Riofreddo", "RM"],
            ["Cerreto Laziale", "RM"],
            ["Rocca Canterano", "RM"],
            ["Mandela", "RM"],
            ["Vallepietra", "RM"],
            ["Vallinfreda", "RM"],
            ["Cineto Romano", "RM"],
            ["Sambuci", "RM"],
            ["Roccagiovine", "RM"],
            ["Saracinesco", "RM"],
        ],
        "00021": [["Affile", "RM"]],
        "00022": [["Anticoli Corrado", "RM"]],
        "00023": [["Arsoli", "RM"]],
        "00024": [["Castel Madama", "RM"]],
        "00025": [["Gerano", "RM"]],
        "00026": [["Civitella", "RM"], ["Licenza", "RM"]],
        "00027": [["Roviano", "RM"]],
        "00028": [["Subiaco", "RM"]],
        "00029": [["Vicovaro", "RM"]],
        "00030": [
            ["Castel San Pietro Romano", "RM"],
            ["Colonna", "RM"],
            ["San Cesareo", "RM"],
            ["Gorga", "RM"],
            ["Labico", "RM"],
            ["Montelanico", "RM"],
            ["Capranica Prenestina", "RM"],
            ["Guadagnolo", "RM"],
            ["Rocca Di Cave", "RM"],
            ["San Vito Romano", "RM"],
            ["Colonna Stazione", "RM"],
            ["Genazzano", "RM"],
            ["Bellegra", "RM"],
            ["Gavignano", "RM"],
            ["Roiate", "RM"],
            ["Rocca Santo Stefano", "RM"],
        ],
        "00031": [["Artena", "RM"], ["Macere", "RM"], ["Colubro", "RM"]],
        "00032": [["Carpineto Romano", "RM"]],
        "00033": [["San Bartolomeo", "RM"], ["Cave", "RM"]],
        "00034": [["Colleferro Scalo", "RM"], ["Colleferro Stazione", "RM"], ["Colleferro", "RM"]],
        "00035": [["Olevano Romano", "RM"]],
        "00036": [["Palestrina", "RM"], ["Carchitti", "RM"]],
        "00037": [["Segni", "RM"]],
        "00038": [["Valmontone", "RM"]],
        "00039": [["Valle Martella", "RM"], ["Zagarolo", "RM"]],
        "00040": [
            ["Rocca Di Papa", "RM"],
            ["Santa Maria Delle Mole", "RM"],
            ["Tor San Lorenzo", "RM"],
            ["Marina Di Ardea", "RM"],
            ["Ardea", "RM"],
            ["Ponte Sulla Moletta", "RM"],
            ["Frattocchie", "RM"],
        ],
        "00041": [
            ["Cecchina Stazione", "RM"],
            ["Cecchina", "RM"],
            ["Pavona Stazione", "RM"],
            ["Albano Laziale", "RM"],
            ["Pavona", "RM"],
        ],
        "00042": [["Lido Dei Pini", "RM"], ["Anzio", "RM"], ["Lavinio Lido Di Enea", "RM"], ["Colonia Di Anzio", "RM"]],
        "00043": [["Casabianca", "RM"], ["Ciampino Aeroporto", "RM"], ["Ciampino", "RM"]],
        "00044": [["Frascati", "RM"], ["Vermicino", "RM"]],
        "00045": [["Landi", "RM"], ["Pedica", "RM"], ["Genzano Di Roma", "RM"]],
        "00046": [["Poggio Tulliano", "RM"], ["Grottaferrata", "RM"]],
        "00047": [["Marino", "RM"]],
        "00048": [["Nettuno", "RM"]],
        "00049": [["Velletri", "RM"]],
        "00050": [["Testa Di Lepre Di Sopra", "RM"]],
        "00051": [["La Bianca", "RM"], ["Allumiere", "RM"]],
        "00052": [
            ["Ceri", "RM"],
            ["Marina Di Cerveteri", "RM"],
            ["Cerveteri", "RM"],
            ["Cerenova", "RM"],
            ["Stazione Di Furbara", "RM"],
            ["Furbara Cerenova", "RM"],
            ["Borgo San Martino Di Cerveteri", "RM"],
        ],
        "00053": [["Civitavecchia", "RM"], ["Aurelia", "RM"], ["Aurelia Di Civitavecchia", "RM"]],
        "00054": [
            ["Maccarese", "RM"],
            ["Fregene", "RM"],
            ["Testa Di Lepre", "RM"],
            ["Isola Sacra", "RM"],
            ["Fiumicino", "RM"],
            ["Torrimpietra", "RM"],
            ["Focene", "RM"],
            ["Fiumicino Aeroporto", "RM"],
            ["Ara Nova", "RM"],
            ["Passo Oscuro", "RM"],
        ],
        "00055": [["Marina San Nicola", "RM"], ["Ladispoli", "RM"], ["Palo", "RM"]],
        "00057": [["Malagrotta", "RM"], ["Pantano Di Grano", "RM"]],
        "00058": [["Santa Marinella", "RM"], ["Santa Severa", "RM"]],
        "00059": [["Tolfa", "RM"], ["Santa Severa Nord", "RM"]],
        "00060": [
            ["Ponte Storto", "RM"],
            ["Nazzano", "RM"],
            ["Filacciano", "RM"],
            ["Castelnuovo Di Porto", "RM"],
            ["Terme Di Stiglian", "RM"],
            ["Monte Caminetto", "RM"],
            ["Belvedere", "RM"],
            ["Torrita Tiberina", "RM"],
            ["Bellavista", "RM"],
            ["Mazzano Romano", "RM"],
            ["Canale Monterano", "RM"],
            ["Formello", "RM"],
            ["Bivio Di Capanelle", "RM"],
            ["Capena", "RM"],
            ["Bagni Di Stigliano", "RM"],
            ["Le Rughe", "RM"],
            ["Riano", "RM"],
            ["Sant'Oreste", "RM"],
            ["Civitella San Paolo", "RM"],
            ["Magliano Romano", "RM"],
            ["Terrazze", "RM"],
            ["Montevirginio", "RM"],
            ["Girardi", "RM"],
            ["Ponzano Romano", "RM"],
            ["Sacrofano", "RM"],
        ],
        "00061": [["Anguillara Sabazia", "RM"]],
        "00062": [["Bracciano", "RM"], ["Rinascente", "RM"], ["Castel Giuliano", "RM"], ["Vigna Di Valle", "RM"]],
        "00063": [["Campagnano Di Roma", "RM"]],
        "00065": [["Feronia", "RM"], ["Fiano Romano", "RM"]],
        "00066": [["Manziana", "RM"], ["Quadroni", "RM"]],
        "00067": [["Morlupo", "RM"]],
        "00068": [["Rignano Flaminio", "RM"]],
        "00069": [["Vicarello", "RM"], ["Trevignano Romano", "RM"]],
        "00071": [["Pratica Di Mare", "RM"], ["Santa Palomba", "RM"], ["Pomezia", "RM"], ["Torvaianica", "RM"]],
        "00072": [["Ariccia", "RM"], ["Galloro", "RM"]],
        "00073": [["Laghetto Di Castel Gandolfo", "RM"], ["Castel Gandolfo", "RM"]],
        "00074": [["Nemi", "RM"]],
        "00075": [["Pascolare", "RM"], ["Lanuvio", "RM"]],
        "00076": [["Lariano", "RM"]],
        "00077": [["Laghetto Di Montecompatri", "RM"], ["Molara", "RM"], ["Montecompatri", "RM"]],
        "00078": [["Monte Porzio Catone", "RM"], ["Armetta", "RM"]],
        "00079": [["Rocca Priora", "RM"], ["Colle Di Fuori", "RM"]],
        "00118": [["Roma", "RM"]],
        "00119": [["Roma", "RM"], ["Ostia Antica", "RM"]],
        "00120": [["Roma", "RM"]],
        "00121": [["Roma", "RM"], ["Lido Di Ostia Ponente", "RM"]],
        "00122": [["Roma", "RM"], ["Lido Di Ostia Levante", "RM"], ["Castel Fusano", "RM"], ["Castel Porziano", "RM"]],
        "00123": [["La Storta", "RM"], ["Roma", "RM"], ["Isola Farnese", "RM"]],
        "00124": [["Casal Palocco", "RM"], ["Roma", "RM"]],
        "00125": [["Acilia", "RM"], ["Roma", "RM"]],
        "00126": [["Roma", "RM"]],
        "00127": [["Risaro", "RM"], ["Roma", "RM"], ["Mezzocammino", "RM"], ["Vitinia", "RM"]],
        "00128": [
            ["Roma", "RM"],
            ["Castel Di Decima", "RM"],
            ["Castel Romano", "RM"],
            ["Malpasso", "RM"],
            ["Tor De' Cenci", "RM"],
        ],
        "00131": [["Roma", "RM"], ["Settecamini", "RM"]],
        "00132": [
            ["Roma", "RM"],
            ["Borgata Finocchio", "RM"],
            ["Colle Della Valentina", "RM"],
            ["Borgata Borghesiana", "RM"],
        ],
        "00133": [["Torre Gaia", "RM"], ["Torre Angela", "RM"], ["Roma", "RM"], ["Torrenova", "RM"]],
        "00134": [["Castel Di Leva", "RM"], ["Divino Amore", "RM"], ["Roma", "RM"]],
        "00135": [["Roma", "RM"], ["Borgata Ottavia", "RM"], ["La Giustiniana", "RM"]],
        "00136": [["Roma", "RM"]],
        "00137": [["Roma", "RM"]],
        "00138": [
            ["Borgata Fidene", "RM"],
            ["Roma", "RM"],
            ["Marcigliana", "RM"],
            ["Castel Giubileo", "RM"],
            ["Settebagni", "RM"],
        ],
        "00139": [["Roma", "RM"]],
        "00141": [["Roma", "RM"]],
        "00142": [["Roma", "RM"]],
        "00143": [["Roma", "RM"], ["Cecchignola", "RM"]],
        "00144": [["Roma", "RM"], ["Decima", "RM"]],
        "00145": [["Roma", "RM"]],
        "00146": [["Roma", "RM"]],
        "00147": [["Roma", "RM"]],
        "00148": [["Borgata Corviale", "RM"], ["Roma", "RM"], ["Magliana Trullo", "RM"]],
        "00149": [["Roma", "RM"]],
        "00151": [["Roma", "RM"]],
        "00152": [["Roma", "RM"]],
        "00153": [["Roma", "RM"]],
        "00154": [["Roma", "RM"]],
        "00155": [["La Rustica", "RM"], ["Tor Sapienza", "RM"], ["Roma", "RM"]],
        "00156": [["Roma", "RM"], ["Rebibbia", "RM"]],
        "00157": [["Roma", "RM"]],
        "00158": [["Roma", "RM"]],
        "00159": [["Roma", "RM"]],
        "00161": [["Roma", "RM"]],
        "00162": [["Roma", "RM"]],
        "00163": [["Roma", "RM"]],
        "00164": [["Roma", "RM"]],
        "00165": [["Roma", "RM"]],
        "00166": [["Roma", "RM"], ["Borgata Casalotti", "RM"]],
        "00167": [["Roma", "RM"]],
        "00168": [["Roma", "RM"]],
        "00169": [["Roma", "RM"], ["Torre Maura", "RM"], ["Torre Spaccata", "RM"]],
        "00171": [["Roma", "RM"]],
        "00172": [["Roma", "RM"]],
        "00173": [["Roma", "RM"]],
        "00174": [["Roma", "RM"]],
        "00175": [["Roma", "RM"]],
        "00176": [["Roma", "RM"]],
        "00177": [["Roma", "RM"]],
        "00178": [["Roma", "RM"], ["Torricola", "RM"], ["Capannelle", "RM"]],
        "00179": [["Roma", "RM"]],
        "00181": [["Roma", "RM"]],
        "00182": [["Roma", "RM"]],
        "00183": [["Roma", "RM"]],
        "00184": [["Roma", "RM"]],
        "00185": [["Roma", "RM"]],
        "00186": [["Roma", "RM"]],
        "00187": [["Roma", "RM"]],
        "00188": [["Labaro", "RM"], ["Prima Porta", "RM"], ["Roma", "RM"]],
        "00189": [["Roma", "RM"], ["Tomba Di Nerone", "RM"], ["Grottarossa", "RM"]],
        "00191": [["Roma", "RM"]],
        "00192": [["Roma", "RM"]],
        "00193": [["Roma", "RM"]],
        "00194": [["Roma", "RM"]],
        "00195": [["Roma", "RM"]],
        "00196": [["Roma", "RM"]],
        "00197": [["Roma", "RM"]],
        "00198": [["Roma", "RM"]],
        "00199": [["Roma", "RM"]],
        "01010": [
            ["Arlena Di Castro", "VT"],
            ["Blera", "VT"],
            ["Oriolo Romano", "VT"],
            ["Vejano", "VT"],
            ["Barbarano Romano", "VT"],
            ["Gradoli", "VT"],
            ["Piansano", "VT"],
            ["Tessennano", "VT"],
            ["Capodimonte", "VT"],
            ["Villa San Giovanni In Tuscia", "VT"],
            ["Cellere", "VT"],
            ["Onano", "VT"],
            ["Marta", "VT"],
            ["Farnese", "VT"],
            ["Civitella Cesi", "VT"],
            ["Latera", "VT"],
            ["Ischia Di Castro", "VT"],
            ["Monte Romano", "VT"],
        ],
        "01011": [["Musignano", "VT"], ["Canino", "VT"]],
        "01012": [["Vico Matrino", "VT"], ["Capranica", "VT"]],
        "01014": [["Montalto Di Castro", "VT"], ["Pescia Romana", "VT"]],
        "01015": [["Sutri", "VT"]],
        "01016": [["Tarquinia", "VT"], ["Lido Di Tarquinia", "VT"], ["Marina Velca", "VT"]],
        "01017": [["Tuscania", "VT"]],
        "01018": [["Valentano", "VT"]],
        "01019": [
            ["La Botte", "VT"],
            ["Pietrara", "VT"],
            ["Giardino", "VT"],
            ["Tre Croci", "VT"],
            ["Cura", "VT"],
            ["Vetralla", "VT"],
        ],
        "01020": [
            ["Bomarzo", "VT"],
            ["Lubriano", "VT"],
            ["Celleno", "VT"],
            ["Casenuove", "VT"],
            ["San Michele In Teverina", "VT"],
            ["Sipicciano", "VT"],
            ["Proceno", "VT"],
            ["Mugnano", "VT"],
            ["San Lorenzo Nuovo", "VT"],
            ["Civitella D'Agliano", "VT"],
            ["Graffignano", "VT"],
        ],
        "01021": [["Acquapendente", "VT"], ["Torre Alfina", "VT"], ["Trevinano", "VT"]],
        "01022": [["Civita", "VT"], ["Bagnoregio", "VT"], ["Vetriolo", "VT"], ["Castel Cellesi", "VT"]],
        "01023": [["Bolsena", "VT"]],
        "01024": [["Castiglione In Teverina", "VT"], ["Sermugnano", "VT"]],
        "01025": [["Grotte Di Castro", "VT"]],
        "01027": [["Le Mosse", "VT"], ["Montefiascone", "VT"], ["Zepponami", "VT"]],
        "01028": [["Orte Scalo", "VT"], ["Orte", "VT"], ["Orte Stazione", "VT"]],
        "01030": [
            ["Bassano Romano", "VT"],
            ["Vitorchiano Stazione", "VT"],
            ["Vitorchiano", "VT"],
            ["Vallerano", "VT"],
            ["Corchiano", "VT"],
            ["Vasanello", "VT"],
            ["Bassano In Teverina", "VT"],
            ["Castel Sant'Elia", "VT"],
            ["Carbognano", "VT"],
            ["Canepina", "VT"],
            ["Monterosi", "VT"],
            ["Calcata", "VT"],
            ["Faleria", "VT"],
            ["Calcata Nuova", "VT"],
        ],
        "01032": [["Caprarola", "VT"]],
        "01033": [
            ["Borghetto", "VT"],
            ["Civita Castellana Stazione", "VT"],
            ["Borghetto Di Civita Castellana Stazione", "VT"],
            ["Civita Castellana", "VT"],
        ],
        "01034": [["Regolelli", "VT"], ["Fabrica Di Roma", "VT"]],
        "01035": [["Scalo Teverina", "VT"], ["Gallese", "VT"]],
        "01036": [["Nepi", "VT"]],
        "01037": [["Lago Di Vico", "VT"], ["Ronciglione", "VT"]],
        "01038": [["Soriano Nel Cimino", "VT"], ["Chia", "VT"]],
        "01039": [["Vignanello", "VT"]],
        "01100": [
            ["Fastello", "VT"],
            ["Viterbo", "VT"],
            ["Tobia", "VT"],
            ["Magugnano", "VT"],
            ["San Martino Al Cimino", "VT"],
            ["Grotte Santo Stefano", "VT"],
            ["La Quercia", "VT"],
            ["Roccalvecce", "VT"],
            ["Bagnaia", "VT"],
        ],
        "16010": [
            ["Prelo", "GE"],
            ["Tiglieto", "GE"],
            ["Castagna", "GE"],
            ["Savignone", "GE"],
            ["Acquasanta", "GE"],
            ["Rossiglione", "GE"],
            ["Crocefieschi", "GE"],
            ["Mele", "GE"],
            ["Manesseno", "GE"],
            ["Isorelle", "GE"],
            ["Ponte Di Savignone", "GE"],
            ["Pedemonte", "GE"],
            ["Carsi", "GE"],
            ["Masone", "GE"],
            ["Orero Di Serra Ricco'", "GE"],
            ["Valbrevenna", "GE"],
            ["Sant'Olcese", "GE"],
            ["Vobbia", "GE"],
            ["Piccarello", "GE"],
            ["Mainetto", "GE"],
            ["Serra Ricco'", "GE"],
        ],
        "16011": [["Pineta Di Arenzano", "GE"], ["Arenzano", "GE"]],
        "16012": [["Busalla", "GE"], ["Sarissola", "GE"], ["Camarza", "GE"]],
        "16013": [["Campo Ligure", "GE"]],
        "16014": [
            ["Geo", "GE"],
            ["Langasco", "GE"],
            ["Isoverde", "GE"],
            ["Guardia", "GE"],
            ["Ceranesi", "GE"],
            ["Pontasso", "GE"],
            ["Ferriera", "GE"],
            ["Campomorone", "GE"],
            ["Santuario Della Guardia", "GE"],
        ],
        "16015": [["Orero", "GE"], ["Casella", "GE"]],
        "16016": [["Sciarborasca", "GE"], ["Lerca", "GE"], ["Cogoleto", "GE"]],
        "16017": [["Isola Del Cantone", "GE"]],
        "16018": [["Giovi", "GE"], ["Mignanego", "GE"]],
        "16019": [["Pieve", "GE"], ["Ronco Scrivia", "GE"], ["Borgo Fornari", "GE"]],
        "16020": [["Fascia", "GE"], ["Cassingheno", "GE"], ["Gorreto", "GE"], ["Fontanarossa", "GE"]],
        "16021": [["Bargagli", "GE"]],
        "16022": [["Davagna", "GE"], ["Moranego", "GE"], ["Scoffera", "GE"], ["Meco", "GE"]],
        "16023": [["Canale Fontanigorda", "GE"], ["Canale", "GE"], ["Fontanigorda", "GE"], ["Casoni", "GE"]],
        "16024": [["Lumarzo", "GE"]],
        "16025": [["Rondanina", "GE"], ["Ponte Trebbia", "GE"], ["Montebruno", "GE"]],
        "16026": [["Trefontane", "GE"], ["Montoggio", "GE"]],
        "16027": [["Propata", "GE"]],
        "16028": [["Casanova", "GE"], ["Rovegno", "GE"]],
        "16029": [["Fascia Di Carlo", "GE"], ["Torriglia", "GE"], ["Laccio", "GE"]],
        "16030": [
            ["Zoagli", "GE"],
            ["Sori", "GE"],
            ["Sant'Anna", "GE"],
            ["Capreno", "GE"],
            ["Uscio", "GE"],
            ["Colonia Arnaldi", "GE"],
            ["Testana", "GE"],
            ["Bargone", "GE"],
            ["Canepa", "GE"],
            ["Moneglia", "GE"],
            ["Casarza Ligure", "GE"],
            ["Cogorno", "GE"],
            ["Tribogna", "GE"],
            ["Castiglione Chiavarese", "GE"],
            ["San Salvatore", "GE"],
            ["Pieve Ligure", "GE"],
            ["Avegno", "GE"],
            ["Velva", "GE"],
        ],
        "16031": [["Poggio Favaro", "GE"], ["Bogliasco", "GE"], ["San Bernardo", "GE"]],
        "16032": [
            ["San Rocco", "GE"],
            ["San Fruttuoso", "GE"],
            ["San Rocco Di Camogli", "GE"],
            ["Camogli", "GE"],
            ["San Fruttuoso Di Camogli", "GE"],
            ["Ruta", "GE"],
        ],
        "16033": [["Lavagna", "GE"], ["Cavi", "GE"]],
        "16034": [["Portofino", "GE"]],
        "16035": [["San Michele Di Pagana", "GE"], ["San Massimo", "GE"], ["Rapallo", "GE"]],
        "16036": [["Recco", "GE"]],
        "16038": [["Santa Margherita Ligure", "GE"], ["Paraggi", "GE"], ["San Lorenzo Della Costa", "GE"]],
        "16039": [
            ["Sestri Levante", "GE"],
            ["Pila Sul Gromolo", "GE"],
            ["Riva Trigoso", "GE"],
            ["Santa Vittoria Di Libiola", "GE"],
        ],
        "16040": [
            ["Celesia", "GE"],
            ["Leivi", "GE"],
            ["San Colombano Certenoli", "GE"],
            ["Pian Dei Ratti", "GE"],
            ["Calvari", "GE"],
            ["Piandifieno", "GE"],
            ["Ognio", "GE"],
            ["Neirone", "GE"],
            ["Coreglia Ligure", "GE"],
            ["Statale", "GE"],
            ["Ne", "GE"],
            ["Roccatagliata", "GE"],
            ["Isolona", "GE"],
            ["Orero", "GE"],
            ["Reppia", "GE"],
            ["Conscenti", "GE"],
            ["Favale Di Malvaro", "GE"],
        ],
        "16041": [
            ["Giaiette", "GE"],
            ["Prato Sopralacroce", "GE"],
            ["Bertigaro", "GE"],
            ["Borzonasca", "GE"],
            ["Brizzolara", "GE"],
        ],
        "16042": [["Carasco", "GE"], ["Rivarola", "GE"], ["Graveglia", "GE"]],
        "16043": [["Sant'Andrea Di Rovereto", "GE"], ["Chiavari", "GE"], ["Caperana", "GE"]],
        "16044": [["Cicagna", "GE"], ["Monleone", "GE"]],
        "16045": [["Lorsica", "GE"]],
        "16046": [["Passo Del Bocco", "GE"], ["Borgonovo", "GE"], ["Borgonovo Ligure", "GE"], ["Mezzanego", "GE"]],
        "16047": [["Moconesi", "GE"], ["Gattorna", "GE"], ["Ferrada", "GE"]],
        "16048": [
            ["Rezzoaglio", "GE"],
            ["Priosa", "GE"],
            ["Parazzuolo", "GE"],
            ["Magnasco", "GE"],
            ["Cabanne", "GE"],
            ["Alpepiana", "GE"],
        ],
        "16049": [["Amborzasco", "GE"], ["Allegrezze", "GE"], ["Santo Stefano D'Aveto", "GE"]],
        "16100": [["Genova", "GE"]],
        "16121": [["Genova", "GE"]],
        "16122": [["Genova", "GE"]],
        "16123": [["Genova", "GE"]],
        "16124": [["Genova", "GE"]],
        "16125": [["Genova", "GE"]],
        "16126": [["Genova", "GE"]],
        "16127": [["Genova", "GE"]],
        "16128": [["Genova", "GE"]],
        "16129": [["Genova", "GE"]],
        "16131": [["Genova", "GE"]],
        "16132": [["Genova", "GE"]],
        "16133": [["Genova", "GE"], ["Apparizione", "GE"], ["Bavari", "GE"], ["San Desiderio", "GE"]],
        "16134": [["Genova", "GE"]],
        "16135": [["Genova", "GE"]],
        "16136": [["Genova", "GE"]],
        "16137": [["Genova", "GE"], ["Staglieno", "GE"]],
        "16138": [["Genova", "GE"], ["Molassana", "GE"]],
        "16139": [["Genova", "GE"]],
        "16141": [["Genova", "GE"], ["Sant'Eusebio", "GE"]],
        "16142": [["Genova", "GE"]],
        "16143": [["Genova", "GE"]],
        "16144": [["Genova", "GE"]],
        "16145": [["Genova", "GE"]],
        "16146": [["Genova", "GE"]],
        "16147": [["Genova", "GE"], ["Sturla", "GE"]],
        "16148": [["Genova", "GE"], ["Quarto Dei Mille", "GE"]],
        "16149": [["Genova", "GE"], ["Sampierdarena", "GE"]],
        "16151": [["Genova", "GE"], ["Campasso", "GE"]],
        "16152": [["Cornigliano Ligure", "GE"], ["Coronata", "GE"], ["Genova", "GE"]],
        "16153": [["Genova", "GE"], ["Borzoli", "GE"]],
        "16154": [["Genova", "GE"], ["Sestri Ponente", "GE"], ["San Giovanni Battista", "GE"]],
        "16155": [["Pegli", "GE"], ["Multedo", "GE"], ["Genova", "GE"]],
        "16156": [["Genova", "GE"]],
        "16157": [["Genova", "GE"], ["Pra'", "GE"], ["Palmaro Di Pra'", "GE"]],
        "16158": [["Fabbriche", "GE"], ["Voltri", "GE"], ["Genova", "GE"]],
        "16159": [["Genova", "GE"], ["Certosa Di Rivarolo Ligure", "GE"], ["Rivarolo Ligure", "GE"]],
        "16161": [["Fegino", "GE"], ["Genova", "GE"], ["Teglia", "GE"]],
        "16162": [["Genova", "GE"], ["Bolzaneto", "GE"]],
        "16163": [["San Quirico In Val Polcevera", "GE"], ["Genova", "GE"]],
        "16164": [["Genova", "GE"], ["Pontedecimo", "GE"]],
        "16165": [["Struppa", "GE"], ["Genova", "GE"]],
        "16166": [["Genova", "GE"], ["Quinto Al Mare", "GE"]],
        "16167": [["Genova", "GE"], ["Nervi", "GE"], ["Sant'Ilario Ligure", "GE"]],
        "18010": [
            ["Pietrabruna", "IM"],
            ["Villa Faraldi", "IM"],
            ["Riva Faraldi", "IM"],
            ["Carpasio", "IM"],
            ["Montalto Ligure", "IM"],
            ["Cervo", "IM"],
            ["Terzorio", "IM"],
            ["Boscomare", "IM"],
            ["Molini Di Triora", "IM"],
            ["Badalucco", "IM"],
            ["Santo Stefano Al Mare", "IM"],
            ["Agaggio Inferiore", "IM"],
            ["Triora", "IM"],
        ],
        "18011": [["Castellaro", "IM"]],
        "18012": [
            ["Bordighera", "IM"],
            ["Piani Di Borghetto", "IM"],
            ["Bordighera Alta", "IM"],
            ["Seborga", "IM"],
            ["Vallebona", "IM"],
            ["Borghetto San Nicolo'", "IM"],
        ],
        "18013": [
            ["Diano Castello", "IM"],
            ["Diano Arentino", "IM"],
            ["Diano Marina", "IM"],
            ["Diano San Pietro", "IM"],
        ],
        "18014": [["Ospedaletti", "IM"]],
        "18015": [["Riva Ligure", "IM"], ["Pompeiana", "IM"]],
        "18016": [["San Bartolomeo Al Mare", "IM"]],
        "18017": [
            ["San Lorenzo Al Mare", "IM"],
            ["Cipressa", "IM"],
            ["Costarainera", "IM"],
            ["Civezza", "IM"],
            ["Lingueglietta", "IM"],
        ],
        "18018": [["Taggia", "IM"], ["Arma Di Taggia", "IM"]],
        "18019": [["Vallecrosia Alta", "IM"], ["Vallecrosia", "IM"]],
        "18020": [
            ["Caravonica", "IM"],
            ["Vasia", "IM"],
            ["Dolcedo", "IM"],
            ["Aquila Di Arroscia", "IM"],
            ["Lucinasco", "IM"],
            ["Borghetto D'Arroscia", "IM"],
            ["Aurigo", "IM"],
            ["Ranzo", "IM"],
            ["Prela'", "IM"],
        ],
        "18021": [["Borgomaro", "IM"]],
        "18022": [["Arzeno D'Oneglia", "IM"], ["Cesio", "IM"], ["Cartari", "IM"]],
        "18023": [["Cosio Di Arroscia", "IM"]],
        "18024": [["Case Di Nava", "IM"], ["Nava", "IM"], ["Pornassio", "IM"]],
        "18025": [["Mendatica", "IM"], ["Montegrosso Pian Latte", "IM"], ["Piaggia", "CN"], ["Briga Alta", "CN"]],
        "18026": [
            ["Armo", "IM"],
            ["Calderara", "IM"],
            ["Pieve Di Teco", "IM"],
            ["Rezzo", "IM"],
            ["Vessalico", "IM"],
            ["Cenova", "IM"],
        ],
        "18027": [["Pontedassio", "IM"], ["Chiusanico", "IM"], ["Chiusavecchia", "IM"]],
        "18030": [
            ["Airole", "IM"],
            ["Rocchetta Nervina", "IM"],
            ["Olivetta San Michele", "IM"],
            ["Castel Vittorio", "IM"],
        ],
        "18031": [["Bajardo", "IM"]],
        "18032": [["Perinaldo", "IM"]],
        "18033": [["Camporosso Mare", "IM"], ["Camporosso", "IM"]],
        "18034": [["Ceriana", "IM"]],
        "18035": [["Dolceacqua", "IM"], ["Isolabona", "IM"], ["Apricale", "IM"]],
        "18036": [["Soldano", "IM"], ["San Biagio Della Cima", "IM"]],
        "18037": [["Pigna", "IM"]],
        "18038": [
            ["Coldirodi", "IM"],
            ["San Remo", "IM"],
            ["San Bartolomeo", "IM"],
            ["Borello", "IM"],
            ["San Giacomo", "IM"],
            ["Bussana", "IM"],
            ["Poggio", "IM"],
            ["Verezzo", "IM"],
            ["San Romolo", "IM"],
        ],
        "18039": [
            ["Bevera", "IM"],
            ["Sealza", "IM"],
            ["Ventimiglia", "IM"],
            ["Torri", "IM"],
            ["Sant'Antonio", "IM"],
            ["Grimaldi", "IM"],
            ["Grimaldi Di Ventimiglia", "IM"],
            ["Calvo", "IM"],
            ["Latte", "IM"],
            ["Trucco", "IM"],
            ["Roverino", "IM"],
        ],
        "18100": [
            ["Imperia", "IM"],
            ["Vasia", "IM"],
            ["Dolcedo", "IM"],
            ["Porto Maurizio", "IM"],
            ["Borgo Primo", "IM"],
            ["Prela'", "IM"],
            ["Oneglia", "IM"],
            ["Castelvecchio Di Santa Maria Maggiore", "IM"],
            ["Caramagna Ligure", "IM"],
        ],
        "19010": [["Torza", "SP"], ["Maissana", "SP"]],
        "19011": [["Bonassola", "SP"]],
        "19012": [["Castello", "SP"], ["Carro", "SP"]],
        "19013": [["Deiva Marina", "SP"]],
        "19014": [["Framura", "SP"]],
        "19015": [["Levanto", "SP"], ["Montale", "SP"]],
        "19016": [["Monterosso Al Mare", "SP"]],
        "19017": [["Manarola", "SP"], ["Riomaggiore", "SP"]],
        "19018": [["Vernazza", "SP"], ["Corniglia", "SP"]],
        "19020": [
            ["Bottagna", "SP"],
            ["Calice Al Cornoviglio", "SP"],
            ["Cavanella Vara", "SP"],
            ["Pieve Di Zignago", "SP"],
            ["Ponzo'", "SP"],
            ["Fornola", "SP"],
            ["Zignago", "SP"],
            ["Piano Di Valeriano", "SP"],
            ["Piano Di Follo", "SP"],
            ["Follo", "SP"],
            ["Padivarma", "SP"],
            ["Suvero", "SP"],
            ["Beverino", "SP"],
            ["Mattarana", "SP"],
            ["Valeriano", "SP"],
            ["Carrodano", "SP"],
            ["Borghetto Di Vara", "SP"],
            ["Rocchetta Di Vara", "SP"],
            ["Bastremoli", "SP"],
            ["Tivegna", "SP"],
            ["Valdurasca", "SP"],
            ["Brugnato", "SP"],
            ["Ponzo' Bovecchio", "SP"],
            ["San Martino Di Durasca", "SP"],
            ["Veppo", "SP"],
            ["Madonna Di Buonviaggio", "SP"],
            ["Piana Battolla", "SP"],
            ["Vezzano Ligure", "SP"],
            ["Pignone", "SP"],
            ["Carpena", "SP"],
            ["Sesta Godano", "SP"],
            ["Prati", "SP"],
            ["Ricco' Del Golfo Di Spezia", "SP"],
            ["Bolano", "SP"],
            ["Ceparana", "SP"],
            ["San Benedetto", "SP"],
        ],
        "19021": [["Romito Magra", "SP"], ["Arcola", "SP"]],
        "19025": [
            ["Portovenere", "SP"],
            ["Le Grazie Varignano", "SP"],
            ["Isola Palmaria", "SP"],
            ["Le Grazie", "SP"],
            ["Fezzano", "SP"],
        ],
        "19028": [
            ["Varese Ligure", "SP"],
            ["San Pietro Vara", "SP"],
            ["Scurtabo'", "SP"],
            ["Comuneglia", "SP"],
            ["Porciorasco", "SP"],
        ],
        "19030": [["Fiumaretta", "SP"]],
        "19031": [
            ["Fiumaretta Di Ameglia", "SP"],
            ["Montemarcello", "SP"],
            ["Ameglia", "SP"],
            ["Bocca Di Magra", "SP"],
        ],
        "19032": [
            ["Serra", "SP"],
            ["Tellaro", "SP"],
            ["Lerici", "SP"],
            ["Pugliola", "SP"],
            ["Fiascherino", "SP"],
            ["San Terenzo", "SP"],
        ],
        "19033": [["Molicciara", "SP"], ["Colombiera", "SP"], ["Castelnuovo Magra", "SP"]],
        "19034": [
            ["Luni", "SP"],
            ["Ortonovo", "SP"],
            ["Dogana", "SP"],
            ["Isola Di Ortonovo", "SP"],
            ["Casano", "SP"],
            ["Luni Mare", "SP"],
            ["Nicola", "SP"],
            ["Serravalle", "SP"],
        ],
        "19037": [["Ponzano Magra", "SP"], ["Ponzano Superiore", "SP"], ["Santo Stefano Di Magra", "SP"]],
        "19038": [
            ["Sarzana", "SP"],
            ["Falcinello", "SP"],
            ["Marinella Di Sarzana", "SP"],
            ["Sarzanello", "SP"],
            ["San Lazzaro", "SP"],
            ["Marinella", "SP"],
            ["Santa Caterina", "SP"],
        ],
        "19100": [["La Spezia", "SP"]],
        "19121": [["Laspezia", "SP"]],
        "19122": [["Laspezia", "SP"]],
        "19123": [["Fabiano", "SP"], ["Chiappa", "SP"], ["Laspezia", "SP"], ["Pegazzano", "SP"]],
        "19124": [["Laspezia", "SP"], ["La Spezia", "SP"]],
        "19125": [["Laspezia", "SP"], ["Migliarina", "SP"]],
        "19126": [["Isola", "SP"], ["Laspezia", "SP"]],
        "19131": [["Laspezia", "SP"], ["Cadimare", "SP"]],
        "19132": [["Marola", "SP"], ["Laspezia", "SP"], ["Campiglia", "SP"]],
        "19133": [["Biassa", "SP"], ["Laspezia", "SP"]],
        "19134": [["Laspezia", "SP"], ["Marinasco", "SP"], ["La Foce", "SP"]],
        "19135": [["Laspezia", "SP"], ["San Venerio", "SP"]],
        "19136": [["Termo", "SP"], ["Laspezia", "SP"], ["Melara", "SP"], ["Limone", "SP"]],
        "19137": [["Laspezia", "SP"], ["Pitelli", "SP"]],
        "19138": [["Laspezia", "SP"], ["San Bartolomeo", "SP"]],
        "19139": [["Muggiano", "SP"], ["Laspezia", "SP"]],
        "12071": [["Massimino", "SV"], ["Bagnasco", "CN"]],
        "17010": [["Osiglia", "SV"], ["Giusvalla", "SV"]],
        "17011": [["Albisola Superiore", "SV"], ["Albisola Capo", "SV"], ["Ellera", "SV"]],
        "17012": [["Albissola Marina", "SV"]],
        "17013": [["Murialdo", "SV"], ["Valle", "SV"], ["Valle Di Murialdo", "SV"], ["Piano", "SV"]],
        "17014": [
            ["San Giuseppe Di Cairo", "SV"],
            ["Bragno", "SV"],
            ["Rocchetta Cairo", "SV"],
            ["San Giuseppe", "SV"],
            ["Ferrania", "SV"],
            ["Cairo Montenotte", "SV"],
        ],
        "17015": [["Celle Ligure", "SV"]],
        "17017": [["Roccavignale", "SV"], ["Millesimo", "SV"], ["Cosseria", "SV"]],
        "17019": [["Alpicella", "SV"], ["Casanova", "SV"], ["Varazze", "SV"], ["Faie", "SV"], ["Pero", "SV"]],
        "17020": [
            ["Bardino Nuovo", "SV"],
            ["Stellanello", "SV"],
            ["Calice Ligure", "SV"],
            ["Tovo San Giacomo", "SV"],
            ["Balestrino", "SV"],
            ["Magliolo", "SV"],
            ["Testico", "SV"],
            ["Bardino Vecchio", "SV"],
            ["Rialto", "SV"],
        ],
        "17021": [["Alassio", "SV"], ["Moglio", "SV"]],
        "17022": [["Borgio Verezzi", "SV"], ["Borgio", "SV"]],
        "17023": [["Ceriale", "SV"]],
        "17024": [
            ["Orco Feglino", "SV"],
            ["Varigotti", "SV"],
            ["Feglino", "SV"],
            ["Finalborgo", "SV"],
            ["Finale Ligure", "SV"],
            ["Gorra", "SV"],
        ],
        "17025": [["Loano", "SV"]],
        "17026": [["Noli", "SV"]],
        "17027": [["Giustenice", "SV"], ["Pietra Ligure", "SV"]],
        "17028": [["Bergeggi", "SV"], ["Spotorno", "SV"], ["Vezzi Portio", "SV"]],
        "17030": [["Erli", "SV"], ["Castelbianco", "SV"], ["Nasino", "SV"]],
        "17031": [
            ["San Fedele", "SV"],
            ["Bastia", "SV"],
            ["Leca", "SV"],
            ["Lusignano", "SV"],
            ["Albenga", "SV"],
            ["Campochiesa", "SV"],
        ],
        "17032": [["Arnasco", "SV"], ["Vendone", "SV"]],
        "17033": [["Villafranca", "SV"], ["Garlenda", "SV"], ["Casanova Lerrone", "SV"]],
        "17034": [["Castelvecchio Di Rocca Barbena", "SV"]],
        "17035": [["Cisano Sul Neva", "SV"]],
        "17037": [["Pogli", "SV"], ["Onzo", "SV"], ["Ortovero", "SV"]],
        "17038": [["Villanova D'Albenga", "SV"]],
        "17039": [["Zuccarello", "SV"]],
        "17040": [["Mioglia", "SV"]],
        "17041": [["Altare", "SV"], ["Cadibona", "SV"]],
        "17042": [["Giovo Ligure", "SV"], ["Giovo", "SV"], ["Pontinvrea", "SV"]],
        "17043": [["Plodio", "SV"], ["Pallare", "SV"], ["Piani", "SV"], ["Carcare", "SV"]],
        "17044": [
            ["Santa Giustina", "SV"],
            ["San Martino Stella", "SV"],
            ["San Martino", "SV"],
            ["Stella", "SV"],
            ["San Bernardo", "SV"],
        ],
        "17045": [["Mallare", "SV"], ["Bormida", "SV"]],
        "17046": [["Sassello", "SV"], ["Palo", "SV"], ["Piampaludo", "SV"]],
        "17047": [["Vado Ligure", "SV"], ["Valleggia", "SV"], ["Quiliano", "SV"]],
        "17048": [
            ["Olba", "SV"],
            ["San Pietro D'Olba", "SV"],
            ["Vara", "SV"],
            ["Vara Inferiore", "SV"],
            ["Vara Superiore", "SV"],
            ["Urbe", "SV"],
        ],
        "17051": [["Andora", "SV"], ["Marina Di Andora", "SV"]],
        "17052": [["Borghetto Santo Spirito", "SV"]],
        "17053": [["Laigueglia", "SV"]],
        "17054": [["Boissano", "SV"]],
        "17055": [["Toirano", "SV"]],
        "17056": [["Cengio", "SV"]],
        "17057": [["Calizzano", "SV"], ["Bardineto", "SV"], ["Caragna", "SV"]],
        "17058": [["Piana Crixia", "SV"], ["Dego", "SV"]],
        "17100": [
            ["Savona", "SV"],
            ["Santuario", "SV"],
            ["Santuario Di Savona", "SV"],
            ["Zinola", "SV"],
            ["Legino", "SV"],
            ["Lavagnola", "SV"],
            ["Fornaci", "SV"],
        ],
        "24010": [
            ["Dossena", "BG"],
            ["Vedeseta", "BG"],
            ["Costa Serina", "BG"],
            ["Ubiale", "BG"],
            ["Olmo Al Brembo", "BG"],
            ["Valleve", "BG"],
            ["Ubiale Clanezzo", "BG"],
            ["Branzi", "BG"],
            ["Muggiasca", "BG"],
            ["Valnegra", "BG"],
            ["Colla", "BG"],
            ["Moio De' Calvi", "BG"],
            ["Piazzatorre", "BG"],
            ["Roncobello", "BG"],
            ["Piazzolo", "BG"],
            ["Carona", "BG"],
            ["Cusio", "BG"],
            ["Camerata Cornello", "BG"],
            ["Peghera", "BG"],
            ["Ornica", "BG"],
            ["Cassiglio", "BG"],
            ["Foppolo", "BG"],
            ["Botta Di Sedrina", "BG"],
            ["Ponteranica", "BG"],
            ["Sorisole", "BG"],
            ["Mezzoldo", "BG"],
            ["Clanezzo", "BG"],
            ["Santa Brigida", "BG"],
            ["Botta", "BG"],
            ["Isola Di Fondra", "BG"],
            ["Bordogna", "BG"],
            ["Algua", "BG"],
            ["Petosino", "BG"],
            ["Taleggio", "BG"],
            ["Valtorta", "BG"],
            ["Averara", "BG"],
            ["Fondra", "BG"],
            ["Olda", "BG"],
            ["Lenna", "BG"],
            ["Bracca", "BG"],
            ["Blello", "BG"],
            ["Sedrina", "BG"],
        ],
        "24011": [["Alme'", "BG"]],
        "24012": [
            ["Laxolo", "BG"],
            ["San Gottardo", "BG"],
            ["Gerosa", "BG"],
            ["Brembilla", "BG"],
            ["Val Brembilla", "BG"],
        ],
        "24013": [["Oltre Il Colle", "BG"]],
        "24014": [["Piazza Brembana", "BG"]],
        "24015": [["San Giovanni Bianco", "BG"]],
        "24016": [["Santa Croce", "BG"], ["San Pellegrino Terme", "BG"]],
        "24017": [["Cornalba", "BG"], ["Serina", "BG"]],
        "24018": [["Villa D'Alme'", "BG"]],
        "24019": [["Poscante", "BG"], ["Spino", "BG"], ["Zogno", "BG"], ["Ambria", "BG"]],
        "24020": [
            ["Selvino", "BG"],
            ["Bondione", "BG"],
            ["Villa Di Serio", "BG"],
            ["Negrone", "BG"],
            ["Cene", "BG"],
            ["Casnigo", "BG"],
            ["Piario", "BG"],
            ["Ardesio", "BG"],
            ["Gorle", "BG"],
            ["Parre", "BG"],
            ["Songavazzo", "BG"],
            ["Fiumenero", "BG"],
            ["Fino Del Monte", "BG"],
            ["Dezzo", "BG"],
            ["Valgoglio", "BG"],
            ["Cerete Basso", "BG"],
            ["Ponte Selva", "BG"],
            ["Ranica", "BG"],
            ["Boario", "BG"],
            ["Premolo", "BG"],
            ["Peia", "BG"],
            ["Cerete", "BG"],
            ["Oneta", "BG"],
            ["Torre Boldone", "BG"],
            ["Rovetta", "BG"],
            ["Gorno", "BG"],
            ["Aviatico", "BG"],
            ["Scanzorosciate", "BG"],
            ["Gavarno", "BG"],
            ["Parre Ponte Selva", "BG"],
            ["San Lorenzo Di Rovetta", "BG"],
            ["Pradalunga", "BG"],
            ["Onore", "BG"],
            ["Gromo", "BG"],
            ["Valbondione", "BG"],
            ["Bratto", "BG"],
            ["Gandellino", "BG"],
            ["Colzate", "BG"],
            ["Vilminore", "BG"],
            ["Scanzo", "BG"],
            ["Castione Della Presolana", "BG"],
            ["Azzone", "BG"],
            ["Oltressenda Alta", "BG"],
            ["Cantoniera Della Presolana", "BG"],
            ["Vilminore Di Scalve", "BG"],
            ["Colere", "BG"],
            ["Schilpario", "BG"],
            ["Villa D'Ogna", "BG"],
            ["Tribulina", "BG"],
            ["Villassio", "BG"],
            ["Fiorano Al Serio", "BG"],
            ["Rosciate", "BG"],
            ["Lizzola", "BG"],
            ["Cornale", "BG"],
        ],
        "24021": [
            ["Comenduno", "BG"],
            ["Abbazia", "BG"],
            ["Albino", "BG"],
            ["Vall'Alta", "BG"],
            ["Desenzano Al Serio", "BG"],
            ["Bondo Petello", "BG"],
        ],
        "24022": [["Alzano Lombardo", "BG"], ["Nese", "BG"]],
        "24023": [["Clusone", "BG"]],
        "24024": [["Gandino", "BG"]],
        "24025": [["Orezzo", "BG"], ["Gazzaniga", "BG"]],
        "24026": [["Cazzano Sant'Andrea", "BG"], ["Leffe", "BG"]],
        "24027": [["Gavarno Rinnovata", "BG"], ["Nembro", "BG"]],
        "24028": [["Ponte Nossa", "BG"]],
        "24029": [["Vertova", "BG"]],
        "24030": [
            ["Camoneone", "BG"],
            ["Paladina", "BG"],
            ["Ponte Giurino", "BG"],
            ["Caprino Bergamasco", "BG"],
            ["Crocette", "BG"],
            ["Valbrembo", "BG"],
            ["Strozza", "BG"],
            ["Mapello", "BG"],
            ["Celana", "BG"],
            ["Berbenno", "BG"],
            ["Costa Valle Imagna", "BG"],
            ["Capizzone", "BG"],
            ["Terno D'Isola", "BG"],
            ["Caprino", "BG"],
            ["Ambivere", "BG"],
            ["Brembate Di Sopra", "BG"],
            ["Presezzo", "BG"],
            ["Corna Imagna", "BG"],
            ["Mozzo", "BG"],
            ["Carvico", "BG"],
            ["Barzana", "BG"],
            ["Roncola", "BG"],
            ["Medolago", "BG"],
            ["Solza", "BG"],
            ["Bedulita", "BG"],
            ["Sant'Antonio", "BG"],
            ["Pontida", "BG"],
            ["Fuipiano Valle Imagna", "BG"],
            ["Locatello", "BG"],
            ["Scano Al Brembo", "BG"],
            ["Gromlongo", "BG"],
            ["Almenno San Bartolomeo", "BG"],
            ["Palazzago", "BG"],
            ["Villa D'Adda", "BG"],
        ],
        "24031": [["Almenno San Salvatore", "BG"]],
        "24033": [["Calusco D'Adda", "BG"]],
        "24034": [["Cisano Bergamasco", "BG"]],
        "24035": [["Curno", "BG"]],
        "24036": [["Ponte San Pietro", "BG"]],
        "24037": [["Rota D'Imagna", "BG"], ["Brumano", "BG"], ["Frontale", "BG"], ["Calchera", "BG"]],
        "24038": [["Mazzoleni", "BG"], ["Selino Basso", "BG"], ["Valsecca", "BG"], ["Sant'Omobono Terme", "BG"]],
        "24039": [["Sotto Il Monte Giovanni Xxiii", "BG"], ["Piazza Caduti", "BG"]],
        "24040": [
            ["Suisio", "BG"],
            ["Lallio", "BG"],
            ["Castel Rozzone", "BG"],
            ["Grumello Del Piano", "BG"],
            ["Isso", "BG"],
            ["Casirate D'Adda", "BG"],
            ["Arcene", "BG"],
            ["Bonate Sotto", "BG"],
            ["Madone", "BG"],
            ["Boltiere", "BG"],
            ["Zingonia", "BG"],
            ["Levate", "BG"],
            ["Pontirolo Nuovo", "BG"],
            ["Canonica D'Adda", "BG"],
            ["Arzago D'Adda", "BG"],
            ["Bottanuco", "BG"],
            ["Filago", "BG"],
            ["Fornovo San Giovanni", "BG"],
            ["Osio Sopra", "BG"],
            ["Verdellino", "BG"],
            ["Ghiaie", "BG"],
            ["Stezzano", "BG"],
            ["Calvenzano", "BG"],
            ["Bonate Sopra", "BG"],
            ["Pognano", "BG"],
            ["Comun Nuovo", "BG"],
            ["Ciserano", "BG"],
            ["Chignolo D'Isola", "BG"],
            ["Misano Di Gera D'Adda", "BG"],
            ["Pagazzano", "BG"],
            ["Barbata", "BG"],
        ],
        "24041": [["Brembate", "BG"], ["Grignano", "BG"]],
        "24042": [["Capriate San Gervasio", "BG"], ["San Gervasio D'Adda", "BG"], ["Crespi D'Adda", "BG"]],
        "24043": [["Vidalengo", "BG"], ["Caravaggio", "BG"], ["Masano", "BG"]],
        "24044": [["Dalmine", "BG"], ["Sforzatica", "BG"], ["Sabbio Bergamasco", "BG"]],
        "24045": [["Badalasco", "BG"], ["Fara Gera D'Adda", "BG"]],
        "24046": [["Osio Sotto", "BG"]],
        "24047": [["Geromina", "BG"], ["Treviglio", "BG"], ["Castel Cerreto", "BG"]],
        "24048": [["Treviolo", "BG"]],
        "24049": [["Verdello", "BG"]],
        "24050": [
            ["Bariano", "BG"],
            ["Torre Pallavicina", "BG"],
            ["Mozzanica", "BG"],
            ["Cortenuova", "BG"],
            ["Lurano", "BG"],
            ["Malpaga", "BG"],
            ["Cavernago", "BG"],
            ["Pumenengo", "BG"],
            ["Zanica", "BG"],
            ["Palosco", "BG"],
            ["Mornico Al Serio", "BG"],
            ["Calcinate", "BG"],
            ["Cividate Al Piano", "BG"],
            ["Ghisalba", "BG"],
            ["Grassobbio", "BG"],
            ["Covo", "BG"],
            ["Morengo", "BG"],
            ["Orio Al Serio", "BG"],
            ["Spirano", "BG"],
        ],
        "24051": [["Antegnate", "BG"]],
        "24052": [["Azzano San Paolo", "BG"]],
        "24053": [["Brignano Gera D'Adda", "BG"]],
        "24054": [["Calcio", "BG"]],
        "24055": [["Cologno Al Serio", "BG"]],
        "24056": [["Fontanella", "BG"]],
        "24057": [["Martinengo", "BG"]],
        "24058": [
            ["Romano Di Lombardia", "BG"],
            ["Fara Olivana", "BG"],
            ["Fara Olivana Con Sola", "BG"],
            ["Sola", "BG"],
        ],
        "24059": [["Basella", "BG"], ["Urgnano", "BG"]],
        "24060": [
            ["Gaverina Terme", "BG"],
            ["Viadanica", "BG"],
            ["Sovere", "BG"],
            ["Castelli Calepio", "BG"],
            ["Credaro", "BG"],
            ["Ranzanico", "BG"],
            ["Casco", "BG"],
            ["Carobbio Degli Angeli", "BG"],
            ["Bianzano", "BG"],
            ["Endine", "BG"],
            ["Gorlago", "BG"],
            ["Bossico", "BG"],
            ["Chiuduno", "BG"],
            ["Monasterolo", "BG"],
            ["Torre De' Roveri", "BG"],
            ["Entratico", "BG"],
            ["Berzo San Fermo", "BG"],
            ["Telgate", "BG"],
            ["Pianico", "BG"],
            ["Spinone Al Lago", "BG"],
            ["Villongo", "BG"],
            ["Zandobbio", "BG"],
            ["Parzanica", "BG"],
            ["Foresto Sparso", "BG"],
            ["Rogno", "BG"],
            ["Borgo Di Terzo", "BG"],
            ["Brusaporto", "BG"],
            ["Adrara San Martino", "BG"],
            ["Cividino", "BG"],
            ["Endine Gaiano", "BG"],
            ["Castel De' Conti", "BG"],
            ["San Paolo D'Argon", "BG"],
            ["Casazza", "BG"],
            ["Solto Collina", "BG"],
            ["Piangaiano", "BG"],
            ["Cenate Sopra", "BG"],
            ["Celatica", "BG"],
            ["Vigolo", "BG"],
            ["Grone", "BG"],
            ["Predore", "BG"],
            ["Tolari", "BG"],
            ["Costa Di Mezzate", "BG"],
            ["Montello", "BG"],
            ["Gandosso", "BG"],
            ["Vigano San Martino", "BG"],
            ["Adrara San Rocco", "BG"],
            ["Bolgare", "BG"],
            ["Fonteno", "BG"],
            ["Tavernola Bergamasca", "BG"],
            ["Bagnatica", "BG"],
            ["Monasterolo Del Castello", "BG"],
            ["Riva Di Solto", "BG"],
        ],
        "24061": [["Albano Sant'Alessandro", "BG"]],
        "24062": [["Costa Volpino", "BG"]],
        "24063": [["Castro", "BG"], ["Fonderia Di Lovere", "BG"]],
        "24064": [["Grumello Del Monte", "BG"]],
        "24065": [["Lovere", "BG"]],
        "24066": [["Pedrengo", "BG"]],
        "24067": [["Sarnico", "BG"]],
        "24068": [["Seriate", "BG"], ["Cassinone", "BG"]],
        "24069": [["Cenate Di Sotto", "BG"], ["Luzzana", "BG"], ["Cenate Sotto", "BG"], ["Trescore Balneario", "BG"]],
        "24100": [["Bergamo", "BG"]],
        "24121": [["Bergamo", "BG"]],
        "24122": [["Bergamo", "BG"]],
        "24123": [["Bergamo", "BG"], ["Valtesse", "BG"]],
        "24124": [["Redona", "BG"], ["Bergamo", "BG"]],
        "24125": [["Boccaleone", "BG"], ["Bergamo", "BG"]],
        "24126": [["Colognola Al Piano", "BG"], ["Malpensata", "BG"], ["Campagnola", "BG"], ["Bergamo", "BG"]],
        "24127": [["Bergamo", "BG"]],
        "24128": [["Bergamo", "BG"], ["Loreto", "BG"]],
        "24129": [["Bergamo", "BG"], ["Longuelo", "BG"]],
        "25010": [
            ["Campione Del Garda", "BS"],
            ["San Zeno Naviglio", "BS"],
            ["Visano", "BS"],
            ["San Felice Del Benaco", "BS"],
            ["Acquafredda", "BS"],
            ["Remedello Di Sotto", "BS"],
            ["Isorella", "BS"],
            ["Limone Sul Garda", "BS"],
            ["San Martino Della Battaglia", "BS"],
            ["Campione", "BS"],
            ["Rivoltella", "BS"],
            ["Tremosine", "BS"],
            ["Remedello Di Sopra", "BS"],
            ["Remedello", "BS"],
            ["Pozzolengo", "BS"],
            ["Montirone", "BS"],
            ["Vesio", "BS"],
            ["Borgosatollo", "BS"],
        ],
        "25011": [["Calcinatello", "BS"], ["Calcinato", "BS"], ["Ponte San Marco", "BS"]],
        "25012": [["Viadana", "BS"], ["Calvisano", "BS"], ["Malpaga", "BS"], ["Mezzane", "BS"]],
        "25013": [["Carpenedolo", "BS"]],
        "25014": [["Capodimonte", "BS"], ["Castenedolo", "BS"]],
        "25015": [["Desenzano Del Garda", "BS"]],
        "25016": [["Ghedi", "BS"]],
        "25017": [["Lonato", "BS"], ["Sedena", "BS"], ["Centenaro", "BS"], ["Esenta", "BS"]],
        "25018": [["Vighizzolo", "BS"], ["Sant'Antonio", "BS"], ["Montichiari", "BS"], ["Novagli", "BS"]],
        "25019": [["Colombare Di Sirmione", "BS"], ["Sirmione", "BS"]],
        "25020": [
            ["Scarpizzolo", "BS"],
            ["Cignano", "BS"],
            ["Offlaga", "BS"],
            ["Gambara", "BS"],
            ["San Gervasio Bresciano", "BS"],
            ["Cigole", "BS"],
            ["Faverzano", "BS"],
            ["Poncarale", "BS"],
            ["Capriano Del Colle", "BS"],
            ["Corticelle Pieve", "BS"],
            ["Bassano Bresciano", "BS"],
            ["Fiesse", "BS"],
            ["Milzano", "BS"],
            ["San Paolo", "BS"],
            ["Flero", "BS"],
            ["Pralboino", "BS"],
            ["Azzano Mella", "BS"],
            ["Quinzanello", "BS"],
            ["Seniga", "BS"],
            ["Pavone Del Mella", "BS"],
            ["Alfianello", "BS"],
            ["Dello", "BS"],
        ],
        "25021": [["Bagnolo Mella", "BS"]],
        "25022": [["Borgo San Giacomo", "BS"], ["Motella", "BS"], ["Farfengo", "BS"], ["Padernello", "BS"]],
        "25023": [["Gottolengo", "BS"]],
        "25024": [["Castelletto", "BS"], ["Castelletto Di Leno", "BS"], ["Porzano", "BS"], ["Leno", "BS"]],
        "25025": [["Manerbio", "BS"]],
        "25026": [["Pontevico", "BS"]],
        "25027": [["Quinzano D'Oglio", "BS"]],
        "25028": [["Verolanuova", "BS"], ["Cadignano", "BS"]],
        "25029": [["Verolavecchia", "BS"]],
        "25030": [
            ["Longhena", "BS"],
            ["Pievedizio", "BS"],
            ["Pompiano", "BS"],
            ["Mairano", "BS"],
            ["Ludriano", "BS"],
            ["Roncadelle", "BS"],
            ["Barbariga", "BS"],
            ["Torbole Casaglia", "BS"],
            ["Brandico", "BS"],
            ["Berlingo", "BS"],
            ["Erbusco", "BS"],
            ["Castelcovati", "BS"],
            ["Torbiato", "BS"],
            ["Castrezzato", "BS"],
            ["Roccafranca", "BS"],
            ["Maclodio", "BS"],
            ["Urago D'Oglio", "BS"],
            ["Rudiano", "BS"],
            ["Cossirano", "BS"],
            ["Paratico", "BS"],
            ["Villa Pedergnano", "BS"],
            ["Lograto", "BS"],
            ["Comezzano Cizzago", "BS"],
            ["Villachiara", "BS"],
            ["Zocco", "BS"],
            ["Orzivecchi", "BS"],
            ["Castel Mella", "BS"],
            ["Comezzano", "BS"],
            ["Cizzago", "BS"],
            ["Coccaglio", "BS"],
            ["Trenzano", "BS"],
            ["Corzano", "BS"],
            ["Adro", "BS"],
        ],
        "25031": [["Capriolo", "BS"]],
        "25032": [["Chiari", "BS"]],
        "25033": [["Cologne", "BS"]],
        "25034": [["Orzinuovi", "BS"], ["Coniolo", "BS"]],
        "25035": [["Ospitaletto", "BS"]],
        "25036": [["Palazzolo Sull'Oglio", "BS"], ["San Pancrazio", "BS"]],
        "25037": [["Pontoglio", "BS"]],
        "25038": [["Duomo", "BS"], ["Sant'Andrea", "BS"], ["Rovato", "BS"], ["Lodetto", "BS"], ["Sant'Anna", "BS"]],
        "25039": [["Travagliato", "BS"]],
        "25040": [
            ["Forno D'Allione", "BS"],
            ["Cerveno", "BS"],
            ["Badetto", "BS"],
            ["Plemo", "BS"],
            ["Incudine", "BS"],
            ["Monticelli Brusati", "BS"],
            ["Lozio", "BS"],
            ["Forno Allione", "BS"],
            ["Corte Franca", "BS"],
            ["Galleno", "BS"],
            ["Borgonato", "BS"],
            ["Nigoline", "BS"],
            ["Malonno", "BS"],
            ["Bienno", "BS"],
            ["Artogne", "BS"],
            ["Saviore Dell'Adamello", "BS"],
            ["Timoline", "BS"],
            ["Monno", "BS"],
            ["Bonomelli", "BS"],
            ["Angolo Terme", "BS"],
            ["Sacca", "BS"],
            ["Cevo", "BS"],
            ["Berzo Demo", "BS"],
            ["Prestine", "BS"],
            ["Gianico", "BS"],
            ["Colombaro", "BS"],
            ["Braone", "BS"],
            ["Esine", "BS"],
            ["Santicolo", "BS"],
            ["Ono San Pietro", "BS"],
            ["Corteno Golgi", "BS"],
            ["Parmezzana Calzana", "BS"],
            ["Ceto", "BS"],
            ["Berzo Inferiore", "BS"],
            ["Cividate Camuno", "BS"],
        ],
        "25041": [["Boario Terme", "BS"], ["Erbanno", "BS"]],
        "25042": [["Borno", "BS"]],
        "25043": [["Astrio", "BS"], ["Pescarzo", "BS"], ["Breno", "BS"]],
        "25044": [["Capo Di Ponte", "BS"]],
        "25045": [["Castegnato", "BS"]],
        "25046": [["Bornato", "BS"], ["Cazzago San Martino", "BS"], ["Calino", "BS"], ["Pedrocca", "BS"]],
        "25047": [["Gorzone", "BS"], ["Darfo Boario Terme", "BS"], ["Darfo", "BS"]],
        "25048": [["Cortenedolo", "BS"], ["Edolo", "BS"], ["Sonico", "BS"]],
        "25049": [["Pilzone", "BS"], ["Iseo", "BS"], ["Clusane", "BS"]],
        "25050": [
            ["Paderno Franciacorta", "BS"],
            ["Provezze", "BS"],
            ["Temu'", "BS"],
            ["Stadolina", "BS"],
            ["Zone", "BS"],
            ["Camignone", "BS"],
            ["Ossimo Superiore", "BS"],
            ["Peschiera Maraglio", "BS"],
            ["Sellero", "BS"],
            ["Vione", "BS"],
            ["Ossimo Inferiore", "BS"],
            ["Rodengo Saiano", "BS"],
            ["Ossimo", "BS"],
            ["Novelle", "BS"],
            ["Fontane", "BS"],
            ["Ponte Cingoli", "BS"],
            ["Crist", "BS"],
            ["Monte Isola", "BS"],
            ["Pontagna", "BS"],
            ["Cimbergo", "BS"],
            ["Zurane", "BS"],
            ["Siviano", "BS"],
            ["Provaglio D'Iseo", "BS"],
            ["Monterotondo", "BS"],
            ["Passirano", "BS"],
            ["Valle Di Saviore", "BS"],
            ["Ome", "BS"],
            ["Niardo", "BS"],
            ["Gresine", "BS"],
            ["Paisco Loveno", "BS"],
            ["Pian Camuno", "BS"],
            ["Paspardo", "BS"],
            ["Losine", "BS"],
        ],
        "25051": [["Cedegolo", "BS"]],
        "25052": [["Pian Di Borno", "BS"], ["Cogno", "BS"], ["Annunciata", "BS"], ["Piancogno", "BS"]],
        "25053": [["Malegno", "BS"]],
        "25054": [["Marone", "BS"]],
        "25055": [["Pisogne", "BS"], ["Toline", "BS"], ["Gratacasolo", "BS"]],
        "25056": [["Ponte Di Legno", "BS"]],
        "25057": [["Sale Marasino", "BS"]],
        "25058": [["Sulzano", "BS"]],
        "25059": [["Vezza D'Oglio", "BS"]],
        "25060": [
            ["Pezzaze", "BS"],
            ["Cellatica", "BS"],
            ["Tavernole Sul Mella", "BS"],
            ["Lodrino", "BS"],
            ["Polaveno", "BS"],
            ["Gombio", "BS"],
            ["Marcheno", "BS"],
            ["Stravignino", "BS"],
            ["Brozzo", "BS"],
            ["Fantasina", "BS"],
            ["Marmentino", "BS"],
            ["Collebeato", "BS"],
            ["Collio", "BS"],
            ["Lavone", "BS"],
            ["San Colombano", "BS"],
            ["Lavone Di Pezzaze", "BS"],
            ["Brione", "BS"],
        ],
        "25061": [["Irma", "BS"], ["Bovegno", "BS"]],
        "25062": [["San Vigilio", "BS"], ["Concesio", "BS"]],
        "25063": [["Gardone Val Trompia", "BS"], ["Magno", "BS"]],
        "25064": [["Piazza", "BS"], ["Ronco", "BS"], ["Mandolossa", "BS"], ["Gussago", "BS"]],
        "25065": [
            ["Lumezzane Pieve", "BS"],
            ["Lumezzane Sant'Apollonio", "BS"],
            ["Pieve", "BS"],
            ["Sant'Apollonio", "BS"],
            ["Lumezzane", "BS"],
            ["San Sebastiano", "BS"],
        ],
        "25068": [["Ponte Zanano", "BS"], ["Zanano", "BS"], ["Sarezzo", "BS"]],
        "25069": [["Carcina", "BS"], ["Cogozzo", "BS"], ["Villa Carcina", "BS"]],
        "25070": [
            ["Preseglie", "BS"],
            ["Trebbio", "BS"],
            ["Sabbio Chiese", "BS"],
            ["Mura", "BS"],
            ["Barghe", "BS"],
            ["Capovalle", "BS"],
            ["Sottocastello", "BS"],
            ["Treviso Bresciano", "BS"],
            ["Anfo", "BS"],
            ["Gazzane", "BS"],
            ["Provaglio Val Sabbia", "BS"],
            ["Casto", "BS"],
            ["Ponte Caffaro", "BS"],
            ["Caino", "BS"],
            ["San Faustino", "BS"],
            ["Livemmo", "BS"],
            ["Bione", "BS"],
            ["Pertica Alta", "BS"],
        ],
        "25071": [["Agnosine", "BS"]],
        "25072": [["Bagolino", "BS"]],
        "25073": [["Bovezzo", "BS"]],
        "25074": [["Idro", "BS"], ["Lavenone", "BS"], ["Crone", "BS"]],
        "25075": [["Nave", "BS"]],
        "25076": [["Odolo", "BS"]],
        "25077": [["Roe' Volciano", "BS"], ["Roe'", "BS"]],
        "25078": [["Forno D'Ono", "BS"], ["Pertica Bassa", "BS"], ["Vestone", "BS"], ["Nozza", "BS"]],
        "25079": [["Vobarno", "BS"], ["Carpeneda", "BS"], ["Pompegnino", "BS"], ["Degagna", "BS"]],
        "25080": [
            ["Padenghe Sul Garda", "BS"],
            ["Valvestino", "BS"],
            ["Vallio Terme", "BS"],
            ["Soiano Del Lago", "BS"],
            ["Mazzano", "BS"],
            ["Ciliverghe", "BS"],
            ["Calvagese Della Riviera", "BS"],
            ["Moniga Del Garda", "BS"],
            ["Soiano", "BS"],
            ["Castello", "BS"],
            ["Molinetto", "BS"],
            ["Gardola", "BS"],
            ["Serle", "BS"],
            ["Magasa", "BS"],
            ["Paitone", "BS"],
            ["Carzago Riviera", "BS"],
            ["Manerba Del Garda", "BS"],
            ["Carzago Della Riviera", "BS"],
            ["Nuvolento", "BS"],
            ["Moerna", "BS"],
            ["Chiesa", "BS"],
            ["Solarolo", "BS"],
            ["Case Nuove", "BS"],
            ["Puegnago Sul Garda", "BS"],
            ["Nuvolera", "BS"],
            ["Polpenazze Del Garda", "BS"],
            ["Prevalle", "BS"],
            ["Muscoline", "BS"],
            ["Tignale", "BS"],
            ["Raffa", "BS"],
        ],
        "25081": [["Bedizzole", "BS"], ["Campagnola", "BS"]],
        "25082": [["Botticino Sera", "BS"], ["Botticino Mattina", "BS"], ["Botticino", "BS"], ["San Gallo", "BS"]],
        "25083": [["San Michele", "BS"], ["Gardone Riviera", "BS"], ["Fasano Del Garda", "BS"], ["Montecucco", "BS"]],
        "25084": [["Gargnano", "BS"], ["Bogliaco", "BS"], ["Navazzo", "BS"]],
        "25085": [["San Giacomo", "BS"], ["San Biagio", "BS"], ["Sopraponte", "BS"], ["Gavardo", "BS"]],
        "25086": [["Rezzato", "BS"], ["Virle Treponti", "BS"]],
        "25087": [["Barbarano", "BS"], ["Campoverde", "BS"], ["Salo'", "BS"]],
        "25088": [["Toscolano Maderno", "BS"], ["Maderno", "BS"]],
        "25089": [["Bostone", "BS"], ["Villanuova Sul Clisi", "BS"]],
        "25100": [["Brescia", "BS"]],
        "25121": [["Brescia", "BS"]],
        "25122": [["Brescia", "BS"]],
        "25123": [["Brescia", "BS"]],
        "25124": [["Brescia", "BS"]],
        "25125": [["Brescia", "BS"]],
        "25126": [["Brescia", "BS"]],
        "25127": [["Brescia", "BS"]],
        "25128": [["Brescia", "BS"]],
        "25129": [["Brescia", "BS"], ["Bettole Di Buffalora", "BS"]],
        "25131": [["Fornaci", "BS"], ["Brescia", "BS"]],
        "25132": [["Brescia", "BS"], ["Mandolossa Di Brescia", "BS"]],
        "25133": [["Brescia", "BS"], ["Mompiano", "BS"]],
        "25134": [["San Polo", "BS"], ["Brescia", "BS"]],
        "25135": [["Brescia", "BS"], ["Caionvico", "BS"], ["Sant'Eufemia Della Fonte", "BS"]],
        "25136": [["Stocchetta", "BS"], ["Brescia", "BS"]],
        "22010": [
            ["San Nazzaro Val Cavargna", "CO"],
            ["Urio", "CO"],
            ["Stazzona", "CO"],
            ["Dosso Del Liro", "CO"],
            ["Germasino", "CO"],
            ["Peglio", "CO"],
            ["San Gregorio", "CO"],
            ["Plesio", "CO"],
            ["Carate Urio", "CO"],
            ["Laglio", "CO"],
            ["Brienno", "CO"],
            ["Musso", "CO"],
            ["Albogasio", "CO"],
            ["Bene Lario", "CO"],
            ["Livo", "CO"],
            ["Montemezzo", "CO"],
            ["Calozzo", "CO"],
            ["Ossuccio", "CO"],
            ["Cusino", "CO"],
            ["Carlazzo", "CO"],
            ["Garzeno", "CO"],
            ["Acquaseria", "CO"],
            ["Santa Maria", "CO"],
            ["Claino Con Osteno", "CO"],
            ["Cremia", "CO"],
            ["Oria", "CO"],
            ["Sala Comacina", "CO"],
            ["Mezzegra", "CO"],
            ["San Bartolomeo Val Cavargna", "CO"],
            ["Azzano", "CO"],
            ["Codogna", "CO"],
            ["Val Rezzo", "CO"],
            ["Trezzone", "CO"],
            ["Gera Lario", "CO"],
            ["Colonno", "CO"],
            ["Sorico", "CO"],
            ["Argegno", "CO"],
            ["Moltrasio", "CO"],
            ["Piano Porlezza", "CO"],
            ["Valsolda", "CO"],
            ["Cavargna", "CO"],
            ["Santa Maria Rezzonico", "CO"],
            ["San Pietro Sovera", "CO"],
            ["Sant'Abbondio", "CO"],
            ["Corrido", "CO"],
            ["Pianello Del Lario", "CO"],
            ["San Siro", "CO"],
            ["Rezzonico", "CO"],
            ["Consiglio Di Rumo", "CO"],
            ["Grandola Ed Uniti", "CO"],
        ],
        "22011": [["Cadenabbia", "CO"], ["Griante", "CO"]],
        "22012": [["Cernobbio", "CO"]],
        "22013": [["Vercana", "CO"], ["Domaso", "CO"]],
        "22014": [["Dongo", "CO"]],
        "22015": [["Gravedona", "CO"]],
        "22016": [["Lenno", "CO"], ["Tremezzina", "CO"]],
        "22017": [["Menaggio", "CO"]],
        "22018": [["Porlezza", "CO"], ["Cima", "CO"]],
        "22019": [["Tremezzo", "CO"]],
        "22020": [
            ["Nesso", "CO"],
            ["San Fermo Della Battaglia", "CO"],
            ["Pare'", "CO"],
            ["Schignano", "CO"],
            ["Cerano D'Intelvi", "CO"],
            ["Camnago Faloppio", "CO"],
            ["Veleso", "CO"],
            ["Pognana Lario", "CO"],
            ["Lemna", "CO"],
            ["Ramponio Verna", "CO"],
            ["Boscone", "CO"],
            ["Pigra", "CO"],
            ["Zelbio", "CO"],
            ["Gaggino", "CO"],
            ["Blevio", "CO"],
            ["Pellio Intelvi", "CO"],
            ["Faggeto Lario", "CO"],
            ["Laino", "CO"],
            ["Pellio", "CO"],
            ["Dizzasco", "CO"],
            ["Torno", "CO"],
            ["Camnago", "CO"],
            ["Faloppio", "CO"],
            ["Occagno", "CO"],
            ["Bizzarone", "CO"],
            ["Ponna", "CO"],
            ["Drezzo", "CO"],
        ],
        "22021": [["Bellagio", "CO"], ["San Giovanni Di Bellagio", "CO"]],
        "22022": [["Casasco D'Intelvi", "CO"]],
        "22023": [["Castiglione D'Intelvi", "CO"]],
        "22024": [["Lanzo D'Intelvi", "CO"], ["Scaria", "CO"]],
        "22025": [["Lezzeno", "CO"]],
        "22026": [["Maslianico", "CO"]],
        "22027": [["Ronago", "CO"]],
        "22028": [["Blessagno", "CO"], ["San Fedele Intelvi", "CO"]],
        "22029": [["Uggiate Trevano", "CO"]],
        "22030": [
            ["Lipomo", "CO"],
            ["Castelmarte", "CO"],
            ["Corneno", "CO"],
            ["Orsenigo", "CO"],
            ["Penzano", "CO"],
            ["Lasnigo", "CO"],
            ["Longone Al Segrino", "CO"],
            ["Galliano", "CO"],
            ["Montorfano", "CO"],
            ["Rezzago", "CO"],
            ["Civenna", "CO"],
            ["Caglio", "CO"],
            ["Magreglio", "CO"],
            ["Caslino D'Erba", "CO"],
            ["Barni", "CO"],
            ["Eupilio", "CO"],
            ["Pusiano", "CO"],
            ["Sormano", "CO"],
            ["Proserpio", "CO"],
        ],
        "22031": [["Albavilla", "CO"]],
        "22032": [["Albese Con Cassano", "CO"]],
        "22033": [["Asso", "CO"]],
        "22034": [["Brunate", "CO"]],
        "22035": [["Canzo", "CO"]],
        "22036": [["Erba", "CO"], ["Arcellasco", "CO"]],
        "22037": [["Ponte Lambro", "CO"]],
        "22038": [["Tavernerio", "CO"], ["Solzago", "CO"]],
        "22039": [["Valbrona", "CO"], ["Osigo", "CO"]],
        "22040": [
            ["Brenna", "CO"],
            ["Alzate Brianza", "CO"],
            ["Lurago D'Erba", "CO"],
            ["Alserio", "CO"],
            ["Nobile", "CO"],
            ["Fabbrica Durini", "CO"],
            ["Anzano Del Parco", "CO"],
            ["Monguzzo", "CO"],
        ],
        "22041": [["Colverde", "CO"], ["Gironico Al Piano", "CO"], ["Gironico", "CO"]],
        "22042": [["Cavallasca", "CO"]],
        "22043": [["Cagno", "CO"], ["Solbiate", "CO"]],
        "22044": [["Inverigo", "CO"], ["Cremnago", "CO"], ["Romano' Brianza", "CO"]],
        "22045": [["Lambrugo", "CO"]],
        "22046": [["Merone", "CO"]],
        "22060": [
            ["Cabiate", "CO"],
            ["Figino Serenza", "CO"],
            ["Cucciago", "CO"],
            ["Campione D'Italia", "CO"],
            ["Novedrate", "CO"],
            ["Montesolaro", "CO"],
            ["Arosio", "CO"],
            ["Carimate", "CO"],
            ["Carugo", "CO"],
        ],
        "22063": [
            ["Asnago Di Cantu'", "CO"],
            ["Cantu' Asnago", "CO"],
            ["Vighizzolo Di Cantu'", "CO"],
            ["Cascina Amata", "CO"],
            ["Cantu'", "CO"],
            ["Mirabello Di Cantu'", "CO"],
        ],
        "22066": [["Mariano Comense", "CO"], ["Perticato", "CO"]],
        "22069": [["Rovellasca", "CO"]],
        "22070": [
            ["Luisago", "CO"],
            ["Bregnano", "CO"],
            ["Puginate", "CO"],
            ["Lucino", "CO"],
            ["Capiago Intimiano", "CO"],
            ["Lurago Marinone", "CO"],
            ["Guanzate", "CO"],
            ["Portichetto", "CO"],
            ["Casanova Lanza", "CO"],
            ["Montano Lucino", "CO"],
            ["Intimiano", "CO"],
            ["Rodero", "CO"],
            ["Capiago", "CO"],
            ["Minoprio", "CO"],
            ["San Giorgio", "CO"],
            ["Casnate", "CO"],
            ["Bulgarograsso", "CO"],
            ["Appiano Gentile", "CO"],
            ["Grandate", "CO"],
            ["Beregazzo Con Figliaro", "CO"],
            ["Vertemate Con Minoprio", "CO"],
            ["Binago", "CO"],
            ["Limido Comasco", "CO"],
            ["Senna Comasco", "CO"],
            ["Carbonate", "CO"],
            ["Albiolo", "CO"],
            ["San Michele", "CO"],
            ["Cascina Restelli", "CO"],
            ["Casnate Con Bernate", "CO"],
            ["Beregazzo", "CO"],
            ["Concagno", "CO"],
            ["Montano", "CO"],
            ["Cirimido", "CO"],
            ["Valmorea", "CO"],
            ["Cassina Rizzardi", "CO"],
            ["Locate Varesino", "CO"],
            ["Rovello Porro", "CO"],
            ["Fenegro'", "CO"],
            ["Castelnuovo Bozzente", "CO"],
            ["Veniano", "CO"],
            ["Figliaro", "CO"],
            ["Oltrona Di San Mamette", "CO"],
        ],
        "22071": [["Bulgorello", "CO"], ["Caslino Al Piano", "CO"], ["Cadorago", "CO"]],
        "22072": [["Cermenate", "CO"]],
        "22073": [["Andrate", "CO"], ["Fino Mornasco", "CO"], ["Molinetto", "CO"]],
        "22074": [["Lomazzo", "CO"], ["Manera", "CO"]],
        "22075": [["Lurate Caccivio", "CO"]],
        "22076": [["Mozzate", "CO"]],
        "22077": [["Olgiate Comasco", "CO"]],
        "22078": [["Turate", "CO"]],
        "22079": [["Villa Guardia", "CO"]],
        "22100": [
            ["Monte Olimpino", "CO"],
            ["Civiglio", "CO"],
            ["Breccia", "CO"],
            ["Lora", "CO"],
            ["Rebbio", "CO"],
            ["Camerlata", "CO"],
            ["Tavernola", "CO"],
            ["Camnago Volta", "CO"],
            ["Albate", "CO"],
            ["Como", "CO"],
            ["Ponte Chiasso", "CO"],
        ],
        "26010": [
            ["Ripalta Nuova", "CR"],
            ["Casale Cremasco", "CR"],
            ["Capralba", "CR"],
            ["Vaiano Cremasco", "CR"],
            ["Olmeneta", "CR"],
            ["Robecco D'Oglio", "CR"],
            ["Ripalta Guerina", "CR"],
            ["Chieve", "CR"],
            ["Bagnolo Cremasco", "CR"],
            ["Montodine", "CR"],
            ["Bolzone", "CR"],
            ["Salvirola", "CR"],
            ["Zappello", "CR"],
            ["Cremosano", "CR"],
            ["Credera", "CR"],
            ["Fiesco", "CR"],
            ["Dovera", "CR"],
            ["Moscazzano", "CR"],
            ["Sergnano", "CR"],
            ["Camisano", "CR"],
            ["Casaletto Vaprio", "CR"],
            ["Pozzaglio Ed Uniti", "CR"],
            ["Credera Rubbiano", "CR"],
            ["Casale Cremasco Vidolasco", "CR"],
            ["Ripalta Cremasca", "CR"],
            ["Casaletto Ceredano", "CR"],
            ["Campagnola Cremasca", "CR"],
            ["Casalsigone", "CR"],
            ["Ricengo", "CR"],
            ["Rovereto", "CR"],
            ["Castelvisconti", "CR"],
            ["Pianengo", "CR"],
            ["Offanengo", "CR"],
            ["Rubbiano", "CR"],
            ["Pozzaglio", "CR"],
            ["Ripalta Arpina", "CR"],
            ["Corte De' Frati", "CR"],
            ["Capergnanica", "CR"],
            ["Izano", "CR"],
            ["Monte Cremasco", "CR"],
            ["Azzanello", "CR"],
            ["Castel Gabbiano", "CR"],
        ],
        "26011": [["Casalbuttano", "CR"], ["Casalbuttano Ed Uniti", "CR"]],
        "26012": [["Castelleone", "CR"]],
        "26013": [
            ["Crema", "CR"],
            ["Santo Stefano In Vairano", "CR"],
            ["Ombriano", "CR"],
            ["Santa Maria Della Croce", "CR"],
            ["Sabbioni", "CR"],
        ],
        "26014": [["Casaletto Di Sopra", "CR"], ["Romanengo", "CR"]],
        "26015": [["Soresina", "CR"]],
        "26016": [["Spino D'Adda", "CR"]],
        "26017": [["Torlino Vimercati", "CR"], ["Quintano", "CR"], ["Trescore Cremasco", "CR"], ["Pieranica", "CR"]],
        "26018": [["Trigolo", "CR"]],
        "26019": [["Vailate", "CR"]],
        "26020": [
            ["Cappella Cantone", "CR"],
            ["Corte De' Cortesi Con Cignone", "CR"],
            ["Madignano", "CR"],
            ["Crotta D'Adda", "CR"],
            ["Gombito", "CR"],
            ["Cignone", "CR"],
            ["Corte De' Cortesi", "CR"],
            ["Formigara", "CR"],
            ["Spinadesco", "CR"],
            ["Bordolano", "CR"],
            ["Casalmorano", "CR"],
            ["Fengo", "CR"],
            ["Agnadello", "CR"],
            ["Ticengo", "CR"],
            ["Acquanegra Cremonese", "CR"],
            ["Cascine Gandini", "CR"],
            ["Scannabue", "CR"],
            ["Genivolta", "CR"],
            ["Palazzo Pignano", "CR"],
            ["Cumignano Sul Naviglio", "CR"],
            ["San Bassano", "CR"],
        ],
        "26021": [["Barzaniga", "CR"], ["Annicco", "CR"]],
        "26022": [["San Martino In Beliseto", "CR"], ["Castelverde", "CR"], ["Costa Sant'Abramo", "CR"]],
        "26023": [["Farfengo", "CR"], ["Grumello Cremonese Ed Uniti", "CR"], ["Grumello Cremonese", "CR"]],
        "26024": [["Paderno Ponchielli", "CR"]],
        "26025": [["Pandino", "CR"], ["Nosadello", "CR"]],
        "26026": [["Pizzighettone", "CR"], ["Roggione", "CR"], ["Regona", "CR"]],
        "26027": [["Rivolta D'Adda", "CR"]],
        "26028": [["Casanova Del Morbasco", "CR"], ["Sesto Cremonese", "CR"], ["Sesto Ed Uniti", "CR"]],
        "26029": [["Gallignano", "CR"], ["Soncino", "CR"]],
        "26030": [
            ["Spineda", "CR"],
            ["Gabbioneta", "CR"],
            ["Ca' De' Mari", "CR"],
            ["Pessina Cremonese", "CR"],
            ["Volongo", "CR"],
            ["Malagnino", "CR"],
            ["Cicognolo", "CR"],
            ["Solarolo Rainerio", "CR"],
            ["Calvatone", "CR"],
            ["Voltido", "CR"],
            ["Tornata", "CR"],
            ["Gabbioneta Binanuova", "CR"],
            ["Binanuova", "CR"],
            ["Gadesco Pieve Delmona", "CR"],
            ["Ardole San Marino", "CR"],
            ["Casteldidone", "CR"],
            ["Cappella De' Picenardi", "CR"],
        ],
        "26031": [["Isola Dovarese", "CR"]],
        "26032": [["Ostiano", "CR"]],
        "26033": [["Pieve Terzagni", "CR"], ["Pescarolo Ed Uniti", "CR"], ["Pescarolo", "CR"]],
        "26034": [["Piadena", "CR"], ["Drizzona", "CR"]],
        "26035": [["Pieve San Giacomo", "CR"]],
        "26036": [["Rivarolo Del Re Ed Uniti", "CR"], ["Rivarolo Del Re", "CR"]],
        "26037": [["San Giovanni In Croce", "CR"]],
        "26038": [["Torre De' Picenardi", "CR"], ["Ca' D'Andrea", "CR"], ["San Lorenzo De' Picenardi", "CR"]],
        "26039": [["Ca' De' Stefani", "CR"], ["Vescovato", "CR"]],
        "26040": [
            ["Gussola", "CR"],
            ["Derovere", "CR"],
            ["Gerre De' Caprioli", "CR"],
            ["Bonemerse", "CR"],
            ["Cella Dati", "CR"],
            ["Pieve D'Olmi", "CR"],
            ["San Martino Del Lago", "CR"],
            ["Castelponzone", "CR"],
            ["Scandolara Ravara", "CR"],
            ["Torricella Del Pizzo", "CR"],
            ["Martignana Di Po", "CR"],
        ],
        "26041": [
            ["Casalbellotto", "CR"],
            ["Casalmaggiore", "CR"],
            ["Vicomoscano", "CR"],
            ["Roncadello", "CR"],
            ["Quattrocase", "CR"],
            ["Vicoboneghisio", "CR"],
            ["Agoiolo", "CR"],
            ["Vicobellignano", "CR"],
        ],
        "26042": [["Cingia De' Botti", "CR"]],
        "26043": [["Persichello", "CR"], ["Dosimo", "CR"], ["Persico Dosimo", "CR"]],
        "26044": [["Grontardo", "CR"], ["Levata", "CR"]],
        "26045": [["Motta Baluffi", "CR"]],
        "26046": [["San Daniele Po", "CR"]],
        "26047": [["Scandolara Ripa D'Oglio", "CR"]],
        "26048": [["San Salvatore", "CR"], ["Sospiro", "CR"]],
        "26049": [["Stagno Lombardo", "CR"]],
        "26100": [
            ["Cava Tigozzi", "CR"],
            ["Boschetto", "CR"],
            ["San Felice", "CR"],
            ["Migliaro", "CR"],
            ["Maristella", "CR"],
            ["Cremona", "CR"],
        ],
        "23801": [["Calolziocorte", "LC"], ["Rossino", "LC"]],
        "23802": [["Carenno", "LC"]],
        "23804": [["Monte Marenzo", "LC"]],
        "23805": [["Erve", "LC"]],
        "23806": [["Torre De' Busi", "LC"], ["San Gottardo", "LC"], ["Valcava", "LC"], ["Favirano", "LC"]],
        "23807": [["Merate", "LC"], ["Cassina Fra Martino", "LC"]],
        "23808": [["Vercurago", "LC"]],
        "23811": [["Ballabio", "LC"], ["Morterone", "LC"]],
        "23813": [["Cortenova", "LC"], ["Bindo", "LC"]],
        "23814": [["Cremeno", "LC"], ["Maggio", "LC"]],
        "23815": [["Introbio", "LC"]],
        "23816": [["Barzio", "LC"]],
        "23817": [["Moggio", "LC"], ["Cassina Valsassina", "LC"]],
        "23818": [["Pasturo", "LC"]],
        "23819": [["Primaluna", "LC"], ["Cortabbio", "LC"]],
        "23821": [["Crebbio", "LC"], ["Abbadia Lariana", "LC"]],
        "23822": [["Bellano", "LC"], ["Vestreno", "LC"]],
        "23823": [["Colico Piano", "LC"], ["Colico", "LC"]],
        "23824": [["Dervio", "LC"], ["Dorio", "LC"]],
        "23825": [["Esino Lario", "LC"]],
        "23826": [["Mandello Del Lario", "LC"]],
        "23827": [["Lierna", "LC"]],
        "23828": [["Perledo", "LC"]],
        "23829": [["Fiumelatte", "LC"], ["Varenna", "LC"]],
        "23831": [["Casargo", "LC"]],
        "23832": [["Margno", "LC"], ["Crandola Valsassina", "LC"]],
        "23833": [["Pagnona", "LC"]],
        "23834": [["Premana", "LC"]],
        "23835": [["Sueglio", "LC"], ["Introzzo", "LC"]],
        "23836": [["Tremenico", "LC"]],
        "23837": [["Taceno", "LC"], ["Parlasco", "LC"]],
        "23838": [["Vendrogno", "LC"]],
        "23841": [["Annone Di Brianza", "LC"]],
        "23842": [["Bosisio Parini", "LC"]],
        "23843": [["Dolzago", "LC"]],
        "23844": [["Sirone", "LC"]],
        "23845": [["Costa Masnaga", "LC"], ["Camisasca", "LC"]],
        "23846": [["Brongio", "LC"], ["Garbagnate Monastero", "LC"]],
        "23847": [["Luzzana", "LC"], ["Molteno", "LC"]],
        "23848": [["Oggiono", "LC"], ["Ello", "LC"]],
        "23849": [["Rogeno", "LC"], ["Casletto", "LC"]],
        "23851": [["Galbiate", "LC"], ["Vergano Villa", "LC"], ["Sala Al Barro", "LC"]],
        "23852": [["Garlate", "LC"]],
        "23854": [["Olginate", "LC"]],
        "23855": [["Pescate", "LC"]],
        "23857": [["Valgreghentino", "LC"]],
        "23861": [["Cesana Brianza", "LC"]],
        "23862": [["Civate", "LC"]],
        "23864": [["Malgrate", "LC"]],
        "23865": [["Limonta", "LC"], ["Oliveto Lario", "LC"], ["Onno", "LC"]],
        "23867": [["Suello", "LC"]],
        "23868": [["Caserta", "LC"], ["Valmadrera", "LC"]],
        "23870": [["Cernusco Lombardone", "LC"]],
        "23871": [["Lomagna", "LC"]],
        "23873": [["Missaglia", "LC"], ["Maresso", "LC"]],
        "23874": [["Montevecchia", "LC"], ["Quattro Strade", "LC"]],
        "23875": [["Osnago", "LC"]],
        "23876": [["Monticello Brianza", "LC"]],
        "23877": [["Paderno D'Adda", "LC"]],
        "23878": [["Verderio Superiore", "LC"]],
        "23879": [["Verderio Inferiore", "LC"], ["Verderio", "LC"]],
        "23880": [
            ["Campofiorenzo", "LC"],
            ["Casatenovo", "LC"],
            ["Galgiana", "LC"],
            ["Rimoldo", "LC"],
            ["Rogoredo", "LC"],
            ["Valaperta", "LC"],
            ["California", "LC"],
        ],
        "23881": [["Airuno", "LC"]],
        "23883": [["Beverate", "LC"], ["Brivio", "LC"]],
        "23884": [["Caraverio", "LC"], ["Cologna", "LC"], ["Castello Di Brianza", "LC"]],
        "23885": [["Calco", "LC"], ["Arlate", "LC"]],
        "23886": [["Colle Brianza", "LC"], ["Nava", "LC"]],
        "23887": [["Monticello", "LC"], ["Canova", "LC"], ["Olgiate Molgora", "LC"]],
        "23888": [["La Valletta Brianza", "LC"], ["Rovagnate", "LC"], ["Perego", "LC"]],
        "23889": [["Santa Maria Hoe'", "LC"]],
        "23890": [["Barzago", "LC"]],
        "23891": [["Barzano'", "LC"]],
        "23892": [["Bulciago", "LC"]],
        "23893": [["Cassago Brianza", "LC"]],
        "23894": [["Cremella", "LC"]],
        "23895": [["Cibrone", "LC"], ["Nibionno", "LC"], ["Tabiago", "LC"]],
        "23896": [["Sirtori", "LC"], ["Bevera Di Sirtori", "LC"]],
        "23897": [["Vigano'", "LC"]],
        "23898": [["Imbersago", "LC"]],
        "23899": [["Robbiate", "LC"]],
        "23900": [["Lecco", "LC"]],
        "26811": [["Boffalora D'Adda", "LO"]],
        "26812": [["Borghetto Lodigiano", "LO"], ["Casoni", "LO"]],
        "26813": [["Graffignana", "LO"]],
        "26814": [["Livraga", "LO"]],
        "26815": [["Motta Vigana", "LO"], ["Massalengo", "LO"]],
        "26816": [["Ossago Lodigiano", "LO"]],
        "26817": [["San Martino In Strada", "LO"]],
        "26818": [["Villanova Del Sillaro", "LO"], ["Bargano", "LO"]],
        "26821": [["Bertonico", "LO"]],
        "26822": [["Brembio", "LO"]],
        "26823": [["Castiglione D'Adda", "LO"], ["Camairago", "LO"]],
        "26824": [["Cavenago D'Adda", "LO"]],
        "26825": [["Basiasco", "LO"], ["Mairago", "LO"]],
        "26826": [["Secugnago", "LO"]],
        "26827": [["Terranova Dei Passerini", "LO"]],
        "26828": [["Melegnanello", "LO"], ["Turano Lodigiano", "LO"]],
        "26831": [["Cologno", "LO"], ["Casalmaiocco", "LO"]],
        "26832": [["Cervignano D'Adda", "LO"], ["Galgagnano", "LO"]],
        "26833": [["Comazzo", "LO"], ["Merlino", "LO"]],
        "26834": [["Cadilana", "LO"], ["Corte Palasio", "LO"], ["Abbadia Cerreto", "LO"], ["Terraverde", "LO"]],
        "26835": [["Crespiatica", "LO"]],
        "26836": [["Montanaso Lombardo", "LO"]],
        "26837": [["Mulazzano", "LO"], ["Cassino D'Alberi", "LO"], ["Quartiano", "LO"]],
        "26838": [["Tavazzano Con Villavesco", "LO"], ["Villavesco", "LO"], ["Tavazzano", "LO"]],
        "26839": [["Zelo Buon Persico", "LO"]],
        "26841": [["Casalpusterlengo", "LO"], ["Zorlesco", "LO"]],
        "26842": [["Cornovecchio", "LO"], ["Caselle Landi", "LO"]],
        "26843": [["Maccastorna", "LO"], ["Castelnuovo Bocca D'Adda", "LO"], ["Meleti", "LO"]],
        "26844": [["Cavacurta", "LO"]],
        "26845": [["Codogno", "LO"]],
        "26846": [["Corno Giovine", "LO"]],
        "26847": [["Maleo", "LO"]],
        "26848": [["San Fiorano", "LO"]],
        "26849": [["Santo Stefano Lodigiano", "LO"]],
        "26851": [["Borgo San Giovanni", "LO"]],
        "26852": [["Casaletto Lodigiano", "LO"], ["Mairano", "LO"]],
        "26853": [["Caselle Lurani", "LO"]],
        "26854": [["Cornegliano Laudense", "LO"], ["Muzza Sant'Angelo", "LO"], ["Pieve Fissiraga", "LO"]],
        "26855": [["Lodi Vecchio", "LO"]],
        "26856": [["Senna Lodigiana", "LO"], ["Mirabello", "LO"]],
        "26857": [["Salerano Sul Lambro", "LO"]],
        "26858": [["Sordio", "LO"]],
        "26859": [["Valera Fratta", "LO"]],
        "26861": [["Fombio", "LO"], ["Retegno", "LO"]],
        "26862": [["Guardamiglio", "LO"]],
        "26863": [["Orio Litta", "LO"]],
        "26864": [["Ospedaletto Lodigiano", "LO"]],
        "26865": [["San Rocco Al Porto", "LO"]],
        "26866": [["Sant'Angelo Lodigiano", "LO"], ["Marudo", "LO"], ["Castiraga Vidardo", "LO"], ["Vidardo", "LO"]],
        "26867": [["Somaglia", "LO"], ["San Martino Pizzolano", "LO"]],
        "26900": [["San Grato", "LO"], ["Lodi", "LO"]],
        "20811": [["Binzago", "MB"], ["Villaggio Snia", "MB"], ["Cassina Savina", "MB"], ["Cesano Maderno", "MB"]],
        "20812": [["Villaggio Dei Giovi", "MB"], ["Villaggio Del Sole", "MB"], ["Mombello", "MB"], ["Limbiate", "MB"]],
        "20813": [["Masciago", "MB"], ["Bovisio-Masciago", "MB"], ["Bovisio", "MB"]],
        "20814": [["Valera", "MB"], ["Varedo", "MB"]],
        "20815": [["Cogliate", "MB"]],
        "20816": [["Ceriano Laghetto", "MB"], ["Dal Pozzo", "MB"]],
        "20821": [["Meda", "MB"]],
        "20822": [["Baruccana", "MB"], ["Seveso", "MB"]],
        "20823": [["Lentate Sul Seveso", "MB"], ["Cimnago", "MB"], ["Camnago", "MB"]],
        "20824": [["Lazzate", "MB"]],
        "20825": [["Barlassina", "MB"]],
        "20826": [["Misinto", "MB"], ["Cascina Nuova", "MB"]],
        "20831": [["Seregno", "MB"]],
        "20832": [["Desio", "MB"]],
        "20833": [["Robbiano Di Giussano", "MB"], ["Paina", "MB"], ["Giussano", "MB"]],
        "20834": [["Nova Milanese", "MB"]],
        "20835": [["Muggio'", "MB"], ["Taccona", "MB"]],
        "20836": [["Capriano", "MB"], ["Briosco", "MB"], ["Fornaci", "MB"]],
        "20837": [["Veduggio Con Colzano", "MB"]],
        "20838": [["Renate", "MB"]],
        "20841": [["Carate Brianza", "MB"], ["Agliate", "MB"]],
        "20842": [["Villa Raverio", "MB"], ["Besana In Brianza", "MB"], ["Zoccorino", "MB"]],
        "20843": [["Verano Brianza", "MB"]],
        "20844": [["Tregasio", "MB"], ["Triuggio", "MB"], ["Canonica", "MB"]],
        "20845": [["Sovico", "MB"]],
        "20846": [["Macherio", "MB"]],
        "20847": [["Albiate", "MB"]],
        "20851": [["Santa Margherita", "MB"], ["Lissone", "MB"]],
        "20852": [["Villasanta", "MB"]],
        "20853": [["Biassono", "MB"]],
        "20854": [["Vedano Al Lambro", "MB"]],
        "20855": [["Peregallo", "MB"], ["Lesmo", "MB"]],
        "20856": [["Correzzana", "MB"]],
        "20857": [["Camparada", "MB"]],
        "20861": [["Brugherio", "MB"], ["San Damiano", "MB"]],
        "20862": [["Arcore", "MB"]],
        "20863": [["Concorezzo", "MB"]],
        "20864": [["Agrate Brianza", "MB"], ["Omate", "MB"]],
        "20865": [["Velate", "MB"], ["Usmate Velate", "MB"]],
        "20866": [["Carnate", "MB"]],
        "20867": [["Caponago", "MB"]],
        "20871": [["Velasca", "MB"], ["Vimercate", "MB"], ["Oreno", "MB"]],
        "20872": [["Porto D'Adda", "MB"], ["Colnago", "MB"], ["Cornate D'Adda", "MB"]],
        "20873": [["Cavenago Di Brianza", "MB"]],
        "20874": [["Busnago", "MB"]],
        "20875": [["Burago Di Molgora", "MB"]],
        "20876": [["Ornago", "MB"]],
        "20877": [["Roncello", "MB"]],
        "20881": [["Villanova", "MB"], ["Bernareggio", "MB"]],
        "20882": [["Bellusco", "MB"]],
        "20883": [["Mezzago", "MB"]],
        "20884": [["Sulbiate", "MB"]],
        "20885": [["Ronco Briantino", "MB"]],
        "20886": [["Aicurzio", "MB"]],
        "20900": [["San Fruttuoso", "MB"], ["Monza", "MB"]],
        "20001": [["Inveruno", "MI"]],
        "20002": [["Ossona", "MI"]],
        "20003": [["Casorezzo", "MI"]],
        "20004": [["Arluno", "MI"]],
        "20005": [["Pogliano Milanese", "MI"]],
        "20006": [["Pregnana Milanese", "MI"]],
        "20007": [["Cornaredo", "MI"]],
        "20008": [["Bareggio", "MI"]],
        "20009": [["Vittuone", "MI"]],
        "20010": [
            ["Mesero", "MI"],
            ["Bernate Ticino", "MI"],
            ["Rogorotto", "MI"],
            ["Santo Stefano Ticino", "MI"],
            ["Boffalora Sopra Ticino", "MI"],
            ["Casate", "MI"],
            ["Mantegazza", "MI"],
            ["Marcallo Con Casone", "MI"],
            ["Furato", "MI"],
            ["Buscate", "MI"],
            ["San Pietro All'Olmo", "MI"],
            ["Casone", "MI"],
        ],
        "20011": [["Corbetta", "MI"], ["Battuello", "MI"], ["Cerello", "MI"]],
        "20012": [["Cuggiono", "MI"]],
        "20013": [["Ponte Nuovo", "MI"], ["Magenta", "MI"]],
        "20014": [["Nerviano", "MI"], ["Sant'Ilario Milanese", "MI"]],
        "20015": [["Parabiago", "MI"], ["Villastanza", "MI"]],
        "20016": [["Pero", "MI"], ["Cerchiate", "MI"]],
        "20017": [
            ["Lucernate", "MI"],
            ["Mazzo Milanese", "MI"],
            ["Terrazzano", "MI"],
            ["Passirana", "MI"],
            ["Rho", "MI"],
        ],
        "20018": [["Sedriano", "MI"]],
        "20019": [["Vighignolo", "MI"], ["Settimo Milanese", "MI"]],
        "20020": [
            ["Cascina Nuova Di Misinto", "MI"],
            ["Bienate", "MI"],
            ["Villaggio Brollo", "MI"],
            ["Vanzaghello", "MI"],
            ["Magnago", "MI"],
            ["Arconate", "MI"],
            ["Nosate", "MI"],
            ["Barbaiana", "MI"],
            ["Robecchetto Con Induno", "MI"],
        ],
        "20021": [["Baranzate", "MI"], ["Cassina Nuova", "MI"], ["Bollate", "MI"]],
        "20022": [["Castano Primo", "MI"]],
        "20023": [["Cantalupo", "MI"], ["Cerro Maggiore", "MI"]],
        "20024": [["Villaggio Garbagnate", "MI"], ["Garbagnate Milanese", "MI"]],
        "20025": [["Legnano", "MI"]],
        "20026": [["Novate Milanese", "MI"]],
        "20027": [["Rescalda", "MI"], ["Rescaldina", "MI"]],
        "20028": [["San Vittore Olona", "MI"]],
        "20029": [["Turbigo", "MI"]],
        "20030": [["Senago", "MI"]],
        "20031": [["Cesate", "MI"]],
        "20032": [["Cormano", "MI"], ["Brusuglio", "MI"], ["Ospitaletto", "MI"]],
        "20033": [["Solaro", "MI"]],
        "20034": [["San Giorgio Su Legnano", "MI"]],
        "20035": [["Villa Cortese", "MI"]],
        "20036": [["Dairago", "MI"]],
        "20037": [["Paderno Dugnano", "MI"], ["Palazzolo Milanese", "MI"]],
        "20038": [["Busto Garolfo", "MI"]],
        "20039": [["Canegrate", "MI"]],
        "20040": [["Velate Milanese", "MI"], ["Torrazza Dei Mandelli", "MI"], ["Cambiago", "MI"]],
        "20041": [["Bussero", "MI"]],
        "20042": [["Pessano Con Bornago", "MI"]],
        "20043": [["Vanzago", "MI"]],
        "20044": [["Arese", "MI"]],
        "20045": [["Lainate", "MI"]],
        "20046": [["Cisliano", "MI"]],
        "20047": [["Cusago", "MI"]],
        "20048": [["Pantigliate", "MI"]],
        "20049": [["Settala", "MI"]],
        "20050": [["Liscate", "MI"]],
        "20051": [["Cassina De' Pecchi", "MI"]],
        "20052": [["Vignate", "MI"]],
        "20053": [["Rodano", "MI"]],
        "20054": [["Segrate", "MI"]],
        "20055": [["Vimodrone", "MI"]],
        "20056": [["Concesa", "MI"], ["Trezzo Sull'Adda", "MI"], ["Grezzago", "MI"]],
        "20057": [["Assago", "MI"]],
        "20058": [["Zibido San Giacomo", "MI"]],
        "20059": [["Casarile", "MI"]],
        "20060": [
            ["Trecella", "MI"],
            ["Triginto", "MI"],
            ["Trezzano Rosa", "MI"],
            ["Bellinzago Lombardo", "MI"],
            ["Villa Fornaci", "MI"],
            ["Bustighera", "MI"],
            ["Gessate", "MI"],
            ["Bettola Di Pozzo D'Adda", "MI"],
            ["Truccazzano", "MI"],
            ["Pozzo D'Adda", "MI"],
            ["Pozzuolo Martesana", "MI"],
            ["Masate", "MI"],
            ["Mombretto", "MI"],
            ["Sant'Agata Martesana", "MI"],
            ["Basiano", "MI"],
            ["Albignano", "MI"],
            ["Bornago", "MI"],
            ["Albignano D'Adda", "MI"],
            ["Vigliano", "MI"],
            ["Balbiano", "MI"],
        ],
        "20061": [["Carugate", "MI"]],
        "20062": [["Cassano D'Adda", "MI"], ["Cascine San Pietro", "MI"], ["Groppello D'Adda", "MI"]],
        "20063": [["Cernusco Sul Naviglio", "MI"]],
        "20064": [["Gorgonzola", "MI"]],
        "20065": [["Inzago", "MI"]],
        "20066": [["Melzo", "MI"]],
        "20067": [["Paullo", "MI"], ["Tribiano", "MI"]],
        "20068": [
            ["Mezzate", "MI"],
            ["Peschiera Borromeo", "MI"],
            ["Bettola", "MI"],
            ["Linate Paese", "MI"],
            ["Zeloforomagno", "MI"],
            ["Bellaria", "MI"],
            ["San Bovio", "MI"],
            ["Linate", "MI"],
        ],
        "20069": [["Vaprio D'Adda", "MI"]],
        "20070": [
            ["Dresano", "MI"],
            ["Cerro Al Lambro", "MI"],
            ["San Zenone Al Lambro", "MI"],
            ["Sarmazzano", "MI"],
            ["Villa Bissone", "MI"],
            ["Vizzolo Predabissi", "MI"],
            ["Riozzo", "MI"],
        ],
        "20071": [["Zelo Surrigone", "MI"], ["Vermezzo", "MI"]],
        "20072": [["Pieve Emanuele", "MI"]],
        "20073": [["Opera", "MI"]],
        "20074": [["Carpiano", "MI"]],
        "20075": [["Colturano", "MI"]],
        "20076": [["Mediglia", "MI"]],
        "20077": [["Melegnano", "MI"]],
        "20078": [["San Colombano Al Lambro", "MI"]],
        "20079": [["Basiglio", "MI"]],
        "20080": [
            ["Calvignasco", "MI"],
            ["San Pietro Cusico", "MI"],
            ["Bubbiano", "MI"],
            ["Moirago", "MI"],
            ["Besate", "MI"],
            ["Moncucco", "MI"],
            ["Ozzero", "MI"],
            ["Pasturago", "MI"],
            ["Albairate", "MI"],
            ["Badile", "MI"],
            ["Vernate", "MI"],
        ],
        "20081": [["Cassinetta Di Lugagnano", "MI"], ["Abbiategrasso", "MI"], ["Morimondo", "MI"]],
        "20082": [["Noviglio", "MI"], ["Binasco", "MI"], ["Santa Corinna", "MI"]],
        "20083": [["San Vito", "MI"], ["Gaggiano", "MI"], ["Vigano", "MI"]],
        "20084": [["Lacchiarella", "MI"]],
        "20085": [["Locate Di Triulzi", "MI"]],
        "20086": [["Motta Visconti", "MI"]],
        "20087": [["Castellazzo De' Barzi", "MI"], ["Robecco Sul Naviglio", "MI"], ["Casterno", "MI"]],
        "20088": [["Rosate", "MI"], ["Gudo Visconti", "MI"]],
        "20089": [["Rozzano", "MI"], ["Quinto De Stampi", "MI"]],
        "20090": [
            ["Sporting Mirasole", "MI"],
            ["Trezzano Sul Naviglio", "MI"],
            ["Cesano Boscone", "MI"],
            ["Noverasco", "MI"],
            ["San Felice", "MI"],
            ["Lucino", "MI"],
            ["Caleppio", "MI"],
            ["Romano Banco", "MI"],
            ["Zingone", "MI"],
            ["Zingone Di Trezzano Sul Naviglio", "MI"],
            ["Premenugo", "MI"],
            ["Novegro", "MI"],
            ["Tregarezzo", "MI"],
            ["Monzoro", "MI"],
            ["Fizzonasco", "MI"],
            ["Linate Aeroporto", "MI"],
            ["Millepini", "MI"],
            ["Buccinasco", "MI"],
        ],
        "20091": [["Bresso", "MI"]],
        "20092": [["Cinisello Balsamo", "MI"]],
        "20093": [["San Maurizio Al Lambro", "MI"], ["Cologno Monzese", "MI"]],
        "20094": [["Corsico", "MI"]],
        "20095": [["Milanino", "MI"], ["Cusano Milanino", "MI"]],
        "20096": [["Pioltello", "MI"], ["Limito", "MI"], ["Seggiano", "MI"]],
        "20097": [["San Donato Milanese", "MI"], ["Poasco", "MI"], ["Metanopoli", "MI"], ["Sorigherio", "MI"]],
        "20098": [["Borgo Lombardo", "MI"], ["San Giuliano Milanese", "MI"], ["Sesto Ulteriano", "MI"]],
        "20099": [["Sesto San Giovanni", "MI"]],
        "20121": [["Milano", "MI"]],
        "20122": [["Milano", "MI"]],
        "20123": [["Milano", "MI"]],
        "20124": [["Milano", "MI"]],
        "20125": [["Milano", "MI"], ["Greco", "MI"], ["Gorla", "MI"], ["Precotto", "MI"]],
        "20126": [["Milano", "MI"]],
        "20127": [["Milano", "MI"], ["Crescenzago", "MI"]],
        "20128": [["Milano", "MI"]],
        "20129": [["Milano", "MI"]],
        "20131": [["Milano", "MI"]],
        "20132": [["Milano", "MI"]],
        "20133": [["Milano", "MI"]],
        "20134": [["Lambrate", "MI"], ["Milano", "MI"]],
        "20135": [["Milano", "MI"]],
        "20136": [["Milano", "MI"]],
        "20137": [["Milano", "MI"]],
        "20138": [["Milano", "MI"], ["Rogoredo", "MI"]],
        "20139": [["Milano", "MI"], ["Chiaravalle Milanese", "MI"]],
        "20141": [["Milano", "MI"]],
        "20142": [["Milano", "MI"], ["Gratosoglio", "MI"]],
        "20143": [["Barona", "MI"], ["Milano", "MI"]],
        "20144": [["Milano", "MI"]],
        "20145": [["Milano", "MI"]],
        "20146": [["Milano", "MI"]],
        "20147": [["Milano", "MI"]],
        "20148": [["Milano", "MI"]],
        "20149": [["Milano", "MI"]],
        "20151": [["Milano", "MI"], ["Musocco", "MI"]],
        "20152": [["Baggio", "MI"], ["Milano", "MI"]],
        "20153": [["Milano", "MI"], ["Figino", "MI"], ["Trenno", "MI"]],
        "20154": [["Milano", "MI"]],
        "20155": [["Milano", "MI"]],
        "20156": [["Milano", "MI"]],
        "20157": [["Milano", "MI"], ["Vialba", "MI"], ["Quarto Oggiaro", "MI"]],
        "20158": [["Milano", "MI"]],
        "20159": [["Milano", "MI"]],
        "20161": [["Milano", "MI"], ["Bruzzano", "MI"], ["Affori", "MI"]],
        "20162": [["Niguarda", "MI"], ["Milano", "MI"]],
        "46010": [
            ["San Michele In Bosco", "MN"],
            ["San Martino Dall'Argine", "MN"],
            ["Redondesco", "MN"],
            ["Belforte", "MN"],
            ["Grazie", "MN"],
            ["Curtatone", "MN"],
            ["Villaggio Eremo", "MN"],
            ["Cesole", "MN"],
            ["Gazzuolo", "MN"],
            ["Campitello", "MN"],
            ["Montanara", "MN"],
            ["Commessaggio", "MN"],
            ["Buscoldo", "MN"],
            ["San Silvestro", "MN"],
            ["Casatico", "MN"],
            ["Canicossa", "MN"],
            ["Gabbiana", "MN"],
            ["Ospitaletto", "MN"],
            ["Levata", "MN"],
            ["Marcaria", "MN"],
            ["Mariana Mantovana", "MN"],
        ],
        "46011": [["Acquanegra Sul Chiese", "MN"], ["Mosio", "MN"]],
        "46012": [["Bozzolo", "MN"]],
        "46013": [["Canneto Sull'Oglio", "MN"]],
        "46014": [["Sarginesco", "MN"], ["Ospitaletto Mantovano", "MN"], ["Castellucchio", "MN"]],
        "46017": [["Cividale Mantovano", "MN"], ["Rivarolo Mantovano", "MN"]],
        "46018": [["Breda Cisoni", "MN"], ["Ponteterra", "MN"], ["Villa Pasquali", "MN"], ["Sabbioneta", "MN"]],
        "46019": [
            ["Cogozzo", "MN"],
            ["Cicognara", "MN"],
            ["San Matteo Delle Chiaviche", "MN"],
            ["Buzzoletto", "MN"],
            ["Viadana", "MN"],
            ["Cizzolo", "MN"],
            ["Bellaguarda", "MN"],
        ],
        "46020": [
            ["Polesine", "MN"],
            ["San Giacomo Delle Segnate", "MN"],
            ["San Giovanni Del Dosso", "MN"],
            ["Magnacavallo", "MN"],
            ["Motteggiana", "MN"],
            ["Pieve Di Coriano", "MN"],
            ["Villa Poma", "MN"],
            ["Villa Saviola", "MN"],
            ["Quingentole", "MN"],
            ["Schivenoglia", "MN"],
            ["Pegognaga", "MN"],
        ],
        "46021": [["Borgofranco Sul Po", "MN"], ["Carbonara Di Po", "MN"]],
        "46022": [["Felonica", "MN"]],
        "46023": [["Bondeno Di Gonzaga", "MN"], ["Palidano", "MN"], ["Gonzaga", "MN"]],
        "46024": [["Bondanello", "MN"], ["Moglia", "MN"]],
        "46025": [["Poggio Rusco", "MN"]],
        "46026": [["Quistello", "MN"], ["Nuvolato", "MN"]],
        "46027": [["Portiolo", "MN"], ["San Benedetto Po", "MN"], ["Mirasole", "MN"], ["San Siro", "MN"]],
        "46028": [
            ["Santa Croce", "MN"],
            ["Sermide", "MN"],
            ["Caposotto", "MN"],
            ["Moglia Di Sermide", "MN"],
            ["Malcantone", "MN"],
        ],
        "46029": [
            ["Sailetto", "MN"],
            ["Tabellano", "MN"],
            ["Riva", "MN"],
            ["Brusatasso", "MN"],
            ["Suzzara", "MN"],
            ["San Prospero", "MN"],
        ],
        "46030": [
            ["Gazzo", "MN"],
            ["Dosolo", "MN"],
            ["Correggioverde", "MN"],
            ["Mottella", "MN"],
            ["Stradella", "MN"],
            ["Tripoli", "MN"],
            ["Sacchetta", "MN"],
            ["Villanova De Bellis", "MN"],
            ["Pomponesco", "MN"],
            ["Sustinente", "MN"],
            ["Villastrada", "MN"],
            ["Serravalle A Po", "MN"],
            ["Ca' Vecchia", "MN"],
            ["Libiola", "MN"],
        ],
        "46031": [["San Nicolo' Po", "MN"], ["San Biagio", "MN"], ["Bagnolo San Vito", "MN"]],
        "46032": [["Castelbelforte", "MN"]],
        "46033": [["Castel D'Ario", "MN"]],
        "46034": [
            ["Boccadiganda", "MN"],
            ["San Cataldo", "MN"],
            ["Borgoforte", "MN"],
            ["Cerese", "MN"],
            ["Virgilio", "MN"],
            ["Romanore", "MN"],
            ["Pietole", "MN"],
            ["Borgo Virgilio", "MN"],
            ["Cappelletta", "MN"],
        ],
        "46035": [["Ostiglia", "MN"], ["Correggioli", "MN"]],
        "46036": [["Revere", "MN"]],
        "46037": [
            ["Casale", "MN"],
            ["Barbasso", "MN"],
            ["Roncoferraro", "MN"],
            ["Borgo Castelletto", "MN"],
            ["Pontemerlano", "MN"],
            ["Villa Garibaldi", "MN"],
            ["Governolo", "MN"],
        ],
        "46039": [["Villimpenta", "MN"]],
        "46040": [
            ["Fontanella Grazioli", "MN"],
            ["Ponti Sul Mincio", "MN"],
            ["San Fermo", "MN"],
            ["Ceresara", "MN"],
            ["Gazoldo Degli Ippoliti", "MN"],
            ["Rivalta", "MN"],
            ["Casalromano", "MN"],
            ["Rivalta Sul Mincio", "MN"],
            ["Rodigo", "MN"],
            ["Monzambano", "MN"],
            ["Guidizzolo", "MN"],
            ["Cavriana", "MN"],
            ["Solferino", "MN"],
            ["Casalmoro", "MN"],
            ["Piubega", "MN"],
            ["Casaloldo", "MN"],
        ],
        "46041": [["Castelnuovo Asolano", "MN"], ["Asola", "MN"], ["Castelnuovo", "MN"], ["Barchi Di Asola", "MN"]],
        "46042": [["Castel Goffredo", "MN"]],
        "46043": [["Gozzolina", "MN"], ["Castiglione Delle Stiviere", "MN"]],
        "46044": [["Goito", "MN"], ["Cerlongo", "MN"], ["Solarolo", "MN"]],
        "46045": [["Pozzolo", "MN"], ["Marengo", "MN"], ["Marmirolo", "MN"]],
        "46046": [["Medole", "MN"]],
        "46047": [["Soave", "MN"], ["Porto Mantovano", "MN"], ["Sant'Antonio", "MN"], ["Soave Mantovano", "MN"]],
        "46048": [
            ["Roverbella", "MN"],
            ["Malavicina", "MN"],
            ["Castiglione Mantovano", "MN"],
            ["Canedole", "MN"],
            ["Pellaloco", "MN"],
        ],
        "46049": [["Cereta", "MN"], ["Volta Mantovana", "MN"]],
        "46051": [["Bigarello", "MN"], ["San Giorgio Di Mantova", "MN"]],
        "46100": [
            ["Frassino Mantovano", "MN"],
            ["Lunetta", "MN"],
            ["Mantova", "MN"],
            ["Borgovirgiliana", "MN"],
            ["Formigosa", "MN"],
        ],
        "27010": [
            ["Gerenzago", "PV"],
            ["Borgarello", "PV"],
            ["San Genesio Ed Uniti", "PV"],
            ["San Leonardo Di Linarolo", "PV"],
            ["San Zenone Al Po", "PV"],
            ["Giovenzano", "PV"],
            ["Roncaro", "PV"],
            ["Costa De' Nobili", "PV"],
            ["Albuzzano", "PV"],
            ["Camporinaldo", "PV"],
            ["Motta San Damiano", "PV"],
            ["Giussago", "PV"],
            ["Zeccone", "PV"],
            ["San Leonardo", "PV"],
            ["Santa Cristina E Bissone", "PV"],
            ["Inverno E Monteleone", "PV"],
            ["Badia Pavese", "PV"],
            ["Vellezzo Bellini", "PV"],
            ["Torre D'Arese", "PV"],
            ["Rognano", "PV"],
            ["Bornasco", "PV"],
            ["Torrevecchia Pia", "PV"],
            ["Marzano", "PV"],
            ["Copiano", "PV"],
            ["Turago Bordone", "PV"],
            ["Vistarino", "PV"],
            ["Spessa", "PV"],
            ["Vigonzone", "PV"],
            ["Inverno", "PV"],
            ["Bascape'", "PV"],
            ["Cura Carpignano", "PV"],
            ["Monticelli Pavese", "PV"],
            ["Siziano", "PV"],
            ["Ceranova", "PV"],
            ["Linarolo", "PV"],
            ["Magherno", "PV"],
            ["Monteleone", "PV"],
            ["Guinzano", "PV"],
            ["Filighera", "PV"],
            ["Valle Salimbene", "PV"],
            ["Miradolo Terme", "PV"],
        ],
        "27011": [["Belgioioso", "PV"], ["Torre De' Negri", "PV"]],
        "27012": [["Torriano", "PV"], ["Certosa Di Pavia", "PV"], ["Torre Del Mangano", "PV"]],
        "27013": [["Lambrinia", "PV"], ["Chignolo Po", "PV"]],
        "27014": [["Genzone", "PV"], ["Corteolona", "PV"]],
        "27015": [["Landriano", "PV"]],
        "27016": [["Lardirago", "PV"], ["Sant'Alessio Con Vialone", "PV"]],
        "27017": [["Zerbo", "PV"], ["Pieve Porto Morone", "PV"]],
        "27018": [["Vidigulfo", "PV"]],
        "27019": [["Villanterio", "PV"]],
        "27020": [
            ["Torre D'Isola", "PV"],
            ["Semiana", "PV"],
            ["Trivolzio", "PV"],
            ["Zerbolo'", "PV"],
            ["Marcignago", "PV"],
            ["Massaua", "PV"],
            ["Dorno", "PV"],
            ["Alagna", "PV"],
            ["San Giorgio Di Lomellina", "PV"],
            ["Cergnago", "PV"],
            ["Olevano Di Lomellina", "PV"],
            ["Valle Lomellina", "PV"],
            ["Carbonara Al Ticino", "PV"],
            ["Travaco' Siccomario", "PV"],
            ["Borgo San Siro", "PV"],
            ["Gravellona Lomellina", "PV"],
            ["Velezzo Lomellina", "PV"],
            ["Casottole", "PV"],
            ["Rotta", "PV"],
            ["Tromello", "PV"],
            ["Battuda", "PV"],
            ["Albonese", "PV"],
            ["Valeggio", "PV"],
            ["Parona", "PV"],
            ["Sartirana Lomellina", "PV"],
            ["Breme", "PV"],
            ["Nicorvo", "PV"],
            ["Trovo", "PV"],
            ["Scaldasole", "PV"],
        ],
        "27021": [["Bereguardo", "PV"]],
        "27022": [["Casorate Primo", "PV"]],
        "27023": [["Cassolnovo", "PV"]],
        "27024": [["Cilavegna", "PV"]],
        "27025": [["Gambolo'", "PV"]],
        "27026": [["San Biagio", "PV"], ["Garlasco", "PV"], ["Madonna Delle Bozzole", "PV"]],
        "27027": [["Gropello Cairoli", "PV"]],
        "27028": [["Bivio Cava Manara", "PV"], ["San Martino Siccomario", "PV"]],
        "27029": [["Vigevano", "PV"], ["Sforzesca", "PV"]],
        "27030": [
            ["Balossa Bigli", "PV"],
            ["Ottobiano", "PV"],
            ["Frascarolo", "PV"],
            ["Langosco", "PV"],
            ["Castello D'Agogna", "PV"],
            ["Zeme", "PV"],
            ["Confienza", "PV"],
            ["Zinasco", "PV"],
            ["Rosasco", "PV"],
            ["Torre Beretti E Castellaro", "PV"],
            ["Castellaro De' Giorgi", "PV"],
            ["Pieve Albignola", "PV"],
            ["Ceretto Lomellina", "PV"],
            ["Castelnovetto", "PV"],
            ["Mezzana Bigli", "PV"],
            ["Zinasco Nuovo", "PV"],
            ["Gambarana", "PV"],
            ["Suardi", "PV"],
            ["Cozzo", "PV"],
            ["Sairano", "PV"],
            ["Sant'Angelo Lomellina", "PV"],
            ["Zinasco Vecchio", "PV"],
            ["Mezzana Rabattone", "PV"],
            ["Villanova D'Ardenghi", "PV"],
            ["Palestro", "PV"],
        ],
        "27031": [["Candia Lomellina", "PV"]],
        "27032": [["Ferrera Erbognone", "PV"]],
        "27033": [["Garbana", "PV"]],
        "27034": [["Galliavola", "PV"], ["Lomello", "PV"]],
        "27035": [["Villa Biscossi", "PV"], ["Mede", "PV"]],
        "27036": [["Mortara", "PV"]],
        "27037": [["Pieve Del Cairo", "PV"]],
        "27038": [["Robbio", "PV"]],
        "27039": [["Sannazzaro De' Burgondi", "PV"]],
        "27040": [
            ["Mezzanino", "PV"],
            ["Bosnasco", "PV"],
            ["Casatisma", "PV"],
            ["San Damiano Al Colle", "PV"],
            ["Arena Po", "PV"],
            ["Castelletto Di Branduzzo", "PV"],
            ["Vallescuropasso", "PV"],
            ["Rea", "PV"],
            ["Castana", "PV"],
            ["Borgoratto Mormorolo", "PV"],
            ["Montu' Beccaria", "PV"],
            ["Tornello", "PV"],
            ["Pinarolo Po", "PV"],
            ["Rovescala", "PV"],
            ["Albaredo Arnaboldi", "PV"],
            ["Castelletto Po", "PV"],
            ["Montalto Pavese", "PV"],
            ["Portalbera", "PV"],
            ["Rocca De' Giorgi", "PV"],
            ["Casenove", "PV"],
            ["Mornico Losana", "PV"],
            ["Torre Degli Alberi", "PV"],
            ["Mornico", "PV"],
            ["Montescano", "PV"],
            ["Fortunago", "PV"],
            ["Pometo", "PV"],
            ["Borgo Priolo", "PV"],
            ["Lirio", "PV"],
            ["Verrua Po", "PV"],
            ["Campospinoso", "PV"],
            ["Busca", "PV"],
            ["Pietra De' Giorgi", "PV"],
            ["Calvignano", "PV"],
            ["Cigognola", "PV"],
        ],
        "27041": [["Barbianello", "PV"], ["Casanova Lonati", "PV"]],
        "27042": [["Robecco Pavese", "PV"], ["Bressana Bottarone", "PV"], ["Bressana", "PV"], ["Bottarone", "PV"]],
        "27043": [["Broni", "PV"], ["San Cipriano Po", "PV"]],
        "27044": [["Canneto Pavese", "PV"], ["Canneto", "PV"]],
        "27045": [["Casteggio", "PV"]],
        "27046": [["Santa Giuletta", "PV"]],
        "27047": [
            ["Santa Maria Della Versa", "PV"],
            ["Montecalvo Versiggia", "PV"],
            ["Golferenzo", "PV"],
            ["Volpara", "PV"],
        ],
        "27048": [["Sommo", "PV"]],
        "27049": [["Zenevredo", "PV"], ["Stradella", "PV"]],
        "27050": [
            ["Casei", "PV"],
            ["Torrazza Coste", "PV"],
            ["Val Di Nizza", "PV"],
            ["Brallo Di Pregola", "PV"],
            ["Pancarana", "PV"],
            ["Casei Gerola", "PV"],
            ["Corana", "PV"],
            ["Cervesina", "PV"],
            ["Santa Margherita Di Staffora", "PV"],
            ["Collegio", "PV"],
            ["Codevilla", "PV"],
            ["Romagnese", "PV"],
            ["Pizzale", "PV"],
            ["Ghiaie", "PV"],
            ["Silvano Pietra", "PV"],
            ["Retorbido", "PV"],
            ["Casanova Di Destra", "PV"],
            ["Ponte Nizza", "PV"],
            ["Cecima", "PV"],
            ["Corvino San Quirico", "PV"],
            ["Fumo", "PV"],
            ["Oliva Gessi", "PV"],
            ["Redavalle", "PV"],
            ["Torricella Verzate", "PV"],
            ["Menconico", "PV"],
            ["Bagnaria", "PV"],
            ["Bastida Pancarana", "PV"],
        ],
        "27051": [["Mezzana Corti", "PV"], ["Tre Re", "PV"], ["Cava Manara", "PV"]],
        "27052": [["Montesegale", "PV"], ["Godiasco", "PV"], ["Rocca Susella", "PV"], ["Salice Terme", "PV"]],
        "27053": [["Verretto", "PV"], ["Lungavilla", "PV"]],
        "27054": [["Montebello Della Battaglia", "PV"]],
        "27055": [["Rivanazzano", "PV"]],
        "27056": [["Cornale E Bastida", "PV"], ["Bastida De' Dossi", "PV"], ["Cornale", "PV"]],
        "27057": [["Pietragavina", "PV"], ["Varzi", "PV"]],
        "27058": [["Oriolo", "PV"], ["Voghera", "PV"]],
        "27059": [["Zavattarello", "PV"]],
        "27061": [["Ruino", "PV"], ["Canevino", "PV"]],
        "27100": [["Mirabello Di Pavia", "PV"], ["Ca' Della Terra", "PV"], ["Pavia", "PV"], ["Fossarmato", "PV"]],
        "23010": [
            ["Cedrasco", "SO"],
            ["Rogolo", "SO"],
            ["Mello", "SO"],
            ["Val Masino", "SO"],
            ["Dazio", "SO"],
            ["Fusine", "SO"],
            ["Piantedo", "SO"],
            ["Rasura", "SO"],
            ["Civo", "SO"],
            ["Cevo", "SO"],
            ["San Martino", "SO"],
            ["Albosaggia", "SO"],
            ["San Martino Val Masino", "SO"],
            ["Berbenno Di Valtellina", "SO"],
            ["Cino", "SO"],
            ["Campo Tartano", "SO"],
            ["Cataeggio", "SO"],
            ["Pedesina", "SO"],
            ["Buglio In Monte", "SO"],
            ["Pedemonte", "SO"],
            ["Colorina", "SO"],
            ["Gerola Alta", "SO"],
            ["Albaredo Per San Marco", "SO"],
            ["Tartano", "SO"],
            ["Villapinta", "SO"],
            ["Sirta", "SO"],
            ["San Pietro Di Berbenno", "SO"],
            ["Bema", "SO"],
            ["Torchione", "SO"],
            ["Sant'Antonio Morignone", "SO"],
            ["Moia", "SO"],
            ["Forcola", "SO"],
            ["Caiolo", "SO"],
            ["Postalesio", "SO"],
        ],
        "23011": [["Ardenno", "SO"]],
        "23012": [["Castione Andevenno", "SO"]],
        "23013": [["Regoledo", "SO"], ["Sacco", "SO"], ["Cosio Stazione", "SO"], ["Cosio Valtellino", "SO"]],
        "23014": [["Andalo Valtellino", "SO"], ["Delebio", "SO"]],
        "23015": [["Dubino", "SO"], ["Nuova Olonio", "SO"]],
        "23016": [["Cercino", "SO"], ["Mantello", "SO"]],
        "23017": [["Campovico", "SO"], ["Morbegno", "SO"]],
        "23018": [["Talamona", "SO"]],
        "23019": [["Traona", "SO"]],
        "23020": [
            ["Caspoggio", "SO"],
            ["Verceia", "SO"],
            ["Gordona", "SO"],
            ["Prasomaso", "SO"],
            ["Boffetto", "SO"],
            ["Montagna In Valtellina", "SO"],
            ["Mese", "SO"],
            ["Faedo Valtellino", "SO"],
            ["Piuro", "SO"],
            ["Borgonuovo Di Piuro", "SO"],
            ["Menarola", "SO"],
            ["Piateda", "SO"],
            ["Tresivio", "SO"],
            ["Lirone", "SO"],
            ["Poggiridenti", "SO"],
            ["Spriana", "SO"],
            ["Lanzada", "SO"],
            ["San Giacomo Filippo", "SO"],
            ["Torre Di Santa Maria", "SO"],
            ["San Cassiano", "SO"],
            ["San Cassiano Valchiavenna", "SO"],
            ["Santa Croce", "SO"],
            ["Prosto", "SO"],
            ["Prata Camportaccio", "SO"],
            ["Santa Croce Di Piuro", "SO"],
        ],
        "23021": [["Campodolcino", "SO"], ["Fraciscio", "SO"]],
        "23022": [["Bette", "SO"], ["Chiavenna", "SO"]],
        "23023": [["Primolo", "SO"], ["Chiareggio", "SO"], ["Chiesa In Valmalenco", "SO"]],
        "23024": [["Isola", "SO"], ["Pianazzo", "SO"], ["Madesimo", "SO"], ["Montespluga", "SO"]],
        "23025": [["Novate Mezzola", "SO"], ["Campo", "SO"]],
        "23026": [["Ponte In Valtellina", "SO"], ["Arigna", "SO"]],
        "23027": [
            ["San Pietro Samolaco", "SO"],
            ["Somaggia", "SO"],
            ["Era", "SO"],
            ["Era Samolaco", "SO"],
            ["San Pietro", "SO"],
            ["Samolaco", "SO"],
        ],
        "23029": [["Dogana Di Villa Chiavenna", "SO"], ["Dogana", "SO"], ["Villa Di Chiavenna", "SO"]],
        "23030": [
            ["Castello Dell'Acqua", "SO"],
            ["Cepina Valdisotto", "SO"],
            ["Piatta", "SO"],
            ["Livigno", "SO"],
            ["San Nicolo' Di Valfurva", "SO"],
            ["Trepalle", "SO"],
            ["Valfurva", "SO"],
            ["Tovo Di Sant'Agata", "SO"],
            ["Stazzona", "SO"],
            ["Villa Di Tirano", "SO"],
            ["Mazzo Di Valtellina", "SO"],
            ["Valdisotto", "SO"],
            ["Santa Caterina", "SO"],
            ["Sant'Antonio", "SO"],
            ["Lovero", "SO"],
            ["Castionetto", "SO"],
            ["Santa Caterina Valfurva", "SO"],
            ["Sernio", "SO"],
            ["Bianzone", "SO"],
            ["Cepina", "SO"],
            ["Chiuro", "SO"],
            ["Vervio", "SO"],
        ],
        "23031": [["Aprica", "SO"]],
        "23032": [["Passo Stelvio", "SO"], ["Bormio", "SO"]],
        "23033": [["Tiolo", "SO"], ["Ravoledo", "SO"], ["Grosio", "SO"]],
        "23034": [["Grosotto", "SO"]],
        "23035": [
            ["Villaggio Sondalo", "SO"],
            ["Frontale", "SO"],
            ["Pineta Di Sortenna", "SO"],
            ["Pineta Di Sortenna Vallesana", "SO"],
            ["Sondalo", "SO"],
            ["Mondadizza", "SO"],
            ["Abetina Vallesana", "SO"],
            ["Le Prese", "SO"],
            ["Pendosso", "SO"],
        ],
        "23036": [["Teglio", "SO"], ["San Giacomo", "SO"], ["San Giacomo Di Teglio", "SO"], ["Tresenda", "SO"]],
        "23037": [["Madonna Di Tirano", "SO"], ["Tirano", "SO"]],
        "23038": [
            ["Isolaccia", "SO"],
            ["Semogo", "SO"],
            ["Bagni Nuovi", "SO"],
            ["Bagni Nuovi Di Bormio", "SO"],
            ["Valdidentro", "SO"],
        ],
        "23100": [
            ["Ponchiera", "SO"],
            ["Sant'Anna", "SO"],
            ["Albosaggia", "SO"],
            ["Mossini", "SO"],
            ["Sondrio", "SO"],
            ["Faedo", "SO"],
            ["Triangia", "SO"],
        ],
        "21010": [
            ["San Macario", "VA"],
            ["Arsago Seprio", "VA"],
            ["Muceno", "VA"],
            ["Calde'", "VA"],
            ["Montegrino Valtravaglia", "VA"],
            ["Nasca", "VA"],
            ["Castelveccana", "VA"],
            ["Domo", "VA"],
            ["Germignaga", "VA"],
            ["Castello", "VA"],
            ["Porto Valtravaglia", "VA"],
            ["Ligurno", "VA"],
            ["Tronzano Lago Maggiore", "VA"],
            ["Vizzola Ticino", "VA"],
            ["Curiglia Con Monteviasco", "VA"],
            ["Golasecca", "VA"],
            ["Due Cossani", "VA"],
            ["Ferno", "VA"],
            ["Besnate", "VA"],
            ["Dumenza", "VA"],
            ["Veddasca", "VA"],
            ["Brezzo Di Bedero", "VA"],
            ["Agra", "VA"],
            ["Cardano Al Campo", "VA"],
            ["Pino Sulla Sponda Del Lago Maggiore", "VA"],
        ],
        "21011": [["Casorate Sempione", "VA"]],
        "21012": [["Cassano Magnago", "VA"]],
        "21013": [["Gallarate", "VA"], ["Crenna", "VA"], ["Cedrate", "VA"]],
        "21014": [["Laveno Mombello", "VA"], ["Mombello", "VA"], ["Laveno", "VA"]],
        "21015": [["Lonate Pozzolo", "VA"], ["Tornavento", "VA"], ["Sant'Antonino Ticino", "VA"]],
        "21016": [["Voldomino", "VA"], ["Poppino", "VA"], ["Creva", "VA"], ["Luino", "VA"]],
        "21017": [["Cascina Elisa", "VA"], ["Verghera", "VA"], ["Cascina Costa", "VA"], ["Samarate", "VA"]],
        "21018": [["Sesto Calende", "VA"], ["Lisanza", "VA"]],
        "21019": [
            ["Malpensa Aeroporto", "VA"],
            ["Somma Lombardo", "VA"],
            ["Coarezza", "VA"],
            ["Maddalena", "VA"],
            ["Case Nuove", "VA"],
        ],
        "21020": [
            ["Villadosia", "VA"],
            ["Barasso", "VA"],
            ["Montonate", "VA"],
            ["Crosio Della Valle", "VA"],
            ["Taino", "VA"],
            ["Ternate", "VA"],
            ["Bregano", "VA"],
            ["Daverio", "VA"],
            ["Inarzo", "VA"],
            ["Bodio Lomnago", "VA"],
            ["Bodio", "VA"],
            ["Casale Litta", "VA"],
            ["Mornago", "VA"],
            ["Buguggiate", "VA"],
            ["Cazzago Brabbia", "VA"],
            ["Ranco", "VA"],
            ["Varano Borghi", "VA"],
            ["Galliate Lombardo", "VA"],
            ["Comabbio", "VA"],
            ["Mercallo", "VA"],
            ["Brebbia", "VA"],
            ["Crugnola", "VA"],
            ["Monvalle", "VA"],
            ["Malgesso", "VA"],
            ["Luvinate", "VA"],
            ["Lomnago", "VA"],
            ["Bernate", "VA"],
            ["Bardello", "VA"],
            ["Brunello", "VA"],
            ["Casciago", "VA"],
        ],
        "21021": [["Angera", "VA"]],
        "21022": [["Azzate", "VA"]],
        "21023": [["Besozzo", "VA"]],
        "21024": [["Biandronno", "VA"]],
        "21025": [["Comerio", "VA"]],
        "21026": [["Oltrona Al Lago", "VA"], ["Gavirate", "VA"]],
        "21027": [["Ispra", "VA"], ["Ispra Centro Euratom", "VA"], ["Barza", "VA"]],
        "21028": [["Travedona Monate", "VA"]],
        "21029": [["Cimbro", "VA"], ["Cuirone", "VA"], ["Corgeno", "VA"], ["Vergiate", "VA"]],
        "21030": [
            ["Castello Cabiaglio", "VA"],
            ["Brenta", "VA"],
            ["Cugliate", "VA"],
            ["Cugliate Fabiasco", "VA"],
            ["Mesenzana", "VA"],
            ["Brinzio", "VA"],
            ["Brissago Valtravaglia", "VA"],
            ["Masciago Primo", "VA"],
            ["Cassano Valcuvia", "VA"],
            ["Fabiasco", "VA"],
            ["Marchirolo", "VA"],
            ["Azzio", "VA"],
            ["Orino", "VA"],
            ["Marzio", "VA"],
            ["Duno", "VA"],
            ["Casalzuigno", "VA"],
            ["Grantola", "VA"],
            ["Cremenaga", "VA"],
            ["Ferrera Di Varese", "VA"],
            ["Cuveglio", "VA"],
            ["Cuvio", "VA"],
            ["Rancio Valcuvia", "VA"],
        ],
        "21031": [["Cadegliano Viconago", "VA"], ["Viconago", "VA"], ["Cadegliano", "VA"]],
        "21032": [["Caravate", "VA"]],
        "21033": [["Cittiglio", "VA"]],
        "21034": [["Caldana", "VA"], ["Trevisago", "VA"], ["Cocquio Trevisago", "VA"], ["Cocquio", "VA"]],
        "21035": [["Cunardo", "VA"]],
        "21036": [["Gemonio", "VA"]],
        "21037": [["Lavena Ponte Tresa", "VA"], ["Ponte Tresa", "VA"]],
        "21038": [["Leggiuno", "VA"], ["Sangiano", "VA"]],
        "21039": [["Bedero Valcuvia", "VA"], ["Valganna", "VA"], ["Ganna", "VA"], ["Ghirla", "VA"]],
        "21040": [
            ["Caronno Varesino", "VA"],
            ["Cascine Maggio", "VA"],
            ["Venegono Superiore", "VA"],
            ["Santo Stefano", "VA"],
            ["Gornate Olona", "VA"],
            ["Castronno", "VA"],
            ["Oggiona", "VA"],
            ["Morazzone", "VA"],
            ["Cislago", "VA"],
            ["Vedano Olona", "VA"],
            ["Origgio", "VA"],
            ["Jerago Con Orago", "VA"],
            ["Oggiona Con Santo Stefano", "VA"],
            ["Sumirago", "VA"],
            ["Uboldo", "VA"],
            ["Massina", "VA"],
            ["Carnago", "VA"],
            ["Lozza", "VA"],
            ["Rovate", "VA"],
            ["Venegono Inferiore", "VA"],
            ["Gerenzano", "VA"],
        ],
        "21041": [["Albizzate", "VA"]],
        "21042": [["Caronno Pertusella", "VA"]],
        "21043": [["Gornate Superiore", "VA"], ["Castiglione Olona", "VA"]],
        "21044": [["Cavaria Con Premezzo", "VA"]],
        "21045": [["Schianno", "VA"], ["Gazzada", "VA"], ["Gazzada Schianno", "VA"]],
        "21046": [["Malnate", "VA"], ["San Salvatore", "VA"]],
        "21047": [["Saronno", "VA"]],
        "21048": [["Solbiate Arno", "VA"], ["Monte", "VA"]],
        "21049": [["Abbiate Guazzone", "VA"], ["Tradate", "VA"]],
        "21050": [
            ["Marnate", "VA"],
            ["Brusimpiano", "VA"],
            ["Cuasso Al Monte", "VA"],
            ["Lonate Ceppino", "VA"],
            ["Besano", "VA"],
            ["Bolladello", "VA"],
            ["Porto Ceresio", "VA"],
            ["Gorla Maggiore", "VA"],
            ["Clivio", "VA"],
            ["Cairate", "VA"],
            ["Saltrio", "VA"],
            ["Cuasso Al Piano", "VA"],
            ["Gaggiolo", "VA"],
            ["Bisuschio", "VA"],
            ["Cavagnano", "VA"],
            ["Castelseprio", "VA"],
            ["Cantello", "VA"],
        ],
        "21051": [["Brenno Useria", "VA"], ["Arcisate", "VA"]],
        "21052": [["Sacconago", "VA"], ["Borsano", "VA"], ["Busto Arsizio", "VA"]],
        "21053": [["Castellanza", "VA"]],
        "21054": [["Fagnano Olona", "VA"], ["Bergoro", "VA"]],
        "21055": [["Gorla Minore", "VA"]],
        "21056": [["Induno Olona", "VA"]],
        "21057": [["Cascina Buon Gesu'", "VA"], ["Olgiate Olona", "VA"]],
        "21058": [["Solbiate Olona", "VA"]],
        "21059": [["Baraggia", "VA"], ["Viggiu'", "VA"]],
        "21061": [["Maccagno Con Pino E Veddasca", "VA"], ["Maccagno", "VA"]],
        "21062": [["Osmate", "VA"], ["Cadrezzate", "VA"]],
        "21100": [
            ["Rasa", "VA"],
            ["Rasa Di Velate", "VA"],
            ["Cartabbia", "VA"],
            ["San Fermo", "VA"],
            ["Santa Maria Del Monte", "VA"],
            ["Bizzozero", "VA"],
            ["Sant'Ambrogio Olona", "VA"],
            ["Calcinate Del Pesce", "VA"],
            ["Varese", "VA"],
            ["Capolago", "VA"],
            ["Masnago", "VA"],
            ["Casbeno", "VA"],
        ],
        "60010": [
            ["Ostra", "AN"],
            ["Castelleone Di Suasa", "AN"],
            ["Vaccarile", "AN"],
            ["Barbara", "AN"],
            ["Casine", "AN"],
            ["Pianello Di Ostra", "AN"],
            ["Ostra Vetere", "AN"],
            ["Ponte Rio Di Monterado", "AN"],
            ["Pianello", "AN"],
        ],
        "60011": [
            ["Palazzo D'Arcevia", "AN"],
            ["Castiglioni D'Arcevia", "AN"],
            ["Arcevia", "AN"],
            ["Nidastore", "AN"],
            ["Piticchio", "AN"],
            ["Palazzo", "AN"],
            ["Costa D'Arcevia", "AN"],
            ["Avacelli", "AN"],
            ["Castiglioni", "AN"],
            ["Montefortino", "AN"],
        ],
        "60012": [
            ["Ponte Rio", "AN"],
            ["Ripe", "AN"],
            ["Monterado", "AN"],
            ["Brugnetto", "AN"],
            ["Trecastelli", "AN"],
            ["Castel Colonna", "AN"],
            ["Passo Di Ripe", "AN"],
        ],
        "60013": [["Corinaldo", "AN"]],
        "60015": [["Castelferretti", "AN"], ["Falconara Alta", "AN"], ["Falconara Marittima", "AN"]],
        "60018": [["Marina Di Montemarciano", "AN"], ["Lungomare", "AN"], ["Montemarciano", "AN"]],
        "60019": [
            ["Sant'Angelo Di Senigallia", "AN"],
            ["Marzocca Di Senigallia", "AN"],
            ["Montignano", "AN"],
            ["Marzocca", "AN"],
            ["Sant'Angelo", "AN"],
            ["Vallone", "AN"],
            ["Roncitelli", "AN"],
            ["Cesano Di Senigallia", "AN"],
            ["Senigallia", "AN"],
            ["Scapezzano", "AN"],
        ],
        "60020": [
            ["Sirolo", "AN"],
            ["Agugliano", "AN"],
            ["Offagna", "AN"],
            ["Polverigi", "AN"],
            ["Camerata Picena", "AN"],
            ["Castel D'Emilio", "AN"],
        ],
        "60021": [["Camerano", "AN"], ["Aspio Terme", "AN"]],
        "60022": [["Acquaviva Villa Musone", "AN"], ["San Rocchetto", "AN"], ["Castelfidardo", "AN"]],
        "60024": [["Montoro", "AN"], ["Filottrano", "AN"]],
        "60025": [["Villa Musone", "AN"], ["Loreto Stazione", "AN"], ["Loreto", "AN"]],
        "60026": [["Numana", "AN"], ["Marcelli", "AN"], ["Numana Lido", "AN"]],
        "60027": [
            ["Passatempo", "AN"],
            ["Osimo Stazione", "AN"],
            ["Casenuove", "AN"],
            ["Padiglione", "AN"],
            ["Campocavallo", "AN"],
            ["Osimo", "AN"],
            ["San Sabino", "AN"],
            ["San Biagio", "AN"],
        ],
        "60030": [
            ["San Marcello", "AN"],
            ["Collina Santa Maria Nuova", "AN"],
            ["Mergo", "AN"],
            ["Monsano", "AN"],
            ["Pianello Vallesina", "AN"],
            ["Angeli Di Rosora", "AN"],
            ["Belvedere Ostrense", "AN"],
            ["Rosora", "AN"],
            ["Angeli", "AN"],
            ["Poggio San Marcello", "AN"],
            ["Castelbellino", "AN"],
            ["Serra De' Conti", "AN"],
            ["Monte Roberto", "AN"],
            ["Morro D'Alba", "AN"],
            ["Stazione", "AN"],
            ["Osteria", "AN"],
            ["Santa Maria Nuova", "AN"],
            ["Angeli Di Mergo", "AN"],
            ["Maiolati Spontini", "AN"],
            ["Moie", "AN"],
        ],
        "60031": [["Castelplanio", "AN"], ["Castelplanio Stazione", "AN"], ["Macine", "AN"], ["Borgo Loreto", "AN"]],
        "60033": [["Chiaravalle", "AN"], ["Grancetta", "AN"]],
        "60034": [["Cupramontana", "AN"]],
        "60035": [["Jesi", "AN"]],
        "60036": [["Montecarotto", "AN"]],
        "60037": [["Le Cozze", "AN"], ["Borghetto", "AN"], ["Monte San Vito", "AN"]],
        "60038": [["San Paolo Di Jesi", "AN"]],
        "60039": [["Staffolo", "AN"]],
        "60040": [
            ["Trinquelli", "AN"],
            ["Colleponi Di Genga", "AN"],
            ["Colleponi", "AN"],
            ["Genga Stazione", "AN"],
            ["Genga", "AN"],
        ],
        "60041": [
            ["Cabernardi", "AN"],
            ["Piano Di Frassineta", "AN"],
            ["Monterosso Stazione", "AN"],
            ["Sassoferrato", "AN"],
            ["Monterosso", "AN"],
            ["Perticano", "AN"],
            ["Borgo Sassoferrato", "AN"],
        ],
        "60043": [["Cerreto D'Esi", "AN"]],
        "60044": [
            ["Sant'Elia", "AN"],
            ["Castelletta", "AN"],
            ["Serradica", "AN"],
            ["Melano", "AN"],
            ["Borgo Tufico", "AN"],
            ["Fabriano", "AN"],
            ["Attiggio", "AN"],
            ["Nebbiano", "AN"],
            ["San Michele", "AN"],
            ["Rocchetta Di Fabriano", "AN"],
            ["Marischio", "AN"],
            ["San Donato", "AN"],
            ["Campodonico", "AN"],
            ["Albacina", "AN"],
            ["Argignano", "AN"],
            ["Cancelli", "AN"],
            ["Collamato", "AN"],
            ["Melano Bastia", "AN"],
        ],
        "60048": [
            ["Castellaro", "AN"],
            ["Serra San Quirico Stazione", "AN"],
            ["Domo", "AN"],
            ["Serra San Quirico", "AN"],
            ["Sasso", "AN"],
        ],
        "60100": [["Ancona", "AN"]],
        "60121": [["Ancona", "AN"]],
        "60122": [["Ancona", "AN"]],
        "60123": [["Ancona", "AN"]],
        "60124": [["Ancona", "AN"]],
        "60125": [["Ancona", "AN"]],
        "60126": [["Ancona", "AN"]],
        "60127": [["Ancona", "AN"], ["Pinocchio", "AN"]],
        "60128": [["Ancona", "AN"]],
        "60129": [["Ancona", "AN"], ["Varano", "AN"], ["Pietralacroce", "AN"], ["Poggio", "AN"]],
        "60131": [["Ancona", "AN"], ["Montesicuro", "AN"]],
        "63020": [["Piane Di Falerone", "AP"]],
        "63031": [["Castel Di Lama Stazione", "AP"]],
        "63061": [["Massignano", "AP"]],
        "63062": [["Montefiore Dell'Aso", "AP"]],
        "63063": [["Carassai", "AP"]],
        "63064": [["Cupra Marittima", "AP"]],
        "63065": [["San Savino", "AP"], ["Ripatransone", "AP"]],
        "63066": [["Ischia", "AP"], ["Grottammare", "AP"]],
        "63067": [["Cossignano", "AP"]],
        "63068": [["Porchia", "AP"], ["Patrignone", "AP"], ["Montalto Delle Marche", "AP"]],
        "63069": [["Montedinove", "AP"]],
        "63071": [["Rotella", "AP"], ["Castel Di Croce", "AP"]],
        "63072": [["Castignano", "AP"], ["Ripaberarda", "AP"]],
        "63073": [["Offida", "AP"]],
        "63074": [["San Benedetto Del Tronto", "AP"], ["Porto D'Ascoli", "AP"]],
        "63075": [["Acquaviva Picena", "AP"]],
        "63076": [["Centobuchi", "AP"], ["Monteprandone", "AP"]],
        "63077": [["Monsampolo Del Tronto", "AP"], ["Stella Di Monsampolo", "AP"]],
        "63078": [["Pagliare", "AP"], ["Spinetoli", "AP"]],
        "63079": [["Villa San Giuseppe", "AP"], ["Colli Del Tronto", "AP"]],
        "63081": [["Castorano", "AP"], ["San Silvestro", "AP"]],
        "63082": [
            ["Villa Sant'Antonio", "AP"],
            ["Castel Di Lama Piattoni", "AP"],
            ["Piattoni", "AP"],
            ["Castel Di Lama", "AP"],
        ],
        "63083": [["Appignano Del Tronto", "AP"]],
        "63084": [["Folignano", "AP"], ["Piane Di Morro", "AP"], ["Villa Pigna", "AP"], ["Pigna Bassa", "AP"]],
        "63085": [["Caselle", "AP"], ["Maltignano", "AP"]],
        "63086": [["Force", "AP"]],
        "63087": [["Comunanza", "AP"], ["Croce Di Casale", "AP"]],
        "63088": [["Montemonaco", "AP"]],
        "63091": [["Venarotta", "AP"]],
        "63092": [["Palmiano", "AP"]],
        "63093": [["Roccafluvione", "AP"], ["Marsia", "AP"], ["Agelli", "AP"]],
        "63094": [["Montegallo", "AP"], ["Bisignano", "AP"]],
        "63095": [
            ["Quintodecimo", "AP"],
            ["San Martino Di Acquasanta", "AP"],
            ["Paggese", "AP"],
            ["Acquasanta Terme", "AP"],
            ["Ponte D'Arli", "AP"],
            ["Pozza Di Acquasanta", "AP"],
            ["Tallacano", "AP"],
        ],
        "63096": [
            ["Pretare", "AP"],
            ["Spelonga", "AP"],
            ["Pescara Del Tronto", "AP"],
            ["Trisungo", "AP"],
            ["Arquata Del Tronto", "AP"],
            ["Capodacqua", "AP"],
        ],
        "63100": [
            ["Castel Trosino", "AP"],
            ["Piagge Di Ascoli Piceno", "AP"],
            ["Piagge", "AP"],
            ["Venagrande", "AP"],
            ["Mozzano", "AP"],
            ["Lisciano", "AP"],
            ["Marino Del Tronto", "AP"],
            ["Monticelli", "AP"],
            ["Ascoli Piceno", "AP"],
            ["Campolungo", "AP"],
            ["Poggio Di Bretta", "AP"],
            ["Lisciano Di Colloto", "AP"],
        ],
        "63811": [
            ["Castellano", "FM"],
            ["Bivio Cascinare", "FM"],
            ["Sant'Elpidio A Mare", "FM"],
            ["Casette D'Ete", "FM"],
            ["La Luce", "FM"],
            ["Cretarola", "FM"],
            ["Cascinare", "FM"],
        ],
        "63812": [["Montegranaro", "FM"]],
        "63813": [["Monte Urano", "FM"]],
        "63814": [["Torre San Patrizio", "FM"]],
        "63815": [["Monte San Pietrangeli", "FM"]],
        "63816": [["Francavilla D'Ete", "FM"]],
        "63821": [["Porto Sant'Elpidio", "FM"]],
        "63822": [["Porto San Giorgio", "FM"]],
        "63823": [["Lapedona", "FM"]],
        "63824": [["Marina Di Altidona", "FM"], ["Altidona", "FM"]],
        "63825": [["Rubbianello", "FM"], ["Monterubbiano", "FM"]],
        "63826": [["Moresco", "FM"]],
        "63827": [["Pedaso", "FM"]],
        "63828": [["Campofilone", "FM"]],
        "63831": [["Contrada Tenna", "FM"], ["Rapagnano", "FM"]],
        "63832": [["Magliano Di Tenna", "FM"]],
        "63833": [["Montegiorgio", "FM"], ["Piane Di Montegiorgio", "FM"], ["Alteta", "FM"]],
        "63834": [["Massa Fermana", "FM"]],
        "63835": [["Montappone", "FM"]],
        "63836": [["Monte Vidon Corrado", "FM"]],
        "63837": [["Falerone", "FM"], ["Piane", "FM"]],
        "63838": [["Belmonte Piceno", "FM"]],
        "63839": [["Curetta", "FM"], ["Servigliano", "FM"]],
        "63841": [["Monteleone Di Fermo", "FM"]],
        "63842": [["Monsampietro Morico", "FM"], ["Sant'Elpidio Morico", "FM"]],
        "63843": [["Montottone", "FM"]],
        "63844": [["Grottazzolina", "FM"]],
        "63845": [["Capparuccia", "FM"], ["Ponzano Di Fermo", "FM"], ["Torchiaro", "FM"]],
        "63846": [["Monte Giberto", "FM"]],
        "63847": [["Monte Vidon Combatte", "FM"]],
        "63848": [["Moregnano", "FM"], ["Petritoli", "FM"]],
        "63851": [["Ortezzano", "FM"]],
        "63852": [["Monte Rinaldo", "FM"]],
        "63853": [["Montelparo", "FM"]],
        "63854": [["Santa Vittoria In Matenano", "FM"]],
        "63855": [["Montefalcone Appennino", "FM"]],
        "63856": [["San Martino Al Faggio", "FM"], ["Smerillo", "FM"]],
        "63857": [["Amandola", "FM"]],
        "63858": [["Santa Lucia In Consilvano", "FM"], ["Montefortino", "FM"]],
        "63900": [
            ["Salvano", "FM"],
            ["Torre Di Palme", "FM"],
            ["Campiglione", "FM"],
            ["Molini Di Tenna", "FM"],
            ["Capodarco", "FM"],
            ["Caldarette", "FM"],
            ["Fermo", "FM"],
            ["Marina Palmense", "FM"],
            ["Lido Di Fermo", "FM"],
            ["Ponte Ete", "FM"],
            ["San Tommaso Tre Archi", "FM"],
            ["San Marco", "FM"],
        ],
        "62010": [
            ["Trodica", "MC"],
            ["Morrovalle", "MC"],
            ["Montefano", "MC"],
            ["Appignano", "MC"],
            ["Sant'Egidio", "MC"],
            ["Montecosaro Stazione", "MC"],
            ["Passo Di Treia", "MC"],
            ["Borgo Stazione", "MC"],
            ["Montecassiano", "MC"],
            ["Urbisaglia", "MC"],
            ["Casette Verdini", "MC"],
            ["Pollenza", "MC"],
            ["Mogliano", "MC"],
            ["Morrovalle Stazione", "MC"],
            ["Sambucheto", "MC"],
            ["Montecosaro", "MC"],
            ["Pintura", "MC"],
            ["Santa Maria In Selva", "MC"],
            ["Stazione Morrovalle", "MC"],
            ["Chiesanuova", "MC"],
            ["Treia", "MC"],
            ["Montelupone", "MC"],
        ],
        "62011": [
            ["San Vittore", "MC"],
            ["Moscosi", "MC"],
            ["Avenale", "MC"],
            ["Troviggiano", "MC"],
            ["Villa Moscosi", "MC"],
            ["Villa Torre", "MC"],
            ["Torre", "MC"],
            ["Strada", "MC"],
            ["Cingoli", "MC"],
            ["Grottaccia", "MC"],
        ],
        "62012": [
            ["Fontespina", "MC"],
            ["Civitanova Alta", "MC"],
            ["Civitanova Marche Alta", "MC"],
            ["Civitanova Marche", "MC"],
            ["Santa Maria Apparente", "MC"],
        ],
        "62014": [
            ["Corridonia", "MC"],
            ["Petriolo", "MC"],
            ["Passo Del Bidollo", "MC"],
            ["San Claudio", "MC"],
            ["Colbuccaro", "MC"],
        ],
        "62015": [["Villa San Filippo", "MC"], ["Monte San Giusto", "MC"]],
        "62017": [["Porto Recanati", "MC"]],
        "62018": [["Potenza Picena", "MC"], ["Porto Potenza Picena", "MC"]],
        "62019": [["Recanati", "MC"], ["Musone", "MC"]],
        "62020": [
            ["Penna San Giovanni", "MC"],
            ["Serrapetrona", "MC"],
            ["Caldarola", "MC"],
            ["Sant'Angelo In Pontano", "MC"],
            ["Cessapalombo", "MC"],
            ["Monte San Martino", "MC"],
            ["Gualdo", "MC"],
            ["Belforte Del Chienti", "MC"],
            ["Loro Piceno", "MC"],
            ["Camporotondo Di Fiastrone", "MC"],
            ["Colmurano", "MC"],
            ["Valcimarra", "MC"],
            ["Ripe San Ginesio", "MC"],
        ],
        "62021": [["Frontale", "MC"], ["Poggio San Vicino", "MC"], ["Apiro", "MC"]],
        "62022": [["Gagliole", "MC"], ["Castelraimondo", "MC"], ["Crispiero", "MC"]],
        "62024": [["Colferraio", "MC"], ["Esanatoglia", "MC"], ["Matelica", "MC"]],
        "62025": [
            ["Seppio", "MC"],
            ["Massa", "MC"],
            ["Sefro", "MC"],
            ["Fiuminata", "MC"],
            ["Fonte Di Brescia", "MC"],
            ["Pioraco", "MC"],
        ],
        "62026": [["San Ginesio", "MC"], ["Passo San Ginesio", "MC"], ["Pian Di Pieca", "MC"]],
        "62027": [["Castel San Pietro", "MC"], ["Cesolo", "MC"], ["San Severino Marche", "MC"]],
        "62028": [["Sarnano", "MC"]],
        "62029": [["Tolentino", "MC"]],
        "62032": [
            ["Mergnano San Savino", "MC"],
            ["Polverina", "MC"],
            ["Morro", "MC"],
            ["San Luca", "MC"],
            ["Mergnano", "MC"],
            ["Camerino", "MC"],
        ],
        "62034": [["Muccia", "MC"]],
        "62035": [
            ["Pievebovigliana", "MC"],
            ["Acquacanina", "MC"],
            ["Fiordimonte", "MC"],
            ["Fiegni", "MC"],
            ["Bolognola", "MC"],
            ["Fiastra", "MC"],
        ],
        "62036": [
            ["Casavecchia", "MC"],
            ["Monte Cavallo", "MC"],
            ["Pie' Casavecchia", "MC"],
            ["Pieve Torina", "MC"],
            ["Appennino", "MC"],
        ],
        "62038": [["Serravalle Di Chienti", "MC"], ["Cesi", "MC"], ["Cesi Di Macerata", "MC"]],
        "62039": [["Visso", "MC"], ["Ussita", "MC"], ["Castelsantangelo Sul Nera", "MC"], ["Fematre", "MC"]],
        "62100": [
            ["Madonna Del Monte", "MC"],
            ["Villa Potenza", "MC"],
            ["Macerata", "MC"],
            ["Sforzacosta", "MC"],
            ["Corridonia Stazione", "MC"],
            ["Piediripa", "MC"],
        ],
        "61010": [
            ["Belvedere Fogliense", "PU"],
            ["Case Bernardi", "PU"],
            ["Rio Salso", "PU"],
            ["Monte Cerignone", "PU"],
            ["Savignano Montetassi", "PU"],
            ["Montegrimano", "PU"],
            ["Tavullia", "PU"],
            ["Padiglione", "PU"],
            ["Montelicciano", "PU"],
            ["Valle Di Teva", "PU"],
        ],
        "61011": [["Gabicce Mare", "PU"], ["Case Badioli", "PU"]],
        "61012": [["Fanano", "PU"], ["Gradara", "PU"]],
        "61013": [
            ["Mercatino Conca", "PU"],
            ["Piandicastello", "PU"],
            ["Valle Sant'Anastasio", "PU"],
            ["Fratte Di Sassofeltrio", "PU"],
            ["Sassofeltrio", "PU"],
        ],
        "61014": [["Madonna Di Pugliano", "PU"], ["Montecopiolo", "PU"], ["Villagrande", "PU"]],
        "61020": [
            ["Casinina", "PU"],
            ["Borgo Massano", "PU"],
            ["Gallo", "PU"],
            ["Gallo Di Petriano", "PU"],
            ["Petriano", "PU"],
            ["Ca' Gallo", "PU"],
            ["Montecalvo In Foglia", "PU"],
            ["Tavoleto", "PU"],
        ],
        "61021": [["Frontino", "PU"], ["Carpegna", "PU"]],
        "61022": [
            ["Sant'Angelo In Lizzola", "PU"],
            ["Vallefoglia", "PU"],
            ["Colbordolo", "PU"],
            ["Morciola", "PU"],
            ["Bottega", "PU"],
            ["Montecchio", "PU"],
        ],
        "61023": [["Macerata Feltria", "PU"], ["Pietrarubbia", "PU"]],
        "61024": [["Mombaroccio", "PU"], ["Monteciccardo", "PU"]],
        "61025": [["Montelabbate", "PU"], ["Osteria Nuova", "PU"]],
        "61026": [
            ["Lunano", "PU"],
            ["Belforte All'Isauro", "PU"],
            ["Monastero", "PU"],
            ["Piandimeleto", "PU"],
            ["San Sisto", "PU"],
        ],
        "61028": [["Caprazzino", "PU"], ["Mercatale", "PU"], ["Sassocorvaro", "PU"], ["Auditore", "PU"]],
        "61029": [
            ["Ponte In Foglia", "PU"],
            ["Schieti", "PU"],
            ["Gadana", "PU"],
            ["Trasanni", "PU"],
            ["Pieve Di Cagna", "PU"],
            ["Urbino", "PU"],
            ["Castello Di Cavallino", "PU"],
            ["Castelcavallino", "PU"],
            ["Via Piana", "PU"],
            ["Canavaccio", "PU"],
        ],
        "61030": [
            ["Serrungarina", "PU"],
            ["Montemaggiore Al Metauro", "PU"],
            ["Calcinelli", "PU"],
            ["Cartoceto", "PU"],
            ["San Giorgio Di Pesaro", "PU"],
            ["Tavernelle", "PU"],
            ["Isola Del Piano", "PU"],
            ["Monteguiduccio", "PU"],
            ["Villanova", "PU"],
            ["Piagge", "PU"],
            ["Saltara", "PU"],
            ["Montefelcino", "PU"],
            ["Lucrezia", "PU"],
        ],
        "61032": [["Fenile", "PU"], ["Cuccurano", "PU"], ["Bellocchi", "PU"], ["Fano", "PU"]],
        "61033": [["Fermignano", "PU"]],
        "61034": [["Isola Di Fano", "PU"], ["Calmazzo", "PU"], ["Fossombrone", "PU"]],
        "61037": [["Marotta", "PU"], ["Mondolfo", "PU"], ["Centocroci", "PU"]],
        "61038": [["Orciano Di Pesaro", "PU"]],
        "61039": [["San Costanzo", "PU"], ["Cerasa", "PU"]],
        "61040": [
            ["Fratte Rosa", "PU"],
            ["Sant'Ippolito", "PU"],
            ["Serra Sant'Abbondio", "PU"],
            ["Sant'Andrea Di Suasa", "PU"],
            ["San Filippo Sul Cesano", "PU"],
            ["Mondavio", "PU"],
            ["San Michele Al Fiume", "PU"],
            ["Mercatello Sul Metauro", "PU"],
            ["Borgo Pace", "PU"],
            ["Frontone", "PU"],
            ["Lamoli", "PU"],
            ["Monte Porzio", "PU"],
            ["Sorbolongo", "PU"],
            ["Castelvecchio", "PU"],
            ["Barchi", "PU"],
        ],
        "61041": [
            ["Acqualagna", "PU"],
            ["Abbadia Di Naro", "PU"],
            ["Furlo", "PU"],
            ["Petriccio", "PU"],
            ["Pole", "PU"],
            ["Bellaria", "PU"],
        ],
        "61042": [["Apecchio", "PU"], ["Serravalle Di Carda", "PU"]],
        "61043": [
            ["Secchiano", "PU"],
            ["Acquaviva Marche", "PU"],
            ["Smirra", "PU"],
            ["Pianello", "PU"],
            ["Cagli", "PU"],
        ],
        "61044": [["Pontericcioli", "PU"], ["Chiaserna", "PU"], ["Cantiano", "PU"]],
        "61045": [["Bellisio Solfare", "PU"], ["Monterolo", "PU"], ["Pergola", "PU"]],
        "61046": [["Piobbico", "PU"]],
        "61047": [["San Lorenzo In Campo", "PU"], ["San Vito Sul Cesano", "PU"]],
        "61048": [["Sant'Angelo In Vado", "PU"]],
        "61049": [["Muraglione", "PU"], ["Urbania", "PU"]],
        "61100": [
            ["Villa San Martino", "PU"],
            ["Novilara", "PU"],
            ["Villa Ceccolini", "PU"],
            ["Muraglia", "PU"],
            ["Fiorenzuola Di Focara", "PU"],
            ["Ponte Del Colombarone", "PU"],
            ["Montegranaro", "PU"],
            ["Candelara", "PU"],
            ["Soria", "PU"],
            ["Pantano", "PU"],
            ["Pozzo Alto", "PU"],
            ["San Pietro In Calibano", "PU"],
            ["Pesaro", "PU"],
            ["Santa Maria Delle Fabrecce", "PU"],
            ["Borgo Santa Maria", "PU"],
            ["Case Bruciate", "PU"],
            ["Santa Veneranda", "PU"],
            ["Cattabrighe", "PU"],
            ["Villa Fastiggi", "PU"],
            ["Ginestreto", "PU"],
        ],
        "61121": [["Pesaro", "PU"]],
        "61122": [["Pesaro", "PU"]],
        "86010": [
            ["Campodipietra", "CB"],
            ["San Giovanni In Galdo", "CB"],
            ["San Giuliano Del Sannio", "CB"],
            ["Casalciprano", "CB"],
            ["Busso", "CB"],
            ["Tufara", "CB"],
            ["Mirabello Sannitico", "CB"],
            ["Castropignano", "CB"],
            ["Ferrazzano", "CB"],
            ["Oratino", "CB"],
            ["Roccaspromonte", "CB"],
            ["Cercepiccola", "CB"],
            ["Gildone", "CB"],
        ],
        "86011": [["Baranello", "CB"]],
        "86012": [["Cercemaggiore", "CB"]],
        "86013": [["Gambatesa", "CB"]],
        "86014": [["Guardiaregia", "CB"]],
        "86015": [["Jelsi", "CB"]],
        "86016": [["Riccia", "CB"]],
        "86017": [["Sepino", "CB"]],
        "86018": [["Toro", "CB"]],
        "86019": [["Vinchiaturo", "CB"]],
        "86020": [
            ["Campochiaro", "CB"],
            ["Sant'Angelo Limosano", "CB"],
            ["Duronia", "CB"],
            ["Pietracupa", "CB"],
            ["Colle D'Anchise", "CB"],
            ["Castellino Del Biferno", "CB"],
            ["Molise", "CB"],
            ["Roccavivara", "CB"],
            ["San Polo Matese", "CB"],
            ["Fossalto", "CB"],
            ["Spinete", "CB"],
            ["San Biase", "CB"],
        ],
        "86021": [
            ["Castellone", "CB"],
            ["Bojano", "CB"],
            ["Monteverde", "CB"],
            ["Monteverde Di Boiano", "CB"],
            ["Castellone Di Boiano", "CB"],
        ],
        "86022": [["Limosano", "CB"]],
        "86023": [["Montagano", "CB"]],
        "86024": [["Petrella Tifernina", "CB"]],
        "86025": [["Ripalimosani", "CB"]],
        "86026": [["Salcito", "CB"]],
        "86027": [["San Massimo", "CB"]],
        "86028": [["Torella Del Sannio", "CB"]],
        "86029": [["Trivento", "CB"]],
        "86030": [
            ["Castelbottaccio", "CB"],
            ["Civitacampomarano", "CB"],
            ["Mafalda", "CB"],
            ["Lucito", "CB"],
            ["San Giacomo Degli Schiavoni", "CB"],
            ["Lupara", "CB"],
            ["Acquaviva Collecroce", "CB"],
            ["Tavenna", "CB"],
            ["Guardialfiera", "CB"],
            ["San Felice Del Molise", "CB"],
            ["Montemitro", "CB"],
            ["Matrice", "CB"],
        ],
        "86031": [["Castelmauro", "CB"]],
        "86032": [["Montecilfone", "CB"]],
        "86033": [["Montefalcone Nel Sannio", "CB"]],
        "86034": [["Guglionesi", "CB"]],
        "86035": [["Larino", "CB"]],
        "86036": [["Montenero Di Bisaccia", "CB"]],
        "86037": [["Palata", "CB"]],
        "86038": [["Collecalcioni", "CB"], ["Petacciato", "CB"]],
        "86039": [["Termoli", "CB"]],
        "86040": [
            ["Ripabottoni", "CB"],
            ["Montelongo", "CB"],
            ["Macchia Valfortore", "CB"],
            ["Campolieto", "CB"],
            ["Morrone Del Sannio", "CB"],
            ["Montorio Nei Frentani", "CB"],
            ["Ripabottoni Stazione", "CB"],
            ["San Giuliano Di Puglia", "CB"],
            ["Pietracatella", "CB"],
            ["Monacilioni", "CB"],
            ["Provvidenti", "CB"],
            ["Rotello", "CB"],
        ],
        "86041": [["Bonefro", "CB"]],
        "86042": [["Nuova Cliternia", "CB"], ["Campomarino", "CB"], ["Lido Di Campomarino", "CB"]],
        "86043": [["Casacalenda", "CB"]],
        "86044": [["Colletorto", "CB"]],
        "86045": [["Portocannone", "CB"]],
        "86046": [["San Martino In Pensilis", "CB"]],
        "86047": [["Santa Croce Di Magliano", "CB"]],
        "86048": [["Sant'Elia A Pianisi", "CB"]],
        "86049": [["Ururi", "CB"]],
        "86100": [["Santo Stefano Di Campobasso", "CB"], ["Campobasso", "CB"], ["Santo Stefano", "CB"]],
        "86070": [
            ["Castelnuovo Al Volturno", "IS"],
            ["Scapoli", "IS"],
            ["Sant'Agapito", "IS"],
            ["Taverna Ravindola", "IS"],
            ["Sant'Agapito Scalo", "IS"],
            ["Rocchetta Nuova", "IS"],
            ["Macchia D'Isernia", "IS"],
            ["Roccaravindola", "IS"],
            ["Roccaravindola Stazione", "IS"],
            ["Montaquila", "IS"],
            ["Rocchetta A Volturno", "IS"],
            ["Conca Casale", "IS"],
            ["Fornelli", "IS"],
        ],
        "86071": [["Pizzone", "IS"], ["Castel San Vincenzo", "IS"]],
        "86072": [["Cerro Al Volturno", "IS"], ["Cupone", "IS"]],
        "86073": [["Colli A Volturno", "IS"]],
        "86074": [["Cerasuolo", "IS"], ["Filignano", "IS"]],
        "86075": [["Monteroduni", "IS"], ["Sant'Eusanio", "IS"]],
        "86077": [["Santa Maria Oliveto", "IS"], ["Pozzilli", "IS"]],
        "86078": [
            ["Roccapipirozzi", "IS"],
            ["Sesto Campano", "IS"],
            ["Selvotta", "IS"],
            ["Campopino", "IS"],
            ["Pianura", "IS"],
        ],
        "86079": [["Ceppagna", "IS"], ["Venafro", "IS"]],
        "86080": [
            ["Belmonte Del Sannio", "IS"],
            ["Castel Del Giudice", "IS"],
            ["Roccasicura", "IS"],
            ["Acquaviva D'Isernia", "IS"],
            ["Miranda", "IS"],
            ["Montenero Val Cocchiara", "IS"],
            ["Castelverrino", "IS"],
            ["Pescopennataro", "IS"],
            ["Sant'Angelo Del Pesco", "IS"],
        ],
        "86081": [["Agnone", "IS"], ["Villa Canale", "IS"]],
        "86082": [["Capracotta", "IS"]],
        "86083": [["Castiglione", "IS"], ["Carovilli", "IS"]],
        "86084": [["Vandra", "IS"], ["Forli' Del Sannio", "IS"]],
        "86085": [["Pietrabbondante", "IS"]],
        "86086": [["Poggio Sannita", "IS"]],
        "86087": [["Rionero Sannitico", "IS"]],
        "86088": [["San Pietro Avellana", "IS"]],
        "86089": [["Vastogirardi", "IS"], ["Cerreto", "IS"], ["Villa San Michele", "IS"]],
        "86090": [
            ["Pettoranello Del Molise", "IS"],
            ["Pastena", "IS"],
            ["Longano", "IS"],
            ["Guasto", "IS"],
            ["Indiprete", "IS"],
            ["Pesche", "IS"],
            ["Castelpetroso", "IS"],
            ["Castelpizzuto", "IS"],
        ],
        "86091": [["Bagnoli Del Trigno", "IS"]],
        "86092": [["Roccamandolfi", "IS"], ["Cantalupo Nel Sannio", "IS"]],
        "86093": [["Carpinone", "IS"]],
        "86094": [["Civitanova Del Sannio", "IS"]],
        "86095": [["Frosolone", "IS"], ["San Pietro In Valle", "IS"], ["Sant'Elena Sannita", "IS"]],
        "86096": [
            ["Santa Maria Del Molise", "IS"],
            ["Macchiagodena", "IS"],
            ["Incoronata", "IS"],
            ["Sant'Angelo In Grotte", "IS"],
        ],
        "86097": [["Sessano Del Molise", "IS"], ["Pescolanciano", "IS"], ["Chiauci", "IS"]],
        "86170": [["Miranda", "IS"], ["Castelromano", "IS"], ["Isernia", "IS"]],
        "15010": [
            ["Grognardo", "AL"],
            ["Orsara Bormida", "AL"],
            ["Merana", "AL"],
            ["Visone", "AL"],
            ["Castelletto D'Erro", "AL"],
            ["Ponti", "AL"],
            ["Pareto", "AL"],
            ["Prasco", "AL"],
            ["Alice Bel Colle", "AL"],
            ["Ricaldone", "AL"],
            ["Montechiaro Denice", "AL"],
            ["Terzo", "AL"],
            ["Cavatore", "AL"],
            ["Morbello", "AL"],
            ["Montechiaro D'Acqui", "AL"],
            ["Melazzo", "AL"],
            ["Frascaro", "AL"],
            ["Morsasco", "AL"],
            ["Ponzone", "AL"],
            ["Denice", "AL"],
            ["Cremolino", "AL"],
            ["Montaldo Bormida", "AL"],
            ["Gamalero", "AL"],
            ["Rivalta Bormida", "AL"],
        ],
        "15011": [["Moirano", "AL"], ["Acqui Terme", "AL"]],
        "15012": [["Bistagno", "AL"]],
        "15013": [["Borgoratto Alessandrino", "AL"]],
        "15014": [["Cantalupo", "AL"]],
        "15015": [["Cartosio", "AL"], ["Malvicino", "AL"]],
        "15016": [["Cassine", "AL"], ["Caranzano", "AL"], ["Gavonata", "AL"]],
        "15017": [["Castelnuovo Bormida", "AL"]],
        "15018": [["Spigno Monferrato", "AL"]],
        "15019": [["Strevi", "AL"]],
        "15020": [
            ["Gabiano", "AL"],
            ["San Giorgio Monferrato", "AL"],
            ["Villamiroglio", "AL"],
            ["San Giorgio", "AL"],
            ["Odalengo Piccolo", "AL"],
            ["Zanco", "AL"],
            ["Casalbagliano", "AL"],
            ["Castel San Pietro Monferrato", "AL"],
            ["Cerrina Monferrato", "AL"],
            ["Casalino Di Mombello", "AL"],
            ["Lussello", "AL"],
            ["Montalero", "AL"],
            ["Brusaschetto", "AL"],
            ["Castel San Pietro", "AL"],
            ["Villa Del Foro", "AL"],
            ["Varengo", "AL"],
            ["Serralunga Di Crea", "AL"],
            ["Mombello Monferrato", "AL"],
            ["Cereseto", "AL"],
            ["Castelletto Merli", "AL"],
            ["Moncestino", "AL"],
            ["Murisengo", "AL"],
            ["Pozzengo", "AL"],
            ["Camino", "AL"],
            ["Odalengo Grande", "AL"],
            ["Solonghello", "AL"],
            ["Valle Cerrina", "AL"],
            ["Vallegioliti", "AL"],
            ["Cantavenna", "AL"],
            ["Ponzano Monferrato", "AL"],
            ["Villadeati", "AL"],
        ],
        "15021": [["Cardona", "AL"], ["Alfiano Natta", "AL"], ["Sanico", "AL"]],
        "15022": [["Bergamasco", "AL"]],
        "15023": [["Felizzano", "AL"]],
        "15024": [["Abbazia", "AL"], ["Masio", "AL"]],
        "15025": [["Morano Sul Po", "AL"]],
        "15026": [["Oviglio", "AL"], ["Carentino", "AL"]],
        "15027": [["Pontestura", "AL"]],
        "15028": [["Piepasso", "AL"], ["Quattordio", "AL"]],
        "15029": [["Solero", "AL"]],
        "15030": [
            ["Villanova Monferrato", "AL"],
            ["Terruggia", "AL"],
            ["Stevani", "AL"],
            ["Treville", "AL"],
            ["Sala Monferrato", "AL"],
            ["San Martino", "AL"],
            ["San Maurizio", "AL"],
            ["Rosignano Monferrato", "AL"],
            ["Conzano", "AL"],
            ["Camagna Monferrato", "AL"],
            ["Olivola", "AL"],
            ["Coniolo", "AL"],
        ],
        "15031": [["Balzola", "AL"]],
        "15032": [["Borgo San Martino", "AL"]],
        "15033": [
            ["Terranova", "AL"],
            ["Terranova Monferrato", "AL"],
            ["San Germano", "AL"],
            ["Casale Monferrato", "AL"],
            ["Popolo", "AL"],
            ["Pozzo Sant'Evasio", "AL"],
            ["Roncaglia", "AL"],
            ["Santa Maria Del Tempio", "AL"],
        ],
        "15034": [["Cella Monte", "AL"]],
        "15035": [["Frassinello Monferrato", "AL"]],
        "15036": [["Giarole", "AL"]],
        "15037": [["Lu", "AL"], ["Cuccaro Monferrato", "AL"]],
        "15038": [["Ottiglio", "AL"]],
        "15039": [["Ozzano Monferrato", "AL"]],
        "15040": [
            ["Valmadonna", "AL"],
            ["San Michele", "AL"],
            ["Rivarone", "AL"],
            ["Pietra Marazzi", "AL"],
            ["Bozzole", "AL"],
            ["Pecetto Di Valenza", "AL"],
            ["Castelletto Monferrato", "AL"],
            ["Mirabello Monferrato", "AL"],
            ["Ticineto", "AL"],
            ["Pavone D'Alessandria", "AL"],
            ["Piovera", "AL"],
            ["Occimiano", "AL"],
            ["Valle San Bartolomeo", "AL"],
            ["Valmacca", "AL"],
            ["Frassineto Po", "AL"],
            ["Giardinetto", "AL"],
            ["Montecastello", "AL"],
            ["Pomaro Monferrato", "AL"],
            ["Grava", "AL"],
            ["Alluvioni Cambio'", "AL"],
        ],
        "15041": [["Franchini", "AL"], ["Altavilla Monferrato", "AL"]],
        "15042": [["Bassignana", "AL"], ["Mugarone", "AL"], ["Fiondi", "AL"]],
        "15043": [["Fubine", "AL"]],
        "15044": [["Quargnento", "AL"]],
        "15045": [["Sale", "AL"]],
        "15046": [["San Salvatore Monferrato", "AL"]],
        "15048": [["Valenza", "AL"], ["Monte", "AL"], ["Villabella", "AL"]],
        "15049": [["Vignale Monferrato", "AL"]],
        "15050": [
            ["Guazzora", "AL"],
            ["Montacuto", "AL"],
            ["Casasco", "AL"],
            ["Montemarzino", "AL"],
            ["Sarezzano", "AL"],
            ["Pozzol Groppo", "AL"],
            ["Molino Dei Torti", "AL"],
            ["Costa Vescovato", "AL"],
            ["Momperone", "AL"],
            ["Avolasca", "AL"],
            ["Villaromagnano", "AL"],
            ["Volpeglino", "AL"],
            ["Berzano Di Tortona", "AL"],
            ["Castellar Guidobono", "AL"],
            ["Carbonara Scrivia", "AL"],
            ["Alzano Scrivia", "AL"],
            ["Cerreto Grue", "AL"],
            ["Montegioco", "AL"],
            ["Brignano Frascata", "AL"],
            ["Spineto Scrivia", "AL"],
            ["Villalvernia", "AL"],
            ["Isola Sant'Antonio", "AL"],
            ["Garbagna", "AL"],
            ["Paderna", "AL"],
            ["Sant'Agata Fossili", "AL"],
        ],
        "15051": [["Carezzano", "AL"], ["Castellania", "AL"]],
        "15052": [["Casalnoceto", "AL"]],
        "15053": [["Castelnuovo Scrivia", "AL"]],
        "15054": [["Fabbrica Curone", "AL"], ["Caldirola", "AL"], ["Garadassi", "AL"]],
        "15055": [["Pontecurone", "AL"]],
        "15056": [["San Sebastiano Curone", "AL"], ["Gremiasco", "AL"], ["Dernice", "AL"]],
        "15057": [
            ["Passalacqua", "AL"],
            ["Tortona", "AL"],
            ["Rivalta Scrivia", "AL"],
            ["Castellar Ponzano", "AL"],
            ["Torre Garofoli", "AL"],
        ],
        "15058": [["Viguzzolo", "AL"]],
        "15059": [["Volpedo", "AL"], ["Monleale", "AL"]],
        "15060": [
            ["Castelletto D'Orba", "AL"],
            ["Mongiardino Ligure", "AL"],
            ["Borghetto Di Borbera", "AL"],
            ["Cuquello", "AL"],
            ["Rocchetta Ligure", "AL"],
            ["Carrosio", "AL"],
            ["Parodi Ligure", "AL"],
            ["Persi", "AL"],
            ["Albera Ligure", "AL"],
            ["Sardigliano", "AL"],
            ["Basaluzzo", "AL"],
            ["Cabella Ligure", "AL"],
            ["Castagnola", "AL"],
            ["Vignole Borbera", "AL"],
            ["Carrega Ligure", "AL"],
            ["Cantalupo Ligure", "AL"],
            ["Grondona", "AL"],
            ["San Cristoforo", "AL"],
            ["Voltaggio", "AL"],
            ["Montaldeo", "AL"],
            ["Cosola Di Cabella", "AL"],
            ["Capriata D'Orba", "AL"],
            ["Francavilla Bisio", "AL"],
            ["Torre De' Ratti", "AL"],
            ["Castagnola Di Fraconalto", "AL"],
            ["Tassarolo", "AL"],
            ["Silvano D'Orba", "AL"],
            ["Stazzano", "AL"],
            ["Pasturana", "AL"],
            ["Fraconalto", "AL"],
            ["Bosio", "AL"],
            ["Roccaforte Ligure", "AL"],
        ],
        "15061": [["Arquata Scrivia", "AL"]],
        "15062": [["Donna", "AL"], ["Bosco Marengo", "AL"], ["Pollastra", "AL"]],
        "15063": [["Cassano Spinola", "AL"], ["Gavazzana", "AL"]],
        "15064": [["Fresonara", "AL"]],
        "15065": [["Frugarolo", "AL"]],
        "15066": [["Gavi", "AL"]],
        "15067": [["Novi Ligure", "AL"], ["Merella", "AL"]],
        "15068": [["Pozzolo Formigaro", "AL"]],
        "15069": [["Serravalle Scrivia", "AL"]],
        "15070": [
            ["Castelspina", "AL"],
            ["Cassinelle", "AL"],
            ["Casaleggio Boiro", "AL"],
            ["Lerma", "AL"],
            ["Villa Botteri", "AL"],
            ["Mongiardino", "AL"],
            ["Trisobbio", "AL"],
            ["Bandita", "AL"],
            ["Belforte Monferrato", "AL"],
            ["Tagliolo Monferrato", "AL"],
        ],
        "15071": [["Carpeneto", "AL"]],
        "15072": [["Portanova", "AL"], ["Casal Cermelli", "AL"]],
        "15073": [["Castellazzo Bormida", "AL"]],
        "15074": [["Molare", "AL"]],
        "15075": [["Mornese", "AL"]],
        "15076": [["Gnocchetto", "AL"], ["Ovada", "AL"]],
        "15077": [["Predosa", "AL"], ["Castelferro", "AL"]],
        "15078": [["Rocca Grimalda", "AL"]],
        "15079": [["Sezzadio", "AL"]],
        "15100": [
            ["San Giuliano Vecchio", "AL"],
            ["Spinetta Marengo", "AL"],
            ["Cascinagrossa", "AL"],
            ["Litta Parodi", "AL"],
            ["Alessandria", "AL"],
            ["Lobbi", "AL"],
            ["Castelceriolo", "AL"],
            ["Orti", "AL"],
            ["San Giuliano Nuovo", "AL"],
            ["Cristo", "AL"],
            ["Mandrogne", "AL"],
        ],
        "15121": [["Alessandria", "AL"]],
        "14010": [
            ["Cantarana", "AT"],
            ["San Martino Alfieri", "AT"],
            ["Dusino", "AT"],
            ["Antignano", "AT"],
            ["Montegrosso Di Cinaglio", "AT"],
            ["Dusino San Michele", "AT"],
            ["Celle Enomondo", "AT"],
            ["San Matteo", "AT"],
            ["Viale", "AT"],
            ["Revigliasco D'Asti", "AT"],
            ["Cellarengo", "AT"],
            ["Cortazzone", "AT"],
            ["Cisterna D'Asti", "AT"],
            ["San Paolo Solbrito", "AT"],
        ],
        "14011": [["Baldichieri D'Asti", "AT"]],
        "14012": [["Ferrere", "AT"]],
        "14013": [["Castellero", "AT"], ["Monale", "AT"], ["Cortandone", "AT"]],
        "14014": [["Montafia", "AT"], ["Capriglio", "AT"]],
        "14015": [["San Pietro", "AT"], ["San Damiano D'Asti", "AT"]],
        "14016": [["Pratomorone", "AT"], ["Tigliole", "AT"]],
        "14017": [["Valfenera", "AT"]],
        "14018": [["Roatto", "AT"], ["Maretto", "AT"], ["Villafranca D'Asti", "AT"]],
        "14019": [["Villanova D'Asti Stazione", "AT"], ["Villanova D'Asti", "AT"]],
        "14020": [
            ["Robella", "AT"],
            ["Villa San Secondo", "AT"],
            ["Passerano", "AT"],
            ["Schierano", "AT"],
            ["Cinaglio", "AT"],
            ["Marmorito", "AT"],
            ["Cortanze", "AT"],
            ["Serravalle D'Asti", "AT"],
            ["Cerreto D'Asti", "AT"],
            ["Berzano Di San Pietro", "AT"],
            ["Settime", "AT"],
            ["Camerano Casasco", "AT"],
            ["Pino D'Asti", "AT"],
            ["Aramengo", "AT"],
            ["Cossombrato", "AT"],
            ["Piea", "AT"],
            ["Soglio", "AT"],
            ["Passerano Marmorito", "AT"],
            ["Corsione", "AT"],
        ],
        "14021": [["Buttigliera D'Asti", "AT"]],
        "14022": [
            ["Becchi", "AT"],
            ["Mondonio San Domenico Savio", "AT"],
            ["Albugnano", "AT"],
            ["Castelnuovo Don Bosco", "AT"],
        ],
        "14023": [
            ["Cocconito Vignaretto", "AT"],
            ["Tonengo", "AT"],
            ["Cocconito", "AT"],
            ["Cocconato", "AT"],
            ["Moransengo", "AT"],
        ],
        "14024": [["Moncucco Torinese", "AT"]],
        "14025": [["Montechiaro D'Asti", "AT"], ["Chiusano D'Asti", "AT"]],
        "14026": [
            ["Montiglio", "AT"],
            ["Scandeluzza", "AT"],
            ["Cunico", "AT"],
            ["Colcavagno", "AT"],
            ["Montiglio Monferrato", "AT"],
            ["Piova' Massaia", "AT"],
        ],
        "14030": [
            ["Refrancore", "AT"],
            ["Rocca D'Arazzo", "AT"],
            ["Valenzani", "AT"],
            ["Accorneri", "AT"],
            ["Montemagno", "AT"],
            ["Frinco", "AT"],
            ["Scurzolengo", "AT"],
            ["Azzano D'Asti", "AT"],
            ["Castagnole Monferrato", "AT"],
            ["Viarigi", "AT"],
            ["Cerro Tanaro", "AT"],
            ["Penango", "AT"],
            ["Rocchetta Tanaro", "AT"],
        ],
        "14031": [["San Desiderio", "AT"], ["Calliano", "AT"], ["Grana", "AT"]],
        "14032": [["Casorzo", "AT"]],
        "14033": [["Callianetto", "AT"], ["Castell'Alfero Stazione", "AT"], ["Castell'Alfero", "AT"]],
        "14034": [["Castello Di Annone", "AT"], ["Monfallito", "AT"]],
        "14035": [["Grazzano Badoglio", "AT"]],
        "14036": [["Moncalvo", "AT"]],
        "14037": [["Castiglione D'Asti", "AT"], ["Portacomaro", "AT"], ["Migliandolo", "AT"]],
        "14039": [["Tonco", "AT"]],
        "14040": [
            ["Cortiglione", "AT"],
            ["Quaranti", "AT"],
            ["Castelnuovo Calcea", "AT"],
            ["Castelletto Molina", "AT"],
            ["Vigliano D'Asti", "AT"],
            ["Vinchio", "AT"],
            ["Mongardino", "AT"],
            ["Montabone", "AT"],
            ["Castel Boglione", "AT"],
            ["Belveglio", "AT"],
            ["Maranzana", "AT"],
        ],
        "14041": [["Agliano", "AT"], ["Agliano Terme", "AT"]],
        "14042": [["Rocchetta Palafea", "AT"], ["Calamandrana", "AT"]],
        "14043": [["Castelnuovo Belbo", "AT"]],
        "14044": [["Castel Rocchero", "AT"], ["Fontanile", "AT"]],
        "14045": [["Ghiare", "AT"], ["Incisa Scapaccino", "AT"], ["Madonna", "AT"]],
        "14046": [["Bazzana", "AT"], ["Bruno", "AT"], ["Mombaruzzo", "AT"]],
        "14047": [["Mombercelli", "AT"]],
        "14048": [["Montegrosso D'Asti", "AT"], ["Montaldo Scarampi", "AT"], ["Montegrosso D'Asti Stazione", "AT"]],
        "14049": [["Vaglio Serra", "AT"], ["Nizza Monferrato", "AT"]],
        "14050": [
            ["Cessole", "AT"],
            ["Motta Di Costigliole", "AT"],
            ["Mombaldone", "AT"],
            ["Olmo Gentile", "AT"],
            ["Serole", "AT"],
            ["Moasca", "AT"],
            ["Roccaverano", "AT"],
            ["San Marzano Oliveto", "AT"],
            ["Cassinasco", "AT"],
        ],
        "14051": [["Loazzolo", "AT"], ["Bubbio", "AT"]],
        "14052": [["Calosso", "AT"]],
        "14053": [
            ["Canelli Recapito Gancia", "AT"],
            ["Canelli", "AT"],
            ["Sant'Antonio", "AT"],
            ["Sant'Antonio Di Canelli", "AT"],
        ],
        "14054": [
            ["Coazzolo", "AT"],
            ["Castagnole Delle Lanze", "AT"],
            ["San Bartolomeo Lanze", "AT"],
            ["Olmo Di Castagnole Lanze", "AT"],
            ["Olmo", "AT"],
        ],
        "14055": [["Costigliole D'Asti", "AT"], ["Motta", "AT"], ["Boglietto", "AT"]],
        "14057": [["Isola D'Asti", "AT"], ["Piano", "AT"], ["Molini D'Isola", "AT"]],
        "14058": [["Monastero Bormida", "AT"], ["Sessame", "AT"]],
        "14059": [["San Giorgio Scarampi", "AT"], ["Vesime", "AT"]],
        "14100": [
            ["Stazione Di Portacomaro", "AT"],
            ["Serravalle", "AT"],
            ["Montemarzo", "AT"],
            ["Valletanaro", "AT"],
            ["Viatosto", "AT"],
            ["Poggio D'Asti", "AT"],
            ["Montemarzo D'Asti", "AT"],
            ["Montegrosso", "AT"],
            ["Portacomaro Stazione", "AT"],
            ["Valleandona", "AT"],
            ["Sessant", "AT"],
            ["Valgera", "AT"],
            ["Variglie", "AT"],
            ["Mombarone", "AT"],
            ["San Marzanotto", "AT"],
            ["Asti", "AT"],
            ["Vaglierano", "AT"],
            ["Castiglione", "AT"],
            ["Casabianca", "AT"],
            ["Quarto D'Asti", "AT"],
            ["Revignano", "AT"],
        ],
        "13811": [["Tavigliano", "BI"], ["Andorno Micca", "BI"]],
        "13812": [
            ["Balma Biellese", "BI"],
            ["Quittengo", "BI"],
            ["Campiglia Cervo", "BI"],
            ["Balma", "BI"],
            ["Montesinaro", "BI"],
            ["Piedicavallo", "BI"],
            ["San Paolo Cervo", "BI"],
        ],
        "13814": [["Pollone", "BI"]],
        "13815": [["Rosazza", "BI"]],
        "13816": [["Miagliano", "BI"], ["Sagliano Micca", "BI"]],
        "13817": [["Sordevolo", "BI"]],
        "13818": [["Tollegno", "BI"]],
        "13821": [["Pianezze", "BI"], ["Callabiana", "BI"], ["Camandona", "BI"]],
        "13822": [["Pistolesa", "BI"]],
        "13823": [["Fontanella Ozino", "BI"], ["Strona", "BI"]],
        "13824": [["Veglio", "BI"]],
        "13825": [["Crocemosso", "BI"], ["Campore", "BI"]],
        "13831": [["Mezzana Mortigliengo", "BI"]],
        "13833": [["Portula", "BI"]],
        "13835": [
            ["Bulliana", "BI"],
            ["Soprana", "BI"],
            ["Ponzone", "BI"],
            ["Valle Mosso", "BI"],
            ["Mosso", "BI"],
            ["Vico", "BI"],
            ["Trivero", "BI"],
            ["Botto", "BI"],
            ["Pratrivero", "BI"],
            ["Giardino", "BI"],
        ],
        "13836": [["Ponte Guelpa", "BI"], ["Castellengo", "BI"], ["Aglietti", "BI"], ["Cossato", "BI"]],
        "13841": [["Selve Marcone", "BI"], ["Bioglio", "BI"]],
        "13843": [["Pettinengo", "BI"], ["Vaglio", "BI"]],
        "13844": [["Piatto", "BI"], ["Ternengo", "BI"]],
        "13845": [["Ronco Biellese", "BI"]],
        "13847": [["Vallanzengo", "BI"], ["Valle San Nicolao", "BI"]],
        "13848": [["Zumaglia", "BI"]],
        "13851": [["Castelletto Cervo", "BI"]],
        "13853": [["Capovilla", "BI"], ["Castello", "BI"], ["Lessona", "BI"], ["Crosa", "BI"]],
        "13854": [["Cerreto Castello", "BI"], ["Quaregna", "BI"]],
        "13855": [["Valdengo", "BI"]],
        "13856": [["Vigliano Biellese", "BI"], ["Villaggi", "BI"]],
        "13861": [["Ailoche", "BI"]],
        "13862": [["Brusnengo", "BI"]],
        "13863": [["Coggiola", "BI"]],
        "13864": [["Crevacuore", "BI"], ["Caprile", "BI"]],
        "13865": [["Curino", "BI"]],
        "13866": [["Casapinta", "BI"], ["Masserano", "BI"]],
        "13867": [["Flecchia", "BI"], ["Pray", "BI"], ["Pianceri Alto", "BI"]],
        "13868": [["Sostegno", "BI"], ["Villa Del Bosco", "BI"]],
        "13871": [["Verrone", "BI"], ["Benna", "BI"]],
        "13872": [["Borriana", "BI"]],
        "13873": [["Massazza", "BI"]],
        "13874": [["Mottalciata", "BI"], ["Gifflenga", "BI"]],
        "13875": [["Ponderano", "BI"]],
        "13876": [["Sandigliano", "BI"]],
        "13877": [["Villanova Biellese", "BI"]],
        "13878": [["Candelo", "BI"]],
        "13881": [["Cavaglia'", "BI"], ["Dorzano", "BI"]],
        "13882": [["Cerrione", "BI"], ["Vergnasco", "BI"], ["Magnonevolo", "BI"]],
        "13883": [["Roppolo", "BI"]],
        "13884": [["Torrazzo", "BI"], ["Sala Biellese", "BI"]],
        "13885": [["Brianco", "BI"], ["Salussola", "BI"], ["Vigellio", "BI"]],
        "13886": [["Viverone", "BI"]],
        "13887": [["Zimone", "BI"], ["Magnano", "BI"]],
        "13888": [["Mongrando", "BI"], ["Ceresane", "BI"], ["Curanuova", "BI"], ["Zubiena", "BI"]],
        "13891": [["Camburzano", "BI"]],
        "13893": [["Donato", "BI"]],
        "13894": [["Gaglianico", "BI"]],
        "13895": [["Graglia", "BI"], ["Muzzano", "BI"], ["Graglia Santuario", "BI"], ["Graglia Bagni", "BI"]],
        "13896": [["Netro", "BI"]],
        "13897": [["Occhieppo Inferiore", "BI"]],
        "13898": [["Occhieppo Superiore", "BI"]],
        "13899": [["Pralungo", "BI"]],
        "13900": [
            ["Chiavazza", "BI"],
            ["Oropa", "BI"],
            ["Pavignano", "BI"],
            ["Biella", "BI"],
            ["Barazzetto", "BI"],
            ["Cossila", "BI"],
            ["Vandorno", "BI"],
            ["Favaro", "BI"],
        ],
        "12010": [
            ["Argentera", "CN"],
            ["Roccasparvera", "CN"],
            ["Rittana", "CN"],
            ["Valdieri", "CN"],
            ["Bersezio", "CN"],
            ["Moiola", "CN"],
            ["Pianche", "CN"],
            ["Bernezzo", "CN"],
            ["Santa Croce Cervasca", "CN"],
            ["Aisone", "CN"],
            ["Santa Croce", "CN"],
            ["Andonno", "CN"],
            ["Gaiola", "CN"],
            ["Bagni Di Vinadio", "CN"],
            ["Vignolo", "CN"],
            ["San Defendente", "CN"],
            ["Valloriate", "CN"],
            ["Cervasca", "CN"],
            ["Entracque", "CN"],
            ["Vinadio", "CN"],
            ["Sant'Anna Di Valdieri", "CN"],
            ["Sant'Anna", "CN"],
            ["Pietraporzio", "CN"],
            ["Roaschia", "CN"],
            ["Sambuco", "CN"],
            ["San Rocco Di Bernezzo", "CN"],
        ],
        "12011": [["Martinetto Del Rame", "CN"], ["Aradolo La Bruna", "CN"], ["Borgo San Dalmazzo", "CN"]],
        "12012": [
            ["Boves", "CN"],
            ["Cerati", "CN"],
            ["Fontanelle", "CN"],
            ["Mellana", "CN"],
            ["San Giacomo", "CN"],
            ["Rivoira", "CN"],
            ["San Giacomo Di Boves", "CN"],
        ],
        "12013": [["Chiusa Di Pesio", "CN"], ["San Bartolomeo", "CN"]],
        "12014": [["Festiona", "CN"], ["Demonte", "CN"]],
        "12015": [["Limone Piemonte", "CN"]],
        "12016": [["Peveragno", "CN"], ["Santa Margherita", "CN"], ["San Lorenzo Peveragno", "CN"]],
        "12017": [["Robilante", "CN"]],
        "12018": [["Brignola", "CN"], ["Roccavione", "CN"], ["Brignola Sottana", "CN"]],
        "12019": [["Vernante", "CN"]],
        "12020": [
            ["Casteldelfino", "CN"],
            ["Monsola", "CN"],
            ["Elva", "CN"],
            ["Roccabruna", "CN"],
            ["Sampeyre", "CN"],
            ["Villar San Costanzo", "CN"],
            ["Marmora", "CN"],
            ["Frassino", "CN"],
            ["Venasca", "CN"],
            ["Monterosso Grana", "CN"],
            ["Lemma", "CN"],
            ["Canosio", "CN"],
            ["Macra", "CN"],
            ["Melle", "CN"],
            ["Brossasco", "CN"],
            ["Rore", "CN"],
            ["Valgrana", "CN"],
            ["Pontechianale", "CN"],
            ["Villar", "CN"],
            ["Villar Sampeyre", "CN"],
            ["Stroppo", "CN"],
            ["Isasca", "CN"],
            ["Vottignasco", "CN"],
            ["Castelmagno", "CN"],
            ["Cartignano", "CN"],
            ["Villafalletto", "CN"],
            ["Bellino", "CN"],
            ["Celle Di Macra", "CN"],
            ["San Pietro Monterosso", "CN"],
            ["Villa San Pietro", "CN"],
            ["Rossana", "CN"],
            ["Tarantasca", "CN"],
        ],
        "12021": [["Acceglio", "CN"]],
        "12022": [["San Chiaffredo", "CN"], ["Valmala", "CN"], ["Busca", "CN"], ["Castelletto Busca", "CN"]],
        "12023": [["Caraglio", "CN"]],
        "12024": [["Costigliole Saluzzo", "CN"]],
        "12025": [["Montemale Di Cuneo", "CN"], ["Dronero", "CN"]],
        "12026": [["Piasco", "CN"]],
        "12027": [["Pradleves", "CN"]],
        "12028": [["San Michele Prazzo", "CN"], ["Prazzo", "CN"]],
        "12029": [["Lottulo", "CN"], ["San Damiano Macra", "CN"]],
        "12030": [
            ["Scarnafigi", "CN"],
            ["Torre San Giorgio", "CN"],
            ["Envie", "CN"],
            ["Rifreddo", "CN"],
            ["Cavallermaggiore", "CN"],
            ["Gambasca", "CN"],
            ["Monasterolo Di Savigliano", "CN"],
            ["Marene", "CN"],
            ["Lagnasco", "CN"],
            ["Villanova Solaro", "CN"],
            ["Faule", "CN"],
            ["Murello", "CN"],
            ["Ostana", "CN"],
            ["Pagno", "CN"],
            ["Manta", "CN"],
            ["Oncino", "CN"],
            ["Rifreddo Di Saluzzo", "CN"],
            ["Madonna Del Pilone", "CN"],
            ["Brondello", "CN"],
            ["Sanfront", "CN"],
            ["Polonghera", "CN"],
            ["Casalgrasso", "CN"],
            ["Crissolo", "CN"],
            ["Caramagna Piemonte", "CN"],
            ["Cavallerleone", "CN"],
            ["Carde'", "CN"],
            ["Ruffia", "CN"],
            ["Martiniana Po", "CN"],
        ],
        "12031": [["Bagnolo Piemonte", "CN"]],
        "12032": [["Galleane", "CN"], ["Barge", "CN"]],
        "12033": [["Moretta", "CN"]],
        "12034": [["Paesana", "CN"]],
        "12035": [["Racconigi", "CN"]],
        "12036": [["Staffarda", "CN"], ["Revello", "CN"]],
        "12037": [
            ["Cervignasco", "CN"],
            ["Saluzzo", "CN"],
            ["San Lazzaro Saluzzo", "CN"],
            ["San Lazzaro", "CN"],
            ["Castellar", "CN"],
            ["Via Dei Romani", "CN"],
        ],
        "12038": [["Savigliano", "CN"], ["Levaldigi", "CN"]],
        "12039": [["Verzuolo", "CN"], ["Villanovetta", "CN"], ["Falicetto", "CN"]],
        "12040": [
            ["San Lorenzo Roero", "CN"],
            ["Morozzo", "CN"],
            ["Piobesi D'Alba", "CN"],
            ["Genola", "CN"],
            ["Santo Stefano Roero", "CN"],
            ["Vezza D'Alba", "CN"],
            ["Cervere", "CN"],
            ["Ceresole Alba", "CN"],
            ["Priocca", "CN"],
            ["Canove", "CN"],
            ["Sant'Albano Stura", "CN"],
            ["Sommariva Perno", "CN"],
            ["Castelletto Stura", "CN"],
            ["Margarita", "CN"],
            ["Montanera", "CN"],
            ["Govone", "CN"],
            ["Montaldo Roero", "CN"],
            ["Trucchi", "CN"],
            ["Corneliano D'Alba", "CN"],
            ["Sanfre'", "CN"],
            ["Monteu Roero", "CN"],
            ["San Giuseppe", "CN"],
            ["Baldissero D'Alba", "CN"],
            ["Salmour", "CN"],
        ],
        "12041": [["Isola Di Bene Vagienna", "CN"], ["Isola", "CN"], ["Bene Vagienna", "CN"]],
        "12042": [["Bandito", "CN"], ["Bra", "CN"], ["Pollenzo", "CN"]],
        "12043": [["Canale", "CN"], ["Valpone", "CN"]],
        "12044": [["Roata Chiusani", "CN"], ["San Biagio", "CN"], ["Centallo", "CN"]],
        "12045": [
            ["Piovani", "CN"],
            ["Murazzo", "CN"],
            ["Gerbo", "CN"],
            ["San Sebastiano Della Comunia", "CN"],
            ["San Sebastiano", "CN"],
            ["Tagliata", "CN"],
            ["San Vittore", "CN"],
            ["Fossano", "CN"],
            ["Maddalene", "CN"],
        ],
        "12046": [["San Rocco", "CN"], ["Monta'", "CN"], ["San Rocco Monta'", "CN"]],
        "12047": [["Rocca De' Baldi", "CN"], ["Crava", "CN"]],
        "12048": [["Sommariva Del Bosco", "CN"]],
        "12049": [["Trinita'", "CN"]],
        "12050": [
            ["Feisoglio", "CN"],
            ["Baraccone", "CN"],
            ["Lequio Berria", "CN"],
            ["Magliano Alfieri", "CN"],
            ["Rocchetta Belbo", "CN"],
            ["Guarene", "CN"],
            ["Serralunga D'Alba", "CN"],
            ["Castagnito", "CN"],
            ["Neviglie", "CN"],
            ["Borgomale", "CN"],
            ["Treiso", "CN"],
            ["Torre Bormida", "CN"],
            ["Arguello", "CN"],
            ["Rodello", "CN"],
            ["Sinio", "CN"],
            ["Castellinaldo", "CN"],
            ["Benevello", "CN"],
            ["Sant'Antonio Magliano Alfieri", "CN"],
            ["Sant'Antonio", "CN"],
            ["San Benedetto Belbo", "CN"],
            ["Barbaresco", "CN"],
            ["Niella Belbo", "CN"],
            ["Serravalle Langhe", "CN"],
            ["Vaccheria", "CN"],
            ["Cerreto Langhe", "CN"],
            ["Trezzo Tinella", "CN"],
            ["Montelupo Albese", "CN"],
            ["Castelrotto", "CN"],
            ["Cravanzana", "CN"],
            ["Castino", "CN"],
            ["Bosia", "CN"],
            ["Albaretto Della Torre", "CN"],
            ["Roddino", "CN"],
            ["Cissone", "CN"],
        ],
        "12051": [["Mussotto", "CN"], ["Alba", "CN"]],
        "12052": [["Neive", "CN"], ["Borgonuovo Di Neive", "CN"], ["Borgonovo", "CN"]],
        "12053": [["Santuario Tinella", "CN"], ["Castiglione Tinella", "CN"]],
        "12054": [["Cossano Belbo", "CN"], ["Santa Libera", "CN"]],
        "12055": [["Diano D'Alba", "CN"], ["Valle Talloria", "CN"], ["San Rocco Cherasca", "CN"], ["Ricca", "CN"]],
        "12056": [["San Donato", "CN"], ["San Donato Di Mango", "CN"], ["Mango", "CN"]],
        "12058": [["Camo", "CN"], ["Valdivilla", "CN"], ["Santo Stefano Belbo", "CN"]],
        "12060": [
            ["Magliano Alpi", "CN"],
            ["Gallo Di Grinzane", "CN"],
            ["Bossolasco", "CN"],
            ["Farigliano", "CN"],
            ["Niella Tanaro", "CN"],
            ["Clavesana", "CN"],
            ["Somano", "CN"],
            ["Roddi", "CN"],
            ["Grinzane Cavour", "CN"],
            ["Lequio Tanaro", "CN"],
            ["Madonna Della Neve", "CN"],
            ["Marsaglia", "CN"],
            ["Belvedere Langhe", "CN"],
            ["Piozzo", "CN"],
            ["Castellino Tanaro", "CN"],
            ["Macellai", "CN"],
            ["Igliano", "CN"],
            ["Magliano Alpi Sottano", "CN"],
            ["Barolo", "CN"],
            ["Magliano Alpi Soprano", "CN"],
            ["Gallo", "CN"],
            ["Verduno", "CN"],
            ["Rocca Ciglie'", "CN"],
            ["Bastia Mondovi'", "CN"],
            ["Bonvicino", "CN"],
            ["Ciglie'", "CN"],
            ["Murazzano", "CN"],
            ["Castiglione Falletto", "CN"],
            ["Pocapaglia", "CN"],
            ["Novello", "CN"],
            ["Monchiero", "CN"],
        ],
        "12061": [["Carru'", "CN"]],
        "12062": [["Bricco Favole", "CN"], ["Cherasco", "CN"], ["Roreto", "CN"]],
        "12063": [["Dogliani", "CN"]],
        "12064": [["Rivalta", "CN"], ["La Morra", "CN"]],
        "12065": [["Perno", "CN"], ["Monforte D'Alba", "CN"]],
        "12066": [["Borgo", "CN"], ["Monticello D'Alba", "CN"]],
        "12068": [["Narzole", "CN"]],
        "12069": [
            ["Cinzano", "CN"],
            ["Villa", "CN"],
            ["Santa Vittoria D'Alba Cinzano", "CN"],
            ["Santa Vittoria D'Alba", "CN"],
        ],
        "12070": [
            ["Montezemolo", "CN"],
            ["Perlo", "CN"],
            ["Mombarcaro", "CN"],
            ["Priero", "CN"],
            ["Bragioli", "CN"],
            ["Viola", "CN"],
            ["Nucetto", "CN"],
            ["Lisio", "CN"],
            ["Paroldo", "CN"],
            ["Castelletto Uzzone", "CN"],
            ["Scagnello", "CN"],
            ["Alto", "CN"],
            ["Scaletta Uzzone", "CN"],
            ["Sale San Giovanni", "CN"],
            ["Gorzegno", "CN"],
            ["Levice", "CN"],
            ["Castelnuovo Di Ceva", "CN"],
            ["Pezzolo Valle Uzzone", "CN"],
            ["Gottasecca", "CN"],
            ["Priola", "CN"],
            ["Torresina", "CN"],
            ["Sale Delle Langhe", "CN"],
            ["Battifollo", "CN"],
            ["Perletto", "CN"],
            ["Caprauna", "CN"],
            ["Mombasiglio", "CN"],
        ],
        "12072": [["Camerana", "CN"]],
        "12073": [["Ceva", "CN"], ["Roascio", "CN"]],
        "12074": [["Bergolo", "CN"], ["Cortemilia", "CN"]],
        "12075": [
            ["Garessio", "CN"],
            ["Garessio Borgo Piave", "CN"],
            ["Cerisola", "CN"],
            ["Garessio Borgo Ponte", "CN"],
            ["Trappa", "CN"],
        ],
        "12076": [["Lesegno", "CN"]],
        "12077": [["Prunetto", "CN"], ["Monesiglio", "CN"]],
        "12078": [["Ormea", "CN"], ["Ponte Di Nava", "CN"]],
        "12079": [["Saliceto", "CN"]],
        "12080": [
            ["Pra'", "CN"],
            ["Montaldo Di Mondovi'", "CN"],
            ["Monasterolo Casotto", "CN"],
            ["Monastero Di Vasco", "CN"],
            ["Vicoforte", "CN"],
            ["Santuario Di Vicoforte", "CN"],
            ["Le Moline", "CN"],
            ["Roburent", "CN"],
            ["Torre Mondovi'", "CN"],
            ["San Michele Mondovi'", "CN"],
            ["Briaglia", "CN"],
            ["Pianfei", "CN"],
            ["Moline", "CN"],
            ["Pra' Di Roburent", "CN"],
        ],
        "12081": [["Beinette", "CN"]],
        "12082": [["Frabosa Soprana", "CN"], ["Bossea", "CN"], ["Fontane", "CN"], ["Corsaglia", "CN"]],
        "12083": [["Gosi Pianvignale", "CN"], ["Gosi", "CN"], ["Frabosa Sottana", "CN"]],
        "12084": [
            ["Pogliola", "CN"],
            ["Breo", "CN"],
            ["Gratteria", "CN"],
            ["Breolungi", "CN"],
            ["Sant'Anna Avagnina", "CN"],
            ["Piazza", "CN"],
            ["Rifreddo Mondovi'", "CN"],
            ["Pascomonti", "CN"],
            ["Mondovi'", "CN"],
        ],
        "12087": [["Valcasotto", "CN"], ["Pamparato", "CN"], ["Serra", "CN"], ["Serra Pamparato", "CN"]],
        "12088": [["Roccaforte Mondovi'", "CN"], ["Lurisia", "CN"], ["Prea", "CN"], ["Prea Di Roccaforte", "CN"]],
        "12089": [["Villanova Mondovi'", "CN"]],
        "12100": [
            ["Madonna Delle Grazie", "CN"],
            ["Passatore", "CN"],
            ["San Pietro Del Gallo", "CN"],
            ["San Benigno", "CN"],
            ["Borgo San Giuseppe", "CN"],
            ["San Rocco Castagnaretta", "CN"],
            ["Confreria", "CN"],
            ["Borgo Gesso", "CN"],
            ["Spinetta", "CN"],
            ["Madonna Dell'Olmo", "CN"],
            ["Ronchi", "CN"],
            ["Cuneo", "CN"],
            ["Roata Rossi", "CN"],
        ],
        "28010": [
            ["Fontaneto D'Agogna", "NO"],
            ["Boca", "NO"],
            ["Bogogno", "NO"],
            ["Cavallirio", "NO"],
            ["Revislate", "NO"],
            ["Bolzano Novarese", "NO"],
            ["Miasino", "NO"],
            ["Gargallo", "NO"],
            ["Alzo", "NO"],
            ["Soriso", "NO"],
            ["Briga Novarese", "NO"],
            ["Cavaglietto", "NO"],
            ["Pisano", "NO"],
            ["Sologno", "NO"],
            ["Barengo", "NO"],
            ["Ameno", "NO"],
            ["Vaprio D'Agogna", "NO"],
            ["Cavaglio D'Agogna", "NO"],
            ["Nebbiuno", "NO"],
            ["Caltignaga", "NO"],
            ["Agrate Conturbia", "NO"],
            ["Pella", "NO"],
            ["Divignano", "NO"],
            ["Colazza", "NO"],
        ],
        "28011": [["Coiromonte", "NO"], ["Armeno", "NO"], ["Sovazza", "NO"]],
        "28012": [["Cressa", "NO"]],
        "28013": [["Veruno", "NO"], ["Gattico", "NO"]],
        "28014": [["Maggiora", "NO"]],
        "28015": [["Momo", "NO"]],
        "28016": [["Orta Novarese", "NO"], ["Isola San Giulio", "NO"], ["Orta San Giulio", "NO"]],
        "28017": [["San Maurizio D'Opaglio", "NO"]],
        "28019": [["Suno", "NO"], ["Baraggia", "NO"]],
        "28021": [
            ["Borgomanero", "NO"],
            ["Vergano Di Borgomanero", "NO"],
            ["Santa Cristina Di Borgomanero", "NO"],
            ["San Marco Di Borgomanero", "NO"],
        ],
        "28024": [["Gozzano", "NO"]],
        "28028": [["Pratolungo", "NO"], ["Pettenasco", "NO"]],
        "28040": [
            ["Oleggio Castello", "NO"],
            ["Lesa", "NO"],
            ["Dormelletto", "NO"],
            ["Paruzzaro", "NO"],
            ["Marano Ticino", "NO"],
            ["Mezzomerico", "NO"],
            ["Borgo Ticino", "NO"],
            ["Varallo Pombia", "NO"],
            ["Massino Visconti", "NO"],
        ],
        "28041": [["Arona", "NO"], ["Dagnente", "NO"], ["Mercurago", "NO"]],
        "28043": [["Bellinzago Novarese", "NO"]],
        "28045": [["Invorio", "NO"]],
        "28046": [["Ghevio", "NO"], ["Meina", "NO"]],
        "28047": [["Oleggio", "NO"], ["Fornaci", "NO"]],
        "28050": [["Pombia", "NO"]],
        "28053": [["Castelletto Sopra Ticino", "NO"]],
        "28060": [
            ["Vinzaglio", "NO"],
            ["Granozzo Con Monticello", "NO"],
            ["Casalvolone", "NO"],
            ["Granozzo", "NO"],
            ["San Nazzaro Sesia", "NO"],
            ["Castellazzo Novarese", "NO"],
            ["Casaleggio Novara", "NO"],
            ["Orfengo", "NO"],
            ["Nibbia", "NO"],
            ["Mandello Vitta", "NO"],
            ["Sozzago", "NO"],
            ["Cameriano", "NO"],
            ["Vicolungo", "NO"],
            ["Cureggio", "NO"],
            ["Casalbeltrame", "NO"],
            ["Recetto", "NO"],
            ["San Pietro Mosezzo", "NO"],
            ["Comignago", "NO"],
            ["Casalino", "NO"],
        ],
        "28061": [["Biandrate", "NO"]],
        "28062": [["Cameri Aeronautica", "NO"], ["Cameri", "NO"]],
        "28064": [["Sillavengo", "NO"], ["Carpignano Sesia", "NO"], ["Landiona", "NO"]],
        "28065": [["Cerano", "NO"]],
        "28066": [["Galliate", "NO"]],
        "28068": [["Romentino", "NO"]],
        "28069": [["Trecate", "NO"]],
        "28070": [
            ["Sizzano", "NO"],
            ["Garbagna Novarese", "NO"],
            ["Nibbiola", "NO"],
            ["Tornaco", "NO"],
            ["Terdobbiate", "NO"],
        ],
        "28071": [["Borgolavezzaro", "NO"]],
        "28072": [["San Bernardino", "NO"], ["Briona", "NO"]],
        "28073": [["Fara Novarese", "NO"]],
        "28074": [["Ghemme", "NO"]],
        "28075": [["Grignasco", "NO"]],
        "28076": [["Pogno", "NO"]],
        "28077": [["Prato Sesia", "NO"]],
        "28078": [["Romagnano Sesia", "NO"]],
        "28079": [["Vespolate", "NO"]],
        "28100": [
            ["Veveri", "NO"],
            ["Vignale", "NO"],
            ["Olengo", "NO"],
            ["Bicocca Di Novara", "NO"],
            ["Torrion Quartara", "NO"],
            ["Agognate", "NO"],
            ["Sant'Agabio", "NO"],
            ["Casalgiate", "NO"],
            ["Novara", "NO"],
            ["Lumellogno", "NO"],
            ["Pernate", "NO"],
        ],
        "10010": [
            ["Colleretto Giacosa", "TO"],
            ["Salerano Canavese", "TO"],
            ["Banchette", "TO"],
            ["Lessolo", "TO"],
            ["Bairo", "TO"],
            ["Orio Canavese", "TO"],
            ["Parella", "TO"],
            ["Tavagnasco", "TO"],
            ["Palazzo Canavese", "TO"],
            ["Nomaglio", "TO"],
            ["Settimo Rottaro", "TO"],
            ["Quagliuzzo", "TO"],
            ["Fiorano Canavese", "TO"],
            ["Candia Canavese", "TO"],
            ["Burolo", "TO"],
            ["Calea", "TO"],
            ["Mercenasco", "TO"],
            ["Quassolo", "TO"],
            ["San Martino Canavese", "TO"],
            ["Masino", "TO"],
            ["Andrate", "TO"],
            ["Cossano Canavese", "TO"],
            ["Quincinetto", "TO"],
            ["Strambinello", "TO"],
            ["Barone Canavese", "TO"],
            ["Carema", "TO"],
            ["Azeglio", "TO"],
            ["Gauna", "TO"],
            ["Piverone", "TO"],
            ["Perosa Canavese", "TO"],
            ["Torre Canavese", "TO"],
            ["Albiano D'Ivrea", "TO"],
            ["Villate", "TO"],
            ["Cascinette D'Ivrea", "TO"],
            ["Settimo Vittone", "TO"],
            ["Caravino", "TO"],
            ["Scarmagno", "TO"],
            ["Chiaverano", "TO"],
            ["Loranze'", "TO"],
            ["Rueglio", "TO"],
        ],
        "10011": [["Aglie'", "TO"]],
        "10012": [["Bollengo", "TO"]],
        "10013": [["Baio Dora", "TO"], ["Borgofranco D'Ivrea", "TO"]],
        "10014": [["Caluso", "TO"], ["Vallo Di Caluso", "TO"], ["Vallo", "TO"], ["Are'", "TO"], ["Rodallo", "TO"]],
        "10015": [["San Bernardo D'Ivrea", "TO"], ["Torre Balfredo", "TO"], ["Ivrea", "TO"]],
        "10016": [["Montalto Dora", "TO"]],
        "10017": [["Montanaro", "TO"]],
        "10018": [["Pavone Canavese", "TO"]],
        "10019": [["Strambino", "TO"], ["Cerone", "TO"], ["Carrone", "TO"]],
        "10020": [
            ["Pecetto Torinese", "TO"],
            ["Moriondo Torinese", "TO"],
            ["Marcorengo", "TO"],
            ["Cavagnolo", "TO"],
            ["Colombaro", "TO"],
            ["San Sebastiano Da Po", "TO"],
            ["Verrua Savoia", "TO"],
            ["Brusasco", "TO"],
            ["Riva Presso Chieri", "TO"],
            ["San Pietro", "TO"],
            ["Baldissero Torinese", "TO"],
            ["Arignano", "TO"],
            ["Monteu Da Po", "TO"],
            ["Lauriano", "TO"],
            ["Madonna Della Scala", "TO"],
            ["Brozolo", "TO"],
            ["Pavarolo", "TO"],
            ["Marentino", "TO"],
            ["Andezeno", "TO"],
            ["Montaldo Torinese", "TO"],
            ["Cambiano", "TO"],
            ["Mombello Di Torino", "TO"],
            ["Casalborgone", "TO"],
            ["Rivodora", "TO"],
        ],
        "10022": [
            ["Cavalleri", "TO"],
            ["Carmagnola", "TO"],
            ["Fumeri", "TO"],
            ["San Michele E Grato", "TO"],
            ["San Bernardo Carmagnola", "TO"],
            ["Borgo Salsasio", "TO"],
        ],
        "10023": [["Chieri", "TO"], ["Pessione", "TO"]],
        "10024": [
            ["Moncalieri", "TO"],
            ["Revigliasco", "TO"],
            ["Tagliaferro", "TO"],
            ["Barauda", "TO"],
            ["Colle Della Maddalena", "TO"],
            ["Testona", "TO"],
            ["Revigliasco Torinese", "TO"],
            ["Borgo San Pietro Di Moncalieri", "TO"],
        ],
        "10025": [["Pino Torinese", "TO"]],
        "10026": [["Santena", "TO"]],
        "10028": [["Valle Sauglio", "TO"], ["Trofarello", "TO"]],
        "10029": [["Villastellone", "TO"]],
        "10030": [
            ["Maglione", "TO"],
            ["Vische", "TO"],
            ["Tina", "TO"],
            ["Rondissone", "TO"],
            ["Vestigne'", "TO"],
            ["Villareggia", "TO"],
        ],
        "10031": [["Borgomasino", "TO"]],
        "10032": [["Brandizzo", "TO"]],
        "10034": [["Boschetto", "TO"], ["Chivasso", "TO"], ["Torassi", "TO"], ["Castelrosso", "TO"]],
        "10035": [["Casale", "TO"], ["Mazze'", "TO"], ["Tonengo Di Mazze'", "TO"]],
        "10036": [["Olimpia", "TO"], ["Settimo Torinese", "TO"]],
        "10037": [["Torrazza Piemonte", "TO"]],
        "10038": [["Verolengo", "TO"], ["Casabianca", "TO"], ["Borgo Revel", "TO"]],
        "10039": [["Pecco", "TO"], ["Lugnacco", "TO"], ["Alice Superiore", "TO"]],
        "10040": [
            ["La Cassa", "TO"],
            ["Rivarossa", "TO"],
            ["Rivera", "TO"],
            ["Rivalta Di Torino", "TO"],
            ["Milanere", "TO"],
            ["Tedeschi", "TO"],
            ["Bivio Cumiana", "TO"],
            ["Givoletto", "TO"],
            ["San Gillio", "TO"],
            ["Caselette", "TO"],
            ["Gerbole", "TO"],
            ["Montelera", "TO"],
            ["Zucche", "TO"],
            ["Druento", "TO"],
            ["Rubiana", "TO"],
            ["Cumiana", "TO"],
            ["Val Della Torre", "TO"],
            ["Leini'", "TO"],
            ["Lombardore", "TO"],
            ["Almese", "TO"],
            ["Novaretto", "TO"],
            ["Villar Dora", "TO"],
            ["Piobesi Torinese", "TO"],
            ["Brione", "TO"],
            ["La Loggia", "TO"],
            ["Osasio", "TO"],
            ["Caprie", "TO"],
            ["Pralormo", "TO"],
            ["Lombriasco", "TO"],
            ["Volvera", "TO"],
        ],
        "10041": [["Carignano", "TO"], ["Ceretto Di Carignano", "TO"], ["Ceretto", "TO"]],
        "10042": [["Stupinigi", "TO"], ["Nichelino", "TO"]],
        "10043": [["Orbassano", "TO"]],
        "10044": [["Pianezza", "TO"]],
        "10045": [["Piossasco", "TO"], ["Garola", "TO"]],
        "10046": [["Marocchi", "TO"], ["Avatanei", "TO"], ["Isolabella", "TO"], ["Poirino", "TO"], ["Favari", "TO"]],
        "10048": [["Vinovo", "TO"], ["Garino", "TO"]],
        "10050": [
            ["Sauze D'Oulx", "TO"],
            ["Coazze", "TO"],
            ["San Giorio Di Susa", "TO"],
            ["Borgone Susa", "TO"],
            ["Chiomonte", "TO"],
            ["Salice D'Ulzio", "TO"],
            ["Baratte", "TO"],
            ["Chianocco", "TO"],
            ["Vernetto", "TO"],
            ["Meana Di Susa", "TO"],
            ["Novalesa", "TO"],
            ["San Didero", "TO"],
            ["Zoie", "TO"],
            ["Claviere", "TO"],
            ["Chiusa Di San Michele", "TO"],
            ["Giaglione", "TO"],
            ["Venaus", "TO"],
            ["San Giorio", "TO"],
            ["Mattie", "TO"],
            ["Gravere", "TO"],
            ["Sant'Antonino Di Susa", "TO"],
            ["Exilles", "TO"],
            ["Vaie", "TO"],
            ["Villar Focchiardo", "TO"],
            ["Moncenisio", "TO"],
            ["Salbertrand", "TO"],
            ["Bruzolo", "TO"],
        ],
        "10051": [["Drubiaglio", "TO"], ["Grangia", "TO"], ["Avigliana", "TO"]],
        "10052": [["Bardonecchia", "TO"], ["Borgonovo Bardonecchia", "TO"]],
        "10053": [["Foresto", "TO"], ["Bussoleno", "TO"]],
        "10054": [["Bousson", "TO"], ["Cesana Torinese", "TO"], ["Solomiac", "TO"], ["Sauze Di Cesana", "TO"]],
        "10055": [["Condove", "TO"]],
        "10056": [["Beaulard", "TO"], ["Oulx", "TO"]],
        "10057": [["Sant'Ambrogio Di Torino", "TO"]],
        "10058": [["Sestriere", "TO"], ["Colle Sestriere", "TO"]],
        "10059": [["Mompantero", "TO"], ["San Giuseppe", "TO"], ["Susa", "TO"]],
        "10060": [
            ["Bibiana", "TO"],
            ["Bricherasio", "TO"],
            ["Villar Pellice", "TO"],
            ["Rora'", "TO"],
            ["Combalere", "TO"],
            ["Cantalupa", "TO"],
            ["Airasca", "TO"],
            ["Roletto", "TO"],
            ["Inverso Pinasca", "TO"],
            ["Pragelato", "TO"],
            ["Campiglione", "TO"],
            ["Scalenghe", "TO"],
            ["Castagnole Piemonte", "TO"],
            ["Macello", "TO"],
            ["Pancalieri", "TO"],
            ["Mentoulles", "TO"],
            ["None", "TO"],
            ["Villaretto", "TO"],
            ["Candiolo", "TO"],
            ["Villaretto Chisone", "TO"],
            ["Roure", "TO"],
            ["Perrero", "TO"],
            ["Dubbione", "TO"],
            ["Piscina", "TO"],
            ["Prarostino", "TO"],
            ["Angrogna", "TO"],
            ["Miradolo", "TO"],
            ["Garzigliana", "TO"],
            ["Frossasco", "TO"],
            ["Massello", "TO"],
            ["Bobbio Pellice", "TO"],
            ["Roreto", "TO"],
            ["Riclaretto", "TO"],
            ["Castel Del Bosco", "TO"],
            ["Virle Piemonte", "TO"],
            ["Roreto Chisone", "TO"],
            ["Buriasco", "TO"],
            ["Viotto", "TO"],
            ["Prali", "TO"],
            ["Osasco", "TO"],
            ["Salza Di Pinerolo", "TO"],
            ["Fenestrelle", "TO"],
            ["Pinasca", "TO"],
            ["Castelnuovo", "TO"],
            ["Pra' Catinat", "TO"],
            ["Cercenasco", "TO"],
            ["San Pietro Val Lemina", "TO"],
            ["San Secondo Di Pinerolo", "TO"],
            ["Usseaux", "TO"],
            ["Porte", "TO"],
            ["Lusernetta", "TO"],
            ["Campiglione Fenile", "TO"],
        ],
        "10061": [["Cavour", "TO"]],
        "10062": [["Airali", "TO"], ["Luserna", "TO"], ["Luserna San Giovanni", "TO"]],
        "10063": [["Perosa Argentina", "TO"], ["Pomaretto", "TO"]],
        "10064": [["Abbadia Alpina", "TO"], ["Riva Di Pinerolo", "TO"], ["Pinerolo", "TO"], ["Baudenasca", "TO"]],
        "10065": [["San Germano Chisone", "TO"], ["Pramollo", "TO"]],
        "10066": [["Torre Pellice", "TO"]],
        "10067": [["Vigone", "TO"]],
        "10068": [["Villafranca Piemonte", "TO"]],
        "10069": [["Villar Perosa", "TO"]],
        "10070": [
            ["Fiano", "TO"],
            ["Levone", "TO"],
            ["Villanova Canavese", "TO"],
            ["Benne", "TO"],
            ["Vauda Canavese Superiore", "TO"],
            ["Ala Di Stura", "TO"],
            ["Front", "TO"],
            ["La Villa", "TO"],
            ["Vauda Canavese", "TO"],
            ["Monasterolo Torinese", "TO"],
            ["San Francesco Al Campo", "TO"],
            ["Vallo Torinese", "TO"],
            ["Ceres", "TO"],
            ["Col San Giovanni Di Viu'", "TO"],
            ["Varisella", "TO"],
            ["Corio", "TO"],
            ["Mezzenile", "TO"],
            ["Cantoira", "TO"],
            ["Rocca Canavese", "TO"],
            ["Mondrone", "TO"],
            ["Coassolo Torinese", "TO"],
            ["San Carlo Canavese", "TO"],
            ["Lemie", "TO"],
            ["Col San Giovanni", "TO"],
            ["Bonzo", "TO"],
            ["Pessinetto", "TO"],
            ["Germagnano", "TO"],
            ["Balangero", "TO"],
            ["Monasterolo", "TO"],
            ["Cafasse", "TO"],
            ["Traves", "TO"],
            ["Viu'", "TO"],
            ["Procaria", "TO"],
            ["Forno Alpi Graie", "TO"],
            ["Groscavallo", "TO"],
            ["Grosso", "TO"],
            ["Usseglio", "TO"],
            ["Monastero Di Lanzo", "TO"],
            ["Balme", "TO"],
            ["Robassomero", "TO"],
            ["Barbania", "TO"],
            ["Chialamberto", "TO"],
        ],
        "10071": [["Borgaro Torinese", "TO"]],
        "10072": [["Caselle Torinese", "TO"], ["Mappano", "TO"]],
        "10073": [["Devesi", "TO"], ["Cirie'", "TO"]],
        "10074": [["Lanzo Torinese", "TO"]],
        "10075": [["Mathi", "TO"]],
        "10076": [["San Giovanni", "TO"], ["Nole", "TO"]],
        "10077": [["Malanghero", "TO"], ["Ceretta Di San Maurizio Canavese", "TO"], ["San Maurizio Canavese", "TO"]],
        "10078": [["Venaria Reale", "TO"], ["Altessano", "TO"]],
        "10080": [
            ["Rosone", "TO"],
            ["Ciconio", "TO"],
            ["Baldissero Canavese", "TO"],
            ["Sparone", "TO"],
            ["Lusiglie'", "TO"],
            ["San Ponso", "TO"],
            ["Oglianico", "TO"],
            ["Ceresole Reale", "TO"],
            ["Cintano", "TO"],
            ["Fornolosa", "TO"],
            ["Alpette", "TO"],
            ["Drusacco", "TO"],
            ["Pratiglione", "TO"],
            ["Ozegna", "TO"],
            ["Traversella", "TO"],
            ["Casetti", "TO"],
            ["Ingria", "TO"],
            ["Colleretto Castelnuovo", "TO"],
            ["Valprato Soana", "TO"],
            ["Vistrorio", "TO"],
            ["San Colombano Belmonte", "TO"],
            ["Villa Castelnuovo", "TO"],
            ["Ribordone", "TO"],
            ["Bosconero", "TO"],
            ["Canischio", "TO"],
            ["Salassa", "TO"],
            ["Brosso", "TO"],
            ["Noasca", "TO"],
            ["Locana", "TO"],
            ["Castelnuovo Nigra", "TO"],
            ["Frassinetto", "TO"],
            ["Pertusio", "TO"],
            ["Prascorsano", "TO"],
            ["Vidracco", "TO"],
            ["Chiesanuova", "TO"],
            ["Feletto", "TO"],
            ["Issiglio", "TO"],
            ["Ronco Canavese", "TO"],
            ["Busano", "TO"],
            ["San Benigno Canavese", "TO"],
            ["Rivara", "TO"],
            ["Borgiallo", "TO"],
        ],
        "10081": [
            ["Campo Canavese", "TO"],
            ["San Giovanni Canavese", "TO"],
            ["Muriaglio", "TO"],
            ["Castellamonte", "TO"],
        ],
        "10082": [["Priacco", "TO"], ["Salto Canavese", "TO"], ["Cuorgne'", "TO"]],
        "10083": [["Favria", "TO"]],
        "10084": [["Forno Canavese", "TO"]],
        "10085": [["Pont Canavese", "TO"]],
        "10086": [["Argentera", "TO"], ["Rivarolo Canavese", "TO"]],
        "10087": [["Valperga", "TO"]],
        "10088": [["Volpiano", "TO"]],
        "10089": [["Vico Canavese", "TO"], ["Trausella", "TO"], ["Meugliano", "TO"]],
        "10090": [
            ["San Bernardino", "TO"],
            ["San Giorgio Canavese", "TO"],
            ["Bussolino", "TO"],
            ["Sciolze", "TO"],
            ["Rivalba", "TO"],
            ["Piana San Raffaele", "TO"],
            ["San Raffaele Cimena", "TO"],
            ["Trana", "TO"],
            ["Cinzano", "TO"],
            ["Foglizzo", "TO"],
            ["Sangano", "TO"],
            ["Bruino", "TO"],
            ["Gassino Torinese", "TO"],
            ["Reano", "TO"],
            ["Cuceglio", "TO"],
            ["Vialfre'", "TO"],
            ["Buttigliera Alta", "TO"],
            ["San Giusto Canavese", "TO"],
            ["Villaggio La Quercia", "TO"],
            ["Villarbasse", "TO"],
            ["Castagneto Po", "TO"],
            ["Montalenghe", "TO"],
            ["Romano Canavese", "TO"],
            ["Rosta", "TO"],
            ["Corbiglia", "TO"],
            ["Castiglione Torinese", "TO"],
            ["Ferriera", "TO"],
        ],
        "10091": [["Alpignano", "TO"]],
        "10092": [["Borgaretto", "TO"], ["Beinasco", "TO"]],
        "10093": [
            ["Leumann", "TO"],
            ["Savonera", "TO"],
            ["Collegno", "TO"],
            ["Borgata Paradiso Di Collegno", "TO"],
            ["Regina Margherita", "TO"],
        ],
        "10094": [["Valgioie", "TO"], ["Pontepietra", "TO"], ["Giaveno", "TO"], ["Selvaggio", "TO"]],
        "10095": [["Gerbido", "TO"], ["Lesna", "TO"], ["Grugliasco", "TO"]],
        "10098": [["Tetti Neirotti", "TO"], ["Rivoli", "TO"], ["Bruere", "TO"], ["Cascine Vica", "TO"]],
        "10099": [["San Mauro Torinese", "TO"]],
        "10100": [["Torino", "TO"]],
        "10121": [["Torino", "TO"]],
        "10122": [["Torino", "TO"]],
        "10123": [["Torino", "TO"]],
        "10124": [["Torino", "TO"]],
        "10125": [["Torino", "TO"]],
        "10126": [["Torino", "TO"]],
        "10127": [["Torino", "TO"]],
        "10128": [["Torino", "TO"]],
        "10129": [["Torino", "TO"]],
        "10131": [["Torino", "TO"]],
        "10132": [["Superga", "TO"], ["Torino", "TO"]],
        "10133": [["Torino", "TO"], ["Cavoretto", "TO"]],
        "10134": [["Torino", "TO"]],
        "10135": [["Torino", "TO"]],
        "10136": [["Torino", "TO"]],
        "10137": [["Torino", "TO"]],
        "10138": [["Torino", "TO"]],
        "10139": [["Torino", "TO"]],
        "10141": [["Torino", "TO"]],
        "10142": [["Torino", "TO"]],
        "10143": [["Torino", "TO"]],
        "10144": [["Torino", "TO"]],
        "10145": [["Torino", "TO"]],
        "10146": [["Torino", "TO"]],
        "10147": [["Torino", "TO"]],
        "10148": [["Torino", "TO"]],
        "10149": [["Torino", "TO"]],
        "10151": [["Torino", "TO"]],
        "10152": [["Torino", "TO"]],
        "10153": [["Torino", "TO"]],
        "10154": [["Torino", "TO"]],
        "10155": [["Torino", "TO"]],
        "10156": [["Bertolla Barca", "TO"], ["Torino", "TO"], ["Falchera", "TO"]],
        "28801": [["Cossogno", "VB"]],
        "28802": [["Albo", "VB"], ["Mergozzo", "VB"]],
        "28803": [["Premosello Chiovenda", "VB"], ["Cuzzago", "VB"]],
        "28804": [["San Bernardino Verbano", "VB"], ["Bieno", "VB"]],
        "28805": [["Vogogna", "VB"]],
        "28811": [["Cissano", "VB"], ["Cresseglio", "VB"], ["Arizzano", "VB"]],
        "28812": [["Aurano", "VB"]],
        "28813": [["Bee", "VB"]],
        "28814": [["Cambiasca", "VB"]],
        "28815": [["Caprezzo", "VB"]],
        "28816": [["Intragna", "VB"]],
        "28817": [["Miazzina", "VB"]],
        "28818": [["Premeno", "VB"]],
        "28819": [["Vignone", "VB"]],
        "28821": [["Cannero Riviera", "VB"]],
        "28822": [["Cannobio", "VB"]],
        "28823": [["Ghiffa", "VB"], ["Susello", "VB"], ["Cargiago", "VB"]],
        "28824": [["Gonte", "VB"], ["Oggebbio", "VB"]],
        "28825": [["Ponte Di Falmenta", "VB"]],
        "28826": [["Trarego Viggiona", "VB"]],
        "28827": [["Cursolo Orasso", "VB"], ["Cavaglio Spoccia", "VB"], ["Falmenta", "VB"], ["Airetta", "VB"]],
        "28828": [["Gurro", "VB"]],
        "28831": [["Feriolo Baveno", "VB"], ["Feriolo", "VB"], ["Baveno", "VB"]],
        "28832": [["Belgirate", "VB"]],
        "28833": [["Brovello Carpugnino", "VB"]],
        "28836": [["Gignese", "VB"], ["Vezzo", "VB"]],
        "28838": [
            ["Binda", "VB"],
            ["Levo", "VB"],
            ["Carciano", "VB"],
            ["Isola Bella", "VB"],
            ["Magognino", "VB"],
            ["Stresa", "VB"],
        ],
        "28841": [["Antrona Schieranco", "VB"], ["Antronapiana", "VB"]],
        "28842": [["Fonti", "VB"], ["Bognanco Fonti", "VB"], ["Bognanco", "VB"]],
        "28843": [["Montescheno", "VB"]],
        "28844": [["Villadossola", "VB"]],
        "28845": [["Domodossola", "VB"]],
        "28846": [["Viganella", "VB"], ["Seppiana", "VB"]],
        "28851": [["Cuzzego", "VB"], ["Beura", "VB"], ["Beura Cardezza", "VB"]],
        "28852": [["Craveggia", "VB"], ["Vocogno", "VB"]],
        "28853": [["Druogno", "VB"]],
        "28854": [["Malesco", "VB"], ["Zornasco", "VB"], ["Finero", "VB"]],
        "28855": [["Masera", "VB"]],
        "28856": [["Re", "VB"], ["Villette", "VB"]],
        "28857": [["Santa Maria Maggiore", "VB"]],
        "28858": [["Toceno", "VB"]],
        "28859": [["Trontano", "VB"]],
        "28861": [["Baceno", "VB"]],
        "28862": [["Crodo", "VB"]],
        "28863": [["Formazza", "VB"]],
        "28864": [["Roldo", "VB"], ["Montecrestese", "VB"], ["Pontetto", "VB"]],
        "28865": [["Preglia", "VB"], ["Crevoladossola", "VB"]],
        "28866": [["Premia", "VB"], ["San Rocco", "VB"]],
        "28868": [["Iselle", "VB"], ["Trasquera", "VB"], ["Varzo", "VB"]],
        "28871": [["Bannio Anzino", "VB"]],
        "28873": [["Calasca Castiglione", "VB"], ["Castiglione D'Ossola", "VB"], ["Castiglione", "VB"]],
        "28875": [["Ceppo Morelli", "VB"]],
        "28876": [["Pestarena", "VB"], ["Borca", "VB"], ["Borca Di Macugnaga", "VB"], ["Macugnaga", "VB"]],
        "28877": [["Anzola D'Ossola", "VB"], ["Ornavasso", "VB"]],
        "28879": [["San Carlo", "VB"], ["Vanzone Con San Carlo", "VB"]],
        "28881": [
            ["Cereda", "VB"],
            ["Ramate", "VB"],
            ["Sant'Anna", "VB"],
            ["Casale Corte Cerro", "VB"],
            ["Gabbio", "VB"],
            ["Gabbio Con Monte Ossolano", "VB"],
        ],
        "28883": [["Granerolo", "VB"], ["Gravellona Toce", "VB"], ["Pedemonte", "VB"]],
        "28884": [["Pallanzeno", "VB"]],
        "28885": [["Piedimulera", "VB"]],
        "28886": [["Pieve Vergonte", "VB"]],
        "28887": [
            ["Cireggio", "VB"],
            ["Crusinallo", "VB"],
            ["Omegna", "VB"],
            ["Bagnella", "VB"],
            ["Germagno", "VB"],
            ["Agrano", "VB"],
        ],
        "28891": [["Nonio", "VB"], ["Cesara", "VB"]],
        "28893": [["Loreglia", "VB"]],
        "28894": [["Madonna Del Sasso", "VB"]],
        "28895": [["Forno Di Omegna", "VB"], ["Massiola", "VB"]],
        "28896": [["Quarna Sotto", "VB"]],
        "28897": [["Fornero", "VB"], ["Luzzogno", "VB"], ["Valstrona", "VB"], ["Sambughetto", "VB"]],
        "28898": [["Quarna Sopra", "VB"]],
        "28899": [["Arola", "VB"]],
        "28922": [["Verbania", "VB"]],
        "13010": [
            ["Civiasco", "VC"],
            ["Caresana", "VC"],
            ["Postua", "VC"],
            ["Villata", "VC"],
            ["Guardabosone", "VC"],
            ["Motta De' Conti", "VC"],
            ["Stroppiana", "VC"],
            ["Pezzana", "VC"],
        ],
        "13011": [["Bettole Sesia", "VC"], ["Isolella", "VC"], ["Borgosesia", "VC"]],
        "13012": [["Borgo Vercelli", "VC"], ["Prarolo", "VC"]],
        "13017": [["Quarona", "VC"], ["Doccio", "VC"]],
        "13018": [["Valduggia", "VC"], ["Zuccaro", "VC"]],
        "13019": [["Morca", "VC"], ["Valmaggia", "VC"], ["Varallo", "VC"], ["Roccapietra", "VC"]],
        "13020": [
            ["Sabbia", "VC"],
            ["Mollia", "VC"],
            ["Balmuccia", "VC"],
            ["Rimella", "VC"],
            ["Breia", "VC"],
            ["Rassa", "VC"],
            ["Vocca", "VC"],
            ["Rossa", "VC"],
            ["Piode", "VC"],
            ["Cravagliana", "VC"],
            ["Ferrera", "VC"],
            ["Ca' Di Ianzo", "VC"],
            ["Pila", "VC"],
        ],
        "13021": [["Riva Valdobbia", "VC"], ["Alagna Valsesia", "VC"]],
        "13022": [["Fervento", "VC"], ["Boccioleto", "VC"]],
        "13023": [["Campertogno", "VC"]],
        "13024": [["Cellio", "VC"]],
        "13025": [["Fobello", "VC"], ["Cervatto", "VC"]],
        "13026": [["Carcoforo", "VC"], ["Rima San Giuseppe", "VC"], ["Rimasco", "VC"]],
        "13027": [["Scopa", "VC"]],
        "13028": [["Scopello", "VC"]],
        "13030": [
            ["San Giacomo Vercellese", "VC"],
            ["Albano Vercellese", "VC"],
            ["Villarboit", "VC"],
            ["Rive", "VC"],
            ["Oldenico", "VC"],
            ["Ghislarengo", "VC"],
            ["Greggio", "VC"],
            ["Caresanablot", "VC"],
            ["Quinto Vercellese", "VC"],
            ["Collobiano", "VC"],
            ["Pertengo", "VC"],
            ["Casanova Elvo", "VC"],
            ["Formigliana", "VC"],
        ],
        "13031": [["Arborio", "VC"]],
        "13032": [["Asigliano Vercellese", "VC"]],
        "13033": [["Costanzana", "VC"]],
        "13034": [["Desana", "VC"], ["Lignana", "VC"]],
        "13035": [["Lenta", "VC"]],
        "13036": [["Ronsecco", "VC"]],
        "13037": [["Bornate Sesia", "VC"], ["Vintebbio", "VC"], ["Serravalle Sesia", "VC"]],
        "13038": [["Tricerro", "VC"]],
        "13039": [["Trino", "VC"]],
        "13040": [
            ["Crova", "VC"],
            ["Moncrivello", "VC"],
            ["Buronzo", "VC"],
            ["Palazzolo Vercellese", "VC"],
            ["Rovasenda", "VC"],
            ["Borgo D'Ale", "VC"],
            ["Alice Castello", "VC"],
            ["Salasco", "VC"],
            ["Fontanetto Po", "VC"],
            ["Fornace Crocicchio", "VC"],
            ["Saluggia", "VC"],
            ["Sali Vercellese", "VC"],
            ["Balocco", "VC"],
            ["Sant'Antonino", "VC"],
            ["Carisio", "VC"],
        ],
        "13041": [["Bianze'", "VC"]],
        "13043": [["Cigliano", "VC"]],
        "13044": [["Crescentino", "VC"], ["San Silvestro", "VC"], ["San Genuario", "VC"]],
        "13045": [["Lozzolo", "VC"], ["Gattinara", "VC"]],
        "13046": [["Lamporo", "VC"], ["Livorno Ferraris", "VC"]],
        "13047": [["Olcenengo", "VC"], ["San Germano Vercellese", "VC"]],
        "13048": [["Santhia'", "VC"]],
        "13049": [["Tronzano Vercellese", "VC"]],
        "13060": [["San Maurizio", "VC"], ["Roasio", "VC"], ["Sant'Eusebio", "VC"]],
        "13100": [
            ["Vercelli", "VC"],
            ["Cappuccini", "VC"],
            ["Prarolo", "VC"],
            ["Lignana", "VC"],
            ["Brarola", "VC"],
            ["Larizzate", "VC"],
        ],
        "70010": [
            ["Capurso", "BA"],
            ["Adelfia", "BA"],
            ["Adelfia Montrone", "BA"],
            ["Adelfia Canneto", "BA"],
            ["Cellamare", "BA"],
            ["Locorotondo", "BA"],
            ["Casamassima", "BA"],
            ["San Marco", "BA"],
            ["Sammichele Di Bari", "BA"],
            ["Superga", "BA"],
            ["Turi", "BA"],
            ["Valenzano", "BA"],
            ["San Pietro", "BA"],
            ["Trito", "BA"],
        ],
        "70011": [["Coreggia", "BA"], ["Alberobello", "BA"]],
        "70013": [["Castellana Grotte", "BA"]],
        "70014": [["Triggianello", "BA"], ["Conversano", "BA"]],
        "70015": [["Lamadacqua", "BA"], ["Noci", "BA"]],
        "70016": [["Parchitello", "BA"], ["Noicattaro", "BA"], ["Parco Scizzo", "BA"]],
        "70017": [["San Michele In Monte Laureto", "BA"], ["Putignano", "BA"], ["San Pietro Piturno", "BA"]],
        "70018": [["Rutigliano", "BA"]],
        "70019": [["Triggiano", "BA"]],
        "70020": [
            ["Bitetto", "BA"],
            ["Cassano Delle Murge", "BA"],
            ["Poggiorsini", "BA"],
            ["Binetto", "BA"],
            ["Bitritto", "BA"],
            ["Toritto", "BA"],
        ],
        "70021": [["Acquaviva Delle Fonti", "BA"]],
        "70022": [["Altamura", "BA"], ["Curtaniello", "BA"], ["Parisi", "BA"]],
        "70023": [["Murgia", "BA"], ["Gioia Del Colle", "BA"]],
        "70024": [["Gravina In Puglia", "BA"], ["Murgetta", "BA"], ["Dolcecanto", "BA"], ["La Murgetta", "BA"]],
        "70025": [["Grumo Appula", "BA"]],
        "70026": [["Modugno", "BA"]],
        "70027": [["Palo Del Colle", "BA"]],
        "70028": [["Sannicandro Di Bari", "BA"]],
        "70029": [["Santeramo In Colle", "BA"]],
        "70032": [["Bitonto", "BA"], ["Mariotto", "BA"], ["Palombaio", "BA"]],
        "70033": [["Corato", "BA"]],
        "70037": [["Ruvo Di Puglia", "BA"]],
        "70038": [["Terlizzi", "BA"]],
        "70042": [["Mola Di Bari", "BA"], ["San Maderno", "BA"], ["Cozze", "BA"]],
        "70043": [
            ["Antonelli", "BA"],
            ["Impalata", "BA"],
            ["Lamalunga", "BA"],
            ["Gorgofreddo", "BA"],
            ["Cozzana", "BA"],
            ["Sant'Antonio D'Ascula", "BA"],
            ["Santa Lucia", "BA"],
            ["Monopoli", "BA"],
        ],
        "70044": [["Polignano A Mare", "BA"]],
        "70054": [["Giovinazzo", "BA"]],
        "70056": [["Molfetta", "BA"]],
        "70100": [["Bari", "BA"]],
        "70121": [["Bari", "BA"]],
        "70122": [["Bari", "BA"]],
        "70123": [
            ["Bari", "BA"],
            ["San Paolo", "BA"],
            ["Fesca", "BA"],
            ["San Francesco Dell'Arena", "BA"],
            ["Stanic", "BA"],
            ["San Cataldo", "BA"],
            ["San Girolamo", "BA"],
        ],
        "70124": [["Picone", "BA"], ["Poggio Franco", "BA"], ["Bari", "BA"]],
        "70125": [["Bari", "BA"], ["San Pasquale", "BA"], ["Carrassi", "BA"]],
        "70126": [["Mungivacca", "BA"], ["Japigia", "BA"], ["Bari", "BA"], ["Torre A Mare", "BA"]],
        "70127": [["Santo Spirito", "BA"]],
        "70128": [["Palese", "BA"]],
        "70129": [["Loseto", "BA"], ["Ceglie Del Campo", "BA"]],
        "70131": [["Carbonara Di Bari", "BA"]],
        "72012": [["Carovigno", "BR"], ["Serranova Di Carovigno", "BR"], ["Serranova", "BR"]],
        "72013": [["Ceglie Messapica", "BR"]],
        "72014": [["Cisternino", "BR"], ["Caranna", "BR"], ["Casalini", "BR"]],
        "72015": [
            ["Savelletri", "BR"],
            ["Lamie Di Olimpie", "BR"],
            ["Montalbano", "BR"],
            ["Madonna Pozzo Guacito", "BR"],
            ["Stazione Di Fasano", "BR"],
            ["Torre Canne", "BR"],
            ["Selva", "BR"],
            ["Selva Di Fasano", "BR"],
            ["Fasano", "BR"],
            ["Pezze Di Greco", "BR"],
            ["Marina Di Savelletri", "BR"],
        ],
        "72016": [["Pozzo Guacito", "BR"], ["Montalbano Di Fasano", "BR"]],
        "72017": [["Ostuni", "BR"]],
        "72018": [["San Michele Salentino", "BR"]],
        "72019": [["San Vito Dei Normanni", "BR"]],
        "72020": [["Cellino San Marco", "BR"], ["Torchiarolo", "BR"], ["Erchie", "BR"], ["Tuturano", "BR"]],
        "72021": [["Capece Bax", "BR"], ["Francavilla Fontana", "BR"], ["Capece", "BR"]],
        "72022": [["Latiano", "BR"]],
        "72023": [["Mesagne", "BR"]],
        "72024": [["Oria", "BR"], ["San Cosimo Alla Macchia", "BR"], ["San Cosimo", "BR"]],
        "72025": [["San Donaci", "BR"]],
        "72026": [["San Pancrazio Salentino", "BR"]],
        "72027": [["San Pietro Vernotico", "BR"]],
        "72028": [["Torre Santa Susanna", "BR"]],
        "72029": [["Villa Castelli", "BR"]],
        "72100": [["Brindisi Casale", "BR"], ["Brindisi", "BR"]],
        "76011": [["Bisceglie", "BT"]],
        "76012": [["Canosa Di Puglia", "BT"], ["Loconia", "BT"]],
        "76013": [["Minervino Murge", "BT"]],
        "76014": [["Spinazzola", "BT"]],
        "76015": [["Trinitapoli", "BT"]],
        "76016": [["Margherita Di Savoia", "BT"]],
        "76017": [["San Ferdinando Di Puglia", "BT"]],
        "76121": [["Barletta", "BT"]],
        "76123": [["Montegrosso", "BT"], ["Andria", "BT"]],
        "76125": [["Trani", "BT"]],
        "71010": [
            ["Poggio Imperiale", "FG"],
            ["San Paolo Di Civitate", "FG"],
            ["Rignano Garganico", "FG"],
            ["Carpino", "FG"],
            ["Serracapriola", "FG"],
            ["Ischitella", "FG"],
            ["Cagnano Varano", "FG"],
            ["Ripalta", "FG"],
            ["Difensola", "FG"],
            ["Lesina", "FG"],
            ["Chieuti Scalo", "FG"],
            ["Foce Varano", "FG"],
            ["Chieuti", "FG"],
            ["Peschici", "FG"],
        ],
        "71011": [["Apricena", "FG"]],
        "71012": [["Rodi Garganico", "FG"]],
        "71013": [["San Giovanni Rotondo", "FG"], ["Matine", "FG"]],
        "71014": [["Borgo Celano", "FG"], ["San Marco In Lamis", "FG"]],
        "71015": [["San Nicandro Garganico", "FG"]],
        "71016": [["San Severo", "FG"]],
        "71017": [["Petrulli", "FG"], ["Torremaggiore", "FG"]],
        "71018": [["Umbra", "FG"], ["Vico Del Gargano", "FG"], ["San Menaio", "FG"]],
        "71019": [["Vieste", "FG"]],
        "71020": [
            ["Rocchetta Sant'Antonio Stazione", "FG"],
            ["Castelluccio Valmaggiore", "FG"],
            ["Faeto", "FG"],
            ["Monteleone Di Puglia", "FG"],
            ["Rocchetta Sant'Antonio", "FG"],
            ["Panni", "FG"],
            ["Anzano Di Puglia", "FG"],
            ["Celle Di San Vito", "FG"],
        ],
        "71021": [["Accadia", "FG"]],
        "71022": [["San Carlo", "FG"], ["San Carlo D'Ascoli", "FG"], ["Ascoli Satriano", "FG"]],
        "71023": [["Bovino", "FG"]],
        "71024": [["Candela", "FG"]],
        "71025": [["Castelluccio Dei Sauri", "FG"]],
        "71026": [["Deliceto", "FG"]],
        "71027": [["Orsara Di Puglia", "FG"]],
        "71028": [["Sant'Agata Di Puglia", "FG"]],
        "71029": [["Borgo Giardinetto", "FG"], ["Troia", "FG"]],
        "71030": [
            ["San Marco La Catola", "FG"],
            ["Volturara Appula", "FG"],
            ["Casalvecchio Di Puglia", "FG"],
            ["Zapponeta", "FG"],
            ["Carlantino", "FG"],
            ["Volturino", "FG"],
            ["Fonterosa", "FG"],
            ["Macchia", "FG"],
            ["Mattinata", "FG"],
            ["Motta Montecorvino", "FG"],
        ],
        "71031": [["Alberona", "FG"]],
        "71032": [["Biccari", "FG"], ["Berardinone", "FG"]],
        "71033": [["Casalnuovo Monterotaro", "FG"]],
        "71034": [["Castelnuovo Della Daunia", "FG"]],
        "71035": [["Celenza Valfortore", "FG"]],
        "71036": [["Lucera", "FG"], ["Palmori", "FG"]],
        "71037": [["Monte Sant'Angelo", "FG"]],
        "71038": [["Pietramontecorvino", "FG"]],
        "71039": [["Roseto Valfortore", "FG"]],
        "71040": [
            ["San Nicola", "FG"],
            ["San Nicola Di Tremiti", "FG"],
            ["Ordona", "FG"],
            ["Isole Tremiti", "FG"],
            ["Borgata Mezzanone", "FG"],
            ["Mezzanone", "FG"],
            ["San Domino", "FG"],
        ],
        "71041": [["Carapelle", "FG"]],
        "71042": [
            ["Borgo Liberta'", "FG"],
            ["Cerignola", "FG"],
            ["Borgo Tressanti", "FG"],
            ["La Moschella", "FG"],
            ["Tressanti", "FG"],
            ["Moschella", "FG"],
        ],
        "71043": [["Siponto", "FG"], ["Manfredonia", "FG"]],
        "71045": [["Orta Nova", "FG"]],
        "71047": [["Stornara", "FG"]],
        "71048": [["Stornarella", "FG"]],
        "71100": [
            ["Incoronata", "FG"],
            ["Tavernola", "FG"],
            ["Arpinova", "FG"],
            ["Borgo Incoronata", "FG"],
            ["Segezia", "FG"],
            ["Foggia", "FG"],
            ["Borgo Cervaro", "FG"],
            ["Rignano Garganico Scalo", "FG"],
            ["Cervaro", "FG"],
        ],
        "73010": [
            ["Lequile", "LE"],
            ["Caprarica Di Lecce", "LE"],
            ["Dragoni", "LE"],
            ["Sternatia", "LE"],
            ["Porto Cesareo", "LE"],
            ["Torre Lapillo", "LE"],
            ["Riesci", "LE"],
            ["Veglie", "LE"],
            ["Sogliano Cavour", "LE"],
            ["San Donato Di Lecce", "LE"],
            ["San Pietro In Lama", "LE"],
            ["Zollino", "LE"],
            ["Villa Baldassarri", "LE"],
            ["Arnesano", "LE"],
            ["Galugnano", "LE"],
            ["Surbo", "LE"],
            ["Soleto", "LE"],
            ["Guagnano", "LE"],
        ],
        "73011": [["Alezio", "LE"]],
        "73012": [["Campi Salentina", "LE"]],
        "73013": [["Collemeto", "LE"], ["Galatina", "LE"], ["Noha", "LE"], ["Santa Barbara", "LE"]],
        "73014": [["Gallipoli", "LE"]],
        "73015": [["Salice Salentino", "LE"]],
        "73016": [["San Cesario Di Lecce", "LE"]],
        "73017": [["Lido Conchiglie", "LE"], ["San Simone", "LE"], ["Sannicola", "LE"], ["Chiesanuova", "LE"]],
        "73018": [["Squinzano", "LE"]],
        "73019": [["Trepuzzi", "LE"]],
        "73020": [
            ["Serrano", "LE"],
            ["Palmariggi", "LE"],
            ["Melpignano", "LE"],
            ["Castrignano De' Greci", "LE"],
            ["Santa Cesarea Terme", "LE"],
            ["Giurdignano", "LE"],
            ["Uggiano La Chiesa", "LE"],
            ["Botrugno", "LE"],
            ["Bagnolo Del Salento", "LE"],
            ["Cavallino", "LE"],
            ["Castri Di Lecce", "LE"],
            ["Martignano", "LE"],
            ["Nociglia", "LE"],
            ["Cutrofiano", "LE"],
            ["Vitigliano", "LE"],
            ["Cerfignano", "LE"],
            ["Scorrano", "LE"],
            ["Castromediano", "LE"],
            ["Casamassella", "LE"],
            ["Carpignano Salentino", "LE"],
            ["Cannole", "LE"],
            ["Cursi", "LE"],
            ["San Cassiano", "LE"],
        ],
        "73021": [["Calimera", "LE"]],
        "73022": [["Corigliano D'Otranto", "LE"]],
        "73023": [["Merine", "LE"], ["Lizzanello", "LE"]],
        "73024": [["Maglie", "LE"], ["Morigino", "LE"]],
        "73025": [["Martano", "LE"]],
        "73026": [
            ["Torre Dell'Orso", "LE"],
            ["San Foca", "LE"],
            ["Roca", "LE"],
            ["Rocca Vecchia", "LE"],
            ["Borgagne", "LE"],
            ["Melendugno", "LE"],
        ],
        "73027": [["Minervino Di Lecce", "LE"], ["Cocumola", "LE"], ["Specchia Gallone", "LE"]],
        "73028": [["Otranto", "LE"]],
        "73029": [
            ["Struda'", "LE"],
            ["Pisignano", "LE"],
            ["Vanze", "LE"],
            ["Acquarica Di Lecce", "LE"],
            ["Vernole", "LE"],
            ["Acaia", "LE"],
        ],
        "73030": [
            ["Tiggiano", "LE"],
            ["Montesano Salentino", "LE"],
            ["Diso", "LE"],
            ["Giuggianello", "LE"],
            ["Castro Marina", "LE"],
            ["Ortelle", "LE"],
            ["Marittima", "LE"],
            ["Vignacastrisi", "LE"],
            ["Sanarica", "LE"],
            ["Surano", "LE"],
        ],
        "73031": [["Alessano", "LE"], ["Montesardo", "LE"]],
        "73032": [["Castiglione", "LE"], ["Andrano", "LE"]],
        "73033": [["Corsano", "LE"]],
        "73034": [["Gagliano Del Capo", "LE"], ["San Dana", "LE"], ["Arigliano", "LE"]],
        "73035": [["Miggiano", "LE"]],
        "73036": [["Muro Leccese", "LE"]],
        "73037": [["Poggiardo", "LE"], ["Vaste", "LE"]],
        "73038": [["Spongano", "LE"]],
        "73039": [
            ["Tutino", "LE"],
            ["Depressa", "LE"],
            ["Sant'Eufemia", "LE"],
            ["Tricase Porto", "LE"],
            ["Lucugnano", "LE"],
            ["Caprarica Del Capo", "LE"],
            ["Tricase", "LE"],
        ],
        "73040": [
            ["Neviano", "LE"],
            ["Giuliano Di Lecce", "LE"],
            ["Barbarano Del Capo", "LE"],
            ["Aradeo", "LE"],
            ["Marina Di Leuca", "LE"],
            ["Alliste", "LE"],
            ["Felline", "LE"],
            ["Castrignano Del Capo", "LE"],
            ["Acquarica Del Capo", "LE"],
            ["Specchia", "LE"],
            ["Morciano Di Leuca", "LE"],
            ["Collepasso", "LE"],
            ["Melissano", "LE"],
            ["Supersano", "LE"],
            ["Leuca", "LE"],
            ["Salignano", "LE"],
        ],
        "73041": [["Magliano", "LE"], ["Carmiano", "LE"]],
        "73042": [["Casarano", "LE"]],
        "73043": [["Copertino", "LE"]],
        "73044": [["Galatone", "LE"]],
        "73045": [["Leverano", "LE"]],
        "73046": [["Matino", "LE"]],
        "73047": [["Monteroni Di Lecce", "LE"]],
        "73048": [["Nardo'", "LE"]],
        "73049": [["Ruffano", "LE"], ["Torrepaduli", "LE"]],
        "73050": [
            ["Santa Chiara Di Nardo'", "LE"],
            ["Ruggiano", "LE"],
            ["Salve", "LE"],
            ["Villaggio Boncore", "LE"],
            ["Santa Maria Al Bagno", "LE"],
            ["Santa Chiara", "LE"],
            ["Boncore", "LE"],
            ["Santa Caterina", "LE"],
            ["Secli'", "LE"],
        ],
        "73051": [["Villa Convento", "LE"], ["Novoli", "LE"]],
        "73052": [["Parabita", "LE"]],
        "73053": [["Patu'", "LE"]],
        "73054": [["Presicce", "LE"]],
        "73055": [["Racale", "LE"]],
        "73056": [["Taurisano", "LE"]],
        "73057": [["Taviano", "LE"]],
        "73058": [["Tuglie", "LE"]],
        "73059": [["Gemini", "LE"], ["Ugento", "LE"]],
        "73100": [["Frigole", "LE"], ["Lecce", "LE"], ["Torre Chianca", "LE"], ["San Cataldo", "LE"]],
        "74010": [["Statte", "TA"]],
        "74011": [
            ["Case Perrone", "TA"],
            ["Borgo Perrone", "TA"],
            ["Marina Di Castellaneta", "TA"],
            ["Castellaneta", "TA"],
        ],
        "74012": [["Crispiano", "TA"]],
        "74013": [["Ginosa", "TA"]],
        "74014": [["Laterza", "TA"]],
        "74015": [
            ["San Paolo", "TA"],
            ["Specchia Tarantina", "TA"],
            ["Lanzo Di Martina Franca", "TA"],
            ["Carpari", "TA"],
            ["Martina Franca", "TA"],
        ],
        "74016": [["Massafra", "TA"]],
        "74017": [["Mottola", "TA"], ["San Basilio Mottola", "TA"]],
        "74018": [["Palagianello", "TA"]],
        "74019": [["Palagiano", "TA"], ["Conca D'Oro", "TA"]],
        "74020": [
            ["Monteparano", "TA"],
            ["Leporano Marina", "TA"],
            ["Leporano", "TA"],
            ["Torricella", "TA"],
            ["San Marzano Di San Giuseppe", "TA"],
            ["Faggiano", "TA"],
            ["Montemesola", "TA"],
            ["Roccaforzata", "TA"],
            ["Lizzano", "TA"],
            ["Avetrana", "TA"],
            ["Maruggio", "TA"],
            ["Monteiasi", "TA"],
        ],
        "74021": [["Carosino", "TA"]],
        "74022": [["Fragagnano", "TA"]],
        "74023": [["Grottaglie", "TA"]],
        "74024": [
            ["Uggiano Montefusco", "TA"],
            ["Manduria", "TA"],
            ["San Pietro In Bevagna", "TA"],
            ["Specchiarica", "TA"],
        ],
        "74025": [["Marina Di Ginosa", "TA"]],
        "74026": [["Lido Silvana", "TA"], ["Pulsano", "TA"], ["Bosco Caggione", "TA"], ["Monti D'Arena", "TA"]],
        "74027": [["San Giorgio Ionico", "TA"]],
        "74028": [["Sava", "TA"]],
        "74100": [["Paolo Vi", "TA"], ["Talsano", "TA"], ["San Vito Taranto", "TA"], ["Taranto", "TA"], ["Lama", "TA"]],
        "74121": [["Taranto", "TA"]],
        "74122": [["Taranto", "TA"]],
        "74123": [["Taranto", "TA"]],
        "08030": [
            ["Orroli", "CA"],
            ["Escolca", "CA"],
            ["Lixius", "CA"],
            ["Nurallao", "CA"],
            ["Serri", "CA"],
            ["Sadali", "CA"],
            ["Seulo", "CA"],
            ["Nuragus", "CA"],
            ["Villanova Tulo", "CA"],
            ["Esterzili", "CA"],
            ["Gergei", "CA"],
            ["Meana Sardo", "NU"],
            ["Atzara", "NU"],
            ["Austis", "NU"],
            ["Gadoni", "NU"],
            ["Belvi", "NU"],
            ["Teti", "NU"],
            ["Genoni", "OR"],
        ],
        "08033": [["Isili", "CA"]],
        "08035": [["Nurri", "CA"]],
        "08043": [["Escalaplano", "CA"]],
        "09010": [
            ["Siliqua", "CA"],
            ["Forte Village", "CA"],
            ["Vallermosa", "CA"],
            ["Villaspeciosa", "CA"],
            ["Decimoputzu", "CA"],
            ["Domus De Maria", "CA"],
            ["Pula", "CA"],
            ["Uta", "CA"],
            ["Villa San Pietro", "CA"],
            ["Buggerru", "SU"],
            ["Villamassargia", "SU"],
            ["Sant'Anna Arresi", "SU"],
            ["Palmas", "SU"],
            ["Masainas", "SU"],
            ["San Giovanni Suergiu", "SU"],
            ["Giba", "SU"],
            ["Rosas", "SU"],
            ["Musei", "SU"],
            ["Terraseo", "SU"],
            ["Matzaccara", "SU"],
            ["Gonnesa", "SU"],
            ["Terresoli", "SU"],
            ["Fluminimaggiore", "SU"],
            ["Nuraxi Figus", "SU"],
            ["Is Urigus", "SU"],
            ["Riomurtas", "SU"],
            ["Piscinas", "SU"],
            ["Portoscuso", "SU"],
            ["Perdaxius", "SU"],
            ["Villarios", "SU"],
            ["Villaperuccio", "SU"],
            ["Paringianu", "SU"],
            ["Narcao", "SU"],
            ["Tratalias", "SU"],
            ["Nuxis", "SU"],
            ["Santadi", "SU"],
        ],
        "09012": [["San Leone", "CA"], ["Capoterra", "CA"], ["Poggio Dei Pini", "CA"], ["La Maddalena", "CA"]],
        "09018": [["Villa D'Orri", "CA"], ["Sarroch", "CA"]],
        "09019": [["Teulada", "CA"]],
        "09020": [
            ["Samatzai", "CA"],
            ["Pimentel", "CA"],
            ["Ussana", "CA"],
            ["Pauli Arbarei", "SU"],
            ["Ussaramanna", "SU"],
            ["Turri", "SU"],
            ["Genuri", "SU"],
            ["Villamar", "SU"],
            ["Siddi", "SU"],
            ["Villanovafranca", "SU"],
            ["Gesturi", "SU"],
            ["Collinas", "SU"],
            ["Las Plassas", "SU"],
            ["Villanovaforru", "SU"],
        ],
        "09023": [["Monastir", "CA"]],
        "09024": [["Villagreca", "CA"], ["Nuraminis", "CA"]],
        "09026": [["San Sperate", "CA"]],
        "09028": [["Sestu", "CA"]],
        "09030": [["Elmas", "CA"], ["Pabillonis", "SU"], ["Sardara", "SU"], ["Montevecchio", "SU"], ["Samassi", "SU"]],
        "09032": [["Assemini", "CA"], ["Macchiareddu", "CA"]],
        "09033": [["Decimomannu", "CA"]],
        "09034": [["Villasor", "CA"]],
        "09040": [
            ["Armungia", "CA"],
            ["Villasalto", "CA"],
            ["Maracalagonis", "CA"],
            ["Senorbi'", "CA"],
            ["Donori'", "CA"],
            ["Settimo San Pietro", "CA"],
            ["Suelli", "CA"],
            ["Goni", "CA"],
            ["Selegas", "CA"],
            ["Gesico", "CA"],
            ["San Vito", "CA"],
            ["Silius", "CA"],
            ["Siurgus Donigala", "CA"],
            ["Guamaggiore", "CA"],
            ["Guasila", "CA"],
            ["Santa Maria", "CA"],
            ["Arixi", "CA"],
            ["Barrali", "CA"],
            ["Mandas", "CA"],
            ["Soleminis", "CA"],
            ["Ballao", "CA"],
            ["Villaputzu", "CA"],
            ["Burcei", "CA"],
            ["Sant'Andrea Frius", "CA"],
            ["Castiadas", "CA"],
            ["Serdiana", "CA"],
            ["Sisini", "CA"],
            ["San Nicolo' Gerrei", "CA"],
            ["Ortacesus", "CA"],
            ["San Basilio", "CA"],
            ["Furtei", "SU"],
            ["Segariu", "SU"],
        ],
        "09041": [["Dolianova", "CA"]],
        "09042": [["Monserrato", "CA"]],
        "09043": [["Muravera", "CA"]],
        "09044": [["Quartucciu", "CA"]],
        "09045": [["Flumini Di Quartu Sant'Elena", "CA"], ["Quartu Sant'Elena", "CA"]],
        "09047": [["Selargius", "CA"], ["Su Planu", "CA"]],
        "09048": [["Sinnai", "CA"]],
        "09049": [["Villasimius", "CA"]],
        "09100": [["Cagliari", "CA"]],
        "09121": [["Cagliari", "CA"]],
        "09122": [["Cagliari", "CA"]],
        "09123": [["Cagliari", "CA"]],
        "09124": [["Cagliari", "CA"]],
        "09125": [["Cagliari", "CA"]],
        "09126": [
            ["Cagliari", "CA"],
            ["Cala Mosca", "CA"],
            ["San Bartolomeo", "CA"],
            ["Lazzaretto", "CA"],
            ["Poetto", "CA"],
        ],
        "09127": [["Cagliari", "CA"]],
        "09128": [["Cagliari", "CA"]],
        "09129": [["Cagliari", "CA"]],
        "09131": [["Cagliari", "CA"]],
        "09134": [["Cagliari", "CA"], ["Pirri", "CA"]],
        "08010": [
            ["Lei", "NU"],
            ["Birori", "NU"],
            ["Noragugume", "NU"],
            ["Dualchi", "NU"],
            ["Santa Maria", "OR"],
            ["Suni", "OR"],
            ["Magomadas", "OR"],
            ["Sa Lumenera", "OR"],
            ["Sagama", "OR"],
            ["Flussio", "OR"],
            ["Montresta", "OR"],
            ["Tinnura", "OR"],
        ],
        "08011": [["Bolotana", "NU"]],
        "08012": [["Bortigali", "NU"], ["Mulargia", "NU"]],
        "08015": [["Macomer", "NU"]],
        "08016": [["Borore", "NU"]],
        "08017": [["Silanus", "NU"]],
        "08018": [["Sindia", "NU"]],
        "08020": [
            ["Onifai", "NU"],
            ["Su Cossu", "NU"],
            ["Sa Pala Ruia", "NU"],
            ["Ottana", "NU"],
            ["Onani", "NU"],
            ["San Giovanni", "NU"],
            ["Ovodda", "NU"],
            ["Sant'Efisio", "NU"],
            ["Monte Longu", "NU"],
            ["Tiana", "NU"],
            ["S'Ena Sa Chitta", "NU"],
            ["Olzai", "NU"],
            ["Orotelli", "NU"],
            ["Sarule", "NU"],
            ["Ovedi'", "NU"],
            ["Orune", "NU"],
            ["Berchidda", "NU"],
            ["Lodine", "NU"],
            ["Galtelli", "NU"],
            ["Oniferi", "NU"],
            ["Sas Murtas", "NU"],
            ["Su Pradu", "NU"],
            ["Concas", "NU"],
            ["Osidda", "NU"],
            ["Torpe'", "NU"],
            ["Ollolai", "NU"],
            ["Gavoi", "NU"],
            ["Brunella", "NU"],
            ["Lode'", "NU"],
            ["Talava'", "NU"],
            ["Irgoli", "NU"],
            ["Mamone", "NU"],
            ["Lula", "NU"],
            ["Loculi", "NU"],
            ["Posada", "NU"],
            ["Muvruneddi", "SS"],
            ["S'Iscala", "SS"],
            ["Straulas", "SS"],
            ["San Gavino", "SS"],
            ["Agrustos", "SS"],
            ["Luddui", "SS"],
            ["Tanaunella", "SS"],
            ["Nuditta", "SS"],
            ["Birgalavo'", "SS"],
            ["Budoni", "SS"],
            ["San Lorenzo", "SS"],
            ["Malamori'", "SS"],
            ["Lu Cuponeddi", "SS"],
            ["Pedra E Cupa", "SS"],
            ["La Runcina", "SS"],
            ["Lu Ricciu", "SS"],
            ["Bircolovo'", "SS"],
            ["Silimini", "SS"],
            ["Lutturai", "SS"],
            ["Lu Impostu", "SS"],
            ["Schifoni", "SS"],
            ["Lu Sitagliacciu", "SS"],
            ["Franculacciu", "SS"],
            ["La Traversa", "SS"],
            ["Stazzu Mesu", "SS"],
            ["Strugas", "SS"],
            ["Pira Maseda", "SS"],
            ["Lu Tintimbaru", "SS"],
            ["Pattimedda", "SS"],
            ["Terrapadedda", "SS"],
            ["Tiridduli", "SS"],
            ["Li Mori", "SS"],
            ["Budditogliu", "SS"],
            ["Lu Muvruneddu", "SS"],
            ["Lotturai", "SS"],
            ["Stazzu Bruciatu", "SS"],
            ["Su Linalvu", "SS"],
            ["Rinaggiu", "SS"],
            ["Suaredda", "SS"],
            ["Limpostu", "SS"],
            ["Lu Titimbaru", "SS"],
            ["Traversa", "SS"],
            ["Sitagliacciu", "SS"],
            ["L'Alzoni", "SS"],
            ["Li Teggi", "SS"],
            ["Nuragheddu", "SS"],
            ["Ottiolu", "SS"],
            ["Muriscuvo'", "SS"],
            ["San Pietro", "SS"],
            ["Puntaldia", "SS"],
            ["Lu Lioni", "SS"],
            ["Maiorca", "SS"],
            ["Tamarispa", "SS"],
            ["Capo Coda Cavallo", "SS"],
            ["Lu Fraili", "SS"],
            ["San Silvestro", "SS"],
            ["Solita'", "SS"],
            ["Badualga", "SS"],
            ["Monte Petrosu", "SS"],
            ["Limpiddu", "SS"],
            ["Luttuni", "SS"],
            ["Berruiles", "SS"],
        ],
        "08021": [["Bitti", "NU"]],
        "08022": [["Dorgali", "NU"], ["Cala Gonone", "NU"]],
        "08023": [["Fonni", "NU"]],
        "08024": [["Mamoiada", "NU"]],
        "08025": [["Oliena", "NU"], ["Su Cologone", "NU"]],
        "08026": [["Orani", "NU"]],
        "08027": [["Orgosolo", "NU"]],
        "08028": [
            ["Cala Liberotto", "NU"],
            ["Orosei", "NU"],
            ["Sos Alinos", "NU"],
            ["Sas Linnas Siccas", "NU"],
            ["Cala Ginepro", "NU"],
        ],
        "08029": [
            ["Siniscola", "NU"],
            ["Sa Pischera", "NU"],
            ["Sarenargiu", "NU"],
            ["Su Tilio'", "NU"],
            ["La Caletta", "NU"],
            ["Sa Perta Ruia", "NU"],
            ["Berchida", "NU"],
            ["Capo Comino", "NU"],
            ["Mandras", "NU"],
            ["Ena Sa Chitta", "NU"],
            ["Overì", "NU"],
            ["Santa Lucia", "NU"],
        ],
        "08031": [["Gidilau", "NU"], ["Aritzo", "NU"]],
        "08032": [["Desulo", "NU"]],
        "08036": [["Ortueri", "NU"]],
        "08037": [["Seui", "NU"]],
        "08038": [["Sorgono", "NU"]],
        "08039": [["Tonara", "NU"]],
        "08040": [
            ["S'Arridellu", "NU"],
            ["Girasole", "NU"],
            ["Arzana", "NU"],
            ["Urzulei", "NU"],
            ["Ardali", "NU"],
            ["Gairo", "NU"],
            ["Osini", "NU"],
            ["Santa Maria Navarrese", "NU"],
            ["Ussassai", "NU"],
            ["Tancau", "NU"],
            ["Baunei", "NU"],
            ["Loceri", "NU"],
            ["Ulassai", "NU"],
            ["Gairo Sant'Elena", "NU"],
            ["Lotzorai", "NU"],
            ["Triei", "NU"],
            ["Taquisara", "NU"],
            ["Talana", "NU"],
            ["Cardedu", "NU"],
            ["Elini", "NU"],
            ["Ilbono", "NU"],
            ["Tancau Sul Mare", "NU"],
        ],
        "08042": [["Bari Sardo", "NU"]],
        "08044": [["Jerzu", "NU"]],
        "08045": [["Lanusei", "NU"]],
        "08046": [["Perdasdefogu", "NU"]],
        "08047": [["Migheli", "NU"], ["Tertenia", "NU"]],
        "08048": [
            ["Su Troccu", "NU"],
            ["Porto Frailis", "NU"],
            ["Calamoresca", "NU"],
            ["Tortoli'", "NU"],
            ["Su Pinu", "NU"],
            ["Arbatax", "NU"],
            ["Is Murdegus", "NU"],
        ],
        "08049": [["Villanova Strisaili", "NU"], ["Villagrande Strisaili", "NU"]],
        "08100": [["Nuoro", "NU"], ["Monte Ortobene", "NU"], ["Manasuddas", "NU"], ["Lollove", "NU"]],
        "08013": [["Turas", "OR"], ["Bosa Marina", "OR"], ["Bosa", "OR"]],
        "08019": [["Modolo", "OR"]],
        "08034": [["Santa Sofia", "OR"], ["Crastu", "OR"], ["Su Lau", "OR"], ["Traidodini", "OR"], ["Laconi", "OR"]],
        "09070": [
            ["Sa Rocca Tunda", "OR"],
            ["Bauladu", "OR"],
            ["Norbello", "OR"],
            ["Zeddiani", "OR"],
            ["Rocca Tunda", "OR"],
            ["Siamaggiore", "OR"],
            ["Seneghe", "OR"],
            ["San Vero Milis", "OR"],
            ["Putzu Idu", "OR"],
            ["Pardu Nou", "OR"],
            ["Baratili San Pietro", "OR"],
            ["Bonarcado", "OR"],
            ["Zerfaliu", "OR"],
            ["Riola Sardo", "OR"],
            ["Narbolia", "OR"],
            ["Mandriola", "OR"],
            ["Milis", "OR"],
            ["Nurachi", "OR"],
            ["Domusnovas Canales", "OR"],
            ["Paulilatino", "OR"],
            ["Tramatza", "OR"],
            ["Aidomaggiore", "OR"],
        ],
        "09071": [["Abbasanta", "OR"]],
        "09072": [["Solanas", "OR"], ["Cabras", "OR"]],
        "09073": [
            ["Santa Caterina Di Pittinurri", "OR"],
            ["Santa Caterina", "OR"],
            ["S'Archittu", "OR"],
            ["Cuglieri", "OR"],
            ["Torre Del Pozzo", "OR"],
        ],
        "09074": [["Zuri", "OR"], ["Ghilarza", "OR"]],
        "09075": [["San Leonardo", "OR"], ["Santu Lussurgiu", "OR"]],
        "09076": [["Sedilo", "OR"]],
        "09077": [["Solarussa", "OR"]],
        "09078": [["Sennariolo", "OR"], ["Scano Di Montiferro", "OR"]],
        "09079": [["Tresnuraghes", "OR"]],
        "09080": [
            ["Sorradile", "OR"],
            ["Soddi'", "OR"],
            ["Bidoni'", "OR"],
            ["Senis", "OR"],
            ["Neoneli", "OR"],
            ["Siapiccia", "OR"],
            ["Sant'Antonio Ruinas", "OR"],
            ["Villa Sant'Antonio", "OR"],
            ["Boroneddu", "OR"],
            ["Siamanna", "OR"],
            ["Ula' Tirso", "OR"],
            ["Villaurbana", "OR"],
            ["Nughedu Santa Vittoria", "OR"],
            ["Mogorella", "OR"],
            ["Nureci", "OR"],
            ["Assolo", "OR"],
            ["Allai", "OR"],
            ["Asuni", "OR"],
            ["Tadasuni", "OR"],
        ],
        "09081": [["Ardauli", "OR"]],
        "09082": [["Busachi", "OR"]],
        "09083": [["Fordongianus", "OR"]],
        "09084": [["Villanova Truschedu", "OR"]],
        "09085": [["Ruinas", "OR"]],
        "09086": [["Samugheo", "OR"]],
        "09088": [["Ollastra", "OR"], ["Simaxis", "OR"]],
        "09090": [
            ["Gonnoscodina", "OR"],
            ["Palmas Arborea", "OR"],
            ["Baressa", "OR"],
            ["Morgongiori", "OR"],
            ["Albagiara", "OR"],
            ["Sini", "OR"],
            ["Baradili", "OR"],
            ["Curcuris", "OR"],
            ["Masullas", "OR"],
            ["Pau", "OR"],
            ["Tiria", "OR"],
            ["Siris", "OR"],
            ["Gonnosno'", "OR"],
            ["Usellus", "OR"],
            ["Simala", "OR"],
            ["Villa Verde", "OR"],
        ],
        "09091": [["Ales", "OR"]],
        "09092": [["Arborea", "OR"]],
        "09093": [["Gonnostramatza", "OR"], ["Pompu", "OR"]],
        "09094": [["Marrubiu", "OR"], ["Sant'Anna", "OR"]],
        "09095": [["Mogoro", "OR"]],
        "09096": [["Santa Giusta", "OR"]],
        "09097": [["San Nicolo' D'Arcidano", "OR"]],
        "09098": [["Tanca Marchese", "OR"], ["Terralba", "OR"]],
        "09099": [["Uras", "OR"]],
        "09170": [
            ["Massama", "OR"],
            ["Oristano", "OR"],
            ["Donigala Fenughedu", "OR"],
            ["Nuraxinieddu", "OR"],
            ["Sili'", "OR"],
            ["Torre Grande", "OR"],
        ],
        "07010": [
            ["Benetutti", "SS"],
            ["Bottidda", "SS"],
            ["Nughedu San Nicolo'", "SS"],
            ["Romana", "SS"],
            ["Nule", "SS"],
            ["Mara", "SS"],
            ["Bultei", "SS"],
            ["Tula", "SS"],
            ["Foresta Burgos", "SS"],
            ["Cossoine", "SS"],
            ["Giave", "SS"],
            ["Foresta Di Burgos", "SS"],
            ["Semestene", "SS"],
            ["Burgos", "SS"],
            ["Ardara", "SS"],
            ["Anela", "SS"],
            ["Illorai", "SS"],
            ["Esporlatu", "SS"],
            ["Ittireddu", "SS"],
            ["Monteleone Rocca Doria", "SS"],
        ],
        "07011": [["Bono", "SS"]],
        "07012": [["Rebeccu", "SS"], ["Santa Lucia", "SS"], ["Bonorva", "SS"]],
        "07013": [["Mores", "SS"]],
        "07014": [["San Nicola", "SS"], ["Chilivani", "SS"], ["Ozieri", "SS"], ["Vigne", "SS"], ["Fraigas", "SS"]],
        "07015": [["Padria", "SS"]],
        "07016": [["Pattada", "SS"]],
        "07017": [["Ploaghe", "SS"]],
        "07018": [["Pozzomaggiore", "SS"]],
        "07019": [["Villanova Monteleone", "SS"]],
        "07020": [
            ["Budduso'", "SS"],
            ["Porto San Paolo", "SS"],
            ["Vaccileddi", "SS"],
            ["Padru", "SS"],
            ["Golfo Aranci", "SS"],
            ["Ala' Dei Sardi", "SS"],
            ["Monti", "SS"],
            ["Luogosanto", "SS"],
            ["Su Canale", "SS"],
            ["Telti", "SS"],
            ["Loiri", "SS"],
            ["San Francesco D'Aglientu", "SS"],
            ["Aglientu", "SS"],
            ["Palau", "SS"],
            ["Loiri Porto San Paolo", "SS"],
            ["Aggius", "SS"],
        ],
        "07021": [
            ["Pirazzolu", "SS"],
            ["Costa Smeralda", "SS"],
            ["Capo Ferro", "SS"],
            ["Cala Di Volpe", "SS"],
            ["Cannigione", "SS"],
            ["Baia Sardinia", "SS"],
            ["Arzachena", "SS"],
            ["Porto Cervo", "SS"],
        ],
        "07022": [["Berchidda", "SS"]],
        "07023": [["Calangianus", "SS"]],
        "07024": [["Moneta", "SS"], ["Isola Di Caprera", "SS"], ["La Maddalena", "SS"]],
        "07025": [["Luras", "SS"]],
        "07026": [["San Pantaleo", "SS"], ["Porto Rotondo", "SS"], ["Olbia", "SS"], ["Berchiddeddu", "SS"]],
        "07027": [["Oschiri", "SS"]],
        "07028": [["San Pasquale", "SS"], ["Santa Teresa Gallura", "SS"]],
        "07029": [["Tempio Pausania", "SS"], ["Nuchis", "SS"], ["Bassacutena", "SS"]],
        "07030": [
            ["Martis", "SS"],
            ["Chiaramonti", "SS"],
            ["Tergu", "SS"],
            ["Santa Maria Coghinas", "SS"],
            ["Bortigiadas", "SS"],
            ["Muros", "SS"],
            ["Florinas", "SS"],
            ["Badesi", "SS"],
            ["Sant'Antonio Di Gallura", "SS"],
            ["Viddalba", "SS"],
            ["Erula", "SS"],
            ["Cargeghe", "SS"],
            ["Bulzi", "SS"],
            ["Laerru", "SS"],
        ],
        "07031": [["Lu Bagnu", "SS"], ["Castelsardo", "SS"]],
        "07032": [["Nulvi", "SS"]],
        "07033": [["Osilo", "SS"], ["Santa Vittoria", "SS"]],
        "07034": [["Perfugas", "SS"]],
        "07035": [["Sedini", "SS"]],
        "07036": [["Sennori", "SS"]],
        "07037": [["Platamona", "SS"], ["Sorso", "SS"]],
        "07038": [["Lu Colbu", "SS"], ["Trinita' D'Agultu E Vignola", "SS"]],
        "07039": [["La Muddizza", "SS"], ["Valledoria", "SS"], ["Codaruina", "SS"]],
        "07040": [
            ["Tissi", "SS"],
            ["Tottubella", "SS"],
            ["Campanedda", "SS"],
            ["Palmadula", "SS"],
            ["Canaglia", "SS"],
            ["Argentiera Nurra", "SS"],
            ["Siligo", "SS"],
            ["Codrongianos", "SS"],
            ["Stintino", "SS"],
            ["Rumanedda", "SS"],
            ["Olmedo", "SS"],
            ["La Corte", "SS"],
            ["Argentiera", "SS"],
            ["Borutta", "SS"],
            ["Uri", "SS"],
            ["Bessude", "SS"],
            ["Putifigari", "SS"],
            ["Cheremule", "SS"],
            ["Biancareddu", "SS"],
            ["Banari", "SS"],
        ],
        "07041": [
            ["Alghero", "SS"],
            ["Santa Maria La Palma", "SS"],
            ["Maristella Porto Conte", "SS"],
            ["Fertilia", "SS"],
            ["Tramariglio", "SS"],
        ],
        "07043": [["Bonnanaro", "SS"]],
        "07044": [["Ittiri", "SS"]],
        "07045": [["Ossi", "SS"]],
        "07046": [
            ["Asinara Cala D'Oliva", "SS"],
            ["Porto Torres", "SS"],
            ["Cala Reale", "SS"],
            ["Asinara Lazzaretto", "SS"],
        ],
        "07047": [["Thiesi", "SS"]],
        "07048": [["Torralba", "SS"]],
        "07049": [["Usini", "SS"]],
        "07100": [
            ["Sassari", "SS"],
            ["Ottava", "SS"],
            ["La Landrigga", "SS"],
            ["Li Punti", "SS"],
            ["San Giovanni", "SS"],
            ["Bancali", "SS"],
            ["Macciadosa", "SS"],
        ],
        "09011": [["Calasetta", "SU"], ["Cussorgia", "SU"]],
        "09013": [
            ["Bacu Abis", "SU"],
            ["Sirai", "SU"],
            ["Barbusi", "SU"],
            ["Carbonia", "SU"],
            ["Cortoghiana", "SU"],
            ["Serbariu", "SU"],
        ],
        "09014": [["Carloforte", "SU"]],
        "09015": [["Domusnovas", "SU"]],
        "09016": [["Nebida", "SU"], ["Iglesias", "SU"], ["San Benedetto", "SU"], ["Bindua", "SU"], ["Monteponi", "SU"]],
        "09017": [["Sant'Antioco", "SU"]],
        "09021": [["Barumini", "SU"]],
        "09022": [["Lunamatrona", "SU"]],
        "09025": [["Sanluri Stato", "SU"], ["Sanluri", "SU"]],
        "09027": [["Serrenti", "SU"]],
        "09029": [["Tuili", "SU"], ["Setzu", "SU"]],
        "09031": [["Gennamari", "SU"], ["Sant'Antonio Di Santadi", "SU"], ["Arbus", "SU"], ["Ingurtosu", "SU"]],
        "09035": [["Gonnosfanadiga", "SU"]],
        "09036": [["Guspini", "SU"]],
        "09037": [["San Gavino Monreale", "SU"]],
        "09038": [["Serramanna", "SU"]],
        "09039": [["Villacidro", "SU"]],
        "92010": [
            ["Burgio", "AG"],
            ["Lampedusa", "AG"],
            ["Caltabellotta", "AG"],
            ["Calamonaci", "AG"],
            ["Realmonte", "AG"],
            ["Lucca Sicula", "AG"],
            ["Lampedusa E Linosa", "AG"],
            ["Joppolo Giancaxio", "AG"],
            ["Linosa", "AG"],
            ["Alessandria Della Rocca", "AG"],
            ["Montevago", "AG"],
            ["Sant'Anna Di Caltabellotta", "AG"],
            ["Siculiana", "AG"],
            ["Sant'Anna", "AG"],
            ["Montallegro", "AG"],
            ["Bivona", "AG"],
        ],
        "92011": [["Cattolica Eraclea", "AG"]],
        "92012": [["Cianciana", "AG"]],
        "92013": [["Menfi", "AG"]],
        "92014": [["Porto Empedocle", "AG"]],
        "92015": [["Raffadali", "AG"]],
        "92016": [["Borgo Bonsignore", "AG"], ["Ribera", "AG"]],
        "92017": [["Sambuca Di Sicilia", "AG"]],
        "92018": [["Santa Margherita Di Belice", "AG"]],
        "92019": [["Sciacca", "AG"]],
        "92020": [
            ["Santa Elisabetta", "AG"],
            ["San Giovanni Gemini", "AG"],
            ["Villafranca Sicula", "AG"],
            ["San Biagio Platani", "AG"],
            ["Sant'Angelo Muxaro", "AG"],
            ["Castrofilippo", "AG"],
            ["Racalmuto", "AG"],
            ["Comitini", "AG"],
            ["Camastra", "AG"],
            ["Grotte", "AG"],
            ["Santo Stefano Quisquina", "AG"],
            ["Palma Di Montechiaro", "AG"],
        ],
        "92021": [["Aragona", "AG"], ["Caldare", "AG"]],
        "92022": [["Borgo Callea", "AG"], ["Cammarata", "AG"]],
        "92023": [["Campobello Di Licata", "AG"]],
        "92024": [["Canicatti'", "AG"]],
        "92025": [["Zolfare", "AG"], ["Casteltermini Zolfare", "AG"], ["Casteltermini", "AG"]],
        "92026": [["Favara", "AG"]],
        "92027": [["Licata", "AG"]],
        "92028": [["Naro", "AG"]],
        "92029": [["Campobello Ravanusa Stazione", "AG"], ["Ravanusa", "AG"]],
        "92100": [
            ["Giardina Gallotti", "AG"],
            ["Villaggio Mose'", "AG"],
            ["Villaseta", "AG"],
            ["San Leone Mose'", "AG"],
            ["Agrigento", "AG"],
            ["Montaperto", "AG"],
            ["Borgo La Loggia", "AG"],
        ],
        "93010": [
            ["Campofranco", "CL"],
            ["Sutera", "CL"],
            ["Bompensiere", "CL"],
            ["Acquaviva Platani", "CL"],
            ["Vallelunga Pratameno", "CL"],
            ["Serradifalco", "CL"],
            ["Milena", "CL"],
            ["Montedoro", "CL"],
            ["Villalba", "CL"],
            ["Marianopoli", "CL"],
            ["Resuttano", "CL"],
            ["Delia", "CL"],
        ],
        "93011": [["Butera", "CL"]],
        "93012": [["Gela", "CL"]],
        "93013": [["Mazzarino", "CL"]],
        "93014": [["Polizzello", "CL"], ["Mussomeli", "CL"]],
        "93015": [["Niscemi", "CL"]],
        "93016": [["Riesi", "CL"]],
        "93017": [["San Cataldo", "CL"]],
        "93018": [["Santa Caterina Villarmosa", "CL"]],
        "93019": [["Trabia Miniere", "CL"], ["Sommatino", "CL"]],
        "93100": [
            ["Favarella", "CL"],
            ["Villaggio Santa Barbara", "CL"],
            ["Borgo Petilia", "CL"],
            ["Caltanissetta", "CL"],
        ],
        "95010": [
            ["Santa Venerina", "CT"],
            ["Milo", "CT"],
            ["Sant'Alfio", "CT"],
            ["Dagala Del Re", "CT"],
            ["Fornazzo", "CT"],
            ["Linera", "CT"],
        ],
        "95011": [["Pasteria", "CT"], ["Calatabiano", "CT"]],
        "95012": [
            ["Solicchiata", "CT"],
            ["Passopisciaro", "CT"],
            ["Mitogio", "CT"],
            ["Verzella", "CT"],
            ["Castiglione Di Sicilia", "CT"],
        ],
        "95013": [["Fiumefreddo Di Sicilia", "CT"]],
        "95014": [
            ["Trepunti", "CT"],
            ["Carruba", "CT"],
            ["San Giovanni", "CT"],
            ["Giarre", "CT"],
            ["San Leonardello", "CT"],
            ["Altarello", "CT"],
            ["San Giovanni Montebello", "CT"],
            ["Macchia Di Giarre", "CT"],
        ],
        "95015": [["Linguaglossa", "CT"]],
        "95016": [
            ["Puntalazzo", "CT"],
            ["Carrabba", "CT"],
            ["Portosalvo", "CT"],
            ["Santa Venera", "CT"],
            ["Nunziata", "CT"],
            ["Mascali", "CT"],
        ],
        "95017": [["Presa", "CT"], ["Vena", "CT"], ["Piedimonte Etneo", "CT"]],
        "95018": [["Torre Archirafi", "CT"], ["Riposto", "CT"]],
        "95019": [["Pisano Etneo", "CT"], ["Fleri", "CT"], ["Sarro", "CT"], ["Zafferana Etnea", "CT"]],
        "95020": [["Aci Bonaccorsi", "CT"]],
        "95021": [["Ficarazzi", "CT"], ["Aci Trezza", "CT"], ["Cannizzaro", "CT"], ["Aci Castello", "CT"]],
        "95022": [
            ["Vampolieri", "CT"],
            ["Nizzeti", "CT"],
            ["Aci Catena", "CT"],
            ["Aci San Filippo", "CT"],
            ["San Nicolo'", "CT"],
            ["Eremo Sant'Anna", "CT"],
        ],
        "95024": [
            ["Santa Tecla Di Acireale", "CT"],
            ["Acireale", "CT"],
            ["Santa Maria Degli Ammalati", "CT"],
            ["Pozzillo", "CT"],
            ["Guardia", "CT"],
            ["Pennisi", "CT"],
            ["Aci Platani", "CT"],
            ["Stazzo", "CT"],
            ["Mangano", "CT"],
            ["Piano D'Api", "CT"],
            ["Scillichenti", "CT"],
            ["Santa Maria La Scala", "CT"],
        ],
        "95025": [
            ["Aci Sant'Antonio", "CT"],
            ["Lavina", "CT"],
            ["Monterosso Etneo", "CT"],
            ["Santa Maria La Stella", "CT"],
            ["Monterosso", "CT"],
            ["Lavinaio", "CT"],
        ],
        "95027": [["Cerza", "CT"], ["San Gregorio Di Catania", "CT"]],
        "95028": [["Valverde", "CT"]],
        "95029": [["Viagrande", "CT"]],
        "95030": [
            ["Sant'Agata Li Battiati", "CT"],
            ["Nicolosi", "CT"],
            ["San Pietro Clarenza", "CT"],
            ["Mascalucia", "CT"],
            ["Ragalna", "CT"],
            ["Tremestieri Etneo", "CT"],
            ["Maniace", "CT"],
            ["Pedara", "CT"],
            ["Canalicchio", "CT"],
            ["Gravina Di Catania", "CT"],
        ],
        "95031": [["Adrano", "CT"]],
        "95032": [
            ["Belpasso", "CT"],
            ["Borrello Di Catania", "CT"],
            ["Villaggio Le Ginestre", "CT"],
            ["Villaggio Del Pino", "CT"],
            ["Piano Tavola", "CT"],
            ["Palazzolo", "CT"],
        ],
        "95033": [["Biancavilla", "CT"]],
        "95034": [["Bronte", "CT"]],
        "95035": [["Maletto", "CT"]],
        "95036": [["Randazzo", "CT"], ["Calderara", "CT"]],
        "95037": [["San Giovanni La Punta", "CT"], ["Trappeto", "CT"]],
        "95038": [["Santa Maria Di Licodia", "CT"]],
        "95039": [["Trecastagni", "CT"]],
        "95040": [
            ["Castel Di Iudica", "CT"],
            ["Motta Sant'Anastasia", "CT"],
            ["Libertinia", "CT"],
            ["Licodia Eubea", "CT"],
            ["Giumarra", "CT"],
            ["Mazzarrone", "CT"],
            ["San Cono", "CT"],
            ["San Michele Di Ganzaria", "CT"],
            ["Raddusa", "CT"],
            ["Cinquegrana", "CT"],
            ["Mirabella Imbaccari", "CT"],
            ["Camporotondo Etneo", "CT"],
            ["Ramacca", "CT"],
            ["Carrubbo", "CT"],
        ],
        "95041": [
            ["Santo Pietro", "CT"],
            ["Caltagirone", "CT"],
            ["Granieri", "CT"],
            ["San Pietro Di Caltagirone", "CT"],
        ],
        "95042": [["Grammichele", "CT"]],
        "95043": [["Militello In Val Di Catania", "CT"]],
        "95044": [["Borgo Lupo", "CT"], ["Mineo", "CT"]],
        "95045": [["Misterbianco", "CT"], ["San Nullo", "CT"]],
        "95046": [["Palagonia", "CT"]],
        "95047": [["Paterno'", "CT"], ["Sferro", "CT"]],
        "95048": [["Scordia", "CT"]],
        "95049": [["Vizzini", "CT"]],
        "95100": [["Catania", "CT"]],
        "95121": [
            ["Catania", "CT"],
            ["Zia Lisa", "CT"],
            ["San Teodoro", "CT"],
            ["San Giorgio", "CT"],
            ["San Giuseppe Alla Rena", "CT"],
            ["Santa Maria Goretti", "CT"],
            ["Fontanarossa Aereoporto", "CT"],
        ],
        "95122": [["Nesima Inferiore", "CT"], ["Acquicella", "CT"], ["Nesima Superiore", "CT"], ["Catania", "CT"]],
        "95123": [["Catania", "CT"], ["San Nullo", "CT"], ["Cibali", "CT"]],
        "95124": [["Catania", "CT"]],
        "95125": [["Catania", "CT"], ["Canalicchio", "CT"], ["Barriera Del Bosco", "CT"]],
        "95126": [["Ognina", "CT"], ["Catania", "CT"]],
        "95127": [["Catania", "CT"], ["Picanello", "CT"]],
        "95128": [["Catania", "CT"]],
        "95129": [["Catania", "CT"]],
        "95131": [["Catania", "CT"]],
        "94010": [
            ["San Giorgio", "EN"],
            ["Assoro", "EN"],
            ["Nissoria", "EN"],
            ["Calascibetta", "EN"],
            ["Cacchiamo", "EN"],
            ["Borgo Baccarato", "EN"],
            ["Gagliano Castelferrato", "EN"],
            ["Sperlinga", "EN"],
            ["Cerami", "EN"],
            ["Centuripe", "EN"],
            ["Villarosa", "EN"],
            ["Catenanuova", "EN"],
            ["Villapriolo", "EN"],
            ["Aidone", "EN"],
        ],
        "94011": [["Agira", "EN"]],
        "94012": [["Barrafranca", "EN"]],
        "94013": [["Leonforte", "EN"]],
        "94014": [["Nicosia", "EN"], ["Villadoro", "EN"], ["San Giacomo", "EN"]],
        "94015": [["Grottacalda", "EN"], ["Piazza Armerina", "EN"]],
        "94016": [["Pietraperzia", "EN"]],
        "94017": [["Regalbuto", "EN"]],
        "94018": [["Troina", "EN"]],
        "94019": [["Valguarnera Caropepe", "EN"]],
        "94100": [["Enna", "EN"], ["Pergusa", "EN"], ["Borgo Cascino", "EN"]],
        "98020": [["Rocchenere", "ME"], ["Pagliara", "ME"], ["Mandanici", "ME"], ["Ali'", "ME"], ["Locadi", "ME"]],
        "98021": [["Ali' Terme", "ME"]],
        "98022": [["Fiumedinisi", "ME"]],
        "98023": [["Furci Siculo", "ME"]],
        "98025": [["Itala", "ME"], ["Itala Marina", "ME"]],
        "98026": [["Nizza Di Sicilia", "ME"]],
        "98027": [["Sciglio", "ME"], ["Roccalumera", "ME"], ["Allume", "ME"]],
        "98028": [["Misserio", "ME"], ["Santa Teresa Di Riva", "ME"], ["Barracca", "ME"]],
        "98029": [
            ["Guidomandri Marina", "ME"],
            ["Guidomandri Superiore", "ME"],
            ["Scaletta Zanclea", "ME"],
            ["Guidomandri", "ME"],
        ],
        "98030": [
            ["San Teodoro", "ME"],
            ["Floresta", "ME"],
            ["Mongiuffi Melia", "ME"],
            ["Gallodoro", "ME"],
            ["Roccafiorita", "ME"],
            ["Mongiuffi", "ME"],
            ["Santa Domenica Vittoria", "ME"],
            ["Forza D'Agro'", "ME"],
            ["Sant'Alessio Siculo", "ME"],
            ["Limina", "ME"],
            ["Gaggi", "ME"],
            ["Motta Camastra", "ME"],
            ["Castelmola", "ME"],
            ["Roccella Valdemone", "ME"],
            ["Moio Alcantara", "ME"],
            ["Melia", "ME"],
            ["Antillo", "ME"],
            ["Malvagna", "ME"],
        ],
        "98031": [["Capizzi", "ME"]],
        "98032": [
            ["Misitano", "ME"],
            ["Misitano Superiore", "ME"],
            ["Casalvecchio Siculo", "ME"],
            ["Misitano Inferiore", "ME"],
        ],
        "98033": [["Cesaro'", "ME"]],
        "98034": [["Francavilla Di Sicilia", "ME"]],
        "98035": [["Naxos", "ME"], ["Giardini Naxos", "ME"], ["Pallio", "ME"]],
        "98036": [["Graniti", "ME"]],
        "98037": [["Letojanni", "ME"]],
        "98038": [["Rina", "ME"], ["Savoca", "ME"]],
        "98039": [
            ["Chianchitta", "ME"],
            ["Mazzeo", "ME"],
            ["Taormina", "ME"],
            ["Trappitello", "ME"],
            ["Mazzaro'", "ME"],
        ],
        "98040": [
            ["Fondachello", "ME"],
            ["Gualtieri Sicamino'", "ME"],
            ["Torregrotta", "ME"],
            ["Condro'", "ME"],
            ["Roccavaldina", "ME"],
            ["Venetico", "ME"],
            ["Venetico Superiore", "ME"],
            ["Venetico Marina", "ME"],
            ["Valdina", "ME"],
            ["Soccorso", "ME"],
            ["Scala Di Torregrotta", "ME"],
            ["Meri'", "ME"],
        ],
        "98041": [["Monforte San Giorgio", "ME"], ["Pellegrino", "ME"], ["Monforte Marina", "ME"]],
        "98042": [["Giammoro", "ME"], ["Pace Del Mela", "ME"]],
        "98043": [["Rometta", "ME"], ["Rometta Marea", "ME"], ["Gimello", "ME"], ["Sant'Andrea", "ME"]],
        "98044": [
            ["San Filippo Del Mela", "ME"],
            ["Archi", "ME"],
            ["Cattafi", "ME"],
            ["Olivarella", "ME"],
            ["Corriolo", "ME"],
        ],
        "98045": [["San Pier Marina", "ME"], ["San Pier Niceto", "ME"]],
        "98046": [["Santa Lucia Del Mela", "ME"]],
        "98047": [["Saponara Marittima", "ME"], ["Saponara", "ME"], ["Cavaliere", "ME"], ["Scarcelli", "ME"]],
        "98048": [["Spadafora", "ME"], ["San Martino Spadafora", "ME"], ["San Martino", "ME"]],
        "98049": [["Villafranca Tirrena", "ME"], ["Divieto", "ME"], ["Calvaruso", "ME"], ["Serro", "ME"]],
        "98050": [
            ["Filicudi", "ME"],
            ["Alicudi Porto", "ME"],
            ["Panarea", "ME"],
            ["Alicudi", "ME"],
            ["Rubino", "ME"],
            ["Castroreale Terme", "ME"],
            ["Malfa", "ME"],
            ["Vulcano", "ME"],
            ["Terme Vigliatore", "ME"],
            ["Vigliatore", "ME"],
            ["Fondachelli Fantina", "ME"],
            ["Lingua", "ME"],
            ["Ginostra", "ME"],
            ["Fantina", "ME"],
            ["Ginostra Di Lipari", "ME"],
            ["Filicudi Porto", "ME"],
            ["Pecorini A Mare", "ME"],
            ["Santa Marina Salina", "ME"],
            ["Leni", "ME"],
            ["Stromboli", "ME"],
            ["Evangelisti", "ME"],
            ["Vulcano Porto", "ME"],
        ],
        "98051": [
            ["San Paolo", "ME"],
            ["Pozzo Di Gotto", "ME"],
            ["La Gala", "ME"],
            ["Sant'Antonino Convento", "ME"],
            ["Caldera'", "ME"],
            ["Sant'Antonio", "ME"],
            ["Porto Salvo", "ME"],
            ["Barcellona Pozzo Di Gotto", "ME"],
            ["Cannistra'", "ME"],
            ["Gala", "ME"],
            ["Acquaficara", "ME"],
        ],
        "98053": [["Bafia", "ME"], ["Castroreale", "ME"], ["Protonotaro", "ME"]],
        "98054": [["Furnari", "ME"], ["Tonnarella", "ME"]],
        "98055": [
            ["Canneto Lipari", "ME"],
            ["Lipari", "ME"],
            ["Acquacalda", "ME"],
            ["Canneto", "ME"],
            ["Pianoconte", "ME"],
            ["Quattropani", "ME"],
        ],
        "98056": [["Mazzarra' Sant'Andrea", "ME"]],
        "98057": [["Santa Marina Di Milazzo", "ME"], ["Milazzo", "ME"], ["San Pietro Di Milazzo", "ME"]],
        "98058": [["Novara Di Sicilia", "ME"], ["San Basilio Di Novara Di Sicilia", "ME"]],
        "98059": [["Rodi' Milici", "ME"], ["Milici", "ME"]],
        "98060": [
            ["Tripi", "ME"],
            ["Salina'", "ME"],
            ["Belvedere", "ME"],
            ["San Lorenzitto", "ME"],
            ["Montagnareale", "ME"],
            ["Piraino", "ME"],
            ["Sant'Angelo Di Brolo", "ME"],
            ["Falcone", "ME"],
            ["Basico'", "ME"],
            ["San Silvestro", "ME"],
            ["Gliaca", "ME"],
            ["Oliveri", "ME"],
            ["Fiumara Di Piraino", "ME"],
            ["Campogrande", "ME"],
            ["Santa Maria Lo Piano", "ME"],
            ["Ucria", "ME"],
            ["Cavallo Pastorio", "ME"],
        ],
        "98061": [["Brolo", "ME"]],
        "98062": [["Ficarra", "ME"]],
        "98063": [["Magaro", "ME"], ["Gioiosa Marea", "ME"], ["San Giorgio", "ME"]],
        "98064": [["Nasidi", "ME"], ["Librizzi", "ME"], ["Colla Maffone", "ME"]],
        "98065": [["Santa Barbara", "ME"], ["Montalbano Elicona", "ME"], ["Braidi", "ME"]],
        "98066": [
            ["Scala", "ME"],
            ["Mongiove", "ME"],
            ["Tindari", "ME"],
            ["Patti", "ME"],
            ["San Cosimo", "ME"],
            ["Marina Di Patti", "ME"],
            ["Case Nuove Russo", "ME"],
        ],
        "98067": [["Raccuja", "ME"], ["Fondachello Di Raccuja", "ME"], ["Zappa", "ME"]],
        "98068": [["San Piero Patti", "ME"], ["Fiumara", "ME"], ["Tesoriero", "ME"]],
        "98069": [["Sinagra", "ME"]],
        "98070": [
            ["Militello Rosmarino", "ME"],
            ["Alcara Li Fusi", "ME"],
            ["Galati Mamertino", "ME"],
            ["Mirto", "ME"],
            ["Reitano", "ME"],
            ["Torrenova", "ME"],
            ["Frazzano'", "ME"],
            ["Capri Leone", "ME"],
            ["Rocca Di Capri Leone", "ME"],
            ["Acquedolci", "ME"],
            ["Castel Di Lucio", "ME"],
            ["San Marco D'Alunzio", "ME"],
            ["Pettineo", "ME"],
            ["Motta D'Affermo", "ME"],
            ["Castell'Umberto", "ME"],
            ["San Salvatore Di Fitalia", "ME"],
            ["San Basilio", "ME"],
            ["Sfaranda", "ME"],
            ["Longi", "ME"],
            ["Torremuzza", "ME"],
        ],
        "98071": [["Piana Di Capo D'Orlando", "ME"], ["Scafa", "ME"], ["Capo D'Orlando", "ME"]],
        "98072": [["Marina Di Caronia", "ME"], ["Canneto Di Caronia", "ME"], ["Caronia", "ME"]],
        "98073": [["Mistretta", "ME"]],
        "98074": [["Malo'", "ME"], ["Cresta", "ME"], ["Naso", "ME"]],
        "98075": [["San Fratello", "ME"]],
        "98076": [["Sant'Agata Di Militello", "ME"], ["Vallebruca", "ME"], ["Torrecandele", "ME"]],
        "98077": [["Santo Stefano Di Camastra", "ME"]],
        "98078": [
            ["Moira", "ME"],
            ["Tortorici", "ME"],
            ["Sceti", "ME"],
            ["Grazia", "ME"],
            ["Ilombati", "ME"],
            ["Sant'Antonino Sciortino", "ME"],
        ],
        "98079": [["Castel Di Tusa", "ME"], ["Tusa", "ME"]],
        "98100": [["Messina", "ME"]],
        "98121": [["Messina", "ME"]],
        "98122": [["Messina", "ME"]],
        "98123": [["Messina", "ME"]],
        "98124": [["Messina", "ME"], ["Gazzi", "ME"]],
        "98125": [["Contesse", "ME"], ["Messina", "ME"]],
        "98126": [["Messina", "ME"], ["Santa Lucia Sopra Contesse", "ME"]],
        "98127": [["Zafferia", "ME"], ["Messina", "ME"]],
        "98128": [["Messina", "ME"], ["Tremestieri", "ME"]],
        "98129": [["Larderia", "ME"], ["Messina", "ME"]],
        "98131": [["Messina", "ME"], ["Mili Marina", "ME"]],
        "98132": [["Mili Marina", "ME"], ["Mili San Marco", "ME"], ["Messina", "ME"]],
        "98133": [["Messina", "ME"], ["Mili Superiore", "ME"]],
        "98134": [["Messina", "ME"], ["Galati Marina", "ME"]],
        "98135": [["Messina", "ME"], ["Santo Stefano Medio", "ME"], ["Santa Margherita", "ME"]],
        "98136": [["Santo Stefano Medio", "ME"], ["Messina", "ME"]],
        "98137": [["Santo Stefano Di Briga", "ME"], ["Messina", "ME"]],
        "98138": [["Messina", "ME"], ["Pezzolo", "ME"]],
        "98139": [["San Placido Calonero'", "ME"], ["Briga Marina", "ME"], ["Briga", "ME"], ["Messina", "ME"]],
        "98141": [["Messina", "ME"], ["Giampilieri Marina", "ME"]],
        "98142": [["Giampilieri", "ME"], ["San Filippo Inferiore", "ME"], ["Messina", "ME"]],
        "98143": [["Messina", "ME"], ["Altolia", "ME"], ["Molino", "ME"]],
        "98144": [["Messina", "ME"], ["San Filippo", "ME"]],
        "98145": [["Messina", "ME"], ["Bordonaro", "ME"], ["San Filippo", "ME"]],
        "98146": [["Cumia", "ME"], ["Santo", "ME"], ["Messina", "ME"]],
        "98147": [["Messina", "ME"], ["Villaggio Aldisio", "ME"]],
        "98148": [["Santo", "ME"], ["Messina", "ME"]],
        "98149": [["Messina", "ME"], ["Camaro", "ME"], ["Camaro Inferiore", "ME"], ["Cataratti", "ME"]],
        "98151": [["Camaro", "ME"], ["Messina", "ME"]],
        "98152": [["Messina", "ME"], ["Scala Ritiro", "ME"], ["San Michele", "ME"]],
        "98153": [["Gesso", "ME"], ["Messina", "ME"]],
        "98154": [["Messina", "ME"], ["Salice Calabro", "ME"], ["Salice", "ME"]],
        "98155": [["Castanea", "ME"], ["Castanea Delle Furie", "ME"], ["Messina", "ME"]],
        "98156": [["Massa San Giorgio", "ME"], ["Messina", "ME"]],
        "98157": [["Messina", "ME"], ["Massa Santa Lucia", "ME"], ["Massa San Giovanni", "ME"]],
        "98158": [["Faro Superiore", "ME"], ["Messina", "ME"]],
        "98159": [["Messina", "ME"], ["Liuzzo Orto", "ME"]],
        "98161": [["Messina", "ME"], ["Rodia", "ME"]],
        "98162": [["San Saba", "ME"], ["Messina", "ME"]],
        "98163": [["Messina", "ME"], ["Sparta'", "ME"]],
        "98164": [["Lido Di Mortelle", "ME"], ["Messina", "ME"], ["Torre Faro", "ME"]],
        "98165": [["Messina", "ME"], ["Ganzirri", "ME"]],
        "98166": [["Sant'Agata", "ME"], ["Messina", "ME"]],
        "98167": [["Messina", "ME"], ["Pace", "ME"]],
        "98168": [
            ["Villaggio Annunziata", "ME"],
            ["Contemplazione", "ME"],
            ["Pace", "ME"],
            ["Villaggio Paradiso", "ME"],
            ["Messina", "ME"],
        ],
        "90010": [
            ["San Mauro Castelverde", "PA"],
            ["Ustica", "PA"],
            ["Cerda", "PA"],
            ["Finale", "PA"],
            ["Gratteri", "PA"],
            ["Pollina", "PA"],
            ["Isnello", "PA"],
            ["Altavilla Milicia", "PA"],
            ["Campofelice Di Roccella", "PA"],
            ["Lascari", "PA"],
            ["Ficarazzi", "PA"],
            ["Borrello Di San Mauro Castelverde", "PA"],
            ["Geraci Siculo", "PA"],
            ["Torre Normanna", "PA"],
            ["Lascari Scalo", "PA"],
        ],
        "90011": [["Aspra", "PA"], ["Bagheria", "PA"]],
        "90012": [["Sambuchi", "PA"], ["San Giovanni Li Greci", "PA"], ["Caccamo", "PA"]],
        "90013": [["Castelbuono", "PA"]],
        "90014": [["Casteldaccia", "PA"]],
        "90015": [["Gibilmanna", "PA"], ["Sant'Ambrogio", "PA"], ["Cefalu'", "PA"]],
        "90016": [["Collesano", "PA"]],
        "90017": [["Sant'Elia", "PA"], ["Santa Flavia", "PA"], ["Porticello", "PA"]],
        "90018": [["Termini Imerese", "PA"], ["Danigarci", "PA"]],
        "90019": [["San Nicolo' L'Arena", "PA"], ["Trabia", "PA"]],
        "90020": [
            ["Scillato", "PA"],
            ["Vicari", "PA"],
            ["Ventimiglia Di Sicilia", "PA"],
            ["Sciara", "PA"],
            ["Calcarelli", "PA"],
            ["Roccapalumba", "PA"],
            ["Baucina", "PA"],
            ["Blufi", "PA"],
            ["Alimena", "PA"],
            ["Castellana Sicula", "PA"],
            ["Nociazzi Inferiore", "PA"],
            ["Aliminusa", "PA"],
            ["Regalgioffoli", "PA"],
            ["Sclafani Bagni", "PA"],
            ["Montemaggiore Belsito", "PA"],
            ["Bompietro", "PA"],
            ["Nociazzi", "PA"],
            ["Locati", "PA"],
        ],
        "90021": [["Alia", "PA"]],
        "90022": [["Caltavuturo", "PA"]],
        "90023": [["Ciminna", "PA"]],
        "90024": [["Gangi", "PA"]],
        "90025": [["Lercara Friddi", "PA"]],
        "90026": [
            ["Pianello", "PA"],
            ["Pianello Di Petralia Sottana", "PA"],
            ["Raffo", "PA"],
            ["Petralia Soprana", "PA"],
            ["Fasano'", "PA"],
        ],
        "90027": [["Petralia Sottana", "PA"]],
        "90028": [["Polizzi Generosa", "PA"]],
        "90029": [["Valledolmo", "PA"]],
        "90030": [
            ["Cefala' Diana", "PA"],
            ["Godrano", "PA"],
            ["Blandino", "PA"],
            ["Santa Cristina Gela", "PA"],
            ["Campofiorito", "PA"],
            ["Giuliana", "PA"],
            ["Piano Maglio", "PA"],
            ["Contessa Entellina", "PA"],
            ["Castronuovo Di Sicilia", "PA"],
            ["Mezzojuso", "PA"],
            ["Villafrati", "PA"],
            ["Palazzo Adriano", "PA"],
            ["Altofonte", "PA"],
            ["Bolognetta", "PA"],
            ["Campofelice Di Fitalia", "PA"],
        ],
        "90031": [["Belmonte Mezzagno", "PA"]],
        "90032": [["Bisacquino", "PA"]],
        "90033": [["San Carlo", "PA"], ["Chiusa Sclafani", "PA"]],
        "90034": [["Corleone", "PA"], ["Ficuzza", "PA"]],
        "90035": [["Marineo", "PA"]],
        "90036": [["Portella Di Mare", "PA"], ["Misilmeri", "PA"]],
        "90037": [["Piana Degli Albanesi", "PA"]],
        "90038": [["Filaga", "PA"], ["Prizzi", "PA"]],
        "90039": [["Villabate", "PA"]],
        "90040": [
            ["Montelepre", "PA"],
            ["Giardinello", "PA"],
            ["Trappeto", "PA"],
            ["Roccamena", "PA"],
            ["San Cipirello", "PA"],
            ["Grisi'", "PA"],
            ["Isola Delle Femmine", "PA"],
            ["Capaci", "PA"],
            ["Torretta", "PA"],
            ["Cortiglia", "PA"],
        ],
        "90041": [["Balestrate", "PA"], ["Foce", "PA"]],
        "90042": [["Borgetto", "PA"]],
        "90043": [["Camporeale", "PA"]],
        "90044": [["Villagrazia Di Carini", "PA"], ["Carini", "PA"]],
        "90045": [["Cinisi", "PA"], ["Punta Raisi Aeroporto", "PA"]],
        "90046": [
            ["Villa Ciambra", "PA"],
            ["Poggio San Francesco", "PA"],
            ["Pioppo", "PA"],
            ["San Martino Delle Scale", "PA"],
            ["Malpasso", "PA"],
            ["Monreale", "PA"],
        ],
        "90047": [["Partinico", "PA"]],
        "90048": [["San Giuseppe Jato", "PA"]],
        "90049": [["Terrasini", "PA"], ["Citta' Del Mare", "PA"]],
        "90100": [["Palermo", "PA"]],
        "90121": [
            ["Palermo", "PA"],
            ["Boccadifalco", "PA"],
            ["In Via Messina Marine", "PA"],
            ["In Via Ammiraglio Cristodulo", "PA"],
            ["Brancaccio Ciaculli", "PA"],
            ["Acqua Dei Corsari", "PA"],
        ],
        "90122": [["Roccella Guarnaschelli", "PA"], ["Palermo", "PA"]],
        "90123": [["Palermo", "PA"], ["Settecannoli", "PA"]],
        "90124": [
            ["In Via Chiavelli", "PA"],
            ["Brancaccio Ciaculli", "PA"],
            ["In Via Brancaccio", "PA"],
            ["In Via Santa Maria Di Gesu'", "PA"],
            ["Palermo", "PA"],
        ],
        "90125": [["Palermo", "PA"], ["In Via Aloi", "PA"]],
        "90126": [["Mezzomonreale Boccadifalco", "PA"], ["Palermo", "PA"]],
        "90127": [["Palermo", "PA"]],
        "90128": [["Palermo", "PA"]],
        "90129": [["Palermo", "PA"]],
        "90131": [["Palermo", "PA"], ["Rocca Monreale", "PA"]],
        "90132": [["Palermo", "PA"]],
        "90133": [["Palermo", "PA"], ["Tribunali Castellammare", "PA"]],
        "90134": [["Zisa", "PA"], ["In Via Gioiamia", "PA"], ["Palermo", "PA"]],
        "90135": [["Palermo", "PA"], ["Zisa", "PA"]],
        "90136": [["Palermo", "PA"]],
        "90137": [["Palermo", "PA"]],
        "90138": [["Palermo", "PA"], ["Zisa", "PA"]],
        "90139": [["Palermo", "PA"]],
        "90141": [["Palermo", "PA"]],
        "90142": [["Palermo", "PA"], ["Montepellegrino", "PA"], ["Arenella Vergine Maria", "PA"]],
        "90143": [["Palermo", "PA"]],
        "90144": [["Palermo", "PA"]],
        "90145": [["Palermo", "PA"]],
        "90146": [
            ["Palermo", "PA"],
            ["In Via San Nicola", "PA"],
            ["Pallavicino", "PA"],
            ["Cruillas", "PA"],
            ["San Lorenzo Colli", "PA"],
            ["Resuttana San Lorenzo", "PA"],
        ],
        "90147": [["Tommaso Natale Sferracavallo", "PA"], ["Palermo", "PA"]],
        "90148": [["Palermo", "PA"], ["Sferracavallo", "PA"], ["Villagrazia", "PA"], ["Tommaso Natale", "PA"]],
        "90149": [["Palermo", "PA"]],
        "90151": [["Palermo", "PA"], ["Partanna Mondello", "PA"], ["Mondello", "PA"]],
        "97010": [
            ["Marina Di Modica", "RG"],
            ["Bellocozzo", "RG"],
            ["Marina Di Ragusa", "RG"],
            ["Monterosso Almo", "RG"],
            ["Roccazzo", "RG"],
            ["Giarratana", "RG"],
        ],
        "97011": [["Acate", "RG"]],
        "97012": [["Chiaramonte Gulfi", "RG"]],
        "97013": [["Pedalino", "RG"], ["Comiso", "RG"]],
        "97014": [["Ispica", "RG"]],
        "97015": [
            ["Modica Alta", "RG"],
            ["Frigintini", "RG"],
            ["Rocciola Sorda", "RG"],
            ["Cava D'Ispica", "RG"],
            ["Modica", "RG"],
        ],
        "97016": [["Pozzallo", "RG"]],
        "97017": [["Santa Croce Camerina", "RG"], ["Donnafugata", "RG"]],
        "97018": [["Donnalucata", "RG"], ["Jungi", "RG"], ["Cava D'Aliga", "RG"], ["Scicli", "RG"], ["Sampieri", "RG"]],
        "97019": [["Scoglitti", "RG"], ["Vittoria", "RG"]],
        "97100": [["Ragusa", "RG"], ["Ragusa Ibla", "RG"]],
        "96010": [
            ["Portopalo Di Capo Passero", "SR"],
            ["Melilli", "SR"],
            ["Buccheri", "SR"],
            ["Villasmundo", "SR"],
            ["Sortino", "SR"],
            ["Ferla", "SR"],
            ["Priolo Gargallo", "SR"],
            ["San Foca'", "SR"],
            ["Marina Di Melilli", "SR"],
            ["Cassaro", "SR"],
            ["Buscemi", "SR"],
            ["Rizzolo", "SR"],
            ["Solarino", "SR"],
            ["Canicattini Bagni", "SR"],
            ["Palazzolo Acreide", "SR"],
        ],
        "96011": [["Augusta", "SR"], ["Brucoli", "SR"]],
        "96012": [["Avola", "SR"]],
        "96013": [["Borgo Rizza", "SR"], ["Carlentini", "SR"], ["Pedagaggi", "SR"]],
        "96014": [["Floridia", "SR"]],
        "96015": [["Francofonte", "SR"]],
        "96016": [["Lentini", "SR"]],
        "96017": [
            ["Santa Lucia", "SR"],
            ["San Paolo Di Noto", "SR"],
            ["San Paolo", "SR"],
            ["Testa Dell'Acqua", "SR"],
            ["Noto", "SR"],
            ["Santa Lucia Di Noto", "SR"],
            ["San Corrado Di Fuori", "SR"],
            ["Rigolizia", "SR"],
            ["Castelluccio", "SR"],
        ],
        "96018": [["Marzamemi", "SR"], ["Pachino", "SR"]],
        "96019": [["Rosolini", "SR"]],
        "96100": [
            ["Siracusa", "SR"],
            ["Carrozziere", "SR"],
            ["Belvedere Di Siracusa", "SR"],
            ["Belvedere", "SR"],
            ["Cassibile", "SR"],
        ],
        "91010": [
            ["Castelluzzo", "TP"],
            ["Macari", "TP"],
            ["Vita", "TP"],
            ["Marettimo", "TP"],
            ["San Vito Lo Capo", "TP"],
        ],
        "91011": [["Alcamo", "TP"]],
        "91012": [["Bruca", "TP"], ["Battaglia", "TP"], ["Buseto Palizzolo", "TP"]],
        "91013": [["Sasi", "TP"], ["Calatafimi Segesta", "TP"], ["Calatafimi", "TP"]],
        "91014": [
            ["Scopello", "TP"],
            ["Castellammare Del Golfo", "TP"],
            ["Balata Di Baida", "TP"],
            ["Castello Inici", "TP"],
        ],
        "91015": [["Sperone Di Custonaci", "TP"], ["Purgatorio", "TP"], ["Custonaci", "TP"]],
        "91016": [
            ["Napola", "TP"],
            ["Ballata", "TP"],
            ["Pizzolungo", "TP"],
            ["Casa Santa", "TP"],
            ["San Giuliano Trentapiedi", "TP"],
            ["Rigaletta", "TP"],
            ["Erice", "TP"],
        ],
        "91017": [
            ["Kamma", "TP"],
            ["Scauri Siculo", "TP"],
            ["Scauri", "TP"],
            ["Pantelleria Aeroporto", "TP"],
            ["Pantelleria", "TP"],
        ],
        "91018": [["Ulmi", "TP"], ["Filci", "TP"], ["San Ciro", "TP"], ["Salemi", "TP"], ["Gorgazzo", "TP"]],
        "91019": [
            ["Valderice", "TP"],
            ["Sant'Andrea Bonagia", "TP"],
            ["Chiesanuova", "TP"],
            ["Crocevie", "TP"],
            ["Tonnara Di Bonagia", "TP"],
            ["Bonagia", "TP"],
            ["Crocci", "TP"],
            ["Fico", "TP"],
        ],
        "91020": [
            ["Poggioreale", "TP"],
            ["Salaparuta", "TP"],
            ["Granitola", "TP"],
            ["Costiera Di Mazara", "TP"],
            ["Petrosino", "TP"],
        ],
        "91021": [["Tre Fontane", "TP"], ["Granitola Torretta", "TP"], ["Campobello Di Mazara", "TP"]],
        "91022": [["Castelvetrano", "TP"], ["Marinella Di Selinunte", "TP"], ["Marinella", "TP"], ["Triscina", "TP"]],
        "91023": [["Favignana", "TP"], ["Levanzo", "TP"]],
        "91024": [["Gibellina", "TP"], ["Villaggio Madonna Delle Grazie", "TP"]],
        "91025": [
            ["Spagnola", "TP"],
            ["Marsala", "TP"],
            ["Ragattisi", "TP"],
            ["Matarocco", "TP"],
            ["Ciavolotto", "TP"],
            ["Bufalata", "TP"],
            ["Tabaccaro", "TP"],
            ["Terrenove Bambina", "TP"],
            ["Santo Padre Delle Perriere", "TP"],
            ["Strasatti Di Marsala", "TP"],
            ["Paolini", "TP"],
            ["Ciavolo", "TP"],
        ],
        "91026": [["Borgata Costiera", "TP"], ["Mazara Del Vallo", "TP"]],
        "91027": [["Paceco", "TP"], ["Dattilo", "TP"], ["Nubia", "TP"]],
        "91028": [["Partanna", "TP"]],
        "91029": [["Santa Ninfa", "TP"]],
        "91100": [
            ["Xitta", "TP"],
            ["Birgi Aerostazione", "TP"],
            ["Locogrande", "TP"],
            ["San Giuliano Trentapiedi", "TP"],
            ["Marausa Loco Grande", "TP"],
            ["Borgo Fazio", "TP"],
            ["Marausa", "TP"],
            ["Ummari", "TP"],
            ["Fulgatore", "TP"],
            ["Fontanelle Casasanta", "TP"],
            ["Borgo Annunziata", "TP"],
            ["Trapani", "TP"],
            ["Guarrato", "TP"],
            ["Salinagrande", "TP"],
            ["Rilievo", "TP"],
        ],
        "52010": [
            ["La Verna", "AR"],
            ["Serravalle Di Bibbiena", "AR"],
            ["Biforco", "AR"],
            ["Subbiano", "AR"],
            ["Corsalone", "AR"],
            ["Ortignano", "AR"],
            ["Chiusi Della Verna", "AR"],
            ["Santa Mama", "AR"],
            ["Montemignaio", "AR"],
            ["Faltona", "AR"],
            ["Capolona", "AR"],
            ["Chitignano", "AR"],
            ["Talla", "AR"],
            ["Ortignano Raggiolo", "AR"],
            ["Raggiolo", "AR"],
            ["Moggiona Di Poppi", "AR"],
        ],
        "52011": [
            ["Bibbiena", "AR"],
            ["Soci", "AR"],
            ["Partina", "AR"],
            ["Banzena", "AR"],
            ["Bibbiena Stazione", "AR"],
            ["Serravalle", "AR"],
        ],
        "52014": [
            ["Ponte A Poppi", "AR"],
            ["Avena", "AR"],
            ["Quota", "AR"],
            ["Camaldoli", "AR"],
            ["Poppi", "AR"],
            ["Porrena", "AR"],
            ["Badia Prataglia", "AR"],
            ["Moggiona", "AR"],
        ],
        "52015": [["Pratovecchio", "AR"], ["Pratovecchio Stia", "AR"]],
        "52016": [["Castel Focognano", "AR"], ["Rassina", "AR"], ["Salutio", "AR"], ["Pieve A Socana", "AR"]],
        "52017": [["Papiano", "AR"], ["Stia", "AR"]],
        "52018": [["Borgo Alla Collina", "AR"], ["Strada", "AR"], ["Castel San Niccolo'", "AR"]],
        "52020": [
            ["Castelfranco Di Sopra", "AR"],
            ["Laterina", "AR"],
            ["Ponticino", "AR"],
            ["Laterina Stazione", "AR"],
            ["Montalto", "AR"],
            ["Pieve A Presciano", "AR"],
            ["Pergine Valdarno", "AR"],
            ["Cavi", "AR"],
            ["Casalone", "AR"],
        ],
        "52021": [
            ["Torre", "AR"],
            ["Badia Agnano", "AR"],
            ["Capannole", "AR"],
            ["Ambra", "AR"],
            ["Bucine", "AR"],
            ["Pietraviva", "AR"],
        ],
        "52022": [
            ["Meleto", "AR"],
            ["Cavriglia", "AR"],
            ["San Cipriano", "AR"],
            ["Neri", "AR"],
            ["Vacchereccia", "AR"],
            ["Santa Barbara", "AR"],
            ["Monastero", "AR"],
            ["Castelnuovo Dei Sabbioni", "AR"],
            ["Montegonzi", "AR"],
        ],
        "52024": [["Loro Ciuffenna", "AR"], ["San Giustino Valdarno", "AR"]],
        "52025": [["Levane", "AR"], ["Montevarchi", "AR"], ["Moncioni", "AR"], ["Mercatale Valdarno", "AR"]],
        "52026": [["Castelfranco Piandiscò", "AR"], ["Pian Di Sco", "AR"], ["Vaggio", "AR"], ["Faella", "AR"]],
        "52027": [["San Giovanni Valdarno", "AR"]],
        "52028": [
            ["Penna", "AR"],
            ["Madrigale", "AR"],
            ["Terranuova Bracciolini", "AR"],
            ["Ville", "AR"],
            ["Campogialli", "AR"],
            ["Malva", "AR"],
        ],
        "52029": [["Castiglion Fibocchi", "AR"]],
        "52031": [["San Leo Di Anghiari", "AR"], ["Anghiari", "AR"]],
        "52032": [["Badia Tedalda", "AR"], ["Ca' Raffaello", "AR"], ["Fresciano", "AR"]],
        "52033": [["Caprese Michelangelo", "AR"]],
        "52035": [["Le Ville", "AR"], ["Monterchi", "AR"]],
        "52036": [["Madonnuccia", "AR"], ["Pieve Santo Stefano", "AR"]],
        "52037": [["Gricignano", "AR"], ["Santa Fiora", "AR"], ["Sansepolcro", "AR"]],
        "52038": [["Colcellalto", "AR"], ["Sestino", "AR"], ["Monterone", "AR"]],
        "52041": [
            ["Pieve Al Toppo", "AR"],
            ["Viciomaggio", "AR"],
            ["Ciggiano", "AR"],
            ["Badia Al Pino", "AR"],
            ["Tegoleto", "AR"],
            ["Civitella In Val Di Chiana", "AR"],
        ],
        "52043": [["Castiglion Fiorentino", "AR"], ["Montecchio", "AR"], ["Manciano", "AR"]],
        "52044": [
            ["Mercatale Di Cortona", "AR"],
            ["Cortona", "AR"],
            ["Mercatale", "AR"],
            ["Santa Caterina", "AR"],
            ["Santa Caterina Di Cortona", "AR"],
            ["Fratta", "AR"],
            ["Centoia", "AR"],
            ["Terontola Stazione", "AR"],
            ["Capezzine", "AR"],
            ["Montanare", "AR"],
            ["Montanare Di Cortona", "AR"],
            ["Camucia", "AR"],
            ["Sant'Andrea Di Sorbello", "AR"],
            ["Terontola", "AR"],
        ],
        "52045": [["Pozzo Della Chiana", "AR"], ["Foiano Della Chiana", "AR"]],
        "52046": [["Lucignano", "AR"]],
        "52047": [["Marciano", "AR"], ["Cesa", "AR"], ["Marciano Della Chiana", "AR"]],
        "52048": [
            ["Montagnano", "AR"],
            ["Monte San Savino", "AR"],
            ["Montagnano Alberoro", "AR"],
            ["Palazzuolo", "AR"],
            ["Alberoro", "AR"],
        ],
        "52100": [
            ["Patrignone", "AR"],
            ["Chiassa", "AR"],
            ["Giovi D'Arezzo", "AR"],
            ["San Giuliano D'Arezzo", "AR"],
            ["Pieve Al Bagnoro", "AR"],
            ["Chiassa Superiore", "AR"],
            ["Olmo", "AR"],
            ["Ponte Alla Chiassa", "AR"],
            ["Indicatore", "AR"],
            ["Battifolle", "AR"],
            ["Molin Nuovo", "AR"],
            ["Frassineto", "AR"],
            ["Rigutino", "AR"],
            ["Pratantico", "AR"],
            ["Quarata", "AR"],
            ["Ruscello", "AR"],
            ["Poggiola", "AR"],
            ["Arezzo", "AR"],
            ["Palazzo Del Pero", "AR"],
            ["Ceciliano", "AR"],
            ["Antria", "AR"],
            ["Staggiano", "AR"],
            ["Puglia", "AR"],
            ["Tregozzano", "AR"],
        ],
        "50010": [["Trespiano", "FI"]],
        "50012": [
            ["Vallina", "FI"],
            ["Bagno A Ripoli", "FI"],
            ["Grassina Ponte A Ema", "FI"],
            ["Osteria Nuova", "FI"],
            ["Candeli", "FI"],
            ["Grassina", "FI"],
            ["Antella", "FI"],
            ["Rimaggio", "FI"],
        ],
        "50013": [
            ["San Piero A Ponti", "FI"],
            ["Il Rosi", "FI"],
            ["San Donnino Di Campi", "FI"],
            ["Capalle", "FI"],
            ["Sant'Angelo", "FI"],
            ["San Donnino", "FI"],
            ["Sant'Angelo A Lecore", "FI"],
            ["Campi Bisenzio", "FI"],
        ],
        "50014": [["Caldine", "FI"], ["San Domenico Di Fiesole", "FI"], ["Fiesole", "FI"], ["Pian Di Mugnone", "FI"]],
        "50018": [
            ["San Vincenzo A Torri", "FI"],
            ["Casellina", "FI"],
            ["San Martino Alla Palma", "FI"],
            ["Scandicci", "FI"],
            ["Badia A Settimo", "FI"],
            ["Le Bagnese San Giusto", "FI"],
        ],
        "50019": [
            ["Querceto", "FI"],
            ["Quinto", "FI"],
            ["Osmannoro", "FI"],
            ["Sesto Fiorentino", "FI"],
            ["Colonnata", "FI"],
            ["Ponte A Giogoli", "FI"],
        ],
        "50020": [["Mercatale Val Di Pesa", "FI"]],
        "50021": [["Vico D'Elsa", "FI"], ["Marcialla", "FI"]],
        "50022": [
            ["Lamole", "FI"],
            ["Panzano", "FI"],
            ["San Polo In Chianti", "FI"],
            ["Lucolena", "FI"],
            ["Greve In Chianti", "FI"],
        ],
        "50023": [
            ["Tavarnuzze", "FI"],
            ["Monte Oriolo", "FI"],
            ["Impruneta", "FI"],
            ["Pozzolatico", "FI"],
            ["Bottai", "FI"],
        ],
        "50025": [
            ["San Quirico In Collina", "FI"],
            ["Lucardo", "FI"],
            ["Montespertoli", "FI"],
            ["Martignana", "FI"],
            ["Baccaiano", "FI"],
            ["Montagnana Val Di Pesa", "FI"],
        ],
        "50026": [
            ["San Casciano In Val Di Pesa", "FI"],
            ["San Pancrazio", "FI"],
            ["Cerbaia", "FI"],
            ["Mercatale", "FI"],
            ["Romola", "FI"],
            ["Montefiridolfi", "FI"],
            ["Spedaletto", "FI"],
        ],
        "50027": [["Chiocchio", "FI"], ["Strada In Chianti", "FI"], ["Passo Dei Pecorai", "FI"]],
        "50028": [
            ["San Donato In Poggio", "FI"],
            ["Barberino Val D'Elsa", "FI"],
            ["Sambuca Val Di Pesa", "FI"],
            ["Tavarnelle Val Di Pesa", "FI"],
            ["Sambuca", "FI"],
        ],
        "50031": [
            ["Cavallina", "FI"],
            ["Cafaggiolo", "FI"],
            ["Galliano", "FI"],
            ["Gagliano Di Mugello", "FI"],
            ["Barberino Di Mugello", "FI"],
            ["Montecarelli", "FI"],
        ],
        "50032": [
            ["Borgo San Lorenzo", "FI"],
            ["Luco Mugello", "FI"],
            ["Ronta", "FI"],
            ["Panicaglia", "FI"],
            ["Polcanto", "FI"],
        ],
        "50033": [
            ["Bruscoli", "FI"],
            ["Rifredo", "FI"],
            ["Filigare", "FI"],
            ["Traversa", "FI"],
            ["Pietramala", "FI"],
            ["Coniale", "FI"],
            ["Cornacchiaia", "FI"],
            ["Firenzuola", "FI"],
            ["Covigliaio", "FI"],
            ["Piancaldoli", "FI"],
        ],
        "50034": [["Crespino Del Lamone", "FI"], ["Casaglia", "FI"], ["Lutirano", "FI"], ["Marradi", "FI"]],
        "50035": [["Misileo", "FI"], ["Palazzuolo Sul Senio", "FI"]],
        "50036": [["Bivigliano", "FI"], ["Pratolino", "FI"], ["Vaglia", "FI"], ["Fontebuona", "FI"]],
        "50037": [["San Piero A Sieve", "FI"]],
        "50038": [
            ["Sant'Agata Mugello", "FI"],
            ["Scarperia", "FI"],
            ["Sant'Agata", "FI"],
            ["Scarperia E San Piero", "FI"],
        ],
        "50039": [["Cistio", "FI"], ["Rupecanina", "FI"], ["Villore", "FI"], ["Gattaia", "FI"], ["Vicchio", "FI"]],
        "50041": [
            ["Calenzano", "FI"],
            ["Carraia", "FI"],
            ["Le Croci", "FI"],
            ["Croci Di Calenzano", "FI"],
            ["Settimello", "FI"],
        ],
        "50050": [
            ["Capraia", "FI"],
            ["Stabbia", "FI"],
            ["Montaione", "FI"],
            ["Pieve A Ripoli", "FI"],
            ["Il Castagno Val D'Elsa", "FI"],
            ["Varna", "FI"],
            ["Limite Sull'Arno", "FI"],
            ["Il Castagno", "FI"],
            ["Ponte Di Masino", "FI"],
            ["Bassa", "FI"],
            ["Badia A Cerreto", "FI"],
            ["Capraia E Limite", "FI"],
            ["Cerreto Guidi", "FI"],
            ["Lazzeretto", "FI"],
            ["Gambassi Terme", "FI"],
            ["San Zio", "FI"],
            ["Gavena", "FI"],
        ],
        "50051": [
            ["Dogana", "FI"],
            ["Petrazzi", "FI"],
            ["Castelnuovo D'Elsa", "FI"],
            ["Cambiano", "FI"],
            ["Castelfiorentino", "FI"],
            ["Granaiolo", "FI"],
        ],
        "50052": [["Fiano", "FI"], ["Certaldo", "FI"]],
        "50053": [
            ["Empoli", "FI"],
            ["Brusciana", "FI"],
            ["Fontanella", "FI"],
            ["Sant'Andrea", "FI"],
            ["Osteria Bianca", "FI"],
            ["Case Nuove", "FI"],
            ["Monterappoli", "FI"],
            ["Ponte A Elsa", "FI"],
            ["Marcignana", "FI"],
        ],
        "50054": [
            ["San Pierino", "FI"],
            ["Galleno", "FI"],
            ["Torre", "FI"],
            ["Ponte A Cappiano", "FI"],
            ["Massarella", "FI"],
            ["Le Botteghe", "FI"],
            ["Fucecchio", "FI"],
            ["La Torre", "FI"],
            ["Querce", "FI"],
        ],
        "50055": [
            ["Ponte A Signa", "FI"],
            ["Lastra A Signa", "FI"],
            ["Malmantile", "FI"],
            ["Porto Di Mezzo", "FI"],
            ["Brucianesi", "FI"],
            ["Ginestra Fiorentina", "FI"],
        ],
        "50056": [
            ["Ambrogiana", "FI"],
            ["Sammontana", "FI"],
            ["Samminiatello", "FI"],
            ["Fibbiana", "FI"],
            ["Montelupo Fiorentino", "FI"],
        ],
        "50058": [["Signa", "FI"], ["San Mauro", "FI"], ["San Mauro A Signa", "FI"]],
        "50059": [
            ["Orbignano", "FI"],
            ["Sant'Amato", "FI"],
            ["Vitolini", "FI"],
            ["San Pantaleo", "FI"],
            ["Spicchio", "FI"],
            ["Sovigliana", "FI"],
            ["Vinci", "FI"],
        ],
        "50060": [
            ["Consuma", "FI"],
            ["Londa", "FI"],
            ["Borselli", "FI"],
            ["San Godenzo", "FI"],
            ["Pelago", "FI"],
            ["Diacceto", "FI"],
        ],
        "50061": [["Compiobbi", "FI"]],
        "50062": [["Sandetole", "FI"], ["Dicomano", "FI"]],
        "50063": [["Figline E Incisa Valdarno", "FI"], ["Figline Valdarno", "FI"]],
        "50064": [["Incisa In Val D'Arno", "FI"], ["Loppiano", "FI"]],
        "50065": [
            ["Pontassieve", "FI"],
            ["Montebonello", "FI"],
            ["Molino Del Piano", "FI"],
            ["Santa Brigida", "FI"],
            ["Sieci", "FI"],
        ],
        "50066": [
            ["Tosi", "FI"],
            ["Cancelli", "FI"],
            ["Cascia", "FI"],
            ["Sant'Ellero", "FI"],
            ["Pietrapiana", "FI"],
            ["Donnini", "FI"],
            ["Reggello", "FI"],
            ["Saltino", "FI"],
            ["Matassino", "FI"],
            ["Vaggio", "FI"],
            ["Leccio", "FI"],
            ["Borgo A Cascia", "FI"],
            ["Vallombrosa", "FI"],
            ["San Donato Fronzano", "FI"],
        ],
        "50067": [["Troghi", "FI"], ["San Donato In Collina", "FI"], ["Rignano Sull'Arno", "FI"], ["Rosano", "FI"]],
        "50068": [["Pomino", "FI"], ["Rufina", "FI"], ["Contea", "FI"]],
        "50100": [["Firenze", "FI"]],
        "50121": [["Firenze", "FI"]],
        "50122": [["Firenze", "FI"]],
        "50123": [["Firenze", "FI"]],
        "50124": [["Firenze", "FI"], ["Galluzzo", "FI"]],
        "50125": [["Arcetri", "FI"], ["Poggio Imperiale", "FI"], ["San Felice A Ema", "FI"], ["Firenze", "FI"]],
        "50126": [
            ["Firenze", "FI"],
            ["Ponte A Ema", "FI"],
            ["Sorgane", "FI"],
            ["Bandino", "FI"],
            ["Pieve A Ripoli", "FI"],
            ["Badia A Ripoli", "FI"],
        ],
        "50127": [["Firenze", "FI"], ["Novoli", "FI"]],
        "50129": [["Firenze", "FI"]],
        "50131": [["Firenze", "FI"]],
        "50132": [["Firenze", "FI"]],
        "50133": [["Firenze", "FI"]],
        "50134": [["Firenze", "FI"], ["Careggi", "FI"]],
        "50135": [["Montalbano", "FI"], ["Settignano", "FI"], ["Coverciano", "FI"], ["Firenze", "FI"]],
        "50136": [["Firenze", "FI"], ["Rovezzano", "FI"], ["Varlungo", "FI"]],
        "50137": [["Firenze", "FI"]],
        "50139": [["Firenze", "FI"]],
        "50141": [["Firenze", "FI"], ["Castello", "FI"], ["Rifredi", "FI"]],
        "50142": [["Mantignano", "FI"], ["Isolotto", "FI"], ["Firenze", "FI"]],
        "50143": [["Firenze", "FI"]],
        "50144": [["Firenze", "FI"]],
        "50145": [["Firenze", "FI"], ["Brozzi", "FI"], ["Peretola", "FI"]],
        "58010": [
            ["San Quirico", "GR"],
            ["Montebuono", "GR"],
            ["San Valentino", "GR"],
            ["Sorano", "GR"],
            ["Pratolungo", "GR"],
            ["Elmo", "GR"],
            ["Castell'Ottieri", "GR"],
            ["Montorio", "GR"],
            ["Sovana", "GR"],
            ["Albinia", "GR"],
            ["Montevitozzo", "GR"],
            ["San Giovanni Delle Contee", "GR"],
        ],
        "58011": [["Capalbio Stazione", "GR"], ["Borgo Carige", "GR"], ["Chiarone", "GR"], ["Capalbio", "GR"]],
        "58012": [
            ["Giglio Castello", "GR"],
            ["Isola Del Giglio", "GR"],
            ["Giglio Porto", "GR"],
            ["Campese", "GR"],
            ["Giglio Campese", "GR"],
        ],
        "58014": [
            ["Poggio Murella", "GR"],
            ["Poderi Di Montemerano", "GR"],
            ["Poggio Capanne", "GR"],
            ["Marsiliana", "GR"],
            ["San Martino Sul Fiora", "GR"],
            ["Saturnia", "GR"],
            ["Manciano", "GR"],
            ["Montemerano", "GR"],
        ],
        "58015": [
            ["Polverosa", "GR"],
            ["Fonteblanda", "GR"],
            ["Orbetello", "GR"],
            ["Santa Liberata", "GR"],
            ["Orbetello Scalo", "GR"],
            ["Talamone", "GR"],
            ["Orbetello Stazione", "GR"],
        ],
        "58017": [["Il Casone", "GR"], ["Casone", "GR"], ["Pitigliano", "GR"]],
        "58018": [["Porto Ercole", "GR"]],
        "58019": [["Porto Santo Stefano", "GR"], ["Monte Argentario", "GR"], ["Giannutri", "GR"]],
        "58020": [["Puntone", "GR"], ["Scarlino Stazione", "GR"], ["Scarlino Scalo", "GR"], ["Scarlino", "GR"]],
        "58022": [["Prato Ranieri", "GR"], ["Follonica", "GR"]],
        "58023": [
            ["Castel Di Pietra", "GR"],
            ["Miniera", "GR"],
            ["Bagno Di Gavorrano", "GR"],
            ["Bivio Di Ravi", "GR"],
            ["Potassa", "GR"],
            ["Caldana", "GR"],
            ["Ravi", "GR"],
            ["Giuncarico", "GR"],
            ["Grilli", "GR"],
            ["Gavorrano", "GR"],
            ["Boschetto", "GR"],
            ["Filare", "GR"],
        ],
        "58024": [
            ["Montebamboli", "GR"],
            ["Capanne Vecchie", "GR"],
            ["Prata", "GR"],
            ["Niccioleta", "GR"],
            ["Capanne", "GR"],
            ["Massa Marittima", "GR"],
            ["Tatti", "GR"],
            ["Ghirlanda", "GR"],
            ["Valpiana", "GR"],
        ],
        "58025": [["Lago Boracifero", "GR"], ["Monterotondo Marittimo", "GR"], ["Frassine", "GR"]],
        "58026": [["Travale", "GR"], ["Montieri", "GR"], ["Boccheggiano", "GR"], ["Gerfalco", "GR"]],
        "58027": [["Ribolla", "GR"], ["Montemassi", "GR"]],
        "58031": [
            ["Bagnoli", "GR"],
            ["Arcidosso", "GR"],
            ["Salaiola", "GR"],
            ["Montelaterone", "GR"],
            ["Zancona", "GR"],
            ["Stribugliano", "GR"],
        ],
        "58033": [["Montegiovi", "GR"], ["Castel Del Piano", "GR"], ["Montenero", "GR"]],
        "58034": [["Castell'Azzara", "GR"], ["Selvena", "GR"]],
        "58036": [
            ["Sticciano Stazione", "GR"],
            ["Sassofortino", "GR"],
            ["Sticciano", "GR"],
            ["Roccatederighi", "GR"],
            ["Roccastrada", "GR"],
            ["Torniella", "GR"],
            ["Sticciano Scalo", "GR"],
        ],
        "58037": [["Bagnolo", "GR"], ["Selva", "GR"], ["Santa Fiora", "GR"], ["Marroneto", "GR"], ["Bagnore", "GR"]],
        "58038": [["Seggiano", "GR"]],
        "58042": [["Montorsaio", "GR"], ["Campagnatico", "GR"], ["Arcille", "GR"], ["Arcille Di Campagnatico", "GR"]],
        "58043": [
            ["Buriano", "GR"],
            ["Vetulonia", "GR"],
            ["Riva Del Sole", "GR"],
            ["Tirli", "GR"],
            ["Punta Ala", "GR"],
            ["Castiglione Della Pescaia", "GR"],
        ],
        "58044": [
            ["Sasso D'Ombrone", "GR"],
            ["Cinigiano", "GR"],
            ["Castiglioncello Bandini", "GR"],
            ["Monticello Dell'Amiata", "GR"],
            ["Monticello Amiata", "GR"],
        ],
        "58045": [
            ["Stazione Di Monte Antico", "GR"],
            ["Monte Antico Scalo", "GR"],
            ["Monte Antico", "GR"],
            ["Paganico", "GR"],
            ["Civitella Paganico", "GR"],
            ["Casale Di Pari", "GR"],
            ["Pari", "GR"],
            ["Civitella Marittima", "GR"],
        ],
        "58051": [["Magliano In Toscana", "GR"], ["Pereta", "GR"], ["Montiano", "GR"]],
        "58053": [
            ["Cana", "GR"],
            ["Vallerona", "GR"],
            ["Roccalbegna", "GR"],
            ["Santa Caterina", "GR"],
            ["Triana", "GR"],
        ],
        "58054": [
            ["Murci", "GR"],
            ["Pomonte", "GR"],
            ["Pancole", "GR"],
            ["Scansano", "GR"],
            ["Montorgiali", "GR"],
            ["Preselle Sergardi", "GR"],
            ["Baccinello", "GR"],
            ["Polveraia", "GR"],
            ["Preselle", "GR"],
            ["Poggioferro", "GR"],
        ],
        "58055": [["Semproniano", "GR"], ["Petricci", "GR"], ["Catabbio", "GR"], ["Cellena", "GR"]],
        "58100": [
            ["Marina Di Grosseto", "GR"],
            ["Santa Maria Di Rispescia", "GR"],
            ["Rispescia", "GR"],
            ["Batignano", "GR"],
            ["Le Stiacciole", "GR"],
            ["Braccagni", "GR"],
            ["Montepescali Stazione", "GR"],
            ["Bagno Roselle", "GR"],
            ["Roselle Terme", "GR"],
            ["Alberese", "GR"],
            ["Montepescali", "GR"],
            ["Grosseto", "GR"],
            ["Istia D'Ombrone", "GR"],
        ],
        "57014": [
            ["Vicarello", "LI"],
            ["Parrana San Giusto", "LI"],
            ["Castell'Anselmo", "LI"],
            ["Crocino", "LI"],
            ["Crocino San Giusto", "LI"],
            ["Collesalvetti", "LI"],
            ["Colognole", "LI"],
            ["Parrana San Martino", "LI"],
        ],
        "57016": [
            ["Rosignano Solvay", "LI"],
            ["Nibbiaia", "LI"],
            ["Caletta Di Castiglioncello", "LI"],
            ["Castiglioncello", "LI"],
            ["Rosignano Marittimo", "LI"],
            ["Gabbro", "LI"],
            ["Vada", "LI"],
            ["Castelnuovo Misericordia", "LI"],
        ],
        "57017": [["Stagno", "LI"], ["Nugola Nuova", "LI"], ["Nugola", "LI"], ["Guasticce", "LI"]],
        "57020": [["Sassetta", "LI"], ["La California", "LI"], ["Bibbona", "LI"]],
        "57021": [
            ["Stazione Di Campiglia Marittima", "LI"],
            ["Campiglia Marittima Stazione", "LI"],
            ["Campiglia Marittima", "LI"],
            ["Venturina", "LI"],
        ],
        "57022": [
            ["Donoratico", "LI"],
            ["Marina Di Castagneto", "LI"],
            ["Marina Di Castagneto Carducci", "LI"],
            ["Castagneto Carducci", "LI"],
            ["San Guido", "LI"],
            ["Bolgheri", "LI"],
        ],
        "57023": [["San Pietro In Palazzi", "LI"], ["Cecina", "LI"], ["Cecina Marina", "LI"]],
        "57025": [
            ["Piombino", "LI"],
            ["Vignale Riotorto", "LI"],
            ["Colmata", "LI"],
            ["Portovecchio", "LI"],
            ["Torre Mozza", "LI"],
            ["Riotorto", "LI"],
            ["Populonia", "LI"],
            ["Cotone", "LI"],
            ["Colmata Fiorentina Di Piombino", "LI"],
        ],
        "57027": [["San Vincenzo", "LI"], ["San Carlo", "LI"]],
        "57028": [["Montioni", "LI"], ["Suvereto", "LI"]],
        "57030": [["Procchio", "LI"], ["Poggio", "LI"], ["Marciana", "LI"], ["Pomonte", "LI"]],
        "57031": [["Capoliveri", "LI"]],
        "57032": [["Capraia Isola", "LI"]],
        "57033": [["Marciana Marina", "LI"]],
        "57034": [
            ["Pianosa Isola", "LI"],
            ["Cavoli", "LI"],
            ["San Piero In Campo", "LI"],
            ["Pianosa", "LI"],
            ["Marina Di Campo", "LI"],
            ["Seccheto", "LI"],
            ["Sant'Ilario", "LI"],
            ["Campo Nell'Elba", "LI"],
            ["La Pila", "LI"],
        ],
        "57036": [["Porto Azzurro", "LI"]],
        "57037": [["Portoferraio", "LI"], ["Magazzini", "LI"], ["Carpani", "LI"], ["San Giovanni", "LI"]],
        "57038": [["Rio Marina", "LI"], ["Cavo", "LI"]],
        "57039": [["Rio Nell'Elba", "LI"]],
        "57100": [["Livorno", "LI"]],
        "57121": [["Livorno", "LI"]],
        "57122": [["Livorno", "LI"]],
        "57123": [["Livorno", "LI"]],
        "57124": [["Livorno", "LI"], ["Salviano", "LI"], ["Valle Benedetta", "LI"]],
        "57125": [["Livorno", "LI"]],
        "57126": [["Livorno", "LI"]],
        "57127": [["Livorno", "LI"]],
        "57128": [["Antignano", "LI"], ["Livorno", "LI"], ["Montenero", "LI"], ["Ardenza", "LI"]],
        "55010": [["Camigliano Santa Gemma", "LU"], ["Gragnano", "LU"], ["San Gennaro", "LU"], ["Lappato", "LU"]],
        "55011": [["Marginone", "LU"], ["Altopascio", "LU"], ["Badia Pozzeveri", "LU"], ["Spianate", "LU"]],
        "55012": [["Capannori", "LU"], ["Zone", "LU"], ["Lunata", "LU"], ["Pieve San Paolo", "LU"]],
        "55013": [["Lammari", "LU"]],
        "55014": [["Marlia", "LU"]],
        "55015": [
            ["San Salvatore", "LU"],
            ["San Salvatore Di Montecarlo", "LU"],
            ["Montecarlo", "LU"],
            ["Turchetto", "LU"],
        ],
        "55016": [["Porcari", "LU"]],
        "55018": [
            ["Segromigno In Piano", "LU"],
            ["San Colombano", "LU"],
            ["Matraia", "LU"],
            ["Segromigno In Monte", "LU"],
        ],
        "55019": [["Pracando", "LU"], ["Botticino", "LU"], ["Villa Basilica", "LU"]],
        "55020": [
            ["Fosciandora", "LU"],
            ["San Pellegrinetto", "LU"],
            ["Fornovolasco", "LU"],
            ["Vergemoli", "LU"],
            ["Sassi", "LU"],
            ["Molazzana", "LU"],
        ],
        "55021": [["Fabbriche Di Vergemoli", "LU"], ["Fabbriche Di Vallico", "LU"]],
        "55022": [
            ["Bagni Di Lucca", "LU"],
            ["Bagni Di Lucca Ponte", "LU"],
            ["San Cassiano Di Controni", "LU"],
            ["Scesta", "LU"],
            ["Pieve Di Controne", "LU"],
            ["Montefegatesi", "LU"],
            ["Ponte A Serraglio", "LU"],
            ["Bagni Di Lucca Villa", "LU"],
            ["Benabbio", "LU"],
            ["San Cassiano", "LU"],
            ["Lucchio", "LU"],
            ["Casabasciana", "LU"],
            ["Fornoli", "LU"],
            ["Isola", "LU"],
        ],
        "55023": [
            ["Gioviano", "LU"],
            ["Diecimo", "LU"],
            ["Chifenti", "LU"],
            ["Anchiano", "LU"],
            ["Corsagna", "LU"],
            ["Borgo A Mozzano", "LU"],
            ["Valdottavo", "LU"],
        ],
        "55025": [
            ["Tereglio", "LU"],
            ["Ghivizzano", "LU"],
            ["Calavorno", "LU"],
            ["Piano Di Coreglia", "LU"],
            ["Coreglia Antelminelli", "LU"],
        ],
        "55027": [["Gallicano", "LU"], ["Fiattone", "LU"], ["Turritecava", "LU"], ["Trassilico", "LU"]],
        "55030": [
            ["Villa Collemandina", "LU"],
            ["Vagli Sotto", "LU"],
            ["Careggine", "LU"],
            ["Corfino", "LU"],
            ["Vagli Sopra", "LU"],
            ["Magliano", "LU"],
        ],
        "55031": [["Poggio", "LU"], ["Poggio Garfagnana", "LU"], ["Camporgiano", "LU"], ["Filicaia", "LU"]],
        "55032": [["Palleroso", "LU"], ["Castelnuovo Di Garfagnana", "LU"]],
        "55033": [
            ["Chiozza", "LU"],
            ["Castiglione Di Garfagnana", "LU"],
            ["Valbona", "LU"],
            ["Cerageto", "LU"],
            ["San Pellegrino", "LU"],
        ],
        "55034": [
            ["Gramolazzo", "LU"],
            ["Minucciano", "LU"],
            ["Gorfigliano", "LU"],
            ["Carpinelli", "LU"],
            ["Casone Carpinelli", "LU"],
            ["Pieve San Lorenzo", "LU"],
        ],
        "55035": [["Sant'Anastasio", "LU"], ["San Michele", "LU"], ["Piazza Al Serchio", "LU"]],
        "55036": [["Pieve Fosciana", "LU"]],
        "55038": [["San Romano In Garfagnana", "LU"]],
        "55039": [["Giuncugnano", "LU"], ["Sillano Giuncugnano", "LU"], ["Sillano", "LU"]],
        "55040": [["Stazzema", "LU"], ["Ruosina", "LU"], ["Pontestazzemese", "LU"], ["Terrinca", "LU"]],
        "55041": [
            ["Nocchi", "LU"],
            ["Pieve", "LU"],
            ["Camaiore", "LU"],
            ["Vado", "LU"],
            ["Valpromaro", "LU"],
            ["Lido Di Camaiore", "LU"],
            ["Capezzano Pianore", "LU"],
            ["Montebello", "LU"],
            ["Pedona", "LU"],
            ["Montemagno", "LU"],
            ["Casoli", "LU"],
        ],
        "55042": [["Forte Dei Marmi", "LU"]],
        "55045": [
            ["Fiumetto", "LU"],
            ["Pietrasanta", "LU"],
            ["Focette", "LU"],
            ["Capezzano Monte", "LU"],
            ["Capriglia", "LU"],
            ["Valdicastello Carducci", "LU"],
            ["Crociale", "LU"],
            ["Marina Di Pietrasanta", "LU"],
            ["Capezzano", "LU"],
            ["Vallecchia", "LU"],
            ["Strettoia", "LU"],
            ["Tonfano", "LU"],
        ],
        "55047": [
            ["Pozzi", "LU"],
            ["Riomagno", "LU"],
            ["Querceta", "LU"],
            ["Seravezza", "LU"],
            ["Ripa", "LU"],
            ["Ponterosso", "LU"],
            ["Basati", "LU"],
            ["Azzano", "LU"],
        ],
        "55049": [["Viareggio", "LU"], ["Torre Del Lago Puccini", "LU"]],
        "55051": [
            ["Filecchio", "LU"],
            ["Sommocolonia", "LU"],
            ["Castelvecchio Pascoli", "LU"],
            ["Barga", "LU"],
            ["Ponte All'Ania", "LU"],
            ["Fornaci Di Barga", "LU"],
            ["Tiglio", "LU"],
            ["Mologno", "LU"],
            ["Sommacolonia", "LU"],
        ],
        "55054": [
            ["Piano Di Mommio", "LU"],
            ["Corsanico", "LU"],
            ["Bozzano", "LU"],
            ["Quiesa", "LU"],
            ["Gualdo Di Massarosa", "LU"],
            ["Stiava", "LU"],
            ["Massarosa", "LU"],
            ["Pieve A Elici", "LU"],
            ["Gualdo", "LU"],
        ],
        "55060": [
            ["Palagnana", "LU"],
            ["Guamo", "LU"],
            ["Vorno", "LU"],
            ["Massa Macinaia", "LU"],
            ["Badia Cantignano", "LU"],
        ],
        "55061": [["Carraia", "LU"], ["San Ginese", "LU"]],
        "55062": [["Ruota", "LU"], ["Colle Di Compito", "LU"], ["Pieve Di Compito", "LU"]],
        "55064": [
            ["Pascoso", "LU"],
            ["Villa A Roggio", "LU"],
            ["San Martino In Freddana", "LU"],
            ["Loppeglia", "LU"],
            ["Piegaio Basso", "LU"],
            ["Piegaio", "LU"],
            ["San Rocco In Turrite", "LU"],
            ["Pescaglia", "LU"],
        ],
        "55100": [
            ["San Lorenzo Di Moriano", "LU"],
            ["Lucca", "LU"],
            ["Cerasomma", "LU"],
            ["San Concordio Di Moriano", "LU"],
            ["Ponte A Moriano", "LU"],
            ["Pontetetto", "LU"],
            ["Santa Maria Del Giudice", "LU"],
            ["Piaggione", "LU"],
            ["Saltocchio", "LU"],
            ["Nozzano", "LU"],
            ["Ponte San Pietro", "LU"],
            ["Monte San Quirico", "LU"],
            ["Fagnano", "LU"],
            ["Montuolo", "LU"],
            ["Maggiano", "LU"],
            ["San Pietro A Vico", "LU"],
            ["Picciorana", "LU"],
            ["Vinchiana", "LU"],
            ["Mutigliano", "LU"],
            ["Gattaiola", "LU"],
            ["Ponte Del Giglio", "LU"],
            ["Massa Pisana", "LU"],
        ],
        "54010": [["Montedivalli", "MS"], ["Podenzana", "MS"]],
        "54011": [
            ["Quercia", "MS"],
            ["Pallerone", "MS"],
            ["Bigliolo", "MS"],
            ["Caprigliola", "MS"],
            ["Aulla", "MS"],
            ["Bibola", "MS"],
            ["Serricciolo", "MS"],
            ["Albiano Magra", "MS"],
        ],
        "54012": [["Barbarasco", "MS"], ["Tresana", "MS"], ["Villa Di Tresana", "MS"]],
        "54013": [
            ["Campiglione", "MS"],
            ["Sassalbo", "MS"],
            ["Tenerano", "MS"],
            ["Soliera", "MS"],
            ["Moncigoli", "MS"],
            ["Vinca", "MS"],
            ["Fivizzano", "MS"],
            ["San Terenzo Monti", "MS"],
            ["Agnino", "MS"],
            ["Rometta Apuana", "MS"],
            ["Gragnola", "MS"],
            ["Gassano", "MS"],
            ["Colla", "MS"],
            ["Rometta", "MS"],
            ["Ceserano", "MS"],
            ["Monzone", "MS"],
            ["Soliera Apuana", "MS"],
        ],
        "54014": [
            ["Regnano", "MS"],
            ["Codiponte", "MS"],
            ["Casola In Lunigiana", "MS"],
            ["Equi", "MS"],
            ["Equi Terme", "MS"],
        ],
        "54015": [["Comano", "MS"], ["Crespiano", "MS"]],
        "54016": [
            ["Monti Di Licciana", "MS"],
            ["Licciana Nardi", "MS"],
            ["Tavernelle", "MS"],
            ["Monti", "MS"],
            ["Terrarossa", "MS"],
        ],
        "54021": [["Treschietto", "MS"], ["Gabbiana", "MS"], ["Bagnone", "MS"], ["Corlaga", "MS"]],
        "54023": [["Filattiera", "MS"], ["Cantiere", "MS"], ["Ponticello", "MS"], ["Scorcetoli", "MS"]],
        "54026": [
            ["Montereggio Di Mulazzo", "MS"],
            ["Montereggio", "MS"],
            ["Groppoli", "MS"],
            ["Arpiola", "MS"],
            ["Mulazzo", "MS"],
        ],
        "54027": [
            ["Traverde", "MS"],
            ["Molinello", "MS"],
            ["Pontremoli", "MS"],
            ["Grondola", "MS"],
            ["Guinadi", "MS"],
            ["Cervara", "MS"],
            ["Vignola", "MS"],
        ],
        "54028": [["Filetto", "MS"], ["Villafranca In Lunigiana", "MS"], ["Virgoletta", "MS"], ["Merizzo", "MS"]],
        "54029": [["Zeri", "MS"], ["Chiesa Di Rossano", "MS"]],
        "54033": [
            ["Castelpoggio", "MS"],
            ["Fossone", "MS"],
            ["Fossola", "MS"],
            ["Marina Di Carrara", "MS"],
            ["Avenza", "MS"],
            ["Codena", "MS"],
            ["Gragnana", "MS"],
            ["Sorgnano", "MS"],
            ["Carrara", "MS"],
            ["Torano", "MS"],
            ["Bergiola", "MS"],
            ["Fontia", "MS"],
            ["Miseglia", "MS"],
            ["Bedizzano", "MS"],
            ["Colonnata", "MS"],
        ],
        "54035": [
            ["Tendola", "MS"],
            ["Fosdinovo", "MS"],
            ["Caniparola", "MS"],
            ["Borghetto", "MS"],
            ["Melara", "MS"],
            ["Marciaso", "MS"],
        ],
        "54038": [
            ["Prato Capanne", "MS"],
            ["Cerreto", "MS"],
            ["San Vito", "MS"],
            ["Cinquale", "MS"],
            ["Montignoso", "MS"],
        ],
        "54100": [
            ["Turano", "MS"],
            ["Ronchi", "MS"],
            ["Forno", "MS"],
            ["Casette", "MS"],
            ["Mirteto", "MS"],
            ["Canevara", "MS"],
            ["Altagnana", "MS"],
            ["Massa", "MS"],
            ["Quercioli", "MS"],
            ["Marina Di Massa", "MS"],
        ],
        "56010": [
            ["Arena Metato", "PI"],
            ["Uliveto Terme", "PI"],
            ["Campo", "PI"],
            ["Caprona", "PI"],
            ["Cucigliana", "PI"],
            ["San Giovanni Alla Vena", "PI"],
            ["Mezzana", "PI"],
            ["Vicopisano", "PI"],
        ],
        "56011": [["Gabella", "PI"], ["Castelmaggiore", "PI"], ["Calci", "PI"], ["Montemagno", "PI"]],
        "56012": [["Calcinaia", "PI"], ["Fornacette", "PI"]],
        "56017": [
            ["Gello", "PI"],
            ["Ripafratta", "PI"],
            ["Agnano", "PI"],
            ["San Giuliano Terme", "PI"],
            ["Pontasserchio", "PI"],
            ["Arena", "PI"],
            ["Molina Di Quosa", "PI"],
            ["Rigoli", "PI"],
            ["Ghezzano", "PI"],
            ["Asciano", "PI"],
            ["Pappiana", "PI"],
        ],
        "56019": [["Vecchiano", "PI"], ["Avane", "PI"], ["Filettole", "PI"], ["Migliarino", "PI"], ["Nodica", "PI"]],
        "56020": [
            ["Cerretti", "PI"],
            ["Montecalvoli", "PI"],
            ["Castel Del Bosco", "PI"],
            ["San Romano", "PI"],
            ["Montopoli", "PI"],
            ["Montopoli In Val D'Arno", "PI"],
            ["Marti", "PI"],
            ["Santa Maria A Monte", "PI"],
            ["Capanne", "PI"],
        ],
        "56021": [
            ["Cascina", "PI"],
            ["San Casciano", "PI"],
            ["Marciana", "PI"],
            ["San Lorenzo A Pagnatico", "PI"],
            ["San Frediano A Settimo", "PI"],
            ["San Benedetto A Settimo", "PI"],
            ["Latignano", "PI"],
        ],
        "56022": [["Castelfranco Di Sotto", "PI"], ["Villa Campanile", "PI"], ["Orentano", "PI"]],
        "56023": [
            ["Navacchio", "PI"],
            ["San Lorenzo Alle Corti", "PI"],
            ["Montione", "PI"],
            ["Musigliano", "PI"],
            ["Ripoli", "PI"],
        ],
        "56024": [["Corazzano", "PI"], ["La Serra", "PI"], ["Ponte A Egola", "PI"]],
        "56025": [
            ["Montecastello", "PI"],
            ["Pontedera", "PI"],
            ["La Borra", "PI"],
            ["Il Romito", "PI"],
            ["Treggiaia", "PI"],
            ["La Rotta", "PI"],
            ["Santa Lucia", "PI"],
        ],
        "56028": [
            ["Isola", "PI"],
            ["La Scala", "PI"],
            ["San Miniato Basso", "PI"],
            ["San Miniato", "PI"],
            ["Ponte A Elsa", "PI"],
        ],
        "56029": [["Staffoli", "PI"], ["Santa Croce Sull'Arno", "PI"]],
        "56030": [
            ["Selvatelle", "PI"],
            ["Orciatico", "PI"],
            ["Soiana", "PI"],
            ["Terricciola", "PI"],
            ["Morrona", "PI"],
            ["Lajatico", "PI"],
        ],
        "56031": [["Bientina", "PI"], ["Quattro Strade", "PI"]],
        "56032": [["La Croce", "PI"], ["Buti", "PI"], ["Cascine", "PI"]],
        "56033": [["San Pietro Belvedere", "PI"], ["Capannoli", "PI"]],
        "56034": [["Rivalto", "PI"], ["Casciana Terme", "PI"], ["Chianni", "PI"]],
        "56035": [
            ["Usigliano", "PI"],
            ["Cevoli", "PI"],
            ["Lavaiano", "PI"],
            ["Casciana Alta", "PI"],
            ["Perignano", "PI"],
            ["Le Casine", "PI"],
            ["Casciana Terme Lari", "PI"],
            ["Lari", "PI"],
            ["Spinelli", "PI"],
        ],
        "56036": [
            ["Montefoscoli", "PI"],
            ["Palaia", "PI"],
            ["Villa Saletta", "PI"],
            ["Alica", "PI"],
            ["Forcoli", "PI"],
            ["Partino", "PI"],
        ],
        "56037": [
            ["Fabbrica", "PI"],
            ["Ghizzano Di Peccioli", "PI"],
            ["Fabbrica Di Peccioli", "PI"],
            ["Ghizzano", "PI"],
            ["Peccioli", "PI"],
            ["Legoli", "PI"],
        ],
        "56038": [["Giardino", "PI"], ["Ponsacco", "PI"]],
        "56040": [
            ["Monteverdi Marittimo", "PI"],
            ["Guardistallo", "PI"],
            ["Orciano Pisano", "PI"],
            ["Montescudaio", "PI"],
            ["Casale Marittimo", "PI"],
            ["Cenaia", "PI"],
            ["Casino Di Terra", "PI"],
            ["Sassa", "PI"],
            ["Castellina Marittima", "PI"],
            ["Montecatini Val Di Cecina", "PI"],
            ["Castello Di Querceto", "PI"],
            ["Canneto", "PI"],
            ["Pieve Di Santa Luce", "PI"],
            ["Ponteginori", "PI"],
            ["Canneto Di Monteverdi", "PI"],
            ["Crespina", "PI"],
            ["Le Badie", "PI"],
            ["Pastina", "PI"],
            ["Pomaia", "PI"],
            ["Santa Luce", "PI"],
        ],
        "56041": [["Sasso Pisano", "PI"], ["Castelnuovo Di Val Di Cecina", "PI"], ["Montecastelli Pisano", "PI"]],
        "56042": [["Crespina Lorenzana", "PI"], ["Lorenzana", "PI"]],
        "56043": [["Luciana", "PI"], ["Fauglia", "PI"]],
        "56044": [["Lustignano", "PI"], ["Larderello", "PI"], ["Serrazzano", "PI"], ["Montecerboli", "PI"]],
        "56045": [
            ["San Dalmazio", "PI"],
            ["Montegemoli", "PI"],
            ["Micciano", "PI"],
            ["Libbiano", "PI"],
            ["Pomarance", "PI"],
        ],
        "56046": [["Riparbella", "PI"]],
        "56048": [
            ["Volterra", "PI"],
            ["Pignano", "PI"],
            ["Mazzolla", "PI"],
            ["Villamagna", "PI"],
            ["Ulignano", "PI"],
            ["Saline Di Volterra", "PI"],
            ["Saline", "PI"],
        ],
        "56100": [["Pisa", "PI"]],
        "56121": [["Putignano", "PI"], ["Pisa", "PI"], ["Riglione", "PI"], ["Coltano", "PI"]],
        "56122": [["San Piero A Grado", "PI"], ["Pisa", "PI"]],
        "56123": [["Pisa", "PI"]],
        "56124": [["Pisa", "PI"]],
        "56125": [["Pisa", "PI"]],
        "56126": [["Pisa", "PI"]],
        "56127": [["Pisa", "PI"]],
        "56128": [["Pisa", "PI"]],
        "59011": [["Seano", "PO"], ["Bacchereto", "PO"]],
        "59013": [["Fornacelle", "PO"], ["Montemurlo", "PO"], ["Oste", "PO"]],
        "59015": [
            ["La Serra", "PO"],
            ["Artimino", "PO"],
            ["Poggio Alla Malva", "PO"],
            ["Carmignano", "PO"],
            ["Comeana", "PO"],
        ],
        "59016": [["Poggio A Caiano", "PO"], ["Poggetto", "PO"]],
        "59021": [["La Briglia", "PO"], ["Vaiano", "PO"], ["Schignano", "PO"]],
        "59024": [
            ["Mercatale Vernio", "PO"],
            ["Mercatale", "PO"],
            ["Cavarzano", "PO"],
            ["San Quirico Di Vernio", "PO"],
            ["San Quirico", "PO"],
            ["Vernio", "PO"],
        ],
        "59025": [
            ["Il Fabbro", "PO"],
            ["Cantagallo", "PO"],
            ["Carmignanello", "PO"],
            ["Usella", "PO"],
            ["Luicciana", "PO"],
        ],
        "59026": [["Montepiano", "PO"]],
        "59100": [
            ["Cafaggio", "PO"],
            ["Galciana", "PO"],
            ["Santa Lucia", "PO"],
            ["Figline Di Prato", "PO"],
            ["Mezzana", "PO"],
            ["Narnali", "PO"],
            ["Santa Maria A Colonica", "PO"],
            ["Iolo", "PO"],
            ["Viaccia", "PO"],
            ["San Giorgio A Colonica", "PO"],
            ["Paperino", "PO"],
            ["Prato", "PO"],
            ["Maliseti", "PO"],
            ["Coiano", "PO"],
            ["La Querce", "PO"],
            ["Tavola", "PO"],
        ],
        "51010": [
            ["Traversagna", "PT"],
            ["Marliana", "PT"],
            ["Montagnana", "PT"],
            ["Santa Lucia Uzzanese", "PT"],
            ["Forone", "PT"],
            ["Avaglio", "PT"],
            ["Margine Coperta", "PT"],
            ["Santa Lucia", "PT"],
            ["Serra Pistoiese", "PT"],
            ["Uzzano", "PT"],
            ["Casore Del Monte", "PT"],
            ["Momigno", "PT"],
            ["Massa E Cozzile", "PT"],
        ],
        "51011": [["Buggiano", "PT"], ["Borgo A Buggiano", "PT"]],
        "51012": [["Veneri", "PT"], ["Ponte All'Abate", "PT"], ["Castellare Di Pescia", "PT"], ["Collodi", "PT"]],
        "51013": [["Chiesina Uzzanese", "PT"], ["Chiesanuova", "PT"], ["Chiesanuova Uzzanese", "PT"]],
        "51015": [
            ["Cintolese", "PT"],
            ["Montevettolini", "PT"],
            ["Pozzarello", "PT"],
            ["Monsummano Terme", "PT"],
            ["Grotta Giusti", "PT"],
            ["Uggia", "PT"],
            ["Pazzera", "PT"],
        ],
        "51016": [
            ["Nievole", "PT"],
            ["Montecatini Val Di Nievole", "PT"],
            ["Montecatini Terme", "PT"],
            ["Montecatini Alto", "PT"],
        ],
        "51017": [
            ["San Quirico", "PT"],
            ["Pietrabuona", "PT"],
            ["Pescia", "PT"],
            ["Castelvecchio", "PT"],
            ["Vellano", "PT"],
            ["San Quirico Valleriana", "PT"],
            ["Castelvecchio Di Vellano", "PT"],
            ["Pontito", "PT"],
        ],
        "51018": [["Pieve A Nievole", "PT"]],
        "51019": [["Ponte Buggianese", "PT"], ["Anchione", "PT"]],
        "51020": [
            ["Castello", "PT"],
            ["Prunetta", "PT"],
            ["Popiglio", "PT"],
            ["Calamecca", "PT"],
            ["Pavana", "PT"],
            ["San Pellegrino Al Cassero", "PT"],
            ["Treppio", "PT"],
            ["San Pellegrino", "PT"],
            ["Pavana Pistoiese", "PT"],
            ["Prataccio", "PT"],
            ["Torri", "PT"],
            ["Collina", "PT"],
            ["Crespole", "PT"],
            ["Frassignoni", "PT"],
            ["Piteglio", "PT"],
            ["La Lima", "PT"],
            ["Sambuca Pistoiese", "PT"],
        ],
        "51021": [["Abetone", "PT"], ["Le Regine", "PT"]],
        "51024": [["Pianosinatico", "PT"], ["Pian Degli Ontani", "PT"], ["Cutigliano", "PT"]],
        "51028": [
            ["San Marcello Pistoiese", "PT"],
            ["Pontepetri", "PT"],
            ["Gavinana", "PT"],
            ["Campo Tizzoro", "PT"],
            ["Bardalone", "PT"],
            ["Limestre Pistoiese", "PT"],
            ["Mammiano", "PT"],
            ["Maresca", "PT"],
            ["Lizzano Pistoiese", "PT"],
            ["Limestre", "PT"],
        ],
        "51030": [["Montagnana Pistoiese", "PT"]],
        "51031": [["San Michele", "PT"], ["Agliana", "PT"], ["San Piero", "PT"]],
        "51034": [
            ["Ponte Di Serravalle", "PT"],
            ["Stazione Masotti", "PT"],
            ["Serravalle Pistoiese", "PT"],
            ["Casalguidi", "PT"],
        ],
        "51035": [
            ["San Baronto", "PT"],
            ["Lamporecchio", "PT"],
            ["Porciano", "PT"],
            ["Mastromarco", "PT"],
            ["Orbignano", "PT"],
        ],
        "51036": [["San Rocco", "PT"], ["Larciano", "PT"], ["Castelmartini", "PT"]],
        "51037": [
            ["Fognano Di Montale", "PT"],
            ["Fognano", "PT"],
            ["Montale", "PT"],
            ["Stazione Di Montale", "PT"],
            ["Tobbiana", "PT"],
        ],
        "51039": [
            ["Catena", "PT"],
            ["Olmi", "PT"],
            ["Santonuovo", "PT"],
            ["Quarrata", "PT"],
            ["Montemagno", "PT"],
            ["Ferruccia", "PT"],
            ["Tizzana", "PT"],
            ["Montemagno Di Quarrata", "PT"],
        ],
        "51100": [
            ["Candeglia", "PT"],
            ["Capostrada", "PT"],
            ["Saturnana", "PT"],
            ["Ponzano", "PT"],
            ["Orsigna", "PT"],
            ["Pontelungo", "PT"],
            ["Piazza", "PT"],
            ["San Felice", "PT"],
            ["Piastre", "PT"],
            ["Masiano", "PT"],
            ["Chiazzano", "PT"],
            ["Le Grazie", "PT"],
            ["Valdibrana", "PT"],
            ["Grazie", "PT"],
            ["Piteccio", "PT"],
            ["Pistoia", "PT"],
            ["Villa Di Baggio", "PT"],
            ["Villa Baggio", "PT"],
            ["Pracchia", "PT"],
            ["Corbezzi", "PT"],
            ["Bottegone", "PT"],
            ["Cireglio", "PT"],
            ["Sammomme'", "PT"],
            ["Santomato", "PT"],
        ],
        "53011": [["Fonterutoli", "SI"], ["Castellina In Chianti", "SI"]],
        "53012": [["Chiusdino", "SI"], ["Ciciano", "SI"], ["Frosini", "SI"], ["Montalcinello", "SI"]],
        "53013": [
            ["Lecchi", "SI"],
            ["Nusenna", "SI"],
            ["Castagnoli", "SI"],
            ["Monti", "SI"],
            ["Ama", "SI"],
            ["Gaiole In Chianti", "SI"],
        ],
        "53014": [
            ["Ponte A Tressa", "SI"],
            ["Lucignano D'Arbia", "SI"],
            ["Monteroni D'Arbia", "SI"],
            ["Corsano", "SI"],
            ["Ville Di Corsano", "SI"],
            ["Ponte D'Arbia", "SI"],
        ],
        "53015": [
            ["Iesa", "SI"],
            ["San Lorenzo A Merse", "SI"],
            ["Monticiano", "SI"],
            ["Scalvaia", "SI"],
            ["Tocchi", "SI"],
        ],
        "53016": [["Casciano", "SI"], ["Murlo", "SI"], ["Vescovado", "SI"]],
        "53017": [["Lucarelli", "SI"], ["Radda In Chianti", "SI"]],
        "53018": [["Rosia", "SI"], ["Sovicille", "SI"], ["San Rocco A Pilli", "SI"]],
        "53019": [
            ["Vagliagli", "SI"],
            ["Casetta", "SI"],
            ["Quercegrossa", "SI"],
            ["Ponte A Bozzone", "SI"],
            ["Castelnuovo Berardenga", "SI"],
            ["Pianella", "SI"],
            ["Monteaperti", "SI"],
            ["San Gusme'", "SI"],
        ],
        "53020": [
            ["Montisi", "SI"],
            ["Trequanda", "SI"],
            ["Castelmuzio", "SI"],
            ["Petroio", "SI"],
            ["San Giovanni D'Asso", "SI"],
        ],
        "53021": [["Abbadia San Salvatore", "SI"]],
        "53022": [["Buonconvento", "SI"]],
        "53023": [
            ["Castiglione D'Orcia", "SI"],
            ["Gallina", "SI"],
            ["Bagni Di San Filippo", "SI"],
            ["Bagni San Filippo", "SI"],
            ["Campiglia D'Orcia", "SI"],
            ["Vivo D'Orcia", "SI"],
        ],
        "53024": [
            ["Montalcino", "SI"],
            ["Sant'Angelo In Colle", "SI"],
            ["Monte Amiata", "SI"],
            ["Torrenieri", "SI"],
            ["Castelnuovo Dell'Abate", "SI"],
        ],
        "53025": [["Saragiolo", "SI"], ["Piancastagnaio", "SI"]],
        "53026": [["Monticchiello", "SI"], ["Pienza", "SI"]],
        "53027": [["San Quirico D'Orcia", "SI"], ["Bagno Vignoni", "SI"]],
        "53030": [
            ["Belforte", "SI"],
            ["Anqua", "SI"],
            ["Castel San Giminiano", "SI"],
            ["Castel San Gimignano", "SI"],
            ["Radicondoli", "SI"],
        ],
        "53031": [["Monteguidi", "SI"], ["Pievescola", "SI"], ["Casole D'Elsa", "SI"]],
        "53034": [
            ["Quartaia", "SI"],
            ["Colle Di Val D'Elsa", "SI"],
            ["Gracciano Di Colle Val D'Elsa", "SI"],
            ["Campiglia", "SI"],
        ],
        "53035": [
            ["San Martino", "SI"],
            ["Castellina Scalo", "SI"],
            ["Uopini", "SI"],
            ["Monteriggioni", "SI"],
            ["Belverde", "SI"],
            ["Castellina In Chianti Stazione", "SI"],
            ["Badesse", "SI"],
            ["Strove", "SI"],
            ["Tognazza", "SI"],
        ],
        "53036": [["Poggibonsi", "SI"], ["Bellavista", "SI"], ["Staggia", "SI"]],
        "53037": [["Ulignano", "SI"], ["Badia A Elmi", "SI"], ["San Gimignano", "SI"]],
        "53040": [
            ["Serre Di Rapolano", "SI"],
            ["Contignano", "SI"],
            ["Radicofani", "SI"],
            ["Cetona", "SI"],
            ["San Casciano Dei Bagni", "SI"],
            ["Celle Sul Rigo", "SI"],
            ["Palazzone", "SI"],
            ["Rapolano Terme", "SI"],
            ["Piazze", "SI"],
        ],
        "53041": [
            ["Chiusure", "SI"],
            ["Arbia", "SI"],
            ["Asciano", "SI"],
            ["Monte Sante Marie", "SI"],
            ["Monte Oliveto Maggiore", "SI"],
        ],
        "53042": [["Chianciano Terme", "SI"]],
        "53043": [["Chiusi Stazione", "SI"], ["Chiusi", "SI"], ["Montallese", "SI"], ["Chiusi Scalo", "SI"]],
        "53045": [
            ["Montepulciano Stazione", "SI"],
            ["Abbadia", "SI"],
            ["Valiano", "SI"],
            ["Acquaviva", "SI"],
            ["Abbadia Di Montepulciano", "SI"],
            ["Gracciano", "SI"],
            ["Montepulciano", "SI"],
            ["Sant'Albino", "SI"],
        ],
        "53047": [["Sarteano", "SI"]],
        "53048": [
            ["Rigomagno", "SI"],
            ["Guazzino", "SI"],
            ["Pieve Di Sinalunga", "SI"],
            ["Rigaiolo", "SI"],
            ["Bettolle", "SI"],
            ["Sinalunga", "SI"],
            ["Scrofiano", "SI"],
        ],
        "53049": [["Montefollonico", "SI"], ["Torrita Stazione", "SI"], ["Torrita Di Siena", "SI"]],
        "53100": [
            ["Costalpino", "SI"],
            ["Sant'Andrea A Montecchio", "SI"],
            ["Siena", "SI"],
            ["Isola D'Arbia", "SI"],
            ["Coroncina", "SI"],
            ["Ponte Al Bozzone", "SI"],
            ["Malafrasca", "SI"],
            ["Taverne D'Arbia", "SI"],
        ],
        "39010": [
            ["Grissian", "BZ"],
            ["Saltusio", "BZ"],
            ["Tisens", "BZ"],
            ["Tesimo", "BZ"],
            ["Unsere liebe Frau i. W.", "BZ"],
            ["Sinich", "BZ"],
            ["Nals", "BZ"],
            ["Pawigl", "BZ"],
            ["Nalles", "BZ"],
            ["Sigmundskron", "BZ"],
            ["Gfrill", "BZ"],
            ["Platzers", "BZ"],
            ["St. Nikolaus/Ulten", "BZ"],
            ["Vilpian", "BZ"],
            ["Vernue", "BZ"],
            ["Gfeis", "BZ"],
            ["Schlaneid", "BZ"],
            ["Pfelders", "BZ"],
            ["Saltaus", "BZ"],
            ["Verschneid", "BZ"],
            ["Kuens", "BZ"],
            ["St. Helena", "BZ"],
            ["St. Gertraud", "BZ"],
            ["Riffian", "BZ"],
            ["Caines", "BZ"],
            ["St. Felix", "BZ"],
            ["San Felice", "BZ"],
            ["Unsere Liebe Frau Im Wald", "BZ"],
            ["Cermes", "BZ"],
            ["Senale San Felice", "BZ"],
            ["San Martino In Passiria", "BZ"],
            ["Andrian", "BZ"],
            ["San Felice Val Di Non", "BZ"],
            ["Frangart", "BZ"],
            ["Prissia", "BZ"],
            ["St. Martin in Passeier", "BZ"],
            ["Mölten", "BZ"],
            ["St. Pankraz", "BZ"],
            ["San Pancrazio", "BZ"],
            ["Meltina", "BZ"],
            ["Vöran", "BZ"],
            ["Hafling", "BZ"],
            ["Tscherms", "BZ"],
            ["Avelengo", "BZ"],
            ["Senale", "BZ"],
            ["Sant'Orsola In Passiria", "BZ"],
            ["Rifiano", "BZ"],
            ["Andriano", "BZ"],
            ["Gargazon", "BZ"],
            ["Prissiano", "BZ"],
            ["Gargazzone", "BZ"],
            ["Walten", "BZ"],
            ["Verano", "BZ"],
        ],
        "39011": [
            ["Lana", "BZ"],
            ["Pawig", "BZ"],
            ["Vigiljoc", "BZ"],
            ["Völlan", "BZ"],
            ["Pavicolo", "BZ"],
            ["Monte San Vigilio", "BZ"],
        ],
        "39012": [
            ["Borgo Vittoria", "BZ"],
            ["Sinic", "BZ"],
            ["Sinigo", "BZ"],
            ["Obermais", "BZ"],
            ["Gratsch", "BZ"],
            ["Meran Sinic", "BZ"],
            ["Untermais", "BZ"],
            ["Meran", "BZ"],
            ["Merano", "BZ"],
        ],
        "39013": [
            ["Moos", "BZ"],
            ["Moso In Passiria", "BZ"],
            ["Stuls", "BZ"],
            ["Plan In Passiria", "BZ"],
            ["Platt", "BZ"],
            ["Pfelder", "BZ"],
            ["Rabenstein", "BZ"],
            ["Ulfas", "BZ"],
        ],
        "39014": [["Postal", "BZ"], ["Burgstall", "BZ"]],
        "39015": [
            ["Walte", "BZ"],
            ["San Leonardo In Passiria", "BZ"],
            ["St. Leonhard in Pass.", "BZ"],
            ["Schweinsteg", "BZ"],
            ["Valtina", "BZ"],
            ["Sant'Orsola", "BZ"],
            ["Windegg", "BZ"],
        ],
        "39016": [
            ["St. Moritz/Ulten", "BZ"],
            ["Kuppelwies", "BZ"],
            ["St.Nikolau", "BZ"],
            ["Santa Valburga Ultimo", "BZ"],
            ["Ultimo", "BZ"],
            ["St.Walburg Ulte", "BZ"],
            ["Santa Geltrude In Ultimo", "BZ"],
            ["San Nicolo' Ultimo", "BZ"],
            ["San Nicolo'", "BZ"],
            ["Santa Valburga", "BZ"],
            ["St. Walburg/Ulten", "BZ"],
            ["Santa Gertrude", "BZ"],
        ],
        "39017": [["Verdins", "BZ"], ["Videgg", "BZ"], ["Schenna", "BZ"], ["Tall", "BZ"], ["Scena", "BZ"]],
        "39018": [
            ["Vilpiano", "BZ"],
            ["Siebeneich", "BZ"],
            ["Vilpia", "BZ"],
            ["Terlan", "BZ"],
            ["Terlano", "BZ"],
            ["Settequerce", "BZ"],
        ],
        "39019": [["Tirolo", "BZ"], ["Tirol", "BZ"]],
        "39020": [
            ["Tanas", "BZ"],
            ["Vernagt", "BZ"],
            ["Gand/Martell", "BZ"],
            ["Lichtenberg", "BZ"],
            ["Schluderns", "BZ"],
            ["Karthaus", "BZ"],
            ["Eyrs", "BZ"],
            ["Staben", "BZ"],
            ["Taufers i. Münstertal", "BZ"],
            ["Plawenn", "BZ"],
            ["Melag", "BZ"],
            ["Planeil", "BZ"],
            ["St. Valentin a. d. H.", "BZ"],
            ["Laatsch", "BZ"],
            ["Graun/Vinschg.", "BZ"],
            ["Matsch", "BZ"],
            ["Unsere Frau i. Schnals", "BZ"],
            ["Freiberg", "BZ"],
            ["Marein", "BZ"],
            ["Töll", "BZ"],
            ["Tartsch", "BZ"],
            ["Tabland", "BZ"],
            ["Marlengo", "BZ"],
            ["Marling", "BZ"],
            ["Tschengls", "BZ"],
            ["Glurns", "BZ"],
            ["Goldrain", "BZ"],
            ["Pedroß", "BZ"],
            ["Freiberg Vinschga", "BZ"],
            ["Tschars", "BZ"],
            ["Katharinaberg", "BZ"],
            ["Kastelbell", "BZ"],
            ["Castelbello Ciardes", "BZ"],
            ["Tol", "BZ"],
            ["Unser Fra", "BZ"],
            ["Montefranco In Venosta", "BZ"],
            ["Tarsch", "BZ"],
            ["Gries", "BZ"],
            ["Ciardes", "BZ"],
            ["Tubre", "BZ"],
            ["Sluderno", "BZ"],
            ["Santa Caterina", "BZ"],
            ["Gomagoi", "BZ"],
            ["Glorenza", "BZ"],
            ["Parcines", "BZ"],
            ["Partschins", "BZ"],
            ["Senales", "BZ"],
            ["Tel", "BZ"],
            ["Montefranco", "BZ"],
            ["Rabland", "BZ"],
            ["Rabla'", "BZ"],
            ["Madonna", "BZ"],
            ["Trafoi", "BZ"],
            ["Castelbello", "BZ"],
            ["Martello", "BZ"],
            ["Hinterkirch", "BZ"],
            ["Morter", "BZ"],
            ["Stilfs", "BZ"],
            ["Rifair", "BZ"],
            ["Martell", "BZ"],
        ],
        "39021": [
            ["Laces", "BZ"],
            ["Latsch", "BZ"],
            ["Morter", "BZ"],
            ["Morte", "BZ"],
            ["Goldrai", "BZ"],
            ["Tarsc", "BZ"],
            ["St. Martin am Kofl", "BZ"],
            ["Coldrano", "BZ"],
            ["Tarres", "BZ"],
        ],
        "39022": [
            ["Oberplars", "BZ"],
            ["Vellau", "BZ"],
            ["Aschbach", "BZ"],
            ["Plars", "BZ"],
            ["Lagundo", "BZ"],
            ["Algund", "BZ"],
        ],
        "39023": [
            ["Laas", "BZ"],
            ["Lasa", "BZ"],
            ["Allitz", "BZ"],
            ["Tana", "BZ"],
            ["Tarnell", "BZ"],
            ["Eyr", "BZ"],
            ["Tanas", "BZ"],
            ["Tschengel", "BZ"],
            ["Cengles", "BZ"],
            ["Oris", "BZ"],
        ],
        "39024": [
            ["Laatsc", "BZ"],
            ["Marienberg", "BZ"],
            ["Planol", "BZ"],
            ["Planei", "BZ"],
            ["Tartsc", "BZ"],
            ["Schleis", "BZ"],
            ["Matsc", "BZ"],
            ["Mazia", "BZ"],
            ["Laudes", "BZ"],
            ["Burgusio", "BZ"],
            ["Schlinig", "BZ"],
            ["Burgeis", "BZ"],
            ["Tarces", "BZ"],
            ["Malles Venosta", "BZ"],
            ["Mals", "BZ"],
        ],
        "39025": [["Plaus", "BZ"], ["Stabe", "BZ"], ["Stava", "BZ"], ["Naturno", "BZ"], ["Naturns", "BZ"]],
        "39026": [
            ["Agums", "BZ"],
            ["Montechiaro", "BZ"],
            ["Prad", "BZ"],
            ["Lichtenber", "BZ"],
            ["Prato Allo Stelvio", "BZ"],
        ],
        "39027": [["Resia", "BZ"], ["Reschen", "BZ"], ["San Valentino Alla Muta", "BZ"], ["Curon Venosta", "BZ"]],
        "39028": [
            ["Silandro", "BZ"],
            ["Covelano", "BZ"],
            ["Vezzano", "BZ"],
            ["Schlanders", "BZ"],
            ["Talatsch", "BZ"],
            ["Vezzan", "BZ"],
            ["Goefla", "BZ"],
            ["Kortsch", "BZ"],
            ["Göflan", "BZ"],
        ],
        "39029": [
            ["Trafo", "BZ"],
            ["Gomago", "BZ"],
            ["Stelvio", "BZ"],
            ["Sulden", "BZ"],
            ["Solda", "BZ"],
            ["Trafoi", "BZ"],
            ["Gomagoi", "BZ"],
        ],
        "39030": [
            ["San Lorenzo Di Sebato", "BZ"],
            ["St. Sigmund", "BZ"],
            ["Vallarga", "BZ"],
            ["St. Lorenzen", "BZ"],
            ["Niederolang", "BZ"],
            ["St. Walburg i. Antholz", "BZ"],
            ["Casteldarne", "BZ"],
            ["St. Kassia", "BZ"],
            ["Mühlen/Pfalzen", "BZ"],
            ["St.Martin Gsie", "BZ"],
            ["La Valle", "BZ"],
            ["Obervintl", "BZ"],
            ["Zwischenwasser", "BZ"],
            ["Steinhaus", "BZ"],
            ["Enneberg/Mareo", "BZ"],
            ["St. Jakob in Ahrn", "BZ"],
            ["St. Veit in Prags", "BZ"],
            ["Chienes", "BZ"],
            ["Kiens", "BZ"],
            ["Issing", "BZ"],
            ["Mühlbach b. Gais", "BZ"],
            ["Pflaurenz", "BZ"],
            ["Oberolang", "BZ"],
            ["Greinwalden", "BZ"],
            ["Kampill", "BZ"],
            ["Untergsies", "BZ"],
            ["St. Martin in Gsies", "BZ"],
            ["Pichl", "BZ"],
            ["Untermoi", "BZ"],
            ["Margen", "BZ"],
            ["Saalen", "BZ"],
            ["Onach", "BZ"],
            ["Gais", "BZ"],
            ["Kasern", "BZ"],
            ["St. Johann in Ahrn", "BZ"],
            ["St.Vigi", "BZ"],
            ["Ahrntal", "BZ"],
            ["Oberrasen", "BZ"],
            ["Niederrasen", "BZ"],
            ["St. Peter in Ahrn", "BZ"],
            ["Percha", "BZ"],
            ["Vandoies", "BZ"],
            ["Campil", "BZ"],
            ["Valle Di Casies", "BZ"],
            ["Mitterolang", "BZ"],
            ["Hofern", "BZ"],
            ["Valle Aurina", "BZ"],
            ["Nasen", "BZ"],
            ["Untervintl", "BZ"],
            ["Ahornach", "BZ"],
            ["Pikolein", "BZ"],
            ["Perca", "BZ"],
            ["Montal", "BZ"],
            ["St. Vigil i. Enneberg", "BZ"],
            ["Kolfuschg", "BZ"],
            ["San Giovanni In Valle Aurina", "BZ"],
            ["San Giuseppe", "BZ"],
            ["St.Johann In Ahrnta", "BZ"],
            ["St.Magdalen", "BZ"],
            ["St. Martin in Thurn/S. Martin de Tor", "BZ"],
            ["Longiaru'", "BZ"],
            ["San Giacomo In Valle Aurina", "BZ"],
            ["St.Jakob In Ahrnta", "BZ"],
            ["St.Sigmun", "BZ"],
            ["Moo", "BZ"],
            ["Weitental", "BZ"],
            ["Pedero", "BZ"],
            ["Ehrenburg", "BZ"],
            ["Ellen", "BZ"],
            ["St. Magdalena i. G.", "BZ"],
            ["Wengen/La Val", "BZ"],
            ["Oberwielenbach", "BZ"],
            ["Rasun Anterselva", "BZ"],
            ["Wielenberg", "BZ"],
            ["San Sigismondo", "BZ"],
            ["Rasun Di Sotto", "BZ"],
            ["Villa Ottone", "BZ"],
            ["Stefansdorf", "BZ"],
            ["Kurfar", "BZ"],
            ["Longega", "BZ"],
            ["Weißenbach", "BZ"],
            ["San Vigilio", "BZ"],
            ["Geiselsberg", "BZ"],
            ["Anterselva Di Mezzo", "BZ"],
            ["Tesselberg", "BZ"],
            ["Niedervintl", "BZ"],
            ["Vandoies Di Sotto", "BZ"],
            ["Vintl", "BZ"],
            ["Prettau", "BZ"],
            ["Terenten", "BZ"],
            ["Welschellen", "BZ"],
            ["Rasun Di Sopra", "BZ"],
            ["Terento", "BZ"],
            ["Lappach", "BZ"],
            ["Piccolino", "BZ"],
            ["Rodeneck", "BZ"],
            ["Sexten", "BZ"],
            ["Sesto", "BZ"],
            ["Cadipietra", "BZ"],
            ["Pfalzen", "BZ"],
            ["Falzes", "BZ"],
            ["Pfunders", "BZ"],
            ["Rein", "BZ"],
            ["San Martino In Casies", "BZ"],
            ["Uttenheim", "BZ"],
            ["Selva Dei Molini", "BZ"],
            ["Mühlwald", "BZ"],
            ["Fundres", "BZ"],
            ["Predoi", "BZ"],
            ["Prags", "BZ"],
            ["Braies", "BZ"],
            ["Vandoies Di Sopra", "BZ"],
            ["Valdaora Di Mezzo", "BZ"],
            ["Unterplanken", "BZ"],
            ["Valdaora Di Sotto", "BZ"],
            ["Platten", "BZ"],
            ["Olang", "BZ"],
            ["Valdaora", "BZ"],
            ["Luttach", "BZ"],
            ["Antholz", "BZ"],
            ["San Martino In Badia", "BZ"],
            ["Lutago", "BZ"],
            ["Pederoa", "BZ"],
            ["Marebbe", "BZ"],
            ["Santa Maddalena", "BZ"],
        ],
        "39031": [
            ["Luns", "BZ"],
            ["Bruneck", "BZ"],
            ["Riscone", "BZ"],
            ["Reischach", "BZ"],
            ["Aufhofen", "BZ"],
            ["Teodone", "BZ"],
            ["Dietenheim", "BZ"],
            ["Stegen", "BZ"],
            ["Brunico", "BZ"],
            ["St. Georgen", "BZ"],
        ],
        "39032": [
            ["Kematen", "BZ"],
            ["Mühlen i. Taufers", "BZ"],
            ["Ahornac", "BZ"],
            ["Moehlen In Taufer", "BZ"],
            ["Taufers/Ahrntal", "BZ"],
            ["Campo Tures", "BZ"],
            ["Sand in Taufers", "BZ"],
            ["Riva Di Tures", "BZ"],
            ["Acereto", "BZ"],
            ["Molini Di Tures", "BZ"],
        ],
        "39033": [["Kolfusch", "BZ"], ["Colfosco", "BZ"], ["Corvara In Badia", "BZ"], ["Corvara", "BZ"]],
        "39034": [["Toblach", "BZ"], ["Dobbiaco", "BZ"], ["Aufkirchen", "BZ"], ["Wahlen", "BZ"]],
        "39035": [["Monguelfo", "BZ"], ["Taisten", "BZ"], ["Tesido", "BZ"], ["Welsberg", "BZ"]],
        "39036": [
            ["St. Kassian", "BZ"],
            ["San Cassiano", "BZ"],
            ["Stern", "BZ"],
            ["Pedraces", "BZ"],
            ["Badia", "BZ"],
            ["Abtei/Badia", "BZ"],
            ["La Villa", "BZ"],
            ["Pedrace", "BZ"],
        ],
        "39037": [
            ["Mühlbach", "BZ"],
            ["Vals", "BZ"],
            ["Meransen", "BZ"],
            ["Spinges", "BZ"],
            ["Rodengo", "BZ"],
            ["Rio Di Pusteria", "BZ"],
        ],
        "39038": [["Vierschach", "BZ"], ["Winnebach", "BZ"], ["San Candido", "BZ"]],
        "39039": [["Villabassa", "BZ"], ["Niederdorf", "BZ"]],
        "39040": [
            ["Stilves", "BZ"],
            ["Penon", "BZ"],
            ["Kastelruth", "BZ"],
            ["Proves", "BZ"],
            ["Campodazzo", "BZ"],
            ["Mauls", "BZ"],
            ["Villandro", "BZ"],
            ["San Pietro", "BZ"],
            ["Lajen", "BZ"],
            ["Mareta", "BZ"],
            ["Seis am Schlern", "BZ"],
            ["Siusi", "BZ"],
            ["Ridanna", "BZ"],
            ["Barbiano", "BZ"],
            ["Petersberg", "BZ"],
            ["Olmi", "BZ"],
            ["Casateia", "BZ"],
            ["Tramin", "BZ"],
            ["Stanghe", "BZ"],
            ["Leone Santa Elisabetta", "BZ"],
            ["Neustift", "BZ"],
            ["Ratschings", "BZ"],
            ["Laion", "BZ"],
            ["Cauria", "BZ"],
            ["Novacella", "BZ"],
            ["Varna", "BZ"],
            ["Rasa", "BZ"],
            ["Salorno", "BZ"],
            ["San Lugano", "BZ"],
            ["Ridnaun", "BZ"],
            ["Auer", "BZ"],
            ["Ora", "BZ"],
            ["Pfitsch", "BZ"],
            ["Aldino", "BZ"],
            ["Laag", "BZ"],
            ["Ponte Gardena", "BZ"],
            ["Racines", "BZ"],
            ["Salurn", "BZ"],
            ["Mareit", "BZ"],
            ["Villanders", "BZ"],
            ["Sciaves", "BZ"],
            ["Luson", "BZ"],
            ["Vahrn", "BZ"],
            ["Mühlen/Truden", "BZ"],
            ["Tanürz", "BZ"],
            ["Villnöß", "BZ"],
            ["Proveis", "BZ"],
            ["Pfulters", "BZ"],
            ["Söll", "BZ"],
            ["Pflersch", "BZ"],
            ["St. Michael/Kastelr.", "BZ"],
            ["Graun/Unterl.", "BZ"],
            ["Lüsen", "BZ"],
            ["Flitt", "BZ"],
            ["Garn", "BZ"],
            ["Buchholz", "BZ"],
            ["Entiklar", "BZ"],
            ["Schmuders", "BZ"],
            ["Kollmann", "BZ"],
            ["Montan", "BZ"],
            ["Hohlen", "BZ"],
            ["Albions", "BZ"],
            ["Castelrotto", "BZ"],
            ["Naz Sciaves", "BZ"],
            ["Pruno", "BZ"],
            ["Feldthurns", "BZ"],
            ["St.Peter Laje", "BZ"],
            ["Pruno Di Stilves", "BZ"],
            ["Velturno", "BZ"],
            ["Gastei", "BZ"],
            ["Trodena", "BZ"],
            ["Magre' Sulla Strada Del Vino", "BZ"],
            ["Redagno", "BZ"],
            ["Laurein", "BZ"],
            ["Mules", "BZ"],
            ["Lauregno", "BZ"],
            ["Alpe Di Siusi", "BZ"],
            ["Raa", "BZ"],
            ["Radein", "BZ"],
            ["Loewenviertel Elisabethsiedlun", "BZ"],
            ["Seiser Al", "BZ"],
            ["Atzwang", "BZ"],
            ["Truden", "BZ"],
            ["St.Lugan", "BZ"],
            ["Natz", "BZ"],
            ["Stilfes", "BZ"],
            ["Gfrill/Unterland", "BZ"],
            ["Funes", "BZ"],
            ["Fontanefredde", "BZ"],
            ["Schabs", "BZ"],
            ["Elzenbaum", "BZ"],
            ["San Pietro Laion", "BZ"],
            ["Valgiovo", "BZ"],
            ["Seis Am Schler", "BZ"],
            ["Termeno Sulla Strada Del Vino", "BZ"],
            ["Kurtinig", "BZ"],
            ["Waidbruck", "BZ"],
            ["Jaufental", "BZ"],
            ["Hole", "BZ"],
            ["Cortaccia Sulla Strada Del Vino", "BZ"],
            ["St.Pete", "BZ"],
            ["Altrei", "BZ"],
            ["Stange", "BZ"],
            ["Kaltenbrunn", "BZ"],
            ["Anterivo", "BZ"],
            ["Naz", "BZ"],
            ["Kurtatsch", "BZ"],
            ["Tschövas", "BZ"],
            ["Gschnon", "BZ"],
            ["Aldein", "BZ"],
            ["Klerant", "BZ"],
            ["Weißenstein", "BZ"],
            ["S. Lugano", "BZ"],
            ["Innerpfitsch", "BZ"],
            ["Margreid", "BZ"],
            ["Schnauders", "BZ"],
            ["Fennberg", "BZ"],
            ["Tagusens", "BZ"],
            ["Flans", "BZ"],
            ["Pinzon", "BZ"],
            ["St. Andrä_", "BZ"],
            ["St. Oswald", "BZ"],
            ["Afers", "BZ"],
            ["Montagna", "BZ"],
            ["Freins", "BZ"],
            ["Rungg", "BZ"],
            ["St. Leonhard", "BZ"],
            ["Trens", "BZ"],
            ["Telfes", "BZ"],
            ["Spiluck", "BZ"],
            ["St. Peter b. Lajen", "BZ"],
            ["Schrambach", "BZ"],
            ["Gossensaß", "BZ"],
            ["St. Moritz b. Villanders", "BZ"],
            ["Campo Di Trens", "BZ"],
            ["Freienfeld", "BZ"],
            ["Barbian", "BZ"],
            ["Glen", "BZ"],
            ["Cortina Sulla Strada Del Vino", "BZ"],
            ["Viums", "BZ"],
            ["Schalders", "BZ"],
        ],
        "39041": [["Gossensas", "BZ"], ["Brennero", "BZ"], ["Brenner", "BZ"], ["Colle Isarco", "BZ"]],
        "39042": [
            ["Sant'Andrea In Monte", "BZ"],
            ["Albes", "BZ"],
            ["Neustift", "BZ"],
            ["Brixen", "BZ"],
            ["Eores", "BZ"],
            ["St.Andr", "BZ"],
            ["Sarns", "BZ"],
            ["Albeins", "BZ"],
            ["Zinggen", "BZ"],
            ["Afer", "BZ"],
            ["Pinzagen", "BZ"],
            ["Bressanone", "BZ"],
            ["Tschötsch", "BZ"],
            ["Mellaun", "BZ"],
            ["Elvas", "BZ"],
            ["Milland", "BZ"],
            ["Karnol", "BZ"],
            ["Tils", "BZ"],
        ],
        "39043": [
            ["Teis", "BZ"],
            ["Verdings", "BZ"],
            ["Latzfons", "BZ"],
            ["Gufidaun", "BZ"],
            ["Gudon", "BZ"],
            ["Chiusa", "BZ"],
            ["Klausen", "BZ"],
            ["Lazfons", "BZ"],
        ],
        "39044": [["Laghetti", "BZ"], ["Mazon", "BZ"], ["Neumarkt", "BZ"], ["Egna", "BZ"]],
        "39045": [
            ["Oberau", "BZ"],
            ["Mittewald", "BZ"],
            ["Grasstein", "BZ"],
            ["Fortezza", "BZ"],
            ["Franzensfeste", "BZ"],
        ],
        "39046": [["St. Ulrich/Urtijei", "BZ"], ["Ortisei", "BZ"], ["Pufels", "BZ"], ["St. Jakob", "BZ"]],
        "39047": [["Santa Cristina Val Gardena", "BZ"], ["St. Christina/S. Crestina -Gherdeina", "BZ"]],
        "39048": [["Selva Di Val Gardena", "BZ"], ["Selva", "BZ"], ["Wolkenstein/Selva", "BZ"]],
        "39049": [
            ["Flains", "BZ"],
            ["Steckholz", "BZ"],
            ["Thuins", "BZ"],
            ["Kematen/Pfitsch", "BZ"],
            ["Val Di Vizze", "BZ"],
            ["Bahnho", "BZ"],
            ["Tschöfs", "BZ"],
            ["Prati", "BZ"],
            ["Wiesen", "BZ"],
            ["Sterzing", "BZ"],
            ["Ried", "BZ"],
            ["Vipiteno", "BZ"],
            ["Stazione", "BZ"],
        ],
        "39050": [
            ["Valas", "BZ"],
            ["Völs am Schlern", "BZ"],
            ["Fie' Allo Sciliar", "BZ"],
            ["Prösels", "BZ"],
            ["Oberinn", "BZ"],
            ["Breien", "BZ"],
            ["Gummer", "BZ"],
            ["Eggen", "BZ"],
            ["Steinmannwald", "BZ"],
            ["Unterrain/Eppan", "BZ"],
            ["St. Justina/Eppan", "BZ"],
            ["St. Nikolaus i. Eggen", "BZ"],
            ["Missian", "BZ"],
            ["San Nicolo' D'Ega", "BZ"],
            ["Wangen", "BZ"],
            ["Jenesien", "BZ"],
            ["Lengstein", "BZ"],
            ["Seit", "BZ"],
            ["San Genesio Atesino", "BZ"],
            ["Ums", "BZ"],
            ["Perdonig", "BZ"],
            ["St. Jakob/Bozen", "BZ"],
            ["Tiers", "BZ"],
            ["Karneid", "BZ"],
            ["Steinegg", "BZ"],
            ["Birchabruck", "BZ"],
            ["Ponte Nova", "BZ"],
            ["Flaas", "BZ"],
            ["Blumau", "BZ"],
            ["Raut", "BZ"],
            ["St. Konstantin", "BZ"],
            ["Untereggen", "BZ"],
            ["Völser Aicha", "BZ"],
            ["Innichen", "BZ"],
            ["San Paolo", "BZ"],
            ["Afing", "BZ"],
            ["Unterglaning", "BZ"],
            ["Girlan", "BZ"],
            ["Nova Ponente", "BZ"],
            ["St.Pauls", "BZ"],
            ["Unterinn", "BZ"],
            ["St. Pauls/Eppan", "BZ"],
            ["Monte San Pietro", "BZ"],
            ["Petersberg", "BZ"],
            ["Deutschnofen", "BZ"],
            ["Cologna Di Sotto", "BZ"],
            ["Avigna", "BZ"],
            ["Aica Di Fie'", "BZ"],
            ["Tires", "BZ"],
        ],
        "39051": [["Branzoll", "BZ"], ["Bronzolo", "BZ"], ["Pfatten", "BZ"], ["Vadena", "BZ"]],
        "39052": [
            ["St. Josef am See", "BZ"],
            ["St. Nikolaus/Kaltern", "BZ"],
            ["Oberplanitzing", "BZ"],
            ["St. Anton", "BZ"],
            ["Mitterdorf", "BZ"],
            ["Altenburg", "BZ"],
            ["Unterplanitzing", "BZ"],
            ["Kaltern", "BZ"],
            ["Caldaro Sulla Strada Del Vino", "BZ"],
        ],
        "39053": [
            ["Kardaun", "BZ"],
            ["Collepietra", "BZ"],
            ["Contrada Val D'Ega", "BZ"],
            ["San Valentino In Campo", "BZ"],
            ["Prato All'Isarco", "BZ"],
            ["Eggenta", "BZ"],
            ["Cornedo All'Isarco", "BZ"],
            ["Cardano", "BZ"],
            ["Kardaun/Bozen", "BZ"],
            ["Steineg", "BZ"],
            ["Bluma", "BZ"],
            ["Gumme", "BZ"],
        ],
        "39054": [
            ["Gissmann", "BZ"],
            ["Unterin", "BZ"],
            ["Auna Inferiore", "BZ"],
            ["Wange", "BZ"],
            ["Collalbo", "BZ"],
            ["Lengmoos", "BZ"],
            ["Auna Di Sopra", "BZ"],
            ["Oberi", "BZ"],
            ["Sant'Ottilia In Renon", "BZ"],
            ["Oberboze", "BZ"],
            ["Ritten", "BZ"],
            ["Lengstein Am Ritte", "BZ"],
            ["Renon", "BZ"],
            ["Vanga", "BZ"],
            ["Klobenstein", "BZ"],
            ["Soprabolzano", "BZ"],
        ],
        "39055": [
            ["Laives", "BZ"],
            ["San Giacomo Di Laives", "BZ"],
            ["San Giacomo", "BZ"],
            ["Leifers", "BZ"],
            ["Seit Bei Leifer", "BZ"],
            ["La Costa Di Laives", "BZ"],
            ["La Costa", "BZ"],
            ["Pineta", "BZ"],
            ["St.Jakob Bei Boze", "BZ"],
        ],
        "39056": [
            ["Carezza Al Lago", "BZ"],
            ["Karersee", "BZ"],
            ["Carezza", "BZ"],
            ["Welschnofen", "BZ"],
            ["Nova Levante", "BZ"],
        ],
        "39057": [
            ["Cornaiano", "BZ"],
            ["Appiano Sulla Strada Del Vino", "BZ"],
            ["Girla", "BZ"],
            ["Eppan", "BZ"],
            ["San Michele Appiano", "BZ"],
            ["San Michele", "BZ"],
            ["Montiggl", "BZ"],
            ["Frangar", "BZ"],
            ["St. Michael/Eppan", "BZ"],
            ["Frangarto", "BZ"],
        ],
        "39058": [
            ["Pens", "BZ"],
            ["Nordhei", "BZ"],
            ["Sarentino", "BZ"],
            ["Asten", "BZ"],
            ["Riedelsberg", "BZ"],
            ["Bundschen", "BZ"],
            ["Weißenbach/Sarntal", "BZ"],
            ["Reinswald", "BZ"],
            ["Durnholz", "BZ"],
            ["Villa", "BZ"],
            ["Astfeld-Nordheim", "BZ"],
            ["Sarnthein", "BZ"],
            ["Campolasta", "BZ"],
            ["Aberstückl", "BZ"],
        ],
        "39059": [["Wolfsgruben", "BZ"], ["Oberbozen", "BZ"]],
        "39100": [
            ["Kampenn", "BZ"],
            ["Glaning", "BZ"],
            ["Sigmundskro", "BZ"],
            ["Castelfirmiano", "BZ"],
            ["Oberau/Bozen", "BZ"],
            ["Signat", "BZ"],
            ["Rentsch", "BZ"],
            ["Bozen", "BZ"],
            ["Bolzano", "BZ"],
        ],
        "38010": [
            ["Faedo", "TN"],
            ["Campodenno", "TN"],
            ["Spormaggiore", "TN"],
            ["Malgolo", "TN"],
            ["Cavedago", "TN"],
            ["Sporminore", "TN"],
            ["Ronzone", "TN"],
            ["Denno", "TN"],
            ["Dambel", "TN"],
            ["Fai Della Paganella", "TN"],
            ["Andalo", "TN"],
            ["Vigo Di Ton", "TN"],
            ["Casez", "TN"],
            ["San Michele All'Adige", "TN"],
            ["Sanzeno", "TN"],
            ["San Romedio", "TN"],
            ["Banco", "TN"],
            ["Ruffre'", "TN"],
            ["Ton", "TN"],
            ["Sfruz", "TN"],
            ["Romeno", "TN"],
            ["Cima Paganella", "TN"],
            ["Vigo Anaunia", "TN"],
            ["Tavon", "TN"],
        ],
        "38011": [["Seio", "TN"], ["Amblar", "TN"], ["Don", "TN"], ["Sarnonico", "TN"], ["Cavareno", "TN"]],
        "38012": [
            ["Segno", "TN"],
            ["Coredo", "TN"],
            ["Vervò", "TN"],
            ["Smarano", "TN"],
            ["Predaia", "TN"],
            ["Tres", "TN"],
            ["Dermulo", "TN"],
            ["Mollaro", "TN"],
            ["Taio", "TN"],
        ],
        "38013": [["Tret", "TN"], ["Malosco", "TN"], ["Vasio", "TN"], ["Fondo", "TN"]],
        "38015": [["Lavis", "TN"], ["Nave San Felice", "TN"], ["Pressano", "TN"]],
        "38016": [["Mezzocorona", "TN"]],
        "38017": [["Mezzolombardo", "TN"]],
        "38018": [["Molveno", "TN"]],
        "38019": [["Tassullo", "TN"], ["Tuenno", "TN"], ["Nanno", "TN"]],
        "38020": [
            ["Deggiano", "TN"],
            ["Mocenigo", "TN"],
            ["Pellizzano", "TN"],
            ["Cloz", "TN"],
            ["Commezzadura", "TN"],
            ["Bresimo", "TN"],
            ["Rabbi", "TN"],
            ["Rumo", "TN"],
            ["Marcena", "TN"],
            ["Castelfondo", "TN"],
            ["Mestriago", "TN"],
            ["Mezzana", "TN"],
            ["Pracorno", "TN"],
            ["Cis", "TN"],
        ],
        "38021": [["Brez", "TN"]],
        "38022": [["Cavizzana", "TN"], ["Caldes", "TN"], ["Bozzana", "TN"]],
        "38023": [["Mechel", "TN"], ["Caltron", "TN"], ["Cles", "TN"]],
        "38024": [
            ["Cogolo", "TN"],
            ["Cogolo In Val Di Pejo", "TN"],
            ["Celledizzo", "TN"],
            ["Celedizzo", "TN"],
            ["Peio", "TN"],
        ],
        "38025": [["Monclassico", "TN"], ["Dimaro", "TN"]],
        "38026": [["Fucine Di Ossana", "TN"], ["Ossana", "TN"], ["Cusiano", "TN"], ["Fucine", "TN"]],
        "38027": [["Male'", "TN"], ["Terzolas", "TN"], ["Croviana", "TN"]],
        "38028": [["Tregiovo", "TN"], ["Romallo", "TN"], ["Revo'", "TN"], ["Cagno'", "TN"]],
        "38029": [["Passo Del Tonale", "TN"], ["Fraviano", "TN"], ["Vermiglio", "TN"]],
        "38030": [
            ["Soraga", "TN"],
            ["Daiano", "TN"],
            ["Molina", "TN"],
            ["Castello Di Fiemme", "TN"],
            ["Varena", "TN"],
            ["Molina Di Fiemme", "TN"],
            ["Stramentizzo", "TN"],
            ["Capriana", "TN"],
            ["Rovere' Della Luna", "TN"],
            ["Giovo", "TN"],
            ["Panchia'", "TN"],
            ["Castello Molina Di Fiemme", "TN"],
            ["Palu'", "TN"],
            ["Stramentizzo Nuovo", "TN"],
            ["Verla", "TN"],
            ["Ziano Di Fiemme", "TN"],
            ["Campestrin", "TN"],
            ["Mazzin", "TN"],
        ],
        "38031": [["Campitello Di Fassa", "TN"]],
        "38032": [["Sass Pordoi", "TN"], ["Alba Di Canazei", "TN"], ["Penia", "TN"], ["Canazei", "TN"]],
        "38033": [["Carano", "TN"], ["Cavalese", "TN"], ["Masi Di Cavalese", "TN"]],
        "38034": [["Lisignago", "TN"], ["Cembra", "TN"]],
        "38035": [["Forno Di Fiemme", "TN"], ["Moena", "TN"], ["Forno", "TN"]],
        "38036": [["Pera", "TN"], ["Pera Di Fassa", "TN"], ["Pozza Di Fassa", "TN"]],
        "38037": [["Paneveggio", "TN"], ["Predazzo", "TN"], ["Passo Rolle", "TN"], ["Bellamonte", "TN"]],
        "38038": [["Tesero", "TN"]],
        "38039": [["Passo Costalunga", "TN"], ["Costalunga", "TN"], ["Vigo Di Fassa", "TN"]],
        "38040": [
            ["Fornace", "TN"],
            ["Lases", "TN"],
            ["Valfloriana", "TN"],
            ["Lona Lases", "TN"],
            ["Ravina", "TN"],
            ["Luserna", "TN"],
            ["Lona", "TN"],
        ],
        "38041": [["Albiano", "TN"]],
        "38042": [
            ["Campolongo", "TN"],
            ["Faida Di Pine'", "TN"],
            ["Faida", "TN"],
            ["Rizzolaga", "TN"],
            ["Baselga Di Pine'", "TN"],
            ["Montagnaga", "TN"],
            ["San Mauro", "TN"],
        ],
        "38043": [["Regnana", "TN"], ["Bedollo", "TN"], ["Brusago", "TN"]],
        "38045": [["Civezzano", "TN"], ["Seregnano", "TN"]],
        "38046": [["Gionghi", "TN"], ["Lavarone Cappella", "TN"], ["Lavarone", "TN"], ["Cappella", "TN"]],
        "38047": [["Valcava", "TN"], ["Sevignano", "TN"], ["Quaras", "TN"], ["Segonzano", "TN"]],
        "38048": [["Sover", "TN"]],
        "38049": [
            ["Vigolo Vattaro", "TN"],
            ["Bosentino", "TN"],
            ["Centa San Nicolo'", "TN"],
            ["Vattaro", "TN"],
            ["Migazzone", "TN"],
        ],
        "38050": [
            ["Calceranica Al Lago", "TN"],
            ["Ospedaletto", "TN"],
            ["Torcegno", "TN"],
            ["Pieve Tesino", "TN"],
            ["Fierozzo", "TN"],
            ["Marter", "TN"],
            ["Prade", "TN"],
            ["Tenna", "TN"],
            ["Sagron Mis", "TN"],
            ["Bieno", "TN"],
            ["Monte Di Mezzo", "TN"],
            ["Carzano", "TN"],
            ["Sant'Orsola Terme", "TN"],
            ["Telve Di Sopra", "TN"],
            ["Santa Brigida", "TN"],
            ["Ronchi Valsugana", "TN"],
            ["Canal San Bovo", "TN"],
            ["Imer", "TN"],
            ["Castelnuovo", "TN"],
            ["Novaledo", "TN"],
            ["Scurelle", "TN"],
            ["Gobbera", "TN"],
            ["Cinte Tesino", "TN"],
            ["Mezzano", "TN"],
            ["Palu' Del Fersina", "TN"],
            ["Caoria", "TN"],
            ["Frassilongo", "TN"],
            ["San Francesco", "TN"],
            ["Telve", "TN"],
            ["Telve Di Valsugana", "TN"],
            ["Roncegno", "TN"],
        ],
        "38051": [["Borgo Valsugana", "TN"], ["Borgo", "TN"], ["Olle", "TN"]],
        "38052": [["Caldonazzo", "TN"]],
        "38053": [["Castello Tesino", "TN"]],
        "38054": [
            ["Siror", "TN"],
            ["San Martino Di Castrozza", "TN"],
            ["Transacqua", "TN"],
            ["Fiera Di Primiero", "TN"],
            ["Tonadico", "TN"],
        ],
        "38055": [
            ["Tezze", "TN"],
            ["Selva Di Grigno", "TN"],
            ["Tezze Val Sugana", "TN"],
            ["Selva", "TN"],
            ["Grigno", "TN"],
        ],
        "38056": [["Barco", "TN"], ["Levico Terme", "TN"]],
        "38057": [
            ["Pergine Valsugana", "TN"],
            ["Vignola", "TN"],
            ["Falesina", "TN"],
            ["Costasavina", "TN"],
            ["Susa'", "TN"],
            ["Canezza", "TN"],
            ["San Cristoforo", "TN"],
            ["Viarago", "TN"],
            ["Roncogno", "TN"],
            ["Canale", "TN"],
            ["Vignola Falesina", "TN"],
            ["Serso", "TN"],
            ["Vigalzano", "TN"],
            ["San Cristoforo Al Lago", "TN"],
            ["Ischia Trentina", "TN"],
            ["Canzolino", "TN"],
            ["Madrano", "TN"],
        ],
        "38059": [
            ["Ivano Fracena", "TN"],
            ["Villa Agnedo", "TN"],
            ["Strigno", "TN"],
            ["Spera", "TN"],
            ["Samone", "TN"],
            ["Agnedo", "TN"],
        ],
        "38060": [
            ["Tenno", "TN"],
            ["Pieve Di Ledro", "TN"],
            ["Valmorbia", "TN"],
            ["Corte", "TN"],
            ["Ronzo", "TN"],
            ["Riva Di Vallarsa", "TN"],
            ["Gavazzo Nuova", "TN"],
            ["Castellano", "TN"],
            ["Ronzo Chienis", "TN"],
            ["Chienis", "TN"],
            ["Pedersano", "TN"],
            ["Garniga Terme", "TN"],
            ["Castione", "TN"],
            ["Villa Lagarina", "TN"],
            ["Anghebeni", "TN"],
            ["Pregasina", "TN"],
            ["Anghebeni Di Vallarsa", "TN"],
            ["Cimone", "TN"],
            ["Isera", "TN"],
            ["Nogaredo", "TN"],
            ["Besenello", "TN"],
            ["Cornale'", "TN"],
            ["Valduga", "TN"],
            ["Tiarno Di Sotto", "TN"],
            ["Bezzecca", "TN"],
            ["Molina Di Ledro", "TN"],
            ["Tiarno Di Sopra", "TN"],
            ["Nomi", "TN"],
            ["Cologna", "TN"],
            ["Brentonico", "TN"],
            ["Volano", "TN"],
            ["Terragnolo", "TN"],
            ["Raossi", "TN"],
            ["Raossi Di Vallarsa", "TN"],
            ["Romagnano", "TN"],
            ["Concei", "TN"],
            ["Aldeno", "TN"],
            ["Vallarsa", "TN"],
            ["Crosano", "TN"],
            ["Pomarolo", "TN"],
        ],
        "38061": [
            ["Santa Margherita", "TN"],
            ["Pilcante", "TN"],
            ["Serravalle All'Adige", "TN"],
            ["Ala", "TN"],
            ["Chizzola", "TN"],
            ["Serravalle", "TN"],
            ["Sega Dei Lessini", "TN"],
        ],
        "38062": [["Oltresarca", "TN"], ["Arco", "TN"], ["Bolognano", "TN"], ["San Giorgio", "TN"], ["Vignole", "TN"]],
        "38063": [["Sabbionara", "TN"], ["Borghetto All'Adige", "TN"], ["Avio", "TN"]],
        "38064": [
            ["Mezzomonte Di Sotto", "TN"],
            ["Folgaria", "TN"],
            ["Mezzomonte", "TN"],
            ["Nosellari", "TN"],
            ["Carbonare Di Folgaria", "TN"],
            ["Serrada", "TN"],
            ["Serrada Di Folgaria", "TN"],
            ["San Sebastiano", "TN"],
            ["Carbonare", "TN"],
            ["Mezzomonte Di Sopra", "TN"],
        ],
        "38065": [
            ["Manzano", "TN"],
            ["Besagno", "TN"],
            ["Sano", "TN"],
            ["Valle San Felice", "TN"],
            ["Mori", "TN"],
            ["Pannone", "TN"],
        ],
        "38066": [["Varone", "TN"], ["Riva Del Garda", "TN"]],
        "38067": [["Mezzolago", "TN"], ["Biacesa Di Ledro", "TN"], ["Ledro", "TN"]],
        "38068": [
            ["Rovereto", "TN"],
            ["Borgo Sacco", "TN"],
            ["Mori Ferrovia", "TN"],
            ["Trambileno", "TN"],
            ["Lizzanella", "TN"],
            ["Marco", "TN"],
        ],
        "38069": [["Nago Torbole", "TN"], ["Torbole", "TN"], ["Nago", "TN"]],
        "38070": [["Tavodo", "TN"], ["Villa Banale", "TN"], ["Lomaso", "TN"], ["Stenico", "TN"]],
        "38071": [
            ["Larido", "TN"],
            ["Marazzone", "TN"],
            ["Bleggio Inferiore", "TN"],
            ["Bleggio Superiore", "TN"],
            ["Bivedo", "TN"],
        ],
        "38073": [["Vigo", "TN"], ["Vigo Cavedine", "TN"], ["Stravino", "TN"], ["Cavedine", "TN"]],
        "38074": [["Drena", "TN"], ["Ceniga", "TN"], ["Dro", "TN"], ["Pietramurata", "TN"]],
        "38075": [["Ballino", "TN"], ["Fiave'", "TN"]],
        "38076": [
            ["Castel Madruzzo", "TN"],
            ["Calavino", "TN"],
            ["Lasino", "TN"],
            ["Sarche", "TN"],
            ["Madruzzo", "TN"],
        ],
        "38077": [
            ["Comano Terme", "TN"],
            ["Vigo Lomaso", "TN"],
            ["Lundo", "TN"],
            ["Bagni Di Comano", "TN"],
            ["Ponte Arche", "TN"],
        ],
        "38078": [
            ["Dorsino", "TN"],
            ["Moline", "TN"],
            ["San Lorenzo In Banale", "TN"],
            ["Moline Di Banale", "TN"],
            ["San Lorenzo Dorsino", "TN"],
        ],
        "38079": [["Bolbeno", "TN"], ["Zuclo", "TN"], ["Tione Di Trento", "TN"], ["Pelugo", "TN"], ["Saone", "TN"]],
        "38080": [
            ["Baitoni", "TN"],
            ["Carisolo", "TN"],
            ["Bocenago", "TN"],
            ["Bondone", "TN"],
            ["Strembo", "TN"],
            ["Iavre' Vigo Rendena", "TN"],
            ["Caderzone", "TN"],
        ],
        "38082": [["Castel Condino", "TN"]],
        "38083": [["Condino", "TN"], ["Brione", "TN"], ["Cimego", "TN"]],
        "38085": [["Pieve Di Bono", "TN"], ["Creto", "TN"], ["Prezzo", "TN"]],
        "38086": [
            ["Massimeno", "TN"],
            ["Sant'Antonio Di Mavignola", "TN"],
            ["Pinzolo", "TN"],
            ["Madonna Di Campiglio", "TN"],
            ["Giustino", "TN"],
        ],
        "38087": [["Bondo", "TN"], ["Lardaro", "TN"], ["Roncone", "TN"], ["Breguzzo", "TN"]],
        "38088": [["Spiazzo Rendena", "TN"], ["Spiazzo", "TN"]],
        "38089": [["Storo", "TN"], ["Darzo", "TN"], ["Lodrone", "TN"]],
        "38091": [["Praso", "TN"], ["Bersone", "TN"], ["Valdaone", "TN"], ["Daone", "TN"]],
        "38092": [["Grauno", "TN"], ["Grumes", "TN"], ["Valda", "TN"], ["Faver", "TN"]],
        "38093": [["Terres", "TN"], ["Flavon", "TN"], ["Cunevo", "TN"]],
        "38094": [
            ["Verdesina", "TN"],
            ["Villa Rendena", "TN"],
            ["Vigo Rendena", "TN"],
            ["Iavre'", "TN"],
            ["Dare'", "TN"],
        ],
        "38095": [["Ragoli", "TN"], ["Montagne", "TN"], ["Preore", "TN"]],
        "38096": [["Vezzano", "TN"], ["Terlago", "TN"], ["Margone", "TN"], ["Ranzo", "TN"], ["Padergnone", "TN"]],
        "38097": [["Zambana", "TN"], ["Nave San Rocco", "TN"]],
        "38100": [
            ["Gardolo Di Mezzo", "TN"],
            ["Trento", "TN"],
            ["Gardolo", "TN"],
            ["Sopramonte", "TN"],
            ["Baselga Del Bondone", "TN"],
            ["Vigo Meano", "TN"],
            ["Cadine", "TN"],
            ["Cognola", "TN"],
            ["Sardagna", "TN"],
            ["Vaneze", "TN"],
            ["Martignano", "TN"],
            ["Baselga Di Vezzano", "TN"],
            ["Vaneze Di Bondone", "TN"],
            ["Valsorda", "TN"],
            ["Villamontagna", "TN"],
            ["Meano", "TN"],
            ["Vigolo Baselga", "TN"],
            ["Vela", "TN"],
            ["Villazzano", "TN"],
            ["Montevaccino", "TN"],
            ["Povo", "TN"],
            ["Mattarello", "TN"],
        ],
        "38121": [["Trento", "TN"]],
        "06010": [["Citerna", "PG"], ["Monte Santa Maria Tiberina", "PG"], ["Lippiano", "PG"], ["Fighille", "PG"]],
        "06012": [
            ["Riosecco", "PG"],
            ["Muccignano", "PG"],
            ["Cinquemiglia", "PG"],
            ["Morra", "PG"],
            ["Piosina", "PG"],
            ["Cerbara", "PG"],
            ["San Maiano", "PG"],
            ["Citta' Di Castello", "PG"],
            ["San Secondo", "PG"],
            ["Lerchi", "PG"],
            ["Promano", "PG"],
            ["Fraccano", "PG"],
        ],
        "06014": [["Montone", "PG"]],
        "06016": [["Selci", "PG"], ["San Giustino", "PG"], ["Lama", "PG"]],
        "06018": [
            ["Pistrino", "PG"],
            ["Petroia", "PG"],
            ["Lugnano", "PG"],
            ["Badia Petroia", "PG"],
            ["San Leo Bastia", "PG"],
            ["Petrelle", "PG"],
            ["Trestina", "PG"],
            ["Lugnano Citta' Di Castello", "PG"],
        ],
        "06019": [
            ["Verna", "PG"],
            ["Montecastelli Umbro", "PG"],
            ["Preggio", "PG"],
            ["Calzolaro", "PG"],
            ["Montecastelli", "PG"],
            ["Pierantonio", "PG"],
            ["Niccone", "PG"],
            ["Umbertide", "PG"],
        ],
        "06020": [["Branca", "PG"], ["Torre Dei Calzolari", "PG"]],
        "06021": [["Costacciaro", "PG"], ["Villa Col De' Canali", "PG"], ["Villa Col Dei Canali", "PG"]],
        "06022": [
            ["Fossato Di Vico Stazione", "PG"],
            ["Purello", "PG"],
            ["Osteria Del Gatto", "PG"],
            ["Fossato Di Vico", "PG"],
        ],
        "06023": [
            ["San Pellegrino Di Gualdo Tadino", "PG"],
            ["Gualdo Tadino", "PG"],
            ["San Pellegrino", "PG"],
            ["Cerqueto", "PG"],
            ["Morano", "PG"],
            ["Morano Madonnuccia", "PG"],
            ["Pieve Di Compresseto", "PG"],
        ],
        "06024": [
            ["Gubbio", "PG"],
            ["Mocaiana", "PG"],
            ["Ponte D'Assi", "PG"],
            ["Stazione Di Padule", "PG"],
            ["San Benedetto Vecchio", "PG"],
            ["Torre Calzolari", "PG"],
            ["Scritto", "PG"],
            ["Padule", "PG"],
            ["Caicambiucci", "PG"],
            ["Semonte", "PG"],
            ["Mocaiana Stazione", "PG"],
            ["Colpalombo", "PG"],
            ["Casamorcia", "PG"],
            ["Cipolleto", "PG"],
            ["Camporeggiano", "PG"],
        ],
        "06025": [["Gaifana", "PG"], ["Nocera Umbra", "PG"], ["Molinaccio", "PG"]],
        "06026": [["Pietralunga", "PG"]],
        "06027": [["Scheggia E Pascelupo", "PG"], ["Scheggia", "PG"], ["Isola Fossara", "PG"], ["Pascelupo", "PG"]],
        "06028": [["Sigillo", "PG"]],
        "06029": [["Casa Castalda", "PG"], ["Valfabbrica", "PG"]],
        "06030": [
            ["Orsano E Cammoro", "PG"],
            ["Cammoro", "PG"],
            ["Sellano", "PG"],
            ["Giano Dell'Umbria", "PG"],
            ["Valtopina", "PG"],
            ["Bastardo", "PG"],
        ],
        "06031": [["Bevagna", "PG"], ["Cantalupo", "PG"]],
        "06033": [["Cannara", "PG"]],
        "06034": [
            ["Scafali", "PG"],
            ["Sant'Eraclio", "PG"],
            ["Annifo", "PG"],
            ["Foligno", "PG"],
            ["Capodacqua", "PG"],
            ["Fiamenga", "PG"],
            ["Rasiglia", "PG"],
            ["Casenove", "PG"],
            ["Verchiano", "PG"],
            ["Scopoli", "PG"],
            ["Colfiorito", "PG"],
            ["Uppello", "PG"],
            ["San Giovanni Profiamma", "PG"],
            ["Scanzano", "PG"],
            ["Sterpete", "PG"],
            ["Pale", "PG"],
            ["Perticani", "PG"],
            ["Pieve Fanonica", "PG"],
            ["Belfiore", "PG"],
        ],
        "06035": [
            ["San Terenziano", "PG"],
            ["Collesecco", "PG"],
            ["Pozzo Di Gualdo Cattaneo", "PG"],
            ["Pozzo", "PG"],
            ["Gualdo Cattaneo", "PG"],
            ["Marcellano", "PG"],
        ],
        "06036": [["Montefalco", "PG"], ["Madonna Della Stella", "PG"], ["San Marco Di Montefalco", "PG"]],
        "06038": [["Spello", "PG"], ["Capitan Loreto", "PG"]],
        "06039": [
            ["Trevi", "PG"],
            ["Cannaiola", "PG"],
            ["Santa Maria In Valle", "PG"],
            ["Matigge", "PG"],
            ["Li Celli", "PG"],
            ["Borgo Di Trevi", "PG"],
        ],
        "06040": [
            ["Piedipaterno", "PG"],
            ["Piedipaterno Sul Nera", "PG"],
            ["Ceselli", "PG"],
            ["Sant'Anatolia Di Narco", "PG"],
            ["Scheggino", "PG"],
            ["Poggiodomo", "PG"],
            ["Vallo Di Nera", "PG"],
        ],
        "06041": [["Borgo Cerreto", "PG"], ["Triponzo", "PG"], ["Cerreto Di Spoleto", "PG"], ["Bugiano", "PG"]],
        "06042": [["Campello Sul Clitunno", "PG"]],
        "06043": [["Cascia", "PG"], ["Chiavano", "PG"], ["Maltignano Di Cascia", "PG"]],
        "06044": [["Castel Ritaldi", "PG"], ["Bruna", "PG"]],
        "06045": [["Monteleone Di Spoleto", "PG"]],
        "06046": [
            ["Ancarano", "PG"],
            ["Agriano", "PG"],
            ["San Pellegrino Di Norcia", "PG"],
            ["Serravalle Di Norcia", "PG"],
            ["Norcia", "PG"],
            ["Serravalle", "PG"],
            ["Castelluccio", "PG"],
            ["Savelli Di Norcia", "PG"],
        ],
        "06047": [
            ["Abeto", "PG"],
            ["Belforte", "PG"],
            ["Todiano", "PG"],
            ["Casali Belforte", "PG"],
            ["Preci", "PG"],
            ["Piedivalle", "PG"],
            ["Roccanolfi", "PG"],
        ],
        "06049": [
            ["Montemartano", "PG"],
            ["Baiano Di Spoleto", "PG"],
            ["Bazzano Inferiore", "PG"],
            ["Cortaccione", "PG"],
            ["San Brizio", "PG"],
            ["Maiano", "PG"],
            ["Eggi", "PG"],
            ["Morgnano", "PG"],
            ["San Martino In Trignano", "PG"],
            ["San Giacomo Di Spoleto", "PG"],
            ["Terzo La Pieve", "PG"],
            ["Madonna Di Baiano", "PG"],
            ["Sant'Angelo In Mercole", "PG"],
            ["Beroide", "PG"],
            ["Spoleto", "PG"],
            ["San Giovanni Di Baiano", "PG"],
            ["San Giacomo", "PG"],
            ["Strettura", "PG"],
        ],
        "06050": [["Collazzone", "PG"], ["Collepepe", "PG"], ["Piedicolle", "PG"], ["Casalalta", "PG"]],
        "06051": [["Ripabianca", "PG"], ["Casalina", "PG"]],
        "06053": [
            ["San Nicolo' Di Celle", "PG"],
            ["San Niccolo' Di Celle", "PG"],
            ["Deruta", "PG"],
            ["Ponte Nuovo", "PG"],
            ["Sant'Angelo Di Celle", "PG"],
        ],
        "06054": [["Fratta Todina", "PG"]],
        "06055": [
            ["Papiano", "PG"],
            ["San Valentino Della Collina", "PG"],
            ["Marsciano", "PG"],
            ["San Valentino", "PG"],
        ],
        "06056": [["Colpetrazzo", "PG"], ["Villa San Faustino", "PG"], ["Viepri", "PG"], ["Massa Martana", "PG"]],
        "06057": [["Monte Castello Di Vibio", "PG"]],
        "06059": [
            ["Todi", "PG"],
            ["Camerata", "PG"],
            ["Montenero Di Todi", "PG"],
            ["Pantalla", "PG"],
            ["Montenero", "PG"],
            ["Canonica", "PG"],
            ["Collevalenza", "PG"],
            ["Izzalini", "PG"],
            ["Ponterio", "PG"],
            ["Ilci", "PG"],
            ["Pontecuti", "PG"],
            ["Pian Di San Martino", "PG"],
            ["Monticello", "PG"],
        ],
        "06060": [["Villastrada Umbra", "PG"], ["Lisciano Niccone", "PG"], ["Paciano", "PG"]],
        "06061": [
            ["Pozzuolo", "PG"],
            ["Villastrada", "PG"],
            ["Macchie", "PG"],
            ["Castiglione Del Lago", "PG"],
            ["Gioiella", "PG"],
            ["Panicarola", "PG"],
            ["Petrignano Del Lago", "PG"],
            ["Sanfatucchio", "PG"],
            ["Porto", "PG"],
        ],
        "06062": [
            ["Citta' Della Pieve", "PG"],
            ["Salci", "PG"],
            ["Po Bandino", "PG"],
            ["Ponticelli", "PG"],
            ["Ponticelli Citta' Della Pieve", "PG"],
            ["Moiano", "PG"],
        ],
        "06063": [
            ["Soccorso", "PG"],
            ["Agello", "PG"],
            ["Villa", "PG"],
            ["San Savino", "PG"],
            ["San Feliciano", "PG"],
            ["Sant'Arcangelo Di Magione", "PG"],
            ["Magione", "PG"],
            ["Sant'Arcangelo", "PG"],
        ],
        "06064": [["Panicale", "PG"]],
        "06065": [["Castel Rigone", "PG"], ["Passignano Sul Trasimeno", "PG"]],
        "06066": [["Pietrafitta", "PG"], ["Piegaro", "PG"], ["Castiglion Fosco", "PG"]],
        "06068": [["Tavernelle", "PG"]],
        "06069": [["Tuoro Sul Trasimeno", "PG"], ["Borghetto Di Tuoro", "PG"], ["Isola Maggiore", "PG"]],
        "06070": [["Ellera", "PG"], ["San Mariano", "PG"], ["Ellera Umbra", "PG"]],
        "06072": [
            ["Mercatello", "PG"],
            ["San Biagio Della Valle", "PG"],
            ["Migliano", "PG"],
            ["Pieve Caina", "PG"],
            ["Compignano", "PG"],
            ["Castiglione Della Valle", "PG"],
            ["Spina", "PG"],
            ["Badiola", "PG"],
        ],
        "06073": [["Corciano", "PG"], ["Mantignana", "PG"]],
        "06081": [
            ["Rivotorto", "PG"],
            ["Assisi", "PG"],
            ["Castelnuovo", "PG"],
            ["Tordandrea", "PG"],
            ["Santa Maria Degli Angeli", "PG"],
            ["Assisi Santuario", "PG"],
            ["Viole Di Assisi", "PG"],
            ["Palazzo D'Assisi", "PG"],
            ["Castelnuovo D'Assisi", "PG"],
            ["Petrignano D'Assisi", "PG"],
            ["San Vitale", "PG"],
            ["Petrignano", "PG"],
            ["Palazzo", "PG"],
            ["Torchiagina", "PG"],
        ],
        "06083": [
            ["Costano", "PG"],
            ["Ospedalicchio Di Bastia Umbra", "PG"],
            ["Ospedalicchio", "PG"],
            ["Bastia", "PG"],
        ],
        "06084": [["Bettona", "PG"], ["Passaggio Di Bettona", "PG"], ["Passaggio", "PG"]],
        "06089": [["Torgiano", "PG"], ["Ponte Nuovo", "PG"], ["Brufa", "PG"], ["Fornaci", "PG"]],
        "06100": [["Perugia", "PG"]],
        "06121": [["Perugia", "PG"]],
        "06122": [["Perugia", "PG"]],
        "06123": [["Perugia", "PG"]],
        "06124": [["Perugia", "PG"], ["Perugia Stazione", "PG"]],
        "06125": [["Perugia", "PG"]],
        "06126": [["Perugia", "PG"], ["Montecorneo", "PG"], ["Montebello", "PG"]],
        "06127": [["Ferro Di Cavallo", "PG"], ["Perugia", "PG"]],
        "06128": [["Perugia", "PG"], ["Ponte Della Pietra", "PG"]],
        "06129": [["Prepo", "PG"], ["Perugia", "PG"]],
        "06131": [["Perugia", "PG"], ["San Marco", "PG"]],
        "06132": [["San Sisto", "PG"], ["Perugia", "PG"]],
        "06134": [["Perugia", "PG"]],
        "05010": [
            ["San Venanzo", "TR"],
            ["Porano", "TR"],
            ["Montegabbione", "TR"],
            ["Parrano", "TR"],
            ["Ospedaletto", "TR"],
            ["Poggio Aquilone", "TR"],
            ["Pornello", "TR"],
            ["San Vito In Monte", "TR"],
            ["Collelungo", "TR"],
            ["Ripalvella", "TR"],
        ],
        "05011": [["Allerona Stazione", "TR"], ["Stazione Di Allerona", "TR"], ["Allerona", "TR"]],
        "05012": [["Attigliano", "TR"]],
        "05013": [["Castel Giorgio", "TR"]],
        "05014": [["Castel Viscardo", "TR"], ["Monterubiaglio", "TR"], ["Pianlungo", "TR"]],
        "05015": [["Fabro Scalo", "TR"], ["Fabro", "TR"], ["Carnaiola", "TR"]],
        "05016": [["Sala", "TR"], ["Ficulle", "TR"]],
        "05017": [["Santa Maria", "TR"], ["Monteleone D'Orvieto", "TR"]],
        "05018": [
            ["Sugano", "TR"],
            ["Ciconia", "TR"],
            ["Corbara", "TR"],
            ["Orvieto", "TR"],
            ["Prodo", "TR"],
            ["Canale Vecchio", "TR"],
            ["Morrano Vecchio", "TR"],
            ["Orvieto Stazione", "TR"],
            ["Canale Nuovo", "TR"],
            ["Sferracavallo", "TR"],
            ["Titignano", "TR"],
            ["Canale", "TR"],
            ["Morrano Nuovo", "TR"],
            ["Gabelletta", "TR"],
            ["Morrano", "TR"],
            ["Orvieto Scalo", "TR"],
        ],
        "05020": [
            ["Santa Restituta", "TR"],
            ["Melezzole", "TR"],
            ["Lugnano In Teverina", "TR"],
            ["Dunarobba", "TR"],
            ["Montecchio", "TR"],
            ["Tenaglie", "TR"],
            ["Sismano", "TR"],
            ["Avigliano Umbro", "TR"],
            ["Alviano", "TR"],
        ],
        "05021": [["Casigliano", "TR"], ["Acquasparta", "TR"], ["Portaria", "TR"]],
        "05022": [
            ["Porchiano Del Monte", "TR"],
            ["Montecampano", "TR"],
            ["Porchiano", "TR"],
            ["Amelia", "TR"],
            ["Macchie", "TR"],
            ["Fornole", "TR"],
        ],
        "05023": [["Civitella Del Lago", "TR"], ["Acqualoreto", "TR"], ["Baschi", "TR"], ["Morre", "TR"]],
        "05024": [["Giove", "TR"]],
        "05025": [["Guardea", "TR"]],
        "05026": [
            ["Collesecco", "TR"],
            ["Montecastrilli", "TR"],
            ["Castel Dell'Aquila", "TR"],
            ["Quadrelli", "TR"],
            ["Casteltodino", "TR"],
            ["Farnetta", "TR"],
        ],
        "05028": [["Penna In Teverina", "TR"]],
        "05029": [["San Gemini", "TR"]],
        "05030": [
            ["Polino", "TR"],
            ["Poggio Di Otricoli", "TR"],
            ["Fontechiaruccia", "TR"],
            ["Montefranco", "TR"],
            ["Otricoli", "TR"],
        ],
        "05031": [["Casteldilago", "TR"], ["Arrone", "TR"], ["Buonacquisto", "TR"]],
        "05032": [["Santa Maria Della Neve", "TR"], ["Calvi Dell'Umbria", "TR"]],
        "05034": [["Ferentillo", "TR"]],
        "05035": [
            ["Taizzano", "TR"],
            ["Narni", "TR"],
            ["Vigne", "TR"],
            ["Schifanoia", "TR"],
            ["San Liberato", "TR"],
            ["Montoro", "TR"],
            ["Itieli", "TR"],
            ["Narni Scalo", "TR"],
            ["Borgaria Di Narni", "TR"],
            ["Nera Montoro", "TR"],
            ["Gualdo", "TR"],
            ["San Vito", "TR"],
            ["Gualdo Di Narni", "TR"],
            ["Narni Stazione", "TR"],
            ["Capitone", "TR"],
            ["Vigne Di Narni", "TR"],
            ["Ponte San Lorenzo", "TR"],
            ["Stifone", "TR"],
            ["Testaccio", "TR"],
            ["Borgaria", "TR"],
            ["Sant'Urbano", "TR"],
        ],
        "05039": [["Stroncone", "TR"]],
        "05100": [
            ["Collestatte", "TR"],
            ["Marmore", "TR"],
            ["Cesi Di Terni", "TR"],
            ["Miranda", "TR"],
            ["Terni", "TR"],
            ["Cesi", "TR"],
            ["Gabelletta Di Cesi", "TR"],
            ["Collestatte Piano", "TR"],
            ["Collescipoli", "TR"],
            ["Valenza", "TR"],
            ["Cecalocco", "TR"],
            ["Giuncano", "TR"],
            ["Giuncano Scalo", "TR"],
            ["Battiferro", "TR"],
            ["Papigno", "TR"],
            ["Piediluco", "TR"],
            ["Rocca San Zenone", "TR"],
            ["Torreorsina", "TR"],
        ],
        "11010": [
            ["Doues", "AO"],
            ["Vieyes", "AO"],
            ["Plan D'Introd", "AO"],
            ["Valgrisenche", "AO"],
            ["La Cretaz", "AO"],
            ["Allein", "AO"],
            ["Valpelline", "AO"],
            ["Ollomont", "AO"],
            ["Pre' Saint Didier", "AO"],
            ["Runaz", "AO"],
            ["Montan", "AO"],
            ["Saint Maurice", "AO"],
            ["Saint Pierre", "AO"],
            ["Bionaz", "AO"],
            ["Bosses", "AO"],
            ["Verrand", "AO"],
            ["Chesallet Sarre", "AO"],
            ["Oyace", "AO"],
            ["Saint Nicolas", "AO"],
            ["Sarre", "AO"],
            ["Rhemes Notre Dame", "AO"],
            ["Aymavilles", "AO"],
            ["Rhemes Saint Georges", "AO"],
            ["Saint Rhemy En Bosses", "AO"],
            ["Roisan", "AO"],
            ["Angelin", "AO"],
            ["Arensod", "AO"],
            ["Introd", "AO"],
            ["Chesallet", "AO"],
            ["Valsavarenche", "AO"],
            ["Gignod", "AO"],
            ["Avise", "AO"],
        ],
        "11011": [["Leverogne", "AO"], ["Planaval", "AO"], ["Arvier", "AO"]],
        "11012": [["Cogne", "AO"], ["Gimillian", "AO"], ["Epinel", "AO"]],
        "11013": [["Dolonne", "AO"], ["Courmayeur", "AO"], ["Entreves", "AO"], ["La Saxe", "AO"]],
        "11014": [["Etroubles", "AO"], ["Saint Oyen", "AO"]],
        "11015": [["La Salle", "AO"], ["Derby", "AO"]],
        "11016": [["La Thuile", "AO"]],
        "11017": [["Morgex", "AO"]],
        "11018": [["Villeneuve", "AO"]],
        "11020": [
            ["La Place", "AO"],
            ["Saint Barthelemy", "AO"],
            ["Gressoney La Trinite'", "AO"],
            ["Gaby", "AO"],
            ["Antey Saint Andre'", "AO"],
            ["Pontboset", "AO"],
            ["Challand Saint Anselme", "AO"],
            ["Ville", "AO"],
            ["Peroulaz", "AO"],
            ["Challand Saint Victor", "AO"],
            ["Grand Villa Cravon", "AO"],
            ["Etabloz", "AO"],
            ["Saint Christophe", "AO"],
            ["Blavy Nus", "AO"],
            ["Perloz", "AO"],
            ["Ville Sur Nus", "AO"],
            ["Fontainemore", "AO"],
            ["Verrayes", "AO"],
            ["Nus", "AO"],
            ["Saint Marcel", "AO"],
            ["Plan Felinaz", "AO"],
            ["Chef Lieu", "AO"],
            ["Pont Suaz", "AO"],
            ["Barme", "AO"],
            ["Periasc", "AO"],
            ["Issogne", "AO"],
            ["Brissogne", "AO"],
            ["Charvensod", "AO"],
            ["Mongnod", "AO"],
            ["La Magdeleine", "AO"],
            ["Jovencan", "AO"],
            ["Champoluc", "AO"],
            ["Champdepraz", "AO"],
            ["Villefranche", "AO"],
            ["Quart", "AO"],
            ["Villair", "AO"],
            ["Antagnod", "AO"],
            ["Buisson", "AO"],
            ["Hone", "AO"],
            ["Champorcher", "AO"],
            ["Pollein", "AO"],
            ["Blavy", "AO"],
            ["Bard", "AO"],
            ["Vert", "AO"],
            ["Montjovet", "AO"],
            ["Lignod", "AO"],
            ["Issime", "AO"],
            ["Torgnon", "AO"],
            ["Fiernaz", "AO"],
            ["Chez Croiset", "AO"],
            ["Fenis", "AO"],
            ["Neyran", "AO"],
            ["Ayas", "AO"],
            ["Grand Vert", "AO"],
            ["Gressan", "AO"],
            ["Donnas", "AO"],
            ["Lillianes", "AO"],
            ["Chamois", "AO"],
            ["Emarese", "AO"],
            ["Arnad", "AO"],
            ["Grand Villa", "AO"],
        ],
        "11021": [["Breuil", "AO"], ["Breuil Cervinia", "AO"], ["Cervinia", "AO"]],
        "11022": [["Arcesaz", "AO"], ["Brusson", "AO"], ["Extrepieraz", "AO"]],
        "11023": [["Saint Denis", "AO"], ["Chambave", "AO"]],
        "11024": [["Chatillon", "AO"], ["Ussel", "AO"], ["Pontey", "AO"], ["Lassolaz", "AO"]],
        "11025": [["Gressoney Saint Jean", "AO"]],
        "11026": [["Pont Saint Martin", "AO"]],
        "11027": [["Moron", "AO"], ["Saint Vincent", "AO"]],
        "11028": [["Valtournenche", "AO"], ["Paquier", "AO"]],
        "11029": [["Verres", "AO"], ["Glair", "AO"]],
        "11100": [
            ["Signayes", "AO"],
            ["Porossan", "AO"],
            ["Roisan", "AO"],
            ["Excenex", "AO"],
            ["Arpuilles", "AO"],
            ["Aosta", "AO"],
        ],
        "32010": [
            ["Garna", "BL"],
            ["Mareson", "BL"],
            ["Ospitale Di Cadore", "BL"],
            ["Zoppe' Di Cadore", "BL"],
            ["Tignes", "BL"],
            ["Lamosano", "BL"],
            ["Tambre", "BL"],
            ["Pecol", "BL"],
            ["Podenzoi", "BL"],
            ["Codissago", "BL"],
            ["Termine", "BL"],
            ["Soverzene", "BL"],
            ["Zoldo Alto", "BL"],
            ["Castello Lavazzo", "BL"],
            ["Pieve D'Alpago", "BL"],
            ["Termine Di Cadore", "BL"],
            ["Perarolo Di Cadore", "BL"],
            ["Chies D'Alpago", "BL"],
        ],
        "32012": [["Dont Di Zoldo", "BL"], ["Dont", "BL"], ["Dozza Di Zoldo", "BL"], ["Forno Di Zoldo", "BL"]],
        "32013": [["Igne", "BL"], ["Longarone", "BL"], ["Fortogna", "BL"]],
        "32014": [
            ["La Secca", "BL"],
            ["Polpet", "BL"],
            ["Col Di Cugnan", "BL"],
            ["Paiane", "BL"],
            ["Ponte Nelle Alpi", "BL"],
            ["Cadola", "BL"],
            ["Casan", "BL"],
            ["Soccher", "BL"],
        ],
        "32015": [["Puos D'Alpago", "BL"], ["Cornei", "BL"]],
        "32016": [["Farra D'Alpago", "BL"], ["Santa Croce", "BL"], ["Spert", "BL"], ["Santa Croce Del Lago", "BL"]],
        "32020": [
            ["Tiser", "BL"],
            ["Villapiana", "BL"],
            ["Selva Di Cadore", "BL"],
            ["Gosaldo", "BL"],
            ["Limana", "BL"],
            ["San Tomaso Agordino", "BL"],
            ["Livinallongo Del Col Di Lana", "BL"],
            ["Voltago Agordino", "BL"],
            ["Colle Santa Lucia", "BL"],
            ["La Valle Agordina", "BL"],
            ["Falcade", "BL"],
            ["Arabba", "BL"],
            ["Avoscan", "BL"],
            ["Rivamonte Agordino", "BL"],
            ["Dussoi", "BL"],
            ["Caviola", "BL"],
            ["Ronchena", "BL"],
            ["Vallada Agordina", "BL"],
            ["Cencenighe Agordino", "BL"],
            ["Canale D'Agordo", "BL"],
            ["Frassene'", "BL"],
            ["Pie' Falcade", "BL"],
        ],
        "32021": [["Agordo", "BL"]],
        "32022": [["Caprile", "BL"], ["Alleghe", "BL"]],
        "32023": [["Rocca Pietore", "BL"], ["Santa Maria Delle Grazie", "BL"], ["Laste Di Rocca Pietore", "BL"]],
        "32026": [["Trichiana", "BL"], ["Lentiai", "BL"], ["Villa Di Villa", "BL"], ["Mel", "BL"]],
        "32027": [["Taibon Agordino", "BL"]],
        "32028": [["Sant'Antonio Tortal", "BL"]],
        "32030": [
            ["San Gregorio Nelle Alpi", "BL"],
            ["Busche", "BL"],
            ["Rocca", "BL"],
            ["Rocca D'Arsie'", "BL"],
            ["Fastro", "BL"],
            ["Arten", "BL"],
            ["Cesiomaggiore", "BL"],
            ["Seren Del Grappa", "BL"],
            ["Mellame", "BL"],
            ["Sovramonte", "BL"],
            ["Arsie'", "BL"],
            ["Fonzaso", "BL"],
            ["Paderno", "BL"],
            ["Soranzen", "BL"],
            ["Sorriva", "BL"],
        ],
        "32031": [["Colmirano", "BL"], ["Fener", "BL"], ["Alano Di Piave", "BL"]],
        "32032": [
            ["Villabruna", "BL"],
            ["Mugnai", "BL"],
            ["Anzu'", "BL"],
            ["Umin", "BL"],
            ["Tomo", "BL"],
            ["Feltre", "BL"],
            ["Foen", "BL"],
            ["Villapaiera", "BL"],
        ],
        "32033": [["Lamon", "BL"], ["Arina", "BL"]],
        "32034": [["Pedavena", "BL"], ["Facen", "BL"], ["Norcen", "BL"], ["Travagola", "BL"]],
        "32035": [["Meano", "BL"], ["Formegan", "BL"], ["Santa Giustina", "BL"]],
        "32036": [["Mas", "BL"], ["Bribano", "BL"], ["Roe Alte", "BL"], ["Sedico", "BL"]],
        "32037": [["Sospirolo", "BL"], ["Mis", "BL"]],
        "32038": [["Vas", "BL"], ["Quero Vas", "BL"], ["Quero", "BL"]],
        "32040": [
            ["Dosoledo", "BL"],
            ["Candide", "BL"],
            ["Villaggio Turistico Di Borca Di Cadore", "BL"],
            ["Venas", "BL"],
            ["Valle Di Cadore", "BL"],
            ["Lorenzago Di Cadore", "BL"],
            ["Vallesella", "BL"],
            ["Casamazzagno", "BL"],
            ["Borca Di Cadore", "BL"],
            ["Comelico Superiore", "BL"],
            ["Presenaio", "BL"],
            ["San Nicolo' Di Comelico", "BL"],
            ["Laggio Di Cadore", "BL"],
            ["Padola", "BL"],
            ["Costalta", "BL"],
            ["San Pietro Di Cadore", "BL"],
            ["Danta Di Cadore", "BL"],
            ["Pelos", "BL"],
            ["Villapiccola", "BL"],
            ["Vigo Di Cadore", "BL"],
            ["Cibiana Di Cadore", "BL"],
            ["Domegge Di Cadore", "BL"],
            ["Pelos Di Cadore", "BL"],
            ["Masarie'", "BL"],
            ["Lozzo Di Cadore", "BL"],
            ["Vodo Cadore", "BL"],
        ],
        "32041": [["Giralba", "BL"], ["Misurina", "BL"], ["Reane", "BL"], ["Auronzo Di Cadore", "BL"]],
        "32042": [["Calalzo Di Cadore", "BL"]],
        "32043": [["Acquabona", "BL"], ["Zuel", "BL"], ["Verocai", "BL"], ["Cortina D'Ampezzo", "BL"]],
        "32044": [["Pozzale", "BL"], ["Tai Di Cadore", "BL"], ["Sottocastello", "BL"], ["Pieve Di Cadore", "BL"]],
        "32045": [["Santo Stefano Di Cadore", "BL"], ["Campolongo Di Cadore", "BL"], ["Costalissoio", "BL"]],
        "32046": [["Chiapuzza", "BL"], ["San Vito Di Cadore", "BL"]],
        "32047": [["Granvilla", "BL"], ["Sappada", "BL"]],
        "32100": [
            ["Salce", "BL"],
            ["Sossai", "BL"],
            ["Levego", "BL"],
            ["Tisoi", "BL"],
            ["Caleipo", "BL"],
            ["Bolzano Di Belluno", "BL"],
            ["Belluno", "BL"],
            ["Visome", "BL"],
            ["Antole", "BL"],
            ["Fiammoi", "BL"],
            ["Sois", "BL"],
            ["Bes", "BL"],
            ["Safforze", "BL"],
            ["Castion", "BL"],
        ],
        "35010": [
            ["San Vito", "PD"],
            ["Ronchi Di Campanile", "PD"],
            ["Grantorto", "PD"],
            ["Curtarolo", "PD"],
            ["Ca' Baglioni", "PD"],
            ["Cadoneghe", "PD"],
            ["Loreggiola", "PD"],
            ["Borgoricco", "PD"],
            ["San Michele Delle Badesse", "PD"],
            ["San Pietro In Gu", "PD"],
            ["Cavino", "PD"],
            ["Santa Maria Di Non", "PD"],
            ["Perarolo", "PD"],
            ["San Giorgio In Bosco", "PD"],
            ["Villanova", "PD"],
            ["Limena", "PD"],
            ["Villa Del Conte", "PD"],
            ["Vigodarzere", "PD"],
            ["Ponterotto", "PD"],
            ["Arsego", "PD"],
            ["Santa Giustina In Colle", "PD"],
            ["Fossalta Di Trebaseleghe", "PD"],
            ["Villafranca Padovana", "PD"],
            ["Campodoro", "PD"],
            ["Codiverno", "PD"],
            ["Tavo", "PD"],
            ["Taggi'", "PD"],
            ["Camazzole", "PD"],
            ["Terraglione", "PD"],
            ["Pieve", "PD"],
            ["Mejaniga", "PD"],
            ["Loreggia", "PD"],
            ["Silvelle", "PD"],
            ["Massanzago", "PD"],
            ["Pionca", "PD"],
            ["Villanova Di Camposampiero", "PD"],
            ["Fratte", "PD"],
            ["Pieve Di Curtarolo", "PD"],
            ["San Giorgio Delle Pertiche", "PD"],
            ["Sant'Ambrogio", "PD"],
            ["Campo San Martino", "PD"],
            ["Fossalta", "PD"],
            ["Carmignano Di Brenta", "PD"],
            ["Vigonza", "PD"],
            ["Marsango", "PD"],
            ["Saletto Di Vigodarzere", "PD"],
            ["Abbazia Pisani", "PD"],
            ["Trebaseleghe", "PD"],
            ["Gazzo", "PD"],
        ],
        "35011": [["Sant'Andrea Di Campodarsego", "PD"], ["Campodarsego", "PD"]],
        "35012": [["Rustega", "PD"], ["Camposampiero", "PD"]],
        "35013": [["Santa Croce Bigolina", "PD"], ["Laghi", "PD"], ["Cittadella", "PD"]],
        "35014": [["Fontaniva", "PD"]],
        "35015": [["Galliera Veneta", "PD"]],
        "35016": [["Presina", "PD"], ["Vaccarino", "PD"], ["Piazzola Sul Brenta", "PD"], ["Tremignon", "PD"]],
        "35017": [["Piombino Dese", "PD"], ["Torreselle", "PD"], ["Levada", "PD"], ["Ronchi", "PD"]],
        "35018": [["San Martino Di Lupari", "PD"]],
        "35019": [["Onara", "PD"], ["Tombolo", "PD"]],
        "35020": [
            ["Legnaro", "PD"],
            ["Carrara San Giorgio", "PD"],
            ["Tribano", "PD"],
            ["Arzercavalli", "PD"],
            ["Masera' Di Padova", "PD"],
            ["Brugine", "PD"],
            ["Polverara", "PD"],
            ["Codevigo", "PD"],
            ["Terradura", "PD"],
            ["Casone", "PD"],
            ["Due Carrare", "PD"],
            ["Cive'", "PD"],
            ["Correzzola", "PD"],
            ["Candiana", "PD"],
            ["Pozzonovo", "PD"],
            ["Albignasego", "PD"],
            ["Casalserugo", "PD"],
            ["Campagnola", "PD"],
            ["Arzergrande", "PD"],
            ["Conche", "PD"],
            ["Vallonga", "PD"],
            ["Vigorovea", "PD"],
            ["Saonara", "PD"],
            ["Terrassa Padovana", "PD"],
            ["San Pietro Viminario", "PD"],
            ["Ponte San Nicolo'", "PD"],
            ["Sant'Angelo Di Piove Di Sacco", "PD"],
            ["Pernumia", "PD"],
            ["Arre", "PD"],
            ["Carrara Santo Stefano", "PD"],
            ["Roncaglia", "PD"],
            ["Bertipaglia", "PD"],
            ["Sant'Agostino", "PD"],
            ["Conche Di Codevigo", "PD"],
            ["Mandriola", "PD"],
            ["Villatora", "PD"],
        ],
        "35021": [["Agna", "PD"]],
        "35022": [["Anguillara Veneta", "PD"], ["Borgoforte", "PD"]],
        "35023": [["Le Casette", "PD"], ["San Siro", "PD"], ["Bagnoli Di Sopra", "PD"]],
        "35024": [["Bovolenta", "PD"]],
        "35025": [["Cagnola", "PD"], ["Cartura", "PD"]],
        "35026": [["Conselve", "PD"]],
        "35027": [["Oltre Brenta", "PD"], ["Noventa Padovana", "PD"]],
        "35028": [["Arzerello", "PD"], ["Piove Di Sacco", "PD"], ["Piovega", "PD"], ["Corte", "PD"]],
        "35029": [["Pontelongo", "PD"]],
        "35030": [
            ["Cinto Euganeo", "PD"],
            ["Baone", "PD"],
            ["Rivadolmo", "PD"],
            ["Caselle Di Selvazzano Dentro", "PD"],
            ["Bosco", "PD"],
            ["Veggiano", "PD"],
            ["Tencarola", "PD"],
            ["Cervarese Santa Croce", "PD"],
            ["Valsanzibio", "PD"],
            ["Vo' Vecchio", "PD"],
            ["Villaguattera", "PD"],
            ["Sarmeola", "PD"],
            ["Feriole", "PD"],
            ["Saccolongo", "PD"],
            ["Bastia Di Rovolon", "PD"],
            ["Rubano", "PD"],
            ["Caselle", "PD"],
            ["Fossona", "PD"],
            ["Galzignano", "PD"],
            ["Vo'", "PD"],
            ["Rovolon", "PD"],
            ["Bastia", "PD"],
            ["Galzignano Terme", "PD"],
            ["Selvazzano Dentro", "PD"],
            ["Montemerlo", "PD"],
        ],
        "35031": [["Abano Terme", "PD"], ["Monteortone", "PD"]],
        "35032": [["Arqua' Petrarca", "PD"]],
        "35034": [["Lanzetta", "PD"], ["Lozzo Atestino", "PD"]],
        "35035": [["Mestrino", "PD"], ["Arlesega", "PD"]],
        "35036": [["Montegrotto Terme", "PD"]],
        "35037": [
            ["Teolo", "PD"],
            ["Treponti", "PD"],
            ["Villa Di Teolo", "PD"],
            ["Villa", "PD"],
            ["San Biagio", "PD"],
            ["Bresseo", "PD"],
        ],
        "35038": [["Torreglia", "PD"]],
        "35040": [
            ["Barbona", "PD"],
            ["San Fidenzio", "PD"],
            ["Vescovana", "PD"],
            ["Sant'Elena", "PD"],
            ["Vighizzolo D'Este", "PD"],
            ["Valli Mocenighe", "PD"],
            ["Villa Estense", "PD"],
            ["Masi", "PD"],
            ["Megliadino San Fidenzio", "PD"],
            ["Merlara", "PD"],
            ["Piacenza D'Adige", "PD"],
            ["Boara Pisani", "PD"],
            ["Bresega", "PD"],
            ["Valli Moceniche", "PD"],
            ["Carmignano", "PD"],
            ["Urbana", "PD"],
            ["Colombare", "PD"],
            ["Ponso", "PD"],
            ["Casale Di Scodosia", "PD"],
            ["Granze", "PD"],
            ["Ca' Morosini", "PD"],
            ["Megliadino San Vitale", "PD"],
            ["Carceri", "PD"],
            ["Santa Margherita D'Adige", "PD"],
            ["Sant'Urbano", "PD"],
            ["Castelbaldo", "PD"],
        ],
        "35041": [["Battaglia Terme", "PD"]],
        "35042": [["Deserto", "PD"], ["Este", "PD"], ["Pilastro", "PD"]],
        "35043": [["Costa Calcinara", "PD"], ["Monselice", "PD"], ["San Cosma", "PD"]],
        "35044": [["Montagnana", "PD"]],
        "35045": [["Ospedaletto Euganeo", "PD"]],
        "35046": [["Saletto", "PD"]],
        "35047": [["Solesino", "PD"]],
        "35048": [["Stanghella", "PD"], ["Pisana", "PD"], ["Ponte Gorzone", "PD"]],
        "35100": [["Padova", "PD"]],
        "35121": [["Padova", "PD"]],
        "35122": [["Padova", "PD"]],
        "35123": [["Padova", "PD"]],
        "35124": [["Padova", "PD"], ["Salboro", "PD"]],
        "35125": [["Guizza", "PD"], ["Padova", "PD"]],
        "35126": [["Padova", "PD"]],
        "35127": [["Padova", "PD"], ["Camin", "PD"], ["Terranegra", "PD"]],
        "35128": [["Padova", "PD"]],
        "35129": [["Padova", "PD"], ["Mortise", "PD"], ["Ponte Di Brenta", "PD"]],
        "35131": [["Padova", "PD"]],
        "35132": [["Padova", "PD"]],
        "35133": [["Padova", "PD"]],
        "35134": [["Padova", "PD"]],
        "35135": [["Padova", "PD"]],
        "35136": [["Padova", "PD"]],
        "35137": [["Padova", "PD"]],
        "35138": [["Padova", "PD"], ["Monta'", "PD"]],
        "35139": [["Padova", "PD"]],
        "35141": [["Padova", "PD"]],
        "35142": [["Padova", "PD"], ["Mandria", "PD"]],
        "35143": [["Brusegana", "PD"], ["Padova", "PD"]],
        "45010": [
            ["Rosolina", "RO"],
            ["Rosolina Mare", "RO"],
            ["Villadose", "RO"],
            ["Ceregnano", "RO"],
            ["Lama Pezzoli", "RO"],
            ["Braglia", "RO"],
            ["Lama Polesine", "RO"],
            ["Pettorazza Grimani", "RO"],
            ["Gavello", "RO"],
            ["Canale", "RO"],
            ["Papozze", "RO"],
        ],
        "45011": [
            ["Piantamelon", "RO"],
            ["Baricetta", "RO"],
            ["Adria", "RO"],
            ["Valliera", "RO"],
            ["Cavedon", "RO"],
            ["Ca' Emo", "RO"],
            ["Bottrighe", "RO"],
            ["Fasana Polesine", "RO"],
            ["Bellombra", "RO"],
            ["Fasana", "RO"],
            ["Cavanella Po", "RO"],
            ["Passetto", "RO"],
        ],
        "45012": [
            ["Piano", "RO"],
            ["Santa Maria In Punta", "RO"],
            ["Grillara", "RO"],
            ["Riva'", "RO"],
            ["Ariano", "RO"],
            ["San Basilio", "RO"],
            ["Ariano Nel Polesine", "RO"],
            ["Crociara", "RO"],
        ],
        "45014": [["Porto Viro", "RO"], ["Contarina", "RO"], ["Donada", "RO"], ["Villaregia", "RO"]],
        "45015": [["Corbola", "RO"]],
        "45017": [["Loreo", "RO"]],
        "45018": [
            ["Scardovari", "RO"],
            ["Ca' Tiepolo", "RO"],
            ["Bonelli", "RO"],
            ["Ca' Dolfin", "RO"],
            ["Ca' Zuliani", "RO"],
            ["Tolle", "RO"],
            ["Gnocca", "RO"],
            ["Porto Tolle", "RO"],
            ["Donzella", "RO"],
            ["Boccasette", "RO"],
            ["Ivica", "RO"],
            ["Ca' Venier", "RO"],
        ],
        "45019": [
            ["Mazzorno", "RO"],
            ["Ca' Vendramin", "RO"],
            ["Mazzorno Destro", "RO"],
            ["Taglio Di Po", "RO"],
            ["Polesinello", "RO"],
        ],
        "45020": [
            ["Lusia", "RO"],
            ["San Bellino", "RO"],
            ["Castelguglielmo", "RO"],
            ["Cavazzana", "RO"],
            ["Pincara", "RO"],
            ["Zelo", "RO"],
            ["Ca Morosini", "RO"],
            ["Giacciano Con Baruchella", "RO"],
            ["Villanova Del Ghebbo", "RO"],
            ["Canda", "RO"],
            ["Baruchella", "RO"],
        ],
        "45021": [["Salvaterra", "RO"], ["Badia Polesine", "RO"], ["Villa D'Adige", "RO"], ["Colombano", "RO"]],
        "45022": [["Bagnolo Di Po", "RO"]],
        "45023": [["Costa Di Rovigo", "RO"]],
        "45024": [["Fiesso Umbertiano", "RO"]],
        "45025": [["Fratta Polesine", "RO"]],
        "45026": [
            ["Barbuglio", "RO"],
            ["Ramodipalo Rasa", "RO"],
            ["Saguedo", "RO"],
            ["Ramodipalo", "RO"],
            ["Lendinara", "RO"],
        ],
        "45027": [["Sariano", "RO"], ["Pissatola", "RO"], ["Trecenta", "RO"]],
        "45030": [
            ["Guarda Veneta", "RO"],
            ["Santa Maria Maddalena", "RO"],
            ["Castelnovo Bariano", "RO"],
            ["San Martino Di Venezze", "RO"],
            ["Chiesa", "RO"],
            ["Frassinelle Polesine", "RO"],
            ["San Pietro Polesine", "RO"],
            ["Pontecchio Polesine", "RO"],
            ["Villanova Marchesana", "RO"],
            ["Calto", "RO"],
            ["Trona Di Sopra", "RO"],
            ["Occhiobello", "RO"],
            ["Gaiba", "RO"],
            ["Beverare", "RO"],
            ["Crespino", "RO"],
            ["Salara", "RO"],
            ["Villamarzana", "RO"],
            ["Ceneselli", "RO"],
        ],
        "45031": [["Corne'", "RO"], ["Arqua' Polesine", "RO"]],
        "45032": [["Bergantino", "RO"]],
        "45033": [["Bosaro", "RO"]],
        "45034": [["Canaro", "RO"], ["Paviole", "RO"]],
        "45035": [["Castelmassa", "RO"]],
        "45036": [["Ficarolo", "RO"]],
        "45037": [["Santo Stefano", "RO"], ["Melara", "RO"]],
        "45038": [["Raccano", "RO"], ["Polesella", "RO"]],
        "45039": [["Sabbioni", "RO"], ["Stienta", "RO"], ["Zampine", "RO"]],
        "45100": [
            ["Grignano Polesine", "RO"],
            ["Boara Polesine", "RO"],
            ["Mardimago", "RO"],
            ["Roverdicre'", "RO"],
            ["Concadirame", "RO"],
            ["Sant'Apollinare Con Selva", "RO"],
            ["Rovigo", "RO"],
            ["Sant'Apollinare", "RO"],
            ["Granzette", "RO"],
            ["Borsea", "RO"],
            ["Cantonazzo", "RO"],
            ["Buso Sarzano", "RO"],
        ],
        "31010": [
            ["Fonte", "TV"],
            ["Farra Di Soligo", "TV"],
            ["San Michele Di Piave", "TV"],
            ["Santa Maria Di Piave", "TV"],
            ["Ponte Della Priula", "TV"],
            ["Fonte Alto", "TV"],
            ["Soligo", "TV"],
            ["Monfumo", "TV"],
            ["Santa Maria Del Piave", "TV"],
            ["One'", "TV"],
            ["Maser", "TV"],
            ["Pianzano", "TV"],
            ["Cimadolmo", "TV"],
            ["Mosnigo", "TV"],
            ["Godega Di Sant'Urbano", "TV"],
            ["Col San Martino", "TV"],
            ["Orsago", "TV"],
            ["Bibano", "TV"],
            ["Moriago Della Battaglia", "TV"],
            ["Fregona", "TV"],
            ["Crespignaga", "TV"],
            ["Mareno Di Piave", "TV"],
            ["Colfosco", "TV"],
            ["Osigo", "TV"],
            ["Priula", "TV"],
            ["Muliparte", "TV"],
        ],
        "31011": [["Casella D'Asolo", "TV"], ["Asolo", "TV"], ["Pagnano", "TV"], ["Villa D'Asolo", "TV"]],
        "31012": [["Cappella Maggiore", "TV"], ["Anzano", "TV"]],
        "31013": [["Roverbasso", "TV"], ["Cimetta", "TV"], ["Codogne'", "TV"]],
        "31014": [["San Martino Di Colle Umberto", "TV"], ["San Martino", "TV"], ["Colle Umberto", "TV"]],
        "31015": [["Conegliano", "TV"], ["Scomigo", "TV"], ["Collalbrigo", "TV"]],
        "31016": [["Villa Di Villa", "TV"], ["Cordignano", "TV"]],
        "31017": [["Crespano Del Grappa", "TV"], ["Paderno Del Grappa", "TV"]],
        "31018": [["Gaiarine", "TV"], ["Campomolino", "TV"], ["Francenigo", "TV"], ["Albina", "TV"]],
        "31020": [
            ["Villorba", "TV"],
            ["Zoppe'", "TV"],
            ["Cosniga", "TV"],
            ["Liedolo", "TV"],
            ["Tarzo", "TV"],
            ["Fossamerlo", "TV"],
            ["Revine", "TV"],
            ["Revine Lago", "TV"],
            ["San Vendemiano", "TV"],
            ["Corbanese", "TV"],
            ["Bagnolo", "TV"],
            ["San Fior Di Sotto", "TV"],
            ["San Zenone Degli Ezzelini", "TV"],
            ["Sernaglia Della Battaglia", "TV"],
            ["Vidor", "TV"],
            ["San Pietro Di Feletto", "TV"],
            ["San Polo Di Piave", "TV"],
            ["Castello Roganzuolo", "TV"],
            ["Refrontolo", "TV"],
            ["San Fior Di Sopra", "TV"],
            ["Lancenigo", "TV"],
            ["San Fior", "TV"],
            ["Ca' Rainati", "TV"],
            ["Lago", "TV"],
            ["Falze' Di Piave", "TV"],
            ["Rua", "TV"],
        ],
        "31021": [
            ["Zerman", "TV"],
            ["Bonisiolo", "TV"],
            ["Campocroce", "TV"],
            ["Mogliano Veneto", "TV"],
            ["Marocco", "TV"],
        ],
        "31022": [
            ["Sambughe", "TV"],
            ["Preganziol", "TV"],
            ["San Trovaso", "TV"],
            ["Frescada", "TV"],
            ["Borgo Verde", "TV"],
        ],
        "31023": [["Castelminio", "TV"], ["San Marco", "TV"], ["Resana", "TV"]],
        "31024": [["Ormelle", "TV"], ["Roncadelle", "TV"]],
        "31025": [["Santa Lucia Di Piave", "TV"]],
        "31026": [["Sarmede", "TV"], ["Montaner", "TV"]],
        "31027": [["Spresiano", "TV"], ["Lovadina", "TV"], ["Visnadello", "TV"]],
        "31028": [["Vazzola", "TV"], ["Tezze", "TV"], ["Visna'", "TV"]],
        "31029": [
            ["Fadalto", "TV"],
            ["San Giacomo Di Veglia", "TV"],
            ["San Floriano", "TV"],
            ["Cozzuolo", "TV"],
            ["Nove", "TV"],
            ["Carpesica", "TV"],
            ["Vittorio Veneto", "TV"],
        ],
        "31030": [
            ["Borso Del Grappa", "TV"],
            ["Pero", "TV"],
            ["Caselle Di Altivole", "TV"],
            ["Dosson", "TV"],
            ["Carbonera", "TV"],
            ["San Vito Di Altivole", "TV"],
            ["Saletto", "TV"],
            ["Valla'", "TV"],
            ["Casier", "TV"],
            ["Cison Di Valmarino", "TV"],
            ["Sant'Eulalia", "TV"],
            ["Mignagola", "TV"],
            ["Arcade", "TV"],
            ["Vacil", "TV"],
            ["Tovena", "TV"],
            ["Semonzo", "TV"],
            ["Castelcucco", "TV"],
            ["Altivole", "TV"],
            ["Castello Di Godego", "TV"],
            ["San Bartolomeo", "TV"],
            ["Breda Di Piave", "TV"],
        ],
        "31031": [["Caerano Di San Marco", "TV"]],
        "31032": [["Lughignano", "TV"], ["Casale Sul Sile", "TV"], ["Conscio", "TV"]],
        "31033": [
            ["Salvatronda", "TV"],
            ["Salvarosa", "TV"],
            ["Castelfranco Veneto", "TV"],
            ["Sant'Andrea", "TV"],
            ["Villarazzo", "TV"],
        ],
        "31034": [["Cavaso Del Tomba", "TV"]],
        "31035": [["Ciano Del Montello", "TV"], ["Ciano", "TV"], ["Crocetta Del Montello", "TV"]],
        "31036": [["Istrana", "TV"], ["Ospedaletto", "TV"], ["Pezzan", "TV"], ["Sala", "TV"]],
        "31037": [["Ramon Campagna", "TV"], ["Loria", "TV"], ["Castione", "TV"], ["Bessica", "TV"]],
        "31038": [
            ["Paese", "TV"],
            ["Padernello", "TV"],
            ["Castagnole", "TV"],
            ["Porcellengo", "TV"],
            ["Postioma", "TV"],
        ],
        "31039": [["Riese Pio X", "TV"], ["Poggiana", "TV"], ["Spineda", "TV"]],
        "31040": [
            ["Portobuffole'", "TV"],
            ["Pederobba", "TV"],
            ["Campo Di Pietra", "TV"],
            ["Santi Angeli", "TV"],
            ["Musano Di Trevignano", "TV"],
            ["Segusino", "TV"],
            ["Volpago Del Montello", "TV"],
            ["Bavaria", "TV"],
            ["Salgareda", "TV"],
            ["Venegazzu'", "TV"],
            ["Giavera Del Montello", "TV"],
            ["Campo Di Pietra Di Salgareda", "TV"],
            ["Mansue'", "TV"],
            ["Covolo", "TV"],
            ["Cessalto", "TV"],
            ["Onigo", "TV"],
            ["Falze'", "TV"],
            ["Selva Del Montello", "TV"],
            ["Meduna Di Livenza", "TV"],
            ["Signoressa", "TV"],
            ["Fossalta Maggiore", "TV"],
            ["Santi Angeli Del Montello", "TV"],
            ["Trevignano", "TV"],
            ["Gorgo Al Monticano", "TV"],
            ["Nervesa Della Battaglia", "TV"],
            ["Cusignana", "TV"],
            ["Chiarano", "TV"],
            ["Musano", "TV"],
        ],
        "31041": [["Cornuda", "TV"]],
        "31042": [["Fagare' Della Battaglia", "TV"], ["Fagare'", "TV"]],
        "31043": [["Lutrano", "TV"], ["Fontanelle", "TV"]],
        "31044": [["Biadene", "TV"], ["Montebelluna", "TV"]],
        "31045": [["Motta Di Livenza", "TV"]],
        "31046": [["Fae'", "TV"], ["Oderzo", "TV"], ["Rustigne'", "TV"], ["Piavon", "TV"]],
        "31047": [["Negrisia", "TV"], ["Ponte Di Piave", "TV"], ["Levada", "TV"]],
        "31048": [
            ["Cavrie", "TV"],
            ["Spercenigo", "TV"],
            ["Olmi", "TV"],
            ["Olmi Di Treviso", "TV"],
            ["San Biagio Di Callalta", "TV"],
        ],
        "31049": [
            ["San Vito Di Valdobbiadene", "TV"],
            ["Bigolino", "TV"],
            ["San Pietro Di Barbozza", "TV"],
            ["Valdobbiadene", "TV"],
            ["Guia", "TV"],
            ["Pianezze", "TV"],
            ["Santo Stefano", "TV"],
        ],
        "31050": [
            ["Santandra'", "TV"],
            ["Morgano", "TV"],
            ["Combai", "TV"],
            ["Zenson Di Piave", "TV"],
            ["Fossalunga", "TV"],
            ["Carpenedo", "TV"],
            ["Miane", "TV"],
            ["Cavasagra Di Vedelago", "TV"],
            ["Vedelago", "TV"],
            ["Fanzolo", "TV"],
            ["Albaredo", "TV"],
            ["Vascon", "TV"],
            ["Barcon", "TV"],
            ["Camalo'", "TV"],
            ["Badoere", "TV"],
            ["Povegliano", "TV"],
            ["Casacorba", "TV"],
            ["Premaor", "TV"],
            ["Ponzano Veneto", "TV"],
            ["Cavasagra", "TV"],
            ["Monastier Di Treviso", "TV"],
        ],
        "31051": [["Valmareno", "TV"], ["Follina", "TV"], ["Pedeguarda", "TV"]],
        "31052": [["Varago", "TV"], ["Maserada Sul Piave", "TV"], ["Candelu'", "TV"]],
        "31053": [["Pieve Di Soligo", "TV"], ["Barbisano", "TV"], ["Solighetto", "TV"]],
        "31054": [["Possagno", "TV"]],
        "31055": [["Quinto Di Treviso", "TV"], ["Santa Cristina", "TV"]],
        "31056": [["Musestre", "TV"], ["San Cipriano", "TV"], ["Roncade", "TV"], ["Biancade", "TV"]],
        "31057": [["Cendon", "TV"], ["Silea", "TV"], ["Sant'Elena", "TV"]],
        "31058": [["Susegana", "TV"]],
        "31059": [["Scandolara", "TV"], ["Zero Branco", "TV"], ["Sant'Alberto", "TV"]],
        "31100": [
            ["Treviso", "TV"],
            ["Fiera", "TV"],
            ["Selvana Bassa", "TV"],
            ["Monigo", "TV"],
            ["Santa Maria Della Rovere", "TV"],
            ["Canizzano", "TV"],
        ],
        "30010": [
            ["Lughetto", "VE"],
            ["Campolongo Maggiore", "VE"],
            ["Cona", "VE"],
            ["Campagna Lupia", "VE"],
            ["Lova", "VE"],
            ["Pegolotte", "VE"],
            ["Cantarana", "VE"],
            ["Camponogara", "VE"],
            ["Liettoli", "VE"],
            ["Bojon", "VE"],
        ],
        "30013": [
            ["Ca' Pasquali", "VE"],
            ["Cavallino Treporti", "VE"],
            ["Cavallino", "VE"],
            ["Treporti", "VE"],
            ["Ca' Ballarin", "VE"],
            ["Ca' Savio", "VE"],
        ],
        "30014": [
            ["Rottanova", "VE"],
            ["Rottanova Di Cavarzere", "VE"],
            ["Cavarzere", "VE"],
            ["San Pietro", "VE"],
            ["Boscochiaro", "VE"],
            ["Villaggio Busonera", "VE"],
            ["San Pietro Di Cavarzere", "VE"],
        ],
        "30015": [
            ["Valli", "VE"],
            ["Sant'Anna", "VE"],
            ["Ca' Bianca", "VE"],
            ["Sottomarina", "VE"],
            ["Chioggia", "VE"],
            ["Sant'Anna Di Chioggia", "VE"],
            ["Cavanella D'Adige", "VE"],
        ],
        "30016": [["Iesolo", "VE"], ["Lido Di Iesolo", "VE"]],
        "30020": [
            ["Eraclea Mare", "VE"],
            ["Torre Di Mosto", "VE"],
            ["Giai", "VE"],
            ["Cinto Caomaggiore", "VE"],
            ["Stretti", "VE"],
            ["Pramaggiore", "VE"],
            ["Stretti Di Eraclea", "VE"],
            ["Portegrandi", "VE"],
            ["Belfiore", "VE"],
            ["Marcon", "VE"],
            ["Torre Di Fine", "VE"],
            ["Meolo", "VE"],
            ["Noventa Di Piave", "VE"],
            ["Loncon", "VE"],
            ["Pramaggiore Blessaglia", "VE"],
            ["Quarto D'Altino", "VE"],
            ["Fossalta Di Piave", "VE"],
            ["Annone Veneto", "VE"],
            ["Gruaro", "VE"],
            ["Gaggio", "VE"],
            ["Losson Della Battaglia", "VE"],
            ["San Liberale", "VE"],
            ["Bagnara", "VE"],
            ["Eraclea", "VE"],
            ["Ponte Crepaldo", "VE"],
        ],
        "30021": [
            ["Ca' Corniani", "VE"],
            ["San Giorgio Di Livenza", "VE"],
            ["San Gaetano", "VE"],
            ["Caorle", "VE"],
            ["Porto Santa Margherita", "VE"],
        ],
        "30022": [["Ceggia", "VE"]],
        "30023": [["Concordia Sagittaria", "VE"], ["Sindacale", "VE"]],
        "30024": [["Croce", "VE"], ["Musile Di Piave", "VE"]],
        "30025": [
            ["Cintello", "VE"],
            ["Teglio Veneto", "VE"],
            ["Fossalta Di Portogruaro", "VE"],
            ["Fratta", "VE"],
            ["Villanova Santa Margherita", "VE"],
        ],
        "30026": [["Lugugnana", "VE"], ["Summaga", "VE"], ["Pradipozzo", "VE"], ["Portogruaro", "VE"]],
        "30027": [["Passarella", "VE"], ["Calvecchia", "VE"], ["San Dona' Di Piave", "VE"]],
        "30028": [
            ["Bibione", "VE"],
            ["Cesarolo", "VE"],
            ["San Giorgio Al Tagliamento", "VE"],
            ["Bibione Pineda", "VE"],
            ["Pozzi San Michele Tagliamento", "VE"],
            ["San Michele Al Tagliamento", "VE"],
            ["Pozzi", "VE"],
        ],
        "30029": [["La Salute Di Livenza", "VE"], ["Corbolone", "VE"], ["Santo Stino Di Livenza", "VE"]],
        "30030": [
            ["Fosso'", "VE"],
            ["Martellago", "VE"],
            ["Sandon", "VE"],
            ["Maerne", "VE"],
            ["Olmo Di Martellago", "VE"],
            ["Galta", "VE"],
            ["Salzano", "VE"],
            ["Olmo", "VE"],
            ["Tombelle", "VE"],
            ["Pianiga", "VE"],
            ["Cazzago Di Pianiga", "VE"],
            ["Robegano", "VE"],
            ["Vigonovo", "VE"],
            ["Cazzago", "VE"],
        ],
        "30031": [["Arino", "VE"], ["Sambruson", "VE"], ["Dolo", "VE"]],
        "30032": [["Fiesso D'Artico", "VE"]],
        "30033": [["Moniego", "VE"], ["Cappelletta", "VE"], ["Moniego Di Noale", "VE"], ["Noale", "VE"]],
        "30034": [
            ["Gambarare", "VE"],
            ["Marano", "VE"],
            ["Marano Veneziano", "VE"],
            ["Mira Porte", "VE"],
            ["Oriago", "VE"],
            ["Borbiago", "VE"],
            ["Mira Taglio", "VE"],
            ["Mira", "VE"],
        ],
        "30035": [["Ballo'", "VE"], ["Zianigo", "VE"], ["Mirano", "VE"], ["Vetrego", "VE"], ["Scaltenigo", "VE"]],
        "30036": [
            ["Caltana", "VE"],
            ["Santa Maria Di Sala", "VE"],
            ["Veternigo", "VE"],
            ["Stigliano", "VE"],
            ["Sant'Angelo", "VE"],
        ],
        "30037": [["Peseggia", "VE"], ["Scorze'", "VE"], ["Rio San Martino", "VE"]],
        "30038": [["Fornase", "VE"], ["Orgnano", "VE"], ["Spinea", "VE"]],
        "30039": [["San Pietro Di Stra'", "VE"], ["Stra", "VE"], ["Paluello", "VE"]],
        "30100": [["Venezia", "VE"]],
        "30121": [["Venezia", "VE"], ["Cannaregio", "VE"]],
        "30122": [["Sant'Elena", "VE"], ["Venezia", "VE"], ["Castello", "VE"]],
        "30123": [["Venezia", "VE"], ["Dorsoduro", "VE"]],
        "30124": [["Venezia", "VE"], ["San Marco", "VE"]],
        "30125": [["San Polo", "VE"], ["Venezia", "VE"]],
        "30126": [
            ["Venezia", "VE"],
            ["Malamocco", "VE"],
            ["Lido", "VE"],
            ["Alberoni", "VE"],
            ["Portosecco", "VE"],
            ["San Pietro In Volta", "VE"],
            ["Vianelli", "VE"],
            ["Zennari", "VE"],
            ["Scarpa", "VE"],
            ["Lido Di Venezia", "VE"],
            ["Busetti", "VE"],
        ],
        "30131": [["Venezia", "VE"]],
        "30132": [["Venezia", "VE"], ["Sant'Elena", "VE"]],
        "30133": [["Sacca Fisola", "VE"], ["Venezia", "VE"], ["Giudecca", "VE"]],
        "30135": [["Santa Croce", "VE"], ["Venezia", "VE"]],
        "30141": [["Venezia", "VE"], ["Murano", "VE"]],
        "30142": [
            ["Mazzorbo", "VE"],
            ["San Martino Destra", "VE"],
            ["Burano", "VE"],
            ["San Martino Sinistra", "VE"],
            ["Giudecca Di Burano", "VE"],
            ["Terranova", "VE"],
            ["San Mauro", "VE"],
        ],
        "30170": [["Venezia Mestre", "VE"]],
        "30171": [["Mestre", "VE"]],
        "30172": [["Mestre", "VE"]],
        "30173": [["Campalto", "VE"], ["Mestre", "VE"], ["Venezia", "VE"], ["Villaggio San Marco", "VE"]],
        "30174": [["Zelarino", "VE"], ["Gazzera", "VE"], ["Mestre", "VE"]],
        "30175": [["Mestre", "VE"], ["Ca' Emiliani", "VE"], ["Carpenedo", "VE"], ["Marghera", "VE"]],
        "36010": [
            ["Camporovere", "VI"],
            ["Chiuppano", "VI"],
            ["Seghe Di Velo", "VI"],
            ["Mezzaselva Di Roana", "VI"],
            ["Cavazzale", "VI"],
            ["Laghi", "VI"],
            ["Cesuna", "VI"],
            ["Velo", "VI"],
            ["Roana", "VI"],
            ["Carre'", "VI"],
            ["Canove Di Roana", "VI"],
            ["Cogollo Del Cengio", "VI"],
            ["Monticello Conte Otto", "VI"],
            ["Tresche' Conca", "VI"],
            ["Rotzo", "VI"],
            ["Seghe", "VI"],
            ["Foza", "VI"],
            ["Vigardolo", "VI"],
            ["Zane'", "VI"],
            ["Posina", "VI"],
            ["Velo D'Astico", "VI"],
        ],
        "36011": [["Arsiero", "VI"], ["Castana", "VI"]],
        "36012": [["Rigoni", "VI"], ["Rodeghieri", "VI"], ["Asiago", "VI"], ["Sasso", "VI"]],
        "36013": [["Piovene Rocchette", "VI"]],
        "36014": [["Santorso", "VI"]],
        "36015": [
            ["Monte Magre'", "VI"],
            ["Giavenale", "VI"],
            ["Sant'Ulderico Di Tretto", "VI"],
            ["Magre' Di Schio", "VI"],
            ["Schio", "VI"],
            ["Tretto", "VI"],
            ["Sant'Ulderico", "VI"],
        ],
        "36016": [["Thiene", "VI"], ["Rozzampia", "VI"]],
        "36020": [
            ["Zovencedo", "VI"],
            ["San Marino", "VI"],
            ["Solagna", "VI"],
            ["Albettone", "VI"],
            ["Campiglia Dei Berici", "VI"],
            ["Agugliaro", "VI"],
            ["Ponte Di Castegnero", "VI"],
            ["Villaganzerla", "VI"],
            ["Primolano", "VI"],
            ["Asigliano Veneto", "VI"],
            ["Pove Del Grappa", "VI"],
            ["Castegnero", "VI"],
            ["Carpane'", "VI"],
        ],
        "36021": [["Villaga", "VI"], ["Ponte Di Barbarano", "VI"], ["Barbarano Vicentino", "VI"]],
        "36022": [["San Giuseppe", "VI"], ["San Zeno", "VI"], ["San Giuseppe Di Cassola", "VI"], ["Cassola", "VI"]],
        "36023": [["Longare", "VI"], ["Lumignano", "VI"], ["Bugano", "VI"]],
        "36024": [["Mossano", "VI"], ["Nanto", "VI"], ["Ponte Di Nanto", "VI"]],
        "36025": [["Noventa Vicentina", "VI"]],
        "36026": [["Cagnano", "VI"], ["Poiana Maggiore", "VI"]],
        "36027": [["Rosa'", "VI"]],
        "36028": [["Rossano Veneto", "VI"]],
        "36029": [
            ["Campolongo Sul Brenta", "VI"],
            ["Valstagna", "VI"],
            ["San Nazario", "VI"],
            ["Cismon Del Grappa", "VI"],
        ],
        "36030": [
            ["Lugo Di Vicenza", "VI"],
            ["Cresole", "VI"],
            ["Sarcedo", "VI"],
            ["Fara Vicentino", "VI"],
            ["Novoledo", "VI"],
            ["Zugliano", "VI"],
            ["Grumolo Pedemonte", "VI"],
            ["Priabona", "VI"],
            ["Sant'Antonio", "VI"],
            ["Leva' Di Montecchio Precalcino", "VI"],
            ["Villaverla", "VI"],
            ["Caltrano", "VI"],
            ["Staro", "VI"],
            ["Calvene", "VI"],
            ["Montecchio Precalcino", "VI"],
            ["Monte Di Malo", "VI"],
            ["Rettorgole", "VI"],
            ["Sant'Antonio Valli", "VI"],
            ["Valli Del Pasubio", "VI"],
            ["Motta", "VI"],
            ["San Vito Di Leguzzano", "VI"],
            ["Costabissara", "VI"],
            ["Leva'", "VI"],
            ["Preara", "VI"],
            ["San Giorgio Di Perlena", "VI"],
            ["Centrale", "VI"],
            ["Caldogno", "VI"],
        ],
        "36031": [["Dueville", "VI"], ["Povolaro", "VI"]],
        "36032": [["Gallio", "VI"]],
        "36033": [["Isola Vicentina", "VI"], ["Castelnovo", "VI"]],
        "36034": [["Malo", "VI"], ["San Tomio", "VI"]],
        "36035": [["Marano Vicentino", "VI"]],
        "36036": [["Torrebelvicino", "VI"], ["Pievebelvicino", "VI"]],
        "36040": [
            ["Orgiano", "VI"],
            ["Lastebasse", "VI"],
            ["Pedescala", "VI"],
            ["Poiana Di Granfion", "VI"],
            ["Valdastico", "VI"],
            ["Casotto", "VI"],
            ["Lerino", "VI"],
            ["Pedemonte", "VI"],
            ["Brendola", "VI"],
            ["Pederiva", "VI"],
            ["San Pietro Valdastico", "VI"],
            ["Marola", "VI"],
            ["Sossano", "VI"],
            ["Laverda", "VI"],
            ["Sarego", "VI"],
            ["Grancona", "VI"],
            ["Grisignano Di Zocco", "VI"],
            ["Salcedo", "VI"],
            ["Grumolo Delle Abbadesse", "VI"],
            ["Vo'", "VI"],
            ["San Germano Dei Berici", "VI"],
            ["Monticello Di Fara", "VI"],
            ["Meledo", "VI"],
            ["Tonezza Del Cimone", "VI"],
            ["Barcarola", "VI"],
            ["Torri Di Quartesolo", "VI"],
        ],
        "36042": [["Mirabella", "VI"], ["Maragnole", "VI"], ["Breganze", "VI"]],
        "36043": [["Camisano Vicentino", "VI"]],
        "36045": [
            ["Lonigo", "VI"],
            ["Bagnolo Di Lonigo", "VI"],
            ["Bagnolo", "VI"],
            ["Almisano", "VI"],
            ["Alonte", "VI"],
        ],
        "36046": [["Santa Caterina", "VI"], ["Conco", "VI"], ["Lusiana", "VI"]],
        "36047": [["Montegalda", "VI"], ["Montegaldella", "VI"]],
        "36050": [
            ["Bolzano Vicentino", "VI"],
            ["Monteviale", "VI"],
            ["Friola", "VI"],
            ["Villaggio Montegrappa", "VI"],
            ["Pozzoleone", "VI"],
            ["Lanze'", "VI"],
            ["Bressanvido", "VI"],
            ["Zermeghedo", "VI"],
            ["Poianella", "VI"],
            ["Sovizzo", "VI"],
            ["Cartigliano", "VI"],
            ["Ospedaletto", "VI"],
            ["Montorso Vicentino", "VI"],
            ["Quinto Vicentino", "VI"],
            ["Lisiera", "VI"],
            ["Gambugliano", "VI"],
        ],
        "36051": [["Olmo", "VI"], ["Creazzo", "VI"]],
        "36052": [["Enego", "VI"], ["Stoner", "VI"]],
        "36053": [["Gambellara", "VI"]],
        "36054": [["Montebello Vicentino", "VI"]],
        "36055": [["Nove", "VI"]],
        "36056": [["Tezze Sul Brenta", "VI"], ["Belvedere", "VI"]],
        "36057": [
            ["Tormeno", "VI"],
            ["Arcugnano", "VI"],
            ["Pianezze Del Lago", "VI"],
            ["Nogarazza", "VI"],
            ["Torri D'Arcugnano", "VI"],
        ],
        "36060": [
            ["Fellette Di Romano D'Ezzellino", "VI"],
            ["Fellette", "VI"],
            ["Romano D'Ezzelino", "VI"],
            ["Villa Di Molvena", "VI"],
            ["Spin", "VI"],
            ["Pianezze", "VI"],
            ["Longa", "VI"],
            ["Schiavon", "VI"],
        ],
        "36061": [["Valrovina", "VI"], ["Bassano Del Grappa", "VI"], ["Campese", "VI"]],
        "36062": [["Fontanelle", "VI"]],
        "36063": [["Valle San Floriano", "VI"], ["Marostica", "VI"], ["Vallonara", "VI"], ["Crosara", "VI"]],
        "36064": [["Molvena", "VI"], ["Mason Vicentino", "VI"], ["Villaraspa", "VI"]],
        "36065": [["Mussolente", "VI"], ["Casoni", "VI"]],
        "36066": [["Sandrigo", "VI"]],
        "36070": [
            ["Molino Di Altissimo", "VI"],
            ["Altissimo", "VI"],
            ["Molino", "VI"],
            ["Brogliano", "VI"],
            ["Lovara", "VI"],
            ["Ferrazza", "VI"],
            ["Trissino", "VI"],
            ["San Pietro Mussolino", "VI"],
            ["San Pietro Vecchio", "VI"],
            ["Crespadoro", "VI"],
            ["Nogarole Vicentino", "VI"],
            ["Castelgomberto", "VI"],
        ],
        "36071": [["Pugnello", "VI"], ["Arzignano", "VI"], ["Tezze", "VI"]],
        "36072": [["Chiampo", "VI"]],
        "36073": [["Cereda", "VI"], ["Cornedo Vicentino", "VI"]],
        "36075": [
            ["Montecchio Maggiore", "VI"],
            ["Alte Di Montecchio Maggiore", "VI"],
            ["Alte Ceccato", "VI"],
            ["Sant'Urbano", "VI"],
        ],
        "36076": [["Rovegliana", "VI"], ["Recoaro Terme", "VI"]],
        "36077": [["Valmarana", "VI"], ["Altavilla Vicentina", "VI"], ["Tavernelle Vicentina", "VI"]],
        "36078": [
            ["Maglio Di Sopra", "VI"],
            ["Novale", "VI"],
            ["Castelvecchio", "VI"],
            ["Valdagno", "VI"],
            ["Piana", "VI"],
            ["San Quirico", "VI"],
        ],
        "36100": [
            ["Vicenza", "VI"],
            ["Setteca'", "VI"],
            ["Anconetta", "VI"],
            ["Longara", "VI"],
            ["Polegge", "VI"],
            ["Campedello", "VI"],
        ],
        "37010": [
            ["Brenzone", "VR"],
            ["Albare' Stazione", "VR"],
            ["Albare'", "VR"],
            ["Torri Del Benaco", "VR"],
            ["Costermano", "VR"],
            ["Magugnano", "VR"],
            ["San Zeno Di Montagna", "VR"],
            ["Piovezzano", "VR"],
            ["Rivoli Veronese", "VR"],
            ["Castelletto Di Brenzone", "VR"],
            ["Sega", "VR"],
            ["Sega Di Cavaion", "VR"],
            ["Affi", "VR"],
            ["San Zeno", "VR"],
            ["Cavaion Veronese", "VR"],
            ["Castion Veronese", "VR"],
            ["Pastrengo", "VR"],
        ],
        "37011": [["Cisano", "VR"], ["Calmasino", "VR"], ["Bardolino", "VR"]],
        "37012": [["Bussolengo", "VR"], ["San Vito Al Mantico", "VR"]],
        "37013": [["Pesina", "VR"], ["Spiazzi", "VR"], ["Caprino Veronese", "VR"], ["Boi", "VR"]],
        "37014": [["Oliosi", "VR"], ["Castelnuovo Del Garda", "VR"], ["Sandra'", "VR"], ["Cavalcaselle", "VR"]],
        "37015": [["Gargagnago", "VR"], ["Domegliara", "VR"], ["Monte", "VR"], ["Sant'Ambrogio Di Valpolicella", "VR"]],
        "37016": [["Garda", "VR"]],
        "37017": [["Lazise", "VR"], ["Cola' Di Lazise", "VR"], ["Cola'", "VR"], ["Pacengo", "VR"]],
        "37018": [["Cassone", "VR"], ["Malcesine", "VR"]],
        "37019": [["Peschiera Del Garda", "VR"], ["San Benedetto Di Lugana", "VR"]],
        "37020": [
            ["Rivalta", "VR"],
            ["Valgatara", "VR"],
            ["Sant'Anna D'Alfaedo", "VR"],
            ["Belluno Veronese", "VR"],
            ["Peri", "VR"],
            ["Cerro Veronese", "VR"],
            ["Brentino Belluno", "VR"],
            ["Ferrara Di Monte Baldo", "VR"],
            ["Cerna", "VR"],
            ["Marano Di Valpolicella", "VR"],
            ["Prun", "VR"],
            ["Fosse", "VR"],
            ["Fane", "VR"],
            ["Erbezzo", "VR"],
            ["Dolce'", "VR"],
            ["Volargne", "VR"],
        ],
        "37021": [["Bosco Chiesanuova", "VR"], ["Corbiolo", "VR"], ["Lughezzano", "VR"]],
        "37022": [["Fumane", "VR"], ["Cavalo", "VR"], ["Breonio", "VR"]],
        "37023": [
            ["Stallavena", "VR"],
            ["Romagnano", "VR"],
            ["Azzago", "VR"],
            ["Grezzana", "VR"],
            ["Lugo Di Grezzana", "VR"],
        ],
        "37024": [
            ["Negrar", "VR"],
            ["Santa Maria Di Negrar", "VR"],
            ["Arbizzano Di Valpolicella", "VR"],
            ["Arbizzano", "VR"],
        ],
        "37026": [["Ospedaletto", "VR"], ["Pescantina", "VR"], ["Settimo", "VR"]],
        "37028": [["Rovere' Veronese", "VR"]],
        "37029": [
            ["Pedemonte", "VR"],
            ["San Floriano", "VR"],
            ["Negarine", "VR"],
            ["San Pietro In Cariano", "VR"],
            ["Corrubbio", "VR"],
            ["Bure", "VR"],
        ],
        "37030": [
            ["Vestenanova", "VR"],
            ["Lavagno", "VR"],
            ["Montecchia Di Crosara", "VR"],
            ["Vago", "VR"],
            ["San Vittore", "VR"],
            ["Colognola Ai Colli", "VR"],
            ["San Bortolo", "VR"],
            ["Mezzane Di Sotto", "VR"],
            ["Selva Di Progno", "VR"],
            ["Stra'", "VR"],
            ["Velo Veronese", "VR"],
            ["Montanara", "VR"],
            ["Terrossa", "VR"],
            ["San Rocco Di Piegara", "VR"],
            ["San Briccio", "VR"],
            ["Ronca'", "VR"],
            ["San Mauro Di Saline", "VR"],
            ["Cazzano Di Tramigna", "VR"],
            ["San Pietro", "VR"],
            ["Badia Calavena", "VR"],
        ],
        "37031": [["Cellore", "VR"], ["Illasi", "VR"]],
        "37032": [["Monteforte D'Alpone", "VR"], ["Brognoligo", "VR"], ["Costalunga", "VR"]],
        "37035": [["San Giovanni Ilarione", "VR"]],
        "37036": [["Ferrazze", "VR"], ["Marcellise", "VR"], ["San Martino Buon Albergo", "VR"], ["Mambrotta", "VR"]],
        "37038": [["Soave", "VR"], ["Castelletto", "VR"]],
        "37039": [["Tregnago", "VR"], ["Cogollo", "VR"], ["Centro", "VR"]],
        "37040": [
            ["Arcole", "VR"],
            ["Caselle", "VR"],
            ["Marega", "VR"],
            ["Begosso", "VR"],
            ["Zimella", "VR"],
            ["Bevilacqua", "VR"],
            ["Terrazzo", "VR"],
            ["Bonavigo", "VR"],
            ["Roveredo Di Gua'", "VR"],
            ["San Gregorio Di Veronella", "VR"],
            ["San Gregorio", "VR"],
            ["Santo Stefano Di Zimella", "VR"],
            ["Sabbion", "VR"],
            ["Veronella", "VR"],
            ["Pressana", "VR"],
            ["Santo Stefano", "VR"],
            ["Boschi Sant'Anna", "VR"],
            ["Gazzolo", "VR"],
            ["Orti", "VR"],
        ],
        "37041": [["Presina", "VR"], ["Albaredo D'Adige", "VR"], ["Michellorie", "VR"], ["Coriano Veronese", "VR"]],
        "37042": [["Caldiero", "VR"], ["Caldierino", "VR"]],
        "37043": [["Castagnaro", "VR"], ["Mena'", "VR"], ["Mena' Vallestrema", "VR"]],
        "37044": [["Cologna Veneta", "VR"], ["San Sebastiano", "VR"], ["Sule'", "VR"], ["Baldaria", "VR"]],
        "37045": [
            ["San Pietro Di Legnago", "VR"],
            ["Casette", "VR"],
            ["Gallese", "VR"],
            ["Legnago", "VR"],
            ["Vangadizza", "VR"],
            ["Terranegra", "VR"],
        ],
        "37046": [["Minerbe", "VR"]],
        "37047": [["Locara", "VR"], ["San Bonifacio", "VR"], ["Prova", "VR"], ["Villabella", "VR"]],
        "37049": [["Spinimbecco", "VR"], ["Carpi Di Villa Bartolomea", "VR"], ["Villa Bartolomea", "VR"]],
        "37050": [
            ["Belfiore", "VR"],
            ["Concamarise", "VR"],
            ["Bonavicina", "VR"],
            ["Vallese", "VR"],
            ["San Pietro Di Morubio", "VR"],
            ["Roverchiaretta", "VR"],
            ["Piazza", "VR"],
            ["Roverchiara", "VR"],
            ["Isola Rizza", "VR"],
            ["Ca' Degli Oppi", "VR"],
            ["Angiari", "VR"],
            ["Oppeano", "VR"],
            ["Palu'", "VR"],
        ],
        "37051": [["Bovolone", "VR"], ["Villafontana", "VR"]],
        "37052": [["Casaleone", "VR"]],
        "37053": [["Cherubine", "VR"], ["Asparetto", "VR"], ["Cerea", "VR"]],
        "37054": [["Nogara", "VR"]],
        "37055": [["Tombazosana", "VR"], ["Albaro", "VR"], ["Ronco All'Adige", "VR"]],
        "37056": [["Crosarol", "VR"], ["Valmorsel", "VR"], ["Salizzole", "VR"], ["Bionde", "VR"], ["Engazza'", "VR"]],
        "37057": [["Raldon", "VR"], ["San Giovanni Lupatoto", "VR"], ["Pozzo Camacici", "VR"]],
        "37058": [["Sanguinetto", "VR"]],
        "37059": [
            ["Zevio", "VR"],
            ["Campagnola", "VR"],
            ["Perzacco", "VR"],
            ["Volon", "VR"],
            ["Santa Maria Di Zevio", "VR"],
        ],
        "37060": [
            ["Maccacari", "VR"],
            ["Pradelle", "VR"],
            ["Castel D'Azzano", "VR"],
            ["Pontepossero", "VR"],
            ["Bovo", "VR"],
            ["Correzzo", "VR"],
            ["Azzano", "VR"],
            ["Roncanova", "VR"],
            ["Buttapietra", "VR"],
            ["Bagnolo", "VR"],
            ["Palazzolo", "VR"],
            ["Bonferraro", "VR"],
            ["Sorga'", "VR"],
            ["San Pietro In Valle", "VR"],
            ["Erbe'", "VR"],
            ["Sona", "VR"],
            ["Marchesino", "VR"],
            ["Beccacivetta", "VR"],
            ["Roncoleva'", "VR"],
            ["Trevenzuolo", "VR"],
            ["San Giorgio In Salici", "VR"],
            ["Mozzecane", "VR"],
            ["Nogarole Rocca", "VR"],
            ["Lugagnano", "VR"],
            ["Gazzo Veronese", "VR"],
        ],
        "37062": [["Dossobuono", "VR"], ["Alpo", "VR"]],
        "37063": [["Pellegrina", "VR"], ["Tarmassia", "VR"], ["Isola Della Scala", "VR"]],
        "37064": [["Povegliano Veronese", "VR"]],
        "37066": [["Custoza", "VR"], ["Sommacampagna", "VR"], ["Caselle Di Sommacampagna", "VR"]],
        "37067": [["Salionze", "VR"], ["Valeggio Sul Mincio", "VR"]],
        "37068": [["Forette", "VR"], ["Vigasio", "VR"], ["Isolalta", "VR"]],
        "37069": [
            ["Pizzoletta", "VR"],
            ["Villafranca Di Verona", "VR"],
            ["Caluri", "VR"],
            ["Quaderni", "VR"],
            ["Rosegaferro", "VR"],
        ],
        "37100": [["Verona", "VR"]],
        "37121": [["Verona", "VR"]],
        "37122": [["Verona", "VR"]],
        "37123": [["Verona", "VR"]],
        "37124": [["Verona", "VR"]],
        "37125": [["Quinzano", "VR"], ["Verona", "VR"]],
        "37126": [["Verona", "VR"]],
        "37127": [["Verona", "VR"], ["Avesa", "VR"]],
        "37128": [["Verona", "VR"]],
        "37129": [["Verona", "VR"]],
        "37131": [["Verona", "VR"]],
        "37132": [["Verona", "VR"], ["San Michele Extra", "VR"]],
        "37133": [["Verona", "VR"]],
        "37134": [["Verona", "VR"]],
        "37135": [["Verona", "VR"]],
        "37136": [["Verona", "VR"]],
        "37137": [["Verona", "VR"]],
        "37138": [["Verona", "VR"]],
        "37139": [["San Massimo All'Adige", "VR"], ["Verona", "VR"], ["Chievo", "VR"]],
        "37142": [["Verona", "VR"]],
    }

    city_prefixes = ("San", "Borgo", "Sesto", "Quarto", "Settimo")
    city_suffixes = (
        "a mare",
        "lido",
        "ligure",
        "del friuli",
        "salentino",
        "calabro",
        "veneto",
        "nell'emilia",
        "umbro",
        "laziale",
        "terme",
        "sardo",
    )
    building_number_formats = ("@@#",)
    street_suffixes = (
        "Piazza",
        "Strada",
        "Via",
        "Borgo",
        "Contrada",
        "Rotonda",
        "Incrocio",
        "Viale",
        "Stretto",
        "Vicolo",
        "Canale",
    )
    postcode_formats = cap_city_province.keys()

    cities = getcities(cap_city_province)
    states = (
        "Agrigento",
        "Alessandria",
        "Ancona",
        "Aosta",
        "Arezzo",
        "Ascoli Piceno",
        "Asti",
        "Avellino",
        "Bari",
        "Barletta-Andria-Trani",
        "Belluno",
        "Benevento",
        "Bergamo",
        "Biella",
        "Bologna",
        "Bolzano",
        "Brescia",
        "Brindisi",
        "Cagliari",
        "Caltanissetta",
        "Campobasso",
        "Carbonia-Iglesias",
        "Caserta",
        "Catania",
        "Catanzaro",
        "Chieti",
        "Como",
        "Cosenza",
        "Cremona",
        "Crotone",
        "Cuneo",
        "Enna",
        "Fermo",
        "Ferrara",
        "Firenze",
        "Foggia",
        "Forlì-Cesena",
        "Frosinone",
        "Genova",
        "Gorizia",
        "Grosseto",
        "Imperia",
        "Isernia",
        "La Spezia",
        "L'Aquila",
        "Latina",
        "Lecce",
        "Lecco",
        "Livorno",
        "Lodi",
        "Lucca",
        "Macerata",
        "Mantova",
        "Massa-Carrara",
        "Matera",
        "Messina",
        "Milano",
        "Modena",
        "Monza e della Brianza",
        "Napoli",
        "Novara",
        "Nuoro",
        "Olbia-Tempio",
        "Oristano",
        "Padova",
        "Palermo",
        "Parma",
        "Pavia",
        "Perugia",
        "Pesaro e Urbino",
        "Pescara",
        "Piacenza",
        "Pisa",
        "Pistoia",
        "Pordenone",
        "Potenza",
        "Prato",
        "Ragusa",
        "Ravenna",
        "Reggio Calabria",
        "Reggio Emilia",
        "Rieti",
        "Rimini",
        "Roma",
        "Rovigo",
        "Salerno",
        "Medio Campidano",
        "Sassari",
        "Savona",
        "Siena",
        "Siracusa",
        "Sondrio",
        "Taranto",
        "Teramo",
        "Terni",
        "Torino",
        "Ogliastra",
        "Trapani",
        "Trento",
        "Treviso",
        "Trieste",
        "Udine",
        "Varese",
        "Venezia",
        "Verbano-Cusio-Ossola",
        "Vercelli",
        "Verona",
        "Vibo Valentia",
        "Vicenza",
        "Viterbo",
    )
    states_abbr = (
        "AG",
        "AL",
        "AN",
        "AO",
        "AR",
        "AP",
        "AT",
        "AV",
        "BA",
        "BT",
        "BL",
        "BN",
        "BG",
        "BI",
        "BO",
        "BZ",
        "BS",
        "BR",
        "CA",
        "CL",
        "CB",
        "CI",
        "CE",
        "CT",
        "CZ",
        "CH",
        "CO",
        "CS",
        "CR",
        "KR",
        "CN",
        "EN",
        "FM",
        "FE",
        "FI",
        "FG",
        "FC",
        "FR",
        "GE",
        "GO",
        "GR",
        "IM",
        "IS",
        "SP",
        "AQ",
        "LT",
        "LE",
        "LC",
        "LI",
        "LO",
        "LU",
        "MC",
        "MN",
        "MS",
        "MT",
        "ME",
        "MI",
        "MO",
        "MB",
        "NA",
        "NO",
        "NU",
        "OT",
        "OR",
        "PD",
        "PA",
        "PR",
        "PV",
        "PG",
        "PU",
        "PE",
        "PC",
        "PI",
        "PT",
        "PN",
        "PZ",
        "PO",
        "RG",
        "RA",
        "RC",
        "RE",
        "RI",
        "RN",
        "RM",
        "RO",
        "SA",
        "VS",
        "SS",
        "SV",
        "SI",
        "SR",
        "SO",
        "TA",
        "TE",
        "TR",
        "TO",
        "OG",
        "TP",
        "TN",
        "TV",
        "TS",
        "UD",
        "VA",
        "VE",
        "VB",
        "VC",
        "VR",
        "VV",
        "VI",
        "VT",
    )
    countries = (
        "Afghanistan",
        "Albania",
        "Algeria",
        "American Samoa",
        "Andorra",
        "Angola",
        "Anguilla",
        "Antartide (territori a sud del 60° parallelo)",
        "Antigua e Barbuda",
        "Argentina",
        "Armenia",
        "Aruba",
        "Australia",
        "Austria",
        "Azerbaijan",
        "Bahamas",
        "Bahrain",
        "Bangladesh",
        "Barbados",
        "Bielorussia",
        "Belgio",
        "Belize",
        "Benin",
        "Bermuda",
        "Bhutan",
        "Bolivia",
        "Bosnia e Herzegovina",
        "Botswana",
        "Bouvet Island (Bouvetoya)",
        "Brasile",
        "Territorio dell'arcipelago indiano",
        "Isole Vergini Britanniche",
        "Brunei Darussalam",
        "Bulgaria",
        "Burkina Faso",
        "Burundi",
        "Cambogia",
        "Cameroon",
        "Canada",
        "Capo Verde",
        "Isole Cayman",
        "Repubblica Centrale Africana",
        "Chad",
        "Cile",
        "Cina",
        "Isola di Pasqua",
        "Isola di Cocos (Keeling)",
        "Colombia",
        "Comoros",
        "Congo",
        "Isole Cook",
        "Costa Rica",
        "Costa d'Avorio",
        "Croazia",
        "Cuba",
        "Cipro",
        "Repubblica Ceca",
        "Danimarca",
        "Gibuti",
        "Repubblica Dominicana",
        "Equador",
        "Egitto",
        "El Salvador",
        "Guinea Equatoriale",
        "Eritrea",
        "Estonia",
        "Etiopia",
        "Isole Faroe",
        "Isole Falkland (Malvinas)",
        "Fiji",
        "Finlandia",
        "Francia",
        "Guyana Francese",
        "Polinesia Francese",
        "Territori Francesi del sud",
        "Gabon",
        "Gambia",
        "Georgia",
        "Germania",
        "Ghana",
        "Gibilterra",
        "Grecia",
        "Groenlandia",
        "Grenada",
        "Guadalupa",
        "Guam",
        "Guatemala",
        "Guernsey",
        "Guinea",
        "Guinea-Bissau",
        "Guyana",
        "Haiti",
        "Heard Island and McDonald Islands",
        "Città del Vaticano",
        "Honduras",
        "Hong Kong",
        "Ungheria",
        "Islanda",
        "India",
        "Indonesia",
        "Iran",
        "Iraq",
        "Irlanda",
        "Isola di Man",
        "Israele",
        "Italia",
        "Giamaica",
        "Giappone",
        "Jersey",
        "Giordania",
        "Kazakhstan",
        "Kenya",
        "Kiribati",
        "Korea",
        "Kuwait",
        "Republicca Kirgiza",
        "Repubblica del Laos",
        "Latvia",
        "Libano",
        "Lesotho",
        "Liberia",
        "Libyan Arab Jamahiriya",
        "Liechtenstein",
        "Lituania",
        "Lussemburgo",
        "Macao",
        "Macedonia del Nord",
        "Madagascar",
        "Malawi",
        "Malesia",
        "Maldive",
        "Mali",
        "Malta",
        "Isole Marshall",
        "Martinica",
        "Mauritania",
        "Mauritius",
        "Mayotte",
        "Messico",
        "Micronesia",
        "Moldova",
        "Principato di Monaco",
        "Mongolia",
        "Montenegro",
        "Montserrat",
        "Marocco",
        "Mozambico",
        "Myanmar",
        "Namibia",
        "Nauru",
        "Nepal",
        "Antille Olandesi",
        "Olanda",
        "Nuova Caledonia",
        "Nuova Zelanda",
        "Nicaragua",
        "Niger",
        "Nigeria",
        "Niue",
        "Isole Norfolk",
        "Northern Mariana Islands",
        "Norvegia",
        "Oman",
        "Pakistan",
        "Palau",
        "Palestina",
        "Panama",
        "Papua Nuova Guinea",
        "Paraguay",
        "Peru",
        "Filippine",
        "Pitcairn Islands",
        "Polonia",
        "Portogallo",
        "Porto Rico",
        "Qatar",
        "Reunion",
        "Romania",
        "Russia",
        "Rwanda",
        "San Bartolomeo",
        "Sant'Elena",
        "Saint Kitts and Nevis",
        "Saint Lucia",
        "Saint Martin",
        "Saint Pierre and Miquelon",
        "Saint Vincent and the Grenadines",
        "Samoa",
        "San Marino",
        "Sao Tome and Principe",
        "Arabia Saudita",
        "Senegal",
        "Serbia",
        "Seychelles",
        "Sierra Leone",
        "Singapore",
        "Slovenia",
        "Isole Solomon",
        "Somalia",
        "Sud Africa",
        "Georgia del sud e South Sandwich Islands",
        "Spagna",
        "Sri Lanka",
        "Sudan",
        "Suriname",
        "Svalbard & Jan Mayen Islands",
        "Swaziland",
        "Svezia",
        "Svizzera",
        "Siria",
        "Taiwan",
        "Tajikistan",
        "Tanzania",
        "Tailandia",
        "Timor-Leste",
        "Togo",
        "Tokelau",
        "Tonga",
        "Trinidad e Tobago",
        "Tunisia",
        "Turchia",
        "Turkmenistan",
        "Isole di Turks and Caicos",
        "Tuvalu",
        "Uganda",
        "Ucraina",
        "Emirati Arabi Uniti",
        "Regno Unito",
        "Stati Uniti d'America",
        "United States Minor Outlying Islands",
        "Isole Vergini Statunitensi",
        "Uruguay",
        "Uzbekistan",
        "Vanuatu",
        "Venezuela",
        "Vietnam",
        "Wallis and Futuna",
        "Western Sahara",
        "Yemen",
        "Zambia",
        "Zimbabwe",
    )
    city_formats = (
        "{{city_prefix}} {{first_name}} {{city_suffix}}",
        "{{city_prefix}} {{first_name}}",
        "{{first_name}} {{city_suffix}}",
        "{{last_name}} {{city_suffix}}",
    )
    street_name_formats = (
        "{{street_suffix}} {{first_name}}",
        "{{street_suffix}} {{last_name}}",
    )
    street_address_formats = (
        "{{street_name}}, {{building_number}}",
        "{{street_name}}, {{building_number}} {{secondary_address}}",
    )
    address_formats = ("{{street_address}}\n{{postcode_city_province}}",)
    secondary_address_formats = ("Appartamento @#", "Piano #")

    def postcode_city_province(self) -> str:
        cap = self.postcode()
        rand_city_prov: List[str] = self.random_element(self.cap_city_province[cap])
        return cap + ", " + rand_city_prov[0] + " (" + rand_city_prov[1] + ")"

    def city(self) -> str:
        return self.random_element(self.cities)

    def city_prefix(self) -> str:
        return self.random_element(self.city_prefixes)

    def secondary_address(self) -> str:
        return self.numerify(self.random_element(self.secondary_address_formats))

    def administrative_unit(self) -> str:
        return self.random_element(self.states)

    state = administrative_unit

    def state_abbr(self) -> str:
        return self.random_element(self.states_abbr)
