/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXCellAlignList;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class MultiCell
extends Command {
    private int columnSpan = 1;
    private int rowSpan = 1;
    private TeXCellAlign alignment;

    public MultiCell(String string) {
        this(string, 1, 1, null);
    }

    public MultiCell(String string, int n, int n2, TeXCellAlign teXCellAlign) {
        super(string);
        this.setColumnSpan(n);
        this.setRowSpan(n2);
        this.setAlignment(teXCellAlign);
    }

    public MultiCell(String string, int n, int n2, TeXParser teXParser, TeXObject teXObject) throws IOException {
        super(string);
        this.setColumnSpan(n);
        this.setRowSpan(n2);
        this.setAlignment(teXParser, teXObject);
    }

    @Override
    public Object clone() {
        MultiCell multiCell = new MultiCell(this.getName());
        multiCell.setColumnSpan(this.getColumnSpan());
        multiCell.setRowSpan(this.getRowSpan());
        multiCell.setAlignment(this.getAlignment());
        return multiCell;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXObjectList.popArg(teXParser).process(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.popNextArg().process(teXParser);
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public TeXCellAlign getAlignment() {
        return this.alignment;
    }

    public void setColumnSpan(int n) {
        this.columnSpan = n;
    }

    public void setRowSpan(int n) {
        this.rowSpan = n;
    }

    public void setAlignment(TeXCellAlign teXCellAlign) {
        this.alignment = teXCellAlign;
    }

    public void setAlignment(TeXParser teXParser, TeXObject teXObject) throws IOException {
        TeXCellAlignList teXCellAlignList = new TeXCellAlignList(teXParser, teXObject);
        this.alignment = teXCellAlignList.size() > 0 ? (TeXCellAlign)teXCellAlignList.get(0) : null;
    }

    @Override
    public String toString() {
        return String.format("%s{colspan:%d,rowspan:%d,align:%s}", this.getName(), this.getColumnSpan(), this.getRowSpan(), this.getAlignment());
    }
}

