var baseForRight = require('../internal/baseForRight'),
    bindCallback = require('../internal/bindCallback'),
    keys = require('./keys');

/**
 * This method is like `_.forOwn` except that it iterates over properties of
 * `object` in the opposite order.
 *
 * @static
 * @memberOf _
 * @category Object
 * @param {Object} object The object to iterate over.
 * @param {Function} [iteratee=_.identity] The function invoked per iteration.
 * @param {*} [thisArg] The `this` binding of `iteratee`.
 * @returns {Object} Returns `object`.
 * @example
 *
 * _.forOwnRight({ '0': 'zero', '1': 'one', 'length': 2 }, function(n, key) {
 *   console.log(key);
 * });
 * // => logs 'length', '1', and '0' assuming `_.forOwn` logs '0', '1', and 'length'
 */
function forOwnRight(object, iteratee, thisArg) {
  iteratee = bindCallback(iteratee, thisArg, 3);
  return baseForRight(object, iteratee, keys);
}

module.exports = forOwnRight;
