"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateLanguageServiceHost = void 0;
function decorateLanguageServiceHost(host) {
    const originalReadDirectory = host.readDirectory?.bind(host);
    host.readDirectory = originalReadDirectory
        ? (path, extensions, exclude, include, depth) => {
            const extensionsWithSvelte = extensions ? [...extensions, '.svelte'] : undefined;
            return originalReadDirectory(path, extensionsWithSvelte, exclude, include, depth);
        }
        : undefined;
}
exports.decorateLanguageServiceHost = decorateLanguageServiceHost;
//# sourceMappingURL=host.js.map