/**
 * Run the file set pipeline once.
 * `callback` is called with a fatal error, or with a status code (`0` on
 * success, `1` on failure).
 *
 * @param {Options} options
 * @param {Callback} callback
 */
export function engine(options: Options, callback: Callback): void
export type VFile = import('vfile').VFile
export type Processor = import('unified').Processor<any, any, any, any>
export type FileSet = import('./file-set.js').FileSet
export type Completer = import('./file-set.js').Completer
export type ResolveFrom = import('./ignore.js').ResolveFrom
export type ConfigTransform = import('./configuration.js').ConfigTransform
export type Preset = import('./configuration.js').Preset
export type VFileReporterFields = {
  color?: boolean | undefined
  quiet?: boolean | undefined
  silent?: boolean | undefined
}
export type VFileReporterOptions = {
  [key: string]: unknown
} & VFileReporterFields
export type VFileReporter = (
  files: Array<VFile>,
  options: VFileReporterOptions
) => string | Promise<string>
export type Settings = {
  processor: Options['processor']
  cwd: Exclude<Options['cwd'], undefined | URL>
  files: Array<string | VFile>
  extensions: Exclude<Options['extensions'], undefined>
  streamIn: Exclude<Options['streamIn'], undefined>
  filePath: Options['filePath']
  streamOut: Exclude<Options['streamOut'], undefined>
  streamError: Exclude<Options['streamError'], undefined>
  out: Options['out']
  output: Options['output']
  alwaysStringify: Options['alwaysStringify']
  tree: Options['tree']
  treeIn: Options['treeIn']
  treeOut: Options['treeOut']
  inspect: Options['inspect']
  rcName: Options['rcName']
  packageField: Options['packageField']
  detectConfig: Options['detectConfig']
  rcPath: Options['rcPath']
  settings: Exclude<Options['settings'], undefined>
  ignoreName: Options['ignoreName']
  detectIgnore: Options['detectIgnore']
  ignorePath: Options['ignorePath']
  ignorePathResolveFrom: Options['ignorePathResolveFrom']
  ignorePatterns: Exclude<Options['ignorePatterns'], undefined>
  ignoreUnconfigured: Exclude<Options['ignoreUnconfigured'], undefined>
  silentlyIgnore: Exclude<Options['silentlyIgnore'], undefined>
  plugins: Options['plugins']
  pluginPrefix: Options['pluginPrefix']
  configTransform: Options['configTransform']
  defaultConfig: Options['defaultConfig']
  reporter: Options['reporter']
  reporterOptions: Options['reporterOptions']
  color: Options['color']
  silent: Options['silent']
  quiet: Options['quiet']
  frail: Options['frail']
}
/**
 * Options for unified engine
 */
export type Options = {
  /**
   * Unified processor to transform files
   */
  processor: () => Processor
  /**
   * Directory to search files in, load plugins from, and more.
   * Defaults to `process.cwd()`.
   */
  cwd?: string | URL | undefined
  /**
   * Paths or globs to files and directories, or virtual files, to process.
   */
  files?: (string | import('vfile').VFile | URL)[] | undefined
  /**
   * If `files` matches directories, include `files` with `extensions`
   */
  extensions?: string[] | undefined
  /**
   * Stream to read from if no files are found or given.
   * Defaults to `process.stdin`.
   */
  streamIn?: NodeJS.ReadableStream | undefined
  /**
   * File path to process the given file on `streamIn` as.
   */
  filePath?: string | undefined
  /**
   * Stream to write processed files to.
   * Defaults to `process.stdout`.
   */
  streamOut?: NodeJS.WritableStream | undefined
  /**
   * Stream to write the report (if any) to.
   * Defaults to `process.stderr`.
   */
  streamError?: NodeJS.WritableStream | undefined
  /**
   * Whether to write the processed file to `streamOut`
   */
  out?: boolean | undefined
  /**
   * Whether to write successfully processed files, and where to.
   *
   * * When `true`, overwrites the given files
   * * When `false`, does not write to the file system
   * * When pointing to an existing directory, files are written to that
   * directory and keep their original basenames
   * * When the parent directory of the given path exists and one file is
   * processed, the file is written to the given path
   */
  output?: string | boolean | undefined
  /**
   * Whether to always serialize successfully processed files.
   */
  alwaysStringify?: boolean | undefined
  /**
   * Whether to treat both input and output as a syntax tree.
   */
  tree?: boolean | undefined
  /**
   * Whether to treat input as a syntax tree.
   * Defaults to `options.tree`.
   */
  treeIn?: boolean | undefined
  /**
   * Whether to treat output as a syntax tree.
   * Defaults to `options.tree`.
   */
  treeOut?: boolean | undefined
  /**
   * Whether to output a formatted syntax tree.
   */
  inspect?: boolean | undefined
  /**
   * Name of configuration files to load.
   */
  rcName?: string | undefined
  /**
   * Property at which configuration can be found in `package.json` files
   */
  packageField?: string | undefined
  /**
   * Whether to search for configuration files.
   * Defaults to `true` if `rcName` or `packageField` are given
   */
  detectConfig?: boolean | undefined
  /**
   * Filepath to a configuration file to load.
   */
  rcPath?: string | undefined
  /**
   * Configuration for the parser and compiler of the processor.
   */
  settings?: Preset['settings']
  /**
   * Name of ignore files to load.
   */
  ignoreName?: string | undefined
  /**
   * Whether to search for ignore files.
   * Defaults to `true` if `ignoreName` is given.
   */
  detectIgnore?: boolean | undefined
  /**
   * Filepath to an ignore file to load.
   */
  ignorePath?: string | undefined
  /**
   * Resolve patterns in `ignorePath` from the current working
   * directory (`'cwd'`) or the ignore file’s directory (`'dir'`, default).
   */
  ignorePathResolveFrom?: import('./ignore.js').ResolveFrom | undefined
  /**
   * Patterns to ignore in addition to ignore files
   */
  ignorePatterns?: string[] | undefined
  /**
   * Ignore files that do not have an associated detected configuration file.
   */
  ignoreUnconfigured?: boolean | undefined
  /**
   * Skip given files if they are ignored.
   */
  silentlyIgnore?: boolean | undefined
  /**
   * Plugins to use.
   */
  plugins?: Preset['plugins']
  /**
   * Prefix to use when searching for plugins
   */
  pluginPrefix?: string | undefined
  /**
   * Transform config files from a different schema.
   */
  configTransform?: import('./configuration.js').ConfigTransform | undefined
  /**
   * Default configuration to use if no config file is given or found.
   */
  defaultConfig?: import('./configuration.js').Preset | undefined
  /**
   * Reporter to use
   * Defaults to `vfile-reporter`
   */
  reporter?: string | VFileReporter | undefined
  /**
   * Config to pass to the used reporter.
   */
  reporterOptions?: VFileReporterOptions | undefined
  /**
   * Whether to report with ANSI color sequences.
   */
  color?: VFileReporterOptions['color']
  /**
   * Report only fatal errors
   */
  silent?: VFileReporterOptions['silent']
  /**
   * Do not report successful files
   */
  quiet?: VFileReporterOptions['quiet']
  /**
   * Call back with an unsuccessful (`1`) code on warnings as well as errors
   */
  frail?: boolean | undefined
}
/**
 * Processing context.
 */
export type Context = {
  /**
   * Processed files.
   */
  files?: import('vfile').VFile[] | undefined
  /**
   * Internally used information
   */
  fileSet?: import('./file-set.js').FileSet | undefined
}
/**
 * Callback called when processing according to options is complete.
 * Invoked with either a fatal error if processing went horribly wrong
 * (probably due to incorrect configuration), or a status code and the
 * processing context.
 */
export type Callback = (
  error: Error | null,
  status?: 0 | 1 | undefined,
  context?: Context | undefined
) => void
