/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context.state;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContext;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchContextEvent;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchState;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchStateMachineClosedException;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchTransition;
import org.opensearch.search.asynchronous.context.state.StateMachine;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchContextEventListener;

public class AsynchronousSearchStateMachine
implements StateMachine<AsynchronousSearchState, AsynchronousSearchContextEvent> {
    private static final Logger logger = LogManager.getLogger(AsynchronousSearchStateMachine.class);
    private final Map<String, AsynchronousSearchTransition<? extends AsynchronousSearchContextEvent>> transitionsMap = new HashMap<String, AsynchronousSearchTransition<? extends AsynchronousSearchContextEvent>>();
    private final AsynchronousSearchState initialState;
    private Set<AsynchronousSearchState> finalStates;
    private final Set<AsynchronousSearchState> states;
    private final AsynchronousSearchContextEventListener asynchronousSearchContextEventListener;

    public AsynchronousSearchStateMachine(Set<AsynchronousSearchState> states, AsynchronousSearchState initialState, AsynchronousSearchContextEventListener asynchronousSearchContextEventListener) {
        this.states = states;
        this.initialState = initialState;
        this.finalStates = new HashSet<AsynchronousSearchState>();
        this.asynchronousSearchContextEventListener = asynchronousSearchContextEventListener;
    }

    public void markTerminalStates(Set<AsynchronousSearchState> finalStates) {
        this.finalStates = finalStates;
    }

    @Override
    public AsynchronousSearchState getInitialState() {
        return this.initialState;
    }

    @Override
    public Set<AsynchronousSearchState> getFinalStates() {
        return this.finalStates;
    }

    @Override
    public Set<AsynchronousSearchState> getStates() {
        return this.states;
    }

    @Override
    public Map<String, AsynchronousSearchTransition<? extends AsynchronousSearchContextEvent>> getTransitions() {
        return this.transitionsMap;
    }

    public void registerTransition(AsynchronousSearchTransition<? extends AsynchronousSearchContextEvent> transition) {
        this.transitionsMap.put(this.getTransitionId(transition), transition);
    }

    @Override
    public AsynchronousSearchState trigger(AsynchronousSearchContextEvent event) throws AsynchronousSearchStateMachineClosedException {
        AsynchronousSearchContext asynchronousSearchContext;
        AsynchronousSearchContext asynchronousSearchContext2 = asynchronousSearchContext = event.asynchronousSearchContext();
        synchronized (asynchronousSearchContext2) {
            AsynchronousSearchState currentState = asynchronousSearchContext.getAsynchronousSearchState();
            if (this.getFinalStates().contains((Object)currentState)) {
                throw new AsynchronousSearchStateMachineClosedException(currentState, event);
            }
            String transitionId = this.getTransitionId(currentState, event.getClass());
            if (this.transitionsMap.containsKey(transitionId)) {
                AsynchronousSearchTransition<? extends AsynchronousSearchContextEvent> transition = this.transitionsMap.get(transitionId);
                this.execute(transition.onEvent(), event, currentState);
                asynchronousSearchContext.setState(transition.targetState());
                logger.debug("Executed event [{}] for asynchronous search id [{}] ", (Object)event.getClass().getName(), (Object)event.asynchronousSearchContext.getAsynchronousSearchId());
                BiConsumer<AsynchronousSearchContextId, AsynchronousSearchContextEventListener> eventListener = transition.eventListener();
                try {
                    eventListener.accept(event.asynchronousSearchContext().getContextId(), this.asynchronousSearchContextEventListener);
                }
                catch (Exception ex) {
                    logger.error(() -> new ParameterizedMessage("Failed to execute listener for asynchronous search id : [{}]", (Object)event.asynchronousSearchContext.getAsynchronousSearchId()), (Throwable)ex);
                }
                return asynchronousSearchContext.getAsynchronousSearchState();
            }
            String message = String.format(Locale.ROOT, "Invalid transition for asynchronous search context [%s] from source state [%s] on event [%s]", new Object[]{asynchronousSearchContext.getAsynchronousSearchId(), currentState, event.getClass().getName()});
            logger.error(message);
            throw new IllegalStateException(message);
        }
    }

    private <T> void execute(BiConsumer<AsynchronousSearchState, T> onEvent, AsynchronousSearchContextEvent event, AsynchronousSearchState state) {
        onEvent.accept(state, (AsynchronousSearchState)((Object)event));
    }

    public String getTransitionId(AsynchronousSearchTransition<? extends AsynchronousSearchContextEvent> transition) {
        return this.getTransitionId(transition.sourceState(), transition.eventType());
    }

    private String getTransitionId(AsynchronousSearchState sourceState, Class<?> eventType) {
        return sourceState + "_" + eventType;
    }
}

