/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.dispatcher.model;

import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class FullyQualifiedTableName {
    private String datasourceName;
    private String schemaName;
    private String tableName;
    private String fullyQualifiedName;

    public FullyQualifiedTableName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
        String[] parts = fullyQualifiedName.split("\\.");
        if (parts.length >= 3) {
            this.datasourceName = parts[0];
            this.schemaName = parts[1];
            this.tableName = String.join((CharSequence)".", Arrays.copyOfRange(parts, 2, parts.length));
        } else if (parts.length == 2) {
            this.schemaName = parts[0];
            this.tableName = parts[1];
        } else if (parts.length == 1) {
            this.tableName = parts[0];
        }
    }

    public String toFlintName() {
        StringBuilder builder = new StringBuilder();
        if (this.datasourceName != null) {
            builder.append(StringUtils.strip((String)this.datasourceName, (String)"`")).append("_");
        }
        if (this.schemaName != null) {
            builder.append(StringUtils.strip((String)this.schemaName, (String)"`")).append("_");
        }
        if (this.tableName != null) {
            builder.append(StringUtils.strip((String)this.tableName, (String)"`"));
        }
        return builder.toString();
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Generated
    public void setDatasourceName(String datasourceName) {
        this.datasourceName = datasourceName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FullyQualifiedTableName)) {
            return false;
        }
        FullyQualifiedTableName other = (FullyQualifiedTableName)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$datasourceName = this.getDatasourceName();
        String other$datasourceName = other.getDatasourceName();
        if (this$datasourceName == null ? other$datasourceName != null : !this$datasourceName.equals(other$datasourceName)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$fullyQualifiedName = this.getFullyQualifiedName();
        String other$fullyQualifiedName = other.getFullyQualifiedName();
        return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FullyQualifiedTableName;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $datasourceName = this.getDatasourceName();
        result = result * 59 + ($datasourceName == null ? 43 : $datasourceName.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $fullyQualifiedName = this.getFullyQualifiedName();
        result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FullyQualifiedTableName(datasourceName=" + this.getDatasourceName() + ", schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", fullyQualifiedName=" + this.getFullyQualifiedName() + ")";
    }

    @Generated
    public FullyQualifiedTableName() {
    }
}

