/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public final class FileFilterExtensions
extends FileFilter {
    private String[] m_extensions;
    private boolean m_isWindows = false;

    public FileFilterExtensions(String[] extensionsWithoutDot) throws IllegalArgumentException {
        this.verify(extensionsWithoutDot);
        this.m_extensions = new String[extensionsWithoutDot.length];
        System.arraycopy(extensionsWithoutDot, 0, this.m_extensions, 0, extensionsWithoutDot.length);
        this.m_isWindows = this.isWindows();
    }

    public boolean accept(File pathname) {
        boolean result = pathname.isDirectory() ? true : this.acceptNoDirectory(pathname.getAbsolutePath());
        return result;
    }

    private boolean acceptNoDirectory(String noDirFileNoURL) {
        boolean ret = false;
        StringTokenizer tokenizer = new StringTokenizer(noDirFileNoURL, ".");
        String extension = "no.txt";
        while (tokenizer.hasMoreElements()) {
            extension = tokenizer.nextToken();
        }
        for (int i = this.m_extensions.length - 1; i >= 0; --i) {
            if (!this.m_extensions[i].equals(extension)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public String getDescription() {
        StringBuffer ret = new StringBuffer();
        int len = this.m_extensions.length;
        for (int i = 0; i < len; ++i) {
            ret.append("*.").append(this.m_extensions[i]);
            if (i >= len - 1) continue;
            ret.append(",");
        }
        return ret.toString();
    }

    private boolean isDirectory(String urlstring) {
        boolean ret = false;
        boolean isURL = false;
        try {
            new URL(urlstring);
            isURL = true;
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        int lastDot = urlstring.lastIndexOf(46);
        int lastSeparator = isURL ? urlstring.lastIndexOf(47) : (this.m_isWindows ? urlstring.lastIndexOf(92) : urlstring.lastIndexOf(47));
        ret = lastSeparator == -1 ? lastDot == -1 : (lastDot == -1 ? true : lastDot <= lastSeparator + 1);
        return ret;
    }

    private boolean isWindows() {
        boolean ret = false;
        File[] roots = FileSystemView.getFileSystemView().getRoots();
        for (int i = 0; i < roots.length; ++i) {
            if (roots[i].getAbsolutePath().indexOf(58) == -1) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void verify(String[] extensions) throws IllegalArgumentException {
        StringBuffer msg = new StringBuffer();
        for (int i = extensions.length - 1; i >= 0; --i) {
            String current = extensions[i];
            if (current == null) {
                msg.append("Extension at index " + i + " is null!\n");
                continue;
            }
            if (current.indexOf(46) == -1) continue;
            msg.append("Extension \"" + current + "\" contains a dot!\n");
        }
        if (msg.length() > 0) {
            throw new IllegalArgumentException(msg.toString());
        }
    }
}

