complete -c gix -n "__fish_use_subcommand" -s r -l repository -d 'The repository to access' -r -F
complete -c gix -n "__fish_use_subcommand" -s c -l config -d 'Add these values to the configuration in the form of `key=value` or `key`' -r
complete -c gix -n "__fish_use_subcommand" -s t -l threads -d 'The amount of threads to use for some operations' -r
complete -c gix -n "__fish_use_subcommand" -s f -l format -d 'Determine the format to use when outputting statistics' -r -f -a "{human	'',json	''}"
complete -c gix -n "__fish_use_subcommand" -l object-hash -d 'The object format to assume when reading files that don\'t inherently know about it, or when writing files' -r -f -a "{SHA1	''}"
complete -c gix -n "__fish_use_subcommand" -s v -l verbose -d 'Display verbose messages and progress information'
complete -c gix -n "__fish_use_subcommand" -l trace -d 'Display structured `tracing` output in a tree-like structure'
complete -c gix -n "__fish_use_subcommand" -l no-verbose -d 'Turn off verbose message display for commands where these are shown by default'
complete -c gix -n "__fish_use_subcommand" -l progress -d 'Bring up a terminal user interface displaying progress visually'
complete -c gix -n "__fish_use_subcommand" -s s -l strict -d 'Don\'t default malformed configuration flags, but show an error instead. Ignore IO errors as well'
complete -c gix -n "__fish_use_subcommand" -l progress-keep-open -d 'The progress TUI will stay up even though the work is already completed'
complete -c gix -n "__fish_use_subcommand" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c gix -n "__fish_use_subcommand" -f -a "archive" -d 'Subcommands for creating worktree archives'
complete -c gix -n "__fish_use_subcommand" -f -a "clean"
complete -c gix -n "__fish_use_subcommand" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_use_subcommand" -f -a "odb" -d 'Interact with the object database'
complete -c gix -n "__fish_use_subcommand" -f -a "fsck" -d 'Check for missing objects'
complete -c gix -n "__fish_use_subcommand" -f -a "tree" -d 'Interact with tree objects'
complete -c gix -n "__fish_use_subcommand" -f -a "commit" -d 'Interact with commit objects'
complete -c gix -n "__fish_use_subcommand" -f -a "verify" -d 'Verify the integrity of the entire repository'
complete -c gix -n "__fish_use_subcommand" -f -a "revision" -d 'Query and obtain information about revisions'
complete -c gix -n "__fish_use_subcommand" -f -a "credential" -d 'A program just like `git credential`'
complete -c gix -n "__fish_use_subcommand" -f -a "fetch" -d 'Fetch data from remotes and store it in the repository'
complete -c gix -n "__fish_use_subcommand" -f -a "clone"
complete -c gix -n "__fish_use_subcommand" -f -a "mailmap" -d 'Interact with the mailmap'
complete -c gix -n "__fish_use_subcommand" -f -a "remote" -d 'Interact with the remote hosts'
complete -c gix -n "__fish_use_subcommand" -f -a "attributes" -d 'Interact with the attribute files like .gitattributes'
complete -c gix -n "__fish_use_subcommand" -f -a "exclude" -d 'Interact with the exclude files like .gitignore'
complete -c gix -n "__fish_use_subcommand" -f -a "index"
complete -c gix -n "__fish_use_subcommand" -f -a "submodule" -d 'Interact with submodules'
complete -c gix -n "__fish_use_subcommand" -f -a "is-clean"
complete -c gix -n "__fish_use_subcommand" -f -a "is-changed"
complete -c gix -n "__fish_use_subcommand" -f -a "config-tree" -d 'Show which git configuration values are used or planned'
complete -c gix -n "__fish_use_subcommand" -f -a "status" -d 'compute repository status similar to `git status`'
complete -c gix -n "__fish_use_subcommand" -f -a "config" -d 'Print all entries in a configuration file or access other sub-commands'
complete -c gix -n "__fish_use_subcommand" -f -a "corpus" -d 'run algorithms on a corpus of git repositories and store their results for later analysis'
complete -c gix -n "__fish_use_subcommand" -f -a "free" -d 'Subcommands that need no git repository to run'
complete -c gix -n "__fish_use_subcommand" -f -a "completions" -d 'Generate shell completions to stdout or a directory'
complete -c gix -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from archive" -s f -l format -d 'Explicitly set the format. Otherwise derived from the suffix of the output file' -r -f -a "{internal	'An internal format that is for debugging, it should not be persisted and cannot be read back',tar	'Use the `.tar` file format, uncompressed',tar-gz	'Use the `.tar.gz` file format, compressed with `gzip`',zip	'Use the `.zip` container format'}"
complete -c gix -n "__fish_seen_subcommand_from archive" -l prefix -d 'Apply the prefix verbatim to any path we add to the archive. Use a trailing `/` if prefix is a directory' -r
complete -c gix -n "__fish_seen_subcommand_from archive" -s l -l compression-level -d 'The compression strength to use for `.zip` and `.tar.gz` archives, valid from 0-9' -r
complete -c gix -n "__fish_seen_subcommand_from archive" -s p -l add-path -d 'Add the given path to the archive. Directories will always be empty' -r -F
complete -c gix -n "__fish_seen_subcommand_from archive" -s v -l add-virtual-file -d 'Add the new file from a slash-separated path, which must happen in pairs of two, first the path, then the content' -r
complete -c gix -n "__fish_seen_subcommand_from archive" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from clean" -l skip-hidden-repositories -d 'Enter ignored directories to skip repositories contained within' -r -f -a "{all	'',non-bare	''}"
complete -c gix -n "__fish_seen_subcommand_from clean" -l find-untracked-repositories -d 'What kind of repositories to find inside of untracked directories' -r -f -a "{all	'',non-bare	''}"
complete -c gix -n "__fish_seen_subcommand_from clean" -l debug -d 'Print additional debug information to help understand decisions it made'
complete -c gix -n "__fish_seen_subcommand_from clean" -s n -l dry-run -d 'A dummy to easy with muscle-memory. This flag is assumed if provided or not, and has no effect'
complete -c gix -n "__fish_seen_subcommand_from clean" -s e -l execute -d 'Actually perform the operation, which deletes files on disk without chance of recovery'
complete -c gix -n "__fish_seen_subcommand_from clean" -s x -l ignored -d 'Remove ignored (and expendable) files'
complete -c gix -n "__fish_seen_subcommand_from clean" -s p -l precious -d 'Remove precious files'
complete -c gix -n "__fish_seen_subcommand_from clean" -s d -l directories -d 'Remove whole directories'
complete -c gix -n "__fish_seen_subcommand_from clean" -s r -l repositories -d 'Remove nested repositories'
complete -c gix -n "__fish_seen_subcommand_from clean" -s m -l pathspec-matches-result -d 'Pathspec patterns are used to match the result of the dirwalk, not the dirwalk itself'
complete -c gix -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all entries in the commit-graph as reachable by starting from `HEAD`'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from verify" -s s -l statistics -d 'output statistical information about the pack'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all entries in the commit-graph as reachable by starting from `HEAD`'
complete -c gix -n "__fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all object names'
complete -c gix -n "__fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Provide general information about the object database'
complete -c gix -n "__fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "stats" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from stats" -l extra-header-lookup -d 'Lookup headers again, but without preloading indices'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from stats" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all object names'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Provide general information about the object database'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "stats" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_seen_subcommand_from odb; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from fsck" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print entries in a given tree'
complete -c gix -n "__fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Provide information about a tree'
complete -c gix -n "__fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from entries" -s r -l recursive -d 'Traverse the entire tree and its subtrees respectively, not only this tree'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from entries" -s e -l extended -d 'Provide files size as well. This is expensive as the object is decoded entirely'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from info" -s e -l extended -d 'Provide files size as well. This is expensive as the object is decoded entirely'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print entries in a given tree'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Provide information about a tree'
complete -c gix -n "__fish_seen_subcommand_from tree; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the signature of a commit'
complete -c gix -n "__fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -f -a "describe" -d 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
complete -c gix -n "__fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s c -l max-candidates -d 'Consider only the given `n` candidates. This can take longer, but potentially produces more accurate results' -r
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s d -l dirty-suffix -d 'Set the suffix to append if the repository is dirty (not counting untracked files)' -r
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s t -l annotated-tags -d 'Use annotated tag references only, not all tags'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s a -l all-refs -d 'Use all references under the `ref/` namespaces, which includes tag references, local and remote branches'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s f -l first-parent -d 'Only follow the first parent when traversing the commit graph'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s l -l long -d 'Always display the long format, even if that would not be necessary as the id is located directly on a reference'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s s -l statistics -d 'Print information on stderr to inform about performance statistics'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -l always -d 'If there was no way to describe the commit, fallback to using the abbreviated input revision'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from describe" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the signature of a commit'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -f -a "describe" -d 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
complete -c gix -n "__fish_seen_subcommand_from commit; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from verify" -s a -l algorithm -d 'The algorithm used to verify packs. They differ in costs' -r -f -a "{less-time	'',less-memory	''}"
complete -c gix -n "__fish_seen_subcommand_from verify" -s s -l statistics -d 'output statistical information'
complete -c gix -n "__fish_seen_subcommand_from verify" -l decode -d 'Decode and parse tags, commits and trees to validate their correctness beyond hashing correctly'
complete -c gix -n "__fish_seen_subcommand_from verify" -l re-encode -d 'Decode and parse tags, commits and trees to validate their correctness, and re-encode them'
complete -c gix -n "__fish_seen_subcommand_from verify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from list" -s l -l limit -d 'How many commits to list at most' -r
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from list" -s s -l svg -d 'Write the graph as SVG file to the given path' -r -F
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from explain" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from resolve" -s b -l blob-format -d 'How to display blobs' -r -f -a "{git	'The version stored in the Git Object Database',worktree	'The version that would be checked out into the worktree, including filters',diff	'The version that would be diffed (Worktree + Text-Conversion)',diff-or-git	'The version that would be diffed if there is a text-conversion, or the one stored in Git otherwise'}"
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from resolve" -s t -l tree-mode -d 'How to display trees as obtained with `@:dirname` or `@^{tree}`' -r -f -a "{raw	'Show the raw bytes - only useful for piping into files for use with tooling',pretty	'Display a tree in human-readable form'}"
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from resolve" -s e -l explain -d 'Instead of resolving a rev-spec, explain what would be done for the first spec'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from resolve" -s r -l reference -d 'Also show the name of the reference which led to the object'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from resolve" -s c -l cat-file -d 'Show the first resulting object similar to how `git cat-file` would, but don\'t show the resolved spec'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from resolve" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from previous-branches" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_seen_subcommand_from revision; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "fill" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "approve" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "reject" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from fill" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from approve" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from reject" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "fill" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "approve" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "reject" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_seen_subcommand_from credential; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from fetch" -s g -l open-negotiation-graph -d 'Open the commit graph used for negotiation and write an SVG file to PATH' -r -F
complete -c gix -n "__fish_seen_subcommand_from fetch" -l depth -d 'Fetch with the history truncated to the given number of commits as seen from the remote' -r
complete -c gix -n "__fish_seen_subcommand_from fetch" -l deepen -d 'Extend the current shallow boundary by the given amount of commits, with 0 meaning no change' -r
complete -c gix -n "__fish_seen_subcommand_from fetch" -l shallow-since -d 'Cutoff all history past the given date. Can be combined with shallow-exclude' -r
complete -c gix -n "__fish_seen_subcommand_from fetch" -l shallow-exclude -d 'Cutoff all history past the tag-name or ref-name. Can be combined with shallow-since' -r
complete -c gix -n "__fish_seen_subcommand_from fetch" -s r -l remote -d 'The name of the remote to connect to, or the url of the remote to connect to directly' -r
complete -c gix -n "__fish_seen_subcommand_from fetch" -s n -l dry-run -d 'Don\'t change the local repository, but otherwise try to be as accurate as possible'
complete -c gix -n "__fish_seen_subcommand_from fetch" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_seen_subcommand_from fetch" -s s -l negotiation-info -d 'Print statistics about negotiation phase'
complete -c gix -n "__fish_seen_subcommand_from fetch" -l unshallow -d 'Remove the shallow boundary and fetch the entire history available on the remote'
complete -c gix -n "__fish_seen_subcommand_from fetch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from clone" -l depth -d 'Create a shallow clone with the history truncated to the given number of commits' -r
complete -c gix -n "__fish_seen_subcommand_from clone" -l shallow-since -d 'Cutoff all history past the given date. Can be combined with shallow-exclude' -r
complete -c gix -n "__fish_seen_subcommand_from clone" -l shallow-exclude -d 'Cutoff all history past the tag-name or ref-name. Can be combined with shallow-since' -r
complete -c gix -n "__fish_seen_subcommand_from clone" -l ref -d 'The name of the reference to check out' -r
complete -c gix -n "__fish_seen_subcommand_from clone" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_seen_subcommand_from clone" -l bare -d 'The clone will be bare and a working tree checkout won\'t be available'
complete -c gix -n "__fish_seen_subcommand_from clone" -l no-tags -d 'Do not clone any tags. Useful to reduce the size of the clone if only branches are needed'
complete -c gix -n "__fish_seen_subcommand_from clone" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all entries in configured mailmaps, inform about errors as well'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -f -a "check" -d 'Print the canonical form of contacts according to the configured mailmaps'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from check" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all entries in configured mailmaps, inform about errors as well'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -f -a "check" -d 'Print the canonical form of contacts according to the configured mailmaps'
complete -c gix -n "__fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -s n -l name -d 'The name of the remote to connect to, or the URL of the remote to connect to directly' -r
complete -c gix -n "__fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -s H -l handshake-info -d 'Output additional typically information provided by the server as part of the connection handshake'
complete -c gix -n "__fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from remote; and __fish_seen_subcommand_from refs" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from remote; and __fish_seen_subcommand_from ref-map" -s u -l show-unmapped-remote-refs -d 'Also display remote references that were sent by the server, but filtered by the refspec locally'
complete -c gix -n "__fish_seen_subcommand_from remote; and __fish_seen_subcommand_from ref-map" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from remote; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_seen_subcommand_from remote; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_seen_subcommand_from remote; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from validate-baseline" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from validate-baseline" -l no-ignore -d 'Don\'t validated excludes as obtaining them with `check-ignore` can be very slow'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from validate-baseline" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from query" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_seen_subcommand_from attributes; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "query" -d 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
complete -c gix -n "__fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from exclude; and __fish_seen_subcommand_from query" -s p -l patterns -d 'Additional patterns to use for exclusions. They have the highest priority' -r
complete -c gix -n "__fish_seen_subcommand_from exclude; and __fish_seen_subcommand_from query" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_seen_subcommand_from exclude; and __fish_seen_subcommand_from query" -s i -l show-ignore-patterns -d 'Show actual ignore patterns instead of un-excluding an entry'
complete -c gix -n "__fish_seen_subcommand_from exclude; and __fish_seen_subcommand_from query" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from exclude; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "query" -d 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
complete -c gix -n "__fish_seen_subcommand_from exclude; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from query; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all entries to standard output'
complete -c gix -n "__fish_seen_subcommand_from index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -f -a "from-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_seen_subcommand_from index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from entries" -s f -l format -d 'How to output index entries' -r -f -a "{simple	'Show only minimal information, useful for first glances',rich	'Show much more information that is still human-readable'}"
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from entries" -l no-attributes -d 'Do not visualize excluded entries or attributes per path'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from entries" -s i -l attributes-from-index -d 'Load attribute and ignore files from the index, don\'t look at the worktree'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from entries" -s r -l recurse-submodules -d 'Display submodule entries as well if their repository exists'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from entries" -s s -l statistics -d 'Print various statistics to stderr'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-tree" -s i -l index-output-path -d 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work' -r -F
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-tree" -s f -l force -d 'Overwrite the specified index file if it already exists'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-tree" -s s -l skip-hash -d 'Don\'t write the trailing hash for a performance gain'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-tree" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Print all entries to standard output'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -f -a "from-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Print all direct submodules to standard output'
complete -c gix -n "__fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from submodule; and __fish_seen_subcommand_from list" -s d -l dirty-suffix -d 'Set the suffix to append if the repository is dirty (not counting untracked files)' -r
complete -c gix -n "__fish_seen_subcommand_from submodule; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from submodule; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "list" -d 'Print all direct submodules to standard output'
complete -c gix -n "__fish_seen_subcommand_from submodule; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from is-clean" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from is-changed" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from config-tree" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from status" -s f -l format -d 'The way status data is displayed' -r -f -a "{simplified	'A basic format that is easy to read, and useful for a first glimpse as flat list',porcelain-v2	'Output very similar to `git status --porcelain=2`'}"
complete -c gix -n "__fish_seen_subcommand_from status" -l ignored -d 'If enabled, show ignored files and directories' -r -f -a "{collapsed	'display all ignored files and directories, but collapse them if possible to simplify',matching	'Show exact matches. Note that this may show directories if these are a match as well'}"
complete -c gix -n "__fish_seen_subcommand_from status" -l submodules -d 'Define how to display the submodule status. Defaults to git configuration if unset' -r -f -a "{all	'display all information about submodules, including ref changes, modifications and untracked files',ref-change	'Compare only the configuration of the superprojects commit with the actually checked out `HEAD` commit',modifications	'See if there are worktree modifications compared to the index, but do not check for untracked files',none	'Ignore all submodule changes'}"
complete -c gix -n "__fish_seen_subcommand_from status" -l index-worktree-renames -d 'Enable rename tracking between the index and the working tree, preventing the collapse of folders as well' -r
complete -c gix -n "__fish_seen_subcommand_from status" -s s -l statistics -d 'Print additional statistics to help understanding performance'
complete -c gix -n "__fish_seen_subcommand_from status" -l no-write -d 'Don\'t write back a changed index, which forces this operation to always be idempotent'
complete -c gix -n "__fish_seen_subcommand_from status" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from config" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -l db -d 'The path to the database to read and write depending on the sub-command' -r -F
complete -c gix -n "__fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -s p -l path -d 'The path to the root of the corpus to search repositories in' -r -F
complete -c gix -n "__fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -f -a "run" -d 'Perform a corpus run on all registered repositories'
complete -c gix -n "__fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -f -a "refresh" -d 'Re-read all repositories under the corpus directory, and add or update them'
complete -c gix -n "__fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from run" -s r -l repo-sql-suffix -d 'The SQL that will be appended to the actual select statement for repositories to apply additional filtering, like `LIMIT 10`' -r
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from run" -s t -l include-task -d 'The short_names of the tasks to include when running' -r
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from run" -s n -l dry-run -d 'Don\'t run any task, but print all repos that would be traversed once'
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from run" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from refresh" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -f -a "run" -d 'Perform a corpus run on all registered repositories'
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -f -a "refresh" -d 'Re-read all repositories under the corpus directory, and add or update them'
complete -c gix -n "__fish_seen_subcommand_from corpus; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from verify" -s s -l statistics -d 'output statistical information about the pack'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -s p -l path -d 'The path to the mailmap file' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Parse all entries in the mailmap and report malformed lines or collisions'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Parse all entries in the mailmap and report malformed lines or collisions'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "index" -d 'Subcommands for interacting with pack indices (.idx)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "multi-index" -d 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new pack with a set of objects'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "receive" -d 'Use the gix-protocol to receive a pack, emulating a clone'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "explode" -d 'Dissolve a pack into its loose objects'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a pack, index or multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "create" -d 'create a pack index from a pack data file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from create" -s i -l iteration-mode -d 'Specify how to iterate the pack, defaults to \'verify\'' -r -f -a "{as-is	'',verify	'',restore	''}"
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from create" -s p -l pack-path -d 'Path to the pack file to read (with .pack extension)' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "create" -d 'create a pack index from a pack data file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -s i -l multi-index-path -d 'The path to the index file' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Print general information about a multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify a multi-index quickly without inspecting objects themselves'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "create" -d 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from entries" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "entries" -d 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Print general information about a multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify a multi-index quickly without inspecting objects themselves'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "create" -d 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -s r -l repository -d 'the directory containing the \'.git\' repository from which objects should be read' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -s e -l expansion -d 'the way objects are expanded. They differ in costs' -r -f -a "{none	'',tree-traversal	'',tree-diff	''}"
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -l counting-threads -d 'The amount of threads to use when counting and the `--nondeterminisitc-count` flag is set, defaulting to the globally configured threads' -r
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -l pack-cache-size-mb -d 'The size in megabytes for a cache to speed up pack access for packs with long delta chains. It is shared among all threads, so 4 threads would use their own cache 1/4th of the size' -r
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -l object-cache-size-mb -d 'The size in megabytes for a cache to speed up accessing entire objects, bypassing object database access when hit. It is shared among all threads, so 4 threads would use their own cache 1/4th of the size' -r
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -s o -l output-directory -d 'The directory into which to write the pack file' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -l nondeterministic-count -d 'if set, the counting phase may be accelerated using multithreading'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -s s -l statistics -d 'If set statistical information will be presented to inform about pack creation details. It\'s a form of instrumentation for developers to help improve pack generation'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -l thin -d 'if set, delta-objects whose base object wouldn\'t be in the pack will not be recompressed as base object, but instead refer to its base object using its object id'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from receive" -s p -l protocol -d 'The protocol version to use. Valid values are 1 and 2' -r
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from receive" -s d -l refs-directory -d 'the directory into which to write references. Existing files will be overwritten' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from receive" -s r -l reference -d 'If set once or more times, these references will be fetched instead of all advertised ones' -r
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from receive" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from explode" -s c -l check -d 'The amount of checks to run' -r -f -a "{all	'',skip-file-checksum	'',skip-file-and-object-checksum	'',skip-file-and-object-checksum-and-no-abort-on-decode	''}"
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from explode" -l verify -d 'Read written objects back and assert they match their source. Fail the operation otherwise'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from explode" -l delete-pack -d 'delete the pack and index file after the operation is successful'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from explode" -l sink-compress -d 'Compress bytes even when using the sink, i.e. no object directory is specified'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from explode" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from verify" -s a -l algorithm -d 'The algorithm used to verify packs. They differ in costs' -r -f -a "{less-time	'',less-memory	''}"
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from verify" -s s -l statistics -d 'output statistical information'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from verify" -l decode -d 'Decode and parse tags, commits and trees to validate their correctness beyond hashing correctly'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from verify" -l re-encode -d 'Decode and parse tags, commits and trees to validate their correctness, and re-encode them'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "index" -d 'Subcommands for interacting with pack indices (.idx)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "multi-index" -d 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new pack with a set of objects'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "receive" -d 'Use the gix-protocol to receive a pack, emulating a clone'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "explode" -d 'Dissolve a pack into its loose objects'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of a pack, index or multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from create" -f -a "create" -d 'create a pack index from a pack data file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "entries" -d 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "info" -d 'Print general information about a multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "verify" -d 'Verify a multi-index quickly without inspecting objects themselves'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "create" -d 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -l object-hash -d 'The object format to assume when reading files that don\'t inherently know about it, or when writing files' -r -f -a "{SHA1	''}"
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -s i -l index-path -d 'The path to the index file' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "from-list" -d 'Create an index from a list of empty files, one per line of the input'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Validate constraints and assumptions of an index along with its integrity'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Print information about the index structure'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "checkout-exclusive" -d 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-list" -s i -l index-output-path -d 'Path to the index file to be written. If none is given it will be kept in memory only as a way to measure performance. One day we will probably write the index back by default, but that requires us to write more of the index to work' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-list" -s f -l force -d 'Overwrite the specified index file if it already exists'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-list" -s s -l skip-hash -d 'Don\'t write the trailing hash for a performance gain'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from from-list" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from verify" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from info" -l no-details -d 'Do not extract specific extension information to gain only a superficial idea of the index\'s composition'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from checkout-exclusive" -s r -l repository -d 'The path to `.git` repository from which objects can be obtained to write the actual files referenced in the index. Use this measure the impact on extracting objects on overall performance' -r -F
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from checkout-exclusive" -s k -l keep-going -d 'Ignore errors and keep checking out as many files as possible, and report all errors at the end of the operation'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from checkout-exclusive" -s e -l empty-files -d 'Enable to query the object database yet write only empty files. This is useful to measure the overhead of ODB query compared to writing the bytes to disk'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from checkout-exclusive" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "from-list" -d 'Create an index from a list of empty files, one per line of the input'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Validate constraints and assumptions of an index along with its integrity'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "info" -d 'Print information about the index structure'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "checkout-exclusive" -d 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from discover" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from verify" -f -a "verify" -d 'Parse all entries in the mailmap and report malformed lines or collisions'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "index" -d 'Subcommands for interacting with pack indices (.idx)'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "multi-index" -d 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "create" -d 'Create a new pack with a set of objects'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "receive" -d 'Use the gix-protocol to receive a pack, emulating a clone'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "explode" -d 'Dissolve a pack into its loose objects'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "verify" -d 'Verify the integrity of a pack, index or multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from create" -f -a "create" -d 'create a pack index from a pack data file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "entries" -d 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "info" -d 'Print general information about a multi-index file'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "verify" -d 'Verify a multi-index quickly without inspecting objects themselves'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "create" -d 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "from-list" -d 'Create an index from a list of empty files, one per line of the input'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "verify" -d 'Validate constraints and assumptions of an index along with its integrity'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "info" -d 'Print information about the index structure'
complete -c gix -n "__fish_seen_subcommand_from free; and __fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "checkout-exclusive" -d 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
complete -c gix -n "__fish_seen_subcommand_from completions" -s s -l shell -d 'The shell to generate completions for. Otherwise it\'s derived from the environment' -r -f -a "{bash	'',elvish	'',fish	'',powershell	'',zsh	''}"
complete -c gix -n "__fish_seen_subcommand_from completions" -s h -l help -d 'Print help'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "archive" -d 'Subcommands for creating worktree archives'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "clean"
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "odb" -d 'Interact with the object database'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "fsck" -d 'Check for missing objects'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "tree" -d 'Interact with tree objects'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "commit" -d 'Interact with commit objects'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "verify" -d 'Verify the integrity of the entire repository'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "revision" -d 'Query and obtain information about revisions'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "credential" -d 'A program just like `git credential`'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "fetch" -d 'Fetch data from remotes and store it in the repository'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "clone"
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "mailmap" -d 'Interact with the mailmap'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "remote" -d 'Interact with the remote hosts'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "attributes" -d 'Interact with the attribute files like .gitattributes'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "exclude" -d 'Interact with the exclude files like .gitignore'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "index"
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "submodule" -d 'Interact with submodules'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "is-clean"
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "is-changed"
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "config-tree" -d 'Show which git configuration values are used or planned'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "status" -d 'compute repository status similar to `git status`'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "config" -d 'Print all entries in a configuration file or access other sub-commands'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "corpus" -d 'run algorithms on a corpus of git repositories and store their results for later analysis'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "free" -d 'Subcommands that need no git repository to run'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "completions" -d 'Generate shell completions to stdout or a directory'
complete -c gix -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from archive; and not __fish_seen_subcommand_from clean; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from fsck; and not __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fetch; and not __fish_seen_subcommand_from clone; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from is-clean; and not __fish_seen_subcommand_from is-changed; and not __fish_seen_subcommand_from config-tree; and not __fish_seen_subcommand_from status; and not __fish_seen_subcommand_from config; and not __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from list" -f -a "list" -d 'List all entries in the commit-graph as reachable by starting from `HEAD`'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats" -f -a "entries" -d 'Print all object names'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats" -f -a "info" -d 'Provide general information about the object database'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from odb; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from stats" -f -a "stats" -d 'Count and obtain information on all, possibly duplicate, objects in the database'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info" -f -a "entries" -d 'Print entries in a given tree'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from tree; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info" -f -a "info" -d 'Provide information about a tree'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe" -f -a "verify" -d 'Verify the signature of a commit'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from commit; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from describe" -f -a "describe" -d 'Describe the current commit or the given one using the name of the closest annotated tag in its ancestry'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches" -f -a "list" -d 'List all commits reachable from the given rev-spec'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches" -f -a "explain" -d 'Provide the revision specification like `@~1` to explain'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches" -f -a "resolve" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from revision; and not __fish_seen_subcommand_from list; and not __fish_seen_subcommand_from explain; and not __fish_seen_subcommand_from resolve; and not __fish_seen_subcommand_from previous-branches" -f -a "previous-branches" -d 'Return the names and hashes of all previously checked-out branches'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject" -f -a "fill" -d 'Get the credentials fed for `url=<url>` via STDIN'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject" -f -a "approve" -d 'Approve the information piped via STDIN as obtained with last call to `fill`'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from credential; and not __fish_seen_subcommand_from fill; and not __fish_seen_subcommand_from approve; and not __fish_seen_subcommand_from reject" -f -a "reject" -d 'Try to resolve the given revspec and print the object names'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check" -f -a "entries" -d 'Print all entries in configured mailmaps, inform about errors as well'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from check" -f -a "check" -d 'Print the canonical form of contacts according to the configured mailmaps'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map" -f -a "refs" -d 'Print all references available on the remote'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from remote; and not __fish_seen_subcommand_from refs; and not __fish_seen_subcommand_from ref-map" -f -a "ref-map" -d 'Print all references available on the remote as filtered through ref-specs'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query" -f -a "validate-baseline" -d 'Run `git check-attr`  and `git check-ignore` on all files of the index or all files passed via stdin and validate that we get the same outcome when computing attributes'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from attributes; and not __fish_seen_subcommand_from validate-baseline; and not __fish_seen_subcommand_from query" -f -a "query" -d 'List all attributes of the given path-specs and display the result similar to `git check-attr`'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from exclude; and not __fish_seen_subcommand_from query" -f -a "query" -d 'Check if path-specs are excluded and print the result similar to `git check-ignore`'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree" -f -a "entries" -d 'Print all entries to standard output'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from from-tree" -f -a "from-tree" -d 'Create an index from a tree-ish'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from submodule; and not __fish_seen_subcommand_from list" -f -a "list" -d 'Print all direct submodules to standard output'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh" -f -a "run" -d 'Perform a corpus run on all registered repositories'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from corpus; and not __fish_seen_subcommand_from run; and not __fish_seen_subcommand_from refresh" -f -a "refresh" -d 'Re-read all repositories under the corpus directory, and add or update them'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover" -f -a "commit-graph" -d 'Subcommands for interacting with commit-graphs'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover" -f -a "mailmap" -d 'Subcommands for interacting with mailmaps'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover" -f -a "pack" -d 'Subcommands for interacting with pack files and indices'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover" -f -a "index" -d 'Subcommands for interacting with a worktree index, typically at .git/index'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and not __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from discover" -f -a "discover" -d 'Show information about repository discovery and when opening a repository at the current path'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from commit-graph; and not __fish_seen_subcommand_from verify" -f -a "verify" -d 'Verify the integrity of a commit graph'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from mailmap; and not __fish_seen_subcommand_from verify" -f -a "verify" -d 'Parse all entries in the mailmap and report malformed lines or collisions'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "index" -d 'Subcommands for interacting with pack indices (.idx)'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "multi-index" -d 'Subcommands for interacting with multi-pack indices (named "multi-pack-index")'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "create" -d 'Create a new pack with a set of objects'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "receive" -d 'Use the gix-protocol to receive a pack, emulating a clone'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "explode" -d 'Dissolve a pack into its loose objects'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and not __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from create; and not __fish_seen_subcommand_from receive; and not __fish_seen_subcommand_from explode; and not __fish_seen_subcommand_from verify" -f -a "verify" -d 'Verify the integrity of a pack, index or multi-index file'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from create" -f -a "create" -d 'create a pack index from a pack data file'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "entries" -d 'Display all entries of a multi-index as: *oid* *pack-id* *pack-offset*'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "info" -d 'Print general information about a multi-index file'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "verify" -d 'Verify a multi-index quickly without inspecting objects themselves'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from pack; and __fish_seen_subcommand_from multi-index; and not __fish_seen_subcommand_from entries; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from create" -f -a "create" -d 'Create a multi-pack index from one or more pack index files, overwriting possibly existing files'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "from-list" -d 'Create an index from a list of empty files, one per line of the input'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "verify" -d 'Validate constraints and assumptions of an index along with its integrity'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "info" -d 'Print information about the index structure'
complete -c gix -n "__fish_seen_subcommand_from help; and __fish_seen_subcommand_from free; and __fish_seen_subcommand_from index; and not __fish_seen_subcommand_from from-list; and not __fish_seen_subcommand_from verify; and not __fish_seen_subcommand_from info; and not __fish_seen_subcommand_from checkout-exclusive" -f -a "checkout-exclusive" -d 'Checkout the index into a directory with exclusive write access, similar to what would happen during clone'
