/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.presentation.java;

import com.intellij.core.JavaPsiBundle;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import com.intellij.ui.NewUiValue;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClassPresentationProvider
implements ItemPresentationProvider<PsiClass> {
    @Override
    public ItemPresentation getPresentation(final @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ClassPresentationProvider.$$$reportNull$$$0(0);
        }
        return new ColoredItemPresentation(){

            public String getPresentableText() {
                return ClassPresentationUtil.getNameForClass(psiClass, false);
            }

            @Override
            public String getLocationString() {
                PsiFile file2 = psiClass.getContainingFile();
                if (file2 instanceof PsiClassOwner) {
                    PsiClassOwner classOwner = (PsiClassOwner)file2;
                    String packageName2 = classOwner.getPackageName();
                    if (packageName2.isEmpty()) {
                        return null;
                    }
                    return NewUiValue.isEnabled() ? JavaPsiBundle.message("aux.context.display", packageName2) : "(" + packageName2 + ")";
                }
                return null;
            }

            public TextAttributesKey getTextAttributesKey() {
                try {
                    if (psiClass.isDeprecated()) {
                        return CodeInsightColors.DEPRECATED_ATTRIBUTES;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                return null;
            }

            @Override
            public Icon getIcon(boolean open) {
                return psiClass.getIcon(3);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/psi/presentation/java/ClassPresentationProvider", "getPresentation"));
    }
}

