/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.caches;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.caches.StubsForCollectionClass;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0014\u001a\u00020\u0011J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00122\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer;", "", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "preComputedStubs", "", "Lorg/jetbrains/kotlin/backend/jvm/caches/StubsForCollectionClass;", "getPreComputedStubs", "()Ljava/util/Collection;", "preComputedStubs$delegate", "Lkotlin/Lazy;", "stubsCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "", "stubsForCollectionClasses", "irClass", "computeStubsForCollectionClasses", "LazyStubsForCollectionClass", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nCollectionStubComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionStubComputer.kt\norg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n72#2,2:106\n1#3:108\n774#4:109\n865#4,2:110\n774#4:112\n865#4:113\n2632#4,3:114\n866#4:117\n*S KotlinDebug\n*F\n+ 1 CollectionStubComputer.kt\norg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer\n*L\n85#1:106,2\n85#1:108\n91#1:109\n91#1:110,2\n94#1:112\n94#1:113\n95#1:114,3\n94#1:117\n*E\n"})
public final class CollectionStubComputer {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Lazy preComputedStubs$delegate;
    @NotNull
    private final ConcurrentHashMap<IrClass, List<StubsForCollectionClass>> stubsCache;

    public CollectionStubComputer(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.preComputedStubs$delegate = LazyKt.lazy(() -> CollectionStubComputer.preComputedStubs_delegate$lambda$1(this));
        this.stubsCache = new ConcurrentHashMap();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final Collection<StubsForCollectionClass> getPreComputedStubs() {
        Lazy lazy = this.preComputedStubs$delegate;
        return (Collection)lazy.getValue();
    }

    @NotNull
    public final List<StubsForCollectionClass> stubsForCollectionClasses(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        ConcurrentMap $this$getOrPut$iv = this.stubsCache;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(irClass);
        if (object == null) {
            boolean bl = false;
            List<StubsForCollectionClass> default$iv = this.computeStubsForCollectionClasses(irClass);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(irClass, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, "getOrPut(...)");
        return (List)object;
    }

    private final List<StubsForCollectionClass> computeStubsForCollectionClasses(IrClass irClass) {
        StubsForCollectionClass it;
        Iterable $this$filterTo$iv$iv;
        if (IrUtilsKt.isFromJava(irClass)) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = this.getPreComputedStubs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StubsForCollectionClass)element$iv$iv;
            boolean bl = false;
            if (!(IrTypeUtilsKt.isStrictSubtypeOfClass(irClass.getSymbol(), it.getReadOnlyClass()) && !IrTypeUtilsKt.isSubtypeOfClass(irClass.getSymbol(), it.getMutableClass()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List stubs = (List)destination$iv$iv;
        $this$filter$iv = stubs;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block6: {
                it = (StubsForCollectionClass)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = stubs;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        StubsForCollectionClass other = (StubsForCollectionClass)element$iv;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual(it.getReadOnlyClass(), other.getReadOnlyClass()) && IrTypeUtilsKt.isSubtypeOfClass(other.getReadOnlyClass(), it.getReadOnlyClass()))) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final List preComputedStubs_delegate$lambda$1(CollectionStubComputer this$0) {
        JvmSymbols $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240 = this$0.context.getIr().getSymbols();
        boolean bl = false;
        LazyStubsForCollectionClass[] lazyStubsForCollectionClassArray = new LazyStubsForCollectionClass[]{new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getCollection(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableCollection()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getSet(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableSet()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getList(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableList()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMap(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableMap()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMapEntry(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableMapEntry()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getIterable(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableIterable()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getIterator(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableIterator()), new LazyStubsForCollectionClass($this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getListIterator(), $this$preComputedStubs_delegate_u24lambda_u241_u24lambda_u240.getMutableListIterator())};
        return CollectionsKt.listOf(lazyStubsForCollectionClassArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer$LazyStubsForCollectionClass;", "Lorg/jetbrains/kotlin/backend/jvm/caches/StubsForCollectionClass;", "readOnlyClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "mutableClass", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;)V", "getReadOnlyClass", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getMutableClass", "candidatesForStubs", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getCandidatesForStubs", "()Ljava/util/Collection;", "candidatesForStubs$delegate", "Lkotlin/Lazy;", "backend.jvm"})
    @SourceDebugExtension(value={"SMAP\nCollectionStubComputer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionStubComputer.kt\norg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer$LazyStubsForCollectionClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n2632#2,3:106\n*S KotlinDebug\n*F\n+ 1 CollectionStubComputer.kt\norg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer$LazyStubsForCollectionClass\n*L\n59#1:106,3\n*E\n"})
    private static final class LazyStubsForCollectionClass
    implements StubsForCollectionClass {
        @NotNull
        private final IrClassSymbol readOnlyClass;
        @NotNull
        private final IrClassSymbol mutableClass;
        @NotNull
        private final Lazy candidatesForStubs$delegate;

        public LazyStubsForCollectionClass(@NotNull IrClassSymbol readOnlyClass, @NotNull IrClassSymbol mutableClass) {
            Intrinsics.checkNotNullParameter(readOnlyClass, "readOnlyClass");
            Intrinsics.checkNotNullParameter(mutableClass, "mutableClass");
            this.readOnlyClass = readOnlyClass;
            this.mutableClass = mutableClass;
            this.candidatesForStubs$delegate = LazyKt.lazy(() -> LazyStubsForCollectionClass.candidatesForStubs_delegate$lambda$2(this));
        }

        @Override
        @NotNull
        public IrClassSymbol getReadOnlyClass() {
            return this.readOnlyClass;
        }

        @Override
        @NotNull
        public IrClassSymbol getMutableClass() {
            return this.mutableClass;
        }

        @Override
        @NotNull
        public Collection<IrSimpleFunction> getCandidatesForStubs() {
            Lazy lazy = this.candidatesForStubs$delegate;
            return (Collection)lazy.getValue();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean candidatesForStubs_delegate$lambda$2$lambda$1(LazyStubsForCollectionClass this$0, IrSimpleFunction memberFun) {
            IrSimpleFunctionSymbol overriddenFun;
            Intrinsics.checkNotNullParameter(memberFun, "memberFun");
            if (!memberFun.isFakeOverride()) return true;
            if (memberFun.getModality() != Modality.ABSTRACT) return false;
            Iterable $this$none$iv = memberFun.getOverriddenSymbols();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$none$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                overriddenFun = (IrSimpleFunctionSymbol)element$iv;
                boolean bl = false;
            } while (!Intrinsics.areEqual(IrUtilsKt.getParentAsClass((IrDeclaration)overriddenFun.getOwner()).getSymbol(), this$0.getReadOnlyClass()));
            return false;
        }

        private static final List candidatesForStubs_delegate$lambda$2(LazyStubsForCollectionClass this$0) {
            return SequencesKt.toList(SequencesKt.filter(IrUtilsKt.getFunctions((IrClass)this$0.getMutableClass().getOwner()), arg_0 -> LazyStubsForCollectionClass.candidatesForStubs_delegate$lambda$2$lambda$1(this$0, arg_0)));
        }
    }
}

