/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInventNamesForLocalClasses;
import org.jetbrains.kotlin.backend.jvm.lower.JvmInventNamesForLocalClassesImpl;
import org.jetbrains.kotlin.backend.jvm.lower.RemoveDuplicatedInlinedLocalClassesLowering;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="InventNamesForInlinedLocalClasses", description="Invent names for INLINED local classes and anonymous objects", prerequisite={JvmInventNamesForLocalClasses.class, RemoveDuplicatedInlinedLocalClassesLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForInlinedAnonymousObjects;", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmInventNamesForLocalClassesImpl;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "putLocalClassName", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "localClassName", "", "backend.jvm.lower"})
public final class JvmInventNamesForInlinedAnonymousObjects
extends JvmInventNamesForLocalClassesImpl {
    public JvmInventNamesForInlinedAnonymousObjects(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        super(context, true);
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        if (this.getContext().getConfig().getEnableIrInliner()) {
            super.lower(irFile);
        }
    }

    @Override
    protected void putLocalClassName(@NotNull IrAttributeContainer declaration, @NotNull String localClassName) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(localClassName, "localClassName");
        if (declaration.getOriginalBeforeInline() == null) {
            return;
        }
        JvmIrAttributesKt.setLocalClassType(declaration, Type.getObjectType(localClassName));
    }
}

