/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaDanglingFileModuleImpl;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.ExtensionFileContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "<init>", "()V", "getNotUnderContentRootModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule;", "project", "Lcom/intellij/openapi/project/Project;", "computeSpecialModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "file", "Lcom/intellij/psi/PsiFile;", "computeDefaultDanglingFileResolutionMode", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "Lorg/jetbrains/kotlin/psi/KtFile;", "computeContextModule", "analysis-api-platform-interface"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectStructureProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectStructureProviderBase.kt\norg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public abstract class KotlinProjectStructureProviderBase
implements KotlinProjectStructureProvider {
    @NotNull
    protected abstract KaNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KaModule computeSpecialModule(@NotNull PsiFile file) {
        KaModule contextModule;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && (contextModule = ExtensionFileContextModuleKt.getAnalysisExtensionFileContextModule(virtualFile)) != null) {
            return contextModule;
        }
        if (file instanceof KtFile && DanglingFilesKt.isDangling((KtFile)file)) {
            contextModule = this.computeContextModule((KtFile)file);
            KaDanglingFileResolutionMode kaDanglingFileResolutionMode = DanglingFilesKt.getDanglingFileResolutionMode((KtFile)file);
            if (kaDanglingFileResolutionMode == null) {
                kaDanglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file);
            }
            KaDanglingFileResolutionMode resolutionMode = kaDanglingFileResolutionMode;
            return new KaDanglingFileModuleImpl((KtFile)file, contextModule, resolutionMode);
        }
        return null;
    }

    private final KaDanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file) {
        if (!(file.isPhysical() || file.getViewProvider().isEventSystemEnabled() || Intrinsics.areEqual((Object)file.getOriginalFile(), (Object)file))) {
            return KaDanglingFileResolutionMode.IGNORE_SELF;
        }
        return KaDanglingFileResolutionMode.PREFER_SELF;
    }

    private final KaModule computeContextModule(KtFile file) {
        PsiElement contextElement;
        PsiElement psiElement = file.getContext();
        if (psiElement == null && (psiElement = KtPsiFactoryKt.getAnalysisContext((KtFile)file)) == null) {
            PsiFile psiFile;
            PsiFile it = psiFile = file.getOriginalFile();
            boolean bl = false;
            psiElement = (PsiElement)(it != file ? psiFile : null);
        }
        if ((contextElement = psiElement) != null) {
            return this.getModule(contextElement, null);
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }
}

